// Copyright (C) 2000-2001 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "ivrconfig.h"
#include <cc++/strchar.h>

#define	BAYONNE_VERSION	VERSION
#define	BAYONNE_SERVER	PACKAGE

#include "bayonne.h"

#ifdef CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif

extern	bool upflag;

#ifdef	USER_HOSTING
extern	Keydata keyusers;
#endif

unsigned funid(char *sym)
{
	unsigned id = 0;

	while(*sym)
		id = (id << 1) ^ (*(sym++) & 0x1f);

	return id % KEYWORD_INDEX_SIZE;
}

aaScript::aaScript() :
ScriptCommand()
{
	// define primary Bayonne dialect
	static Script::Define interp[] = {
		{"cleardigits", (Method)&Trunk::scrCleardigits, 
			&ScriptCommand::chkIgnore},
		{"assign", (Method)&Trunk::scrAssign, 
			&ScriptCommand::chkIgnore},
#ifdef	XML_SCRIPTS
		{"load", (Method)&Trunk::scrLoad, 
			&ScriptCommand::chkHasArgs},
#endif
		{"hangup", (Method)&Trunk::scrHangup, 
			&ScriptCommand::chkIgnore},
		{"audit", (Method)&Trunk::scrAudit, 
			&ScriptCommand::chkHasArgs},
		{"debug", (Method)&Trunk::scrDebug, 
			&ScriptCommand::chkHasArgs},
		{"sleep", (Method)&Trunk::scrSleep,
			&ScriptCommand::chkHasArgs},
		{"sync", (Method)&Trunk::scrSync, 
			&ScriptCommand::chkIgnore},
		{"accept", (Method)&Trunk::scrAccept, 
			&ScriptCommand::chkIgnore},
		{"reject", (Method)&Trunk::scrReject,
			&ScriptCommand::chkIgnore},
		{"answer", (Method)&Trunk::scrAnswer, 
			&ScriptCommand::chkIgnore},
		{"collect", (Method)&Trunk::scrCollect, 
			&ScriptCommand::chkHasArgs},
		{"flash", (Method)&Trunk::scrFlash, 
			&ScriptCommand::chkIgnore},
		{"altplay", (Method)&Trunk::scrAltPlay,
			&ScriptCommand::chkHasArgs},
		{"play", (Method)&Trunk::scrPlay, 
			&ScriptCommand::chkHasArgs},
		{"say", (Method)&Trunk::scrSay, 
			&ScriptCommand::chkHasArgs},
		{"record", (Method)&Trunk::scrRecord, 
			&ScriptCommand::chkHasArgs},	
		{"options", (Method)&Trunk::scrOptions,
			&ScriptCommand::chkIgnore},
		{"erase", (Method)&Trunk::scrErase,
			&ScriptCommand::chkHasArgs},
#ifdef	HAVE_TGI
		{"copy", (Method)&Trunk::scrCopy,
			&ScriptCommand::chkHasArgs},
#endif
		{"move", (Method)&Trunk::scrMove,
			&ScriptCommand::chkHasArgs},
		{"tone", (Method)&Trunk::scrTone,
			&ScriptCommand::chkHasArgs},
		{"dial", (Method)&Trunk::scrDial, 
			&ScriptCommand::chkHasArgs},
		{"transfer", (Method)&Trunk::scrTransfer, 
			&ScriptCommand::chkHasArgs},
		{"hold", (Method)&Trunk::scrHold, 
			&ScriptCommand::chkNoArgs},
#ifdef	HAVE_TGI
		{"libexec", (Method)&Trunk::scrLibexec, 
			&ScriptCommand::chkHasArgs},
#endif
		{"altspeak", (Method)&Trunk::scrAltSpeak,
			&ScriptCommand::chkHasArgs},
		{"speak", (Method)&Trunk::scrSpeak, 
			&ScriptCommand::chkHasArgs},
		{"schedule", (Method)&Trunk::scrSchedule, 
			&ScriptCommand::chkHasArgs},
		{"start", (Method)&Trunk::scrStart, 
			&ScriptCommand::chkHasArgs},
		{"signal", (Method)&Trunk::scrSignal, 
			&ScriptCommand::chkHasArgs},
		{"busy", (Method)&Trunk::scrBusy,
			&ScriptCommand::chkIgnore},
		{"idle", (Method)&Trunk::scrIdle, 
			&ScriptCommand::chkIgnore},
		{"send", (Method)&Trunk::scrSend, 
			&ScriptCommand::chkHasArgs},
		{"config", (Method)&Trunk::scrConfig, 
			&ScriptCommand::chkIgnore},
		{"policy", (Method)&Trunk::scrPolicy, 
			&ScriptCommand::chkIgnore},
		{"slog", (Method)&Trunk::scrSlog,
			&ScriptCommand::chkIgnore},
		{"examine", (Method)&Trunk::scrExamine,
			&ScriptCommand::chkHasArgs},
		{"service", (Method)&Trunk::scrService,
			&ScriptCommand::chkNoArgs},
		{"login", (Method)&Trunk::scrLogin,
			&ScriptCommand::chkIgnore},
		{"logout", (Method)&Trunk::scrService,
			&ScriptCommand::chkNoArgs},
		{"password", (Method)&Trunk::scrPassword,
			&ScriptCommand::chkIgnore},
		{"change", (Method)&Trunk::scrChange,
			&ScriptCommand::chkIgnore},
		{"reset", (Method)&Trunk::scrChange,
			&ScriptCommand::chkIgnore},
		{"saveinfo", (Method)&Trunk::scrCommit,
			&ScriptCommand::chkNoArgs},
		{"userinfo", (Method)&Trunk::scrUserinfo,
			&ScriptCommand::chkIgnore},
                {"huntinfo", (Method)&Trunk::scrHuntinfo,
                        &ScriptCommand::chkIgnore},
		{"statinfo", (Method)&Trunk::scrStatinfo,
			&ScriptCommand::chkIgnore},
		{"control", (Method)&Trunk::scrControl,
			&ScriptCommand::chkHasArgs},
		{"redirect", (Method)&Trunk::scrRedirect,
			&ScriptCommand::chkHasArgs},
		{"sendfax", (Method)&Trunk::scrSendFax,
			&ScriptCommand::chkHasArgs},
		{"recvfax", (Method)&Trunk::scrRecvFax,
			&ScriptCommand::chkHasArgs},
		{NULL, NULL, NULL}};

	// set standard aascript trap identifiers

#ifdef	SCRIPT_TRAP_MASKED
	trap("timeout", false);
#else
	trap("timeout");
#endif
	trap("dtmf");

	trap("0");	/* 0x10 */
	trap("1");
	trap("2");
	trap("3");

	trap("4");	/* 0x100 */
	trap("5");
	trap("6");
	trap("7");

	trap("8");	/* 0x1000 */
	trap("9");
	trap("star");
	trap("pound");
	
	trap("a");	/* 0x10000 */
	trap("b");
	trap("c");
	trap("d");

#ifdef	SCRIPT_TRAP_MASKED
	trap("silence", false);
	trap("busy", false);
	trap("cancel", false);
	trap("signal", false);
#else
	trap("silence");
	trap("busy");
	trap("cancel");
	trap("signal");
#endif

	trap("noanswer");
	trap("ring");
	trap("tone");
	trap("event");

	trap("time");
	trap("child");

	load(interp);
}

int aaScript::mapicmp(const char *s1, const char *s2)
{
	for(;;)
	{
		if(!*s1 || !*s2)
			return *s2 - *s1;
		if(tolower(*s1) != tolower(*s2))
			if(*s1 != '?' && *s2 != '?')
				return tolower(*s2) - tolower(*s1);
		++s1;
		++s2;
	}
}

int aaScript::mapnicmp(const char *s1, const char *s2, size_t n)
{
        while(n--)
        {
                if(!*s1 || !*s2)
                        return *s2 - *s1;
                if(tolower(*s1) != tolower(*s2))
                        if(*s1 != '?' && *s2 != '?')
                                return tolower(*s2) - tolower(*s1);
                ++s1;
                ++s2;
        }
	return 0;
}	
	
void aaScript::addModule(Module *module, const char *alias)
{
	char *name = module->getName();
	Script::Define keywords[2];
	char namebuf[65];
	
	if(!name)
		return;

	if(alias)
	{
		snprintf(namebuf, sizeof(namebuf), "%s-%s", alias, name);
		name = namebuf;
	}
	name = alloc(name);

	module->prior = getHandler(name);
	keywords[0].keyword = name;
	keywords[0].method = (Method)&Trunk::scrModule;
	keywords[0].check = &ScriptCommand::chkHasArgs;
	keywords[1].keyword = NULL;
	keywords[1].method = (Method)NULL;
	keywords[1].check = (Check)NULL;
	load(keywords);
}

void aaScript::addDummy(const char *name)
{
	Script::Define keywords[2];

	keywords[0].keyword = name;
	keywords[0].method = (Method)&Trunk::scrDummy;
	keywords[0].check = &ScriptCommand::chkIgnore;
	keywords[1].keyword = NULL;
	keywords[1].method = (Method)NULL;
	keywords[1].check = (Check)NULL;
	load(keywords);
}
	
unsigned long aaScript::getTrapMask(const char *trapname)
{
	unsigned long mask;

	if(!stricmp(trapname, "hangup"))
		return 0x00000001;

	if(!strcmp(trapname, "!"))
		return 0x0000fff8;

	if(!stricmp(trapname, "override"))
		return 0x00010000;

	if(!stricmp(trapname, "flash"))
		return 0x00020000;

	if(!stricmp(trapname, "immediate"))
		return 0x00040000;

	if(!stricmp(trapname, "priority"))
		return 0x00080000;

	if(!stricmp(trapname, "part"))
		return 0x00400000;

	if(!stricmp(trapname, "fail"))
		return 0x00400000;

	if(!stricmp(trapname, "invalid"))
		return 0x00400000;

	if(!stricmp(trapname, "nodialtone"))
		return 0x01000000;

	if(!stricmp(trapname, "noringback"))
		return 0x01000000;

	if(!stricmp(trapname, "busytone"))
		return 0x00200000;

	if(!stricmp(trapname, "maxtime"))
		return 0x10000000;

	if(!stricmp(trapname, "answer"))
		return 0x02000000;

	if(!stricmp(trapname, "pickup"))
		return 0x02000000;

	mask = ScriptCommand::getTrapMask(trapname);
	if(mask == 0x00000008)
		return 0x0000fff8;

	if(mask & 0x0000fff0)
		mask |= 0x00000008;

	return mask;
}

aaImage::aaImage(aaScript *script) :
ScriptImage((ScriptCommand *)script, "/bayonne/script")
{
	char path[1024];
	char *users[128];
	char **user = users;
	char username[128];
	const char *alt = keypaths.getLast("altscripts");

	if(alt)
	{
		if(canAccess(alt))
		{
			strcpy(path, alt);
			scanDir1(path);
			scanDir2(path);
		}
	}

	strcpy(path, keypaths.getScriptFiles());
	if(canAccess(path))
	{
		scanDir1(path);
		scanDir2(path);
	}

	strcpy(path, keyserver.getPrefix());
	strcat(path, "/aascripts");
	if(isDir(path))
		if(canAccess(path))
		{
			scanDir1(path);
			scanDir2(path);
		}

#ifdef	USER_HOSTING
	keyusers.getIndex(users, 127);

	while(*user)
	{
		snprintf(username, sizeof(username), "~%s", *user);
		snprintf(path, sizeof(path), "%s/bayonnerc", 
			keyusers.getLast(*user));
		if(canAccess(path))
			compile(path, username);
		++user;
	}
#endif

       static Keydata::Define keys[] = {
                {"timeout", "60"},
                {"interdigit", "6"},
                {"extdigits", "4"},
                {"localdigits", "7"},
                {"natdigits", "10"},
                {"xferextension", "FW"},
                {"dialextension", "W"},
                {"diallocal", "W9"},
                {"xferlocal", "FW9"},
                {"dialnational", "W81"},
                {"xfernational", "FW81"},
                {"dialinternational", "W8011"},
                {"xferinternational", "FW8011"},
                {"localprefix", "732"},
                {"dialoperator", "0"},
                {"fastpickup", "2"},
                {"slowpickup", "5"},
                {"country", "1"},
                {"ringtime", "6"},
                {"language", "english"},
                {"extension", ".au"},
                {"voice", "UsEngM"},
                {NULL, NULL}};

        Keydata::load("~bayonne/script");
        setValue("node", keyserver.getNode());
        setValue("version", BAYONNE_VERSION);
        setValue("server", BAYONNE_SERVER);
        setValue("driver", plugins.getDriverName());

	if(tts)
		setValue("tts", tts->getName());
	else
		setValue("tts", "none");

        Keydata::load(keys);

	commit();
};

bool aaImage::preProcess(const char *directive, Name *script)
{
// cmds
	char rule[512];
	char tagbuf[128];
	char *tok, *tag;
	Translator *tts;
	size_t size;
	ScriptSymbol *globals;
	Symbol *sym;
	TrunkGroup *grp = getGroup(NULL);

	if(!stricmp(directive, ".mod") || !stricmp(directive, ".module"))
	{
		while(NULL != (tok = getToken()))
		{
			if(!getModule(MODULE_ANY, tok))
			{
				snprintf(rule, sizeof(rule), "%s/%s.mod",
					keypaths.getLast("modlibpath"), tok);
				try
				{
					new DSO(rule);
				}
				catch(DSO *dso)
				{
					slog(Slog::levelError) << "load: " << rule << " failed." << endl;
					return true;
				}
			}
		}
		return true;
	}

#ifdef	XML_SCRIPTS
        if(!stricmp(directive, ".xml"))
        {
                while(NULL != (tok = getToken()))
                {
                        if(!getModule(MODULE_XML, tok))
                        {
                                snprintf(rule, sizeof(rule), "%s/%s.xml",
                                        keypaths.getLast("modlibpath"), tok);
                                try
                                {
                                        new DSO(rule);
                                }
                                catch(DSO *dso)
                                {
                                        slog(Slog::levelError) << "load: " << rule << " failed." << endl;
                                        return true;
                                }
                        }
                }
                return true;
        }
#else
	if(!stricmp(directive, ".xml"))
		return true;
#endif

	if(!stricmp(directive, ".rpc"))
	{
		while(NULL != (tok = getToken()))
		{
			snprintf(rule, sizeof(rule), "rpc::%s", tok);
			keyserver.setValue(rule, script->name);
		}
		return true;
	}

	if(!stricmp(directive, ".import"))
	{
		if(!Module::modImport)
			return true;

		while(NULL != (tok = getToken()))
			Module::modImport->import(tok);

		return true;
	}

	if(!stricmp(directive, ".clear"))
	{
		while(NULL != (tok = getToken()))
		{
			tag = (char *)grp->getLast(tok);
			if(!tag)
				tag = "";

			if(!stricmp(tag, "*"))
				continue;

			grp->setValue(tok, "*");
		}
	}			

	if(!strnicmp(directive, ".line", 5))
	{
		directive += 5;
		if(*directive == '.')
			++directive;

		if(*directive)
			size = atoi(directive);
		else
			size = 64;

		directive = getToken();
		if(!directive)
			return true;

		if(!stricmp(directive, "dialgroup"))
			return true;

		globals = Trunk::getGlobals();
		snprintf(tagbuf, sizeof(tagbuf), "line.default.%s", directive);
		globals->setConst("line.default.id", "default");
		sym = globals->getEntry(tagbuf, size);
		if(!sym)
			return true;

		tok = getToken();
		if(!tok)
			tok = "";
	
		snprintf(sym->data, sym->flags.size + 1, "%s", tok);
		sym->flags.readonly = true;
		sym->flags.initial = false;
		return true;
	} 

       	if(!strnicmp(directive, ".hunt", 5))
       	{
                directive += 5;
                if(*directive == '.')
                        ++directive;

                if(*directive)
                        size = atoi(directive);
                else
                        size = 64;

                directive = getToken();
                if(!directive)
                        return true;

                globals = Trunk::getGlobals();
                snprintf(tagbuf, sizeof(tagbuf), "hunt.default.%s", directive);
                globals->setConst("hunt.default.id", "default");
                sym = globals->getEntry(tagbuf, size);
                if(!sym)
                        return true;

                tok = getToken();
                if(!tok)
                        tok = "";

                snprintf(sym->data, sym->flags.size + 1, "%s", tok);
                sym->flags.readonly = true;
                sym->flags.initial = false;
                return true;
        }

	if(!strnicmp(directive, ".default", 8))
	{
		directive += 8;
		if(*directive == '.')
			++directive;
		if(*directive)
			size = atoi(directive);
		else
			size = 64;

		directive = getToken();
		if(!directive)
			return true;

		if(!stricmp(directive, "ringgroup"))
			return true;
	
		globals = Trunk::getGlobals();
		snprintf(tagbuf, sizeof(tagbuf), "default.%s", directive);
		sym = globals->getEntry(tagbuf, size);
		if(!sym)
			return true;
		
		tok = getToken();
		if(!tok)
			tok = "";

		snprintf(sym->data, sym->flags.size + 1, "%s", tok);
		sym->flags.readonly = true;
		sym->flags.initial = false;
		return true;
	}		 

	if(!stricmp(directive, ".languages"))
	{
		while(NULL != (tok = getToken()))
		{
			tts = getTranslator(tok);
			if(!tts)
				plugins.loadTranslators(tok);
		}
		return true;
	}

	if(!stricmp(directive, ".prefix") || !stricmp(directive, ".dir"))
	{
		while(NULL != (tok = getToken()))
			mkdir(tok, 0770);
		return true;
	}		

	if(!stricmp(directive, ".rule") || !stricmp(directive, ".phrase"))
		directive = "all";
	else
	{	
		tts = getTranslator(directive + 1);
		if(!tts)
			return false;	
		++directive;
	}

	rule[0] = 0;
	tag = getToken();
	if(!tag)
		return false;

	snprintf(tagbuf, sizeof(tagbuf), "_%s_%s", directive, tag);

	while(NULL != (tok = getToken()))
	{
		if(rule[0])
			strcat(rule, " ");
		strcat(rule, tok);
	}
	if(!rule[0])
		return false;

	setValue(tagbuf, rule);
	return true;
}

void aaImage::scanDir1(char *path)
{
	char *scrname;
	char *pp = path + strlen(path);
	Dir dir(path);

	*(pp++) = '/';
	for(;;)
	{
		scrname = (char *)dir.getName();
		if(!scrname)
			break;
		if(!isScript(scrname))
			continue;

		strcpy(pp, scrname);
		compile(path);
	}
	*(--pp) = 0;
}

void aaImage::scanDir2(char *path)
{
        char *scrname, *ext;
        char *pp = path + strlen(path);
        Dir dir(path);

        *(pp++) = '/';
        for(;;)
        {
                scrname = (char *)dir.getName();
                if(!scrname)
                        break;


		ext = strrchr(scrname, '.');
		if(!ext)
			continue;

		if(stricmp(ext, ".scr"))
			continue;

		if(!stricmp(scrname, "up.scr"))
			upflag = true;

                strcpy(pp, scrname);

		*ext = 0;
		if(getScript(scrname))
			continue;

                compile(path);
        }
	*(--pp) = 0;
}

bool aaImage::isScript(char *scrname)
{
	char modbuf[32];
	char sw[5];
	Module *mod = Module::modFirst;
	const char *mext;
	char *ext = strrchr(scrname, '.');
	if(!ext)
		return false;

	snprintf(sw, 5, ".sc%d", driver->getExtNumbering());

	// handle in pass 2
	if(!stricmp(ext, ".scr"))
		return false;

	if(!stricmp(ext, ".tts") && tts)
		return true;

	// pbx switch scripts by dialing plan
	if(!stricmp(ext, sw))
		return true;

	if(driver->getExtNumbering())
		if(!stricmp(ext, ".scx"))
			return true;

	if(!stricmp(ext, ".mod"))
	{
		strncpy(modbuf, scrname, 31);
		modbuf[31] = 0;
		ext = strchr(modbuf, '.');
		if(!ext)
			return false;

		*ext = 0;
		if(getModule(MODULE_ANY, modbuf))
			return true;
		return false;
	}

	while(mod)
	{
		mext = mod->getExtension();
		if(mext)
			if(!stricmp(ext, mext))
				return true;
		mod = mod->modNext;
	}
	return false;
}

#ifdef	CCXX_NAMESPACES
};
#endif
