// Copyright (C) 2005 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "module.h"
#include <cc++/process.h>

namespace module {
using namespace ost;
using namespace std;

#ifdef  WIN32
#define KEYS    "/bayonne/tcpmon"
#else
#define KEYS    "/bayonne/module/tcpmon"
#endif

Service Service::tcp;
bool Service::active = false;

Service::Service() :
BayonneService(0, 0), Keydata(Bayonne::getKeypath(KEYS))
{
	static Keydata::Define defkeys[] = {
	{"interface", "127.0.0.1:5555"},
	{"gateway", "127.0.0.1:5556"},
	{"secret", "pass"},
	{NULL, NULL}};

	load(defkeys);

#ifdef  WIN32
        const char *env = Process::getEnv("MODULECONFIG");

        if(env)
                loadFile(env, "tcpmon");
#else
	if(Bayonne::provision_system)
		load("/bayonne/provision/tcpmon");
	else if(Bayonne::provision_user)
	        load("~bayonne/tcpmon");
#endif

}

void Service::stopService(void)
{
	active = false;
	terminate();
}

void Service::run(void)
{
	tpport_t port;
	Session *session;
	char *abuf;
	char *pnum;

	if(Bayonne::provision_gateway)
		abuf = (char *)getLast("gateway");
	else
		abuf = (char *)getLast("interface");

	pnum = strrchr(abuf, ':');
	if(pnum)
		*(pnum++) = 0;
	else
		pnum = "5555";

	port = atoi(pnum);
	InetAddress addr(abuf);
	TCPSocket tcp(addr, port);

	active = true;
	slog.debug("tcpmon service started");

	for(;;)
	{
                if(tcp.isPendingConnection(30))
                {
                        session = new Session(tcp);
                        session->detach();
                }
		Thread::yield();
	}

	Thread::sync();
}

} // namespace 
