/* translation of file "petrinet-patterns-shortcuts.k" */
/* generated by:
 *  @(#)$Author: Kimwitu++ version 2.3.11 (C) 1998-2007 Humboldt-University of Berlin $
 */
#define KC_FUNCTIONS_petrinet_patterns_shortcuts

#include <stdlib.h>
#include "ast-system-k.h"
#include "petrinet-patterns-shortcuts.h"
namespace kc { }
using namespace kc;
/* included stuff */
#line 27 "petrinet-patterns-shortcuts.k"
/*!
 * \file    petrinet-patterns-shortcuts.cc
 *
 * \brief   Petri net patterns for shortcuts
 *
 * \author  Niels Lohmann <nlohmann@informatik.hu-berlin.de>,
 *          Christian Gierds <gierds@informatik.hu-berlin.de>,
 *          Martin Znamirowski <znamirow@informatik.hu-berlin.de>,
 *          last changes of: \$Author: znamirow $
 * 
 * \since   2007-03-06
 *
 * \date    \$Date: 2007/07/13 12:50:47 $
 * 
 * \note    This file is part of the tool BPEL2oWFN and was created during the
 *          project "Tools4BPEL" at the Humboldt-Universitt zu Berlin. See
 *          http://www.informatik.hu-berlin.de/top/tools4bpel for details.
 *
 * \note    This file was created using Kimwitu++ reading file
 *          petrinet-patterns-shortcuts.k.
 *          See http://site.informatik.hu-berlin.de/kimwitu++ for details.
 *
 * \version \$Revision: 1.30 $
*/

#line  40 "petrinet-patterns-shortcuts.cc"
#line 70 "petrinet-patterns-shortcuts.k"
#include <iostream>
#include <cmath>

#include "ast-details.h"
#include "globals.h"
#include "petrinet.h"

extern PetriNet PN;

#line  51 "petrinet-patterns-shortcuts.cc"
#line 85 "petrinet-patterns-shortcuts.k"
/*!
 * \fn      Transition *kc::throwFault(Place *p1, Place *p2, string p1name, string prefix, integer id, int negativeControlFlow, bool preventFurtherFaults = true)
 *
 * \brief   generates transition and places to throw a fault
 *
 *          This functions generates a subnet to model the throwing of a fault.
 *          It models faults in any control flow of the BPEL process as well as
 *          in any patterns used.
 *
 * \param   p1  the place in positive control flow from which the control flow
 *              enters the negative control flow
 *
 * \param   p2  the place of the pattern on which a token shall be produced which
 *              can only be removed by stopping the pattern
 *
 * \param   p1name  name of place p1 which is used to label the generated
 *                  transitions (e.g. if p1 is called "running" generated
 *                  transitions end with this name (e.g. "throwFault.running")
 *
 * \param   prefix  prefix of the pattern to label generated places and
 *                  transitions
 *
 * \param   id  identifier of the caller activity
 *
 * \param   negativeControlFlow  signals where the activity is located:
 *                                - 0: inside a scope or the process
 *                                - 1: inside a fault handler
 *                                - 2: inside a compensation handler
 *
 * \param   preventFurtherFaults  controls what happens to further faults
 *                                 - true: these faults are prevented (standard)
 *                                 - false: these faults are suppressed
 *
 * \return  a pointer to the (first) generated fault transition
 *
 * \ingroup patterns
*/

#line  91 "petrinet-patterns-shortcuts.cc"
#line 238 "petrinet-patterns-shortcuts.k"
/*!
 * \fn      Transition *kc::stop(Place *p, string p_name, string prefix)
 *
 * \brief   generates a subnet to stop
 *
 *          Generates a transition and places to stop the activity, i.e. a
 *          transition moving a token on the "stop" place to "stopped".
 *
 * \param   p  the place in control flow from which the token is move to
 *             "stop"
 *
 * \param   p_name  name of place p which is used to label the generated
 *                  transition (e.g. if p1 is called "running" generated
 *                  transition end with this name (e.g. "stop.running")
 *
 * \param   prefix  prefix of the pattern to label generated transition
 *
 * \return  a pointer to the stop transition
 *
 * \ingroup patterns
 */

#line  115 "petrinet-patterns-shortcuts.cc"
#line 280 "petrinet-patterns-shortcuts.k"
/*!
 * \fn      Transition *kc::stop_loop(Place *p, string p_name, string prefix)
 *
 * \brief   generates a subnet to stop
 *
 *          Generates a transition and places to stop the activity, i.e. a
 *          transition moving a token on the "stop" place to "stopped".
 *
 * \param   p  the place in control flow from which the token is move to
 *             "stop"
 *
 * \param   p_name  name of place p which is used to label the generated
 *                  transition (e.g. if p1 is called "running" generated
 *                  transition end with this name (e.g. "stop.running")
 *
 * \param   prefix  prefix of the pattern to label generated transition
 *
 * \return  a pointer to the stop transition
 *
 * \ingroup patterns
 */

#line  139 "petrinet-patterns-shortcuts.cc"
#line 323 "petrinet-patterns-shortcuts.k"
/*!
 * \fn      Transition *kc::stop_activity(Place *p, string p_name, string prefix)
 *
 * \brief   generates a subnet to stop
 *
 *          Generates a transition and places to stop the activity, i.e. a
 *          transition moving a token on the "stop" place to "stopped".
 *
 * \param   p  the place in control flow from which the token is move to
 *             "stop"
 *
 * \param   p_name  name of place p which is used to label the generated
 *                  transition (e.g. if p1 is called "running" generated
 *                  transition end with this name (e.g. "stop.running")
 *
 * \param   prefix  prefix of the pattern to label generated transition
 *
 * \return  a pointer to the stop transition
 *
 * \ingroup patterns
 */

#line  163 "petrinet-patterns-shortcuts.cc"
#line 367 "petrinet-patterns-shortcuts.k"
/*!
 * \fn      void kc::dpeLinks(Transition *t, int id)
 *
 * \brief   add a subnet for dead-path elimination
 *
 *          Creates arcs to set links on dead paths to false.
 *
 * \param   t          transition that invokes DPE
 * \param   id         the identifier of the AST node
 * \param   parent_id  the id of the parent <pick> or <if> (default 0)
 *
 * \ingroup patterns
 */

#line  179 "petrinet-patterns-shortcuts.cc"
#line 453 "petrinet-patterns-shortcuts.k"
/*!
 * \brief Adds a pattern for a cyclic net with a cap of loops
 *
 * \param   condition   the condition for entering/leaving the loop
 * \param   maxloops    the cap for the number of cycles
 * \param   prefix      the prefix of the places and transitions
 * \param   id          the id of the callin activity
 * \param   enterPlace  the where the loop is entered (needed to connect correctly)
 * \param   loopPlace   the place that is marked if the condition was accepted (needed to connect correctly)
 * \param   exitPlace   the place to be marked when the loop is left (needed to connect correctly)
 *
 * \ingroup patterns
 */

#line  195 "petrinet-patterns-shortcuts.cc"
#line 578 "petrinet-patterns-shortcuts.k"
/*!
 * \brief Adds a receiving pattern
 *
 * \param   name        the name of the communication transition
 * \param   prePlace    the place before the pattern (needed to connect correctly)
 * \param   postPlace   the place after the pattern (needed to connect correctly)
 * \param   channel     the place acting as channel place
 * \param   faultPlace  the place of the pattern, where faults are stored
 * \param   prefix      the prefix of the places and transitions
 * \param   id          the id of the callin activity
 * \param   negativeControlFlow  signals where the activity is located:
 *                                - 0: inside a scope or the process
 *                                - 1: inside a fault handler
 *                                - 2: inside a compensation handler
 *
 * \param   preventFurtherFaults  controls what happens to further faults
 *                                 - true: these faults are prevented (standard)
 *                                 - false: these faults are suppressed
 *
 * \ingroup patterns
 */

#line  219 "petrinet-patterns-shortcuts.cc"
#line 659 "petrinet-patterns-shortcuts.k"
/*!
 * \brief Adds a sending pattern
 *
 * \param   name        the name of the communication transition
 * \param   prePlace    the place before the pattern (needed to connect correctly)
 * \param   postPlace   the place after the pattern (needed to connect correctly)
 * \param   channel     the place acting as channel place
 * \param   faultPlace  the place of the pattern, where faults are stored
 * \param   prefix      the prefix of the places and transitions
 * \param   id          the id of the callin activity
 * \param   negativeControlFlow  signals where the activity is located:
 *                                - 0: inside a scope or the process
 *                                - 1: inside a fault handler
 *                                - 2: inside a compensation handler
 *
 * \param   preventFurtherFaults  controls what happens to further faults
 *                                 - true: these faults are prevented (standard)
 *                                 - false: these faults are suppressed
 *
 * \ingroup patterns
 */

#line  243 "petrinet-patterns-shortcuts.cc"
#line 734 "petrinet-patterns-shortcuts.k"
/*!
 * \fn void kc::P_transitionCondition(string prefix, tSource_list source_links)
 *
 * \brief   Pattern to model the transition condition of an activity
 *
 * \param   prefix        the prefix of the activity's pattern
 * \param   source_links  the list of outgoing links of the activity
 *
 * \ingroup patterns
 *
 * \todo    Implement nondeterministic transition condition and add respective
 *          parameter.
 */

#line  259 "petrinet-patterns-shortcuts.cc"
#line 829 "petrinet-patterns-shortcuts.k"
/*!
 * \fn void kc::P_joinCondition(string prefix, tTarget_list target_links, joinCondition jc)
 *
 * \brief   Pattern to model the join condition of an activity
 *
 * \param   prefix        the prefix of the activity's pattern
 * \param   target_links  the list of incoming links of the activity
 * \param   jc            the join condition
 *
 * \ingroup patterns
 */

#line  273 "petrinet-patterns-shortcuts.cc"
/* end included stuff */


namespace kc {

#ifndef KC_TRACE_PROVIDED
#define KC_TRACE_PROVIDED(COND,FILE,LINE,NODE) COND
#endif

Transition *throwFault(Place *p1, Place *p2, string p1name, string prefix, integer id, int negativeControlFlow, bool preventFurtherFaults)
#line 126 "petrinet-patterns-shortcuts.k"
{
    assert(p1 != NULL);
    assert(p2 != NULL);



    if (globals::parameters[P_COMMUNICATIONONLY])
    return NULL;




    if (globals::ASTEmap[globals::ASTEmap[id->value]->parentScopeId]->attributes["exitOnStandardFault"] == "yes")
    {
	Transition *t1 = PN.newTransition(prefix + "exitOnStandardFault." + p1name);
	PN.newArc(p1, t1);
	PN.newArc(t1, p2);
	PN.newArc(t1, PN.findPlace("1.internal.exit"));

	return t1;
    }



    switch (negativeControlFlow)
    {
	case(0): 
	{
	    unsigned int parentId = globals::ASTEmap[id->value]->parentScopeId;

	    Transition *t1 = PN.newTransition(prefix + "throwFault." + p1name);
	    PN.newArc(p1, t1);
	    PN.newArc(t1, p2);
	    PN.newArc(t1, PN.findPlace(toString(parentId) + ".internal.fault_in"));

	    return t1;
	}

	case(1): 
	case(4): 
	{


	    unsigned int parentId = globals::ASTEmap[globals::ASTEmap[id->value]->parentScopeId]->parentScopeId;

	    Transition *t1;
	    if (negativeControlFlow == 4)
	    t1 = PN.newTransition(prefix + "rethrow");
	    else
	    t1 = PN.newTransition(prefix + "rethrowFault." + p1name);

	    PN.newArc(p1, t1);
	    PN.newArc(t1, p2);

	    if (globals::ASTEmap[id->value]->parentScopeId == 1)
	    {
		PN.newArc(t1, PN.findPlace(toString(parentId) + ".internal.exit"));
		PN.newArc(PN.findPlace(toString(parentId) + ".internal.!Exiting"), t1, READ);

		Transition *t2;
		if (negativeControlFlow == 4)
		t2 = PN.newTransition(prefix + "final_rethrow");
		else
		t2 = PN.newTransition(prefix + "final_rethrowFault." + p1name);

		PN.newArc(p1, t2);
		PN.newArc(t2, p2);

		PN.newArc(t2, PN.findPlace(toString(parentId) + ".internal.inner_stop"));
		PN.newArc(PN.findPlace(toString(parentId) + ".internal.Exiting"), t2, READ);
	    }
	    else
	    {
		PN.newArc(t1, PN.findPlace(toString(parentId) + ".internal.fault_in"));
	    }

	    return t1;
	}

	case(2): 
	{
	    unsigned int parentId = globals::ASTEmap[id->value]->parentScopeId;


	    assert(parentId != 1);

	    Transition *t1 = PN.newTransition(prefix + "throwCHFault." + p1name);
	    PN.newArc(p1, t1);
	    PN.newArc(t1, p2);
	    PN.newArc(t1, PN.findPlace(toString(parentId) + ".internal.ch_fault_in"));

	    return t1;
	}

	case(3): 
	{
	    unsigned int parentId = globals::ASTEmap[id->value]->parentScopeId;

	    Transition *t1 = PN.newTransition(prefix + "signalFault." + p1name);
	    PN.newArc(p1, t1);
	    PN.newArc(t1, p2);
	    PN.newArc(t1, PN.findPlace(toString(parentId) + ".terminationHandler.inner_fault"));
	}
    }
    return NULL;

#line 231 "petrinet-patterns-shortcuts.k"
}
#line  393 "petrinet-patterns-shortcuts.cc"

Transition *stop(Place *p, string p_name, string prefix)
#line 261 "petrinet-patterns-shortcuts.k"
{
    assert(p != NULL);


    if (globals::parameters[P_COMMUNICATIONONLY])
    return NULL;

    Transition *stopTransition = PN.newTransition(prefix + "stopped." + p_name);
    PN.newArc(PN.findPlace(prefix + "stop"), stopTransition);
    PN.newArc(stopTransition, PN.findPlace(prefix + "stopped"));
    PN.newArc(p, stopTransition);

    return stopTransition;

#line 274 "petrinet-patterns-shortcuts.k"
}
#line  413 "petrinet-patterns-shortcuts.cc"

Transition *stop_loop(Place *p, string p_name, string prefix)
#line 303 "petrinet-patterns-shortcuts.k"
{
    assert(p != NULL);


    if (globals::parameters[P_COMMUNICATIONONLY])
    return NULL;

    Transition *stopTransition = PN.newTransition(prefix + "stopped_loop." + p_name);
    PN.newArc(PN.findPlace(prefix + "stop_loop"), stopTransition);
    PN.newArc(stopTransition, PN.findPlace(prefix + "stopped_loop"));
    PN.newArc(p, stopTransition);

    return stopTransition;

#line 316 "petrinet-patterns-shortcuts.k"
}
#line  433 "petrinet-patterns-shortcuts.cc"

Transition *stop_activity(Place *p, string p_name, string prefix)
#line 346 "petrinet-patterns-shortcuts.k"
{
    assert(p != NULL);


    if (globals::parameters[P_COMMUNICATIONONLY])
    return NULL;

    Transition *stopTransition = PN.newTransition(prefix + "stopped." + p_name);
    PN.newArc(PN.findPlace(prefix + "stop_activity"), stopTransition);
    PN.newArc(stopTransition, PN.findPlace(prefix + "stopped_activity"));
    PN.newArc(p, stopTransition);

    return stopTransition;

#line 359 "petrinet-patterns-shortcuts.k"
}
#line  453 "petrinet-patterns-shortcuts.cc"

void dpeLinks(Transition *t, int id, int parent_id)
#line 382 "petrinet-patterns-shortcuts.k"
{
    ENTER("[ASTT]");

    assert(t != NULL);
    assert(globals::ASTEmap[id] != NULL);

    for (set<unsigned int>::iterator linkID = globals::ASTEmap[id]->enclosedSourceLinks.begin();
	linkID != globals::ASTEmap[id]->enclosedSourceLinks.end();
	linkID++)
    {
	assert(globals::ASTEmap[*linkID] != NULL);
	string linkName = globals::ASTEmap[*linkID]->linkName;
	PN.newArc(t, PN.findPlace("!link." + linkName));
    }




    if (parent_id != 0)
    {
	for (set<unsigned int>::iterator linkID = globals::ASTEmap[id]->enclosedTargetLinks.begin();
	    linkID != globals::ASTEmap[id]->enclosedTargetLinks.end();
	    linkID++)
	{
	    assert(globals::ASTEmap[*linkID] != NULL);
	    string linkName = globals::ASTEmap[*linkID]->linkName;

	    Place *p1 = PN.findPlace(toString(parent_id) + ".internal.resetLink." + toString(*linkID));
	    Place *p2 = PN.findPlace(toString(parent_id) + ".internal.resetedLink." + toString(*linkID));

	    if ( p1 == NULL )
	    {
		p1 = PN.newPlace(toString(parent_id) + ".internal.resetLink." + toString(*linkID));
	    }
	    if ( p2 == NULL )
	    {
		p2 = PN.newPlace(toString(parent_id) + ".internal.resetedLink." + toString(*linkID));
		PN.newArc(p2, PN.findTransition(toString(globals::ASTEmap[*linkID]->parentActivityId) + ".internal.join"));
	    }

	    PN.newArc(t, p1);

	    Transition *t1 = PN.findTransition(toString(parent_id) + ".internal.reset_true." + linkName);
	    if ( t1 == NULL )
	    {
		t1 = PN.newTransition(toString(parent_id) + ".internal.reset_true." + linkName);
		PN.newArc(p1, t1);
		PN.newArc(PN.findPlace("link." + linkName), t1);
		PN.newArc(t1, p2);
	    }

	    Transition *t2 = PN.findTransition(toString(parent_id) + ".internal.reset_false." + linkName);
	    if ( t2 == NULL )
	    {
		t2 = PN.newTransition(toString(parent_id) + ".internal.reset_false." + linkName);
		PN.newArc(p1, t2);
		PN.newArc(PN.findPlace("!link." + linkName), t2);
		PN.newArc(t2, p2);
	    }

	}
    }

    LEAVE("[ASTT]");

#line 446 "petrinet-patterns-shortcuts.k"
}
#line  524 "petrinet-patterns-shortcuts.cc"

void looppattern(string condition, int maxloops, string prefix, int id, Place *enterPlace, Place *loopPlace, Place *exitPlace)
#line 469 "petrinet-patterns-shortcuts.k"
{
    ENTER("[ASTT] looppattern");

    assert( enterPlace != NULL );
    assert( loopPlace != NULL );
    assert( exitPlace != NULL );

    std::string newPrefix = prefix + "loop.";

    int counter=0;

    if (condition == "false")
    {
	Place *Pbase = PN.newPlace(newPrefix + "count_" + toString(counter));
	Pbase->mark();

	Transition *t1 = PN.newTransition(newPrefix + "exit_" + toString(counter));
	PN.newArc(enterPlace, t1);
	PN.newArc(Pbase, t1);
	PN.newArc(t1, Pbase);
	PN.newArc(t1, exitPlace);

    } 
    else
    {
	if (condition == "true")
	{
	    Place *Pbase = PN.newPlace(newPrefix + "count_" + toString(counter));
	    Pbase->mark();
	    Place *Pcurrent = Pbase;
	    Transition *Tcurrent;
	    Transition *Tstop;

	    while(counter < maxloops)
	    {
		Tcurrent = PN.newTransition(newPrefix + "run_" + toString(counter+1));
		if (globals::parameters[P_LOOPCONTROL])
		PN.newArc(PN.findPlace("in.enterloop." + toString(id)), Tcurrent);
		PN.newArc(enterPlace, Tcurrent);
		PN.newArc(Pcurrent, Tcurrent);
		Pcurrent = PN.newPlace(newPrefix + "count_" + toString(counter+1));
		if (globals::parameters[P_COMMUNICATIONONLY] == false)
		{
		    Tstop = stop_loop(Pcurrent, "count_" + toString(counter+1), prefix);
		    PN.newArc(Tstop, Pbase);
		}
		PN.newArc(Tcurrent, Pcurrent);
		PN.newArc(Tcurrent, loopPlace);
		counter++;
	    }

	    Transition *Texit = PN.newTransition(newPrefix + "exit_" + toString(counter));
	    if (globals::parameters[P_LOOPCONTROL])
	    PN.newArc(PN.findPlace("in.leaveloop." + toString(id)), Texit);
	    PN.newArc(Pcurrent, Texit);
	    PN.newArc(enterPlace, Texit);
	    PN.newArc(Texit, Pbase);
	    PN.newArc(Texit, exitPlace);      
	}
	else
	{
	    Place *Pbase = PN.newPlace(newPrefix + "count_" + toString(counter));
	    Pbase->mark();
	    Transition *Texit = PN.newTransition(newPrefix + "exit_" + toString(counter));
	    if (globals::parameters[P_LOOPCONTROL])
	    PN.newArc(PN.findPlace("in.enterloop." + toString(id)), Texit);
	    PN.newArc(Pbase, Texit);
	    PN.newArc(enterPlace, Texit);
	    PN.newArc(Texit, Pbase);
	    PN.newArc(Texit, exitPlace);      

	    Place *Pcurrent =Pbase;
	    Transition *Tcurrent;
	    Transition *Tstop;

	    while(counter < maxloops)
	    {
		Tcurrent = PN.newTransition(newPrefix + "run_" + toString(counter+1));
		if (globals::parameters[P_LOOPCONTROL])
		PN.newArc(PN.findPlace("in.enterloop." + toString(id)), Tcurrent);
		PN.newArc(enterPlace, Tcurrent);
		PN.newArc(Pcurrent, Tcurrent);
		PN.newArc(Tcurrent, loopPlace);
		Pcurrent = PN.newPlace(newPrefix + "count_" + toString(counter+1));
		PN.newArc(Tcurrent, Pcurrent);
		if (globals::parameters[P_COMMUNICATIONONLY] == false)
		{
		    Tstop = stop_loop(Pcurrent, "count_" + toString(counter+1), prefix);
		    PN.newArc(Tstop, Pbase);
		}
		Tcurrent = PN.newTransition(newPrefix + "exit_" + toString(counter+1));
		if (globals::parameters[P_LOOPCONTROL])
		PN.newArc(PN.findPlace("in.leaveloop." + toString(id)), Tcurrent);
		PN.newArc(Pcurrent, Tcurrent);
		PN.newArc(enterPlace, Tcurrent);
		PN.newArc(Tcurrent, Pbase);
		PN.newArc(Tcurrent, exitPlace);
		counter++;
	    }
	}
    }
    LEAVE("[ASTT] looppattern");

#line 571 "petrinet-patterns-shortcuts.k"
}
#line  633 "petrinet-patterns-shortcuts.cc"

void receivingTransition(string name, Place *prePlace, Place *postPlace, Place *channel, Place *faultPlace, string prefix, integer id, int negativeControlFlow, bool preventFurtherFaults)
#line 603 "petrinet-patterns-shortcuts.k"
{
    ENTER("[ASTT] receivingTransition");

    assert( prePlace != NULL );
    assert( postPlace != NULL );
    assert( channel != NULL );
    assert( faultPlace != NULL );

    std::string newPrefix = prefix + name + ".";

    Place *p1 = PN.newPlace(newPrefix + "buffer");
    Place *p2 = PN.newPlace(newPrefix + "received");

    Transition *t1 = PN.newTransition(newPrefix + "receive");
    PN.newArc(prePlace, t1);
    PN.newArc(channel, t1);

    PN.newArc(t1, p1);

    Transition *t2 = PN.newTransition(newPrefix + "write_variable");
    PN.newArc(p1, t2);
    PN.newArc(t2, p2);

    if (globals::parameters[P_VARIABLES])
    {
	string varName = "variable." + globals::ASTEmap[id->value]->variableName;
	if ( name == "invoke_in" )
	{
	    varName = "variable." + globals::ASTEmap[id->value]->outputVariableName;
	}
	PN.newArc(PN.findPlace(varName), t2);
	PN.newArc(t2, PN.findPlace(varName));
    }

    Transition *t3 = PN.newTransition(newPrefix + "finish");
    PN.newArc(p2, t3);
    PN.newArc(t3, postPlace);

    Transition *t4 = stop(p1, name + ".buffer", prefix);
    Transition *t5 = stop(p2, name + ".received", prefix);

    if (globals::parameters[P_STANDARDFAULTS])
    {
	Transition *t6 = throwFault(p1, faultPlace, "buffer", newPrefix, id, globals::ASTEmap[id->value]->controlFlow, preventFurtherFaults);
	Transition *t7 = throwFault(p2, faultPlace, "received", newPrefix, id, globals::ASTEmap[id->value]->controlFlow, preventFurtherFaults);
    }


    LEAVE("[ASTT] receivingTransition");

#line 652 "petrinet-patterns-shortcuts.k"
}
#line  689 "petrinet-patterns-shortcuts.cc"

void sendingTransition(string name, Place *prePlace, Place *postPlace, Place *channel, Place *faultPlace, string prefix, integer id, int negativeControlFlow, bool preventFurtherFaults)
#line 684 "petrinet-patterns-shortcuts.k"
{
    ENTER("[ASTT] sendingTransition");

    std::string newPrefix = prefix + name + ".";

    Place *p1 = PN.newPlace(newPrefix + "buffer");
    Place *p2 = PN.newPlace(newPrefix + "sent");

    Transition *t1 = PN.newTransition(newPrefix + "read_variable");
    PN.newArc(prePlace, t1);
    PN.newArc(t1, p1);

    if (globals::parameters[P_VARIABLES])
    {
	string varName = "variable." + globals::ASTEmap[id->value]->variableName;
	if ( name == "invoke" || name == "invoke_out" )
	{
	    varName = "variable." + globals::ASTEmap[id->value]->inputVariableName;
	}
	PN.newArc(PN.findPlace(varName), t1, READ);
    }

    Transition *t2 = PN.newTransition(newPrefix + "send");
    PN.newArc(p1, t2);
    PN.newArc(t2, channel);

    PN.newArc(t2, p2);

    Transition *t3 = PN.newTransition(newPrefix + "finish");
    PN.newArc(p2, t3);
    PN.newArc(t3, postPlace);

    Transition *t4 = stop(p1, name + ".buffer", prefix);
    Transition *t5 = stop(p2, name + ".sent", prefix);

    if (globals::parameters[P_STANDARDFAULTS])
    {
	Transition *t6 = throwFault(p1, faultPlace, "buffer", newPrefix, id, globals::ASTEmap[id->value]->controlFlow, preventFurtherFaults);
	Transition *t7 = throwFault(p2, faultPlace, "sent", newPrefix, id, globals::ASTEmap[id->value]->controlFlow, preventFurtherFaults);
    }


    LEAVE("[ASTT] sendingTransition");

#line 727 "petrinet-patterns-shortcuts.k"
}
#line  739 "petrinet-patterns-shortcuts.cc"

void P_transitionCondition(string prefix, tSource_list source_links)
#line 749 "petrinet-patterns-shortcuts.k"
{



    Place *p_done = PN.findPlace(prefix + "done");
    Place *p_final = PN.findPlace(prefix + "final");

    assert(p_done != NULL);
    assert(p_final != NULL);






    if (globals::parameters[P_XOR] && (source_links->length() > 1))
    {

	unsigned int linkCounter = 1;
	{
#line 768 "petrinet-patterns-shortcuts.k"
	    tSource_list kc_fe_selvar_1 =  source_links;

#line  766 "petrinet-patterns-shortcuts.cc"
	    while(
		    kc_fe_selvar_1->prod_sel() == sel_ConstSource_list
		) {
		tSource kc_selvar_0_1 = kc_fe_selvar_1->tSource_1;
		{
#line 768 "petrinet-patterns-shortcuts.k"
		    {
			{
#line 769 "petrinet-patterns-shortcuts.k"
#line 768 "petrinet-patterns-shortcuts.k"
			    const tSource source = kc_selvar_0_1;
#line 769 "petrinet-patterns-shortcuts.k"


			    Transition *t1 = PN.newTransition(prefix + "setLinks" + toString(linkCounter++));
			    PN.newArc(p_done, t1);
			    PN.newArc(t1, p_final);


			    Place *link_true = PN.findPlace("link." + globals::ASTEmap[source->id]->linkName);
			    PN.newArc(t1, link_true);


			    {
#line 780 "petrinet-patterns-shortcuts.k"
				tSource_list kc_fe_selvar_1 =  source_links;

#line  794 "petrinet-patterns-shortcuts.cc"
				while(
					kc_fe_selvar_1->prod_sel() == sel_ConstSource_list
				    ) {
				    tSource kc_selvar_1_1 = kc_fe_selvar_1->tSource_1;
				    {
#line 780 "petrinet-patterns-shortcuts.k"
					{
					    {
#line 781 "petrinet-patterns-shortcuts.k"
#line 780 "petrinet-patterns-shortcuts.k"
						const tSource source2 = kc_selvar_1_1;
#line 781 "petrinet-patterns-shortcuts.k"

						if (globals::ASTEmap[source2->id]->linkName != globals::ASTEmap[source->id]->linkName)
						{
						    Place *link_false = PN.findPlace("!link." + globals::ASTEmap[source2->id]->linkName);
						    PN.newArc(t1, link_false);
						}

#line  814 "petrinet-patterns-shortcuts.cc"
					    }
					}

#line  818 "petrinet-patterns-shortcuts.cc"
				    }
				    kc_fe_selvar_1 = kc_fe_selvar_1->tSource_list_1;
#line 780 "petrinet-patterns-shortcuts.k"

#line  823 "petrinet-patterns-shortcuts.cc"
				}
			    }
#line 788 "petrinet-patterns-shortcuts.k"


			    string givenTransitionCondition = globals::ASTEmap[source->id]->attributes["transitionCondition"];
			    if ((givenTransitionCondition != "") && (givenTransitionCondition != "true"))
			    {
				if (givenTransitionCondition != "" && givenTransitionCondition != "true")
				genericError(119, globals::ASTEmap[globals::ASTEmap[source->id]->parentActivityId]->activityTypeName(), globals::ASTEmap[source->id]->attributes["referenceLine"], ERRORLEVEL_NOTICE);
			    }

#line  836 "petrinet-patterns-shortcuts.cc"
			}
		    }

#line  840 "petrinet-patterns-shortcuts.cc"
		}
		kc_fe_selvar_1 = kc_fe_selvar_1->tSource_list_1;
#line 768 "petrinet-patterns-shortcuts.k"

#line  845 "petrinet-patterns-shortcuts.cc"
	    }
	}
#line 797 "petrinet-patterns-shortcuts.k"
    }





    else
    {

	Transition *t1 = PN.newTransition(prefix + "setLinks");
	PN.newArc(p_done, t1);
	PN.newArc(t1, p_final);


	{
#line 811 "petrinet-patterns-shortcuts.k"
	    tSource_list kc_fe_selvar_1 =  source_links;

#line  867 "petrinet-patterns-shortcuts.cc"
	    while(
		    kc_fe_selvar_1->prod_sel() == sel_ConstSource_list
		) {
		tSource kc_selvar_0_1 = kc_fe_selvar_1->tSource_1;
		{
#line 811 "petrinet-patterns-shortcuts.k"
		    {
			{
#line 812 "petrinet-patterns-shortcuts.k"
#line 811 "petrinet-patterns-shortcuts.k"
			    const tSource source = kc_selvar_0_1;
#line 812 "petrinet-patterns-shortcuts.k"

			    Place *link_true = PN.findPlace("link." + globals::ASTEmap[source->id]->linkName);
			    PN.newArc(t1, link_true);


			    string givenTransitionCondition = globals::ASTEmap[source->id]->attributes["transitionCondition"];
			    if (givenTransitionCondition != "" && givenTransitionCondition != "true")
			    genericError(118, globals::ASTEmap[globals::ASTEmap[source->id]->parentActivityId]->activityTypeName(), globals::ASTEmap[source->id]->attributes["referenceLine"], ERRORLEVEL_NOTICE);

#line  889 "petrinet-patterns-shortcuts.cc"
			}
		    }

#line  893 "petrinet-patterns-shortcuts.cc"
		}
		kc_fe_selvar_1 = kc_fe_selvar_1->tSource_list_1;
#line 811 "petrinet-patterns-shortcuts.k"

#line  898 "petrinet-patterns-shortcuts.cc"
	    }
	}
#line 821 "petrinet-patterns-shortcuts.k"
    }

#line 822 "petrinet-patterns-shortcuts.k"
}
#line  906 "petrinet-patterns-shortcuts.cc"

void P_joinCondition(string prefix, tTarget_list target_links, joinCondition jc)
#line 842 "petrinet-patterns-shortcuts.k"
{

    map<unsigned int, Transition*> joinTransitions;
    map<unsigned int, Place*> trueLinks;
    map<unsigned int, Place*> falseLinks;
    unsigned int transitionNumber = (unsigned int)pow(2.0, target_links->length());


    bool report = (transitionNumber > 1000);

    Place *p_jc_false = PN.findPlace(prefix + "jc_false");
    Place *p_jc_true = PN.findPlace(prefix + "jc_true");

    assert(p_jc_false != NULL);
    assert(p_jc_true != NULL);




    unsigned int linkCount = 0;
    {
#line 862 "petrinet-patterns-shortcuts.k"
	tTarget_list kc_fe_selvar_1 =  target_links;

#line  934 "petrinet-patterns-shortcuts.cc"
	while(
		kc_fe_selvar_1->prod_sel() == sel_ConstTarget_list
	    ) {
	    tTarget kc_selvar_0_1 = kc_fe_selvar_1->tTarget_1;
	    {
#line 862 "petrinet-patterns-shortcuts.k"
		{
		    {
#line 863 "petrinet-patterns-shortcuts.k"
#line 862 "petrinet-patterns-shortcuts.k"
			const tTarget target = kc_selvar_0_1;
#line 863 "petrinet-patterns-shortcuts.k"

			Place *linkT = PN.findPlace("link." + globals::ASTEmap[target->id]->linkName);
			Place *linkF = PN.findPlace("!link." + globals::ASTEmap[target->id]->linkName);

			trueLinks[linkCount] = linkT;
			falseLinks[linkCount] = linkF;

			linkCount++;

#line  956 "petrinet-patterns-shortcuts.cc"
		    }
		}

#line  960 "petrinet-patterns-shortcuts.cc"
	    }
	    kc_fe_selvar_1 = kc_fe_selvar_1->tTarget_list_1;
#line 862 "petrinet-patterns-shortcuts.k"

#line  965 "petrinet-patterns-shortcuts.cc"
	}
    }
#line 872 "petrinet-patterns-shortcuts.k"



    for (unsigned int i = 0; i < transitionNumber; i++)
    {
	if (report && (i % 1000 == 0) && (i > 0))
	trace(TRACE_WARNINGS, "[JC]\t" + toString(i) + " transitions created\n");

	joinTransitions[i] = PN.newTransition(prefix + "evaluate" + toString(i));

	PN.newArc(PN.findPlace(prefix + "initial"), joinTransitions[i]); 

	for (unsigned int j = 0; j < linkCount; j++)
	{
	    if (((i >> j) % 2) == 0) 
	    PN.newArc(trueLinks[j], joinTransitions[i]);
	    else
	    PN.newArc(falseLinks[j], joinTransitions[i]);  
	}
    }






    if (string(jc->op_name()) == "standardJoinCondition")
    {

	for (unsigned int i = 0; i < transitionNumber; i++)
	{
	    if (report && (i % 1000 == 0) && (i > 0))
	    trace(TRACE_WARNINGS, "[JC]\t" + toString(i) + " arcs created\n");



	    if (i == transitionNumber-1)
	    PN.newArc(joinTransitions[i], p_jc_false);
	    else
	    PN.newArc(joinTransitions[i], p_jc_true);
	}
    }






    else
    {

	for (unsigned int i = 0; i < transitionNumber; i++)
	{
	    if (report && (i % 1000 == 0) && (i > 0))
	    trace(TRACE_WARNINGS, "[JC]\t" + toString(i) + " arcs created\n");


	    if (globals::joinCondition_result[jc->parentId][i])
	    PN.newArc(joinTransitions[i], p_jc_true);
	    else
	    PN.newArc(joinTransitions[i], p_jc_false);
	}  
    }

#line 935 "petrinet-patterns-shortcuts.k"
}
#line  1035 "petrinet-patterns-shortcuts.cc"


} // namespace kc
