;;; -*- Mode: LISP; Syntax: COMMON-LISP; Base: 10.; Package: XIT -*-
;;;_____________________________________________________________________________
;;;
;;;                       System: XIT
;;;                       Module: Form Examples
;;;
;;; Copyright (c): Forschungsgruppe DRUID, Juergen Herczeg
;;;                Universitaet Stuttgart
;;;
;;; File: /usr/local/lisp/xit/examples/form-examples.lisp
;;; File Creation Date: 6/23/89 10:31:37
;;; Last Modification Time: 07/22/92 10:48:31
;;; Last Modification By: Juergen Herczeg
;;;
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;;
;;;_____________________________________________________________________________

(in-package :xit)

;_______________________________________________________________________________

(proclaim '(special demo-window icon-menu form-window form-1 *display*))

		   
(setq form-window
      (make-window 'intel-example-window
		   :x 300 :y 50 :width 500 :height 600
		   :window-icon `(intel-example-icon :parent ,icon-menu
						     :text "Forms")
		   :title "Forms"))

(setq form-1
      (make-window 'form
		   :parent form-window
		   :x 20 :y 40
		   :border-width 1
		   :view-of demo-window
		   :part-label-width 100
		   :reactivity-entries '((:single-left-button
				  "Read attribute values of Test Window"
				  (call :self read-values))
				 (:single-middle-button
				  "Move form window"
				  (call :move)))
		   :parts '((:label x
			     :read-function contact-x
			     :write-function (change-geometry view-of :x value))
			    (:label y
			     :read-function contact-y
			     :write-function (change-geometry view-of :y value))
			    (:label width
			     :read-function contact-width
			     :write-function (change-geometry view-of :width value))
			    (:label height
			     :read-function contact-height
			     :write-function (change-geometry view-of :height value))
			    (:label "border width"
			     :read-function contact-border-width
			     :write-function (change-geometry view-of :border-width value))
			    (:label min-width
			     :read-function min-width
			     :write-function (setf (min-width view-of) value))
			    (:label min-height
			     :read-function min-height
			     :write-function (setf (min-height view-of) value))
			    (:label max-width
			     :read-function max-width
			     :write-function (setf (max-width view-of) value))
			    (:label max-height
			     :read-function max-height
			     :write-function (setf (max-height view-of) value))
			    (:read-function title
			     :write-transformation string)
			    (:label "title font" 
			     :read-function title-font
			     :value-width 300)
			    (:read-function reactivity
			     :value-font (:face :normal :size 10)
			     :value-width nil))))

(update-state *display*)
(process-all-events *display*)

(shrink form-window)

(update-state *display*)
(process-all-events *display*)
