;;; -*- Mode: LISP; Syntax: Common-lisp; Package: XLIB; Base: 10; Lowercase: Yes	
(in-package :xlib)

;; patch for lucid 4.0
;; (see comment below)

#+lcl3.0
(defun buffer-input-wait-default (display timeout)
  (declare (type display display)
	   (type (or null number) timeout)
	   (values timeout))
  #.(declare-buffun)
  (let ((stream (display-input-stream display)))
    (declare (type (or null stream) stream))
    (cond ((null stream))
	  ((listen stream) nil)
	  ((eql timeout 0) :timeout)
	  ((with-underlying-stream (stream stream display input)
	     ;; ********** CHANGED **********
	     ;; 10/15/1991 (Hubertus)
	     ;; In Lucid 4.0 LCL:PROCESS-WAIT-WITH-TIMEOUT never times out
	     ;; if wrapped inside LUCID::WAITING-FOR-INPUT-FROM-STREAM
	     (#+lcl4.0 progn #-lcl4.0 lucid::waiting-for-input-from-stream
		    stream
               (lucid::with-io-unlocked
		 (if (null timeout)
		     (lcl:process-wait "CLX Input" #'listen stream)
		   (lcl:process-wait-with-timeout
		     "CLX Input" timeout #'listen stream)))))
	   nil)
	  (:timeout))))

