;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: USER; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;         The Garnet User Interface Development Environment.      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; This code was written as part of the Garnet project at          ;;;
;;; Carnegie Mellon University, and has been placed in the public   ;;;
;;; domain.  If you are using this code or any part of Garnet,      ;;;
;;; please contact garnet@cs.cmu.edu to be put on the mailing list. ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;

#|
============================================================
Change log:
        27-Aug-93 Andrew Mickish - Added suggest-constants
        10-Jan-93 Brad Myers - Added inspector 
        20-Jan-92 Andrew Mickish - Moved GARNET-DEBUG package
                                   definition into Garnet-Loader
	22-Mar-90 Robert Cook - Define the package "GARNET-DEBUG"
				for the TI Explorer
	 4-Jan-90 ECP Added version number
	18-Oct-89 RBD Created
============================================================
|#

(in-package "USER" :use '("LISP"))

(defparameter Debug-Version-Number "2.0")

(format t "Loading Debugging Tools ...~%")

;; check first to see if pathname variable is set
(unless (boundp 'Garnet-Debug-PathName)
  (error "Load 'Garnet-Loader' first to set Garnet-Debug-PathName before loading debug tools."))

;; ---- Load debugging tools now.

(Defvar Garnet-Debug-Files
  '(
    "debug-fns"
    "objsize"
    "inspector"
    "suggest-constants"))


(dolist (file Garnet-Debug-Files)
  (load (merge-pathnames file 
			 #+cmu "debug:"
			 #+(not cmu) Garnet-Debug-PathName
			 )
	:verbose T))

(setf (get :garnet-modules :debug)  t)
(format t "...Done Debugging Tools.~%")

