/* 
 * AFM mac encoding.
 * Copyright (c) 1996 Markku Rossi.
 *
 * Author: Markku Rossi <mtr@iki.fi>
 */

/*
 * This file is part of the AFM library.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "afmint.h"

AFMEncodingTable afm_mac_encoding[] =
{
  {0x00, AFM_ENC_NONE},
  {0x01, AFM_ENC_NONE},
  {0x02, AFM_ENC_NONE},
  {0x03, AFM_ENC_NONE},
  {0x04, AFM_ENC_NONE},
  {0x05, AFM_ENC_NONE},
  {0x06, AFM_ENC_NONE},
  {0x07, AFM_ENC_NONE},
  {0x08, AFM_ENC_NONE},
  {0x09, AFM_ENC_NONE},
  {0x0a, AFM_ENC_NONE},
  {0x0b, AFM_ENC_NONE},
  {0x0c, AFM_ENC_NONE},
  {0x0d, AFM_ENC_NONE},
  {0x0e, AFM_ENC_NONE},
  {0x0f, AFM_ENC_NONE},
  {0x10, AFM_ENC_NONE},
  {0x11, AFM_ENC_NONE},
  {0x12, AFM_ENC_NONE},
  {0x13, AFM_ENC_NONE},
  {0x14, AFM_ENC_NONE},
  {0x15, AFM_ENC_NONE},
  {0x16, AFM_ENC_NONE},
  {0x17, AFM_ENC_NONE},
  {0x18, AFM_ENC_NONE},
  {0x19, AFM_ENC_NONE},
  {0x1a, AFM_ENC_NONE},
  {0x1b, AFM_ENC_NONE},
  {0x1c, AFM_ENC_NONE},
  {0x1d, AFM_ENC_NONE},
  {0x1e, AFM_ENC_NONE},
  {0x1f, AFM_ENC_NONE},
  {0x20, "space"},
  {0x21, "exclam"},
  {0x22, "quotedbl"},
  {0x23, "numbersign"},
  {0x24, "dollar"},
  {0x25, "percent"},
  {0x26, "ampersand"},
  {0x27, "quoteright"},
  {0x28, "parenleft"},
  {0x29, "parenright"},
  {0x2a, "asterisk"},
  {0x2b, "plus"},
  {0x2c, "comma"},
  {0x2d, "minus"},
  {0x2e, "period"},
  {0x2f, "slash"},
  {0x30, "zero"},
  {0x31, "one"},
  {0x32, "two"},
  {0x33, "three"},
  {0x34, "four"},
  {0x35, "five"},
  {0x36, "six"},
  {0x37, "seven"},
  {0x38, "eight"},
  {0x39, "nine"},
  {0x3a, "colon"},
  {0x3b, "semicolon"},
  {0x3c, "less"},
  {0x3d, "equal"},
  {0x3e, "greater"},
  {0x3f, "question"},
  {0x40, "at"},
  {0x41, "A"},
  {0x42, "B"},
  {0x43, "C"},
  {0x44, "D"},
  {0x45, "E"},
  {0x46, "F"},
  {0x47, "G"},
  {0x48, "H"},
  {0x49, "I"},
  {0x4a, "J"},
  {0x4b, "K"},
  {0x4c, "L"},
  {0x4d, "M"},
  {0x4e, "N"},
  {0x4f, "O"},
  {0x50, "P"},
  {0x51, "Q"},
  {0x52, "R"},
  {0x53, "S"},
  {0x54, "T"},
  {0x55, "U"},
  {0x56, "V"},
  {0x57, "W"},
  {0x58, "X"},
  {0x59, "Y"},
  {0x5a, "Z"},
  {0x5b, "bracketleft"},
  {0x5c, "backslash"},
  {0x5d, "bracketright"},
  {0x5e, "asciicircum"},
  {0x5f, "underscore"},
  {0x60, "quoteleft"},
  {0x61, "a"},
  {0x62, "b"},
  {0x63, "c"},
  {0x64, "d"},
  {0x65, "e"},
  {0x66, "f"},
  {0x67, "g"},
  {0x68, "h"},
  {0x69, "i"},
  {0x6a, "j"},
  {0x6b, "k"},
  {0x6c, "l"},
  {0x6d, "m"},
  {0x6e, "n"},
  {0x6f, "o"},
  {0x70, "p"},
  {0x71, "q"},
  {0x72, "r"},
  {0x73, "s"},
  {0x74, "t"},
  {0x75, "u"},
  {0x76, "v"},
  {0x77, "w"},
  {0x78, "x"},
  {0x79, "y"},
  {0x7a, "z"},
  {0x7b, "braceleft"},
  {0x7c, "bar"},
  {0x7d, "braceright"},
  {0x7e, "tilde"},
  {0x7f, AFM_ENC_NONE},
  {0x80, "Adieresis"},
  {0x81, "Aring"},
  {0x82, "Ccedilla"},
  {0x83, "Eacute"},
  {0x84, "Ntilde"},
  {0x85, "Odieresis"},
  {0x86, "Udieresis"},
  {0x87, "aacute"},
  {0x88, "agrave"},
  {0x89, "acircumflex"},
  {0x8a, "adieresis"},
  {0x8b, "atilde"},
  {0x8c, "aring"},
  {0x8d, "ccedilla"},
  {0x8e, "eacute"},
  {0x8f, "egrave"},
  {0x90, "ecircumflex"},
  {0x91, "edieresis"},
  {0x92, "iacute"},
  {0x93, "igrave"},
  {0x94, "icircumflex"},
  {0x95, "idieresis"},
  {0x96, "ntilde"},
  {0x97, "oacute"},
  {0x98, "ograve"},
  {0x99, "ocircumflex"},
  {0x9a, "odieresis"},
  {0x9b, "otilde"},
  {0x9c, "uacute"},
  {0x9d, "ugrave"},
  {0x9e, "ucircumflex"},
  {0x9f, "udieresis"},
  {0xa0, "dagger"},
  {0xa1, "degree"},
  {0xa2, "cent"},
  {0xa3, "sterling"},
  {0xa4, "section"},
  {0xa5, "bullet"},
  {0xa6, "paragraph"},
  {0xa7, "germandbls"},
  {0xa8, "registered"},
  {0xa9, "copyright"},
  {0xaa, "trademark"},
  {0xab, "acute"},
  {0xac, "dieresis"},
  {0xad, "notequal"},
  {0xae, "AE"},
  {0xaf, "Oslash"},
  {0xb0, "infinity"},
  {0xb1, "plusminus"},
  {0xb2, "lessequal"},
  {0xb3, "greaterequal"},
  {0xb4, "yen"},
  {0xb5, "mu"},
  {0xb6, "partialdiff"},
  {0xb7, "Sigma"},
  {0xb8, "product"},
  {0xb9, "pi"},
  {0xba, "integral"},
  {0xbb, "ordfeminine"},
  {0xbc, "ordmasculine"},
  {0xbd, "Omega"},
  {0xbe, "ae"},
  {0xbf, "oslash"},
  {0xc0, "questiondown"},
  {0xc1, "exclamdown"},
  {0xc2, "logicalnot"},
  {0xc3, "radical"},
  {0xc4, "florin"},
  {0xc5, "approxequal"},
  {0xc6, "Delta"},
  {0xc7, "guillemotleft"},
  {0xc8, "guillemotright"},
  {0xc9, "ellipsis"},
  {0xca, "space"},
  {0xcb, "Agrave"},
  {0xcc, "Atilde"},
  {0xcd, "Otilde"},
  {0xce, "OE"},
  {0xcf, "oe"},
  {0xd0, "endash"},
  {0xd1, "emdash"},
  {0xd2, "quotedblleft"},
  {0xd3, "quotedblright"},
  {0xd4, "quoteleft"},
  {0xd5, "quoteright"},
  {0xd6, "divide"},
  {0xd7, "lozenge"},
  {0xd8, "ydieresis"},
  {0xd9, "Ydieresis"},
  {0xda, "fraction"},
  {0xdb, "currency"},
  {0xdc, "guilsinglleft"},
  {0xdd, "guilsinglright"},
  {0xde, "fi"},
  {0xdf, "fl"},
  {0xe0, "daggerdbl"},
  {0xe1, "periodcentered"},
  {0xe2, "quotesinglbase"},
  {0xe3, "quotedblbase"},
  {0xe4, "perthousand"},
  {0xe5, "Acircumflex"},
  {0xe6, "Ecircumflex"},
  {0xe7, "Aacute"},
  {0xe8, "Edieresis"},
  {0xe9, "Egrave"},
  {0xea, "Iacute"},
  {0xeb, "Icircumflex"},
  {0xec, "Idieresis"},
  {0xed, "Igrave"},
  {0xee, "Oacute"},
  {0xef, "Ocircumflex"},
  {0xf0, AFM_ENC_NONE},
  {0xf1, "Ograve"},
  {0xf2, "Uacute"},
  {0xf3, "Ucircumflex"},
  {0xf4, "Ugrave"},
  {0xf5, "dotlessi"},
  {0xf6, "circumflex"},
  {0xf7, "tilde"},
  {0xf8, "macron"},
  {0xf9, "breve"},
  {0xfa, "dotaccent"},
  {0xfb, "ring"},
  {0xfc, "cedilla"},
  {0xfd, "hungarumlaut"},
  {0xfe, "ogonek"},
  {0xff, "caron"},
  {-1,   NULL},
};
