.\" Copyright (c) 1993, 1999 Free Software Foundation, Inc.
.\" See section COPYING for conditions for redistribution
.\" edit-pr, editing function for GNATS - Jeffrey Osier
.TH edit-pr 1 "November 2002" "GNATS @VERSION@" "GNATS User Utilities"
.de BP
.sp
.ti -.2i
\(**
..
.SH NAME
edit-pr \- edit a problem report in the GNATS database
.SH SYNOPSIS
.hy 0
.na
.B edit-pr 
.RS
[
.B -h 
| 
.B --help
]
[
.B -V 
| 
.B --version
]
.br
[
.BI -d \ databasename
|
.BI --database= databasename
]
.br
[
.BI -H \ host
|
.BI --host= host
]
[
.BI -P \ port
|
.BI --port= port
]
.br
[
.BI -v \ user
|
.BI --user= user
]
[
.BI -w \ password
|
.BI --passwd= password
]
.br
.I PR
.ad b
.hy 1
.SH DESCRIPTION
\fBedit-pr\fR is used to make changes to existing PRs in a GNATS
database.
.P
\fBedit-pr\fR first examines the \fIPR\fR and locks it if it is not
already locked.  This is to prevent a PR from being edited by two
users simultaneously.  If the PR is already in the process of being
edited, \fBedit-pr\fR displays the name of the person who owns the
lock.
.P
\fBedit-pr\fR then calls \fB$EDITOR\fR on \fIPR\fR.  After the PR has
been edited, it is resubmitted to the database, and the index is
updated.
.P
If you change a field that requires a reason for the change,
\fBedit-pr\fR prompts you to supply a reason for the change.  A
message is then appended to the Audit-Trail field of \fIPR\fR with the
changed values and the change reason.
.P
Depending on how the database is configured, editing various fields in
the PR may also cause mail to be sent concerning these changes.  In
the default configuration, any fields that generate Audit-Trail
entries will cause a copy of the new Audit-Trail message to be sent.
.SH OPTIONS
.TP 1i
.B -h\fR,\fB --help
Prints a brief usage message for
.BR edit-pr .
.TP
.B -V\fR,\fB --version
Prints the version number for
.BR edit-pr .
.TP
.B -d\fR,\fB --database
Specifies the database containing the PR to be edited; if no database is
specified, the database named \fIdefault\fR is assumed.  This option
overrides the database specified in the \fBGNATSDB\fR environment variable.
.SS
GNATS network options:
.TP
.B -H\fR,\fB --host
Hostname of the GNATS server.
.TP
.B -P\fR,\fB --port
The port that the GNATS server runs on.
.TP
.B -v\fR,\fB --username
Username used to log into the GNATS server.
.TP
.B -w\fR,\fB --passwd
Password used to log into the GNATS server.
.B
.SH ENVIRONMENT VARIABLES
The environment variable
.B EDITOR
specifies the editor to invoke on the PR.  Default is \fIvi\fR(1).
.TP
The \fBGNATSDB\fR environment variable is used to determine which database to
use.  For a local database, it contains the name of the database to access.
.P
For network access via \fIgnatsd\fR, it contains a colon-separated list
of strings that describe the remote database, in the form
.TP
\fIserver\fR:\fIport\fR:\fIdatabasename\fR:\fIusername\fR:\fIpassword\fR
.P
Any of the fields may be omitted, but at least one colon must appear;
otherwise, the value is assumed to be the name of a local database.
.P
If \fBGNATSDB\fR is not set, it is assumed that the database is local
and that its name is \fIdefault\fR.
.SH FILES
.TP 1i
.B /tmp/ep$$
Temporary file for PR being edited.
.TP
.B /tmp/ed_pr_ch$$
Holds 
.B Audit-Trail
change message, if needed.
.TP
.B /tmp/u$$
Holds output of lock function.
.SH "SEE ALSO"
.I Keeping Track: Managing Messages With GNATS
(also installed as the GNU Info file
.BR gnats.info )
.LP
.BR databases (5),
.BR dbconfig (5),
.BR delete-pr (8),
.BR edit-pr (1)
.BR file-pr (8),
.BR gen-index (8),
.BR gnats (7),
.BR gnatsd (8),
.BR mkcat (8),
.BR mkdb (8),
.BR pr-edit (8),
.BR query-pr (1),
.BR queue-pr (8),
.BR send-pr (1).
.SH COPYING
Copyright (c) 1993, 2002, Free Software Foundation, Inc.
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
