/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm;

import gnu.prolog.vm.Environment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;

public abstract class EnvInitializer {
    public static final void runInitializers(Environment environment) {
        try {
            Enumeration<URL> urls = EnvInitializer.class.getClassLoader().getResources("META-INF/services/gnu.prolog.vm.envinitializer");
            while (urls.hasMoreElements()) {
                String line;
                BufferedReader rdr = new BufferedReader(new InputStreamReader(urls.nextElement().openStream()));
                while ((line = rdr.readLine()) != null) {
                    try {
                        Class<?> cls = Class.forName(line);
                        if (!EnvInitializer.class.isAssignableFrom(cls)) continue;
                        EnvInitializer envinit = cls.asSubclass(EnvInitializer.class).newInstance();
                        envinit.initialize(environment);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public abstract void initialize(Environment var1);
}

