// Copyright 2012-2015 The Rust Project Developers. See the COPYRIGHT
// file at the top-level directory of this distribution and at
// http://rust-lang.org/COPYRIGHT.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

// NOTE: The following code was generated by "scripts/unicode.py", do not edit directly

#![allow(missing_docs, non_upper_case_globals, non_snake_case)]

/// The version of [Unicode](http://www.unicode.org/)
/// that this version of unicode-normalization is based on.
pub const UNICODE_VERSION: (u64, u64, u64) = (8, 0, 0);

pub mod normalization {
    // Canonical decompositions
    pub const canonical_table: &'static [(char, &'static [char])] = &[
        ('\u{c0}', &['\u{41}', '\u{300}']), ('\u{c1}', &['\u{41}', '\u{301}']), ('\u{c2}',
        &['\u{41}', '\u{302}']), ('\u{c3}', &['\u{41}', '\u{303}']), ('\u{c4}', &['\u{41}',
        '\u{308}']), ('\u{c5}', &['\u{41}', '\u{30a}']), ('\u{c7}', &['\u{43}', '\u{327}']),
        ('\u{c8}', &['\u{45}', '\u{300}']), ('\u{c9}', &['\u{45}', '\u{301}']), ('\u{ca}',
        &['\u{45}', '\u{302}']), ('\u{cb}', &['\u{45}', '\u{308}']), ('\u{cc}', &['\u{49}',
        '\u{300}']), ('\u{cd}', &['\u{49}', '\u{301}']), ('\u{ce}', &['\u{49}', '\u{302}']),
        ('\u{cf}', &['\u{49}', '\u{308}']), ('\u{d1}', &['\u{4e}', '\u{303}']), ('\u{d2}',
        &['\u{4f}', '\u{300}']), ('\u{d3}', &['\u{4f}', '\u{301}']), ('\u{d4}', &['\u{4f}',
        '\u{302}']), ('\u{d5}', &['\u{4f}', '\u{303}']), ('\u{d6}', &['\u{4f}', '\u{308}']),
        ('\u{d9}', &['\u{55}', '\u{300}']), ('\u{da}', &['\u{55}', '\u{301}']), ('\u{db}',
        &['\u{55}', '\u{302}']), ('\u{dc}', &['\u{55}', '\u{308}']), ('\u{dd}', &['\u{59}',
        '\u{301}']), ('\u{e0}', &['\u{61}', '\u{300}']), ('\u{e1}', &['\u{61}', '\u{301}']),
        ('\u{e2}', &['\u{61}', '\u{302}']), ('\u{e3}', &['\u{61}', '\u{303}']), ('\u{e4}',
        &['\u{61}', '\u{308}']), ('\u{e5}', &['\u{61}', '\u{30a}']), ('\u{e7}', &['\u{63}',
        '\u{327}']), ('\u{e8}', &['\u{65}', '\u{300}']), ('\u{e9}', &['\u{65}', '\u{301}']),
        ('\u{ea}', &['\u{65}', '\u{302}']), ('\u{eb}', &['\u{65}', '\u{308}']), ('\u{ec}',
        &['\u{69}', '\u{300}']), ('\u{ed}', &['\u{69}', '\u{301}']), ('\u{ee}', &['\u{69}',
        '\u{302}']), ('\u{ef}', &['\u{69}', '\u{308}']), ('\u{f1}', &['\u{6e}', '\u{303}']),
        ('\u{f2}', &['\u{6f}', '\u{300}']), ('\u{f3}', &['\u{6f}', '\u{301}']), ('\u{f4}',
        &['\u{6f}', '\u{302}']), ('\u{f5}', &['\u{6f}', '\u{303}']), ('\u{f6}', &['\u{6f}',
        '\u{308}']), ('\u{f9}', &['\u{75}', '\u{300}']), ('\u{fa}', &['\u{75}', '\u{301}']),
        ('\u{fb}', &['\u{75}', '\u{302}']), ('\u{fc}', &['\u{75}', '\u{308}']), ('\u{fd}',
        &['\u{79}', '\u{301}']), ('\u{ff}', &['\u{79}', '\u{308}']), ('\u{100}', &['\u{41}',
        '\u{304}']), ('\u{101}', &['\u{61}', '\u{304}']), ('\u{102}', &['\u{41}', '\u{306}']),
        ('\u{103}', &['\u{61}', '\u{306}']), ('\u{104}', &['\u{41}', '\u{328}']), ('\u{105}',
        &['\u{61}', '\u{328}']), ('\u{106}', &['\u{43}', '\u{301}']), ('\u{107}', &['\u{63}',
        '\u{301}']), ('\u{108}', &['\u{43}', '\u{302}']), ('\u{109}', &['\u{63}', '\u{302}']),
        ('\u{10a}', &['\u{43}', '\u{307}']), ('\u{10b}', &['\u{63}', '\u{307}']), ('\u{10c}',
        &['\u{43}', '\u{30c}']), ('\u{10d}', &['\u{63}', '\u{30c}']), ('\u{10e}', &['\u{44}',
        '\u{30c}']), ('\u{10f}', &['\u{64}', '\u{30c}']), ('\u{112}', &['\u{45}', '\u{304}']),
        ('\u{113}', &['\u{65}', '\u{304}']), ('\u{114}', &['\u{45}', '\u{306}']), ('\u{115}',
        &['\u{65}', '\u{306}']), ('\u{116}', &['\u{45}', '\u{307}']), ('\u{117}', &['\u{65}',
        '\u{307}']), ('\u{118}', &['\u{45}', '\u{328}']), ('\u{119}', &['\u{65}', '\u{328}']),
        ('\u{11a}', &['\u{45}', '\u{30c}']), ('\u{11b}', &['\u{65}', '\u{30c}']), ('\u{11c}',
        &['\u{47}', '\u{302}']), ('\u{11d}', &['\u{67}', '\u{302}']), ('\u{11e}', &['\u{47}',
        '\u{306}']), ('\u{11f}', &['\u{67}', '\u{306}']), ('\u{120}', &['\u{47}', '\u{307}']),
        ('\u{121}', &['\u{67}', '\u{307}']), ('\u{122}', &['\u{47}', '\u{327}']), ('\u{123}',
        &['\u{67}', '\u{327}']), ('\u{124}', &['\u{48}', '\u{302}']), ('\u{125}', &['\u{68}',
        '\u{302}']), ('\u{128}', &['\u{49}', '\u{303}']), ('\u{129}', &['\u{69}', '\u{303}']),
        ('\u{12a}', &['\u{49}', '\u{304}']), ('\u{12b}', &['\u{69}', '\u{304}']), ('\u{12c}',
        &['\u{49}', '\u{306}']), ('\u{12d}', &['\u{69}', '\u{306}']), ('\u{12e}', &['\u{49}',
        '\u{328}']), ('\u{12f}', &['\u{69}', '\u{328}']), ('\u{130}', &['\u{49}', '\u{307}']),
        ('\u{134}', &['\u{4a}', '\u{302}']), ('\u{135}', &['\u{6a}', '\u{302}']), ('\u{136}',
        &['\u{4b}', '\u{327}']), ('\u{137}', &['\u{6b}', '\u{327}']), ('\u{139}', &['\u{4c}',
        '\u{301}']), ('\u{13a}', &['\u{6c}', '\u{301}']), ('\u{13b}', &['\u{4c}', '\u{327}']),
        ('\u{13c}', &['\u{6c}', '\u{327}']), ('\u{13d}', &['\u{4c}', '\u{30c}']), ('\u{13e}',
        &['\u{6c}', '\u{30c}']), ('\u{143}', &['\u{4e}', '\u{301}']), ('\u{144}', &['\u{6e}',
        '\u{301}']), ('\u{145}', &['\u{4e}', '\u{327}']), ('\u{146}', &['\u{6e}', '\u{327}']),
        ('\u{147}', &['\u{4e}', '\u{30c}']), ('\u{148}', &['\u{6e}', '\u{30c}']), ('\u{14c}',
        &['\u{4f}', '\u{304}']), ('\u{14d}', &['\u{6f}', '\u{304}']), ('\u{14e}', &['\u{4f}',
        '\u{306}']), ('\u{14f}', &['\u{6f}', '\u{306}']), ('\u{150}', &['\u{4f}', '\u{30b}']),
        ('\u{151}', &['\u{6f}', '\u{30b}']), ('\u{154}', &['\u{52}', '\u{301}']), ('\u{155}',
        &['\u{72}', '\u{301}']), ('\u{156}', &['\u{52}', '\u{327}']), ('\u{157}', &['\u{72}',
        '\u{327}']), ('\u{158}', &['\u{52}', '\u{30c}']), ('\u{159}', &['\u{72}', '\u{30c}']),
        ('\u{15a}', &['\u{53}', '\u{301}']), ('\u{15b}', &['\u{73}', '\u{301}']), ('\u{15c}',
        &['\u{53}', '\u{302}']), ('\u{15d}', &['\u{73}', '\u{302}']), ('\u{15e}', &['\u{53}',
        '\u{327}']), ('\u{15f}', &['\u{73}', '\u{327}']), ('\u{160}', &['\u{53}', '\u{30c}']),
        ('\u{161}', &['\u{73}', '\u{30c}']), ('\u{162}', &['\u{54}', '\u{327}']), ('\u{163}',
        &['\u{74}', '\u{327}']), ('\u{164}', &['\u{54}', '\u{30c}']), ('\u{165}', &['\u{74}',
        '\u{30c}']), ('\u{168}', &['\u{55}', '\u{303}']), ('\u{169}', &['\u{75}', '\u{303}']),
        ('\u{16a}', &['\u{55}', '\u{304}']), ('\u{16b}', &['\u{75}', '\u{304}']), ('\u{16c}',
        &['\u{55}', '\u{306}']), ('\u{16d}', &['\u{75}', '\u{306}']), ('\u{16e}', &['\u{55}',
        '\u{30a}']), ('\u{16f}', &['\u{75}', '\u{30a}']), ('\u{170}', &['\u{55}', '\u{30b}']),
        ('\u{171}', &['\u{75}', '\u{30b}']), ('\u{172}', &['\u{55}', '\u{328}']), ('\u{173}',
        &['\u{75}', '\u{328}']), ('\u{174}', &['\u{57}', '\u{302}']), ('\u{175}', &['\u{77}',
        '\u{302}']), ('\u{176}', &['\u{59}', '\u{302}']), ('\u{177}', &['\u{79}', '\u{302}']),
        ('\u{178}', &['\u{59}', '\u{308}']), ('\u{179}', &['\u{5a}', '\u{301}']), ('\u{17a}',
        &['\u{7a}', '\u{301}']), ('\u{17b}', &['\u{5a}', '\u{307}']), ('\u{17c}', &['\u{7a}',
        '\u{307}']), ('\u{17d}', &['\u{5a}', '\u{30c}']), ('\u{17e}', &['\u{7a}', '\u{30c}']),
        ('\u{1a0}', &['\u{4f}', '\u{31b}']), ('\u{1a1}', &['\u{6f}', '\u{31b}']), ('\u{1af}',
        &['\u{55}', '\u{31b}']), ('\u{1b0}', &['\u{75}', '\u{31b}']), ('\u{1cd}', &['\u{41}',
        '\u{30c}']), ('\u{1ce}', &['\u{61}', '\u{30c}']), ('\u{1cf}', &['\u{49}', '\u{30c}']),
        ('\u{1d0}', &['\u{69}', '\u{30c}']), ('\u{1d1}', &['\u{4f}', '\u{30c}']), ('\u{1d2}',
        &['\u{6f}', '\u{30c}']), ('\u{1d3}', &['\u{55}', '\u{30c}']), ('\u{1d4}', &['\u{75}',
        '\u{30c}']), ('\u{1d5}', &['\u{dc}', '\u{304}']), ('\u{1d6}', &['\u{fc}', '\u{304}']),
        ('\u{1d7}', &['\u{dc}', '\u{301}']), ('\u{1d8}', &['\u{fc}', '\u{301}']), ('\u{1d9}',
        &['\u{dc}', '\u{30c}']), ('\u{1da}', &['\u{fc}', '\u{30c}']), ('\u{1db}', &['\u{dc}',
        '\u{300}']), ('\u{1dc}', &['\u{fc}', '\u{300}']), ('\u{1de}', &['\u{c4}', '\u{304}']),
        ('\u{1df}', &['\u{e4}', '\u{304}']), ('\u{1e0}', &['\u{226}', '\u{304}']), ('\u{1e1}',
        &['\u{227}', '\u{304}']), ('\u{1e2}', &['\u{c6}', '\u{304}']), ('\u{1e3}', &['\u{e6}',
        '\u{304}']), ('\u{1e6}', &['\u{47}', '\u{30c}']), ('\u{1e7}', &['\u{67}', '\u{30c}']),
        ('\u{1e8}', &['\u{4b}', '\u{30c}']), ('\u{1e9}', &['\u{6b}', '\u{30c}']), ('\u{1ea}',
        &['\u{4f}', '\u{328}']), ('\u{1eb}', &['\u{6f}', '\u{328}']), ('\u{1ec}', &['\u{1ea}',
        '\u{304}']), ('\u{1ed}', &['\u{1eb}', '\u{304}']), ('\u{1ee}', &['\u{1b7}', '\u{30c}']),
        ('\u{1ef}', &['\u{292}', '\u{30c}']), ('\u{1f0}', &['\u{6a}', '\u{30c}']), ('\u{1f4}',
        &['\u{47}', '\u{301}']), ('\u{1f5}', &['\u{67}', '\u{301}']), ('\u{1f8}', &['\u{4e}',
        '\u{300}']), ('\u{1f9}', &['\u{6e}', '\u{300}']), ('\u{1fa}', &['\u{c5}', '\u{301}']),
        ('\u{1fb}', &['\u{e5}', '\u{301}']), ('\u{1fc}', &['\u{c6}', '\u{301}']), ('\u{1fd}',
        &['\u{e6}', '\u{301}']), ('\u{1fe}', &['\u{d8}', '\u{301}']), ('\u{1ff}', &['\u{f8}',
        '\u{301}']), ('\u{200}', &['\u{41}', '\u{30f}']), ('\u{201}', &['\u{61}', '\u{30f}']),
        ('\u{202}', &['\u{41}', '\u{311}']), ('\u{203}', &['\u{61}', '\u{311}']), ('\u{204}',
        &['\u{45}', '\u{30f}']), ('\u{205}', &['\u{65}', '\u{30f}']), ('\u{206}', &['\u{45}',
        '\u{311}']), ('\u{207}', &['\u{65}', '\u{311}']), ('\u{208}', &['\u{49}', '\u{30f}']),
        ('\u{209}', &['\u{69}', '\u{30f}']), ('\u{20a}', &['\u{49}', '\u{311}']), ('\u{20b}',
        &['\u{69}', '\u{311}']), ('\u{20c}', &['\u{4f}', '\u{30f}']), ('\u{20d}', &['\u{6f}',
        '\u{30f}']), ('\u{20e}', &['\u{4f}', '\u{311}']), ('\u{20f}', &['\u{6f}', '\u{311}']),
        ('\u{210}', &['\u{52}', '\u{30f}']), ('\u{211}', &['\u{72}', '\u{30f}']), ('\u{212}',
        &['\u{52}', '\u{311}']), ('\u{213}', &['\u{72}', '\u{311}']), ('\u{214}', &['\u{55}',
        '\u{30f}']), ('\u{215}', &['\u{75}', '\u{30f}']), ('\u{216}', &['\u{55}', '\u{311}']),
        ('\u{217}', &['\u{75}', '\u{311}']), ('\u{218}', &['\u{53}', '\u{326}']), ('\u{219}',
        &['\u{73}', '\u{326}']), ('\u{21a}', &['\u{54}', '\u{326}']), ('\u{21b}', &['\u{74}',
        '\u{326}']), ('\u{21e}', &['\u{48}', '\u{30c}']), ('\u{21f}', &['\u{68}', '\u{30c}']),
        ('\u{226}', &['\u{41}', '\u{307}']), ('\u{227}', &['\u{61}', '\u{307}']), ('\u{228}',
        &['\u{45}', '\u{327}']), ('\u{229}', &['\u{65}', '\u{327}']), ('\u{22a}', &['\u{d6}',
        '\u{304}']), ('\u{22b}', &['\u{f6}', '\u{304}']), ('\u{22c}', &['\u{d5}', '\u{304}']),
        ('\u{22d}', &['\u{f5}', '\u{304}']), ('\u{22e}', &['\u{4f}', '\u{307}']), ('\u{22f}',
        &['\u{6f}', '\u{307}']), ('\u{230}', &['\u{22e}', '\u{304}']), ('\u{231}', &['\u{22f}',
        '\u{304}']), ('\u{232}', &['\u{59}', '\u{304}']), ('\u{233}', &['\u{79}', '\u{304}']),
        ('\u{340}', &['\u{300}']), ('\u{341}', &['\u{301}']), ('\u{343}', &['\u{313}']), ('\u{344}',
        &['\u{308}', '\u{301}']), ('\u{374}', &['\u{2b9}']), ('\u{37e}', &['\u{3b}']), ('\u{385}',
        &['\u{a8}', '\u{301}']), ('\u{386}', &['\u{391}', '\u{301}']), ('\u{387}', &['\u{b7}']),
        ('\u{388}', &['\u{395}', '\u{301}']), ('\u{389}', &['\u{397}', '\u{301}']), ('\u{38a}',
        &['\u{399}', '\u{301}']), ('\u{38c}', &['\u{39f}', '\u{301}']), ('\u{38e}', &['\u{3a5}',
        '\u{301}']), ('\u{38f}', &['\u{3a9}', '\u{301}']), ('\u{390}', &['\u{3ca}', '\u{301}']),
        ('\u{3aa}', &['\u{399}', '\u{308}']), ('\u{3ab}', &['\u{3a5}', '\u{308}']), ('\u{3ac}',
        &['\u{3b1}', '\u{301}']), ('\u{3ad}', &['\u{3b5}', '\u{301}']), ('\u{3ae}', &['\u{3b7}',
        '\u{301}']), ('\u{3af}', &['\u{3b9}', '\u{301}']), ('\u{3b0}', &['\u{3cb}', '\u{301}']),
        ('\u{3ca}', &['\u{3b9}', '\u{308}']), ('\u{3cb}', &['\u{3c5}', '\u{308}']), ('\u{3cc}',
        &['\u{3bf}', '\u{301}']), ('\u{3cd}', &['\u{3c5}', '\u{301}']), ('\u{3ce}', &['\u{3c9}',
        '\u{301}']), ('\u{3d3}', &['\u{3d2}', '\u{301}']), ('\u{3d4}', &['\u{3d2}', '\u{308}']),
        ('\u{400}', &['\u{415}', '\u{300}']), ('\u{401}', &['\u{415}', '\u{308}']), ('\u{403}',
        &['\u{413}', '\u{301}']), ('\u{407}', &['\u{406}', '\u{308}']), ('\u{40c}', &['\u{41a}',
        '\u{301}']), ('\u{40d}', &['\u{418}', '\u{300}']), ('\u{40e}', &['\u{423}', '\u{306}']),
        ('\u{419}', &['\u{418}', '\u{306}']), ('\u{439}', &['\u{438}', '\u{306}']), ('\u{450}',
        &['\u{435}', '\u{300}']), ('\u{451}', &['\u{435}', '\u{308}']), ('\u{453}', &['\u{433}',
        '\u{301}']), ('\u{457}', &['\u{456}', '\u{308}']), ('\u{45c}', &['\u{43a}', '\u{301}']),
        ('\u{45d}', &['\u{438}', '\u{300}']), ('\u{45e}', &['\u{443}', '\u{306}']), ('\u{476}',
        &['\u{474}', '\u{30f}']), ('\u{477}', &['\u{475}', '\u{30f}']), ('\u{4c1}', &['\u{416}',
        '\u{306}']), ('\u{4c2}', &['\u{436}', '\u{306}']), ('\u{4d0}', &['\u{410}', '\u{306}']),
        ('\u{4d1}', &['\u{430}', '\u{306}']), ('\u{4d2}', &['\u{410}', '\u{308}']), ('\u{4d3}',
        &['\u{430}', '\u{308}']), ('\u{4d6}', &['\u{415}', '\u{306}']), ('\u{4d7}', &['\u{435}',
        '\u{306}']), ('\u{4da}', &['\u{4d8}', '\u{308}']), ('\u{4db}', &['\u{4d9}', '\u{308}']),
        ('\u{4dc}', &['\u{416}', '\u{308}']), ('\u{4dd}', &['\u{436}', '\u{308}']), ('\u{4de}',
        &['\u{417}', '\u{308}']), ('\u{4df}', &['\u{437}', '\u{308}']), ('\u{4e2}', &['\u{418}',
        '\u{304}']), ('\u{4e3}', &['\u{438}', '\u{304}']), ('\u{4e4}', &['\u{418}', '\u{308}']),
        ('\u{4e5}', &['\u{438}', '\u{308}']), ('\u{4e6}', &['\u{41e}', '\u{308}']), ('\u{4e7}',
        &['\u{43e}', '\u{308}']), ('\u{4ea}', &['\u{4e8}', '\u{308}']), ('\u{4eb}', &['\u{4e9}',
        '\u{308}']), ('\u{4ec}', &['\u{42d}', '\u{308}']), ('\u{4ed}', &['\u{44d}', '\u{308}']),
        ('\u{4ee}', &['\u{423}', '\u{304}']), ('\u{4ef}', &['\u{443}', '\u{304}']), ('\u{4f0}',
        &['\u{423}', '\u{308}']), ('\u{4f1}', &['\u{443}', '\u{308}']), ('\u{4f2}', &['\u{423}',
        '\u{30b}']), ('\u{4f3}', &['\u{443}', '\u{30b}']), ('\u{4f4}', &['\u{427}', '\u{308}']),
        ('\u{4f5}', &['\u{447}', '\u{308}']), ('\u{4f8}', &['\u{42b}', '\u{308}']), ('\u{4f9}',
        &['\u{44b}', '\u{308}']), ('\u{622}', &['\u{627}', '\u{653}']), ('\u{623}', &['\u{627}',
        '\u{654}']), ('\u{624}', &['\u{648}', '\u{654}']), ('\u{625}', &['\u{627}', '\u{655}']),
        ('\u{626}', &['\u{64a}', '\u{654}']), ('\u{6c0}', &['\u{6d5}', '\u{654}']), ('\u{6c2}',
        &['\u{6c1}', '\u{654}']), ('\u{6d3}', &['\u{6d2}', '\u{654}']), ('\u{929}', &['\u{928}',
        '\u{93c}']), ('\u{931}', &['\u{930}', '\u{93c}']), ('\u{934}', &['\u{933}', '\u{93c}']),
        ('\u{958}', &['\u{915}', '\u{93c}']), ('\u{959}', &['\u{916}', '\u{93c}']), ('\u{95a}',
        &['\u{917}', '\u{93c}']), ('\u{95b}', &['\u{91c}', '\u{93c}']), ('\u{95c}', &['\u{921}',
        '\u{93c}']), ('\u{95d}', &['\u{922}', '\u{93c}']), ('\u{95e}', &['\u{92b}', '\u{93c}']),
        ('\u{95f}', &['\u{92f}', '\u{93c}']), ('\u{9cb}', &['\u{9c7}', '\u{9be}']), ('\u{9cc}',
        &['\u{9c7}', '\u{9d7}']), ('\u{9dc}', &['\u{9a1}', '\u{9bc}']), ('\u{9dd}', &['\u{9a2}',
        '\u{9bc}']), ('\u{9df}', &['\u{9af}', '\u{9bc}']), ('\u{a33}', &['\u{a32}', '\u{a3c}']),
        ('\u{a36}', &['\u{a38}', '\u{a3c}']), ('\u{a59}', &['\u{a16}', '\u{a3c}']), ('\u{a5a}',
        &['\u{a17}', '\u{a3c}']), ('\u{a5b}', &['\u{a1c}', '\u{a3c}']), ('\u{a5e}', &['\u{a2b}',
        '\u{a3c}']), ('\u{b48}', &['\u{b47}', '\u{b56}']), ('\u{b4b}', &['\u{b47}', '\u{b3e}']),
        ('\u{b4c}', &['\u{b47}', '\u{b57}']), ('\u{b5c}', &['\u{b21}', '\u{b3c}']), ('\u{b5d}',
        &['\u{b22}', '\u{b3c}']), ('\u{b94}', &['\u{b92}', '\u{bd7}']), ('\u{bca}', &['\u{bc6}',
        '\u{bbe}']), ('\u{bcb}', &['\u{bc7}', '\u{bbe}']), ('\u{bcc}', &['\u{bc6}', '\u{bd7}']),
        ('\u{c48}', &['\u{c46}', '\u{c56}']), ('\u{cc0}', &['\u{cbf}', '\u{cd5}']), ('\u{cc7}',
        &['\u{cc6}', '\u{cd5}']), ('\u{cc8}', &['\u{cc6}', '\u{cd6}']), ('\u{cca}', &['\u{cc6}',
        '\u{cc2}']), ('\u{ccb}', &['\u{cca}', '\u{cd5}']), ('\u{d4a}', &['\u{d46}', '\u{d3e}']),
        ('\u{d4b}', &['\u{d47}', '\u{d3e}']), ('\u{d4c}', &['\u{d46}', '\u{d57}']), ('\u{dda}',
        &['\u{dd9}', '\u{dca}']), ('\u{ddc}', &['\u{dd9}', '\u{dcf}']), ('\u{ddd}', &['\u{ddc}',
        '\u{dca}']), ('\u{dde}', &['\u{dd9}', '\u{ddf}']), ('\u{f43}', &['\u{f42}', '\u{fb7}']),
        ('\u{f4d}', &['\u{f4c}', '\u{fb7}']), ('\u{f52}', &['\u{f51}', '\u{fb7}']), ('\u{f57}',
        &['\u{f56}', '\u{fb7}']), ('\u{f5c}', &['\u{f5b}', '\u{fb7}']), ('\u{f69}', &['\u{f40}',
        '\u{fb5}']), ('\u{f73}', &['\u{f71}', '\u{f72}']), ('\u{f75}', &['\u{f71}', '\u{f74}']),
        ('\u{f76}', &['\u{fb2}', '\u{f80}']), ('\u{f78}', &['\u{fb3}', '\u{f80}']), ('\u{f81}',
        &['\u{f71}', '\u{f80}']), ('\u{f93}', &['\u{f92}', '\u{fb7}']), ('\u{f9d}', &['\u{f9c}',
        '\u{fb7}']), ('\u{fa2}', &['\u{fa1}', '\u{fb7}']), ('\u{fa7}', &['\u{fa6}', '\u{fb7}']),
        ('\u{fac}', &['\u{fab}', '\u{fb7}']), ('\u{fb9}', &['\u{f90}', '\u{fb5}']), ('\u{1026}',
        &['\u{1025}', '\u{102e}']), ('\u{1b06}', &['\u{1b05}', '\u{1b35}']), ('\u{1b08}',
        &['\u{1b07}', '\u{1b35}']), ('\u{1b0a}', &['\u{1b09}', '\u{1b35}']), ('\u{1b0c}',
        &['\u{1b0b}', '\u{1b35}']), ('\u{1b0e}', &['\u{1b0d}', '\u{1b35}']), ('\u{1b12}',
        &['\u{1b11}', '\u{1b35}']), ('\u{1b3b}', &['\u{1b3a}', '\u{1b35}']), ('\u{1b3d}',
        &['\u{1b3c}', '\u{1b35}']), ('\u{1b40}', &['\u{1b3e}', '\u{1b35}']), ('\u{1b41}',
        &['\u{1b3f}', '\u{1b35}']), ('\u{1b43}', &['\u{1b42}', '\u{1b35}']), ('\u{1e00}',
        &['\u{41}', '\u{325}']), ('\u{1e01}', &['\u{61}', '\u{325}']), ('\u{1e02}', &['\u{42}',
        '\u{307}']), ('\u{1e03}', &['\u{62}', '\u{307}']), ('\u{1e04}', &['\u{42}', '\u{323}']),
        ('\u{1e05}', &['\u{62}', '\u{323}']), ('\u{1e06}', &['\u{42}', '\u{331}']), ('\u{1e07}',
        &['\u{62}', '\u{331}']), ('\u{1e08}', &['\u{c7}', '\u{301}']), ('\u{1e09}', &['\u{e7}',
        '\u{301}']), ('\u{1e0a}', &['\u{44}', '\u{307}']), ('\u{1e0b}', &['\u{64}', '\u{307}']),
        ('\u{1e0c}', &['\u{44}', '\u{323}']), ('\u{1e0d}', &['\u{64}', '\u{323}']), ('\u{1e0e}',
        &['\u{44}', '\u{331}']), ('\u{1e0f}', &['\u{64}', '\u{331}']), ('\u{1e10}', &['\u{44}',
        '\u{327}']), ('\u{1e11}', &['\u{64}', '\u{327}']), ('\u{1e12}', &['\u{44}', '\u{32d}']),
        ('\u{1e13}', &['\u{64}', '\u{32d}']), ('\u{1e14}', &['\u{112}', '\u{300}']), ('\u{1e15}',
        &['\u{113}', '\u{300}']), ('\u{1e16}', &['\u{112}', '\u{301}']), ('\u{1e17}', &['\u{113}',
        '\u{301}']), ('\u{1e18}', &['\u{45}', '\u{32d}']), ('\u{1e19}', &['\u{65}', '\u{32d}']),
        ('\u{1e1a}', &['\u{45}', '\u{330}']), ('\u{1e1b}', &['\u{65}', '\u{330}']), ('\u{1e1c}',
        &['\u{228}', '\u{306}']), ('\u{1e1d}', &['\u{229}', '\u{306}']), ('\u{1e1e}', &['\u{46}',
        '\u{307}']), ('\u{1e1f}', &['\u{66}', '\u{307}']), ('\u{1e20}', &['\u{47}', '\u{304}']),
        ('\u{1e21}', &['\u{67}', '\u{304}']), ('\u{1e22}', &['\u{48}', '\u{307}']), ('\u{1e23}',
        &['\u{68}', '\u{307}']), ('\u{1e24}', &['\u{48}', '\u{323}']), ('\u{1e25}', &['\u{68}',
        '\u{323}']), ('\u{1e26}', &['\u{48}', '\u{308}']), ('\u{1e27}', &['\u{68}', '\u{308}']),
        ('\u{1e28}', &['\u{48}', '\u{327}']), ('\u{1e29}', &['\u{68}', '\u{327}']), ('\u{1e2a}',
        &['\u{48}', '\u{32e}']), ('\u{1e2b}', &['\u{68}', '\u{32e}']), ('\u{1e2c}', &['\u{49}',
        '\u{330}']), ('\u{1e2d}', &['\u{69}', '\u{330}']), ('\u{1e2e}', &['\u{cf}', '\u{301}']),
        ('\u{1e2f}', &['\u{ef}', '\u{301}']), ('\u{1e30}', &['\u{4b}', '\u{301}']), ('\u{1e31}',
        &['\u{6b}', '\u{301}']), ('\u{1e32}', &['\u{4b}', '\u{323}']), ('\u{1e33}', &['\u{6b}',
        '\u{323}']), ('\u{1e34}', &['\u{4b}', '\u{331}']), ('\u{1e35}', &['\u{6b}', '\u{331}']),
        ('\u{1e36}', &['\u{4c}', '\u{323}']), ('\u{1e37}', &['\u{6c}', '\u{323}']), ('\u{1e38}',
        &['\u{1e36}', '\u{304}']), ('\u{1e39}', &['\u{1e37}', '\u{304}']), ('\u{1e3a}', &['\u{4c}',
        '\u{331}']), ('\u{1e3b}', &['\u{6c}', '\u{331}']), ('\u{1e3c}', &['\u{4c}', '\u{32d}']),
        ('\u{1e3d}', &['\u{6c}', '\u{32d}']), ('\u{1e3e}', &['\u{4d}', '\u{301}']), ('\u{1e3f}',
        &['\u{6d}', '\u{301}']), ('\u{1e40}', &['\u{4d}', '\u{307}']), ('\u{1e41}', &['\u{6d}',
        '\u{307}']), ('\u{1e42}', &['\u{4d}', '\u{323}']), ('\u{1e43}', &['\u{6d}', '\u{323}']),
        ('\u{1e44}', &['\u{4e}', '\u{307}']), ('\u{1e45}', &['\u{6e}', '\u{307}']), ('\u{1e46}',
        &['\u{4e}', '\u{323}']), ('\u{1e47}', &['\u{6e}', '\u{323}']), ('\u{1e48}', &['\u{4e}',
        '\u{331}']), ('\u{1e49}', &['\u{6e}', '\u{331}']), ('\u{1e4a}', &['\u{4e}', '\u{32d}']),
        ('\u{1e4b}', &['\u{6e}', '\u{32d}']), ('\u{1e4c}', &['\u{d5}', '\u{301}']), ('\u{1e4d}',
        &['\u{f5}', '\u{301}']), ('\u{1e4e}', &['\u{d5}', '\u{308}']), ('\u{1e4f}', &['\u{f5}',
        '\u{308}']), ('\u{1e50}', &['\u{14c}', '\u{300}']), ('\u{1e51}', &['\u{14d}', '\u{300}']),
        ('\u{1e52}', &['\u{14c}', '\u{301}']), ('\u{1e53}', &['\u{14d}', '\u{301}']), ('\u{1e54}',
        &['\u{50}', '\u{301}']), ('\u{1e55}', &['\u{70}', '\u{301}']), ('\u{1e56}', &['\u{50}',
        '\u{307}']), ('\u{1e57}', &['\u{70}', '\u{307}']), ('\u{1e58}', &['\u{52}', '\u{307}']),
        ('\u{1e59}', &['\u{72}', '\u{307}']), ('\u{1e5a}', &['\u{52}', '\u{323}']), ('\u{1e5b}',
        &['\u{72}', '\u{323}']), ('\u{1e5c}', &['\u{1e5a}', '\u{304}']), ('\u{1e5d}', &['\u{1e5b}',
        '\u{304}']), ('\u{1e5e}', &['\u{52}', '\u{331}']), ('\u{1e5f}', &['\u{72}', '\u{331}']),
        ('\u{1e60}', &['\u{53}', '\u{307}']), ('\u{1e61}', &['\u{73}', '\u{307}']), ('\u{1e62}',
        &['\u{53}', '\u{323}']), ('\u{1e63}', &['\u{73}', '\u{323}']), ('\u{1e64}', &['\u{15a}',
        '\u{307}']), ('\u{1e65}', &['\u{15b}', '\u{307}']), ('\u{1e66}', &['\u{160}', '\u{307}']),
        ('\u{1e67}', &['\u{161}', '\u{307}']), ('\u{1e68}', &['\u{1e62}', '\u{307}']), ('\u{1e69}',
        &['\u{1e63}', '\u{307}']), ('\u{1e6a}', &['\u{54}', '\u{307}']), ('\u{1e6b}', &['\u{74}',
        '\u{307}']), ('\u{1e6c}', &['\u{54}', '\u{323}']), ('\u{1e6d}', &['\u{74}', '\u{323}']),
        ('\u{1e6e}', &['\u{54}', '\u{331}']), ('\u{1e6f}', &['\u{74}', '\u{331}']), ('\u{1e70}',
        &['\u{54}', '\u{32d}']), ('\u{1e71}', &['\u{74}', '\u{32d}']), ('\u{1e72}', &['\u{55}',
        '\u{324}']), ('\u{1e73}', &['\u{75}', '\u{324}']), ('\u{1e74}', &['\u{55}', '\u{330}']),
        ('\u{1e75}', &['\u{75}', '\u{330}']), ('\u{1e76}', &['\u{55}', '\u{32d}']), ('\u{1e77}',
        &['\u{75}', '\u{32d}']), ('\u{1e78}', &['\u{168}', '\u{301}']), ('\u{1e79}', &['\u{169}',
        '\u{301}']), ('\u{1e7a}', &['\u{16a}', '\u{308}']), ('\u{1e7b}', &['\u{16b}', '\u{308}']),
        ('\u{1e7c}', &['\u{56}', '\u{303}']), ('\u{1e7d}', &['\u{76}', '\u{303}']), ('\u{1e7e}',
        &['\u{56}', '\u{323}']), ('\u{1e7f}', &['\u{76}', '\u{323}']), ('\u{1e80}', &['\u{57}',
        '\u{300}']), ('\u{1e81}', &['\u{77}', '\u{300}']), ('\u{1e82}', &['\u{57}', '\u{301}']),
        ('\u{1e83}', &['\u{77}', '\u{301}']), ('\u{1e84}', &['\u{57}', '\u{308}']), ('\u{1e85}',
        &['\u{77}', '\u{308}']), ('\u{1e86}', &['\u{57}', '\u{307}']), ('\u{1e87}', &['\u{77}',
        '\u{307}']), ('\u{1e88}', &['\u{57}', '\u{323}']), ('\u{1e89}', &['\u{77}', '\u{323}']),
        ('\u{1e8a}', &['\u{58}', '\u{307}']), ('\u{1e8b}', &['\u{78}', '\u{307}']), ('\u{1e8c}',
        &['\u{58}', '\u{308}']), ('\u{1e8d}', &['\u{78}', '\u{308}']), ('\u{1e8e}', &['\u{59}',
        '\u{307}']), ('\u{1e8f}', &['\u{79}', '\u{307}']), ('\u{1e90}', &['\u{5a}', '\u{302}']),
        ('\u{1e91}', &['\u{7a}', '\u{302}']), ('\u{1e92}', &['\u{5a}', '\u{323}']), ('\u{1e93}',
        &['\u{7a}', '\u{323}']), ('\u{1e94}', &['\u{5a}', '\u{331}']), ('\u{1e95}', &['\u{7a}',
        '\u{331}']), ('\u{1e96}', &['\u{68}', '\u{331}']), ('\u{1e97}', &['\u{74}', '\u{308}']),
        ('\u{1e98}', &['\u{77}', '\u{30a}']), ('\u{1e99}', &['\u{79}', '\u{30a}']), ('\u{1e9b}',
        &['\u{17f}', '\u{307}']), ('\u{1ea0}', &['\u{41}', '\u{323}']), ('\u{1ea1}', &['\u{61}',
        '\u{323}']), ('\u{1ea2}', &['\u{41}', '\u{309}']), ('\u{1ea3}', &['\u{61}', '\u{309}']),
        ('\u{1ea4}', &['\u{c2}', '\u{301}']), ('\u{1ea5}', &['\u{e2}', '\u{301}']), ('\u{1ea6}',
        &['\u{c2}', '\u{300}']), ('\u{1ea7}', &['\u{e2}', '\u{300}']), ('\u{1ea8}', &['\u{c2}',
        '\u{309}']), ('\u{1ea9}', &['\u{e2}', '\u{309}']), ('\u{1eaa}', &['\u{c2}', '\u{303}']),
        ('\u{1eab}', &['\u{e2}', '\u{303}']), ('\u{1eac}', &['\u{1ea0}', '\u{302}']), ('\u{1ead}',
        &['\u{1ea1}', '\u{302}']), ('\u{1eae}', &['\u{102}', '\u{301}']), ('\u{1eaf}', &['\u{103}',
        '\u{301}']), ('\u{1eb0}', &['\u{102}', '\u{300}']), ('\u{1eb1}', &['\u{103}', '\u{300}']),
        ('\u{1eb2}', &['\u{102}', '\u{309}']), ('\u{1eb3}', &['\u{103}', '\u{309}']), ('\u{1eb4}',
        &['\u{102}', '\u{303}']), ('\u{1eb5}', &['\u{103}', '\u{303}']), ('\u{1eb6}', &['\u{1ea0}',
        '\u{306}']), ('\u{1eb7}', &['\u{1ea1}', '\u{306}']), ('\u{1eb8}', &['\u{45}', '\u{323}']),
        ('\u{1eb9}', &['\u{65}', '\u{323}']), ('\u{1eba}', &['\u{45}', '\u{309}']), ('\u{1ebb}',
        &['\u{65}', '\u{309}']), ('\u{1ebc}', &['\u{45}', '\u{303}']), ('\u{1ebd}', &['\u{65}',
        '\u{303}']), ('\u{1ebe}', &['\u{ca}', '\u{301}']), ('\u{1ebf}', &['\u{ea}', '\u{301}']),
        ('\u{1ec0}', &['\u{ca}', '\u{300}']), ('\u{1ec1}', &['\u{ea}', '\u{300}']), ('\u{1ec2}',
        &['\u{ca}', '\u{309}']), ('\u{1ec3}', &['\u{ea}', '\u{309}']), ('\u{1ec4}', &['\u{ca}',
        '\u{303}']), ('\u{1ec5}', &['\u{ea}', '\u{303}']), ('\u{1ec6}', &['\u{1eb8}', '\u{302}']),
        ('\u{1ec7}', &['\u{1eb9}', '\u{302}']), ('\u{1ec8}', &['\u{49}', '\u{309}']), ('\u{1ec9}',
        &['\u{69}', '\u{309}']), ('\u{1eca}', &['\u{49}', '\u{323}']), ('\u{1ecb}', &['\u{69}',
        '\u{323}']), ('\u{1ecc}', &['\u{4f}', '\u{323}']), ('\u{1ecd}', &['\u{6f}', '\u{323}']),
        ('\u{1ece}', &['\u{4f}', '\u{309}']), ('\u{1ecf}', &['\u{6f}', '\u{309}']), ('\u{1ed0}',
        &['\u{d4}', '\u{301}']), ('\u{1ed1}', &['\u{f4}', '\u{301}']), ('\u{1ed2}', &['\u{d4}',
        '\u{300}']), ('\u{1ed3}', &['\u{f4}', '\u{300}']), ('\u{1ed4}', &['\u{d4}', '\u{309}']),
        ('\u{1ed5}', &['\u{f4}', '\u{309}']), ('\u{1ed6}', &['\u{d4}', '\u{303}']), ('\u{1ed7}',
        &['\u{f4}', '\u{303}']), ('\u{1ed8}', &['\u{1ecc}', '\u{302}']), ('\u{1ed9}', &['\u{1ecd}',
        '\u{302}']), ('\u{1eda}', &['\u{1a0}', '\u{301}']), ('\u{1edb}', &['\u{1a1}', '\u{301}']),
        ('\u{1edc}', &['\u{1a0}', '\u{300}']), ('\u{1edd}', &['\u{1a1}', '\u{300}']), ('\u{1ede}',
        &['\u{1a0}', '\u{309}']), ('\u{1edf}', &['\u{1a1}', '\u{309}']), ('\u{1ee0}', &['\u{1a0}',
        '\u{303}']), ('\u{1ee1}', &['\u{1a1}', '\u{303}']), ('\u{1ee2}', &['\u{1a0}', '\u{323}']),
        ('\u{1ee3}', &['\u{1a1}', '\u{323}']), ('\u{1ee4}', &['\u{55}', '\u{323}']), ('\u{1ee5}',
        &['\u{75}', '\u{323}']), ('\u{1ee6}', &['\u{55}', '\u{309}']), ('\u{1ee7}', &['\u{75}',
        '\u{309}']), ('\u{1ee8}', &['\u{1af}', '\u{301}']), ('\u{1ee9}', &['\u{1b0}', '\u{301}']),
        ('\u{1eea}', &['\u{1af}', '\u{300}']), ('\u{1eeb}', &['\u{1b0}', '\u{300}']), ('\u{1eec}',
        &['\u{1af}', '\u{309}']), ('\u{1eed}', &['\u{1b0}', '\u{309}']), ('\u{1eee}', &['\u{1af}',
        '\u{303}']), ('\u{1eef}', &['\u{1b0}', '\u{303}']), ('\u{1ef0}', &['\u{1af}', '\u{323}']),
        ('\u{1ef1}', &['\u{1b0}', '\u{323}']), ('\u{1ef2}', &['\u{59}', '\u{300}']), ('\u{1ef3}',
        &['\u{79}', '\u{300}']), ('\u{1ef4}', &['\u{59}', '\u{323}']), ('\u{1ef5}', &['\u{79}',
        '\u{323}']), ('\u{1ef6}', &['\u{59}', '\u{309}']), ('\u{1ef7}', &['\u{79}', '\u{309}']),
        ('\u{1ef8}', &['\u{59}', '\u{303}']), ('\u{1ef9}', &['\u{79}', '\u{303}']), ('\u{1f00}',
        &['\u{3b1}', '\u{313}']), ('\u{1f01}', &['\u{3b1}', '\u{314}']), ('\u{1f02}', &['\u{1f00}',
        '\u{300}']), ('\u{1f03}', &['\u{1f01}', '\u{300}']), ('\u{1f04}', &['\u{1f00}', '\u{301}']),
        ('\u{1f05}', &['\u{1f01}', '\u{301}']), ('\u{1f06}', &['\u{1f00}', '\u{342}']), ('\u{1f07}',
        &['\u{1f01}', '\u{342}']), ('\u{1f08}', &['\u{391}', '\u{313}']), ('\u{1f09}', &['\u{391}',
        '\u{314}']), ('\u{1f0a}', &['\u{1f08}', '\u{300}']), ('\u{1f0b}', &['\u{1f09}', '\u{300}']),
        ('\u{1f0c}', &['\u{1f08}', '\u{301}']), ('\u{1f0d}', &['\u{1f09}', '\u{301}']), ('\u{1f0e}',
        &['\u{1f08}', '\u{342}']), ('\u{1f0f}', &['\u{1f09}', '\u{342}']), ('\u{1f10}', &['\u{3b5}',
        '\u{313}']), ('\u{1f11}', &['\u{3b5}', '\u{314}']), ('\u{1f12}', &['\u{1f10}', '\u{300}']),
        ('\u{1f13}', &['\u{1f11}', '\u{300}']), ('\u{1f14}', &['\u{1f10}', '\u{301}']), ('\u{1f15}',
        &['\u{1f11}', '\u{301}']), ('\u{1f18}', &['\u{395}', '\u{313}']), ('\u{1f19}', &['\u{395}',
        '\u{314}']), ('\u{1f1a}', &['\u{1f18}', '\u{300}']), ('\u{1f1b}', &['\u{1f19}', '\u{300}']),
        ('\u{1f1c}', &['\u{1f18}', '\u{301}']), ('\u{1f1d}', &['\u{1f19}', '\u{301}']), ('\u{1f20}',
        &['\u{3b7}', '\u{313}']), ('\u{1f21}', &['\u{3b7}', '\u{314}']), ('\u{1f22}', &['\u{1f20}',
        '\u{300}']), ('\u{1f23}', &['\u{1f21}', '\u{300}']), ('\u{1f24}', &['\u{1f20}', '\u{301}']),
        ('\u{1f25}', &['\u{1f21}', '\u{301}']), ('\u{1f26}', &['\u{1f20}', '\u{342}']), ('\u{1f27}',
        &['\u{1f21}', '\u{342}']), ('\u{1f28}', &['\u{397}', '\u{313}']), ('\u{1f29}', &['\u{397}',
        '\u{314}']), ('\u{1f2a}', &['\u{1f28}', '\u{300}']), ('\u{1f2b}', &['\u{1f29}', '\u{300}']),
        ('\u{1f2c}', &['\u{1f28}', '\u{301}']), ('\u{1f2d}', &['\u{1f29}', '\u{301}']), ('\u{1f2e}',
        &['\u{1f28}', '\u{342}']), ('\u{1f2f}', &['\u{1f29}', '\u{342}']), ('\u{1f30}', &['\u{3b9}',
        '\u{313}']), ('\u{1f31}', &['\u{3b9}', '\u{314}']), ('\u{1f32}', &['\u{1f30}', '\u{300}']),
        ('\u{1f33}', &['\u{1f31}', '\u{300}']), ('\u{1f34}', &['\u{1f30}', '\u{301}']), ('\u{1f35}',
        &['\u{1f31}', '\u{301}']), ('\u{1f36}', &['\u{1f30}', '\u{342}']), ('\u{1f37}',
        &['\u{1f31}', '\u{342}']), ('\u{1f38}', &['\u{399}', '\u{313}']), ('\u{1f39}', &['\u{399}',
        '\u{314}']), ('\u{1f3a}', &['\u{1f38}', '\u{300}']), ('\u{1f3b}', &['\u{1f39}', '\u{300}']),
        ('\u{1f3c}', &['\u{1f38}', '\u{301}']), ('\u{1f3d}', &['\u{1f39}', '\u{301}']), ('\u{1f3e}',
        &['\u{1f38}', '\u{342}']), ('\u{1f3f}', &['\u{1f39}', '\u{342}']), ('\u{1f40}', &['\u{3bf}',
        '\u{313}']), ('\u{1f41}', &['\u{3bf}', '\u{314}']), ('\u{1f42}', &['\u{1f40}', '\u{300}']),
        ('\u{1f43}', &['\u{1f41}', '\u{300}']), ('\u{1f44}', &['\u{1f40}', '\u{301}']), ('\u{1f45}',
        &['\u{1f41}', '\u{301}']), ('\u{1f48}', &['\u{39f}', '\u{313}']), ('\u{1f49}', &['\u{39f}',
        '\u{314}']), ('\u{1f4a}', &['\u{1f48}', '\u{300}']), ('\u{1f4b}', &['\u{1f49}', '\u{300}']),
        ('\u{1f4c}', &['\u{1f48}', '\u{301}']), ('\u{1f4d}', &['\u{1f49}', '\u{301}']), ('\u{1f50}',
        &['\u{3c5}', '\u{313}']), ('\u{1f51}', &['\u{3c5}', '\u{314}']), ('\u{1f52}', &['\u{1f50}',
        '\u{300}']), ('\u{1f53}', &['\u{1f51}', '\u{300}']), ('\u{1f54}', &['\u{1f50}', '\u{301}']),
        ('\u{1f55}', &['\u{1f51}', '\u{301}']), ('\u{1f56}', &['\u{1f50}', '\u{342}']), ('\u{1f57}',
        &['\u{1f51}', '\u{342}']), ('\u{1f59}', &['\u{3a5}', '\u{314}']), ('\u{1f5b}', &['\u{1f59}',
        '\u{300}']), ('\u{1f5d}', &['\u{1f59}', '\u{301}']), ('\u{1f5f}', &['\u{1f59}', '\u{342}']),
        ('\u{1f60}', &['\u{3c9}', '\u{313}']), ('\u{1f61}', &['\u{3c9}', '\u{314}']), ('\u{1f62}',
        &['\u{1f60}', '\u{300}']), ('\u{1f63}', &['\u{1f61}', '\u{300}']), ('\u{1f64}',
        &['\u{1f60}', '\u{301}']), ('\u{1f65}', &['\u{1f61}', '\u{301}']), ('\u{1f66}',
        &['\u{1f60}', '\u{342}']), ('\u{1f67}', &['\u{1f61}', '\u{342}']), ('\u{1f68}', &['\u{3a9}',
        '\u{313}']), ('\u{1f69}', &['\u{3a9}', '\u{314}']), ('\u{1f6a}', &['\u{1f68}', '\u{300}']),
        ('\u{1f6b}', &['\u{1f69}', '\u{300}']), ('\u{1f6c}', &['\u{1f68}', '\u{301}']), ('\u{1f6d}',
        &['\u{1f69}', '\u{301}']), ('\u{1f6e}', &['\u{1f68}', '\u{342}']), ('\u{1f6f}',
        &['\u{1f69}', '\u{342}']), ('\u{1f70}', &['\u{3b1}', '\u{300}']), ('\u{1f71}',
        &['\u{3ac}']), ('\u{1f72}', &['\u{3b5}', '\u{300}']), ('\u{1f73}', &['\u{3ad}']),
        ('\u{1f74}', &['\u{3b7}', '\u{300}']), ('\u{1f75}', &['\u{3ae}']), ('\u{1f76}', &['\u{3b9}',
        '\u{300}']), ('\u{1f77}', &['\u{3af}']), ('\u{1f78}', &['\u{3bf}', '\u{300}']), ('\u{1f79}',
        &['\u{3cc}']), ('\u{1f7a}', &['\u{3c5}', '\u{300}']), ('\u{1f7b}', &['\u{3cd}']),
        ('\u{1f7c}', &['\u{3c9}', '\u{300}']), ('\u{1f7d}', &['\u{3ce}']), ('\u{1f80}',
        &['\u{1f00}', '\u{345}']), ('\u{1f81}', &['\u{1f01}', '\u{345}']), ('\u{1f82}',
        &['\u{1f02}', '\u{345}']), ('\u{1f83}', &['\u{1f03}', '\u{345}']), ('\u{1f84}',
        &['\u{1f04}', '\u{345}']), ('\u{1f85}', &['\u{1f05}', '\u{345}']), ('\u{1f86}',
        &['\u{1f06}', '\u{345}']), ('\u{1f87}', &['\u{1f07}', '\u{345}']), ('\u{1f88}',
        &['\u{1f08}', '\u{345}']), ('\u{1f89}', &['\u{1f09}', '\u{345}']), ('\u{1f8a}',
        &['\u{1f0a}', '\u{345}']), ('\u{1f8b}', &['\u{1f0b}', '\u{345}']), ('\u{1f8c}',
        &['\u{1f0c}', '\u{345}']), ('\u{1f8d}', &['\u{1f0d}', '\u{345}']), ('\u{1f8e}',
        &['\u{1f0e}', '\u{345}']), ('\u{1f8f}', &['\u{1f0f}', '\u{345}']), ('\u{1f90}',
        &['\u{1f20}', '\u{345}']), ('\u{1f91}', &['\u{1f21}', '\u{345}']), ('\u{1f92}',
        &['\u{1f22}', '\u{345}']), ('\u{1f93}', &['\u{1f23}', '\u{345}']), ('\u{1f94}',
        &['\u{1f24}', '\u{345}']), ('\u{1f95}', &['\u{1f25}', '\u{345}']), ('\u{1f96}',
        &['\u{1f26}', '\u{345}']), ('\u{1f97}', &['\u{1f27}', '\u{345}']), ('\u{1f98}',
        &['\u{1f28}', '\u{345}']), ('\u{1f99}', &['\u{1f29}', '\u{345}']), ('\u{1f9a}',
        &['\u{1f2a}', '\u{345}']), ('\u{1f9b}', &['\u{1f2b}', '\u{345}']), ('\u{1f9c}',
        &['\u{1f2c}', '\u{345}']), ('\u{1f9d}', &['\u{1f2d}', '\u{345}']), ('\u{1f9e}',
        &['\u{1f2e}', '\u{345}']), ('\u{1f9f}', &['\u{1f2f}', '\u{345}']), ('\u{1fa0}',
        &['\u{1f60}', '\u{345}']), ('\u{1fa1}', &['\u{1f61}', '\u{345}']), ('\u{1fa2}',
        &['\u{1f62}', '\u{345}']), ('\u{1fa3}', &['\u{1f63}', '\u{345}']), ('\u{1fa4}',
        &['\u{1f64}', '\u{345}']), ('\u{1fa5}', &['\u{1f65}', '\u{345}']), ('\u{1fa6}',
        &['\u{1f66}', '\u{345}']), ('\u{1fa7}', &['\u{1f67}', '\u{345}']), ('\u{1fa8}',
        &['\u{1f68}', '\u{345}']), ('\u{1fa9}', &['\u{1f69}', '\u{345}']), ('\u{1faa}',
        &['\u{1f6a}', '\u{345}']), ('\u{1fab}', &['\u{1f6b}', '\u{345}']), ('\u{1fac}',
        &['\u{1f6c}', '\u{345}']), ('\u{1fad}', &['\u{1f6d}', '\u{345}']), ('\u{1fae}',
        &['\u{1f6e}', '\u{345}']), ('\u{1faf}', &['\u{1f6f}', '\u{345}']), ('\u{1fb0}', &['\u{3b1}',
        '\u{306}']), ('\u{1fb1}', &['\u{3b1}', '\u{304}']), ('\u{1fb2}', &['\u{1f70}', '\u{345}']),
        ('\u{1fb3}', &['\u{3b1}', '\u{345}']), ('\u{1fb4}', &['\u{3ac}', '\u{345}']), ('\u{1fb6}',
        &['\u{3b1}', '\u{342}']), ('\u{1fb7}', &['\u{1fb6}', '\u{345}']), ('\u{1fb8}', &['\u{391}',
        '\u{306}']), ('\u{1fb9}', &['\u{391}', '\u{304}']), ('\u{1fba}', &['\u{391}', '\u{300}']),
        ('\u{1fbb}', &['\u{386}']), ('\u{1fbc}', &['\u{391}', '\u{345}']), ('\u{1fbe}',
        &['\u{3b9}']), ('\u{1fc1}', &['\u{a8}', '\u{342}']), ('\u{1fc2}', &['\u{1f74}', '\u{345}']),
        ('\u{1fc3}', &['\u{3b7}', '\u{345}']), ('\u{1fc4}', &['\u{3ae}', '\u{345}']), ('\u{1fc6}',
        &['\u{3b7}', '\u{342}']), ('\u{1fc7}', &['\u{1fc6}', '\u{345}']), ('\u{1fc8}', &['\u{395}',
        '\u{300}']), ('\u{1fc9}', &['\u{388}']), ('\u{1fca}', &['\u{397}', '\u{300}']), ('\u{1fcb}',
        &['\u{389}']), ('\u{1fcc}', &['\u{397}', '\u{345}']), ('\u{1fcd}', &['\u{1fbf}',
        '\u{300}']), ('\u{1fce}', &['\u{1fbf}', '\u{301}']), ('\u{1fcf}', &['\u{1fbf}', '\u{342}']),
        ('\u{1fd0}', &['\u{3b9}', '\u{306}']), ('\u{1fd1}', &['\u{3b9}', '\u{304}']), ('\u{1fd2}',
        &['\u{3ca}', '\u{300}']), ('\u{1fd3}', &['\u{390}']), ('\u{1fd6}', &['\u{3b9}', '\u{342}']),
        ('\u{1fd7}', &['\u{3ca}', '\u{342}']), ('\u{1fd8}', &['\u{399}', '\u{306}']), ('\u{1fd9}',
        &['\u{399}', '\u{304}']), ('\u{1fda}', &['\u{399}', '\u{300}']), ('\u{1fdb}', &['\u{38a}']),
        ('\u{1fdd}', &['\u{1ffe}', '\u{300}']), ('\u{1fde}', &['\u{1ffe}', '\u{301}']), ('\u{1fdf}',
        &['\u{1ffe}', '\u{342}']), ('\u{1fe0}', &['\u{3c5}', '\u{306}']), ('\u{1fe1}', &['\u{3c5}',
        '\u{304}']), ('\u{1fe2}', &['\u{3cb}', '\u{300}']), ('\u{1fe3}', &['\u{3b0}']), ('\u{1fe4}',
        &['\u{3c1}', '\u{313}']), ('\u{1fe5}', &['\u{3c1}', '\u{314}']), ('\u{1fe6}', &['\u{3c5}',
        '\u{342}']), ('\u{1fe7}', &['\u{3cb}', '\u{342}']), ('\u{1fe8}', &['\u{3a5}', '\u{306}']),
        ('\u{1fe9}', &['\u{3a5}', '\u{304}']), ('\u{1fea}', &['\u{3a5}', '\u{300}']), ('\u{1feb}',
        &['\u{38e}']), ('\u{1fec}', &['\u{3a1}', '\u{314}']), ('\u{1fed}', &['\u{a8}', '\u{300}']),
        ('\u{1fee}', &['\u{385}']), ('\u{1fef}', &['\u{60}']), ('\u{1ff2}', &['\u{1f7c}',
        '\u{345}']), ('\u{1ff3}', &['\u{3c9}', '\u{345}']), ('\u{1ff4}', &['\u{3ce}', '\u{345}']),
        ('\u{1ff6}', &['\u{3c9}', '\u{342}']), ('\u{1ff7}', &['\u{1ff6}', '\u{345}']), ('\u{1ff8}',
        &['\u{39f}', '\u{300}']), ('\u{1ff9}', &['\u{38c}']), ('\u{1ffa}', &['\u{3a9}', '\u{300}']),
        ('\u{1ffb}', &['\u{38f}']), ('\u{1ffc}', &['\u{3a9}', '\u{345}']), ('\u{1ffd}',
        &['\u{b4}']), ('\u{2000}', &['\u{2002}']), ('\u{2001}', &['\u{2003}']), ('\u{2126}',
        &['\u{3a9}']), ('\u{212a}', &['\u{4b}']), ('\u{212b}', &['\u{c5}']), ('\u{219a}',
        &['\u{2190}', '\u{338}']), ('\u{219b}', &['\u{2192}', '\u{338}']), ('\u{21ae}',
        &['\u{2194}', '\u{338}']), ('\u{21cd}', &['\u{21d0}', '\u{338}']), ('\u{21ce}',
        &['\u{21d4}', '\u{338}']), ('\u{21cf}', &['\u{21d2}', '\u{338}']), ('\u{2204}',
        &['\u{2203}', '\u{338}']), ('\u{2209}', &['\u{2208}', '\u{338}']), ('\u{220c}',
        &['\u{220b}', '\u{338}']), ('\u{2224}', &['\u{2223}', '\u{338}']), ('\u{2226}',
        &['\u{2225}', '\u{338}']), ('\u{2241}', &['\u{223c}', '\u{338}']), ('\u{2244}',
        &['\u{2243}', '\u{338}']), ('\u{2247}', &['\u{2245}', '\u{338}']), ('\u{2249}',
        &['\u{2248}', '\u{338}']), ('\u{2260}', &['\u{3d}', '\u{338}']), ('\u{2262}', &['\u{2261}',
        '\u{338}']), ('\u{226d}', &['\u{224d}', '\u{338}']), ('\u{226e}', &['\u{3c}', '\u{338}']),
        ('\u{226f}', &['\u{3e}', '\u{338}']), ('\u{2270}', &['\u{2264}', '\u{338}']), ('\u{2271}',
        &['\u{2265}', '\u{338}']), ('\u{2274}', &['\u{2272}', '\u{338}']), ('\u{2275}',
        &['\u{2273}', '\u{338}']), ('\u{2278}', &['\u{2276}', '\u{338}']), ('\u{2279}',
        &['\u{2277}', '\u{338}']), ('\u{2280}', &['\u{227a}', '\u{338}']), ('\u{2281}',
        &['\u{227b}', '\u{338}']), ('\u{2284}', &['\u{2282}', '\u{338}']), ('\u{2285}',
        &['\u{2283}', '\u{338}']), ('\u{2288}', &['\u{2286}', '\u{338}']), ('\u{2289}',
        &['\u{2287}', '\u{338}']), ('\u{22ac}', &['\u{22a2}', '\u{338}']), ('\u{22ad}',
        &['\u{22a8}', '\u{338}']), ('\u{22ae}', &['\u{22a9}', '\u{338}']), ('\u{22af}',
        &['\u{22ab}', '\u{338}']), ('\u{22e0}', &['\u{227c}', '\u{338}']), ('\u{22e1}',
        &['\u{227d}', '\u{338}']), ('\u{22e2}', &['\u{2291}', '\u{338}']), ('\u{22e3}',
        &['\u{2292}', '\u{338}']), ('\u{22ea}', &['\u{22b2}', '\u{338}']), ('\u{22eb}',
        &['\u{22b3}', '\u{338}']), ('\u{22ec}', &['\u{22b4}', '\u{338}']), ('\u{22ed}',
        &['\u{22b5}', '\u{338}']), ('\u{2329}', &['\u{3008}']), ('\u{232a}', &['\u{3009}']),
        ('\u{2adc}', &['\u{2add}', '\u{338}']), ('\u{304c}', &['\u{304b}', '\u{3099}']),
        ('\u{304e}', &['\u{304d}', '\u{3099}']), ('\u{3050}', &['\u{304f}', '\u{3099}']),
        ('\u{3052}', &['\u{3051}', '\u{3099}']), ('\u{3054}', &['\u{3053}', '\u{3099}']),
        ('\u{3056}', &['\u{3055}', '\u{3099}']), ('\u{3058}', &['\u{3057}', '\u{3099}']),
        ('\u{305a}', &['\u{3059}', '\u{3099}']), ('\u{305c}', &['\u{305b}', '\u{3099}']),
        ('\u{305e}', &['\u{305d}', '\u{3099}']), ('\u{3060}', &['\u{305f}', '\u{3099}']),
        ('\u{3062}', &['\u{3061}', '\u{3099}']), ('\u{3065}', &['\u{3064}', '\u{3099}']),
        ('\u{3067}', &['\u{3066}', '\u{3099}']), ('\u{3069}', &['\u{3068}', '\u{3099}']),
        ('\u{3070}', &['\u{306f}', '\u{3099}']), ('\u{3071}', &['\u{306f}', '\u{309a}']),
        ('\u{3073}', &['\u{3072}', '\u{3099}']), ('\u{3074}', &['\u{3072}', '\u{309a}']),
        ('\u{3076}', &['\u{3075}', '\u{3099}']), ('\u{3077}', &['\u{3075}', '\u{309a}']),
        ('\u{3079}', &['\u{3078}', '\u{3099}']), ('\u{307a}', &['\u{3078}', '\u{309a}']),
        ('\u{307c}', &['\u{307b}', '\u{3099}']), ('\u{307d}', &['\u{307b}', '\u{309a}']),
        ('\u{3094}', &['\u{3046}', '\u{3099}']), ('\u{309e}', &['\u{309d}', '\u{3099}']),
        ('\u{30ac}', &['\u{30ab}', '\u{3099}']), ('\u{30ae}', &['\u{30ad}', '\u{3099}']),
        ('\u{30b0}', &['\u{30af}', '\u{3099}']), ('\u{30b2}', &['\u{30b1}', '\u{3099}']),
        ('\u{30b4}', &['\u{30b3}', '\u{3099}']), ('\u{30b6}', &['\u{30b5}', '\u{3099}']),
        ('\u{30b8}', &['\u{30b7}', '\u{3099}']), ('\u{30ba}', &['\u{30b9}', '\u{3099}']),
        ('\u{30bc}', &['\u{30bb}', '\u{3099}']), ('\u{30be}', &['\u{30bd}', '\u{3099}']),
        ('\u{30c0}', &['\u{30bf}', '\u{3099}']), ('\u{30c2}', &['\u{30c1}', '\u{3099}']),
        ('\u{30c5}', &['\u{30c4}', '\u{3099}']), ('\u{30c7}', &['\u{30c6}', '\u{3099}']),
        ('\u{30c9}', &['\u{30c8}', '\u{3099}']), ('\u{30d0}', &['\u{30cf}', '\u{3099}']),
        ('\u{30d1}', &['\u{30cf}', '\u{309a}']), ('\u{30d3}', &['\u{30d2}', '\u{3099}']),
        ('\u{30d4}', &['\u{30d2}', '\u{309a}']), ('\u{30d6}', &['\u{30d5}', '\u{3099}']),
        ('\u{30d7}', &['\u{30d5}', '\u{309a}']), ('\u{30d9}', &['\u{30d8}', '\u{3099}']),
        ('\u{30da}', &['\u{30d8}', '\u{309a}']), ('\u{30dc}', &['\u{30db}', '\u{3099}']),
        ('\u{30dd}', &['\u{30db}', '\u{309a}']), ('\u{30f4}', &['\u{30a6}', '\u{3099}']),
        ('\u{30f7}', &['\u{30ef}', '\u{3099}']), ('\u{30f8}', &['\u{30f0}', '\u{3099}']),
        ('\u{30f9}', &['\u{30f1}', '\u{3099}']), ('\u{30fa}', &['\u{30f2}', '\u{3099}']),
        ('\u{30fe}', &['\u{30fd}', '\u{3099}']), ('\u{f900}', &['\u{8c48}']), ('\u{f901}',
        &['\u{66f4}']), ('\u{f902}', &['\u{8eca}']), ('\u{f903}', &['\u{8cc8}']), ('\u{f904}',
        &['\u{6ed1}']), ('\u{f905}', &['\u{4e32}']), ('\u{f906}', &['\u{53e5}']), ('\u{f907}',
        &['\u{9f9c}']), ('\u{f908}', &['\u{9f9c}']), ('\u{f909}', &['\u{5951}']), ('\u{f90a}',
        &['\u{91d1}']), ('\u{f90b}', &['\u{5587}']), ('\u{f90c}', &['\u{5948}']), ('\u{f90d}',
        &['\u{61f6}']), ('\u{f90e}', &['\u{7669}']), ('\u{f90f}', &['\u{7f85}']), ('\u{f910}',
        &['\u{863f}']), ('\u{f911}', &['\u{87ba}']), ('\u{f912}', &['\u{88f8}']), ('\u{f913}',
        &['\u{908f}']), ('\u{f914}', &['\u{6a02}']), ('\u{f915}', &['\u{6d1b}']), ('\u{f916}',
        &['\u{70d9}']), ('\u{f917}', &['\u{73de}']), ('\u{f918}', &['\u{843d}']), ('\u{f919}',
        &['\u{916a}']), ('\u{f91a}', &['\u{99f1}']), ('\u{f91b}', &['\u{4e82}']), ('\u{f91c}',
        &['\u{5375}']), ('\u{f91d}', &['\u{6b04}']), ('\u{f91e}', &['\u{721b}']), ('\u{f91f}',
        &['\u{862d}']), ('\u{f920}', &['\u{9e1e}']), ('\u{f921}', &['\u{5d50}']), ('\u{f922}',
        &['\u{6feb}']), ('\u{f923}', &['\u{85cd}']), ('\u{f924}', &['\u{8964}']), ('\u{f925}',
        &['\u{62c9}']), ('\u{f926}', &['\u{81d8}']), ('\u{f927}', &['\u{881f}']), ('\u{f928}',
        &['\u{5eca}']), ('\u{f929}', &['\u{6717}']), ('\u{f92a}', &['\u{6d6a}']), ('\u{f92b}',
        &['\u{72fc}']), ('\u{f92c}', &['\u{90ce}']), ('\u{f92d}', &['\u{4f86}']), ('\u{f92e}',
        &['\u{51b7}']), ('\u{f92f}', &['\u{52de}']), ('\u{f930}', &['\u{64c4}']), ('\u{f931}',
        &['\u{6ad3}']), ('\u{f932}', &['\u{7210}']), ('\u{f933}', &['\u{76e7}']), ('\u{f934}',
        &['\u{8001}']), ('\u{f935}', &['\u{8606}']), ('\u{f936}', &['\u{865c}']), ('\u{f937}',
        &['\u{8def}']), ('\u{f938}', &['\u{9732}']), ('\u{f939}', &['\u{9b6f}']), ('\u{f93a}',
        &['\u{9dfa}']), ('\u{f93b}', &['\u{788c}']), ('\u{f93c}', &['\u{797f}']), ('\u{f93d}',
        &['\u{7da0}']), ('\u{f93e}', &['\u{83c9}']), ('\u{f93f}', &['\u{9304}']), ('\u{f940}',
        &['\u{9e7f}']), ('\u{f941}', &['\u{8ad6}']), ('\u{f942}', &['\u{58df}']), ('\u{f943}',
        &['\u{5f04}']), ('\u{f944}', &['\u{7c60}']), ('\u{f945}', &['\u{807e}']), ('\u{f946}',
        &['\u{7262}']), ('\u{f947}', &['\u{78ca}']), ('\u{f948}', &['\u{8cc2}']), ('\u{f949}',
        &['\u{96f7}']), ('\u{f94a}', &['\u{58d8}']), ('\u{f94b}', &['\u{5c62}']), ('\u{f94c}',
        &['\u{6a13}']), ('\u{f94d}', &['\u{6dda}']), ('\u{f94e}', &['\u{6f0f}']), ('\u{f94f}',
        &['\u{7d2f}']), ('\u{f950}', &['\u{7e37}']), ('\u{f951}', &['\u{964b}']), ('\u{f952}',
        &['\u{52d2}']), ('\u{f953}', &['\u{808b}']), ('\u{f954}', &['\u{51dc}']), ('\u{f955}',
        &['\u{51cc}']), ('\u{f956}', &['\u{7a1c}']), ('\u{f957}', &['\u{7dbe}']), ('\u{f958}',
        &['\u{83f1}']), ('\u{f959}', &['\u{9675}']), ('\u{f95a}', &['\u{8b80}']), ('\u{f95b}',
        &['\u{62cf}']), ('\u{f95c}', &['\u{6a02}']), ('\u{f95d}', &['\u{8afe}']), ('\u{f95e}',
        &['\u{4e39}']), ('\u{f95f}', &['\u{5be7}']), ('\u{f960}', &['\u{6012}']), ('\u{f961}',
        &['\u{7387}']), ('\u{f962}', &['\u{7570}']), ('\u{f963}', &['\u{5317}']), ('\u{f964}',
        &['\u{78fb}']), ('\u{f965}', &['\u{4fbf}']), ('\u{f966}', &['\u{5fa9}']), ('\u{f967}',
        &['\u{4e0d}']), ('\u{f968}', &['\u{6ccc}']), ('\u{f969}', &['\u{6578}']), ('\u{f96a}',
        &['\u{7d22}']), ('\u{f96b}', &['\u{53c3}']), ('\u{f96c}', &['\u{585e}']), ('\u{f96d}',
        &['\u{7701}']), ('\u{f96e}', &['\u{8449}']), ('\u{f96f}', &['\u{8aaa}']), ('\u{f970}',
        &['\u{6bba}']), ('\u{f971}', &['\u{8fb0}']), ('\u{f972}', &['\u{6c88}']), ('\u{f973}',
        &['\u{62fe}']), ('\u{f974}', &['\u{82e5}']), ('\u{f975}', &['\u{63a0}']), ('\u{f976}',
        &['\u{7565}']), ('\u{f977}', &['\u{4eae}']), ('\u{f978}', &['\u{5169}']), ('\u{f979}',
        &['\u{51c9}']), ('\u{f97a}', &['\u{6881}']), ('\u{f97b}', &['\u{7ce7}']), ('\u{f97c}',
        &['\u{826f}']), ('\u{f97d}', &['\u{8ad2}']), ('\u{f97e}', &['\u{91cf}']), ('\u{f97f}',
        &['\u{52f5}']), ('\u{f980}', &['\u{5442}']), ('\u{f981}', &['\u{5973}']), ('\u{f982}',
        &['\u{5eec}']), ('\u{f983}', &['\u{65c5}']), ('\u{f984}', &['\u{6ffe}']), ('\u{f985}',
        &['\u{792a}']), ('\u{f986}', &['\u{95ad}']), ('\u{f987}', &['\u{9a6a}']), ('\u{f988}',
        &['\u{9e97}']), ('\u{f989}', &['\u{9ece}']), ('\u{f98a}', &['\u{529b}']), ('\u{f98b}',
        &['\u{66c6}']), ('\u{f98c}', &['\u{6b77}']), ('\u{f98d}', &['\u{8f62}']), ('\u{f98e}',
        &['\u{5e74}']), ('\u{f98f}', &['\u{6190}']), ('\u{f990}', &['\u{6200}']), ('\u{f991}',
        &['\u{649a}']), ('\u{f992}', &['\u{6f23}']), ('\u{f993}', &['\u{7149}']), ('\u{f994}',
        &['\u{7489}']), ('\u{f995}', &['\u{79ca}']), ('\u{f996}', &['\u{7df4}']), ('\u{f997}',
        &['\u{806f}']), ('\u{f998}', &['\u{8f26}']), ('\u{f999}', &['\u{84ee}']), ('\u{f99a}',
        &['\u{9023}']), ('\u{f99b}', &['\u{934a}']), ('\u{f99c}', &['\u{5217}']), ('\u{f99d}',
        &['\u{52a3}']), ('\u{f99e}', &['\u{54bd}']), ('\u{f99f}', &['\u{70c8}']), ('\u{f9a0}',
        &['\u{88c2}']), ('\u{f9a1}', &['\u{8aaa}']), ('\u{f9a2}', &['\u{5ec9}']), ('\u{f9a3}',
        &['\u{5ff5}']), ('\u{f9a4}', &['\u{637b}']), ('\u{f9a5}', &['\u{6bae}']), ('\u{f9a6}',
        &['\u{7c3e}']), ('\u{f9a7}', &['\u{7375}']), ('\u{f9a8}', &['\u{4ee4}']), ('\u{f9a9}',
        &['\u{56f9}']), ('\u{f9aa}', &['\u{5be7}']), ('\u{f9ab}', &['\u{5dba}']), ('\u{f9ac}',
        &['\u{601c}']), ('\u{f9ad}', &['\u{73b2}']), ('\u{f9ae}', &['\u{7469}']), ('\u{f9af}',
        &['\u{7f9a}']), ('\u{f9b0}', &['\u{8046}']), ('\u{f9b1}', &['\u{9234}']), ('\u{f9b2}',
        &['\u{96f6}']), ('\u{f9b3}', &['\u{9748}']), ('\u{f9b4}', &['\u{9818}']), ('\u{f9b5}',
        &['\u{4f8b}']), ('\u{f9b6}', &['\u{79ae}']), ('\u{f9b7}', &['\u{91b4}']), ('\u{f9b8}',
        &['\u{96b8}']), ('\u{f9b9}', &['\u{60e1}']), ('\u{f9ba}', &['\u{4e86}']), ('\u{f9bb}',
        &['\u{50da}']), ('\u{f9bc}', &['\u{5bee}']), ('\u{f9bd}', &['\u{5c3f}']), ('\u{f9be}',
        &['\u{6599}']), ('\u{f9bf}', &['\u{6a02}']), ('\u{f9c0}', &['\u{71ce}']), ('\u{f9c1}',
        &['\u{7642}']), ('\u{f9c2}', &['\u{84fc}']), ('\u{f9c3}', &['\u{907c}']), ('\u{f9c4}',
        &['\u{9f8d}']), ('\u{f9c5}', &['\u{6688}']), ('\u{f9c6}', &['\u{962e}']), ('\u{f9c7}',
        &['\u{5289}']), ('\u{f9c8}', &['\u{677b}']), ('\u{f9c9}', &['\u{67f3}']), ('\u{f9ca}',
        &['\u{6d41}']), ('\u{f9cb}', &['\u{6e9c}']), ('\u{f9cc}', &['\u{7409}']), ('\u{f9cd}',
        &['\u{7559}']), ('\u{f9ce}', &['\u{786b}']), ('\u{f9cf}', &['\u{7d10}']), ('\u{f9d0}',
        &['\u{985e}']), ('\u{f9d1}', &['\u{516d}']), ('\u{f9d2}', &['\u{622e}']), ('\u{f9d3}',
        &['\u{9678}']), ('\u{f9d4}', &['\u{502b}']), ('\u{f9d5}', &['\u{5d19}']), ('\u{f9d6}',
        &['\u{6dea}']), ('\u{f9d7}', &['\u{8f2a}']), ('\u{f9d8}', &['\u{5f8b}']), ('\u{f9d9}',
        &['\u{6144}']), ('\u{f9da}', &['\u{6817}']), ('\u{f9db}', &['\u{7387}']), ('\u{f9dc}',
        &['\u{9686}']), ('\u{f9dd}', &['\u{5229}']), ('\u{f9de}', &['\u{540f}']), ('\u{f9df}',
        &['\u{5c65}']), ('\u{f9e0}', &['\u{6613}']), ('\u{f9e1}', &['\u{674e}']), ('\u{f9e2}',
        &['\u{68a8}']), ('\u{f9e3}', &['\u{6ce5}']), ('\u{f9e4}', &['\u{7406}']), ('\u{f9e5}',
        &['\u{75e2}']), ('\u{f9e6}', &['\u{7f79}']), ('\u{f9e7}', &['\u{88cf}']), ('\u{f9e8}',
        &['\u{88e1}']), ('\u{f9e9}', &['\u{91cc}']), ('\u{f9ea}', &['\u{96e2}']), ('\u{f9eb}',
        &['\u{533f}']), ('\u{f9ec}', &['\u{6eba}']), ('\u{f9ed}', &['\u{541d}']), ('\u{f9ee}',
        &['\u{71d0}']), ('\u{f9ef}', &['\u{7498}']), ('\u{f9f0}', &['\u{85fa}']), ('\u{f9f1}',
        &['\u{96a3}']), ('\u{f9f2}', &['\u{9c57}']), ('\u{f9f3}', &['\u{9e9f}']), ('\u{f9f4}',
        &['\u{6797}']), ('\u{f9f5}', &['\u{6dcb}']), ('\u{f9f6}', &['\u{81e8}']), ('\u{f9f7}',
        &['\u{7acb}']), ('\u{f9f8}', &['\u{7b20}']), ('\u{f9f9}', &['\u{7c92}']), ('\u{f9fa}',
        &['\u{72c0}']), ('\u{f9fb}', &['\u{7099}']), ('\u{f9fc}', &['\u{8b58}']), ('\u{f9fd}',
        &['\u{4ec0}']), ('\u{f9fe}', &['\u{8336}']), ('\u{f9ff}', &['\u{523a}']), ('\u{fa00}',
        &['\u{5207}']), ('\u{fa01}', &['\u{5ea6}']), ('\u{fa02}', &['\u{62d3}']), ('\u{fa03}',
        &['\u{7cd6}']), ('\u{fa04}', &['\u{5b85}']), ('\u{fa05}', &['\u{6d1e}']), ('\u{fa06}',
        &['\u{66b4}']), ('\u{fa07}', &['\u{8f3b}']), ('\u{fa08}', &['\u{884c}']), ('\u{fa09}',
        &['\u{964d}']), ('\u{fa0a}', &['\u{898b}']), ('\u{fa0b}', &['\u{5ed3}']), ('\u{fa0c}',
        &['\u{5140}']), ('\u{fa0d}', &['\u{55c0}']), ('\u{fa10}', &['\u{585a}']), ('\u{fa12}',
        &['\u{6674}']), ('\u{fa15}', &['\u{51de}']), ('\u{fa16}', &['\u{732a}']), ('\u{fa17}',
        &['\u{76ca}']), ('\u{fa18}', &['\u{793c}']), ('\u{fa19}', &['\u{795e}']), ('\u{fa1a}',
        &['\u{7965}']), ('\u{fa1b}', &['\u{798f}']), ('\u{fa1c}', &['\u{9756}']), ('\u{fa1d}',
        &['\u{7cbe}']), ('\u{fa1e}', &['\u{7fbd}']), ('\u{fa20}', &['\u{8612}']), ('\u{fa22}',
        &['\u{8af8}']), ('\u{fa25}', &['\u{9038}']), ('\u{fa26}', &['\u{90fd}']), ('\u{fa2a}',
        &['\u{98ef}']), ('\u{fa2b}', &['\u{98fc}']), ('\u{fa2c}', &['\u{9928}']), ('\u{fa2d}',
        &['\u{9db4}']), ('\u{fa2e}', &['\u{90de}']), ('\u{fa2f}', &['\u{96b7}']), ('\u{fa30}',
        &['\u{4fae}']), ('\u{fa31}', &['\u{50e7}']), ('\u{fa32}', &['\u{514d}']), ('\u{fa33}',
        &['\u{52c9}']), ('\u{fa34}', &['\u{52e4}']), ('\u{fa35}', &['\u{5351}']), ('\u{fa36}',
        &['\u{559d}']), ('\u{fa37}', &['\u{5606}']), ('\u{fa38}', &['\u{5668}']), ('\u{fa39}',
        &['\u{5840}']), ('\u{fa3a}', &['\u{58a8}']), ('\u{fa3b}', &['\u{5c64}']), ('\u{fa3c}',
        &['\u{5c6e}']), ('\u{fa3d}', &['\u{6094}']), ('\u{fa3e}', &['\u{6168}']), ('\u{fa3f}',
        &['\u{618e}']), ('\u{fa40}', &['\u{61f2}']), ('\u{fa41}', &['\u{654f}']), ('\u{fa42}',
        &['\u{65e2}']), ('\u{fa43}', &['\u{6691}']), ('\u{fa44}', &['\u{6885}']), ('\u{fa45}',
        &['\u{6d77}']), ('\u{fa46}', &['\u{6e1a}']), ('\u{fa47}', &['\u{6f22}']), ('\u{fa48}',
        &['\u{716e}']), ('\u{fa49}', &['\u{722b}']), ('\u{fa4a}', &['\u{7422}']), ('\u{fa4b}',
        &['\u{7891}']), ('\u{fa4c}', &['\u{793e}']), ('\u{fa4d}', &['\u{7949}']), ('\u{fa4e}',
        &['\u{7948}']), ('\u{fa4f}', &['\u{7950}']), ('\u{fa50}', &['\u{7956}']), ('\u{fa51}',
        &['\u{795d}']), ('\u{fa52}', &['\u{798d}']), ('\u{fa53}', &['\u{798e}']), ('\u{fa54}',
        &['\u{7a40}']), ('\u{fa55}', &['\u{7a81}']), ('\u{fa56}', &['\u{7bc0}']), ('\u{fa57}',
        &['\u{7df4}']), ('\u{fa58}', &['\u{7e09}']), ('\u{fa59}', &['\u{7e41}']), ('\u{fa5a}',
        &['\u{7f72}']), ('\u{fa5b}', &['\u{8005}']), ('\u{fa5c}', &['\u{81ed}']), ('\u{fa5d}',
        &['\u{8279}']), ('\u{fa5e}', &['\u{8279}']), ('\u{fa5f}', &['\u{8457}']), ('\u{fa60}',
        &['\u{8910}']), ('\u{fa61}', &['\u{8996}']), ('\u{fa62}', &['\u{8b01}']), ('\u{fa63}',
        &['\u{8b39}']), ('\u{fa64}', &['\u{8cd3}']), ('\u{fa65}', &['\u{8d08}']), ('\u{fa66}',
        &['\u{8fb6}']), ('\u{fa67}', &['\u{9038}']), ('\u{fa68}', &['\u{96e3}']), ('\u{fa69}',
        &['\u{97ff}']), ('\u{fa6a}', &['\u{983b}']), ('\u{fa6b}', &['\u{6075}']), ('\u{fa6c}',
        &['\u{242ee}']), ('\u{fa6d}', &['\u{8218}']), ('\u{fa70}', &['\u{4e26}']), ('\u{fa71}',
        &['\u{51b5}']), ('\u{fa72}', &['\u{5168}']), ('\u{fa73}', &['\u{4f80}']), ('\u{fa74}',
        &['\u{5145}']), ('\u{fa75}', &['\u{5180}']), ('\u{fa76}', &['\u{52c7}']), ('\u{fa77}',
        &['\u{52fa}']), ('\u{fa78}', &['\u{559d}']), ('\u{fa79}', &['\u{5555}']), ('\u{fa7a}',
        &['\u{5599}']), ('\u{fa7b}', &['\u{55e2}']), ('\u{fa7c}', &['\u{585a}']), ('\u{fa7d}',
        &['\u{58b3}']), ('\u{fa7e}', &['\u{5944}']), ('\u{fa7f}', &['\u{5954}']), ('\u{fa80}',
        &['\u{5a62}']), ('\u{fa81}', &['\u{5b28}']), ('\u{fa82}', &['\u{5ed2}']), ('\u{fa83}',
        &['\u{5ed9}']), ('\u{fa84}', &['\u{5f69}']), ('\u{fa85}', &['\u{5fad}']), ('\u{fa86}',
        &['\u{60d8}']), ('\u{fa87}', &['\u{614e}']), ('\u{fa88}', &['\u{6108}']), ('\u{fa89}',
        &['\u{618e}']), ('\u{fa8a}', &['\u{6160}']), ('\u{fa8b}', &['\u{61f2}']), ('\u{fa8c}',
        &['\u{6234}']), ('\u{fa8d}', &['\u{63c4}']), ('\u{fa8e}', &['\u{641c}']), ('\u{fa8f}',
        &['\u{6452}']), ('\u{fa90}', &['\u{6556}']), ('\u{fa91}', &['\u{6674}']), ('\u{fa92}',
        &['\u{6717}']), ('\u{fa93}', &['\u{671b}']), ('\u{fa94}', &['\u{6756}']), ('\u{fa95}',
        &['\u{6b79}']), ('\u{fa96}', &['\u{6bba}']), ('\u{fa97}', &['\u{6d41}']), ('\u{fa98}',
        &['\u{6edb}']), ('\u{fa99}', &['\u{6ecb}']), ('\u{fa9a}', &['\u{6f22}']), ('\u{fa9b}',
        &['\u{701e}']), ('\u{fa9c}', &['\u{716e}']), ('\u{fa9d}', &['\u{77a7}']), ('\u{fa9e}',
        &['\u{7235}']), ('\u{fa9f}', &['\u{72af}']), ('\u{faa0}', &['\u{732a}']), ('\u{faa1}',
        &['\u{7471}']), ('\u{faa2}', &['\u{7506}']), ('\u{faa3}', &['\u{753b}']), ('\u{faa4}',
        &['\u{761d}']), ('\u{faa5}', &['\u{761f}']), ('\u{faa6}', &['\u{76ca}']), ('\u{faa7}',
        &['\u{76db}']), ('\u{faa8}', &['\u{76f4}']), ('\u{faa9}', &['\u{774a}']), ('\u{faaa}',
        &['\u{7740}']), ('\u{faab}', &['\u{78cc}']), ('\u{faac}', &['\u{7ab1}']), ('\u{faad}',
        &['\u{7bc0}']), ('\u{faae}', &['\u{7c7b}']), ('\u{faaf}', &['\u{7d5b}']), ('\u{fab0}',
        &['\u{7df4}']), ('\u{fab1}', &['\u{7f3e}']), ('\u{fab2}', &['\u{8005}']), ('\u{fab3}',
        &['\u{8352}']), ('\u{fab4}', &['\u{83ef}']), ('\u{fab5}', &['\u{8779}']), ('\u{fab6}',
        &['\u{8941}']), ('\u{fab7}', &['\u{8986}']), ('\u{fab8}', &['\u{8996}']), ('\u{fab9}',
        &['\u{8abf}']), ('\u{faba}', &['\u{8af8}']), ('\u{fabb}', &['\u{8acb}']), ('\u{fabc}',
        &['\u{8b01}']), ('\u{fabd}', &['\u{8afe}']), ('\u{fabe}', &['\u{8aed}']), ('\u{fabf}',
        &['\u{8b39}']), ('\u{fac0}', &['\u{8b8a}']), ('\u{fac1}', &['\u{8d08}']), ('\u{fac2}',
        &['\u{8f38}']), ('\u{fac3}', &['\u{9072}']), ('\u{fac4}', &['\u{9199}']), ('\u{fac5}',
        &['\u{9276}']), ('\u{fac6}', &['\u{967c}']), ('\u{fac7}', &['\u{96e3}']), ('\u{fac8}',
        &['\u{9756}']), ('\u{fac9}', &['\u{97db}']), ('\u{faca}', &['\u{97ff}']), ('\u{facb}',
        &['\u{980b}']), ('\u{facc}', &['\u{983b}']), ('\u{facd}', &['\u{9b12}']), ('\u{face}',
        &['\u{9f9c}']), ('\u{facf}', &['\u{2284a}']), ('\u{fad0}', &['\u{22844}']), ('\u{fad1}',
        &['\u{233d5}']), ('\u{fad2}', &['\u{3b9d}']), ('\u{fad3}', &['\u{4018}']), ('\u{fad4}',
        &['\u{4039}']), ('\u{fad5}', &['\u{25249}']), ('\u{fad6}', &['\u{25cd0}']), ('\u{fad7}',
        &['\u{27ed3}']), ('\u{fad8}', &['\u{9f43}']), ('\u{fad9}', &['\u{9f8e}']), ('\u{fb1d}',
        &['\u{5d9}', '\u{5b4}']), ('\u{fb1f}', &['\u{5f2}', '\u{5b7}']), ('\u{fb2a}', &['\u{5e9}',
        '\u{5c1}']), ('\u{fb2b}', &['\u{5e9}', '\u{5c2}']), ('\u{fb2c}', &['\u{fb49}', '\u{5c1}']),
        ('\u{fb2d}', &['\u{fb49}', '\u{5c2}']), ('\u{fb2e}', &['\u{5d0}', '\u{5b7}']), ('\u{fb2f}',
        &['\u{5d0}', '\u{5b8}']), ('\u{fb30}', &['\u{5d0}', '\u{5bc}']), ('\u{fb31}', &['\u{5d1}',
        '\u{5bc}']), ('\u{fb32}', &['\u{5d2}', '\u{5bc}']), ('\u{fb33}', &['\u{5d3}', '\u{5bc}']),
        ('\u{fb34}', &['\u{5d4}', '\u{5bc}']), ('\u{fb35}', &['\u{5d5}', '\u{5bc}']), ('\u{fb36}',
        &['\u{5d6}', '\u{5bc}']), ('\u{fb38}', &['\u{5d8}', '\u{5bc}']), ('\u{fb39}', &['\u{5d9}',
        '\u{5bc}']), ('\u{fb3a}', &['\u{5da}', '\u{5bc}']), ('\u{fb3b}', &['\u{5db}', '\u{5bc}']),
        ('\u{fb3c}', &['\u{5dc}', '\u{5bc}']), ('\u{fb3e}', &['\u{5de}', '\u{5bc}']), ('\u{fb40}',
        &['\u{5e0}', '\u{5bc}']), ('\u{fb41}', &['\u{5e1}', '\u{5bc}']), ('\u{fb43}', &['\u{5e3}',
        '\u{5bc}']), ('\u{fb44}', &['\u{5e4}', '\u{5bc}']), ('\u{fb46}', &['\u{5e6}', '\u{5bc}']),
        ('\u{fb47}', &['\u{5e7}', '\u{5bc}']), ('\u{fb48}', &['\u{5e8}', '\u{5bc}']), ('\u{fb49}',
        &['\u{5e9}', '\u{5bc}']), ('\u{fb4a}', &['\u{5ea}', '\u{5bc}']), ('\u{fb4b}', &['\u{5d5}',
        '\u{5b9}']), ('\u{fb4c}', &['\u{5d1}', '\u{5bf}']), ('\u{fb4d}', &['\u{5db}', '\u{5bf}']),
        ('\u{fb4e}', &['\u{5e4}', '\u{5bf}']), ('\u{1109a}', &['\u{11099}', '\u{110ba}']),
        ('\u{1109c}', &['\u{1109b}', '\u{110ba}']), ('\u{110ab}', &['\u{110a5}', '\u{110ba}']),
        ('\u{1112e}', &['\u{11131}', '\u{11127}']), ('\u{1112f}', &['\u{11132}', '\u{11127}']),
        ('\u{1134b}', &['\u{11347}', '\u{1133e}']), ('\u{1134c}', &['\u{11347}', '\u{11357}']),
        ('\u{114bb}', &['\u{114b9}', '\u{114ba}']), ('\u{114bc}', &['\u{114b9}', '\u{114b0}']),
        ('\u{114be}', &['\u{114b9}', '\u{114bd}']), ('\u{115ba}', &['\u{115b8}', '\u{115af}']),
        ('\u{115bb}', &['\u{115b9}', '\u{115af}']), ('\u{1d15e}', &['\u{1d157}', '\u{1d165}']),
        ('\u{1d15f}', &['\u{1d158}', '\u{1d165}']), ('\u{1d160}', &['\u{1d15f}', '\u{1d16e}']),
        ('\u{1d161}', &['\u{1d15f}', '\u{1d16f}']), ('\u{1d162}', &['\u{1d15f}', '\u{1d170}']),
        ('\u{1d163}', &['\u{1d15f}', '\u{1d171}']), ('\u{1d164}', &['\u{1d15f}', '\u{1d172}']),
        ('\u{1d1bb}', &['\u{1d1b9}', '\u{1d165}']), ('\u{1d1bc}', &['\u{1d1ba}', '\u{1d165}']),
        ('\u{1d1bd}', &['\u{1d1bb}', '\u{1d16e}']), ('\u{1d1be}', &['\u{1d1bc}', '\u{1d16e}']),
        ('\u{1d1bf}', &['\u{1d1bb}', '\u{1d16f}']), ('\u{1d1c0}', &['\u{1d1bc}', '\u{1d16f}']),
        ('\u{2f800}', &['\u{4e3d}']), ('\u{2f801}', &['\u{4e38}']), ('\u{2f802}', &['\u{4e41}']),
        ('\u{2f803}', &['\u{20122}']), ('\u{2f804}', &['\u{4f60}']), ('\u{2f805}', &['\u{4fae}']),
        ('\u{2f806}', &['\u{4fbb}']), ('\u{2f807}', &['\u{5002}']), ('\u{2f808}', &['\u{507a}']),
        ('\u{2f809}', &['\u{5099}']), ('\u{2f80a}', &['\u{50e7}']), ('\u{2f80b}', &['\u{50cf}']),
        ('\u{2f80c}', &['\u{349e}']), ('\u{2f80d}', &['\u{2063a}']), ('\u{2f80e}', &['\u{514d}']),
        ('\u{2f80f}', &['\u{5154}']), ('\u{2f810}', &['\u{5164}']), ('\u{2f811}', &['\u{5177}']),
        ('\u{2f812}', &['\u{2051c}']), ('\u{2f813}', &['\u{34b9}']), ('\u{2f814}', &['\u{5167}']),
        ('\u{2f815}', &['\u{518d}']), ('\u{2f816}', &['\u{2054b}']), ('\u{2f817}', &['\u{5197}']),
        ('\u{2f818}', &['\u{51a4}']), ('\u{2f819}', &['\u{4ecc}']), ('\u{2f81a}', &['\u{51ac}']),
        ('\u{2f81b}', &['\u{51b5}']), ('\u{2f81c}', &['\u{291df}']), ('\u{2f81d}', &['\u{51f5}']),
        ('\u{2f81e}', &['\u{5203}']), ('\u{2f81f}', &['\u{34df}']), ('\u{2f820}', &['\u{523b}']),
        ('\u{2f821}', &['\u{5246}']), ('\u{2f822}', &['\u{5272}']), ('\u{2f823}', &['\u{5277}']),
        ('\u{2f824}', &['\u{3515}']), ('\u{2f825}', &['\u{52c7}']), ('\u{2f826}', &['\u{52c9}']),
        ('\u{2f827}', &['\u{52e4}']), ('\u{2f828}', &['\u{52fa}']), ('\u{2f829}', &['\u{5305}']),
        ('\u{2f82a}', &['\u{5306}']), ('\u{2f82b}', &['\u{5317}']), ('\u{2f82c}', &['\u{5349}']),
        ('\u{2f82d}', &['\u{5351}']), ('\u{2f82e}', &['\u{535a}']), ('\u{2f82f}', &['\u{5373}']),
        ('\u{2f830}', &['\u{537d}']), ('\u{2f831}', &['\u{537f}']), ('\u{2f832}', &['\u{537f}']),
        ('\u{2f833}', &['\u{537f}']), ('\u{2f834}', &['\u{20a2c}']), ('\u{2f835}', &['\u{7070}']),
        ('\u{2f836}', &['\u{53ca}']), ('\u{2f837}', &['\u{53df}']), ('\u{2f838}', &['\u{20b63}']),
        ('\u{2f839}', &['\u{53eb}']), ('\u{2f83a}', &['\u{53f1}']), ('\u{2f83b}', &['\u{5406}']),
        ('\u{2f83c}', &['\u{549e}']), ('\u{2f83d}', &['\u{5438}']), ('\u{2f83e}', &['\u{5448}']),
        ('\u{2f83f}', &['\u{5468}']), ('\u{2f840}', &['\u{54a2}']), ('\u{2f841}', &['\u{54f6}']),
        ('\u{2f842}', &['\u{5510}']), ('\u{2f843}', &['\u{5553}']), ('\u{2f844}', &['\u{5563}']),
        ('\u{2f845}', &['\u{5584}']), ('\u{2f846}', &['\u{5584}']), ('\u{2f847}', &['\u{5599}']),
        ('\u{2f848}', &['\u{55ab}']), ('\u{2f849}', &['\u{55b3}']), ('\u{2f84a}', &['\u{55c2}']),
        ('\u{2f84b}', &['\u{5716}']), ('\u{2f84c}', &['\u{5606}']), ('\u{2f84d}', &['\u{5717}']),
        ('\u{2f84e}', &['\u{5651}']), ('\u{2f84f}', &['\u{5674}']), ('\u{2f850}', &['\u{5207}']),
        ('\u{2f851}', &['\u{58ee}']), ('\u{2f852}', &['\u{57ce}']), ('\u{2f853}', &['\u{57f4}']),
        ('\u{2f854}', &['\u{580d}']), ('\u{2f855}', &['\u{578b}']), ('\u{2f856}', &['\u{5832}']),
        ('\u{2f857}', &['\u{5831}']), ('\u{2f858}', &['\u{58ac}']), ('\u{2f859}', &['\u{214e4}']),
        ('\u{2f85a}', &['\u{58f2}']), ('\u{2f85b}', &['\u{58f7}']), ('\u{2f85c}', &['\u{5906}']),
        ('\u{2f85d}', &['\u{591a}']), ('\u{2f85e}', &['\u{5922}']), ('\u{2f85f}', &['\u{5962}']),
        ('\u{2f860}', &['\u{216a8}']), ('\u{2f861}', &['\u{216ea}']), ('\u{2f862}', &['\u{59ec}']),
        ('\u{2f863}', &['\u{5a1b}']), ('\u{2f864}', &['\u{5a27}']), ('\u{2f865}', &['\u{59d8}']),
        ('\u{2f866}', &['\u{5a66}']), ('\u{2f867}', &['\u{36ee}']), ('\u{2f868}', &['\u{36fc}']),
        ('\u{2f869}', &['\u{5b08}']), ('\u{2f86a}', &['\u{5b3e}']), ('\u{2f86b}', &['\u{5b3e}']),
        ('\u{2f86c}', &['\u{219c8}']), ('\u{2f86d}', &['\u{5bc3}']), ('\u{2f86e}', &['\u{5bd8}']),
        ('\u{2f86f}', &['\u{5be7}']), ('\u{2f870}', &['\u{5bf3}']), ('\u{2f871}', &['\u{21b18}']),
        ('\u{2f872}', &['\u{5bff}']), ('\u{2f873}', &['\u{5c06}']), ('\u{2f874}', &['\u{5f53}']),
        ('\u{2f875}', &['\u{5c22}']), ('\u{2f876}', &['\u{3781}']), ('\u{2f877}', &['\u{5c60}']),
        ('\u{2f878}', &['\u{5c6e}']), ('\u{2f879}', &['\u{5cc0}']), ('\u{2f87a}', &['\u{5c8d}']),
        ('\u{2f87b}', &['\u{21de4}']), ('\u{2f87c}', &['\u{5d43}']), ('\u{2f87d}', &['\u{21de6}']),
        ('\u{2f87e}', &['\u{5d6e}']), ('\u{2f87f}', &['\u{5d6b}']), ('\u{2f880}', &['\u{5d7c}']),
        ('\u{2f881}', &['\u{5de1}']), ('\u{2f882}', &['\u{5de2}']), ('\u{2f883}', &['\u{382f}']),
        ('\u{2f884}', &['\u{5dfd}']), ('\u{2f885}', &['\u{5e28}']), ('\u{2f886}', &['\u{5e3d}']),
        ('\u{2f887}', &['\u{5e69}']), ('\u{2f888}', &['\u{3862}']), ('\u{2f889}', &['\u{22183}']),
        ('\u{2f88a}', &['\u{387c}']), ('\u{2f88b}', &['\u{5eb0}']), ('\u{2f88c}', &['\u{5eb3}']),
        ('\u{2f88d}', &['\u{5eb6}']), ('\u{2f88e}', &['\u{5eca}']), ('\u{2f88f}', &['\u{2a392}']),
        ('\u{2f890}', &['\u{5efe}']), ('\u{2f891}', &['\u{22331}']), ('\u{2f892}', &['\u{22331}']),
        ('\u{2f893}', &['\u{8201}']), ('\u{2f894}', &['\u{5f22}']), ('\u{2f895}', &['\u{5f22}']),
        ('\u{2f896}', &['\u{38c7}']), ('\u{2f897}', &['\u{232b8}']), ('\u{2f898}', &['\u{261da}']),
        ('\u{2f899}', &['\u{5f62}']), ('\u{2f89a}', &['\u{5f6b}']), ('\u{2f89b}', &['\u{38e3}']),
        ('\u{2f89c}', &['\u{5f9a}']), ('\u{2f89d}', &['\u{5fcd}']), ('\u{2f89e}', &['\u{5fd7}']),
        ('\u{2f89f}', &['\u{5ff9}']), ('\u{2f8a0}', &['\u{6081}']), ('\u{2f8a1}', &['\u{393a}']),
        ('\u{2f8a2}', &['\u{391c}']), ('\u{2f8a3}', &['\u{6094}']), ('\u{2f8a4}', &['\u{226d4}']),
        ('\u{2f8a5}', &['\u{60c7}']), ('\u{2f8a6}', &['\u{6148}']), ('\u{2f8a7}', &['\u{614c}']),
        ('\u{2f8a8}', &['\u{614e}']), ('\u{2f8a9}', &['\u{614c}']), ('\u{2f8aa}', &['\u{617a}']),
        ('\u{2f8ab}', &['\u{618e}']), ('\u{2f8ac}', &['\u{61b2}']), ('\u{2f8ad}', &['\u{61a4}']),
        ('\u{2f8ae}', &['\u{61af}']), ('\u{2f8af}', &['\u{61de}']), ('\u{2f8b0}', &['\u{61f2}']),
        ('\u{2f8b1}', &['\u{61f6}']), ('\u{2f8b2}', &['\u{6210}']), ('\u{2f8b3}', &['\u{621b}']),
        ('\u{2f8b4}', &['\u{625d}']), ('\u{2f8b5}', &['\u{62b1}']), ('\u{2f8b6}', &['\u{62d4}']),
        ('\u{2f8b7}', &['\u{6350}']), ('\u{2f8b8}', &['\u{22b0c}']), ('\u{2f8b9}', &['\u{633d}']),
        ('\u{2f8ba}', &['\u{62fc}']), ('\u{2f8bb}', &['\u{6368}']), ('\u{2f8bc}', &['\u{6383}']),
        ('\u{2f8bd}', &['\u{63e4}']), ('\u{2f8be}', &['\u{22bf1}']), ('\u{2f8bf}', &['\u{6422}']),
        ('\u{2f8c0}', &['\u{63c5}']), ('\u{2f8c1}', &['\u{63a9}']), ('\u{2f8c2}', &['\u{3a2e}']),
        ('\u{2f8c3}', &['\u{6469}']), ('\u{2f8c4}', &['\u{647e}']), ('\u{2f8c5}', &['\u{649d}']),
        ('\u{2f8c6}', &['\u{6477}']), ('\u{2f8c7}', &['\u{3a6c}']), ('\u{2f8c8}', &['\u{654f}']),
        ('\u{2f8c9}', &['\u{656c}']), ('\u{2f8ca}', &['\u{2300a}']), ('\u{2f8cb}', &['\u{65e3}']),
        ('\u{2f8cc}', &['\u{66f8}']), ('\u{2f8cd}', &['\u{6649}']), ('\u{2f8ce}', &['\u{3b19}']),
        ('\u{2f8cf}', &['\u{6691}']), ('\u{2f8d0}', &['\u{3b08}']), ('\u{2f8d1}', &['\u{3ae4}']),
        ('\u{2f8d2}', &['\u{5192}']), ('\u{2f8d3}', &['\u{5195}']), ('\u{2f8d4}', &['\u{6700}']),
        ('\u{2f8d5}', &['\u{669c}']), ('\u{2f8d6}', &['\u{80ad}']), ('\u{2f8d7}', &['\u{43d9}']),
        ('\u{2f8d8}', &['\u{6717}']), ('\u{2f8d9}', &['\u{671b}']), ('\u{2f8da}', &['\u{6721}']),
        ('\u{2f8db}', &['\u{675e}']), ('\u{2f8dc}', &['\u{6753}']), ('\u{2f8dd}', &['\u{233c3}']),
        ('\u{2f8de}', &['\u{3b49}']), ('\u{2f8df}', &['\u{67fa}']), ('\u{2f8e0}', &['\u{6785}']),
        ('\u{2f8e1}', &['\u{6852}']), ('\u{2f8e2}', &['\u{6885}']), ('\u{2f8e3}', &['\u{2346d}']),
        ('\u{2f8e4}', &['\u{688e}']), ('\u{2f8e5}', &['\u{681f}']), ('\u{2f8e6}', &['\u{6914}']),
        ('\u{2f8e7}', &['\u{3b9d}']), ('\u{2f8e8}', &['\u{6942}']), ('\u{2f8e9}', &['\u{69a3}']),
        ('\u{2f8ea}', &['\u{69ea}']), ('\u{2f8eb}', &['\u{6aa8}']), ('\u{2f8ec}', &['\u{236a3}']),
        ('\u{2f8ed}', &['\u{6adb}']), ('\u{2f8ee}', &['\u{3c18}']), ('\u{2f8ef}', &['\u{6b21}']),
        ('\u{2f8f0}', &['\u{238a7}']), ('\u{2f8f1}', &['\u{6b54}']), ('\u{2f8f2}', &['\u{3c4e}']),
        ('\u{2f8f3}', &['\u{6b72}']), ('\u{2f8f4}', &['\u{6b9f}']), ('\u{2f8f5}', &['\u{6bba}']),
        ('\u{2f8f6}', &['\u{6bbb}']), ('\u{2f8f7}', &['\u{23a8d}']), ('\u{2f8f8}', &['\u{21d0b}']),
        ('\u{2f8f9}', &['\u{23afa}']), ('\u{2f8fa}', &['\u{6c4e}']), ('\u{2f8fb}', &['\u{23cbc}']),
        ('\u{2f8fc}', &['\u{6cbf}']), ('\u{2f8fd}', &['\u{6ccd}']), ('\u{2f8fe}', &['\u{6c67}']),
        ('\u{2f8ff}', &['\u{6d16}']), ('\u{2f900}', &['\u{6d3e}']), ('\u{2f901}', &['\u{6d77}']),
        ('\u{2f902}', &['\u{6d41}']), ('\u{2f903}', &['\u{6d69}']), ('\u{2f904}', &['\u{6d78}']),
        ('\u{2f905}', &['\u{6d85}']), ('\u{2f906}', &['\u{23d1e}']), ('\u{2f907}', &['\u{6d34}']),
        ('\u{2f908}', &['\u{6e2f}']), ('\u{2f909}', &['\u{6e6e}']), ('\u{2f90a}', &['\u{3d33}']),
        ('\u{2f90b}', &['\u{6ecb}']), ('\u{2f90c}', &['\u{6ec7}']), ('\u{2f90d}', &['\u{23ed1}']),
        ('\u{2f90e}', &['\u{6df9}']), ('\u{2f90f}', &['\u{6f6e}']), ('\u{2f910}', &['\u{23f5e}']),
        ('\u{2f911}', &['\u{23f8e}']), ('\u{2f912}', &['\u{6fc6}']), ('\u{2f913}', &['\u{7039}']),
        ('\u{2f914}', &['\u{701e}']), ('\u{2f915}', &['\u{701b}']), ('\u{2f916}', &['\u{3d96}']),
        ('\u{2f917}', &['\u{704a}']), ('\u{2f918}', &['\u{707d}']), ('\u{2f919}', &['\u{7077}']),
        ('\u{2f91a}', &['\u{70ad}']), ('\u{2f91b}', &['\u{20525}']), ('\u{2f91c}', &['\u{7145}']),
        ('\u{2f91d}', &['\u{24263}']), ('\u{2f91e}', &['\u{719c}']), ('\u{2f91f}', &['\u{243ab}']),
        ('\u{2f920}', &['\u{7228}']), ('\u{2f921}', &['\u{7235}']), ('\u{2f922}', &['\u{7250}']),
        ('\u{2f923}', &['\u{24608}']), ('\u{2f924}', &['\u{7280}']), ('\u{2f925}', &['\u{7295}']),
        ('\u{2f926}', &['\u{24735}']), ('\u{2f927}', &['\u{24814}']), ('\u{2f928}', &['\u{737a}']),
        ('\u{2f929}', &['\u{738b}']), ('\u{2f92a}', &['\u{3eac}']), ('\u{2f92b}', &['\u{73a5}']),
        ('\u{2f92c}', &['\u{3eb8}']), ('\u{2f92d}', &['\u{3eb8}']), ('\u{2f92e}', &['\u{7447}']),
        ('\u{2f92f}', &['\u{745c}']), ('\u{2f930}', &['\u{7471}']), ('\u{2f931}', &['\u{7485}']),
        ('\u{2f932}', &['\u{74ca}']), ('\u{2f933}', &['\u{3f1b}']), ('\u{2f934}', &['\u{7524}']),
        ('\u{2f935}', &['\u{24c36}']), ('\u{2f936}', &['\u{753e}']), ('\u{2f937}', &['\u{24c92}']),
        ('\u{2f938}', &['\u{7570}']), ('\u{2f939}', &['\u{2219f}']), ('\u{2f93a}', &['\u{7610}']),
        ('\u{2f93b}', &['\u{24fa1}']), ('\u{2f93c}', &['\u{24fb8}']), ('\u{2f93d}', &['\u{25044}']),
        ('\u{2f93e}', &['\u{3ffc}']), ('\u{2f93f}', &['\u{4008}']), ('\u{2f940}', &['\u{76f4}']),
        ('\u{2f941}', &['\u{250f3}']), ('\u{2f942}', &['\u{250f2}']), ('\u{2f943}', &['\u{25119}']),
        ('\u{2f944}', &['\u{25133}']), ('\u{2f945}', &['\u{771e}']), ('\u{2f946}', &['\u{771f}']),
        ('\u{2f947}', &['\u{771f}']), ('\u{2f948}', &['\u{774a}']), ('\u{2f949}', &['\u{4039}']),
        ('\u{2f94a}', &['\u{778b}']), ('\u{2f94b}', &['\u{4046}']), ('\u{2f94c}', &['\u{4096}']),
        ('\u{2f94d}', &['\u{2541d}']), ('\u{2f94e}', &['\u{784e}']), ('\u{2f94f}', &['\u{788c}']),
        ('\u{2f950}', &['\u{78cc}']), ('\u{2f951}', &['\u{40e3}']), ('\u{2f952}', &['\u{25626}']),
        ('\u{2f953}', &['\u{7956}']), ('\u{2f954}', &['\u{2569a}']), ('\u{2f955}', &['\u{256c5}']),
        ('\u{2f956}', &['\u{798f}']), ('\u{2f957}', &['\u{79eb}']), ('\u{2f958}', &['\u{412f}']),
        ('\u{2f959}', &['\u{7a40}']), ('\u{2f95a}', &['\u{7a4a}']), ('\u{2f95b}', &['\u{7a4f}']),
        ('\u{2f95c}', &['\u{2597c}']), ('\u{2f95d}', &['\u{25aa7}']), ('\u{2f95e}', &['\u{25aa7}']),
        ('\u{2f95f}', &['\u{7aee}']), ('\u{2f960}', &['\u{4202}']), ('\u{2f961}', &['\u{25bab}']),
        ('\u{2f962}', &['\u{7bc6}']), ('\u{2f963}', &['\u{7bc9}']), ('\u{2f964}', &['\u{4227}']),
        ('\u{2f965}', &['\u{25c80}']), ('\u{2f966}', &['\u{7cd2}']), ('\u{2f967}', &['\u{42a0}']),
        ('\u{2f968}', &['\u{7ce8}']), ('\u{2f969}', &['\u{7ce3}']), ('\u{2f96a}', &['\u{7d00}']),
        ('\u{2f96b}', &['\u{25f86}']), ('\u{2f96c}', &['\u{7d63}']), ('\u{2f96d}', &['\u{4301}']),
        ('\u{2f96e}', &['\u{7dc7}']), ('\u{2f96f}', &['\u{7e02}']), ('\u{2f970}', &['\u{7e45}']),
        ('\u{2f971}', &['\u{4334}']), ('\u{2f972}', &['\u{26228}']), ('\u{2f973}', &['\u{26247}']),
        ('\u{2f974}', &['\u{4359}']), ('\u{2f975}', &['\u{262d9}']), ('\u{2f976}', &['\u{7f7a}']),
        ('\u{2f977}', &['\u{2633e}']), ('\u{2f978}', &['\u{7f95}']), ('\u{2f979}', &['\u{7ffa}']),
        ('\u{2f97a}', &['\u{8005}']), ('\u{2f97b}', &['\u{264da}']), ('\u{2f97c}', &['\u{26523}']),
        ('\u{2f97d}', &['\u{8060}']), ('\u{2f97e}', &['\u{265a8}']), ('\u{2f97f}', &['\u{8070}']),
        ('\u{2f980}', &['\u{2335f}']), ('\u{2f981}', &['\u{43d5}']), ('\u{2f982}', &['\u{80b2}']),
        ('\u{2f983}', &['\u{8103}']), ('\u{2f984}', &['\u{440b}']), ('\u{2f985}', &['\u{813e}']),
        ('\u{2f986}', &['\u{5ab5}']), ('\u{2f987}', &['\u{267a7}']), ('\u{2f988}', &['\u{267b5}']),
        ('\u{2f989}', &['\u{23393}']), ('\u{2f98a}', &['\u{2339c}']), ('\u{2f98b}', &['\u{8201}']),
        ('\u{2f98c}', &['\u{8204}']), ('\u{2f98d}', &['\u{8f9e}']), ('\u{2f98e}', &['\u{446b}']),
        ('\u{2f98f}', &['\u{8291}']), ('\u{2f990}', &['\u{828b}']), ('\u{2f991}', &['\u{829d}']),
        ('\u{2f992}', &['\u{52b3}']), ('\u{2f993}', &['\u{82b1}']), ('\u{2f994}', &['\u{82b3}']),
        ('\u{2f995}', &['\u{82bd}']), ('\u{2f996}', &['\u{82e6}']), ('\u{2f997}', &['\u{26b3c}']),
        ('\u{2f998}', &['\u{82e5}']), ('\u{2f999}', &['\u{831d}']), ('\u{2f99a}', &['\u{8363}']),
        ('\u{2f99b}', &['\u{83ad}']), ('\u{2f99c}', &['\u{8323}']), ('\u{2f99d}', &['\u{83bd}']),
        ('\u{2f99e}', &['\u{83e7}']), ('\u{2f99f}', &['\u{8457}']), ('\u{2f9a0}', &['\u{8353}']),
        ('\u{2f9a1}', &['\u{83ca}']), ('\u{2f9a2}', &['\u{83cc}']), ('\u{2f9a3}', &['\u{83dc}']),
        ('\u{2f9a4}', &['\u{26c36}']), ('\u{2f9a5}', &['\u{26d6b}']), ('\u{2f9a6}', &['\u{26cd5}']),
        ('\u{2f9a7}', &['\u{452b}']), ('\u{2f9a8}', &['\u{84f1}']), ('\u{2f9a9}', &['\u{84f3}']),
        ('\u{2f9aa}', &['\u{8516}']), ('\u{2f9ab}', &['\u{273ca}']), ('\u{2f9ac}', &['\u{8564}']),
        ('\u{2f9ad}', &['\u{26f2c}']), ('\u{2f9ae}', &['\u{455d}']), ('\u{2f9af}', &['\u{4561}']),
        ('\u{2f9b0}', &['\u{26fb1}']), ('\u{2f9b1}', &['\u{270d2}']), ('\u{2f9b2}', &['\u{456b}']),
        ('\u{2f9b3}', &['\u{8650}']), ('\u{2f9b4}', &['\u{865c}']), ('\u{2f9b5}', &['\u{8667}']),
        ('\u{2f9b6}', &['\u{8669}']), ('\u{2f9b7}', &['\u{86a9}']), ('\u{2f9b8}', &['\u{8688}']),
        ('\u{2f9b9}', &['\u{870e}']), ('\u{2f9ba}', &['\u{86e2}']), ('\u{2f9bb}', &['\u{8779}']),
        ('\u{2f9bc}', &['\u{8728}']), ('\u{2f9bd}', &['\u{876b}']), ('\u{2f9be}', &['\u{8786}']),
        ('\u{2f9bf}', &['\u{45d7}']), ('\u{2f9c0}', &['\u{87e1}']), ('\u{2f9c1}', &['\u{8801}']),
        ('\u{2f9c2}', &['\u{45f9}']), ('\u{2f9c3}', &['\u{8860}']), ('\u{2f9c4}', &['\u{8863}']),
        ('\u{2f9c5}', &['\u{27667}']), ('\u{2f9c6}', &['\u{88d7}']), ('\u{2f9c7}', &['\u{88de}']),
        ('\u{2f9c8}', &['\u{4635}']), ('\u{2f9c9}', &['\u{88fa}']), ('\u{2f9ca}', &['\u{34bb}']),
        ('\u{2f9cb}', &['\u{278ae}']), ('\u{2f9cc}', &['\u{27966}']), ('\u{2f9cd}', &['\u{46be}']),
        ('\u{2f9ce}', &['\u{46c7}']), ('\u{2f9cf}', &['\u{8aa0}']), ('\u{2f9d0}', &['\u{8aed}']),
        ('\u{2f9d1}', &['\u{8b8a}']), ('\u{2f9d2}', &['\u{8c55}']), ('\u{2f9d3}', &['\u{27ca8}']),
        ('\u{2f9d4}', &['\u{8cab}']), ('\u{2f9d5}', &['\u{8cc1}']), ('\u{2f9d6}', &['\u{8d1b}']),
        ('\u{2f9d7}', &['\u{8d77}']), ('\u{2f9d8}', &['\u{27f2f}']), ('\u{2f9d9}', &['\u{20804}']),
        ('\u{2f9da}', &['\u{8dcb}']), ('\u{2f9db}', &['\u{8dbc}']), ('\u{2f9dc}', &['\u{8df0}']),
        ('\u{2f9dd}', &['\u{208de}']), ('\u{2f9de}', &['\u{8ed4}']), ('\u{2f9df}', &['\u{8f38}']),
        ('\u{2f9e0}', &['\u{285d2}']), ('\u{2f9e1}', &['\u{285ed}']), ('\u{2f9e2}', &['\u{9094}']),
        ('\u{2f9e3}', &['\u{90f1}']), ('\u{2f9e4}', &['\u{9111}']), ('\u{2f9e5}', &['\u{2872e}']),
        ('\u{2f9e6}', &['\u{911b}']), ('\u{2f9e7}', &['\u{9238}']), ('\u{2f9e8}', &['\u{92d7}']),
        ('\u{2f9e9}', &['\u{92d8}']), ('\u{2f9ea}', &['\u{927c}']), ('\u{2f9eb}', &['\u{93f9}']),
        ('\u{2f9ec}', &['\u{9415}']), ('\u{2f9ed}', &['\u{28bfa}']), ('\u{2f9ee}', &['\u{958b}']),
        ('\u{2f9ef}', &['\u{4995}']), ('\u{2f9f0}', &['\u{95b7}']), ('\u{2f9f1}', &['\u{28d77}']),
        ('\u{2f9f2}', &['\u{49e6}']), ('\u{2f9f3}', &['\u{96c3}']), ('\u{2f9f4}', &['\u{5db2}']),
        ('\u{2f9f5}', &['\u{9723}']), ('\u{2f9f6}', &['\u{29145}']), ('\u{2f9f7}', &['\u{2921a}']),
        ('\u{2f9f8}', &['\u{4a6e}']), ('\u{2f9f9}', &['\u{4a76}']), ('\u{2f9fa}', &['\u{97e0}']),
        ('\u{2f9fb}', &['\u{2940a}']), ('\u{2f9fc}', &['\u{4ab2}']), ('\u{2f9fd}', &['\u{29496}']),
        ('\u{2f9fe}', &['\u{980b}']), ('\u{2f9ff}', &['\u{980b}']), ('\u{2fa00}', &['\u{9829}']),
        ('\u{2fa01}', &['\u{295b6}']), ('\u{2fa02}', &['\u{98e2}']), ('\u{2fa03}', &['\u{4b33}']),
        ('\u{2fa04}', &['\u{9929}']), ('\u{2fa05}', &['\u{99a7}']), ('\u{2fa06}', &['\u{99c2}']),
        ('\u{2fa07}', &['\u{99fe}']), ('\u{2fa08}', &['\u{4bce}']), ('\u{2fa09}', &['\u{29b30}']),
        ('\u{2fa0a}', &['\u{9b12}']), ('\u{2fa0b}', &['\u{9c40}']), ('\u{2fa0c}', &['\u{9cfd}']),
        ('\u{2fa0d}', &['\u{4cce}']), ('\u{2fa0e}', &['\u{4ced}']), ('\u{2fa0f}', &['\u{9d67}']),
        ('\u{2fa10}', &['\u{2a0ce}']), ('\u{2fa11}', &['\u{4cf8}']), ('\u{2fa12}', &['\u{2a105}']),
        ('\u{2fa13}', &['\u{2a20e}']), ('\u{2fa14}', &['\u{2a291}']), ('\u{2fa15}', &['\u{9ebb}']),
        ('\u{2fa16}', &['\u{4d56}']), ('\u{2fa17}', &['\u{9ef9}']), ('\u{2fa18}', &['\u{9efe}']),
        ('\u{2fa19}', &['\u{9f05}']), ('\u{2fa1a}', &['\u{9f0f}']), ('\u{2fa1b}', &['\u{9f16}']),
        ('\u{2fa1c}', &['\u{9f3b}']), ('\u{2fa1d}', &['\u{2a600}'])
    ];

    // Compatibility decompositions
    pub const compatibility_table: &'static [(char, &'static [char])] = &[
        ('\u{a0}', &['\u{20}']), ('\u{a8}', &['\u{20}', '\u{308}']), ('\u{aa}', &['\u{61}']),
        ('\u{af}', &['\u{20}', '\u{304}']), ('\u{b2}', &['\u{32}']), ('\u{b3}', &['\u{33}']),
        ('\u{b4}', &['\u{20}', '\u{301}']), ('\u{b5}', &['\u{3bc}']), ('\u{b8}', &['\u{20}',
        '\u{327}']), ('\u{b9}', &['\u{31}']), ('\u{ba}', &['\u{6f}']), ('\u{bc}', &['\u{31}',
        '\u{2044}', '\u{34}']), ('\u{bd}', &['\u{31}', '\u{2044}', '\u{32}']), ('\u{be}',
        &['\u{33}', '\u{2044}', '\u{34}']), ('\u{132}', &['\u{49}', '\u{4a}']), ('\u{133}',
        &['\u{69}', '\u{6a}']), ('\u{13f}', &['\u{4c}', '\u{b7}']), ('\u{140}', &['\u{6c}',
        '\u{b7}']), ('\u{149}', &['\u{2bc}', '\u{6e}']), ('\u{17f}', &['\u{73}']), ('\u{1c4}',
        &['\u{44}', '\u{17d}']), ('\u{1c5}', &['\u{44}', '\u{17e}']), ('\u{1c6}', &['\u{64}',
        '\u{17e}']), ('\u{1c7}', &['\u{4c}', '\u{4a}']), ('\u{1c8}', &['\u{4c}', '\u{6a}']),
        ('\u{1c9}', &['\u{6c}', '\u{6a}']), ('\u{1ca}', &['\u{4e}', '\u{4a}']), ('\u{1cb}',
        &['\u{4e}', '\u{6a}']), ('\u{1cc}', &['\u{6e}', '\u{6a}']), ('\u{1f1}', &['\u{44}',
        '\u{5a}']), ('\u{1f2}', &['\u{44}', '\u{7a}']), ('\u{1f3}', &['\u{64}', '\u{7a}']),
        ('\u{2b0}', &['\u{68}']), ('\u{2b1}', &['\u{266}']), ('\u{2b2}', &['\u{6a}']), ('\u{2b3}',
        &['\u{72}']), ('\u{2b4}', &['\u{279}']), ('\u{2b5}', &['\u{27b}']), ('\u{2b6}',
        &['\u{281}']), ('\u{2b7}', &['\u{77}']), ('\u{2b8}', &['\u{79}']), ('\u{2d8}', &['\u{20}',
        '\u{306}']), ('\u{2d9}', &['\u{20}', '\u{307}']), ('\u{2da}', &['\u{20}', '\u{30a}']),
        ('\u{2db}', &['\u{20}', '\u{328}']), ('\u{2dc}', &['\u{20}', '\u{303}']), ('\u{2dd}',
        &['\u{20}', '\u{30b}']), ('\u{2e0}', &['\u{263}']), ('\u{2e1}', &['\u{6c}']), ('\u{2e2}',
        &['\u{73}']), ('\u{2e3}', &['\u{78}']), ('\u{2e4}', &['\u{295}']), ('\u{37a}', &['\u{20}',
        '\u{345}']), ('\u{384}', &['\u{20}', '\u{301}']), ('\u{3d0}', &['\u{3b2}']), ('\u{3d1}',
        &['\u{3b8}']), ('\u{3d2}', &['\u{3a5}']), ('\u{3d5}', &['\u{3c6}']), ('\u{3d6}',
        &['\u{3c0}']), ('\u{3f0}', &['\u{3ba}']), ('\u{3f1}', &['\u{3c1}']), ('\u{3f2}',
        &['\u{3c2}']), ('\u{3f4}', &['\u{398}']), ('\u{3f5}', &['\u{3b5}']), ('\u{3f9}',
        &['\u{3a3}']), ('\u{587}', &['\u{565}', '\u{582}']), ('\u{675}', &['\u{627}', '\u{674}']),
        ('\u{676}', &['\u{648}', '\u{674}']), ('\u{677}', &['\u{6c7}', '\u{674}']), ('\u{678}',
        &['\u{64a}', '\u{674}']), ('\u{e33}', &['\u{e4d}', '\u{e32}']), ('\u{eb3}', &['\u{ecd}',
        '\u{eb2}']), ('\u{edc}', &['\u{eab}', '\u{e99}']), ('\u{edd}', &['\u{eab}', '\u{ea1}']),
        ('\u{f0c}', &['\u{f0b}']), ('\u{f77}', &['\u{fb2}', '\u{f81}']), ('\u{f79}', &['\u{fb3}',
        '\u{f81}']), ('\u{10fc}', &['\u{10dc}']), ('\u{1d2c}', &['\u{41}']), ('\u{1d2d}',
        &['\u{c6}']), ('\u{1d2e}', &['\u{42}']), ('\u{1d30}', &['\u{44}']), ('\u{1d31}',
        &['\u{45}']), ('\u{1d32}', &['\u{18e}']), ('\u{1d33}', &['\u{47}']), ('\u{1d34}',
        &['\u{48}']), ('\u{1d35}', &['\u{49}']), ('\u{1d36}', &['\u{4a}']), ('\u{1d37}',
        &['\u{4b}']), ('\u{1d38}', &['\u{4c}']), ('\u{1d39}', &['\u{4d}']), ('\u{1d3a}',
        &['\u{4e}']), ('\u{1d3c}', &['\u{4f}']), ('\u{1d3d}', &['\u{222}']), ('\u{1d3e}',
        &['\u{50}']), ('\u{1d3f}', &['\u{52}']), ('\u{1d40}', &['\u{54}']), ('\u{1d41}',
        &['\u{55}']), ('\u{1d42}', &['\u{57}']), ('\u{1d43}', &['\u{61}']), ('\u{1d44}',
        &['\u{250}']), ('\u{1d45}', &['\u{251}']), ('\u{1d46}', &['\u{1d02}']), ('\u{1d47}',
        &['\u{62}']), ('\u{1d48}', &['\u{64}']), ('\u{1d49}', &['\u{65}']), ('\u{1d4a}',
        &['\u{259}']), ('\u{1d4b}', &['\u{25b}']), ('\u{1d4c}', &['\u{25c}']), ('\u{1d4d}',
        &['\u{67}']), ('\u{1d4f}', &['\u{6b}']), ('\u{1d50}', &['\u{6d}']), ('\u{1d51}',
        &['\u{14b}']), ('\u{1d52}', &['\u{6f}']), ('\u{1d53}', &['\u{254}']), ('\u{1d54}',
        &['\u{1d16}']), ('\u{1d55}', &['\u{1d17}']), ('\u{1d56}', &['\u{70}']), ('\u{1d57}',
        &['\u{74}']), ('\u{1d58}', &['\u{75}']), ('\u{1d59}', &['\u{1d1d}']), ('\u{1d5a}',
        &['\u{26f}']), ('\u{1d5b}', &['\u{76}']), ('\u{1d5c}', &['\u{1d25}']), ('\u{1d5d}',
        &['\u{3b2}']), ('\u{1d5e}', &['\u{3b3}']), ('\u{1d5f}', &['\u{3b4}']), ('\u{1d60}',
        &['\u{3c6}']), ('\u{1d61}', &['\u{3c7}']), ('\u{1d62}', &['\u{69}']), ('\u{1d63}',
        &['\u{72}']), ('\u{1d64}', &['\u{75}']), ('\u{1d65}', &['\u{76}']), ('\u{1d66}',
        &['\u{3b2}']), ('\u{1d67}', &['\u{3b3}']), ('\u{1d68}', &['\u{3c1}']), ('\u{1d69}',
        &['\u{3c6}']), ('\u{1d6a}', &['\u{3c7}']), ('\u{1d78}', &['\u{43d}']), ('\u{1d9b}',
        &['\u{252}']), ('\u{1d9c}', &['\u{63}']), ('\u{1d9d}', &['\u{255}']), ('\u{1d9e}',
        &['\u{f0}']), ('\u{1d9f}', &['\u{25c}']), ('\u{1da0}', &['\u{66}']), ('\u{1da1}',
        &['\u{25f}']), ('\u{1da2}', &['\u{261}']), ('\u{1da3}', &['\u{265}']), ('\u{1da4}',
        &['\u{268}']), ('\u{1da5}', &['\u{269}']), ('\u{1da6}', &['\u{26a}']), ('\u{1da7}',
        &['\u{1d7b}']), ('\u{1da8}', &['\u{29d}']), ('\u{1da9}', &['\u{26d}']), ('\u{1daa}',
        &['\u{1d85}']), ('\u{1dab}', &['\u{29f}']), ('\u{1dac}', &['\u{271}']), ('\u{1dad}',
        &['\u{270}']), ('\u{1dae}', &['\u{272}']), ('\u{1daf}', &['\u{273}']), ('\u{1db0}',
        &['\u{274}']), ('\u{1db1}', &['\u{275}']), ('\u{1db2}', &['\u{278}']), ('\u{1db3}',
        &['\u{282}']), ('\u{1db4}', &['\u{283}']), ('\u{1db5}', &['\u{1ab}']), ('\u{1db6}',
        &['\u{289}']), ('\u{1db7}', &['\u{28a}']), ('\u{1db8}', &['\u{1d1c}']), ('\u{1db9}',
        &['\u{28b}']), ('\u{1dba}', &['\u{28c}']), ('\u{1dbb}', &['\u{7a}']), ('\u{1dbc}',
        &['\u{290}']), ('\u{1dbd}', &['\u{291}']), ('\u{1dbe}', &['\u{292}']), ('\u{1dbf}',
        &['\u{3b8}']), ('\u{1e9a}', &['\u{61}', '\u{2be}']), ('\u{1fbd}', &['\u{20}', '\u{313}']),
        ('\u{1fbf}', &['\u{20}', '\u{313}']), ('\u{1fc0}', &['\u{20}', '\u{342}']), ('\u{1ffe}',
        &['\u{20}', '\u{314}']), ('\u{2002}', &['\u{20}']), ('\u{2003}', &['\u{20}']), ('\u{2004}',
        &['\u{20}']), ('\u{2005}', &['\u{20}']), ('\u{2006}', &['\u{20}']), ('\u{2007}',
        &['\u{20}']), ('\u{2008}', &['\u{20}']), ('\u{2009}', &['\u{20}']), ('\u{200a}',
        &['\u{20}']), ('\u{2011}', &['\u{2010}']), ('\u{2017}', &['\u{20}', '\u{333}']),
        ('\u{2024}', &['\u{2e}']), ('\u{2025}', &['\u{2e}', '\u{2e}']), ('\u{2026}', &['\u{2e}',
        '\u{2e}', '\u{2e}']), ('\u{202f}', &['\u{20}']), ('\u{2033}', &['\u{2032}', '\u{2032}']),
        ('\u{2034}', &['\u{2032}', '\u{2032}', '\u{2032}']), ('\u{2036}', &['\u{2035}',
        '\u{2035}']), ('\u{2037}', &['\u{2035}', '\u{2035}', '\u{2035}']), ('\u{203c}', &['\u{21}',
        '\u{21}']), ('\u{203e}', &['\u{20}', '\u{305}']), ('\u{2047}', &['\u{3f}', '\u{3f}']),
        ('\u{2048}', &['\u{3f}', '\u{21}']), ('\u{2049}', &['\u{21}', '\u{3f}']), ('\u{2057}',
        &['\u{2032}', '\u{2032}', '\u{2032}', '\u{2032}']), ('\u{205f}', &['\u{20}']), ('\u{2070}',
        &['\u{30}']), ('\u{2071}', &['\u{69}']), ('\u{2074}', &['\u{34}']), ('\u{2075}',
        &['\u{35}']), ('\u{2076}', &['\u{36}']), ('\u{2077}', &['\u{37}']), ('\u{2078}',
        &['\u{38}']), ('\u{2079}', &['\u{39}']), ('\u{207a}', &['\u{2b}']), ('\u{207b}',
        &['\u{2212}']), ('\u{207c}', &['\u{3d}']), ('\u{207d}', &['\u{28}']), ('\u{207e}',
        &['\u{29}']), ('\u{207f}', &['\u{6e}']), ('\u{2080}', &['\u{30}']), ('\u{2081}',
        &['\u{31}']), ('\u{2082}', &['\u{32}']), ('\u{2083}', &['\u{33}']), ('\u{2084}',
        &['\u{34}']), ('\u{2085}', &['\u{35}']), ('\u{2086}', &['\u{36}']), ('\u{2087}',
        &['\u{37}']), ('\u{2088}', &['\u{38}']), ('\u{2089}', &['\u{39}']), ('\u{208a}',
        &['\u{2b}']), ('\u{208b}', &['\u{2212}']), ('\u{208c}', &['\u{3d}']), ('\u{208d}',
        &['\u{28}']), ('\u{208e}', &['\u{29}']), ('\u{2090}', &['\u{61}']), ('\u{2091}',
        &['\u{65}']), ('\u{2092}', &['\u{6f}']), ('\u{2093}', &['\u{78}']), ('\u{2094}',
        &['\u{259}']), ('\u{2095}', &['\u{68}']), ('\u{2096}', &['\u{6b}']), ('\u{2097}',
        &['\u{6c}']), ('\u{2098}', &['\u{6d}']), ('\u{2099}', &['\u{6e}']), ('\u{209a}',
        &['\u{70}']), ('\u{209b}', &['\u{73}']), ('\u{209c}', &['\u{74}']), ('\u{20a8}', &['\u{52}',
        '\u{73}']), ('\u{2100}', &['\u{61}', '\u{2f}', '\u{63}']), ('\u{2101}', &['\u{61}',
        '\u{2f}', '\u{73}']), ('\u{2102}', &['\u{43}']), ('\u{2103}', &['\u{b0}', '\u{43}']),
        ('\u{2105}', &['\u{63}', '\u{2f}', '\u{6f}']), ('\u{2106}', &['\u{63}', '\u{2f}',
        '\u{75}']), ('\u{2107}', &['\u{190}']), ('\u{2109}', &['\u{b0}', '\u{46}']), ('\u{210a}',
        &['\u{67}']), ('\u{210b}', &['\u{48}']), ('\u{210c}', &['\u{48}']), ('\u{210d}',
        &['\u{48}']), ('\u{210e}', &['\u{68}']), ('\u{210f}', &['\u{127}']), ('\u{2110}',
        &['\u{49}']), ('\u{2111}', &['\u{49}']), ('\u{2112}', &['\u{4c}']), ('\u{2113}',
        &['\u{6c}']), ('\u{2115}', &['\u{4e}']), ('\u{2116}', &['\u{4e}', '\u{6f}']), ('\u{2119}',
        &['\u{50}']), ('\u{211a}', &['\u{51}']), ('\u{211b}', &['\u{52}']), ('\u{211c}',
        &['\u{52}']), ('\u{211d}', &['\u{52}']), ('\u{2120}', &['\u{53}', '\u{4d}']), ('\u{2121}',
        &['\u{54}', '\u{45}', '\u{4c}']), ('\u{2122}', &['\u{54}', '\u{4d}']), ('\u{2124}',
        &['\u{5a}']), ('\u{2128}', &['\u{5a}']), ('\u{212c}', &['\u{42}']), ('\u{212d}',
        &['\u{43}']), ('\u{212f}', &['\u{65}']), ('\u{2130}', &['\u{45}']), ('\u{2131}',
        &['\u{46}']), ('\u{2133}', &['\u{4d}']), ('\u{2134}', &['\u{6f}']), ('\u{2135}',
        &['\u{5d0}']), ('\u{2136}', &['\u{5d1}']), ('\u{2137}', &['\u{5d2}']), ('\u{2138}',
        &['\u{5d3}']), ('\u{2139}', &['\u{69}']), ('\u{213b}', &['\u{46}', '\u{41}', '\u{58}']),
        ('\u{213c}', &['\u{3c0}']), ('\u{213d}', &['\u{3b3}']), ('\u{213e}', &['\u{393}']),
        ('\u{213f}', &['\u{3a0}']), ('\u{2140}', &['\u{2211}']), ('\u{2145}', &['\u{44}']),
        ('\u{2146}', &['\u{64}']), ('\u{2147}', &['\u{65}']), ('\u{2148}', &['\u{69}']),
        ('\u{2149}', &['\u{6a}']), ('\u{2150}', &['\u{31}', '\u{2044}', '\u{37}']), ('\u{2151}',
        &['\u{31}', '\u{2044}', '\u{39}']), ('\u{2152}', &['\u{31}', '\u{2044}', '\u{31}',
        '\u{30}']), ('\u{2153}', &['\u{31}', '\u{2044}', '\u{33}']), ('\u{2154}', &['\u{32}',
        '\u{2044}', '\u{33}']), ('\u{2155}', &['\u{31}', '\u{2044}', '\u{35}']), ('\u{2156}',
        &['\u{32}', '\u{2044}', '\u{35}']), ('\u{2157}', &['\u{33}', '\u{2044}', '\u{35}']),
        ('\u{2158}', &['\u{34}', '\u{2044}', '\u{35}']), ('\u{2159}', &['\u{31}', '\u{2044}',
        '\u{36}']), ('\u{215a}', &['\u{35}', '\u{2044}', '\u{36}']), ('\u{215b}', &['\u{31}',
        '\u{2044}', '\u{38}']), ('\u{215c}', &['\u{33}', '\u{2044}', '\u{38}']), ('\u{215d}',
        &['\u{35}', '\u{2044}', '\u{38}']), ('\u{215e}', &['\u{37}', '\u{2044}', '\u{38}']),
        ('\u{215f}', &['\u{31}', '\u{2044}']), ('\u{2160}', &['\u{49}']), ('\u{2161}', &['\u{49}',
        '\u{49}']), ('\u{2162}', &['\u{49}', '\u{49}', '\u{49}']), ('\u{2163}', &['\u{49}',
        '\u{56}']), ('\u{2164}', &['\u{56}']), ('\u{2165}', &['\u{56}', '\u{49}']), ('\u{2166}',
        &['\u{56}', '\u{49}', '\u{49}']), ('\u{2167}', &['\u{56}', '\u{49}', '\u{49}', '\u{49}']),
        ('\u{2168}', &['\u{49}', '\u{58}']), ('\u{2169}', &['\u{58}']), ('\u{216a}', &['\u{58}',
        '\u{49}']), ('\u{216b}', &['\u{58}', '\u{49}', '\u{49}']), ('\u{216c}', &['\u{4c}']),
        ('\u{216d}', &['\u{43}']), ('\u{216e}', &['\u{44}']), ('\u{216f}', &['\u{4d}']),
        ('\u{2170}', &['\u{69}']), ('\u{2171}', &['\u{69}', '\u{69}']), ('\u{2172}', &['\u{69}',
        '\u{69}', '\u{69}']), ('\u{2173}', &['\u{69}', '\u{76}']), ('\u{2174}', &['\u{76}']),
        ('\u{2175}', &['\u{76}', '\u{69}']), ('\u{2176}', &['\u{76}', '\u{69}', '\u{69}']),
        ('\u{2177}', &['\u{76}', '\u{69}', '\u{69}', '\u{69}']), ('\u{2178}', &['\u{69}',
        '\u{78}']), ('\u{2179}', &['\u{78}']), ('\u{217a}', &['\u{78}', '\u{69}']), ('\u{217b}',
        &['\u{78}', '\u{69}', '\u{69}']), ('\u{217c}', &['\u{6c}']), ('\u{217d}', &['\u{63}']),
        ('\u{217e}', &['\u{64}']), ('\u{217f}', &['\u{6d}']), ('\u{2189}', &['\u{30}', '\u{2044}',
        '\u{33}']), ('\u{222c}', &['\u{222b}', '\u{222b}']), ('\u{222d}', &['\u{222b}', '\u{222b}',
        '\u{222b}']), ('\u{222f}', &['\u{222e}', '\u{222e}']), ('\u{2230}', &['\u{222e}',
        '\u{222e}', '\u{222e}']), ('\u{2460}', &['\u{31}']), ('\u{2461}', &['\u{32}']), ('\u{2462}',
        &['\u{33}']), ('\u{2463}', &['\u{34}']), ('\u{2464}', &['\u{35}']), ('\u{2465}',
        &['\u{36}']), ('\u{2466}', &['\u{37}']), ('\u{2467}', &['\u{38}']), ('\u{2468}',
        &['\u{39}']), ('\u{2469}', &['\u{31}', '\u{30}']), ('\u{246a}', &['\u{31}', '\u{31}']),
        ('\u{246b}', &['\u{31}', '\u{32}']), ('\u{246c}', &['\u{31}', '\u{33}']), ('\u{246d}',
        &['\u{31}', '\u{34}']), ('\u{246e}', &['\u{31}', '\u{35}']), ('\u{246f}', &['\u{31}',
        '\u{36}']), ('\u{2470}', &['\u{31}', '\u{37}']), ('\u{2471}', &['\u{31}', '\u{38}']),
        ('\u{2472}', &['\u{31}', '\u{39}']), ('\u{2473}', &['\u{32}', '\u{30}']), ('\u{2474}',
        &['\u{28}', '\u{31}', '\u{29}']), ('\u{2475}', &['\u{28}', '\u{32}', '\u{29}']),
        ('\u{2476}', &['\u{28}', '\u{33}', '\u{29}']), ('\u{2477}', &['\u{28}', '\u{34}',
        '\u{29}']), ('\u{2478}', &['\u{28}', '\u{35}', '\u{29}']), ('\u{2479}', &['\u{28}',
        '\u{36}', '\u{29}']), ('\u{247a}', &['\u{28}', '\u{37}', '\u{29}']), ('\u{247b}',
        &['\u{28}', '\u{38}', '\u{29}']), ('\u{247c}', &['\u{28}', '\u{39}', '\u{29}']),
        ('\u{247d}', &['\u{28}', '\u{31}', '\u{30}', '\u{29}']), ('\u{247e}', &['\u{28}', '\u{31}',
        '\u{31}', '\u{29}']), ('\u{247f}', &['\u{28}', '\u{31}', '\u{32}', '\u{29}']), ('\u{2480}',
        &['\u{28}', '\u{31}', '\u{33}', '\u{29}']), ('\u{2481}', &['\u{28}', '\u{31}', '\u{34}',
        '\u{29}']), ('\u{2482}', &['\u{28}', '\u{31}', '\u{35}', '\u{29}']), ('\u{2483}',
        &['\u{28}', '\u{31}', '\u{36}', '\u{29}']), ('\u{2484}', &['\u{28}', '\u{31}', '\u{37}',
        '\u{29}']), ('\u{2485}', &['\u{28}', '\u{31}', '\u{38}', '\u{29}']), ('\u{2486}',
        &['\u{28}', '\u{31}', '\u{39}', '\u{29}']), ('\u{2487}', &['\u{28}', '\u{32}', '\u{30}',
        '\u{29}']), ('\u{2488}', &['\u{31}', '\u{2e}']), ('\u{2489}', &['\u{32}', '\u{2e}']),
        ('\u{248a}', &['\u{33}', '\u{2e}']), ('\u{248b}', &['\u{34}', '\u{2e}']), ('\u{248c}',
        &['\u{35}', '\u{2e}']), ('\u{248d}', &['\u{36}', '\u{2e}']), ('\u{248e}', &['\u{37}',
        '\u{2e}']), ('\u{248f}', &['\u{38}', '\u{2e}']), ('\u{2490}', &['\u{39}', '\u{2e}']),
        ('\u{2491}', &['\u{31}', '\u{30}', '\u{2e}']), ('\u{2492}', &['\u{31}', '\u{31}',
        '\u{2e}']), ('\u{2493}', &['\u{31}', '\u{32}', '\u{2e}']), ('\u{2494}', &['\u{31}',
        '\u{33}', '\u{2e}']), ('\u{2495}', &['\u{31}', '\u{34}', '\u{2e}']), ('\u{2496}',
        &['\u{31}', '\u{35}', '\u{2e}']), ('\u{2497}', &['\u{31}', '\u{36}', '\u{2e}']),
        ('\u{2498}', &['\u{31}', '\u{37}', '\u{2e}']), ('\u{2499}', &['\u{31}', '\u{38}',
        '\u{2e}']), ('\u{249a}', &['\u{31}', '\u{39}', '\u{2e}']), ('\u{249b}', &['\u{32}',
        '\u{30}', '\u{2e}']), ('\u{249c}', &['\u{28}', '\u{61}', '\u{29}']), ('\u{249d}',
        &['\u{28}', '\u{62}', '\u{29}']), ('\u{249e}', &['\u{28}', '\u{63}', '\u{29}']),
        ('\u{249f}', &['\u{28}', '\u{64}', '\u{29}']), ('\u{24a0}', &['\u{28}', '\u{65}',
        '\u{29}']), ('\u{24a1}', &['\u{28}', '\u{66}', '\u{29}']), ('\u{24a2}', &['\u{28}',
        '\u{67}', '\u{29}']), ('\u{24a3}', &['\u{28}', '\u{68}', '\u{29}']), ('\u{24a4}',
        &['\u{28}', '\u{69}', '\u{29}']), ('\u{24a5}', &['\u{28}', '\u{6a}', '\u{29}']),
        ('\u{24a6}', &['\u{28}', '\u{6b}', '\u{29}']), ('\u{24a7}', &['\u{28}', '\u{6c}',
        '\u{29}']), ('\u{24a8}', &['\u{28}', '\u{6d}', '\u{29}']), ('\u{24a9}', &['\u{28}',
        '\u{6e}', '\u{29}']), ('\u{24aa}', &['\u{28}', '\u{6f}', '\u{29}']), ('\u{24ab}',
        &['\u{28}', '\u{70}', '\u{29}']), ('\u{24ac}', &['\u{28}', '\u{71}', '\u{29}']),
        ('\u{24ad}', &['\u{28}', '\u{72}', '\u{29}']), ('\u{24ae}', &['\u{28}', '\u{73}',
        '\u{29}']), ('\u{24af}', &['\u{28}', '\u{74}', '\u{29}']), ('\u{24b0}', &['\u{28}',
        '\u{75}', '\u{29}']), ('\u{24b1}', &['\u{28}', '\u{76}', '\u{29}']), ('\u{24b2}',
        &['\u{28}', '\u{77}', '\u{29}']), ('\u{24b3}', &['\u{28}', '\u{78}', '\u{29}']),
        ('\u{24b4}', &['\u{28}', '\u{79}', '\u{29}']), ('\u{24b5}', &['\u{28}', '\u{7a}',
        '\u{29}']), ('\u{24b6}', &['\u{41}']), ('\u{24b7}', &['\u{42}']), ('\u{24b8}', &['\u{43}']),
        ('\u{24b9}', &['\u{44}']), ('\u{24ba}', &['\u{45}']), ('\u{24bb}', &['\u{46}']),
        ('\u{24bc}', &['\u{47}']), ('\u{24bd}', &['\u{48}']), ('\u{24be}', &['\u{49}']),
        ('\u{24bf}', &['\u{4a}']), ('\u{24c0}', &['\u{4b}']), ('\u{24c1}', &['\u{4c}']),
        ('\u{24c2}', &['\u{4d}']), ('\u{24c3}', &['\u{4e}']), ('\u{24c4}', &['\u{4f}']),
        ('\u{24c5}', &['\u{50}']), ('\u{24c6}', &['\u{51}']), ('\u{24c7}', &['\u{52}']),
        ('\u{24c8}', &['\u{53}']), ('\u{24c9}', &['\u{54}']), ('\u{24ca}', &['\u{55}']),
        ('\u{24cb}', &['\u{56}']), ('\u{24cc}', &['\u{57}']), ('\u{24cd}', &['\u{58}']),
        ('\u{24ce}', &['\u{59}']), ('\u{24cf}', &['\u{5a}']), ('\u{24d0}', &['\u{61}']),
        ('\u{24d1}', &['\u{62}']), ('\u{24d2}', &['\u{63}']), ('\u{24d3}', &['\u{64}']),
        ('\u{24d4}', &['\u{65}']), ('\u{24d5}', &['\u{66}']), ('\u{24d6}', &['\u{67}']),
        ('\u{24d7}', &['\u{68}']), ('\u{24d8}', &['\u{69}']), ('\u{24d9}', &['\u{6a}']),
        ('\u{24da}', &['\u{6b}']), ('\u{24db}', &['\u{6c}']), ('\u{24dc}', &['\u{6d}']),
        ('\u{24dd}', &['\u{6e}']), ('\u{24de}', &['\u{6f}']), ('\u{24df}', &['\u{70}']),
        ('\u{24e0}', &['\u{71}']), ('\u{24e1}', &['\u{72}']), ('\u{24e2}', &['\u{73}']),
        ('\u{24e3}', &['\u{74}']), ('\u{24e4}', &['\u{75}']), ('\u{24e5}', &['\u{76}']),
        ('\u{24e6}', &['\u{77}']), ('\u{24e7}', &['\u{78}']), ('\u{24e8}', &['\u{79}']),
        ('\u{24e9}', &['\u{7a}']), ('\u{24ea}', &['\u{30}']), ('\u{2a0c}', &['\u{222b}', '\u{222b}',
        '\u{222b}', '\u{222b}']), ('\u{2a74}', &['\u{3a}', '\u{3a}', '\u{3d}']), ('\u{2a75}',
        &['\u{3d}', '\u{3d}']), ('\u{2a76}', &['\u{3d}', '\u{3d}', '\u{3d}']), ('\u{2c7c}',
        &['\u{6a}']), ('\u{2c7d}', &['\u{56}']), ('\u{2d6f}', &['\u{2d61}']), ('\u{2e9f}',
        &['\u{6bcd}']), ('\u{2ef3}', &['\u{9f9f}']), ('\u{2f00}', &['\u{4e00}']), ('\u{2f01}',
        &['\u{4e28}']), ('\u{2f02}', &['\u{4e36}']), ('\u{2f03}', &['\u{4e3f}']), ('\u{2f04}',
        &['\u{4e59}']), ('\u{2f05}', &['\u{4e85}']), ('\u{2f06}', &['\u{4e8c}']), ('\u{2f07}',
        &['\u{4ea0}']), ('\u{2f08}', &['\u{4eba}']), ('\u{2f09}', &['\u{513f}']), ('\u{2f0a}',
        &['\u{5165}']), ('\u{2f0b}', &['\u{516b}']), ('\u{2f0c}', &['\u{5182}']), ('\u{2f0d}',
        &['\u{5196}']), ('\u{2f0e}', &['\u{51ab}']), ('\u{2f0f}', &['\u{51e0}']), ('\u{2f10}',
        &['\u{51f5}']), ('\u{2f11}', &['\u{5200}']), ('\u{2f12}', &['\u{529b}']), ('\u{2f13}',
        &['\u{52f9}']), ('\u{2f14}', &['\u{5315}']), ('\u{2f15}', &['\u{531a}']), ('\u{2f16}',
        &['\u{5338}']), ('\u{2f17}', &['\u{5341}']), ('\u{2f18}', &['\u{535c}']), ('\u{2f19}',
        &['\u{5369}']), ('\u{2f1a}', &['\u{5382}']), ('\u{2f1b}', &['\u{53b6}']), ('\u{2f1c}',
        &['\u{53c8}']), ('\u{2f1d}', &['\u{53e3}']), ('\u{2f1e}', &['\u{56d7}']), ('\u{2f1f}',
        &['\u{571f}']), ('\u{2f20}', &['\u{58eb}']), ('\u{2f21}', &['\u{5902}']), ('\u{2f22}',
        &['\u{590a}']), ('\u{2f23}', &['\u{5915}']), ('\u{2f24}', &['\u{5927}']), ('\u{2f25}',
        &['\u{5973}']), ('\u{2f26}', &['\u{5b50}']), ('\u{2f27}', &['\u{5b80}']), ('\u{2f28}',
        &['\u{5bf8}']), ('\u{2f29}', &['\u{5c0f}']), ('\u{2f2a}', &['\u{5c22}']), ('\u{2f2b}',
        &['\u{5c38}']), ('\u{2f2c}', &['\u{5c6e}']), ('\u{2f2d}', &['\u{5c71}']), ('\u{2f2e}',
        &['\u{5ddb}']), ('\u{2f2f}', &['\u{5de5}']), ('\u{2f30}', &['\u{5df1}']), ('\u{2f31}',
        &['\u{5dfe}']), ('\u{2f32}', &['\u{5e72}']), ('\u{2f33}', &['\u{5e7a}']), ('\u{2f34}',
        &['\u{5e7f}']), ('\u{2f35}', &['\u{5ef4}']), ('\u{2f36}', &['\u{5efe}']), ('\u{2f37}',
        &['\u{5f0b}']), ('\u{2f38}', &['\u{5f13}']), ('\u{2f39}', &['\u{5f50}']), ('\u{2f3a}',
        &['\u{5f61}']), ('\u{2f3b}', &['\u{5f73}']), ('\u{2f3c}', &['\u{5fc3}']), ('\u{2f3d}',
        &['\u{6208}']), ('\u{2f3e}', &['\u{6236}']), ('\u{2f3f}', &['\u{624b}']), ('\u{2f40}',
        &['\u{652f}']), ('\u{2f41}', &['\u{6534}']), ('\u{2f42}', &['\u{6587}']), ('\u{2f43}',
        &['\u{6597}']), ('\u{2f44}', &['\u{65a4}']), ('\u{2f45}', &['\u{65b9}']), ('\u{2f46}',
        &['\u{65e0}']), ('\u{2f47}', &['\u{65e5}']), ('\u{2f48}', &['\u{66f0}']), ('\u{2f49}',
        &['\u{6708}']), ('\u{2f4a}', &['\u{6728}']), ('\u{2f4b}', &['\u{6b20}']), ('\u{2f4c}',
        &['\u{6b62}']), ('\u{2f4d}', &['\u{6b79}']), ('\u{2f4e}', &['\u{6bb3}']), ('\u{2f4f}',
        &['\u{6bcb}']), ('\u{2f50}', &['\u{6bd4}']), ('\u{2f51}', &['\u{6bdb}']), ('\u{2f52}',
        &['\u{6c0f}']), ('\u{2f53}', &['\u{6c14}']), ('\u{2f54}', &['\u{6c34}']), ('\u{2f55}',
        &['\u{706b}']), ('\u{2f56}', &['\u{722a}']), ('\u{2f57}', &['\u{7236}']), ('\u{2f58}',
        &['\u{723b}']), ('\u{2f59}', &['\u{723f}']), ('\u{2f5a}', &['\u{7247}']), ('\u{2f5b}',
        &['\u{7259}']), ('\u{2f5c}', &['\u{725b}']), ('\u{2f5d}', &['\u{72ac}']), ('\u{2f5e}',
        &['\u{7384}']), ('\u{2f5f}', &['\u{7389}']), ('\u{2f60}', &['\u{74dc}']), ('\u{2f61}',
        &['\u{74e6}']), ('\u{2f62}', &['\u{7518}']), ('\u{2f63}', &['\u{751f}']), ('\u{2f64}',
        &['\u{7528}']), ('\u{2f65}', &['\u{7530}']), ('\u{2f66}', &['\u{758b}']), ('\u{2f67}',
        &['\u{7592}']), ('\u{2f68}', &['\u{7676}']), ('\u{2f69}', &['\u{767d}']), ('\u{2f6a}',
        &['\u{76ae}']), ('\u{2f6b}', &['\u{76bf}']), ('\u{2f6c}', &['\u{76ee}']), ('\u{2f6d}',
        &['\u{77db}']), ('\u{2f6e}', &['\u{77e2}']), ('\u{2f6f}', &['\u{77f3}']), ('\u{2f70}',
        &['\u{793a}']), ('\u{2f71}', &['\u{79b8}']), ('\u{2f72}', &['\u{79be}']), ('\u{2f73}',
        &['\u{7a74}']), ('\u{2f74}', &['\u{7acb}']), ('\u{2f75}', &['\u{7af9}']), ('\u{2f76}',
        &['\u{7c73}']), ('\u{2f77}', &['\u{7cf8}']), ('\u{2f78}', &['\u{7f36}']), ('\u{2f79}',
        &['\u{7f51}']), ('\u{2f7a}', &['\u{7f8a}']), ('\u{2f7b}', &['\u{7fbd}']), ('\u{2f7c}',
        &['\u{8001}']), ('\u{2f7d}', &['\u{800c}']), ('\u{2f7e}', &['\u{8012}']), ('\u{2f7f}',
        &['\u{8033}']), ('\u{2f80}', &['\u{807f}']), ('\u{2f81}', &['\u{8089}']), ('\u{2f82}',
        &['\u{81e3}']), ('\u{2f83}', &['\u{81ea}']), ('\u{2f84}', &['\u{81f3}']), ('\u{2f85}',
        &['\u{81fc}']), ('\u{2f86}', &['\u{820c}']), ('\u{2f87}', &['\u{821b}']), ('\u{2f88}',
        &['\u{821f}']), ('\u{2f89}', &['\u{826e}']), ('\u{2f8a}', &['\u{8272}']), ('\u{2f8b}',
        &['\u{8278}']), ('\u{2f8c}', &['\u{864d}']), ('\u{2f8d}', &['\u{866b}']), ('\u{2f8e}',
        &['\u{8840}']), ('\u{2f8f}', &['\u{884c}']), ('\u{2f90}', &['\u{8863}']), ('\u{2f91}',
        &['\u{897e}']), ('\u{2f92}', &['\u{898b}']), ('\u{2f93}', &['\u{89d2}']), ('\u{2f94}',
        &['\u{8a00}']), ('\u{2f95}', &['\u{8c37}']), ('\u{2f96}', &['\u{8c46}']), ('\u{2f97}',
        &['\u{8c55}']), ('\u{2f98}', &['\u{8c78}']), ('\u{2f99}', &['\u{8c9d}']), ('\u{2f9a}',
        &['\u{8d64}']), ('\u{2f9b}', &['\u{8d70}']), ('\u{2f9c}', &['\u{8db3}']), ('\u{2f9d}',
        &['\u{8eab}']), ('\u{2f9e}', &['\u{8eca}']), ('\u{2f9f}', &['\u{8f9b}']), ('\u{2fa0}',
        &['\u{8fb0}']), ('\u{2fa1}', &['\u{8fb5}']), ('\u{2fa2}', &['\u{9091}']), ('\u{2fa3}',
        &['\u{9149}']), ('\u{2fa4}', &['\u{91c6}']), ('\u{2fa5}', &['\u{91cc}']), ('\u{2fa6}',
        &['\u{91d1}']), ('\u{2fa7}', &['\u{9577}']), ('\u{2fa8}', &['\u{9580}']), ('\u{2fa9}',
        &['\u{961c}']), ('\u{2faa}', &['\u{96b6}']), ('\u{2fab}', &['\u{96b9}']), ('\u{2fac}',
        &['\u{96e8}']), ('\u{2fad}', &['\u{9751}']), ('\u{2fae}', &['\u{975e}']), ('\u{2faf}',
        &['\u{9762}']), ('\u{2fb0}', &['\u{9769}']), ('\u{2fb1}', &['\u{97cb}']), ('\u{2fb2}',
        &['\u{97ed}']), ('\u{2fb3}', &['\u{97f3}']), ('\u{2fb4}', &['\u{9801}']), ('\u{2fb5}',
        &['\u{98a8}']), ('\u{2fb6}', &['\u{98db}']), ('\u{2fb7}', &['\u{98df}']), ('\u{2fb8}',
        &['\u{9996}']), ('\u{2fb9}', &['\u{9999}']), ('\u{2fba}', &['\u{99ac}']), ('\u{2fbb}',
        &['\u{9aa8}']), ('\u{2fbc}', &['\u{9ad8}']), ('\u{2fbd}', &['\u{9adf}']), ('\u{2fbe}',
        &['\u{9b25}']), ('\u{2fbf}', &['\u{9b2f}']), ('\u{2fc0}', &['\u{9b32}']), ('\u{2fc1}',
        &['\u{9b3c}']), ('\u{2fc2}', &['\u{9b5a}']), ('\u{2fc3}', &['\u{9ce5}']), ('\u{2fc4}',
        &['\u{9e75}']), ('\u{2fc5}', &['\u{9e7f}']), ('\u{2fc6}', &['\u{9ea5}']), ('\u{2fc7}',
        &['\u{9ebb}']), ('\u{2fc8}', &['\u{9ec3}']), ('\u{2fc9}', &['\u{9ecd}']), ('\u{2fca}',
        &['\u{9ed1}']), ('\u{2fcb}', &['\u{9ef9}']), ('\u{2fcc}', &['\u{9efd}']), ('\u{2fcd}',
        &['\u{9f0e}']), ('\u{2fce}', &['\u{9f13}']), ('\u{2fcf}', &['\u{9f20}']), ('\u{2fd0}',
        &['\u{9f3b}']), ('\u{2fd1}', &['\u{9f4a}']), ('\u{2fd2}', &['\u{9f52}']), ('\u{2fd3}',
        &['\u{9f8d}']), ('\u{2fd4}', &['\u{9f9c}']), ('\u{2fd5}', &['\u{9fa0}']), ('\u{3000}',
        &['\u{20}']), ('\u{3036}', &['\u{3012}']), ('\u{3038}', &['\u{5341}']), ('\u{3039}',
        &['\u{5344}']), ('\u{303a}', &['\u{5345}']), ('\u{309b}', &['\u{20}', '\u{3099}']),
        ('\u{309c}', &['\u{20}', '\u{309a}']), ('\u{309f}', &['\u{3088}', '\u{308a}']), ('\u{30ff}',
        &['\u{30b3}', '\u{30c8}']), ('\u{3131}', &['\u{1100}']), ('\u{3132}', &['\u{1101}']),
        ('\u{3133}', &['\u{11aa}']), ('\u{3134}', &['\u{1102}']), ('\u{3135}', &['\u{11ac}']),
        ('\u{3136}', &['\u{11ad}']), ('\u{3137}', &['\u{1103}']), ('\u{3138}', &['\u{1104}']),
        ('\u{3139}', &['\u{1105}']), ('\u{313a}', &['\u{11b0}']), ('\u{313b}', &['\u{11b1}']),
        ('\u{313c}', &['\u{11b2}']), ('\u{313d}', &['\u{11b3}']), ('\u{313e}', &['\u{11b4}']),
        ('\u{313f}', &['\u{11b5}']), ('\u{3140}', &['\u{111a}']), ('\u{3141}', &['\u{1106}']),
        ('\u{3142}', &['\u{1107}']), ('\u{3143}', &['\u{1108}']), ('\u{3144}', &['\u{1121}']),
        ('\u{3145}', &['\u{1109}']), ('\u{3146}', &['\u{110a}']), ('\u{3147}', &['\u{110b}']),
        ('\u{3148}', &['\u{110c}']), ('\u{3149}', &['\u{110d}']), ('\u{314a}', &['\u{110e}']),
        ('\u{314b}', &['\u{110f}']), ('\u{314c}', &['\u{1110}']), ('\u{314d}', &['\u{1111}']),
        ('\u{314e}', &['\u{1112}']), ('\u{314f}', &['\u{1161}']), ('\u{3150}', &['\u{1162}']),
        ('\u{3151}', &['\u{1163}']), ('\u{3152}', &['\u{1164}']), ('\u{3153}', &['\u{1165}']),
        ('\u{3154}', &['\u{1166}']), ('\u{3155}', &['\u{1167}']), ('\u{3156}', &['\u{1168}']),
        ('\u{3157}', &['\u{1169}']), ('\u{3158}', &['\u{116a}']), ('\u{3159}', &['\u{116b}']),
        ('\u{315a}', &['\u{116c}']), ('\u{315b}', &['\u{116d}']), ('\u{315c}', &['\u{116e}']),
        ('\u{315d}', &['\u{116f}']), ('\u{315e}', &['\u{1170}']), ('\u{315f}', &['\u{1171}']),
        ('\u{3160}', &['\u{1172}']), ('\u{3161}', &['\u{1173}']), ('\u{3162}', &['\u{1174}']),
        ('\u{3163}', &['\u{1175}']), ('\u{3164}', &['\u{1160}']), ('\u{3165}', &['\u{1114}']),
        ('\u{3166}', &['\u{1115}']), ('\u{3167}', &['\u{11c7}']), ('\u{3168}', &['\u{11c8}']),
        ('\u{3169}', &['\u{11cc}']), ('\u{316a}', &['\u{11ce}']), ('\u{316b}', &['\u{11d3}']),
        ('\u{316c}', &['\u{11d7}']), ('\u{316d}', &['\u{11d9}']), ('\u{316e}', &['\u{111c}']),
        ('\u{316f}', &['\u{11dd}']), ('\u{3170}', &['\u{11df}']), ('\u{3171}', &['\u{111d}']),
        ('\u{3172}', &['\u{111e}']), ('\u{3173}', &['\u{1120}']), ('\u{3174}', &['\u{1122}']),
        ('\u{3175}', &['\u{1123}']), ('\u{3176}', &['\u{1127}']), ('\u{3177}', &['\u{1129}']),
        ('\u{3178}', &['\u{112b}']), ('\u{3179}', &['\u{112c}']), ('\u{317a}', &['\u{112d}']),
        ('\u{317b}', &['\u{112e}']), ('\u{317c}', &['\u{112f}']), ('\u{317d}', &['\u{1132}']),
        ('\u{317e}', &['\u{1136}']), ('\u{317f}', &['\u{1140}']), ('\u{3180}', &['\u{1147}']),
        ('\u{3181}', &['\u{114c}']), ('\u{3182}', &['\u{11f1}']), ('\u{3183}', &['\u{11f2}']),
        ('\u{3184}', &['\u{1157}']), ('\u{3185}', &['\u{1158}']), ('\u{3186}', &['\u{1159}']),
        ('\u{3187}', &['\u{1184}']), ('\u{3188}', &['\u{1185}']), ('\u{3189}', &['\u{1188}']),
        ('\u{318a}', &['\u{1191}']), ('\u{318b}', &['\u{1192}']), ('\u{318c}', &['\u{1194}']),
        ('\u{318d}', &['\u{119e}']), ('\u{318e}', &['\u{11a1}']), ('\u{3192}', &['\u{4e00}']),
        ('\u{3193}', &['\u{4e8c}']), ('\u{3194}', &['\u{4e09}']), ('\u{3195}', &['\u{56db}']),
        ('\u{3196}', &['\u{4e0a}']), ('\u{3197}', &['\u{4e2d}']), ('\u{3198}', &['\u{4e0b}']),
        ('\u{3199}', &['\u{7532}']), ('\u{319a}', &['\u{4e59}']), ('\u{319b}', &['\u{4e19}']),
        ('\u{319c}', &['\u{4e01}']), ('\u{319d}', &['\u{5929}']), ('\u{319e}', &['\u{5730}']),
        ('\u{319f}', &['\u{4eba}']), ('\u{3200}', &['\u{28}', '\u{1100}', '\u{29}']), ('\u{3201}',
        &['\u{28}', '\u{1102}', '\u{29}']), ('\u{3202}', &['\u{28}', '\u{1103}', '\u{29}']),
        ('\u{3203}', &['\u{28}', '\u{1105}', '\u{29}']), ('\u{3204}', &['\u{28}', '\u{1106}',
        '\u{29}']), ('\u{3205}', &['\u{28}', '\u{1107}', '\u{29}']), ('\u{3206}', &['\u{28}',
        '\u{1109}', '\u{29}']), ('\u{3207}', &['\u{28}', '\u{110b}', '\u{29}']), ('\u{3208}',
        &['\u{28}', '\u{110c}', '\u{29}']), ('\u{3209}', &['\u{28}', '\u{110e}', '\u{29}']),
        ('\u{320a}', &['\u{28}', '\u{110f}', '\u{29}']), ('\u{320b}', &['\u{28}', '\u{1110}',
        '\u{29}']), ('\u{320c}', &['\u{28}', '\u{1111}', '\u{29}']), ('\u{320d}', &['\u{28}',
        '\u{1112}', '\u{29}']), ('\u{320e}', &['\u{28}', '\u{1100}', '\u{1161}', '\u{29}']),
        ('\u{320f}', &['\u{28}', '\u{1102}', '\u{1161}', '\u{29}']), ('\u{3210}', &['\u{28}',
        '\u{1103}', '\u{1161}', '\u{29}']), ('\u{3211}', &['\u{28}', '\u{1105}', '\u{1161}',
        '\u{29}']), ('\u{3212}', &['\u{28}', '\u{1106}', '\u{1161}', '\u{29}']), ('\u{3213}',
        &['\u{28}', '\u{1107}', '\u{1161}', '\u{29}']), ('\u{3214}', &['\u{28}', '\u{1109}',
        '\u{1161}', '\u{29}']), ('\u{3215}', &['\u{28}', '\u{110b}', '\u{1161}', '\u{29}']),
        ('\u{3216}', &['\u{28}', '\u{110c}', '\u{1161}', '\u{29}']), ('\u{3217}', &['\u{28}',
        '\u{110e}', '\u{1161}', '\u{29}']), ('\u{3218}', &['\u{28}', '\u{110f}', '\u{1161}',
        '\u{29}']), ('\u{3219}', &['\u{28}', '\u{1110}', '\u{1161}', '\u{29}']), ('\u{321a}',
        &['\u{28}', '\u{1111}', '\u{1161}', '\u{29}']), ('\u{321b}', &['\u{28}', '\u{1112}',
        '\u{1161}', '\u{29}']), ('\u{321c}', &['\u{28}', '\u{110c}', '\u{116e}', '\u{29}']),
        ('\u{321d}', &['\u{28}', '\u{110b}', '\u{1169}', '\u{110c}', '\u{1165}', '\u{11ab}',
        '\u{29}']), ('\u{321e}', &['\u{28}', '\u{110b}', '\u{1169}', '\u{1112}', '\u{116e}',
        '\u{29}']), ('\u{3220}', &['\u{28}', '\u{4e00}', '\u{29}']), ('\u{3221}', &['\u{28}',
        '\u{4e8c}', '\u{29}']), ('\u{3222}', &['\u{28}', '\u{4e09}', '\u{29}']), ('\u{3223}',
        &['\u{28}', '\u{56db}', '\u{29}']), ('\u{3224}', &['\u{28}', '\u{4e94}', '\u{29}']),
        ('\u{3225}', &['\u{28}', '\u{516d}', '\u{29}']), ('\u{3226}', &['\u{28}', '\u{4e03}',
        '\u{29}']), ('\u{3227}', &['\u{28}', '\u{516b}', '\u{29}']), ('\u{3228}', &['\u{28}',
        '\u{4e5d}', '\u{29}']), ('\u{3229}', &['\u{28}', '\u{5341}', '\u{29}']), ('\u{322a}',
        &['\u{28}', '\u{6708}', '\u{29}']), ('\u{322b}', &['\u{28}', '\u{706b}', '\u{29}']),
        ('\u{322c}', &['\u{28}', '\u{6c34}', '\u{29}']), ('\u{322d}', &['\u{28}', '\u{6728}',
        '\u{29}']), ('\u{322e}', &['\u{28}', '\u{91d1}', '\u{29}']), ('\u{322f}', &['\u{28}',
        '\u{571f}', '\u{29}']), ('\u{3230}', &['\u{28}', '\u{65e5}', '\u{29}']), ('\u{3231}',
        &['\u{28}', '\u{682a}', '\u{29}']), ('\u{3232}', &['\u{28}', '\u{6709}', '\u{29}']),
        ('\u{3233}', &['\u{28}', '\u{793e}', '\u{29}']), ('\u{3234}', &['\u{28}', '\u{540d}',
        '\u{29}']), ('\u{3235}', &['\u{28}', '\u{7279}', '\u{29}']), ('\u{3236}', &['\u{28}',
        '\u{8ca1}', '\u{29}']), ('\u{3237}', &['\u{28}', '\u{795d}', '\u{29}']), ('\u{3238}',
        &['\u{28}', '\u{52b4}', '\u{29}']), ('\u{3239}', &['\u{28}', '\u{4ee3}', '\u{29}']),
        ('\u{323a}', &['\u{28}', '\u{547c}', '\u{29}']), ('\u{323b}', &['\u{28}', '\u{5b66}',
        '\u{29}']), ('\u{323c}', &['\u{28}', '\u{76e3}', '\u{29}']), ('\u{323d}', &['\u{28}',
        '\u{4f01}', '\u{29}']), ('\u{323e}', &['\u{28}', '\u{8cc7}', '\u{29}']), ('\u{323f}',
        &['\u{28}', '\u{5354}', '\u{29}']), ('\u{3240}', &['\u{28}', '\u{796d}', '\u{29}']),
        ('\u{3241}', &['\u{28}', '\u{4f11}', '\u{29}']), ('\u{3242}', &['\u{28}', '\u{81ea}',
        '\u{29}']), ('\u{3243}', &['\u{28}', '\u{81f3}', '\u{29}']), ('\u{3244}', &['\u{554f}']),
        ('\u{3245}', &['\u{5e7c}']), ('\u{3246}', &['\u{6587}']), ('\u{3247}', &['\u{7b8f}']),
        ('\u{3250}', &['\u{50}', '\u{54}', '\u{45}']), ('\u{3251}', &['\u{32}', '\u{31}']),
        ('\u{3252}', &['\u{32}', '\u{32}']), ('\u{3253}', &['\u{32}', '\u{33}']), ('\u{3254}',
        &['\u{32}', '\u{34}']), ('\u{3255}', &['\u{32}', '\u{35}']), ('\u{3256}', &['\u{32}',
        '\u{36}']), ('\u{3257}', &['\u{32}', '\u{37}']), ('\u{3258}', &['\u{32}', '\u{38}']),
        ('\u{3259}', &['\u{32}', '\u{39}']), ('\u{325a}', &['\u{33}', '\u{30}']), ('\u{325b}',
        &['\u{33}', '\u{31}']), ('\u{325c}', &['\u{33}', '\u{32}']), ('\u{325d}', &['\u{33}',
        '\u{33}']), ('\u{325e}', &['\u{33}', '\u{34}']), ('\u{325f}', &['\u{33}', '\u{35}']),
        ('\u{3260}', &['\u{1100}']), ('\u{3261}', &['\u{1102}']), ('\u{3262}', &['\u{1103}']),
        ('\u{3263}', &['\u{1105}']), ('\u{3264}', &['\u{1106}']), ('\u{3265}', &['\u{1107}']),
        ('\u{3266}', &['\u{1109}']), ('\u{3267}', &['\u{110b}']), ('\u{3268}', &['\u{110c}']),
        ('\u{3269}', &['\u{110e}']), ('\u{326a}', &['\u{110f}']), ('\u{326b}', &['\u{1110}']),
        ('\u{326c}', &['\u{1111}']), ('\u{326d}', &['\u{1112}']), ('\u{326e}', &['\u{1100}',
        '\u{1161}']), ('\u{326f}', &['\u{1102}', '\u{1161}']), ('\u{3270}', &['\u{1103}',
        '\u{1161}']), ('\u{3271}', &['\u{1105}', '\u{1161}']), ('\u{3272}', &['\u{1106}',
        '\u{1161}']), ('\u{3273}', &['\u{1107}', '\u{1161}']), ('\u{3274}', &['\u{1109}',
        '\u{1161}']), ('\u{3275}', &['\u{110b}', '\u{1161}']), ('\u{3276}', &['\u{110c}',
        '\u{1161}']), ('\u{3277}', &['\u{110e}', '\u{1161}']), ('\u{3278}', &['\u{110f}',
        '\u{1161}']), ('\u{3279}', &['\u{1110}', '\u{1161}']), ('\u{327a}', &['\u{1111}',
        '\u{1161}']), ('\u{327b}', &['\u{1112}', '\u{1161}']), ('\u{327c}', &['\u{110e}',
        '\u{1161}', '\u{11b7}', '\u{1100}', '\u{1169}']), ('\u{327d}', &['\u{110c}', '\u{116e}',
        '\u{110b}', '\u{1174}']), ('\u{327e}', &['\u{110b}', '\u{116e}']), ('\u{3280}',
        &['\u{4e00}']), ('\u{3281}', &['\u{4e8c}']), ('\u{3282}', &['\u{4e09}']), ('\u{3283}',
        &['\u{56db}']), ('\u{3284}', &['\u{4e94}']), ('\u{3285}', &['\u{516d}']), ('\u{3286}',
        &['\u{4e03}']), ('\u{3287}', &['\u{516b}']), ('\u{3288}', &['\u{4e5d}']), ('\u{3289}',
        &['\u{5341}']), ('\u{328a}', &['\u{6708}']), ('\u{328b}', &['\u{706b}']), ('\u{328c}',
        &['\u{6c34}']), ('\u{328d}', &['\u{6728}']), ('\u{328e}', &['\u{91d1}']), ('\u{328f}',
        &['\u{571f}']), ('\u{3290}', &['\u{65e5}']), ('\u{3291}', &['\u{682a}']), ('\u{3292}',
        &['\u{6709}']), ('\u{3293}', &['\u{793e}']), ('\u{3294}', &['\u{540d}']), ('\u{3295}',
        &['\u{7279}']), ('\u{3296}', &['\u{8ca1}']), ('\u{3297}', &['\u{795d}']), ('\u{3298}',
        &['\u{52b4}']), ('\u{3299}', &['\u{79d8}']), ('\u{329a}', &['\u{7537}']), ('\u{329b}',
        &['\u{5973}']), ('\u{329c}', &['\u{9069}']), ('\u{329d}', &['\u{512a}']), ('\u{329e}',
        &['\u{5370}']), ('\u{329f}', &['\u{6ce8}']), ('\u{32a0}', &['\u{9805}']), ('\u{32a1}',
        &['\u{4f11}']), ('\u{32a2}', &['\u{5199}']), ('\u{32a3}', &['\u{6b63}']), ('\u{32a4}',
        &['\u{4e0a}']), ('\u{32a5}', &['\u{4e2d}']), ('\u{32a6}', &['\u{4e0b}']), ('\u{32a7}',
        &['\u{5de6}']), ('\u{32a8}', &['\u{53f3}']), ('\u{32a9}', &['\u{533b}']), ('\u{32aa}',
        &['\u{5b97}']), ('\u{32ab}', &['\u{5b66}']), ('\u{32ac}', &['\u{76e3}']), ('\u{32ad}',
        &['\u{4f01}']), ('\u{32ae}', &['\u{8cc7}']), ('\u{32af}', &['\u{5354}']), ('\u{32b0}',
        &['\u{591c}']), ('\u{32b1}', &['\u{33}', '\u{36}']), ('\u{32b2}', &['\u{33}', '\u{37}']),
        ('\u{32b3}', &['\u{33}', '\u{38}']), ('\u{32b4}', &['\u{33}', '\u{39}']), ('\u{32b5}',
        &['\u{34}', '\u{30}']), ('\u{32b6}', &['\u{34}', '\u{31}']), ('\u{32b7}', &['\u{34}',
        '\u{32}']), ('\u{32b8}', &['\u{34}', '\u{33}']), ('\u{32b9}', &['\u{34}', '\u{34}']),
        ('\u{32ba}', &['\u{34}', '\u{35}']), ('\u{32bb}', &['\u{34}', '\u{36}']), ('\u{32bc}',
        &['\u{34}', '\u{37}']), ('\u{32bd}', &['\u{34}', '\u{38}']), ('\u{32be}', &['\u{34}',
        '\u{39}']), ('\u{32bf}', &['\u{35}', '\u{30}']), ('\u{32c0}', &['\u{31}', '\u{6708}']),
        ('\u{32c1}', &['\u{32}', '\u{6708}']), ('\u{32c2}', &['\u{33}', '\u{6708}']), ('\u{32c3}',
        &['\u{34}', '\u{6708}']), ('\u{32c4}', &['\u{35}', '\u{6708}']), ('\u{32c5}', &['\u{36}',
        '\u{6708}']), ('\u{32c6}', &['\u{37}', '\u{6708}']), ('\u{32c7}', &['\u{38}', '\u{6708}']),
        ('\u{32c8}', &['\u{39}', '\u{6708}']), ('\u{32c9}', &['\u{31}', '\u{30}', '\u{6708}']),
        ('\u{32ca}', &['\u{31}', '\u{31}', '\u{6708}']), ('\u{32cb}', &['\u{31}', '\u{32}',
        '\u{6708}']), ('\u{32cc}', &['\u{48}', '\u{67}']), ('\u{32cd}', &['\u{65}', '\u{72}',
        '\u{67}']), ('\u{32ce}', &['\u{65}', '\u{56}']), ('\u{32cf}', &['\u{4c}', '\u{54}',
        '\u{44}']), ('\u{32d0}', &['\u{30a2}']), ('\u{32d1}', &['\u{30a4}']), ('\u{32d2}',
        &['\u{30a6}']), ('\u{32d3}', &['\u{30a8}']), ('\u{32d4}', &['\u{30aa}']), ('\u{32d5}',
        &['\u{30ab}']), ('\u{32d6}', &['\u{30ad}']), ('\u{32d7}', &['\u{30af}']), ('\u{32d8}',
        &['\u{30b1}']), ('\u{32d9}', &['\u{30b3}']), ('\u{32da}', &['\u{30b5}']), ('\u{32db}',
        &['\u{30b7}']), ('\u{32dc}', &['\u{30b9}']), ('\u{32dd}', &['\u{30bb}']), ('\u{32de}',
        &['\u{30bd}']), ('\u{32df}', &['\u{30bf}']), ('\u{32e0}', &['\u{30c1}']), ('\u{32e1}',
        &['\u{30c4}']), ('\u{32e2}', &['\u{30c6}']), ('\u{32e3}', &['\u{30c8}']), ('\u{32e4}',
        &['\u{30ca}']), ('\u{32e5}', &['\u{30cb}']), ('\u{32e6}', &['\u{30cc}']), ('\u{32e7}',
        &['\u{30cd}']), ('\u{32e8}', &['\u{30ce}']), ('\u{32e9}', &['\u{30cf}']), ('\u{32ea}',
        &['\u{30d2}']), ('\u{32eb}', &['\u{30d5}']), ('\u{32ec}', &['\u{30d8}']), ('\u{32ed}',
        &['\u{30db}']), ('\u{32ee}', &['\u{30de}']), ('\u{32ef}', &['\u{30df}']), ('\u{32f0}',
        &['\u{30e0}']), ('\u{32f1}', &['\u{30e1}']), ('\u{32f2}', &['\u{30e2}']), ('\u{32f3}',
        &['\u{30e4}']), ('\u{32f4}', &['\u{30e6}']), ('\u{32f5}', &['\u{30e8}']), ('\u{32f6}',
        &['\u{30e9}']), ('\u{32f7}', &['\u{30ea}']), ('\u{32f8}', &['\u{30eb}']), ('\u{32f9}',
        &['\u{30ec}']), ('\u{32fa}', &['\u{30ed}']), ('\u{32fb}', &['\u{30ef}']), ('\u{32fc}',
        &['\u{30f0}']), ('\u{32fd}', &['\u{30f1}']), ('\u{32fe}', &['\u{30f2}']), ('\u{3300}',
        &['\u{30a2}', '\u{30d1}', '\u{30fc}', '\u{30c8}']), ('\u{3301}', &['\u{30a2}', '\u{30eb}',
        '\u{30d5}', '\u{30a1}']), ('\u{3302}', &['\u{30a2}', '\u{30f3}', '\u{30da}', '\u{30a2}']),
        ('\u{3303}', &['\u{30a2}', '\u{30fc}', '\u{30eb}']), ('\u{3304}', &['\u{30a4}', '\u{30cb}',
        '\u{30f3}', '\u{30b0}']), ('\u{3305}', &['\u{30a4}', '\u{30f3}', '\u{30c1}']), ('\u{3306}',
        &['\u{30a6}', '\u{30a9}', '\u{30f3}']), ('\u{3307}', &['\u{30a8}', '\u{30b9}', '\u{30af}',
        '\u{30fc}', '\u{30c9}']), ('\u{3308}', &['\u{30a8}', '\u{30fc}', '\u{30ab}', '\u{30fc}']),
        ('\u{3309}', &['\u{30aa}', '\u{30f3}', '\u{30b9}']), ('\u{330a}', &['\u{30aa}', '\u{30fc}',
        '\u{30e0}']), ('\u{330b}', &['\u{30ab}', '\u{30a4}', '\u{30ea}']), ('\u{330c}',
        &['\u{30ab}', '\u{30e9}', '\u{30c3}', '\u{30c8}']), ('\u{330d}', &['\u{30ab}', '\u{30ed}',
        '\u{30ea}', '\u{30fc}']), ('\u{330e}', &['\u{30ac}', '\u{30ed}', '\u{30f3}']), ('\u{330f}',
        &['\u{30ac}', '\u{30f3}', '\u{30de}']), ('\u{3310}', &['\u{30ae}', '\u{30ac}']),
        ('\u{3311}', &['\u{30ae}', '\u{30cb}', '\u{30fc}']), ('\u{3312}', &['\u{30ad}', '\u{30e5}',
        '\u{30ea}', '\u{30fc}']), ('\u{3313}', &['\u{30ae}', '\u{30eb}', '\u{30c0}', '\u{30fc}']),
        ('\u{3314}', &['\u{30ad}', '\u{30ed}']), ('\u{3315}', &['\u{30ad}', '\u{30ed}', '\u{30b0}',
        '\u{30e9}', '\u{30e0}']), ('\u{3316}', &['\u{30ad}', '\u{30ed}', '\u{30e1}', '\u{30fc}',
        '\u{30c8}', '\u{30eb}']), ('\u{3317}', &['\u{30ad}', '\u{30ed}', '\u{30ef}', '\u{30c3}',
        '\u{30c8}']), ('\u{3318}', &['\u{30b0}', '\u{30e9}', '\u{30e0}']), ('\u{3319}',
        &['\u{30b0}', '\u{30e9}', '\u{30e0}', '\u{30c8}', '\u{30f3}']), ('\u{331a}', &['\u{30af}',
        '\u{30eb}', '\u{30bc}', '\u{30a4}', '\u{30ed}']), ('\u{331b}', &['\u{30af}', '\u{30ed}',
        '\u{30fc}', '\u{30cd}']), ('\u{331c}', &['\u{30b1}', '\u{30fc}', '\u{30b9}']), ('\u{331d}',
        &['\u{30b3}', '\u{30eb}', '\u{30ca}']), ('\u{331e}', &['\u{30b3}', '\u{30fc}', '\u{30dd}']),
        ('\u{331f}', &['\u{30b5}', '\u{30a4}', '\u{30af}', '\u{30eb}']), ('\u{3320}', &['\u{30b5}',
        '\u{30f3}', '\u{30c1}', '\u{30fc}', '\u{30e0}']), ('\u{3321}', &['\u{30b7}', '\u{30ea}',
        '\u{30f3}', '\u{30b0}']), ('\u{3322}', &['\u{30bb}', '\u{30f3}', '\u{30c1}']), ('\u{3323}',
        &['\u{30bb}', '\u{30f3}', '\u{30c8}']), ('\u{3324}', &['\u{30c0}', '\u{30fc}', '\u{30b9}']),
        ('\u{3325}', &['\u{30c7}', '\u{30b7}']), ('\u{3326}', &['\u{30c9}', '\u{30eb}']),
        ('\u{3327}', &['\u{30c8}', '\u{30f3}']), ('\u{3328}', &['\u{30ca}', '\u{30ce}']),
        ('\u{3329}', &['\u{30ce}', '\u{30c3}', '\u{30c8}']), ('\u{332a}', &['\u{30cf}', '\u{30a4}',
        '\u{30c4}']), ('\u{332b}', &['\u{30d1}', '\u{30fc}', '\u{30bb}', '\u{30f3}', '\u{30c8}']),
        ('\u{332c}', &['\u{30d1}', '\u{30fc}', '\u{30c4}']), ('\u{332d}', &['\u{30d0}', '\u{30fc}',
        '\u{30ec}', '\u{30eb}']), ('\u{332e}', &['\u{30d4}', '\u{30a2}', '\u{30b9}', '\u{30c8}',
        '\u{30eb}']), ('\u{332f}', &['\u{30d4}', '\u{30af}', '\u{30eb}']), ('\u{3330}',
        &['\u{30d4}', '\u{30b3}']), ('\u{3331}', &['\u{30d3}', '\u{30eb}']), ('\u{3332}',
        &['\u{30d5}', '\u{30a1}', '\u{30e9}', '\u{30c3}', '\u{30c9}']), ('\u{3333}', &['\u{30d5}',
        '\u{30a3}', '\u{30fc}', '\u{30c8}']), ('\u{3334}', &['\u{30d6}', '\u{30c3}', '\u{30b7}',
        '\u{30a7}', '\u{30eb}']), ('\u{3335}', &['\u{30d5}', '\u{30e9}', '\u{30f3}']), ('\u{3336}',
        &['\u{30d8}', '\u{30af}', '\u{30bf}', '\u{30fc}', '\u{30eb}']), ('\u{3337}', &['\u{30da}',
        '\u{30bd}']), ('\u{3338}', &['\u{30da}', '\u{30cb}', '\u{30d2}']), ('\u{3339}',
        &['\u{30d8}', '\u{30eb}', '\u{30c4}']), ('\u{333a}', &['\u{30da}', '\u{30f3}', '\u{30b9}']),
        ('\u{333b}', &['\u{30da}', '\u{30fc}', '\u{30b8}']), ('\u{333c}', &['\u{30d9}', '\u{30fc}',
        '\u{30bf}']), ('\u{333d}', &['\u{30dd}', '\u{30a4}', '\u{30f3}', '\u{30c8}']), ('\u{333e}',
        &['\u{30dc}', '\u{30eb}', '\u{30c8}']), ('\u{333f}', &['\u{30db}', '\u{30f3}']),
        ('\u{3340}', &['\u{30dd}', '\u{30f3}', '\u{30c9}']), ('\u{3341}', &['\u{30db}', '\u{30fc}',
        '\u{30eb}']), ('\u{3342}', &['\u{30db}', '\u{30fc}', '\u{30f3}']), ('\u{3343}',
        &['\u{30de}', '\u{30a4}', '\u{30af}', '\u{30ed}']), ('\u{3344}', &['\u{30de}', '\u{30a4}',
        '\u{30eb}']), ('\u{3345}', &['\u{30de}', '\u{30c3}', '\u{30cf}']), ('\u{3346}',
        &['\u{30de}', '\u{30eb}', '\u{30af}']), ('\u{3347}', &['\u{30de}', '\u{30f3}', '\u{30b7}',
        '\u{30e7}', '\u{30f3}']), ('\u{3348}', &['\u{30df}', '\u{30af}', '\u{30ed}', '\u{30f3}']),
        ('\u{3349}', &['\u{30df}', '\u{30ea}']), ('\u{334a}', &['\u{30df}', '\u{30ea}', '\u{30d0}',
        '\u{30fc}', '\u{30eb}']), ('\u{334b}', &['\u{30e1}', '\u{30ac}']), ('\u{334c}',
        &['\u{30e1}', '\u{30ac}', '\u{30c8}', '\u{30f3}']), ('\u{334d}', &['\u{30e1}', '\u{30fc}',
        '\u{30c8}', '\u{30eb}']), ('\u{334e}', &['\u{30e4}', '\u{30fc}', '\u{30c9}']), ('\u{334f}',
        &['\u{30e4}', '\u{30fc}', '\u{30eb}']), ('\u{3350}', &['\u{30e6}', '\u{30a2}', '\u{30f3}']),
        ('\u{3351}', &['\u{30ea}', '\u{30c3}', '\u{30c8}', '\u{30eb}']), ('\u{3352}', &['\u{30ea}',
        '\u{30e9}']), ('\u{3353}', &['\u{30eb}', '\u{30d4}', '\u{30fc}']), ('\u{3354}',
        &['\u{30eb}', '\u{30fc}', '\u{30d6}', '\u{30eb}']), ('\u{3355}', &['\u{30ec}', '\u{30e0}']),
        ('\u{3356}', &['\u{30ec}', '\u{30f3}', '\u{30c8}', '\u{30b2}', '\u{30f3}']), ('\u{3357}',
        &['\u{30ef}', '\u{30c3}', '\u{30c8}']), ('\u{3358}', &['\u{30}', '\u{70b9}']), ('\u{3359}',
        &['\u{31}', '\u{70b9}']), ('\u{335a}', &['\u{32}', '\u{70b9}']), ('\u{335b}', &['\u{33}',
        '\u{70b9}']), ('\u{335c}', &['\u{34}', '\u{70b9}']), ('\u{335d}', &['\u{35}', '\u{70b9}']),
        ('\u{335e}', &['\u{36}', '\u{70b9}']), ('\u{335f}', &['\u{37}', '\u{70b9}']), ('\u{3360}',
        &['\u{38}', '\u{70b9}']), ('\u{3361}', &['\u{39}', '\u{70b9}']), ('\u{3362}', &['\u{31}',
        '\u{30}', '\u{70b9}']), ('\u{3363}', &['\u{31}', '\u{31}', '\u{70b9}']), ('\u{3364}',
        &['\u{31}', '\u{32}', '\u{70b9}']), ('\u{3365}', &['\u{31}', '\u{33}', '\u{70b9}']),
        ('\u{3366}', &['\u{31}', '\u{34}', '\u{70b9}']), ('\u{3367}', &['\u{31}', '\u{35}',
        '\u{70b9}']), ('\u{3368}', &['\u{31}', '\u{36}', '\u{70b9}']), ('\u{3369}', &['\u{31}',
        '\u{37}', '\u{70b9}']), ('\u{336a}', &['\u{31}', '\u{38}', '\u{70b9}']), ('\u{336b}',
        &['\u{31}', '\u{39}', '\u{70b9}']), ('\u{336c}', &['\u{32}', '\u{30}', '\u{70b9}']),
        ('\u{336d}', &['\u{32}', '\u{31}', '\u{70b9}']), ('\u{336e}', &['\u{32}', '\u{32}',
        '\u{70b9}']), ('\u{336f}', &['\u{32}', '\u{33}', '\u{70b9}']), ('\u{3370}', &['\u{32}',
        '\u{34}', '\u{70b9}']), ('\u{3371}', &['\u{68}', '\u{50}', '\u{61}']), ('\u{3372}',
        &['\u{64}', '\u{61}']), ('\u{3373}', &['\u{41}', '\u{55}']), ('\u{3374}', &['\u{62}',
        '\u{61}', '\u{72}']), ('\u{3375}', &['\u{6f}', '\u{56}']), ('\u{3376}', &['\u{70}',
        '\u{63}']), ('\u{3377}', &['\u{64}', '\u{6d}']), ('\u{3378}', &['\u{64}', '\u{6d}',
        '\u{b2}']), ('\u{3379}', &['\u{64}', '\u{6d}', '\u{b3}']), ('\u{337a}', &['\u{49}',
        '\u{55}']), ('\u{337b}', &['\u{5e73}', '\u{6210}']), ('\u{337c}', &['\u{662d}',
        '\u{548c}']), ('\u{337d}', &['\u{5927}', '\u{6b63}']), ('\u{337e}', &['\u{660e}',
        '\u{6cbb}']), ('\u{337f}', &['\u{682a}', '\u{5f0f}', '\u{4f1a}', '\u{793e}']), ('\u{3380}',
        &['\u{70}', '\u{41}']), ('\u{3381}', &['\u{6e}', '\u{41}']), ('\u{3382}', &['\u{3bc}',
        '\u{41}']), ('\u{3383}', &['\u{6d}', '\u{41}']), ('\u{3384}', &['\u{6b}', '\u{41}']),
        ('\u{3385}', &['\u{4b}', '\u{42}']), ('\u{3386}', &['\u{4d}', '\u{42}']), ('\u{3387}',
        &['\u{47}', '\u{42}']), ('\u{3388}', &['\u{63}', '\u{61}', '\u{6c}']), ('\u{3389}',
        &['\u{6b}', '\u{63}', '\u{61}', '\u{6c}']), ('\u{338a}', &['\u{70}', '\u{46}']),
        ('\u{338b}', &['\u{6e}', '\u{46}']), ('\u{338c}', &['\u{3bc}', '\u{46}']), ('\u{338d}',
        &['\u{3bc}', '\u{67}']), ('\u{338e}', &['\u{6d}', '\u{67}']), ('\u{338f}', &['\u{6b}',
        '\u{67}']), ('\u{3390}', &['\u{48}', '\u{7a}']), ('\u{3391}', &['\u{6b}', '\u{48}',
        '\u{7a}']), ('\u{3392}', &['\u{4d}', '\u{48}', '\u{7a}']), ('\u{3393}', &['\u{47}',
        '\u{48}', '\u{7a}']), ('\u{3394}', &['\u{54}', '\u{48}', '\u{7a}']), ('\u{3395}',
        &['\u{3bc}', '\u{2113}']), ('\u{3396}', &['\u{6d}', '\u{2113}']), ('\u{3397}', &['\u{64}',
        '\u{2113}']), ('\u{3398}', &['\u{6b}', '\u{2113}']), ('\u{3399}', &['\u{66}', '\u{6d}']),
        ('\u{339a}', &['\u{6e}', '\u{6d}']), ('\u{339b}', &['\u{3bc}', '\u{6d}']), ('\u{339c}',
        &['\u{6d}', '\u{6d}']), ('\u{339d}', &['\u{63}', '\u{6d}']), ('\u{339e}', &['\u{6b}',
        '\u{6d}']), ('\u{339f}', &['\u{6d}', '\u{6d}', '\u{b2}']), ('\u{33a0}', &['\u{63}',
        '\u{6d}', '\u{b2}']), ('\u{33a1}', &['\u{6d}', '\u{b2}']), ('\u{33a2}', &['\u{6b}',
        '\u{6d}', '\u{b2}']), ('\u{33a3}', &['\u{6d}', '\u{6d}', '\u{b3}']), ('\u{33a4}',
        &['\u{63}', '\u{6d}', '\u{b3}']), ('\u{33a5}', &['\u{6d}', '\u{b3}']), ('\u{33a6}',
        &['\u{6b}', '\u{6d}', '\u{b3}']), ('\u{33a7}', &['\u{6d}', '\u{2215}', '\u{73}']),
        ('\u{33a8}', &['\u{6d}', '\u{2215}', '\u{73}', '\u{b2}']), ('\u{33a9}', &['\u{50}',
        '\u{61}']), ('\u{33aa}', &['\u{6b}', '\u{50}', '\u{61}']), ('\u{33ab}', &['\u{4d}',
        '\u{50}', '\u{61}']), ('\u{33ac}', &['\u{47}', '\u{50}', '\u{61}']), ('\u{33ad}',
        &['\u{72}', '\u{61}', '\u{64}']), ('\u{33ae}', &['\u{72}', '\u{61}', '\u{64}', '\u{2215}',
        '\u{73}']), ('\u{33af}', &['\u{72}', '\u{61}', '\u{64}', '\u{2215}', '\u{73}', '\u{b2}']),
        ('\u{33b0}', &['\u{70}', '\u{73}']), ('\u{33b1}', &['\u{6e}', '\u{73}']), ('\u{33b2}',
        &['\u{3bc}', '\u{73}']), ('\u{33b3}', &['\u{6d}', '\u{73}']), ('\u{33b4}', &['\u{70}',
        '\u{56}']), ('\u{33b5}', &['\u{6e}', '\u{56}']), ('\u{33b6}', &['\u{3bc}', '\u{56}']),
        ('\u{33b7}', &['\u{6d}', '\u{56}']), ('\u{33b8}', &['\u{6b}', '\u{56}']), ('\u{33b9}',
        &['\u{4d}', '\u{56}']), ('\u{33ba}', &['\u{70}', '\u{57}']), ('\u{33bb}', &['\u{6e}',
        '\u{57}']), ('\u{33bc}', &['\u{3bc}', '\u{57}']), ('\u{33bd}', &['\u{6d}', '\u{57}']),
        ('\u{33be}', &['\u{6b}', '\u{57}']), ('\u{33bf}', &['\u{4d}', '\u{57}']), ('\u{33c0}',
        &['\u{6b}', '\u{3a9}']), ('\u{33c1}', &['\u{4d}', '\u{3a9}']), ('\u{33c2}', &['\u{61}',
        '\u{2e}', '\u{6d}', '\u{2e}']), ('\u{33c3}', &['\u{42}', '\u{71}']), ('\u{33c4}',
        &['\u{63}', '\u{63}']), ('\u{33c5}', &['\u{63}', '\u{64}']), ('\u{33c6}', &['\u{43}',
        '\u{2215}', '\u{6b}', '\u{67}']), ('\u{33c7}', &['\u{43}', '\u{6f}', '\u{2e}']),
        ('\u{33c8}', &['\u{64}', '\u{42}']), ('\u{33c9}', &['\u{47}', '\u{79}']), ('\u{33ca}',
        &['\u{68}', '\u{61}']), ('\u{33cb}', &['\u{48}', '\u{50}']), ('\u{33cc}', &['\u{69}',
        '\u{6e}']), ('\u{33cd}', &['\u{4b}', '\u{4b}']), ('\u{33ce}', &['\u{4b}', '\u{4d}']),
        ('\u{33cf}', &['\u{6b}', '\u{74}']), ('\u{33d0}', &['\u{6c}', '\u{6d}']), ('\u{33d1}',
        &['\u{6c}', '\u{6e}']), ('\u{33d2}', &['\u{6c}', '\u{6f}', '\u{67}']), ('\u{33d3}',
        &['\u{6c}', '\u{78}']), ('\u{33d4}', &['\u{6d}', '\u{62}']), ('\u{33d5}', &['\u{6d}',
        '\u{69}', '\u{6c}']), ('\u{33d6}', &['\u{6d}', '\u{6f}', '\u{6c}']), ('\u{33d7}',
        &['\u{50}', '\u{48}']), ('\u{33d8}', &['\u{70}', '\u{2e}', '\u{6d}', '\u{2e}']),
        ('\u{33d9}', &['\u{50}', '\u{50}', '\u{4d}']), ('\u{33da}', &['\u{50}', '\u{52}']),
        ('\u{33db}', &['\u{73}', '\u{72}']), ('\u{33dc}', &['\u{53}', '\u{76}']), ('\u{33dd}',
        &['\u{57}', '\u{62}']), ('\u{33de}', &['\u{56}', '\u{2215}', '\u{6d}']), ('\u{33df}',
        &['\u{41}', '\u{2215}', '\u{6d}']), ('\u{33e0}', &['\u{31}', '\u{65e5}']), ('\u{33e1}',
        &['\u{32}', '\u{65e5}']), ('\u{33e2}', &['\u{33}', '\u{65e5}']), ('\u{33e3}', &['\u{34}',
        '\u{65e5}']), ('\u{33e4}', &['\u{35}', '\u{65e5}']), ('\u{33e5}', &['\u{36}', '\u{65e5}']),
        ('\u{33e6}', &['\u{37}', '\u{65e5}']), ('\u{33e7}', &['\u{38}', '\u{65e5}']), ('\u{33e8}',
        &['\u{39}', '\u{65e5}']), ('\u{33e9}', &['\u{31}', '\u{30}', '\u{65e5}']), ('\u{33ea}',
        &['\u{31}', '\u{31}', '\u{65e5}']), ('\u{33eb}', &['\u{31}', '\u{32}', '\u{65e5}']),
        ('\u{33ec}', &['\u{31}', '\u{33}', '\u{65e5}']), ('\u{33ed}', &['\u{31}', '\u{34}',
        '\u{65e5}']), ('\u{33ee}', &['\u{31}', '\u{35}', '\u{65e5}']), ('\u{33ef}', &['\u{31}',
        '\u{36}', '\u{65e5}']), ('\u{33f0}', &['\u{31}', '\u{37}', '\u{65e5}']), ('\u{33f1}',
        &['\u{31}', '\u{38}', '\u{65e5}']), ('\u{33f2}', &['\u{31}', '\u{39}', '\u{65e5}']),
        ('\u{33f3}', &['\u{32}', '\u{30}', '\u{65e5}']), ('\u{33f4}', &['\u{32}', '\u{31}',
        '\u{65e5}']), ('\u{33f5}', &['\u{32}', '\u{32}', '\u{65e5}']), ('\u{33f6}', &['\u{32}',
        '\u{33}', '\u{65e5}']), ('\u{33f7}', &['\u{32}', '\u{34}', '\u{65e5}']), ('\u{33f8}',
        &['\u{32}', '\u{35}', '\u{65e5}']), ('\u{33f9}', &['\u{32}', '\u{36}', '\u{65e5}']),
        ('\u{33fa}', &['\u{32}', '\u{37}', '\u{65e5}']), ('\u{33fb}', &['\u{32}', '\u{38}',
        '\u{65e5}']), ('\u{33fc}', &['\u{32}', '\u{39}', '\u{65e5}']), ('\u{33fd}', &['\u{33}',
        '\u{30}', '\u{65e5}']), ('\u{33fe}', &['\u{33}', '\u{31}', '\u{65e5}']), ('\u{33ff}',
        &['\u{67}', '\u{61}', '\u{6c}']), ('\u{a69c}', &['\u{44a}']), ('\u{a69d}', &['\u{44c}']),
        ('\u{a770}', &['\u{a76f}']), ('\u{a7f8}', &['\u{126}']), ('\u{a7f9}', &['\u{153}']),
        ('\u{ab5c}', &['\u{a727}']), ('\u{ab5d}', &['\u{ab37}']), ('\u{ab5e}', &['\u{26b}']),
        ('\u{ab5f}', &['\u{ab52}']), ('\u{fb00}', &['\u{66}', '\u{66}']), ('\u{fb01}', &['\u{66}',
        '\u{69}']), ('\u{fb02}', &['\u{66}', '\u{6c}']), ('\u{fb03}', &['\u{66}', '\u{66}',
        '\u{69}']), ('\u{fb04}', &['\u{66}', '\u{66}', '\u{6c}']), ('\u{fb05}', &['\u{17f}',
        '\u{74}']), ('\u{fb06}', &['\u{73}', '\u{74}']), ('\u{fb13}', &['\u{574}', '\u{576}']),
        ('\u{fb14}', &['\u{574}', '\u{565}']), ('\u{fb15}', &['\u{574}', '\u{56b}']), ('\u{fb16}',
        &['\u{57e}', '\u{576}']), ('\u{fb17}', &['\u{574}', '\u{56d}']), ('\u{fb20}', &['\u{5e2}']),
        ('\u{fb21}', &['\u{5d0}']), ('\u{fb22}', &['\u{5d3}']), ('\u{fb23}', &['\u{5d4}']),
        ('\u{fb24}', &['\u{5db}']), ('\u{fb25}', &['\u{5dc}']), ('\u{fb26}', &['\u{5dd}']),
        ('\u{fb27}', &['\u{5e8}']), ('\u{fb28}', &['\u{5ea}']), ('\u{fb29}', &['\u{2b}']),
        ('\u{fb4f}', &['\u{5d0}', '\u{5dc}']), ('\u{fb50}', &['\u{671}']), ('\u{fb51}',
        &['\u{671}']), ('\u{fb52}', &['\u{67b}']), ('\u{fb53}', &['\u{67b}']), ('\u{fb54}',
        &['\u{67b}']), ('\u{fb55}', &['\u{67b}']), ('\u{fb56}', &['\u{67e}']), ('\u{fb57}',
        &['\u{67e}']), ('\u{fb58}', &['\u{67e}']), ('\u{fb59}', &['\u{67e}']), ('\u{fb5a}',
        &['\u{680}']), ('\u{fb5b}', &['\u{680}']), ('\u{fb5c}', &['\u{680}']), ('\u{fb5d}',
        &['\u{680}']), ('\u{fb5e}', &['\u{67a}']), ('\u{fb5f}', &['\u{67a}']), ('\u{fb60}',
        &['\u{67a}']), ('\u{fb61}', &['\u{67a}']), ('\u{fb62}', &['\u{67f}']), ('\u{fb63}',
        &['\u{67f}']), ('\u{fb64}', &['\u{67f}']), ('\u{fb65}', &['\u{67f}']), ('\u{fb66}',
        &['\u{679}']), ('\u{fb67}', &['\u{679}']), ('\u{fb68}', &['\u{679}']), ('\u{fb69}',
        &['\u{679}']), ('\u{fb6a}', &['\u{6a4}']), ('\u{fb6b}', &['\u{6a4}']), ('\u{fb6c}',
        &['\u{6a4}']), ('\u{fb6d}', &['\u{6a4}']), ('\u{fb6e}', &['\u{6a6}']), ('\u{fb6f}',
        &['\u{6a6}']), ('\u{fb70}', &['\u{6a6}']), ('\u{fb71}', &['\u{6a6}']), ('\u{fb72}',
        &['\u{684}']), ('\u{fb73}', &['\u{684}']), ('\u{fb74}', &['\u{684}']), ('\u{fb75}',
        &['\u{684}']), ('\u{fb76}', &['\u{683}']), ('\u{fb77}', &['\u{683}']), ('\u{fb78}',
        &['\u{683}']), ('\u{fb79}', &['\u{683}']), ('\u{fb7a}', &['\u{686}']), ('\u{fb7b}',
        &['\u{686}']), ('\u{fb7c}', &['\u{686}']), ('\u{fb7d}', &['\u{686}']), ('\u{fb7e}',
        &['\u{687}']), ('\u{fb7f}', &['\u{687}']), ('\u{fb80}', &['\u{687}']), ('\u{fb81}',
        &['\u{687}']), ('\u{fb82}', &['\u{68d}']), ('\u{fb83}', &['\u{68d}']), ('\u{fb84}',
        &['\u{68c}']), ('\u{fb85}', &['\u{68c}']), ('\u{fb86}', &['\u{68e}']), ('\u{fb87}',
        &['\u{68e}']), ('\u{fb88}', &['\u{688}']), ('\u{fb89}', &['\u{688}']), ('\u{fb8a}',
        &['\u{698}']), ('\u{fb8b}', &['\u{698}']), ('\u{fb8c}', &['\u{691}']), ('\u{fb8d}',
        &['\u{691}']), ('\u{fb8e}', &['\u{6a9}']), ('\u{fb8f}', &['\u{6a9}']), ('\u{fb90}',
        &['\u{6a9}']), ('\u{fb91}', &['\u{6a9}']), ('\u{fb92}', &['\u{6af}']), ('\u{fb93}',
        &['\u{6af}']), ('\u{fb94}', &['\u{6af}']), ('\u{fb95}', &['\u{6af}']), ('\u{fb96}',
        &['\u{6b3}']), ('\u{fb97}', &['\u{6b3}']), ('\u{fb98}', &['\u{6b3}']), ('\u{fb99}',
        &['\u{6b3}']), ('\u{fb9a}', &['\u{6b1}']), ('\u{fb9b}', &['\u{6b1}']), ('\u{fb9c}',
        &['\u{6b1}']), ('\u{fb9d}', &['\u{6b1}']), ('\u{fb9e}', &['\u{6ba}']), ('\u{fb9f}',
        &['\u{6ba}']), ('\u{fba0}', &['\u{6bb}']), ('\u{fba1}', &['\u{6bb}']), ('\u{fba2}',
        &['\u{6bb}']), ('\u{fba3}', &['\u{6bb}']), ('\u{fba4}', &['\u{6c0}']), ('\u{fba5}',
        &['\u{6c0}']), ('\u{fba6}', &['\u{6c1}']), ('\u{fba7}', &['\u{6c1}']), ('\u{fba8}',
        &['\u{6c1}']), ('\u{fba9}', &['\u{6c1}']), ('\u{fbaa}', &['\u{6be}']), ('\u{fbab}',
        &['\u{6be}']), ('\u{fbac}', &['\u{6be}']), ('\u{fbad}', &['\u{6be}']), ('\u{fbae}',
        &['\u{6d2}']), ('\u{fbaf}', &['\u{6d2}']), ('\u{fbb0}', &['\u{6d3}']), ('\u{fbb1}',
        &['\u{6d3}']), ('\u{fbd3}', &['\u{6ad}']), ('\u{fbd4}', &['\u{6ad}']), ('\u{fbd5}',
        &['\u{6ad}']), ('\u{fbd6}', &['\u{6ad}']), ('\u{fbd7}', &['\u{6c7}']), ('\u{fbd8}',
        &['\u{6c7}']), ('\u{fbd9}', &['\u{6c6}']), ('\u{fbda}', &['\u{6c6}']), ('\u{fbdb}',
        &['\u{6c8}']), ('\u{fbdc}', &['\u{6c8}']), ('\u{fbdd}', &['\u{677}']), ('\u{fbde}',
        &['\u{6cb}']), ('\u{fbdf}', &['\u{6cb}']), ('\u{fbe0}', &['\u{6c5}']), ('\u{fbe1}',
        &['\u{6c5}']), ('\u{fbe2}', &['\u{6c9}']), ('\u{fbe3}', &['\u{6c9}']), ('\u{fbe4}',
        &['\u{6d0}']), ('\u{fbe5}', &['\u{6d0}']), ('\u{fbe6}', &['\u{6d0}']), ('\u{fbe7}',
        &['\u{6d0}']), ('\u{fbe8}', &['\u{649}']), ('\u{fbe9}', &['\u{649}']), ('\u{fbea}',
        &['\u{626}', '\u{627}']), ('\u{fbeb}', &['\u{626}', '\u{627}']), ('\u{fbec}', &['\u{626}',
        '\u{6d5}']), ('\u{fbed}', &['\u{626}', '\u{6d5}']), ('\u{fbee}', &['\u{626}', '\u{648}']),
        ('\u{fbef}', &['\u{626}', '\u{648}']), ('\u{fbf0}', &['\u{626}', '\u{6c7}']), ('\u{fbf1}',
        &['\u{626}', '\u{6c7}']), ('\u{fbf2}', &['\u{626}', '\u{6c6}']), ('\u{fbf3}', &['\u{626}',
        '\u{6c6}']), ('\u{fbf4}', &['\u{626}', '\u{6c8}']), ('\u{fbf5}', &['\u{626}', '\u{6c8}']),
        ('\u{fbf6}', &['\u{626}', '\u{6d0}']), ('\u{fbf7}', &['\u{626}', '\u{6d0}']), ('\u{fbf8}',
        &['\u{626}', '\u{6d0}']), ('\u{fbf9}', &['\u{626}', '\u{649}']), ('\u{fbfa}', &['\u{626}',
        '\u{649}']), ('\u{fbfb}', &['\u{626}', '\u{649}']), ('\u{fbfc}', &['\u{6cc}']), ('\u{fbfd}',
        &['\u{6cc}']), ('\u{fbfe}', &['\u{6cc}']), ('\u{fbff}', &['\u{6cc}']), ('\u{fc00}',
        &['\u{626}', '\u{62c}']), ('\u{fc01}', &['\u{626}', '\u{62d}']), ('\u{fc02}', &['\u{626}',
        '\u{645}']), ('\u{fc03}', &['\u{626}', '\u{649}']), ('\u{fc04}', &['\u{626}', '\u{64a}']),
        ('\u{fc05}', &['\u{628}', '\u{62c}']), ('\u{fc06}', &['\u{628}', '\u{62d}']), ('\u{fc07}',
        &['\u{628}', '\u{62e}']), ('\u{fc08}', &['\u{628}', '\u{645}']), ('\u{fc09}', &['\u{628}',
        '\u{649}']), ('\u{fc0a}', &['\u{628}', '\u{64a}']), ('\u{fc0b}', &['\u{62a}', '\u{62c}']),
        ('\u{fc0c}', &['\u{62a}', '\u{62d}']), ('\u{fc0d}', &['\u{62a}', '\u{62e}']), ('\u{fc0e}',
        &['\u{62a}', '\u{645}']), ('\u{fc0f}', &['\u{62a}', '\u{649}']), ('\u{fc10}', &['\u{62a}',
        '\u{64a}']), ('\u{fc11}', &['\u{62b}', '\u{62c}']), ('\u{fc12}', &['\u{62b}', '\u{645}']),
        ('\u{fc13}', &['\u{62b}', '\u{649}']), ('\u{fc14}', &['\u{62b}', '\u{64a}']), ('\u{fc15}',
        &['\u{62c}', '\u{62d}']), ('\u{fc16}', &['\u{62c}', '\u{645}']), ('\u{fc17}', &['\u{62d}',
        '\u{62c}']), ('\u{fc18}', &['\u{62d}', '\u{645}']), ('\u{fc19}', &['\u{62e}', '\u{62c}']),
        ('\u{fc1a}', &['\u{62e}', '\u{62d}']), ('\u{fc1b}', &['\u{62e}', '\u{645}']), ('\u{fc1c}',
        &['\u{633}', '\u{62c}']), ('\u{fc1d}', &['\u{633}', '\u{62d}']), ('\u{fc1e}', &['\u{633}',
        '\u{62e}']), ('\u{fc1f}', &['\u{633}', '\u{645}']), ('\u{fc20}', &['\u{635}', '\u{62d}']),
        ('\u{fc21}', &['\u{635}', '\u{645}']), ('\u{fc22}', &['\u{636}', '\u{62c}']), ('\u{fc23}',
        &['\u{636}', '\u{62d}']), ('\u{fc24}', &['\u{636}', '\u{62e}']), ('\u{fc25}', &['\u{636}',
        '\u{645}']), ('\u{fc26}', &['\u{637}', '\u{62d}']), ('\u{fc27}', &['\u{637}', '\u{645}']),
        ('\u{fc28}', &['\u{638}', '\u{645}']), ('\u{fc29}', &['\u{639}', '\u{62c}']), ('\u{fc2a}',
        &['\u{639}', '\u{645}']), ('\u{fc2b}', &['\u{63a}', '\u{62c}']), ('\u{fc2c}', &['\u{63a}',
        '\u{645}']), ('\u{fc2d}', &['\u{641}', '\u{62c}']), ('\u{fc2e}', &['\u{641}', '\u{62d}']),
        ('\u{fc2f}', &['\u{641}', '\u{62e}']), ('\u{fc30}', &['\u{641}', '\u{645}']), ('\u{fc31}',
        &['\u{641}', '\u{649}']), ('\u{fc32}', &['\u{641}', '\u{64a}']), ('\u{fc33}', &['\u{642}',
        '\u{62d}']), ('\u{fc34}', &['\u{642}', '\u{645}']), ('\u{fc35}', &['\u{642}', '\u{649}']),
        ('\u{fc36}', &['\u{642}', '\u{64a}']), ('\u{fc37}', &['\u{643}', '\u{627}']), ('\u{fc38}',
        &['\u{643}', '\u{62c}']), ('\u{fc39}', &['\u{643}', '\u{62d}']), ('\u{fc3a}', &['\u{643}',
        '\u{62e}']), ('\u{fc3b}', &['\u{643}', '\u{644}']), ('\u{fc3c}', &['\u{643}', '\u{645}']),
        ('\u{fc3d}', &['\u{643}', '\u{649}']), ('\u{fc3e}', &['\u{643}', '\u{64a}']), ('\u{fc3f}',
        &['\u{644}', '\u{62c}']), ('\u{fc40}', &['\u{644}', '\u{62d}']), ('\u{fc41}', &['\u{644}',
        '\u{62e}']), ('\u{fc42}', &['\u{644}', '\u{645}']), ('\u{fc43}', &['\u{644}', '\u{649}']),
        ('\u{fc44}', &['\u{644}', '\u{64a}']), ('\u{fc45}', &['\u{645}', '\u{62c}']), ('\u{fc46}',
        &['\u{645}', '\u{62d}']), ('\u{fc47}', &['\u{645}', '\u{62e}']), ('\u{fc48}', &['\u{645}',
        '\u{645}']), ('\u{fc49}', &['\u{645}', '\u{649}']), ('\u{fc4a}', &['\u{645}', '\u{64a}']),
        ('\u{fc4b}', &['\u{646}', '\u{62c}']), ('\u{fc4c}', &['\u{646}', '\u{62d}']), ('\u{fc4d}',
        &['\u{646}', '\u{62e}']), ('\u{fc4e}', &['\u{646}', '\u{645}']), ('\u{fc4f}', &['\u{646}',
        '\u{649}']), ('\u{fc50}', &['\u{646}', '\u{64a}']), ('\u{fc51}', &['\u{647}', '\u{62c}']),
        ('\u{fc52}', &['\u{647}', '\u{645}']), ('\u{fc53}', &['\u{647}', '\u{649}']), ('\u{fc54}',
        &['\u{647}', '\u{64a}']), ('\u{fc55}', &['\u{64a}', '\u{62c}']), ('\u{fc56}', &['\u{64a}',
        '\u{62d}']), ('\u{fc57}', &['\u{64a}', '\u{62e}']), ('\u{fc58}', &['\u{64a}', '\u{645}']),
        ('\u{fc59}', &['\u{64a}', '\u{649}']), ('\u{fc5a}', &['\u{64a}', '\u{64a}']), ('\u{fc5b}',
        &['\u{630}', '\u{670}']), ('\u{fc5c}', &['\u{631}', '\u{670}']), ('\u{fc5d}', &['\u{649}',
        '\u{670}']), ('\u{fc5e}', &['\u{20}', '\u{64c}', '\u{651}']), ('\u{fc5f}', &['\u{20}',
        '\u{64d}', '\u{651}']), ('\u{fc60}', &['\u{20}', '\u{64e}', '\u{651}']), ('\u{fc61}',
        &['\u{20}', '\u{64f}', '\u{651}']), ('\u{fc62}', &['\u{20}', '\u{650}', '\u{651}']),
        ('\u{fc63}', &['\u{20}', '\u{651}', '\u{670}']), ('\u{fc64}', &['\u{626}', '\u{631}']),
        ('\u{fc65}', &['\u{626}', '\u{632}']), ('\u{fc66}', &['\u{626}', '\u{645}']), ('\u{fc67}',
        &['\u{626}', '\u{646}']), ('\u{fc68}', &['\u{626}', '\u{649}']), ('\u{fc69}', &['\u{626}',
        '\u{64a}']), ('\u{fc6a}', &['\u{628}', '\u{631}']), ('\u{fc6b}', &['\u{628}', '\u{632}']),
        ('\u{fc6c}', &['\u{628}', '\u{645}']), ('\u{fc6d}', &['\u{628}', '\u{646}']), ('\u{fc6e}',
        &['\u{628}', '\u{649}']), ('\u{fc6f}', &['\u{628}', '\u{64a}']), ('\u{fc70}', &['\u{62a}',
        '\u{631}']), ('\u{fc71}', &['\u{62a}', '\u{632}']), ('\u{fc72}', &['\u{62a}', '\u{645}']),
        ('\u{fc73}', &['\u{62a}', '\u{646}']), ('\u{fc74}', &['\u{62a}', '\u{649}']), ('\u{fc75}',
        &['\u{62a}', '\u{64a}']), ('\u{fc76}', &['\u{62b}', '\u{631}']), ('\u{fc77}', &['\u{62b}',
        '\u{632}']), ('\u{fc78}', &['\u{62b}', '\u{645}']), ('\u{fc79}', &['\u{62b}', '\u{646}']),
        ('\u{fc7a}', &['\u{62b}', '\u{649}']), ('\u{fc7b}', &['\u{62b}', '\u{64a}']), ('\u{fc7c}',
        &['\u{641}', '\u{649}']), ('\u{fc7d}', &['\u{641}', '\u{64a}']), ('\u{fc7e}', &['\u{642}',
        '\u{649}']), ('\u{fc7f}', &['\u{642}', '\u{64a}']), ('\u{fc80}', &['\u{643}', '\u{627}']),
        ('\u{fc81}', &['\u{643}', '\u{644}']), ('\u{fc82}', &['\u{643}', '\u{645}']), ('\u{fc83}',
        &['\u{643}', '\u{649}']), ('\u{fc84}', &['\u{643}', '\u{64a}']), ('\u{fc85}', &['\u{644}',
        '\u{645}']), ('\u{fc86}', &['\u{644}', '\u{649}']), ('\u{fc87}', &['\u{644}', '\u{64a}']),
        ('\u{fc88}', &['\u{645}', '\u{627}']), ('\u{fc89}', &['\u{645}', '\u{645}']), ('\u{fc8a}',
        &['\u{646}', '\u{631}']), ('\u{fc8b}', &['\u{646}', '\u{632}']), ('\u{fc8c}', &['\u{646}',
        '\u{645}']), ('\u{fc8d}', &['\u{646}', '\u{646}']), ('\u{fc8e}', &['\u{646}', '\u{649}']),
        ('\u{fc8f}', &['\u{646}', '\u{64a}']), ('\u{fc90}', &['\u{649}', '\u{670}']), ('\u{fc91}',
        &['\u{64a}', '\u{631}']), ('\u{fc92}', &['\u{64a}', '\u{632}']), ('\u{fc93}', &['\u{64a}',
        '\u{645}']), ('\u{fc94}', &['\u{64a}', '\u{646}']), ('\u{fc95}', &['\u{64a}', '\u{649}']),
        ('\u{fc96}', &['\u{64a}', '\u{64a}']), ('\u{fc97}', &['\u{626}', '\u{62c}']), ('\u{fc98}',
        &['\u{626}', '\u{62d}']), ('\u{fc99}', &['\u{626}', '\u{62e}']), ('\u{fc9a}', &['\u{626}',
        '\u{645}']), ('\u{fc9b}', &['\u{626}', '\u{647}']), ('\u{fc9c}', &['\u{628}', '\u{62c}']),
        ('\u{fc9d}', &['\u{628}', '\u{62d}']), ('\u{fc9e}', &['\u{628}', '\u{62e}']), ('\u{fc9f}',
        &['\u{628}', '\u{645}']), ('\u{fca0}', &['\u{628}', '\u{647}']), ('\u{fca1}', &['\u{62a}',
        '\u{62c}']), ('\u{fca2}', &['\u{62a}', '\u{62d}']), ('\u{fca3}', &['\u{62a}', '\u{62e}']),
        ('\u{fca4}', &['\u{62a}', '\u{645}']), ('\u{fca5}', &['\u{62a}', '\u{647}']), ('\u{fca6}',
        &['\u{62b}', '\u{645}']), ('\u{fca7}', &['\u{62c}', '\u{62d}']), ('\u{fca8}', &['\u{62c}',
        '\u{645}']), ('\u{fca9}', &['\u{62d}', '\u{62c}']), ('\u{fcaa}', &['\u{62d}', '\u{645}']),
        ('\u{fcab}', &['\u{62e}', '\u{62c}']), ('\u{fcac}', &['\u{62e}', '\u{645}']), ('\u{fcad}',
        &['\u{633}', '\u{62c}']), ('\u{fcae}', &['\u{633}', '\u{62d}']), ('\u{fcaf}', &['\u{633}',
        '\u{62e}']), ('\u{fcb0}', &['\u{633}', '\u{645}']), ('\u{fcb1}', &['\u{635}', '\u{62d}']),
        ('\u{fcb2}', &['\u{635}', '\u{62e}']), ('\u{fcb3}', &['\u{635}', '\u{645}']), ('\u{fcb4}',
        &['\u{636}', '\u{62c}']), ('\u{fcb5}', &['\u{636}', '\u{62d}']), ('\u{fcb6}', &['\u{636}',
        '\u{62e}']), ('\u{fcb7}', &['\u{636}', '\u{645}']), ('\u{fcb8}', &['\u{637}', '\u{62d}']),
        ('\u{fcb9}', &['\u{638}', '\u{645}']), ('\u{fcba}', &['\u{639}', '\u{62c}']), ('\u{fcbb}',
        &['\u{639}', '\u{645}']), ('\u{fcbc}', &['\u{63a}', '\u{62c}']), ('\u{fcbd}', &['\u{63a}',
        '\u{645}']), ('\u{fcbe}', &['\u{641}', '\u{62c}']), ('\u{fcbf}', &['\u{641}', '\u{62d}']),
        ('\u{fcc0}', &['\u{641}', '\u{62e}']), ('\u{fcc1}', &['\u{641}', '\u{645}']), ('\u{fcc2}',
        &['\u{642}', '\u{62d}']), ('\u{fcc3}', &['\u{642}', '\u{645}']), ('\u{fcc4}', &['\u{643}',
        '\u{62c}']), ('\u{fcc5}', &['\u{643}', '\u{62d}']), ('\u{fcc6}', &['\u{643}', '\u{62e}']),
        ('\u{fcc7}', &['\u{643}', '\u{644}']), ('\u{fcc8}', &['\u{643}', '\u{645}']), ('\u{fcc9}',
        &['\u{644}', '\u{62c}']), ('\u{fcca}', &['\u{644}', '\u{62d}']), ('\u{fccb}', &['\u{644}',
        '\u{62e}']), ('\u{fccc}', &['\u{644}', '\u{645}']), ('\u{fccd}', &['\u{644}', '\u{647}']),
        ('\u{fcce}', &['\u{645}', '\u{62c}']), ('\u{fccf}', &['\u{645}', '\u{62d}']), ('\u{fcd0}',
        &['\u{645}', '\u{62e}']), ('\u{fcd1}', &['\u{645}', '\u{645}']), ('\u{fcd2}', &['\u{646}',
        '\u{62c}']), ('\u{fcd3}', &['\u{646}', '\u{62d}']), ('\u{fcd4}', &['\u{646}', '\u{62e}']),
        ('\u{fcd5}', &['\u{646}', '\u{645}']), ('\u{fcd6}', &['\u{646}', '\u{647}']), ('\u{fcd7}',
        &['\u{647}', '\u{62c}']), ('\u{fcd8}', &['\u{647}', '\u{645}']), ('\u{fcd9}', &['\u{647}',
        '\u{670}']), ('\u{fcda}', &['\u{64a}', '\u{62c}']), ('\u{fcdb}', &['\u{64a}', '\u{62d}']),
        ('\u{fcdc}', &['\u{64a}', '\u{62e}']), ('\u{fcdd}', &['\u{64a}', '\u{645}']), ('\u{fcde}',
        &['\u{64a}', '\u{647}']), ('\u{fcdf}', &['\u{626}', '\u{645}']), ('\u{fce0}', &['\u{626}',
        '\u{647}']), ('\u{fce1}', &['\u{628}', '\u{645}']), ('\u{fce2}', &['\u{628}', '\u{647}']),
        ('\u{fce3}', &['\u{62a}', '\u{645}']), ('\u{fce4}', &['\u{62a}', '\u{647}']), ('\u{fce5}',
        &['\u{62b}', '\u{645}']), ('\u{fce6}', &['\u{62b}', '\u{647}']), ('\u{fce7}', &['\u{633}',
        '\u{645}']), ('\u{fce8}', &['\u{633}', '\u{647}']), ('\u{fce9}', &['\u{634}', '\u{645}']),
        ('\u{fcea}', &['\u{634}', '\u{647}']), ('\u{fceb}', &['\u{643}', '\u{644}']), ('\u{fcec}',
        &['\u{643}', '\u{645}']), ('\u{fced}', &['\u{644}', '\u{645}']), ('\u{fcee}', &['\u{646}',
        '\u{645}']), ('\u{fcef}', &['\u{646}', '\u{647}']), ('\u{fcf0}', &['\u{64a}', '\u{645}']),
        ('\u{fcf1}', &['\u{64a}', '\u{647}']), ('\u{fcf2}', &['\u{640}', '\u{64e}', '\u{651}']),
        ('\u{fcf3}', &['\u{640}', '\u{64f}', '\u{651}']), ('\u{fcf4}', &['\u{640}', '\u{650}',
        '\u{651}']), ('\u{fcf5}', &['\u{637}', '\u{649}']), ('\u{fcf6}', &['\u{637}', '\u{64a}']),
        ('\u{fcf7}', &['\u{639}', '\u{649}']), ('\u{fcf8}', &['\u{639}', '\u{64a}']), ('\u{fcf9}',
        &['\u{63a}', '\u{649}']), ('\u{fcfa}', &['\u{63a}', '\u{64a}']), ('\u{fcfb}', &['\u{633}',
        '\u{649}']), ('\u{fcfc}', &['\u{633}', '\u{64a}']), ('\u{fcfd}', &['\u{634}', '\u{649}']),
        ('\u{fcfe}', &['\u{634}', '\u{64a}']), ('\u{fcff}', &['\u{62d}', '\u{649}']), ('\u{fd00}',
        &['\u{62d}', '\u{64a}']), ('\u{fd01}', &['\u{62c}', '\u{649}']), ('\u{fd02}', &['\u{62c}',
        '\u{64a}']), ('\u{fd03}', &['\u{62e}', '\u{649}']), ('\u{fd04}', &['\u{62e}', '\u{64a}']),
        ('\u{fd05}', &['\u{635}', '\u{649}']), ('\u{fd06}', &['\u{635}', '\u{64a}']), ('\u{fd07}',
        &['\u{636}', '\u{649}']), ('\u{fd08}', &['\u{636}', '\u{64a}']), ('\u{fd09}', &['\u{634}',
        '\u{62c}']), ('\u{fd0a}', &['\u{634}', '\u{62d}']), ('\u{fd0b}', &['\u{634}', '\u{62e}']),
        ('\u{fd0c}', &['\u{634}', '\u{645}']), ('\u{fd0d}', &['\u{634}', '\u{631}']), ('\u{fd0e}',
        &['\u{633}', '\u{631}']), ('\u{fd0f}', &['\u{635}', '\u{631}']), ('\u{fd10}', &['\u{636}',
        '\u{631}']), ('\u{fd11}', &['\u{637}', '\u{649}']), ('\u{fd12}', &['\u{637}', '\u{64a}']),
        ('\u{fd13}', &['\u{639}', '\u{649}']), ('\u{fd14}', &['\u{639}', '\u{64a}']), ('\u{fd15}',
        &['\u{63a}', '\u{649}']), ('\u{fd16}', &['\u{63a}', '\u{64a}']), ('\u{fd17}', &['\u{633}',
        '\u{649}']), ('\u{fd18}', &['\u{633}', '\u{64a}']), ('\u{fd19}', &['\u{634}', '\u{649}']),
        ('\u{fd1a}', &['\u{634}', '\u{64a}']), ('\u{fd1b}', &['\u{62d}', '\u{649}']), ('\u{fd1c}',
        &['\u{62d}', '\u{64a}']), ('\u{fd1d}', &['\u{62c}', '\u{649}']), ('\u{fd1e}', &['\u{62c}',
        '\u{64a}']), ('\u{fd1f}', &['\u{62e}', '\u{649}']), ('\u{fd20}', &['\u{62e}', '\u{64a}']),
        ('\u{fd21}', &['\u{635}', '\u{649}']), ('\u{fd22}', &['\u{635}', '\u{64a}']), ('\u{fd23}',
        &['\u{636}', '\u{649}']), ('\u{fd24}', &['\u{636}', '\u{64a}']), ('\u{fd25}', &['\u{634}',
        '\u{62c}']), ('\u{fd26}', &['\u{634}', '\u{62d}']), ('\u{fd27}', &['\u{634}', '\u{62e}']),
        ('\u{fd28}', &['\u{634}', '\u{645}']), ('\u{fd29}', &['\u{634}', '\u{631}']), ('\u{fd2a}',
        &['\u{633}', '\u{631}']), ('\u{fd2b}', &['\u{635}', '\u{631}']), ('\u{fd2c}', &['\u{636}',
        '\u{631}']), ('\u{fd2d}', &['\u{634}', '\u{62c}']), ('\u{fd2e}', &['\u{634}', '\u{62d}']),
        ('\u{fd2f}', &['\u{634}', '\u{62e}']), ('\u{fd30}', &['\u{634}', '\u{645}']), ('\u{fd31}',
        &['\u{633}', '\u{647}']), ('\u{fd32}', &['\u{634}', '\u{647}']), ('\u{fd33}', &['\u{637}',
        '\u{645}']), ('\u{fd34}', &['\u{633}', '\u{62c}']), ('\u{fd35}', &['\u{633}', '\u{62d}']),
        ('\u{fd36}', &['\u{633}', '\u{62e}']), ('\u{fd37}', &['\u{634}', '\u{62c}']), ('\u{fd38}',
        &['\u{634}', '\u{62d}']), ('\u{fd39}', &['\u{634}', '\u{62e}']), ('\u{fd3a}', &['\u{637}',
        '\u{645}']), ('\u{fd3b}', &['\u{638}', '\u{645}']), ('\u{fd3c}', &['\u{627}', '\u{64b}']),
        ('\u{fd3d}', &['\u{627}', '\u{64b}']), ('\u{fd50}', &['\u{62a}', '\u{62c}', '\u{645}']),
        ('\u{fd51}', &['\u{62a}', '\u{62d}', '\u{62c}']), ('\u{fd52}', &['\u{62a}', '\u{62d}',
        '\u{62c}']), ('\u{fd53}', &['\u{62a}', '\u{62d}', '\u{645}']), ('\u{fd54}', &['\u{62a}',
        '\u{62e}', '\u{645}']), ('\u{fd55}', &['\u{62a}', '\u{645}', '\u{62c}']), ('\u{fd56}',
        &['\u{62a}', '\u{645}', '\u{62d}']), ('\u{fd57}', &['\u{62a}', '\u{645}', '\u{62e}']),
        ('\u{fd58}', &['\u{62c}', '\u{645}', '\u{62d}']), ('\u{fd59}', &['\u{62c}', '\u{645}',
        '\u{62d}']), ('\u{fd5a}', &['\u{62d}', '\u{645}', '\u{64a}']), ('\u{fd5b}', &['\u{62d}',
        '\u{645}', '\u{649}']), ('\u{fd5c}', &['\u{633}', '\u{62d}', '\u{62c}']), ('\u{fd5d}',
        &['\u{633}', '\u{62c}', '\u{62d}']), ('\u{fd5e}', &['\u{633}', '\u{62c}', '\u{649}']),
        ('\u{fd5f}', &['\u{633}', '\u{645}', '\u{62d}']), ('\u{fd60}', &['\u{633}', '\u{645}',
        '\u{62d}']), ('\u{fd61}', &['\u{633}', '\u{645}', '\u{62c}']), ('\u{fd62}', &['\u{633}',
        '\u{645}', '\u{645}']), ('\u{fd63}', &['\u{633}', '\u{645}', '\u{645}']), ('\u{fd64}',
        &['\u{635}', '\u{62d}', '\u{62d}']), ('\u{fd65}', &['\u{635}', '\u{62d}', '\u{62d}']),
        ('\u{fd66}', &['\u{635}', '\u{645}', '\u{645}']), ('\u{fd67}', &['\u{634}', '\u{62d}',
        '\u{645}']), ('\u{fd68}', &['\u{634}', '\u{62d}', '\u{645}']), ('\u{fd69}', &['\u{634}',
        '\u{62c}', '\u{64a}']), ('\u{fd6a}', &['\u{634}', '\u{645}', '\u{62e}']), ('\u{fd6b}',
        &['\u{634}', '\u{645}', '\u{62e}']), ('\u{fd6c}', &['\u{634}', '\u{645}', '\u{645}']),
        ('\u{fd6d}', &['\u{634}', '\u{645}', '\u{645}']), ('\u{fd6e}', &['\u{636}', '\u{62d}',
        '\u{649}']), ('\u{fd6f}', &['\u{636}', '\u{62e}', '\u{645}']), ('\u{fd70}', &['\u{636}',
        '\u{62e}', '\u{645}']), ('\u{fd71}', &['\u{637}', '\u{645}', '\u{62d}']), ('\u{fd72}',
        &['\u{637}', '\u{645}', '\u{62d}']), ('\u{fd73}', &['\u{637}', '\u{645}', '\u{645}']),
        ('\u{fd74}', &['\u{637}', '\u{645}', '\u{64a}']), ('\u{fd75}', &['\u{639}', '\u{62c}',
        '\u{645}']), ('\u{fd76}', &['\u{639}', '\u{645}', '\u{645}']), ('\u{fd77}', &['\u{639}',
        '\u{645}', '\u{645}']), ('\u{fd78}', &['\u{639}', '\u{645}', '\u{649}']), ('\u{fd79}',
        &['\u{63a}', '\u{645}', '\u{645}']), ('\u{fd7a}', &['\u{63a}', '\u{645}', '\u{64a}']),
        ('\u{fd7b}', &['\u{63a}', '\u{645}', '\u{649}']), ('\u{fd7c}', &['\u{641}', '\u{62e}',
        '\u{645}']), ('\u{fd7d}', &['\u{641}', '\u{62e}', '\u{645}']), ('\u{fd7e}', &['\u{642}',
        '\u{645}', '\u{62d}']), ('\u{fd7f}', &['\u{642}', '\u{645}', '\u{645}']), ('\u{fd80}',
        &['\u{644}', '\u{62d}', '\u{645}']), ('\u{fd81}', &['\u{644}', '\u{62d}', '\u{64a}']),
        ('\u{fd82}', &['\u{644}', '\u{62d}', '\u{649}']), ('\u{fd83}', &['\u{644}', '\u{62c}',
        '\u{62c}']), ('\u{fd84}', &['\u{644}', '\u{62c}', '\u{62c}']), ('\u{fd85}', &['\u{644}',
        '\u{62e}', '\u{645}']), ('\u{fd86}', &['\u{644}', '\u{62e}', '\u{645}']), ('\u{fd87}',
        &['\u{644}', '\u{645}', '\u{62d}']), ('\u{fd88}', &['\u{644}', '\u{645}', '\u{62d}']),
        ('\u{fd89}', &['\u{645}', '\u{62d}', '\u{62c}']), ('\u{fd8a}', &['\u{645}', '\u{62d}',
        '\u{645}']), ('\u{fd8b}', &['\u{645}', '\u{62d}', '\u{64a}']), ('\u{fd8c}', &['\u{645}',
        '\u{62c}', '\u{62d}']), ('\u{fd8d}', &['\u{645}', '\u{62c}', '\u{645}']), ('\u{fd8e}',
        &['\u{645}', '\u{62e}', '\u{62c}']), ('\u{fd8f}', &['\u{645}', '\u{62e}', '\u{645}']),
        ('\u{fd92}', &['\u{645}', '\u{62c}', '\u{62e}']), ('\u{fd93}', &['\u{647}', '\u{645}',
        '\u{62c}']), ('\u{fd94}', &['\u{647}', '\u{645}', '\u{645}']), ('\u{fd95}', &['\u{646}',
        '\u{62d}', '\u{645}']), ('\u{fd96}', &['\u{646}', '\u{62d}', '\u{649}']), ('\u{fd97}',
        &['\u{646}', '\u{62c}', '\u{645}']), ('\u{fd98}', &['\u{646}', '\u{62c}', '\u{645}']),
        ('\u{fd99}', &['\u{646}', '\u{62c}', '\u{649}']), ('\u{fd9a}', &['\u{646}', '\u{645}',
        '\u{64a}']), ('\u{fd9b}', &['\u{646}', '\u{645}', '\u{649}']), ('\u{fd9c}', &['\u{64a}',
        '\u{645}', '\u{645}']), ('\u{fd9d}', &['\u{64a}', '\u{645}', '\u{645}']), ('\u{fd9e}',
        &['\u{628}', '\u{62e}', '\u{64a}']), ('\u{fd9f}', &['\u{62a}', '\u{62c}', '\u{64a}']),
        ('\u{fda0}', &['\u{62a}', '\u{62c}', '\u{649}']), ('\u{fda1}', &['\u{62a}', '\u{62e}',
        '\u{64a}']), ('\u{fda2}', &['\u{62a}', '\u{62e}', '\u{649}']), ('\u{fda3}', &['\u{62a}',
        '\u{645}', '\u{64a}']), ('\u{fda4}', &['\u{62a}', '\u{645}', '\u{649}']), ('\u{fda5}',
        &['\u{62c}', '\u{645}', '\u{64a}']), ('\u{fda6}', &['\u{62c}', '\u{62d}', '\u{649}']),
        ('\u{fda7}', &['\u{62c}', '\u{645}', '\u{649}']), ('\u{fda8}', &['\u{633}', '\u{62e}',
        '\u{649}']), ('\u{fda9}', &['\u{635}', '\u{62d}', '\u{64a}']), ('\u{fdaa}', &['\u{634}',
        '\u{62d}', '\u{64a}']), ('\u{fdab}', &['\u{636}', '\u{62d}', '\u{64a}']), ('\u{fdac}',
        &['\u{644}', '\u{62c}', '\u{64a}']), ('\u{fdad}', &['\u{644}', '\u{645}', '\u{64a}']),
        ('\u{fdae}', &['\u{64a}', '\u{62d}', '\u{64a}']), ('\u{fdaf}', &['\u{64a}', '\u{62c}',
        '\u{64a}']), ('\u{fdb0}', &['\u{64a}', '\u{645}', '\u{64a}']), ('\u{fdb1}', &['\u{645}',
        '\u{645}', '\u{64a}']), ('\u{fdb2}', &['\u{642}', '\u{645}', '\u{64a}']), ('\u{fdb3}',
        &['\u{646}', '\u{62d}', '\u{64a}']), ('\u{fdb4}', &['\u{642}', '\u{645}', '\u{62d}']),
        ('\u{fdb5}', &['\u{644}', '\u{62d}', '\u{645}']), ('\u{fdb6}', &['\u{639}', '\u{645}',
        '\u{64a}']), ('\u{fdb7}', &['\u{643}', '\u{645}', '\u{64a}']), ('\u{fdb8}', &['\u{646}',
        '\u{62c}', '\u{62d}']), ('\u{fdb9}', &['\u{645}', '\u{62e}', '\u{64a}']), ('\u{fdba}',
        &['\u{644}', '\u{62c}', '\u{645}']), ('\u{fdbb}', &['\u{643}', '\u{645}', '\u{645}']),
        ('\u{fdbc}', &['\u{644}', '\u{62c}', '\u{645}']), ('\u{fdbd}', &['\u{646}', '\u{62c}',
        '\u{62d}']), ('\u{fdbe}', &['\u{62c}', '\u{62d}', '\u{64a}']), ('\u{fdbf}', &['\u{62d}',
        '\u{62c}', '\u{64a}']), ('\u{fdc0}', &['\u{645}', '\u{62c}', '\u{64a}']), ('\u{fdc1}',
        &['\u{641}', '\u{645}', '\u{64a}']), ('\u{fdc2}', &['\u{628}', '\u{62d}', '\u{64a}']),
        ('\u{fdc3}', &['\u{643}', '\u{645}', '\u{645}']), ('\u{fdc4}', &['\u{639}', '\u{62c}',
        '\u{645}']), ('\u{fdc5}', &['\u{635}', '\u{645}', '\u{645}']), ('\u{fdc6}', &['\u{633}',
        '\u{62e}', '\u{64a}']), ('\u{fdc7}', &['\u{646}', '\u{62c}', '\u{64a}']), ('\u{fdf0}',
        &['\u{635}', '\u{644}', '\u{6d2}']), ('\u{fdf1}', &['\u{642}', '\u{644}', '\u{6d2}']),
        ('\u{fdf2}', &['\u{627}', '\u{644}', '\u{644}', '\u{647}']), ('\u{fdf3}', &['\u{627}',
        '\u{643}', '\u{628}', '\u{631}']), ('\u{fdf4}', &['\u{645}', '\u{62d}', '\u{645}',
        '\u{62f}']), ('\u{fdf5}', &['\u{635}', '\u{644}', '\u{639}', '\u{645}']), ('\u{fdf6}',
        &['\u{631}', '\u{633}', '\u{648}', '\u{644}']), ('\u{fdf7}', &['\u{639}', '\u{644}',
        '\u{64a}', '\u{647}']), ('\u{fdf8}', &['\u{648}', '\u{633}', '\u{644}', '\u{645}']),
        ('\u{fdf9}', &['\u{635}', '\u{644}', '\u{649}']), ('\u{fdfa}', &['\u{635}', '\u{644}',
        '\u{649}', '\u{20}', '\u{627}', '\u{644}', '\u{644}', '\u{647}', '\u{20}', '\u{639}',
        '\u{644}', '\u{64a}', '\u{647}', '\u{20}', '\u{648}', '\u{633}', '\u{644}', '\u{645}']),
        ('\u{fdfb}', &['\u{62c}', '\u{644}', '\u{20}', '\u{62c}', '\u{644}', '\u{627}', '\u{644}',
        '\u{647}']), ('\u{fdfc}', &['\u{631}', '\u{6cc}', '\u{627}', '\u{644}']), ('\u{fe10}',
        &['\u{2c}']), ('\u{fe11}', &['\u{3001}']), ('\u{fe12}', &['\u{3002}']), ('\u{fe13}',
        &['\u{3a}']), ('\u{fe14}', &['\u{3b}']), ('\u{fe15}', &['\u{21}']), ('\u{fe16}',
        &['\u{3f}']), ('\u{fe17}', &['\u{3016}']), ('\u{fe18}', &['\u{3017}']), ('\u{fe19}',
        &['\u{2026}']), ('\u{fe30}', &['\u{2025}']), ('\u{fe31}', &['\u{2014}']), ('\u{fe32}',
        &['\u{2013}']), ('\u{fe33}', &['\u{5f}']), ('\u{fe34}', &['\u{5f}']), ('\u{fe35}',
        &['\u{28}']), ('\u{fe36}', &['\u{29}']), ('\u{fe37}', &['\u{7b}']), ('\u{fe38}',
        &['\u{7d}']), ('\u{fe39}', &['\u{3014}']), ('\u{fe3a}', &['\u{3015}']), ('\u{fe3b}',
        &['\u{3010}']), ('\u{fe3c}', &['\u{3011}']), ('\u{fe3d}', &['\u{300a}']), ('\u{fe3e}',
        &['\u{300b}']), ('\u{fe3f}', &['\u{3008}']), ('\u{fe40}', &['\u{3009}']), ('\u{fe41}',
        &['\u{300c}']), ('\u{fe42}', &['\u{300d}']), ('\u{fe43}', &['\u{300e}']), ('\u{fe44}',
        &['\u{300f}']), ('\u{fe47}', &['\u{5b}']), ('\u{fe48}', &['\u{5d}']), ('\u{fe49}',
        &['\u{203e}']), ('\u{fe4a}', &['\u{203e}']), ('\u{fe4b}', &['\u{203e}']), ('\u{fe4c}',
        &['\u{203e}']), ('\u{fe4d}', &['\u{5f}']), ('\u{fe4e}', &['\u{5f}']), ('\u{fe4f}',
        &['\u{5f}']), ('\u{fe50}', &['\u{2c}']), ('\u{fe51}', &['\u{3001}']), ('\u{fe52}',
        &['\u{2e}']), ('\u{fe54}', &['\u{3b}']), ('\u{fe55}', &['\u{3a}']), ('\u{fe56}',
        &['\u{3f}']), ('\u{fe57}', &['\u{21}']), ('\u{fe58}', &['\u{2014}']), ('\u{fe59}',
        &['\u{28}']), ('\u{fe5a}', &['\u{29}']), ('\u{fe5b}', &['\u{7b}']), ('\u{fe5c}',
        &['\u{7d}']), ('\u{fe5d}', &['\u{3014}']), ('\u{fe5e}', &['\u{3015}']), ('\u{fe5f}',
        &['\u{23}']), ('\u{fe60}', &['\u{26}']), ('\u{fe61}', &['\u{2a}']), ('\u{fe62}',
        &['\u{2b}']), ('\u{fe63}', &['\u{2d}']), ('\u{fe64}', &['\u{3c}']), ('\u{fe65}',
        &['\u{3e}']), ('\u{fe66}', &['\u{3d}']), ('\u{fe68}', &['\u{5c}']), ('\u{fe69}',
        &['\u{24}']), ('\u{fe6a}', &['\u{25}']), ('\u{fe6b}', &['\u{40}']), ('\u{fe70}', &['\u{20}',
        '\u{64b}']), ('\u{fe71}', &['\u{640}', '\u{64b}']), ('\u{fe72}', &['\u{20}', '\u{64c}']),
        ('\u{fe74}', &['\u{20}', '\u{64d}']), ('\u{fe76}', &['\u{20}', '\u{64e}']), ('\u{fe77}',
        &['\u{640}', '\u{64e}']), ('\u{fe78}', &['\u{20}', '\u{64f}']), ('\u{fe79}', &['\u{640}',
        '\u{64f}']), ('\u{fe7a}', &['\u{20}', '\u{650}']), ('\u{fe7b}', &['\u{640}', '\u{650}']),
        ('\u{fe7c}', &['\u{20}', '\u{651}']), ('\u{fe7d}', &['\u{640}', '\u{651}']), ('\u{fe7e}',
        &['\u{20}', '\u{652}']), ('\u{fe7f}', &['\u{640}', '\u{652}']), ('\u{fe80}', &['\u{621}']),
        ('\u{fe81}', &['\u{622}']), ('\u{fe82}', &['\u{622}']), ('\u{fe83}', &['\u{623}']),
        ('\u{fe84}', &['\u{623}']), ('\u{fe85}', &['\u{624}']), ('\u{fe86}', &['\u{624}']),
        ('\u{fe87}', &['\u{625}']), ('\u{fe88}', &['\u{625}']), ('\u{fe89}', &['\u{626}']),
        ('\u{fe8a}', &['\u{626}']), ('\u{fe8b}', &['\u{626}']), ('\u{fe8c}', &['\u{626}']),
        ('\u{fe8d}', &['\u{627}']), ('\u{fe8e}', &['\u{627}']), ('\u{fe8f}', &['\u{628}']),
        ('\u{fe90}', &['\u{628}']), ('\u{fe91}', &['\u{628}']), ('\u{fe92}', &['\u{628}']),
        ('\u{fe93}', &['\u{629}']), ('\u{fe94}', &['\u{629}']), ('\u{fe95}', &['\u{62a}']),
        ('\u{fe96}', &['\u{62a}']), ('\u{fe97}', &['\u{62a}']), ('\u{fe98}', &['\u{62a}']),
        ('\u{fe99}', &['\u{62b}']), ('\u{fe9a}', &['\u{62b}']), ('\u{fe9b}', &['\u{62b}']),
        ('\u{fe9c}', &['\u{62b}']), ('\u{fe9d}', &['\u{62c}']), ('\u{fe9e}', &['\u{62c}']),
        ('\u{fe9f}', &['\u{62c}']), ('\u{fea0}', &['\u{62c}']), ('\u{fea1}', &['\u{62d}']),
        ('\u{fea2}', &['\u{62d}']), ('\u{fea3}', &['\u{62d}']), ('\u{fea4}', &['\u{62d}']),
        ('\u{fea5}', &['\u{62e}']), ('\u{fea6}', &['\u{62e}']), ('\u{fea7}', &['\u{62e}']),
        ('\u{fea8}', &['\u{62e}']), ('\u{fea9}', &['\u{62f}']), ('\u{feaa}', &['\u{62f}']),
        ('\u{feab}', &['\u{630}']), ('\u{feac}', &['\u{630}']), ('\u{fead}', &['\u{631}']),
        ('\u{feae}', &['\u{631}']), ('\u{feaf}', &['\u{632}']), ('\u{feb0}', &['\u{632}']),
        ('\u{feb1}', &['\u{633}']), ('\u{feb2}', &['\u{633}']), ('\u{feb3}', &['\u{633}']),
        ('\u{feb4}', &['\u{633}']), ('\u{feb5}', &['\u{634}']), ('\u{feb6}', &['\u{634}']),
        ('\u{feb7}', &['\u{634}']), ('\u{feb8}', &['\u{634}']), ('\u{feb9}', &['\u{635}']),
        ('\u{feba}', &['\u{635}']), ('\u{febb}', &['\u{635}']), ('\u{febc}', &['\u{635}']),
        ('\u{febd}', &['\u{636}']), ('\u{febe}', &['\u{636}']), ('\u{febf}', &['\u{636}']),
        ('\u{fec0}', &['\u{636}']), ('\u{fec1}', &['\u{637}']), ('\u{fec2}', &['\u{637}']),
        ('\u{fec3}', &['\u{637}']), ('\u{fec4}', &['\u{637}']), ('\u{fec5}', &['\u{638}']),
        ('\u{fec6}', &['\u{638}']), ('\u{fec7}', &['\u{638}']), ('\u{fec8}', &['\u{638}']),
        ('\u{fec9}', &['\u{639}']), ('\u{feca}', &['\u{639}']), ('\u{fecb}', &['\u{639}']),
        ('\u{fecc}', &['\u{639}']), ('\u{fecd}', &['\u{63a}']), ('\u{fece}', &['\u{63a}']),
        ('\u{fecf}', &['\u{63a}']), ('\u{fed0}', &['\u{63a}']), ('\u{fed1}', &['\u{641}']),
        ('\u{fed2}', &['\u{641}']), ('\u{fed3}', &['\u{641}']), ('\u{fed4}', &['\u{641}']),
        ('\u{fed5}', &['\u{642}']), ('\u{fed6}', &['\u{642}']), ('\u{fed7}', &['\u{642}']),
        ('\u{fed8}', &['\u{642}']), ('\u{fed9}', &['\u{643}']), ('\u{feda}', &['\u{643}']),
        ('\u{fedb}', &['\u{643}']), ('\u{fedc}', &['\u{643}']), ('\u{fedd}', &['\u{644}']),
        ('\u{fede}', &['\u{644}']), ('\u{fedf}', &['\u{644}']), ('\u{fee0}', &['\u{644}']),
        ('\u{fee1}', &['\u{645}']), ('\u{fee2}', &['\u{645}']), ('\u{fee3}', &['\u{645}']),
        ('\u{fee4}', &['\u{645}']), ('\u{fee5}', &['\u{646}']), ('\u{fee6}', &['\u{646}']),
        ('\u{fee7}', &['\u{646}']), ('\u{fee8}', &['\u{646}']), ('\u{fee9}', &['\u{647}']),
        ('\u{feea}', &['\u{647}']), ('\u{feeb}', &['\u{647}']), ('\u{feec}', &['\u{647}']),
        ('\u{feed}', &['\u{648}']), ('\u{feee}', &['\u{648}']), ('\u{feef}', &['\u{649}']),
        ('\u{fef0}', &['\u{649}']), ('\u{fef1}', &['\u{64a}']), ('\u{fef2}', &['\u{64a}']),
        ('\u{fef3}', &['\u{64a}']), ('\u{fef4}', &['\u{64a}']), ('\u{fef5}', &['\u{644}',
        '\u{622}']), ('\u{fef6}', &['\u{644}', '\u{622}']), ('\u{fef7}', &['\u{644}', '\u{623}']),
        ('\u{fef8}', &['\u{644}', '\u{623}']), ('\u{fef9}', &['\u{644}', '\u{625}']), ('\u{fefa}',
        &['\u{644}', '\u{625}']), ('\u{fefb}', &['\u{644}', '\u{627}']), ('\u{fefc}', &['\u{644}',
        '\u{627}']), ('\u{ff01}', &['\u{21}']), ('\u{ff02}', &['\u{22}']), ('\u{ff03}',
        &['\u{23}']), ('\u{ff04}', &['\u{24}']), ('\u{ff05}', &['\u{25}']), ('\u{ff06}',
        &['\u{26}']), ('\u{ff07}', &['\u{27}']), ('\u{ff08}', &['\u{28}']), ('\u{ff09}',
        &['\u{29}']), ('\u{ff0a}', &['\u{2a}']), ('\u{ff0b}', &['\u{2b}']), ('\u{ff0c}',
        &['\u{2c}']), ('\u{ff0d}', &['\u{2d}']), ('\u{ff0e}', &['\u{2e}']), ('\u{ff0f}',
        &['\u{2f}']), ('\u{ff10}', &['\u{30}']), ('\u{ff11}', &['\u{31}']), ('\u{ff12}',
        &['\u{32}']), ('\u{ff13}', &['\u{33}']), ('\u{ff14}', &['\u{34}']), ('\u{ff15}',
        &['\u{35}']), ('\u{ff16}', &['\u{36}']), ('\u{ff17}', &['\u{37}']), ('\u{ff18}',
        &['\u{38}']), ('\u{ff19}', &['\u{39}']), ('\u{ff1a}', &['\u{3a}']), ('\u{ff1b}',
        &['\u{3b}']), ('\u{ff1c}', &['\u{3c}']), ('\u{ff1d}', &['\u{3d}']), ('\u{ff1e}',
        &['\u{3e}']), ('\u{ff1f}', &['\u{3f}']), ('\u{ff20}', &['\u{40}']), ('\u{ff21}',
        &['\u{41}']), ('\u{ff22}', &['\u{42}']), ('\u{ff23}', &['\u{43}']), ('\u{ff24}',
        &['\u{44}']), ('\u{ff25}', &['\u{45}']), ('\u{ff26}', &['\u{46}']), ('\u{ff27}',
        &['\u{47}']), ('\u{ff28}', &['\u{48}']), ('\u{ff29}', &['\u{49}']), ('\u{ff2a}',
        &['\u{4a}']), ('\u{ff2b}', &['\u{4b}']), ('\u{ff2c}', &['\u{4c}']), ('\u{ff2d}',
        &['\u{4d}']), ('\u{ff2e}', &['\u{4e}']), ('\u{ff2f}', &['\u{4f}']), ('\u{ff30}',
        &['\u{50}']), ('\u{ff31}', &['\u{51}']), ('\u{ff32}', &['\u{52}']), ('\u{ff33}',
        &['\u{53}']), ('\u{ff34}', &['\u{54}']), ('\u{ff35}', &['\u{55}']), ('\u{ff36}',
        &['\u{56}']), ('\u{ff37}', &['\u{57}']), ('\u{ff38}', &['\u{58}']), ('\u{ff39}',
        &['\u{59}']), ('\u{ff3a}', &['\u{5a}']), ('\u{ff3b}', &['\u{5b}']), ('\u{ff3c}',
        &['\u{5c}']), ('\u{ff3d}', &['\u{5d}']), ('\u{ff3e}', &['\u{5e}']), ('\u{ff3f}',
        &['\u{5f}']), ('\u{ff40}', &['\u{60}']), ('\u{ff41}', &['\u{61}']), ('\u{ff42}',
        &['\u{62}']), ('\u{ff43}', &['\u{63}']), ('\u{ff44}', &['\u{64}']), ('\u{ff45}',
        &['\u{65}']), ('\u{ff46}', &['\u{66}']), ('\u{ff47}', &['\u{67}']), ('\u{ff48}',
        &['\u{68}']), ('\u{ff49}', &['\u{69}']), ('\u{ff4a}', &['\u{6a}']), ('\u{ff4b}',
        &['\u{6b}']), ('\u{ff4c}', &['\u{6c}']), ('\u{ff4d}', &['\u{6d}']), ('\u{ff4e}',
        &['\u{6e}']), ('\u{ff4f}', &['\u{6f}']), ('\u{ff50}', &['\u{70}']), ('\u{ff51}',
        &['\u{71}']), ('\u{ff52}', &['\u{72}']), ('\u{ff53}', &['\u{73}']), ('\u{ff54}',
        &['\u{74}']), ('\u{ff55}', &['\u{75}']), ('\u{ff56}', &['\u{76}']), ('\u{ff57}',
        &['\u{77}']), ('\u{ff58}', &['\u{78}']), ('\u{ff59}', &['\u{79}']), ('\u{ff5a}',
        &['\u{7a}']), ('\u{ff5b}', &['\u{7b}']), ('\u{ff5c}', &['\u{7c}']), ('\u{ff5d}',
        &['\u{7d}']), ('\u{ff5e}', &['\u{7e}']), ('\u{ff5f}', &['\u{2985}']), ('\u{ff60}',
        &['\u{2986}']), ('\u{ff61}', &['\u{3002}']), ('\u{ff62}', &['\u{300c}']), ('\u{ff63}',
        &['\u{300d}']), ('\u{ff64}', &['\u{3001}']), ('\u{ff65}', &['\u{30fb}']), ('\u{ff66}',
        &['\u{30f2}']), ('\u{ff67}', &['\u{30a1}']), ('\u{ff68}', &['\u{30a3}']), ('\u{ff69}',
        &['\u{30a5}']), ('\u{ff6a}', &['\u{30a7}']), ('\u{ff6b}', &['\u{30a9}']), ('\u{ff6c}',
        &['\u{30e3}']), ('\u{ff6d}', &['\u{30e5}']), ('\u{ff6e}', &['\u{30e7}']), ('\u{ff6f}',
        &['\u{30c3}']), ('\u{ff70}', &['\u{30fc}']), ('\u{ff71}', &['\u{30a2}']), ('\u{ff72}',
        &['\u{30a4}']), ('\u{ff73}', &['\u{30a6}']), ('\u{ff74}', &['\u{30a8}']), ('\u{ff75}',
        &['\u{30aa}']), ('\u{ff76}', &['\u{30ab}']), ('\u{ff77}', &['\u{30ad}']), ('\u{ff78}',
        &['\u{30af}']), ('\u{ff79}', &['\u{30b1}']), ('\u{ff7a}', &['\u{30b3}']), ('\u{ff7b}',
        &['\u{30b5}']), ('\u{ff7c}', &['\u{30b7}']), ('\u{ff7d}', &['\u{30b9}']), ('\u{ff7e}',
        &['\u{30bb}']), ('\u{ff7f}', &['\u{30bd}']), ('\u{ff80}', &['\u{30bf}']), ('\u{ff81}',
        &['\u{30c1}']), ('\u{ff82}', &['\u{30c4}']), ('\u{ff83}', &['\u{30c6}']), ('\u{ff84}',
        &['\u{30c8}']), ('\u{ff85}', &['\u{30ca}']), ('\u{ff86}', &['\u{30cb}']), ('\u{ff87}',
        &['\u{30cc}']), ('\u{ff88}', &['\u{30cd}']), ('\u{ff89}', &['\u{30ce}']), ('\u{ff8a}',
        &['\u{30cf}']), ('\u{ff8b}', &['\u{30d2}']), ('\u{ff8c}', &['\u{30d5}']), ('\u{ff8d}',
        &['\u{30d8}']), ('\u{ff8e}', &['\u{30db}']), ('\u{ff8f}', &['\u{30de}']), ('\u{ff90}',
        &['\u{30df}']), ('\u{ff91}', &['\u{30e0}']), ('\u{ff92}', &['\u{30e1}']), ('\u{ff93}',
        &['\u{30e2}']), ('\u{ff94}', &['\u{30e4}']), ('\u{ff95}', &['\u{30e6}']), ('\u{ff96}',
        &['\u{30e8}']), ('\u{ff97}', &['\u{30e9}']), ('\u{ff98}', &['\u{30ea}']), ('\u{ff99}',
        &['\u{30eb}']), ('\u{ff9a}', &['\u{30ec}']), ('\u{ff9b}', &['\u{30ed}']), ('\u{ff9c}',
        &['\u{30ef}']), ('\u{ff9d}', &['\u{30f3}']), ('\u{ff9e}', &['\u{3099}']), ('\u{ff9f}',
        &['\u{309a}']), ('\u{ffa0}', &['\u{3164}']), ('\u{ffa1}', &['\u{3131}']), ('\u{ffa2}',
        &['\u{3132}']), ('\u{ffa3}', &['\u{3133}']), ('\u{ffa4}', &['\u{3134}']), ('\u{ffa5}',
        &['\u{3135}']), ('\u{ffa6}', &['\u{3136}']), ('\u{ffa7}', &['\u{3137}']), ('\u{ffa8}',
        &['\u{3138}']), ('\u{ffa9}', &['\u{3139}']), ('\u{ffaa}', &['\u{313a}']), ('\u{ffab}',
        &['\u{313b}']), ('\u{ffac}', &['\u{313c}']), ('\u{ffad}', &['\u{313d}']), ('\u{ffae}',
        &['\u{313e}']), ('\u{ffaf}', &['\u{313f}']), ('\u{ffb0}', &['\u{3140}']), ('\u{ffb1}',
        &['\u{3141}']), ('\u{ffb2}', &['\u{3142}']), ('\u{ffb3}', &['\u{3143}']), ('\u{ffb4}',
        &['\u{3144}']), ('\u{ffb5}', &['\u{3145}']), ('\u{ffb6}', &['\u{3146}']), ('\u{ffb7}',
        &['\u{3147}']), ('\u{ffb8}', &['\u{3148}']), ('\u{ffb9}', &['\u{3149}']), ('\u{ffba}',
        &['\u{314a}']), ('\u{ffbb}', &['\u{314b}']), ('\u{ffbc}', &['\u{314c}']), ('\u{ffbd}',
        &['\u{314d}']), ('\u{ffbe}', &['\u{314e}']), ('\u{ffc2}', &['\u{314f}']), ('\u{ffc3}',
        &['\u{3150}']), ('\u{ffc4}', &['\u{3151}']), ('\u{ffc5}', &['\u{3152}']), ('\u{ffc6}',
        &['\u{3153}']), ('\u{ffc7}', &['\u{3154}']), ('\u{ffca}', &['\u{3155}']), ('\u{ffcb}',
        &['\u{3156}']), ('\u{ffcc}', &['\u{3157}']), ('\u{ffcd}', &['\u{3158}']), ('\u{ffce}',
        &['\u{3159}']), ('\u{ffcf}', &['\u{315a}']), ('\u{ffd2}', &['\u{315b}']), ('\u{ffd3}',
        &['\u{315c}']), ('\u{ffd4}', &['\u{315d}']), ('\u{ffd5}', &['\u{315e}']), ('\u{ffd6}',
        &['\u{315f}']), ('\u{ffd7}', &['\u{3160}']), ('\u{ffda}', &['\u{3161}']), ('\u{ffdb}',
        &['\u{3162}']), ('\u{ffdc}', &['\u{3163}']), ('\u{ffe0}', &['\u{a2}']), ('\u{ffe1}',
        &['\u{a3}']), ('\u{ffe2}', &['\u{ac}']), ('\u{ffe3}', &['\u{af}']), ('\u{ffe4}',
        &['\u{a6}']), ('\u{ffe5}', &['\u{a5}']), ('\u{ffe6}', &['\u{20a9}']), ('\u{ffe8}',
        &['\u{2502}']), ('\u{ffe9}', &['\u{2190}']), ('\u{ffea}', &['\u{2191}']), ('\u{ffeb}',
        &['\u{2192}']), ('\u{ffec}', &['\u{2193}']), ('\u{ffed}', &['\u{25a0}']), ('\u{ffee}',
        &['\u{25cb}']), ('\u{1d400}', &['\u{41}']), ('\u{1d401}', &['\u{42}']), ('\u{1d402}',
        &['\u{43}']), ('\u{1d403}', &['\u{44}']), ('\u{1d404}', &['\u{45}']), ('\u{1d405}',
        &['\u{46}']), ('\u{1d406}', &['\u{47}']), ('\u{1d407}', &['\u{48}']), ('\u{1d408}',
        &['\u{49}']), ('\u{1d409}', &['\u{4a}']), ('\u{1d40a}', &['\u{4b}']), ('\u{1d40b}',
        &['\u{4c}']), ('\u{1d40c}', &['\u{4d}']), ('\u{1d40d}', &['\u{4e}']), ('\u{1d40e}',
        &['\u{4f}']), ('\u{1d40f}', &['\u{50}']), ('\u{1d410}', &['\u{51}']), ('\u{1d411}',
        &['\u{52}']), ('\u{1d412}', &['\u{53}']), ('\u{1d413}', &['\u{54}']), ('\u{1d414}',
        &['\u{55}']), ('\u{1d415}', &['\u{56}']), ('\u{1d416}', &['\u{57}']), ('\u{1d417}',
        &['\u{58}']), ('\u{1d418}', &['\u{59}']), ('\u{1d419}', &['\u{5a}']), ('\u{1d41a}',
        &['\u{61}']), ('\u{1d41b}', &['\u{62}']), ('\u{1d41c}', &['\u{63}']), ('\u{1d41d}',
        &['\u{64}']), ('\u{1d41e}', &['\u{65}']), ('\u{1d41f}', &['\u{66}']), ('\u{1d420}',
        &['\u{67}']), ('\u{1d421}', &['\u{68}']), ('\u{1d422}', &['\u{69}']), ('\u{1d423}',
        &['\u{6a}']), ('\u{1d424}', &['\u{6b}']), ('\u{1d425}', &['\u{6c}']), ('\u{1d426}',
        &['\u{6d}']), ('\u{1d427}', &['\u{6e}']), ('\u{1d428}', &['\u{6f}']), ('\u{1d429}',
        &['\u{70}']), ('\u{1d42a}', &['\u{71}']), ('\u{1d42b}', &['\u{72}']), ('\u{1d42c}',
        &['\u{73}']), ('\u{1d42d}', &['\u{74}']), ('\u{1d42e}', &['\u{75}']), ('\u{1d42f}',
        &['\u{76}']), ('\u{1d430}', &['\u{77}']), ('\u{1d431}', &['\u{78}']), ('\u{1d432}',
        &['\u{79}']), ('\u{1d433}', &['\u{7a}']), ('\u{1d434}', &['\u{41}']), ('\u{1d435}',
        &['\u{42}']), ('\u{1d436}', &['\u{43}']), ('\u{1d437}', &['\u{44}']), ('\u{1d438}',
        &['\u{45}']), ('\u{1d439}', &['\u{46}']), ('\u{1d43a}', &['\u{47}']), ('\u{1d43b}',
        &['\u{48}']), ('\u{1d43c}', &['\u{49}']), ('\u{1d43d}', &['\u{4a}']), ('\u{1d43e}',
        &['\u{4b}']), ('\u{1d43f}', &['\u{4c}']), ('\u{1d440}', &['\u{4d}']), ('\u{1d441}',
        &['\u{4e}']), ('\u{1d442}', &['\u{4f}']), ('\u{1d443}', &['\u{50}']), ('\u{1d444}',
        &['\u{51}']), ('\u{1d445}', &['\u{52}']), ('\u{1d446}', &['\u{53}']), ('\u{1d447}',
        &['\u{54}']), ('\u{1d448}', &['\u{55}']), ('\u{1d449}', &['\u{56}']), ('\u{1d44a}',
        &['\u{57}']), ('\u{1d44b}', &['\u{58}']), ('\u{1d44c}', &['\u{59}']), ('\u{1d44d}',
        &['\u{5a}']), ('\u{1d44e}', &['\u{61}']), ('\u{1d44f}', &['\u{62}']), ('\u{1d450}',
        &['\u{63}']), ('\u{1d451}', &['\u{64}']), ('\u{1d452}', &['\u{65}']), ('\u{1d453}',
        &['\u{66}']), ('\u{1d454}', &['\u{67}']), ('\u{1d456}', &['\u{69}']), ('\u{1d457}',
        &['\u{6a}']), ('\u{1d458}', &['\u{6b}']), ('\u{1d459}', &['\u{6c}']), ('\u{1d45a}',
        &['\u{6d}']), ('\u{1d45b}', &['\u{6e}']), ('\u{1d45c}', &['\u{6f}']), ('\u{1d45d}',
        &['\u{70}']), ('\u{1d45e}', &['\u{71}']), ('\u{1d45f}', &['\u{72}']), ('\u{1d460}',
        &['\u{73}']), ('\u{1d461}', &['\u{74}']), ('\u{1d462}', &['\u{75}']), ('\u{1d463}',
        &['\u{76}']), ('\u{1d464}', &['\u{77}']), ('\u{1d465}', &['\u{78}']), ('\u{1d466}',
        &['\u{79}']), ('\u{1d467}', &['\u{7a}']), ('\u{1d468}', &['\u{41}']), ('\u{1d469}',
        &['\u{42}']), ('\u{1d46a}', &['\u{43}']), ('\u{1d46b}', &['\u{44}']), ('\u{1d46c}',
        &['\u{45}']), ('\u{1d46d}', &['\u{46}']), ('\u{1d46e}', &['\u{47}']), ('\u{1d46f}',
        &['\u{48}']), ('\u{1d470}', &['\u{49}']), ('\u{1d471}', &['\u{4a}']), ('\u{1d472}',
        &['\u{4b}']), ('\u{1d473}', &['\u{4c}']), ('\u{1d474}', &['\u{4d}']), ('\u{1d475}',
        &['\u{4e}']), ('\u{1d476}', &['\u{4f}']), ('\u{1d477}', &['\u{50}']), ('\u{1d478}',
        &['\u{51}']), ('\u{1d479}', &['\u{52}']), ('\u{1d47a}', &['\u{53}']), ('\u{1d47b}',
        &['\u{54}']), ('\u{1d47c}', &['\u{55}']), ('\u{1d47d}', &['\u{56}']), ('\u{1d47e}',
        &['\u{57}']), ('\u{1d47f}', &['\u{58}']), ('\u{1d480}', &['\u{59}']), ('\u{1d481}',
        &['\u{5a}']), ('\u{1d482}', &['\u{61}']), ('\u{1d483}', &['\u{62}']), ('\u{1d484}',
        &['\u{63}']), ('\u{1d485}', &['\u{64}']), ('\u{1d486}', &['\u{65}']), ('\u{1d487}',
        &['\u{66}']), ('\u{1d488}', &['\u{67}']), ('\u{1d489}', &['\u{68}']), ('\u{1d48a}',
        &['\u{69}']), ('\u{1d48b}', &['\u{6a}']), ('\u{1d48c}', &['\u{6b}']), ('\u{1d48d}',
        &['\u{6c}']), ('\u{1d48e}', &['\u{6d}']), ('\u{1d48f}', &['\u{6e}']), ('\u{1d490}',
        &['\u{6f}']), ('\u{1d491}', &['\u{70}']), ('\u{1d492}', &['\u{71}']), ('\u{1d493}',
        &['\u{72}']), ('\u{1d494}', &['\u{73}']), ('\u{1d495}', &['\u{74}']), ('\u{1d496}',
        &['\u{75}']), ('\u{1d497}', &['\u{76}']), ('\u{1d498}', &['\u{77}']), ('\u{1d499}',
        &['\u{78}']), ('\u{1d49a}', &['\u{79}']), ('\u{1d49b}', &['\u{7a}']), ('\u{1d49c}',
        &['\u{41}']), ('\u{1d49e}', &['\u{43}']), ('\u{1d49f}', &['\u{44}']), ('\u{1d4a2}',
        &['\u{47}']), ('\u{1d4a5}', &['\u{4a}']), ('\u{1d4a6}', &['\u{4b}']), ('\u{1d4a9}',
        &['\u{4e}']), ('\u{1d4aa}', &['\u{4f}']), ('\u{1d4ab}', &['\u{50}']), ('\u{1d4ac}',
        &['\u{51}']), ('\u{1d4ae}', &['\u{53}']), ('\u{1d4af}', &['\u{54}']), ('\u{1d4b0}',
        &['\u{55}']), ('\u{1d4b1}', &['\u{56}']), ('\u{1d4b2}', &['\u{57}']), ('\u{1d4b3}',
        &['\u{58}']), ('\u{1d4b4}', &['\u{59}']), ('\u{1d4b5}', &['\u{5a}']), ('\u{1d4b6}',
        &['\u{61}']), ('\u{1d4b7}', &['\u{62}']), ('\u{1d4b8}', &['\u{63}']), ('\u{1d4b9}',
        &['\u{64}']), ('\u{1d4bb}', &['\u{66}']), ('\u{1d4bd}', &['\u{68}']), ('\u{1d4be}',
        &['\u{69}']), ('\u{1d4bf}', &['\u{6a}']), ('\u{1d4c0}', &['\u{6b}']), ('\u{1d4c1}',
        &['\u{6c}']), ('\u{1d4c2}', &['\u{6d}']), ('\u{1d4c3}', &['\u{6e}']), ('\u{1d4c5}',
        &['\u{70}']), ('\u{1d4c6}', &['\u{71}']), ('\u{1d4c7}', &['\u{72}']), ('\u{1d4c8}',
        &['\u{73}']), ('\u{1d4c9}', &['\u{74}']), ('\u{1d4ca}', &['\u{75}']), ('\u{1d4cb}',
        &['\u{76}']), ('\u{1d4cc}', &['\u{77}']), ('\u{1d4cd}', &['\u{78}']), ('\u{1d4ce}',
        &['\u{79}']), ('\u{1d4cf}', &['\u{7a}']), ('\u{1d4d0}', &['\u{41}']), ('\u{1d4d1}',
        &['\u{42}']), ('\u{1d4d2}', &['\u{43}']), ('\u{1d4d3}', &['\u{44}']), ('\u{1d4d4}',
        &['\u{45}']), ('\u{1d4d5}', &['\u{46}']), ('\u{1d4d6}', &['\u{47}']), ('\u{1d4d7}',
        &['\u{48}']), ('\u{1d4d8}', &['\u{49}']), ('\u{1d4d9}', &['\u{4a}']), ('\u{1d4da}',
        &['\u{4b}']), ('\u{1d4db}', &['\u{4c}']), ('\u{1d4dc}', &['\u{4d}']), ('\u{1d4dd}',
        &['\u{4e}']), ('\u{1d4de}', &['\u{4f}']), ('\u{1d4df}', &['\u{50}']), ('\u{1d4e0}',
        &['\u{51}']), ('\u{1d4e1}', &['\u{52}']), ('\u{1d4e2}', &['\u{53}']), ('\u{1d4e3}',
        &['\u{54}']), ('\u{1d4e4}', &['\u{55}']), ('\u{1d4e5}', &['\u{56}']), ('\u{1d4e6}',
        &['\u{57}']), ('\u{1d4e7}', &['\u{58}']), ('\u{1d4e8}', &['\u{59}']), ('\u{1d4e9}',
        &['\u{5a}']), ('\u{1d4ea}', &['\u{61}']), ('\u{1d4eb}', &['\u{62}']), ('\u{1d4ec}',
        &['\u{63}']), ('\u{1d4ed}', &['\u{64}']), ('\u{1d4ee}', &['\u{65}']), ('\u{1d4ef}',
        &['\u{66}']), ('\u{1d4f0}', &['\u{67}']), ('\u{1d4f1}', &['\u{68}']), ('\u{1d4f2}',
        &['\u{69}']), ('\u{1d4f3}', &['\u{6a}']), ('\u{1d4f4}', &['\u{6b}']), ('\u{1d4f5}',
        &['\u{6c}']), ('\u{1d4f6}', &['\u{6d}']), ('\u{1d4f7}', &['\u{6e}']), ('\u{1d4f8}',
        &['\u{6f}']), ('\u{1d4f9}', &['\u{70}']), ('\u{1d4fa}', &['\u{71}']), ('\u{1d4fb}',
        &['\u{72}']), ('\u{1d4fc}', &['\u{73}']), ('\u{1d4fd}', &['\u{74}']), ('\u{1d4fe}',
        &['\u{75}']), ('\u{1d4ff}', &['\u{76}']), ('\u{1d500}', &['\u{77}']), ('\u{1d501}',
        &['\u{78}']), ('\u{1d502}', &['\u{79}']), ('\u{1d503}', &['\u{7a}']), ('\u{1d504}',
        &['\u{41}']), ('\u{1d505}', &['\u{42}']), ('\u{1d507}', &['\u{44}']), ('\u{1d508}',
        &['\u{45}']), ('\u{1d509}', &['\u{46}']), ('\u{1d50a}', &['\u{47}']), ('\u{1d50d}',
        &['\u{4a}']), ('\u{1d50e}', &['\u{4b}']), ('\u{1d50f}', &['\u{4c}']), ('\u{1d510}',
        &['\u{4d}']), ('\u{1d511}', &['\u{4e}']), ('\u{1d512}', &['\u{4f}']), ('\u{1d513}',
        &['\u{50}']), ('\u{1d514}', &['\u{51}']), ('\u{1d516}', &['\u{53}']), ('\u{1d517}',
        &['\u{54}']), ('\u{1d518}', &['\u{55}']), ('\u{1d519}', &['\u{56}']), ('\u{1d51a}',
        &['\u{57}']), ('\u{1d51b}', &['\u{58}']), ('\u{1d51c}', &['\u{59}']), ('\u{1d51e}',
        &['\u{61}']), ('\u{1d51f}', &['\u{62}']), ('\u{1d520}', &['\u{63}']), ('\u{1d521}',
        &['\u{64}']), ('\u{1d522}', &['\u{65}']), ('\u{1d523}', &['\u{66}']), ('\u{1d524}',
        &['\u{67}']), ('\u{1d525}', &['\u{68}']), ('\u{1d526}', &['\u{69}']), ('\u{1d527}',
        &['\u{6a}']), ('\u{1d528}', &['\u{6b}']), ('\u{1d529}', &['\u{6c}']), ('\u{1d52a}',
        &['\u{6d}']), ('\u{1d52b}', &['\u{6e}']), ('\u{1d52c}', &['\u{6f}']), ('\u{1d52d}',
        &['\u{70}']), ('\u{1d52e}', &['\u{71}']), ('\u{1d52f}', &['\u{72}']), ('\u{1d530}',
        &['\u{73}']), ('\u{1d531}', &['\u{74}']), ('\u{1d532}', &['\u{75}']), ('\u{1d533}',
        &['\u{76}']), ('\u{1d534}', &['\u{77}']), ('\u{1d535}', &['\u{78}']), ('\u{1d536}',
        &['\u{79}']), ('\u{1d537}', &['\u{7a}']), ('\u{1d538}', &['\u{41}']), ('\u{1d539}',
        &['\u{42}']), ('\u{1d53b}', &['\u{44}']), ('\u{1d53c}', &['\u{45}']), ('\u{1d53d}',
        &['\u{46}']), ('\u{1d53e}', &['\u{47}']), ('\u{1d540}', &['\u{49}']), ('\u{1d541}',
        &['\u{4a}']), ('\u{1d542}', &['\u{4b}']), ('\u{1d543}', &['\u{4c}']), ('\u{1d544}',
        &['\u{4d}']), ('\u{1d546}', &['\u{4f}']), ('\u{1d54a}', &['\u{53}']), ('\u{1d54b}',
        &['\u{54}']), ('\u{1d54c}', &['\u{55}']), ('\u{1d54d}', &['\u{56}']), ('\u{1d54e}',
        &['\u{57}']), ('\u{1d54f}', &['\u{58}']), ('\u{1d550}', &['\u{59}']), ('\u{1d552}',
        &['\u{61}']), ('\u{1d553}', &['\u{62}']), ('\u{1d554}', &['\u{63}']), ('\u{1d555}',
        &['\u{64}']), ('\u{1d556}', &['\u{65}']), ('\u{1d557}', &['\u{66}']), ('\u{1d558}',
        &['\u{67}']), ('\u{1d559}', &['\u{68}']), ('\u{1d55a}', &['\u{69}']), ('\u{1d55b}',
        &['\u{6a}']), ('\u{1d55c}', &['\u{6b}']), ('\u{1d55d}', &['\u{6c}']), ('\u{1d55e}',
        &['\u{6d}']), ('\u{1d55f}', &['\u{6e}']), ('\u{1d560}', &['\u{6f}']), ('\u{1d561}',
        &['\u{70}']), ('\u{1d562}', &['\u{71}']), ('\u{1d563}', &['\u{72}']), ('\u{1d564}',
        &['\u{73}']), ('\u{1d565}', &['\u{74}']), ('\u{1d566}', &['\u{75}']), ('\u{1d567}',
        &['\u{76}']), ('\u{1d568}', &['\u{77}']), ('\u{1d569}', &['\u{78}']), ('\u{1d56a}',
        &['\u{79}']), ('\u{1d56b}', &['\u{7a}']), ('\u{1d56c}', &['\u{41}']), ('\u{1d56d}',
        &['\u{42}']), ('\u{1d56e}', &['\u{43}']), ('\u{1d56f}', &['\u{44}']), ('\u{1d570}',
        &['\u{45}']), ('\u{1d571}', &['\u{46}']), ('\u{1d572}', &['\u{47}']), ('\u{1d573}',
        &['\u{48}']), ('\u{1d574}', &['\u{49}']), ('\u{1d575}', &['\u{4a}']), ('\u{1d576}',
        &['\u{4b}']), ('\u{1d577}', &['\u{4c}']), ('\u{1d578}', &['\u{4d}']), ('\u{1d579}',
        &['\u{4e}']), ('\u{1d57a}', &['\u{4f}']), ('\u{1d57b}', &['\u{50}']), ('\u{1d57c}',
        &['\u{51}']), ('\u{1d57d}', &['\u{52}']), ('\u{1d57e}', &['\u{53}']), ('\u{1d57f}',
        &['\u{54}']), ('\u{1d580}', &['\u{55}']), ('\u{1d581}', &['\u{56}']), ('\u{1d582}',
        &['\u{57}']), ('\u{1d583}', &['\u{58}']), ('\u{1d584}', &['\u{59}']), ('\u{1d585}',
        &['\u{5a}']), ('\u{1d586}', &['\u{61}']), ('\u{1d587}', &['\u{62}']), ('\u{1d588}',
        &['\u{63}']), ('\u{1d589}', &['\u{64}']), ('\u{1d58a}', &['\u{65}']), ('\u{1d58b}',
        &['\u{66}']), ('\u{1d58c}', &['\u{67}']), ('\u{1d58d}', &['\u{68}']), ('\u{1d58e}',
        &['\u{69}']), ('\u{1d58f}', &['\u{6a}']), ('\u{1d590}', &['\u{6b}']), ('\u{1d591}',
        &['\u{6c}']), ('\u{1d592}', &['\u{6d}']), ('\u{1d593}', &['\u{6e}']), ('\u{1d594}',
        &['\u{6f}']), ('\u{1d595}', &['\u{70}']), ('\u{1d596}', &['\u{71}']), ('\u{1d597}',
        &['\u{72}']), ('\u{1d598}', &['\u{73}']), ('\u{1d599}', &['\u{74}']), ('\u{1d59a}',
        &['\u{75}']), ('\u{1d59b}', &['\u{76}']), ('\u{1d59c}', &['\u{77}']), ('\u{1d59d}',
        &['\u{78}']), ('\u{1d59e}', &['\u{79}']), ('\u{1d59f}', &['\u{7a}']), ('\u{1d5a0}',
        &['\u{41}']), ('\u{1d5a1}', &['\u{42}']), ('\u{1d5a2}', &['\u{43}']), ('\u{1d5a3}',
        &['\u{44}']), ('\u{1d5a4}', &['\u{45}']), ('\u{1d5a5}', &['\u{46}']), ('\u{1d5a6}',
        &['\u{47}']), ('\u{1d5a7}', &['\u{48}']), ('\u{1d5a8}', &['\u{49}']), ('\u{1d5a9}',
        &['\u{4a}']), ('\u{1d5aa}', &['\u{4b}']), ('\u{1d5ab}', &['\u{4c}']), ('\u{1d5ac}',
        &['\u{4d}']), ('\u{1d5ad}', &['\u{4e}']), ('\u{1d5ae}', &['\u{4f}']), ('\u{1d5af}',
        &['\u{50}']), ('\u{1d5b0}', &['\u{51}']), ('\u{1d5b1}', &['\u{52}']), ('\u{1d5b2}',
        &['\u{53}']), ('\u{1d5b3}', &['\u{54}']), ('\u{1d5b4}', &['\u{55}']), ('\u{1d5b5}',
        &['\u{56}']), ('\u{1d5b6}', &['\u{57}']), ('\u{1d5b7}', &['\u{58}']), ('\u{1d5b8}',
        &['\u{59}']), ('\u{1d5b9}', &['\u{5a}']), ('\u{1d5ba}', &['\u{61}']), ('\u{1d5bb}',
        &['\u{62}']), ('\u{1d5bc}', &['\u{63}']), ('\u{1d5bd}', &['\u{64}']), ('\u{1d5be}',
        &['\u{65}']), ('\u{1d5bf}', &['\u{66}']), ('\u{1d5c0}', &['\u{67}']), ('\u{1d5c1}',
        &['\u{68}']), ('\u{1d5c2}', &['\u{69}']), ('\u{1d5c3}', &['\u{6a}']), ('\u{1d5c4}',
        &['\u{6b}']), ('\u{1d5c5}', &['\u{6c}']), ('\u{1d5c6}', &['\u{6d}']), ('\u{1d5c7}',
        &['\u{6e}']), ('\u{1d5c8}', &['\u{6f}']), ('\u{1d5c9}', &['\u{70}']), ('\u{1d5ca}',
        &['\u{71}']), ('\u{1d5cb}', &['\u{72}']), ('\u{1d5cc}', &['\u{73}']), ('\u{1d5cd}',
        &['\u{74}']), ('\u{1d5ce}', &['\u{75}']), ('\u{1d5cf}', &['\u{76}']), ('\u{1d5d0}',
        &['\u{77}']), ('\u{1d5d1}', &['\u{78}']), ('\u{1d5d2}', &['\u{79}']), ('\u{1d5d3}',
        &['\u{7a}']), ('\u{1d5d4}', &['\u{41}']), ('\u{1d5d5}', &['\u{42}']), ('\u{1d5d6}',
        &['\u{43}']), ('\u{1d5d7}', &['\u{44}']), ('\u{1d5d8}', &['\u{45}']), ('\u{1d5d9}',
        &['\u{46}']), ('\u{1d5da}', &['\u{47}']), ('\u{1d5db}', &['\u{48}']), ('\u{1d5dc}',
        &['\u{49}']), ('\u{1d5dd}', &['\u{4a}']), ('\u{1d5de}', &['\u{4b}']), ('\u{1d5df}',
        &['\u{4c}']), ('\u{1d5e0}', &['\u{4d}']), ('\u{1d5e1}', &['\u{4e}']), ('\u{1d5e2}',
        &['\u{4f}']), ('\u{1d5e3}', &['\u{50}']), ('\u{1d5e4}', &['\u{51}']), ('\u{1d5e5}',
        &['\u{52}']), ('\u{1d5e6}', &['\u{53}']), ('\u{1d5e7}', &['\u{54}']), ('\u{1d5e8}',
        &['\u{55}']), ('\u{1d5e9}', &['\u{56}']), ('\u{1d5ea}', &['\u{57}']), ('\u{1d5eb}',
        &['\u{58}']), ('\u{1d5ec}', &['\u{59}']), ('\u{1d5ed}', &['\u{5a}']), ('\u{1d5ee}',
        &['\u{61}']), ('\u{1d5ef}', &['\u{62}']), ('\u{1d5f0}', &['\u{63}']), ('\u{1d5f1}',
        &['\u{64}']), ('\u{1d5f2}', &['\u{65}']), ('\u{1d5f3}', &['\u{66}']), ('\u{1d5f4}',
        &['\u{67}']), ('\u{1d5f5}', &['\u{68}']), ('\u{1d5f6}', &['\u{69}']), ('\u{1d5f7}',
        &['\u{6a}']), ('\u{1d5f8}', &['\u{6b}']), ('\u{1d5f9}', &['\u{6c}']), ('\u{1d5fa}',
        &['\u{6d}']), ('\u{1d5fb}', &['\u{6e}']), ('\u{1d5fc}', &['\u{6f}']), ('\u{1d5fd}',
        &['\u{70}']), ('\u{1d5fe}', &['\u{71}']), ('\u{1d5ff}', &['\u{72}']), ('\u{1d600}',
        &['\u{73}']), ('\u{1d601}', &['\u{74}']), ('\u{1d602}', &['\u{75}']), ('\u{1d603}',
        &['\u{76}']), ('\u{1d604}', &['\u{77}']), ('\u{1d605}', &['\u{78}']), ('\u{1d606}',
        &['\u{79}']), ('\u{1d607}', &['\u{7a}']), ('\u{1d608}', &['\u{41}']), ('\u{1d609}',
        &['\u{42}']), ('\u{1d60a}', &['\u{43}']), ('\u{1d60b}', &['\u{44}']), ('\u{1d60c}',
        &['\u{45}']), ('\u{1d60d}', &['\u{46}']), ('\u{1d60e}', &['\u{47}']), ('\u{1d60f}',
        &['\u{48}']), ('\u{1d610}', &['\u{49}']), ('\u{1d611}', &['\u{4a}']), ('\u{1d612}',
        &['\u{4b}']), ('\u{1d613}', &['\u{4c}']), ('\u{1d614}', &['\u{4d}']), ('\u{1d615}',
        &['\u{4e}']), ('\u{1d616}', &['\u{4f}']), ('\u{1d617}', &['\u{50}']), ('\u{1d618}',
        &['\u{51}']), ('\u{1d619}', &['\u{52}']), ('\u{1d61a}', &['\u{53}']), ('\u{1d61b}',
        &['\u{54}']), ('\u{1d61c}', &['\u{55}']), ('\u{1d61d}', &['\u{56}']), ('\u{1d61e}',
        &['\u{57}']), ('\u{1d61f}', &['\u{58}']), ('\u{1d620}', &['\u{59}']), ('\u{1d621}',
        &['\u{5a}']), ('\u{1d622}', &['\u{61}']), ('\u{1d623}', &['\u{62}']), ('\u{1d624}',
        &['\u{63}']), ('\u{1d625}', &['\u{64}']), ('\u{1d626}', &['\u{65}']), ('\u{1d627}',
        &['\u{66}']), ('\u{1d628}', &['\u{67}']), ('\u{1d629}', &['\u{68}']), ('\u{1d62a}',
        &['\u{69}']), ('\u{1d62b}', &['\u{6a}']), ('\u{1d62c}', &['\u{6b}']), ('\u{1d62d}',
        &['\u{6c}']), ('\u{1d62e}', &['\u{6d}']), ('\u{1d62f}', &['\u{6e}']), ('\u{1d630}',
        &['\u{6f}']), ('\u{1d631}', &['\u{70}']), ('\u{1d632}', &['\u{71}']), ('\u{1d633}',
        &['\u{72}']), ('\u{1d634}', &['\u{73}']), ('\u{1d635}', &['\u{74}']), ('\u{1d636}',
        &['\u{75}']), ('\u{1d637}', &['\u{76}']), ('\u{1d638}', &['\u{77}']), ('\u{1d639}',
        &['\u{78}']), ('\u{1d63a}', &['\u{79}']), ('\u{1d63b}', &['\u{7a}']), ('\u{1d63c}',
        &['\u{41}']), ('\u{1d63d}', &['\u{42}']), ('\u{1d63e}', &['\u{43}']), ('\u{1d63f}',
        &['\u{44}']), ('\u{1d640}', &['\u{45}']), ('\u{1d641}', &['\u{46}']), ('\u{1d642}',
        &['\u{47}']), ('\u{1d643}', &['\u{48}']), ('\u{1d644}', &['\u{49}']), ('\u{1d645}',
        &['\u{4a}']), ('\u{1d646}', &['\u{4b}']), ('\u{1d647}', &['\u{4c}']), ('\u{1d648}',
        &['\u{4d}']), ('\u{1d649}', &['\u{4e}']), ('\u{1d64a}', &['\u{4f}']), ('\u{1d64b}',
        &['\u{50}']), ('\u{1d64c}', &['\u{51}']), ('\u{1d64d}', &['\u{52}']), ('\u{1d64e}',
        &['\u{53}']), ('\u{1d64f}', &['\u{54}']), ('\u{1d650}', &['\u{55}']), ('\u{1d651}',
        &['\u{56}']), ('\u{1d652}', &['\u{57}']), ('\u{1d653}', &['\u{58}']), ('\u{1d654}',
        &['\u{59}']), ('\u{1d655}', &['\u{5a}']), ('\u{1d656}', &['\u{61}']), ('\u{1d657}',
        &['\u{62}']), ('\u{1d658}', &['\u{63}']), ('\u{1d659}', &['\u{64}']), ('\u{1d65a}',
        &['\u{65}']), ('\u{1d65b}', &['\u{66}']), ('\u{1d65c}', &['\u{67}']), ('\u{1d65d}',
        &['\u{68}']), ('\u{1d65e}', &['\u{69}']), ('\u{1d65f}', &['\u{6a}']), ('\u{1d660}',
        &['\u{6b}']), ('\u{1d661}', &['\u{6c}']), ('\u{1d662}', &['\u{6d}']), ('\u{1d663}',
        &['\u{6e}']), ('\u{1d664}', &['\u{6f}']), ('\u{1d665}', &['\u{70}']), ('\u{1d666}',
        &['\u{71}']), ('\u{1d667}', &['\u{72}']), ('\u{1d668}', &['\u{73}']), ('\u{1d669}',
        &['\u{74}']), ('\u{1d66a}', &['\u{75}']), ('\u{1d66b}', &['\u{76}']), ('\u{1d66c}',
        &['\u{77}']), ('\u{1d66d}', &['\u{78}']), ('\u{1d66e}', &['\u{79}']), ('\u{1d66f}',
        &['\u{7a}']), ('\u{1d670}', &['\u{41}']), ('\u{1d671}', &['\u{42}']), ('\u{1d672}',
        &['\u{43}']), ('\u{1d673}', &['\u{44}']), ('\u{1d674}', &['\u{45}']), ('\u{1d675}',
        &['\u{46}']), ('\u{1d676}', &['\u{47}']), ('\u{1d677}', &['\u{48}']), ('\u{1d678}',
        &['\u{49}']), ('\u{1d679}', &['\u{4a}']), ('\u{1d67a}', &['\u{4b}']), ('\u{1d67b}',
        &['\u{4c}']), ('\u{1d67c}', &['\u{4d}']), ('\u{1d67d}', &['\u{4e}']), ('\u{1d67e}',
        &['\u{4f}']), ('\u{1d67f}', &['\u{50}']), ('\u{1d680}', &['\u{51}']), ('\u{1d681}',
        &['\u{52}']), ('\u{1d682}', &['\u{53}']), ('\u{1d683}', &['\u{54}']), ('\u{1d684}',
        &['\u{55}']), ('\u{1d685}', &['\u{56}']), ('\u{1d686}', &['\u{57}']), ('\u{1d687}',
        &['\u{58}']), ('\u{1d688}', &['\u{59}']), ('\u{1d689}', &['\u{5a}']), ('\u{1d68a}',
        &['\u{61}']), ('\u{1d68b}', &['\u{62}']), ('\u{1d68c}', &['\u{63}']), ('\u{1d68d}',
        &['\u{64}']), ('\u{1d68e}', &['\u{65}']), ('\u{1d68f}', &['\u{66}']), ('\u{1d690}',
        &['\u{67}']), ('\u{1d691}', &['\u{68}']), ('\u{1d692}', &['\u{69}']), ('\u{1d693}',
        &['\u{6a}']), ('\u{1d694}', &['\u{6b}']), ('\u{1d695}', &['\u{6c}']), ('\u{1d696}',
        &['\u{6d}']), ('\u{1d697}', &['\u{6e}']), ('\u{1d698}', &['\u{6f}']), ('\u{1d699}',
        &['\u{70}']), ('\u{1d69a}', &['\u{71}']), ('\u{1d69b}', &['\u{72}']), ('\u{1d69c}',
        &['\u{73}']), ('\u{1d69d}', &['\u{74}']), ('\u{1d69e}', &['\u{75}']), ('\u{1d69f}',
        &['\u{76}']), ('\u{1d6a0}', &['\u{77}']), ('\u{1d6a1}', &['\u{78}']), ('\u{1d6a2}',
        &['\u{79}']), ('\u{1d6a3}', &['\u{7a}']), ('\u{1d6a4}', &['\u{131}']), ('\u{1d6a5}',
        &['\u{237}']), ('\u{1d6a8}', &['\u{391}']), ('\u{1d6a9}', &['\u{392}']), ('\u{1d6aa}',
        &['\u{393}']), ('\u{1d6ab}', &['\u{394}']), ('\u{1d6ac}', &['\u{395}']), ('\u{1d6ad}',
        &['\u{396}']), ('\u{1d6ae}', &['\u{397}']), ('\u{1d6af}', &['\u{398}']), ('\u{1d6b0}',
        &['\u{399}']), ('\u{1d6b1}', &['\u{39a}']), ('\u{1d6b2}', &['\u{39b}']), ('\u{1d6b3}',
        &['\u{39c}']), ('\u{1d6b4}', &['\u{39d}']), ('\u{1d6b5}', &['\u{39e}']), ('\u{1d6b6}',
        &['\u{39f}']), ('\u{1d6b7}', &['\u{3a0}']), ('\u{1d6b8}', &['\u{3a1}']), ('\u{1d6b9}',
        &['\u{3f4}']), ('\u{1d6ba}', &['\u{3a3}']), ('\u{1d6bb}', &['\u{3a4}']), ('\u{1d6bc}',
        &['\u{3a5}']), ('\u{1d6bd}', &['\u{3a6}']), ('\u{1d6be}', &['\u{3a7}']), ('\u{1d6bf}',
        &['\u{3a8}']), ('\u{1d6c0}', &['\u{3a9}']), ('\u{1d6c1}', &['\u{2207}']), ('\u{1d6c2}',
        &['\u{3b1}']), ('\u{1d6c3}', &['\u{3b2}']), ('\u{1d6c4}', &['\u{3b3}']), ('\u{1d6c5}',
        &['\u{3b4}']), ('\u{1d6c6}', &['\u{3b5}']), ('\u{1d6c7}', &['\u{3b6}']), ('\u{1d6c8}',
        &['\u{3b7}']), ('\u{1d6c9}', &['\u{3b8}']), ('\u{1d6ca}', &['\u{3b9}']), ('\u{1d6cb}',
        &['\u{3ba}']), ('\u{1d6cc}', &['\u{3bb}']), ('\u{1d6cd}', &['\u{3bc}']), ('\u{1d6ce}',
        &['\u{3bd}']), ('\u{1d6cf}', &['\u{3be}']), ('\u{1d6d0}', &['\u{3bf}']), ('\u{1d6d1}',
        &['\u{3c0}']), ('\u{1d6d2}', &['\u{3c1}']), ('\u{1d6d3}', &['\u{3c2}']), ('\u{1d6d4}',
        &['\u{3c3}']), ('\u{1d6d5}', &['\u{3c4}']), ('\u{1d6d6}', &['\u{3c5}']), ('\u{1d6d7}',
        &['\u{3c6}']), ('\u{1d6d8}', &['\u{3c7}']), ('\u{1d6d9}', &['\u{3c8}']), ('\u{1d6da}',
        &['\u{3c9}']), ('\u{1d6db}', &['\u{2202}']), ('\u{1d6dc}', &['\u{3f5}']), ('\u{1d6dd}',
        &['\u{3d1}']), ('\u{1d6de}', &['\u{3f0}']), ('\u{1d6df}', &['\u{3d5}']), ('\u{1d6e0}',
        &['\u{3f1}']), ('\u{1d6e1}', &['\u{3d6}']), ('\u{1d6e2}', &['\u{391}']), ('\u{1d6e3}',
        &['\u{392}']), ('\u{1d6e4}', &['\u{393}']), ('\u{1d6e5}', &['\u{394}']), ('\u{1d6e6}',
        &['\u{395}']), ('\u{1d6e7}', &['\u{396}']), ('\u{1d6e8}', &['\u{397}']), ('\u{1d6e9}',
        &['\u{398}']), ('\u{1d6ea}', &['\u{399}']), ('\u{1d6eb}', &['\u{39a}']), ('\u{1d6ec}',
        &['\u{39b}']), ('\u{1d6ed}', &['\u{39c}']), ('\u{1d6ee}', &['\u{39d}']), ('\u{1d6ef}',
        &['\u{39e}']), ('\u{1d6f0}', &['\u{39f}']), ('\u{1d6f1}', &['\u{3a0}']), ('\u{1d6f2}',
        &['\u{3a1}']), ('\u{1d6f3}', &['\u{3f4}']), ('\u{1d6f4}', &['\u{3a3}']), ('\u{1d6f5}',
        &['\u{3a4}']), ('\u{1d6f6}', &['\u{3a5}']), ('\u{1d6f7}', &['\u{3a6}']), ('\u{1d6f8}',
        &['\u{3a7}']), ('\u{1d6f9}', &['\u{3a8}']), ('\u{1d6fa}', &['\u{3a9}']), ('\u{1d6fb}',
        &['\u{2207}']), ('\u{1d6fc}', &['\u{3b1}']), ('\u{1d6fd}', &['\u{3b2}']), ('\u{1d6fe}',
        &['\u{3b3}']), ('\u{1d6ff}', &['\u{3b4}']), ('\u{1d700}', &['\u{3b5}']), ('\u{1d701}',
        &['\u{3b6}']), ('\u{1d702}', &['\u{3b7}']), ('\u{1d703}', &['\u{3b8}']), ('\u{1d704}',
        &['\u{3b9}']), ('\u{1d705}', &['\u{3ba}']), ('\u{1d706}', &['\u{3bb}']), ('\u{1d707}',
        &['\u{3bc}']), ('\u{1d708}', &['\u{3bd}']), ('\u{1d709}', &['\u{3be}']), ('\u{1d70a}',
        &['\u{3bf}']), ('\u{1d70b}', &['\u{3c0}']), ('\u{1d70c}', &['\u{3c1}']), ('\u{1d70d}',
        &['\u{3c2}']), ('\u{1d70e}', &['\u{3c3}']), ('\u{1d70f}', &['\u{3c4}']), ('\u{1d710}',
        &['\u{3c5}']), ('\u{1d711}', &['\u{3c6}']), ('\u{1d712}', &['\u{3c7}']), ('\u{1d713}',
        &['\u{3c8}']), ('\u{1d714}', &['\u{3c9}']), ('\u{1d715}', &['\u{2202}']), ('\u{1d716}',
        &['\u{3f5}']), ('\u{1d717}', &['\u{3d1}']), ('\u{1d718}', &['\u{3f0}']), ('\u{1d719}',
        &['\u{3d5}']), ('\u{1d71a}', &['\u{3f1}']), ('\u{1d71b}', &['\u{3d6}']), ('\u{1d71c}',
        &['\u{391}']), ('\u{1d71d}', &['\u{392}']), ('\u{1d71e}', &['\u{393}']), ('\u{1d71f}',
        &['\u{394}']), ('\u{1d720}', &['\u{395}']), ('\u{1d721}', &['\u{396}']), ('\u{1d722}',
        &['\u{397}']), ('\u{1d723}', &['\u{398}']), ('\u{1d724}', &['\u{399}']), ('\u{1d725}',
        &['\u{39a}']), ('\u{1d726}', &['\u{39b}']), ('\u{1d727}', &['\u{39c}']), ('\u{1d728}',
        &['\u{39d}']), ('\u{1d729}', &['\u{39e}']), ('\u{1d72a}', &['\u{39f}']), ('\u{1d72b}',
        &['\u{3a0}']), ('\u{1d72c}', &['\u{3a1}']), ('\u{1d72d}', &['\u{3f4}']), ('\u{1d72e}',
        &['\u{3a3}']), ('\u{1d72f}', &['\u{3a4}']), ('\u{1d730}', &['\u{3a5}']), ('\u{1d731}',
        &['\u{3a6}']), ('\u{1d732}', &['\u{3a7}']), ('\u{1d733}', &['\u{3a8}']), ('\u{1d734}',
        &['\u{3a9}']), ('\u{1d735}', &['\u{2207}']), ('\u{1d736}', &['\u{3b1}']), ('\u{1d737}',
        &['\u{3b2}']), ('\u{1d738}', &['\u{3b3}']), ('\u{1d739}', &['\u{3b4}']), ('\u{1d73a}',
        &['\u{3b5}']), ('\u{1d73b}', &['\u{3b6}']), ('\u{1d73c}', &['\u{3b7}']), ('\u{1d73d}',
        &['\u{3b8}']), ('\u{1d73e}', &['\u{3b9}']), ('\u{1d73f}', &['\u{3ba}']), ('\u{1d740}',
        &['\u{3bb}']), ('\u{1d741}', &['\u{3bc}']), ('\u{1d742}', &['\u{3bd}']), ('\u{1d743}',
        &['\u{3be}']), ('\u{1d744}', &['\u{3bf}']), ('\u{1d745}', &['\u{3c0}']), ('\u{1d746}',
        &['\u{3c1}']), ('\u{1d747}', &['\u{3c2}']), ('\u{1d748}', &['\u{3c3}']), ('\u{1d749}',
        &['\u{3c4}']), ('\u{1d74a}', &['\u{3c5}']), ('\u{1d74b}', &['\u{3c6}']), ('\u{1d74c}',
        &['\u{3c7}']), ('\u{1d74d}', &['\u{3c8}']), ('\u{1d74e}', &['\u{3c9}']), ('\u{1d74f}',
        &['\u{2202}']), ('\u{1d750}', &['\u{3f5}']), ('\u{1d751}', &['\u{3d1}']), ('\u{1d752}',
        &['\u{3f0}']), ('\u{1d753}', &['\u{3d5}']), ('\u{1d754}', &['\u{3f1}']), ('\u{1d755}',
        &['\u{3d6}']), ('\u{1d756}', &['\u{391}']), ('\u{1d757}', &['\u{392}']), ('\u{1d758}',
        &['\u{393}']), ('\u{1d759}', &['\u{394}']), ('\u{1d75a}', &['\u{395}']), ('\u{1d75b}',
        &['\u{396}']), ('\u{1d75c}', &['\u{397}']), ('\u{1d75d}', &['\u{398}']), ('\u{1d75e}',
        &['\u{399}']), ('\u{1d75f}', &['\u{39a}']), ('\u{1d760}', &['\u{39b}']), ('\u{1d761}',
        &['\u{39c}']), ('\u{1d762}', &['\u{39d}']), ('\u{1d763}', &['\u{39e}']), ('\u{1d764}',
        &['\u{39f}']), ('\u{1d765}', &['\u{3a0}']), ('\u{1d766}', &['\u{3a1}']), ('\u{1d767}',
        &['\u{3f4}']), ('\u{1d768}', &['\u{3a3}']), ('\u{1d769}', &['\u{3a4}']), ('\u{1d76a}',
        &['\u{3a5}']), ('\u{1d76b}', &['\u{3a6}']), ('\u{1d76c}', &['\u{3a7}']), ('\u{1d76d}',
        &['\u{3a8}']), ('\u{1d76e}', &['\u{3a9}']), ('\u{1d76f}', &['\u{2207}']), ('\u{1d770}',
        &['\u{3b1}']), ('\u{1d771}', &['\u{3b2}']), ('\u{1d772}', &['\u{3b3}']), ('\u{1d773}',
        &['\u{3b4}']), ('\u{1d774}', &['\u{3b5}']), ('\u{1d775}', &['\u{3b6}']), ('\u{1d776}',
        &['\u{3b7}']), ('\u{1d777}', &['\u{3b8}']), ('\u{1d778}', &['\u{3b9}']), ('\u{1d779}',
        &['\u{3ba}']), ('\u{1d77a}', &['\u{3bb}']), ('\u{1d77b}', &['\u{3bc}']), ('\u{1d77c}',
        &['\u{3bd}']), ('\u{1d77d}', &['\u{3be}']), ('\u{1d77e}', &['\u{3bf}']), ('\u{1d77f}',
        &['\u{3c0}']), ('\u{1d780}', &['\u{3c1}']), ('\u{1d781}', &['\u{3c2}']), ('\u{1d782}',
        &['\u{3c3}']), ('\u{1d783}', &['\u{3c4}']), ('\u{1d784}', &['\u{3c5}']), ('\u{1d785}',
        &['\u{3c6}']), ('\u{1d786}', &['\u{3c7}']), ('\u{1d787}', &['\u{3c8}']), ('\u{1d788}',
        &['\u{3c9}']), ('\u{1d789}', &['\u{2202}']), ('\u{1d78a}', &['\u{3f5}']), ('\u{1d78b}',
        &['\u{3d1}']), ('\u{1d78c}', &['\u{3f0}']), ('\u{1d78d}', &['\u{3d5}']), ('\u{1d78e}',
        &['\u{3f1}']), ('\u{1d78f}', &['\u{3d6}']), ('\u{1d790}', &['\u{391}']), ('\u{1d791}',
        &['\u{392}']), ('\u{1d792}', &['\u{393}']), ('\u{1d793}', &['\u{394}']), ('\u{1d794}',
        &['\u{395}']), ('\u{1d795}', &['\u{396}']), ('\u{1d796}', &['\u{397}']), ('\u{1d797}',
        &['\u{398}']), ('\u{1d798}', &['\u{399}']), ('\u{1d799}', &['\u{39a}']), ('\u{1d79a}',
        &['\u{39b}']), ('\u{1d79b}', &['\u{39c}']), ('\u{1d79c}', &['\u{39d}']), ('\u{1d79d}',
        &['\u{39e}']), ('\u{1d79e}', &['\u{39f}']), ('\u{1d79f}', &['\u{3a0}']), ('\u{1d7a0}',
        &['\u{3a1}']), ('\u{1d7a1}', &['\u{3f4}']), ('\u{1d7a2}', &['\u{3a3}']), ('\u{1d7a3}',
        &['\u{3a4}']), ('\u{1d7a4}', &['\u{3a5}']), ('\u{1d7a5}', &['\u{3a6}']), ('\u{1d7a6}',
        &['\u{3a7}']), ('\u{1d7a7}', &['\u{3a8}']), ('\u{1d7a8}', &['\u{3a9}']), ('\u{1d7a9}',
        &['\u{2207}']), ('\u{1d7aa}', &['\u{3b1}']), ('\u{1d7ab}', &['\u{3b2}']), ('\u{1d7ac}',
        &['\u{3b3}']), ('\u{1d7ad}', &['\u{3b4}']), ('\u{1d7ae}', &['\u{3b5}']), ('\u{1d7af}',
        &['\u{3b6}']), ('\u{1d7b0}', &['\u{3b7}']), ('\u{1d7b1}', &['\u{3b8}']), ('\u{1d7b2}',
        &['\u{3b9}']), ('\u{1d7b3}', &['\u{3ba}']), ('\u{1d7b4}', &['\u{3bb}']), ('\u{1d7b5}',
        &['\u{3bc}']), ('\u{1d7b6}', &['\u{3bd}']), ('\u{1d7b7}', &['\u{3be}']), ('\u{1d7b8}',
        &['\u{3bf}']), ('\u{1d7b9}', &['\u{3c0}']), ('\u{1d7ba}', &['\u{3c1}']), ('\u{1d7bb}',
        &['\u{3c2}']), ('\u{1d7bc}', &['\u{3c3}']), ('\u{1d7bd}', &['\u{3c4}']), ('\u{1d7be}',
        &['\u{3c5}']), ('\u{1d7bf}', &['\u{3c6}']), ('\u{1d7c0}', &['\u{3c7}']), ('\u{1d7c1}',
        &['\u{3c8}']), ('\u{1d7c2}', &['\u{3c9}']), ('\u{1d7c3}', &['\u{2202}']), ('\u{1d7c4}',
        &['\u{3f5}']), ('\u{1d7c5}', &['\u{3d1}']), ('\u{1d7c6}', &['\u{3f0}']), ('\u{1d7c7}',
        &['\u{3d5}']), ('\u{1d7c8}', &['\u{3f1}']), ('\u{1d7c9}', &['\u{3d6}']), ('\u{1d7ca}',
        &['\u{3dc}']), ('\u{1d7cb}', &['\u{3dd}']), ('\u{1d7ce}', &['\u{30}']), ('\u{1d7cf}',
        &['\u{31}']), ('\u{1d7d0}', &['\u{32}']), ('\u{1d7d1}', &['\u{33}']), ('\u{1d7d2}',
        &['\u{34}']), ('\u{1d7d3}', &['\u{35}']), ('\u{1d7d4}', &['\u{36}']), ('\u{1d7d5}',
        &['\u{37}']), ('\u{1d7d6}', &['\u{38}']), ('\u{1d7d7}', &['\u{39}']), ('\u{1d7d8}',
        &['\u{30}']), ('\u{1d7d9}', &['\u{31}']), ('\u{1d7da}', &['\u{32}']), ('\u{1d7db}',
        &['\u{33}']), ('\u{1d7dc}', &['\u{34}']), ('\u{1d7dd}', &['\u{35}']), ('\u{1d7de}',
        &['\u{36}']), ('\u{1d7df}', &['\u{37}']), ('\u{1d7e0}', &['\u{38}']), ('\u{1d7e1}',
        &['\u{39}']), ('\u{1d7e2}', &['\u{30}']), ('\u{1d7e3}', &['\u{31}']), ('\u{1d7e4}',
        &['\u{32}']), ('\u{1d7e5}', &['\u{33}']), ('\u{1d7e6}', &['\u{34}']), ('\u{1d7e7}',
        &['\u{35}']), ('\u{1d7e8}', &['\u{36}']), ('\u{1d7e9}', &['\u{37}']), ('\u{1d7ea}',
        &['\u{38}']), ('\u{1d7eb}', &['\u{39}']), ('\u{1d7ec}', &['\u{30}']), ('\u{1d7ed}',
        &['\u{31}']), ('\u{1d7ee}', &['\u{32}']), ('\u{1d7ef}', &['\u{33}']), ('\u{1d7f0}',
        &['\u{34}']), ('\u{1d7f1}', &['\u{35}']), ('\u{1d7f2}', &['\u{36}']), ('\u{1d7f3}',
        &['\u{37}']), ('\u{1d7f4}', &['\u{38}']), ('\u{1d7f5}', &['\u{39}']), ('\u{1d7f6}',
        &['\u{30}']), ('\u{1d7f7}', &['\u{31}']), ('\u{1d7f8}', &['\u{32}']), ('\u{1d7f9}',
        &['\u{33}']), ('\u{1d7fa}', &['\u{34}']), ('\u{1d7fb}', &['\u{35}']), ('\u{1d7fc}',
        &['\u{36}']), ('\u{1d7fd}', &['\u{37}']), ('\u{1d7fe}', &['\u{38}']), ('\u{1d7ff}',
        &['\u{39}']), ('\u{1ee00}', &['\u{627}']), ('\u{1ee01}', &['\u{628}']), ('\u{1ee02}',
        &['\u{62c}']), ('\u{1ee03}', &['\u{62f}']), ('\u{1ee05}', &['\u{648}']), ('\u{1ee06}',
        &['\u{632}']), ('\u{1ee07}', &['\u{62d}']), ('\u{1ee08}', &['\u{637}']), ('\u{1ee09}',
        &['\u{64a}']), ('\u{1ee0a}', &['\u{643}']), ('\u{1ee0b}', &['\u{644}']), ('\u{1ee0c}',
        &['\u{645}']), ('\u{1ee0d}', &['\u{646}']), ('\u{1ee0e}', &['\u{633}']), ('\u{1ee0f}',
        &['\u{639}']), ('\u{1ee10}', &['\u{641}']), ('\u{1ee11}', &['\u{635}']), ('\u{1ee12}',
        &['\u{642}']), ('\u{1ee13}', &['\u{631}']), ('\u{1ee14}', &['\u{634}']), ('\u{1ee15}',
        &['\u{62a}']), ('\u{1ee16}', &['\u{62b}']), ('\u{1ee17}', &['\u{62e}']), ('\u{1ee18}',
        &['\u{630}']), ('\u{1ee19}', &['\u{636}']), ('\u{1ee1a}', &['\u{638}']), ('\u{1ee1b}',
        &['\u{63a}']), ('\u{1ee1c}', &['\u{66e}']), ('\u{1ee1d}', &['\u{6ba}']), ('\u{1ee1e}',
        &['\u{6a1}']), ('\u{1ee1f}', &['\u{66f}']), ('\u{1ee21}', &['\u{628}']), ('\u{1ee22}',
        &['\u{62c}']), ('\u{1ee24}', &['\u{647}']), ('\u{1ee27}', &['\u{62d}']), ('\u{1ee29}',
        &['\u{64a}']), ('\u{1ee2a}', &['\u{643}']), ('\u{1ee2b}', &['\u{644}']), ('\u{1ee2c}',
        &['\u{645}']), ('\u{1ee2d}', &['\u{646}']), ('\u{1ee2e}', &['\u{633}']), ('\u{1ee2f}',
        &['\u{639}']), ('\u{1ee30}', &['\u{641}']), ('\u{1ee31}', &['\u{635}']), ('\u{1ee32}',
        &['\u{642}']), ('\u{1ee34}', &['\u{634}']), ('\u{1ee35}', &['\u{62a}']), ('\u{1ee36}',
        &['\u{62b}']), ('\u{1ee37}', &['\u{62e}']), ('\u{1ee39}', &['\u{636}']), ('\u{1ee3b}',
        &['\u{63a}']), ('\u{1ee42}', &['\u{62c}']), ('\u{1ee47}', &['\u{62d}']), ('\u{1ee49}',
        &['\u{64a}']), ('\u{1ee4b}', &['\u{644}']), ('\u{1ee4d}', &['\u{646}']), ('\u{1ee4e}',
        &['\u{633}']), ('\u{1ee4f}', &['\u{639}']), ('\u{1ee51}', &['\u{635}']), ('\u{1ee52}',
        &['\u{642}']), ('\u{1ee54}', &['\u{634}']), ('\u{1ee57}', &['\u{62e}']), ('\u{1ee59}',
        &['\u{636}']), ('\u{1ee5b}', &['\u{63a}']), ('\u{1ee5d}', &['\u{6ba}']), ('\u{1ee5f}',
        &['\u{66f}']), ('\u{1ee61}', &['\u{628}']), ('\u{1ee62}', &['\u{62c}']), ('\u{1ee64}',
        &['\u{647}']), ('\u{1ee67}', &['\u{62d}']), ('\u{1ee68}', &['\u{637}']), ('\u{1ee69}',
        &['\u{64a}']), ('\u{1ee6a}', &['\u{643}']), ('\u{1ee6c}', &['\u{645}']), ('\u{1ee6d}',
        &['\u{646}']), ('\u{1ee6e}', &['\u{633}']), ('\u{1ee6f}', &['\u{639}']), ('\u{1ee70}',
        &['\u{641}']), ('\u{1ee71}', &['\u{635}']), ('\u{1ee72}', &['\u{642}']), ('\u{1ee74}',
        &['\u{634}']), ('\u{1ee75}', &['\u{62a}']), ('\u{1ee76}', &['\u{62b}']), ('\u{1ee77}',
        &['\u{62e}']), ('\u{1ee79}', &['\u{636}']), ('\u{1ee7a}', &['\u{638}']), ('\u{1ee7b}',
        &['\u{63a}']), ('\u{1ee7c}', &['\u{66e}']), ('\u{1ee7e}', &['\u{6a1}']), ('\u{1ee80}',
        &['\u{627}']), ('\u{1ee81}', &['\u{628}']), ('\u{1ee82}', &['\u{62c}']), ('\u{1ee83}',
        &['\u{62f}']), ('\u{1ee84}', &['\u{647}']), ('\u{1ee85}', &['\u{648}']), ('\u{1ee86}',
        &['\u{632}']), ('\u{1ee87}', &['\u{62d}']), ('\u{1ee88}', &['\u{637}']), ('\u{1ee89}',
        &['\u{64a}']), ('\u{1ee8b}', &['\u{644}']), ('\u{1ee8c}', &['\u{645}']), ('\u{1ee8d}',
        &['\u{646}']), ('\u{1ee8e}', &['\u{633}']), ('\u{1ee8f}', &['\u{639}']), ('\u{1ee90}',
        &['\u{641}']), ('\u{1ee91}', &['\u{635}']), ('\u{1ee92}', &['\u{642}']), ('\u{1ee93}',
        &['\u{631}']), ('\u{1ee94}', &['\u{634}']), ('\u{1ee95}', &['\u{62a}']), ('\u{1ee96}',
        &['\u{62b}']), ('\u{1ee97}', &['\u{62e}']), ('\u{1ee98}', &['\u{630}']), ('\u{1ee99}',
        &['\u{636}']), ('\u{1ee9a}', &['\u{638}']), ('\u{1ee9b}', &['\u{63a}']), ('\u{1eea1}',
        &['\u{628}']), ('\u{1eea2}', &['\u{62c}']), ('\u{1eea3}', &['\u{62f}']), ('\u{1eea5}',
        &['\u{648}']), ('\u{1eea6}', &['\u{632}']), ('\u{1eea7}', &['\u{62d}']), ('\u{1eea8}',
        &['\u{637}']), ('\u{1eea9}', &['\u{64a}']), ('\u{1eeab}', &['\u{644}']), ('\u{1eeac}',
        &['\u{645}']), ('\u{1eead}', &['\u{646}']), ('\u{1eeae}', &['\u{633}']), ('\u{1eeaf}',
        &['\u{639}']), ('\u{1eeb0}', &['\u{641}']), ('\u{1eeb1}', &['\u{635}']), ('\u{1eeb2}',
        &['\u{642}']), ('\u{1eeb3}', &['\u{631}']), ('\u{1eeb4}', &['\u{634}']), ('\u{1eeb5}',
        &['\u{62a}']), ('\u{1eeb6}', &['\u{62b}']), ('\u{1eeb7}', &['\u{62e}']), ('\u{1eeb8}',
        &['\u{630}']), ('\u{1eeb9}', &['\u{636}']), ('\u{1eeba}', &['\u{638}']), ('\u{1eebb}',
        &['\u{63a}']), ('\u{1f100}', &['\u{30}', '\u{2e}']), ('\u{1f101}', &['\u{30}', '\u{2c}']),
        ('\u{1f102}', &['\u{31}', '\u{2c}']), ('\u{1f103}', &['\u{32}', '\u{2c}']), ('\u{1f104}',
        &['\u{33}', '\u{2c}']), ('\u{1f105}', &['\u{34}', '\u{2c}']), ('\u{1f106}', &['\u{35}',
        '\u{2c}']), ('\u{1f107}', &['\u{36}', '\u{2c}']), ('\u{1f108}', &['\u{37}', '\u{2c}']),
        ('\u{1f109}', &['\u{38}', '\u{2c}']), ('\u{1f10a}', &['\u{39}', '\u{2c}']), ('\u{1f110}',
        &['\u{28}', '\u{41}', '\u{29}']), ('\u{1f111}', &['\u{28}', '\u{42}', '\u{29}']),
        ('\u{1f112}', &['\u{28}', '\u{43}', '\u{29}']), ('\u{1f113}', &['\u{28}', '\u{44}',
        '\u{29}']), ('\u{1f114}', &['\u{28}', '\u{45}', '\u{29}']), ('\u{1f115}', &['\u{28}',
        '\u{46}', '\u{29}']), ('\u{1f116}', &['\u{28}', '\u{47}', '\u{29}']), ('\u{1f117}',
        &['\u{28}', '\u{48}', '\u{29}']), ('\u{1f118}', &['\u{28}', '\u{49}', '\u{29}']),
        ('\u{1f119}', &['\u{28}', '\u{4a}', '\u{29}']), ('\u{1f11a}', &['\u{28}', '\u{4b}',
        '\u{29}']), ('\u{1f11b}', &['\u{28}', '\u{4c}', '\u{29}']), ('\u{1f11c}', &['\u{28}',
        '\u{4d}', '\u{29}']), ('\u{1f11d}', &['\u{28}', '\u{4e}', '\u{29}']), ('\u{1f11e}',
        &['\u{28}', '\u{4f}', '\u{29}']), ('\u{1f11f}', &['\u{28}', '\u{50}', '\u{29}']),
        ('\u{1f120}', &['\u{28}', '\u{51}', '\u{29}']), ('\u{1f121}', &['\u{28}', '\u{52}',
        '\u{29}']), ('\u{1f122}', &['\u{28}', '\u{53}', '\u{29}']), ('\u{1f123}', &['\u{28}',
        '\u{54}', '\u{29}']), ('\u{1f124}', &['\u{28}', '\u{55}', '\u{29}']), ('\u{1f125}',
        &['\u{28}', '\u{56}', '\u{29}']), ('\u{1f126}', &['\u{28}', '\u{57}', '\u{29}']),
        ('\u{1f127}', &['\u{28}', '\u{58}', '\u{29}']), ('\u{1f128}', &['\u{28}', '\u{59}',
        '\u{29}']), ('\u{1f129}', &['\u{28}', '\u{5a}', '\u{29}']), ('\u{1f12a}', &['\u{3014}',
        '\u{53}', '\u{3015}']), ('\u{1f12b}', &['\u{43}']), ('\u{1f12c}', &['\u{52}']),
        ('\u{1f12d}', &['\u{43}', '\u{44}']), ('\u{1f12e}', &['\u{57}', '\u{5a}']), ('\u{1f130}',
        &['\u{41}']), ('\u{1f131}', &['\u{42}']), ('\u{1f132}', &['\u{43}']), ('\u{1f133}',
        &['\u{44}']), ('\u{1f134}', &['\u{45}']), ('\u{1f135}', &['\u{46}']), ('\u{1f136}',
        &['\u{47}']), ('\u{1f137}', &['\u{48}']), ('\u{1f138}', &['\u{49}']), ('\u{1f139}',
        &['\u{4a}']), ('\u{1f13a}', &['\u{4b}']), ('\u{1f13b}', &['\u{4c}']), ('\u{1f13c}',
        &['\u{4d}']), ('\u{1f13d}', &['\u{4e}']), ('\u{1f13e}', &['\u{4f}']), ('\u{1f13f}',
        &['\u{50}']), ('\u{1f140}', &['\u{51}']), ('\u{1f141}', &['\u{52}']), ('\u{1f142}',
        &['\u{53}']), ('\u{1f143}', &['\u{54}']), ('\u{1f144}', &['\u{55}']), ('\u{1f145}',
        &['\u{56}']), ('\u{1f146}', &['\u{57}']), ('\u{1f147}', &['\u{58}']), ('\u{1f148}',
        &['\u{59}']), ('\u{1f149}', &['\u{5a}']), ('\u{1f14a}', &['\u{48}', '\u{56}']),
        ('\u{1f14b}', &['\u{4d}', '\u{56}']), ('\u{1f14c}', &['\u{53}', '\u{44}']), ('\u{1f14d}',
        &['\u{53}', '\u{53}']), ('\u{1f14e}', &['\u{50}', '\u{50}', '\u{56}']), ('\u{1f14f}',
        &['\u{57}', '\u{43}']), ('\u{1f16a}', &['\u{4d}', '\u{43}']), ('\u{1f16b}', &['\u{4d}',
        '\u{44}']), ('\u{1f190}', &['\u{44}', '\u{4a}']), ('\u{1f200}', &['\u{307b}', '\u{304b}']),
        ('\u{1f201}', &['\u{30b3}', '\u{30b3}']), ('\u{1f202}', &['\u{30b5}']), ('\u{1f210}',
        &['\u{624b}']), ('\u{1f211}', &['\u{5b57}']), ('\u{1f212}', &['\u{53cc}']), ('\u{1f213}',
        &['\u{30c7}']), ('\u{1f214}', &['\u{4e8c}']), ('\u{1f215}', &['\u{591a}']), ('\u{1f216}',
        &['\u{89e3}']), ('\u{1f217}', &['\u{5929}']), ('\u{1f218}', &['\u{4ea4}']), ('\u{1f219}',
        &['\u{6620}']), ('\u{1f21a}', &['\u{7121}']), ('\u{1f21b}', &['\u{6599}']), ('\u{1f21c}',
        &['\u{524d}']), ('\u{1f21d}', &['\u{5f8c}']), ('\u{1f21e}', &['\u{518d}']), ('\u{1f21f}',
        &['\u{65b0}']), ('\u{1f220}', &['\u{521d}']), ('\u{1f221}', &['\u{7d42}']), ('\u{1f222}',
        &['\u{751f}']), ('\u{1f223}', &['\u{8ca9}']), ('\u{1f224}', &['\u{58f0}']), ('\u{1f225}',
        &['\u{5439}']), ('\u{1f226}', &['\u{6f14}']), ('\u{1f227}', &['\u{6295}']), ('\u{1f228}',
        &['\u{6355}']), ('\u{1f229}', &['\u{4e00}']), ('\u{1f22a}', &['\u{4e09}']), ('\u{1f22b}',
        &['\u{904a}']), ('\u{1f22c}', &['\u{5de6}']), ('\u{1f22d}', &['\u{4e2d}']), ('\u{1f22e}',
        &['\u{53f3}']), ('\u{1f22f}', &['\u{6307}']), ('\u{1f230}', &['\u{8d70}']), ('\u{1f231}',
        &['\u{6253}']), ('\u{1f232}', &['\u{7981}']), ('\u{1f233}', &['\u{7a7a}']), ('\u{1f234}',
        &['\u{5408}']), ('\u{1f235}', &['\u{6e80}']), ('\u{1f236}', &['\u{6709}']), ('\u{1f237}',
        &['\u{6708}']), ('\u{1f238}', &['\u{7533}']), ('\u{1f239}', &['\u{5272}']), ('\u{1f23a}',
        &['\u{55b6}']), ('\u{1f240}', &['\u{3014}', '\u{672c}', '\u{3015}']), ('\u{1f241}',
        &['\u{3014}', '\u{4e09}', '\u{3015}']), ('\u{1f242}', &['\u{3014}', '\u{4e8c}',
        '\u{3015}']), ('\u{1f243}', &['\u{3014}', '\u{5b89}', '\u{3015}']), ('\u{1f244}',
        &['\u{3014}', '\u{70b9}', '\u{3015}']), ('\u{1f245}', &['\u{3014}', '\u{6253}',
        '\u{3015}']), ('\u{1f246}', &['\u{3014}', '\u{76d7}', '\u{3015}']), ('\u{1f247}',
        &['\u{3014}', '\u{52dd}', '\u{3015}']), ('\u{1f248}', &['\u{3014}', '\u{6557}',
        '\u{3015}']), ('\u{1f250}', &['\u{5f97}']), ('\u{1f251}', &['\u{53ef}'])
    ];

    // Canonical compositions
    pub const composition_table: &'static [(char, &'static [(char, char)])] = &[
        ('\u{3c}', &[('\u{338}', '\u{226e}')]), ('\u{3d}', &[('\u{338}', '\u{2260}')]), ('\u{3e}',
        &[('\u{338}', '\u{226f}')]), ('\u{41}', &[('\u{300}', '\u{c0}'), ('\u{301}', '\u{c1}'),
        ('\u{302}', '\u{c2}'), ('\u{303}', '\u{c3}'), ('\u{304}', '\u{100}'), ('\u{306}',
        '\u{102}'), ('\u{307}', '\u{226}'), ('\u{308}', '\u{c4}'), ('\u{309}', '\u{1ea2}'),
        ('\u{30a}', '\u{c5}'), ('\u{30c}', '\u{1cd}'), ('\u{30f}', '\u{200}'), ('\u{311}',
        '\u{202}'), ('\u{323}', '\u{1ea0}'), ('\u{325}', '\u{1e00}'), ('\u{328}', '\u{104}')]),
        ('\u{42}', &[('\u{307}', '\u{1e02}'), ('\u{323}', '\u{1e04}'), ('\u{331}', '\u{1e06}')]),
        ('\u{43}', &[('\u{301}', '\u{106}'), ('\u{302}', '\u{108}'), ('\u{307}', '\u{10a}'),
        ('\u{30c}', '\u{10c}'), ('\u{327}', '\u{c7}')]), ('\u{44}', &[('\u{307}', '\u{1e0a}'),
        ('\u{30c}', '\u{10e}'), ('\u{323}', '\u{1e0c}'), ('\u{327}', '\u{1e10}'), ('\u{32d}',
        '\u{1e12}'), ('\u{331}', '\u{1e0e}')]), ('\u{45}', &[('\u{300}', '\u{c8}'), ('\u{301}',
        '\u{c9}'), ('\u{302}', '\u{ca}'), ('\u{303}', '\u{1ebc}'), ('\u{304}', '\u{112}'),
        ('\u{306}', '\u{114}'), ('\u{307}', '\u{116}'), ('\u{308}', '\u{cb}'), ('\u{309}',
        '\u{1eba}'), ('\u{30c}', '\u{11a}'), ('\u{30f}', '\u{204}'), ('\u{311}', '\u{206}'),
        ('\u{323}', '\u{1eb8}'), ('\u{327}', '\u{228}'), ('\u{328}', '\u{118}'), ('\u{32d}',
        '\u{1e18}'), ('\u{330}', '\u{1e1a}')]), ('\u{46}', &[('\u{307}', '\u{1e1e}')]), ('\u{47}',
        &[('\u{301}', '\u{1f4}'), ('\u{302}', '\u{11c}'), ('\u{304}', '\u{1e20}'), ('\u{306}',
        '\u{11e}'), ('\u{307}', '\u{120}'), ('\u{30c}', '\u{1e6}'), ('\u{327}', '\u{122}')]),
        ('\u{48}', &[('\u{302}', '\u{124}'), ('\u{307}', '\u{1e22}'), ('\u{308}', '\u{1e26}'),
        ('\u{30c}', '\u{21e}'), ('\u{323}', '\u{1e24}'), ('\u{327}', '\u{1e28}'), ('\u{32e}',
        '\u{1e2a}')]), ('\u{49}', &[('\u{300}', '\u{cc}'), ('\u{301}', '\u{cd}'), ('\u{302}',
        '\u{ce}'), ('\u{303}', '\u{128}'), ('\u{304}', '\u{12a}'), ('\u{306}', '\u{12c}'),
        ('\u{307}', '\u{130}'), ('\u{308}', '\u{cf}'), ('\u{309}', '\u{1ec8}'), ('\u{30c}',
        '\u{1cf}'), ('\u{30f}', '\u{208}'), ('\u{311}', '\u{20a}'), ('\u{323}', '\u{1eca}'),
        ('\u{328}', '\u{12e}'), ('\u{330}', '\u{1e2c}')]), ('\u{4a}', &[('\u{302}', '\u{134}')]),
        ('\u{4b}', &[('\u{301}', '\u{1e30}'), ('\u{30c}', '\u{1e8}'), ('\u{323}', '\u{1e32}'),
        ('\u{327}', '\u{136}'), ('\u{331}', '\u{1e34}')]), ('\u{4c}', &[('\u{301}', '\u{139}'),
        ('\u{30c}', '\u{13d}'), ('\u{323}', '\u{1e36}'), ('\u{327}', '\u{13b}'), ('\u{32d}',
        '\u{1e3c}'), ('\u{331}', '\u{1e3a}')]), ('\u{4d}', &[('\u{301}', '\u{1e3e}'), ('\u{307}',
        '\u{1e40}'), ('\u{323}', '\u{1e42}')]), ('\u{4e}', &[('\u{300}', '\u{1f8}'), ('\u{301}',
        '\u{143}'), ('\u{303}', '\u{d1}'), ('\u{307}', '\u{1e44}'), ('\u{30c}', '\u{147}'),
        ('\u{323}', '\u{1e46}'), ('\u{327}', '\u{145}'), ('\u{32d}', '\u{1e4a}'), ('\u{331}',
        '\u{1e48}')]), ('\u{4f}', &[('\u{300}', '\u{d2}'), ('\u{301}', '\u{d3}'), ('\u{302}',
        '\u{d4}'), ('\u{303}', '\u{d5}'), ('\u{304}', '\u{14c}'), ('\u{306}', '\u{14e}'),
        ('\u{307}', '\u{22e}'), ('\u{308}', '\u{d6}'), ('\u{309}', '\u{1ece}'), ('\u{30b}',
        '\u{150}'), ('\u{30c}', '\u{1d1}'), ('\u{30f}', '\u{20c}'), ('\u{311}', '\u{20e}'),
        ('\u{31b}', '\u{1a0}'), ('\u{323}', '\u{1ecc}'), ('\u{328}', '\u{1ea}')]), ('\u{50}',
        &[('\u{301}', '\u{1e54}'), ('\u{307}', '\u{1e56}')]), ('\u{52}', &[('\u{301}', '\u{154}'),
        ('\u{307}', '\u{1e58}'), ('\u{30c}', '\u{158}'), ('\u{30f}', '\u{210}'), ('\u{311}',
        '\u{212}'), ('\u{323}', '\u{1e5a}'), ('\u{327}', '\u{156}'), ('\u{331}', '\u{1e5e}')]),
        ('\u{53}', &[('\u{301}', '\u{15a}'), ('\u{302}', '\u{15c}'), ('\u{307}', '\u{1e60}'),
        ('\u{30c}', '\u{160}'), ('\u{323}', '\u{1e62}'), ('\u{326}', '\u{218}'), ('\u{327}',
        '\u{15e}')]), ('\u{54}', &[('\u{307}', '\u{1e6a}'), ('\u{30c}', '\u{164}'), ('\u{323}',
        '\u{1e6c}'), ('\u{326}', '\u{21a}'), ('\u{327}', '\u{162}'), ('\u{32d}', '\u{1e70}'),
        ('\u{331}', '\u{1e6e}')]), ('\u{55}', &[('\u{300}', '\u{d9}'), ('\u{301}', '\u{da}'),
        ('\u{302}', '\u{db}'), ('\u{303}', '\u{168}'), ('\u{304}', '\u{16a}'), ('\u{306}',
        '\u{16c}'), ('\u{308}', '\u{dc}'), ('\u{309}', '\u{1ee6}'), ('\u{30a}', '\u{16e}'),
        ('\u{30b}', '\u{170}'), ('\u{30c}', '\u{1d3}'), ('\u{30f}', '\u{214}'), ('\u{311}',
        '\u{216}'), ('\u{31b}', '\u{1af}'), ('\u{323}', '\u{1ee4}'), ('\u{324}', '\u{1e72}'),
        ('\u{328}', '\u{172}'), ('\u{32d}', '\u{1e76}'), ('\u{330}', '\u{1e74}')]), ('\u{56}',
        &[('\u{303}', '\u{1e7c}'), ('\u{323}', '\u{1e7e}')]), ('\u{57}', &[('\u{300}', '\u{1e80}'),
        ('\u{301}', '\u{1e82}'), ('\u{302}', '\u{174}'), ('\u{307}', '\u{1e86}'), ('\u{308}',
        '\u{1e84}'), ('\u{323}', '\u{1e88}')]), ('\u{58}', &[('\u{307}', '\u{1e8a}'), ('\u{308}',
        '\u{1e8c}')]), ('\u{59}', &[('\u{300}', '\u{1ef2}'), ('\u{301}', '\u{dd}'), ('\u{302}',
        '\u{176}'), ('\u{303}', '\u{1ef8}'), ('\u{304}', '\u{232}'), ('\u{307}', '\u{1e8e}'),
        ('\u{308}', '\u{178}'), ('\u{309}', '\u{1ef6}'), ('\u{323}', '\u{1ef4}')]), ('\u{5a}',
        &[('\u{301}', '\u{179}'), ('\u{302}', '\u{1e90}'), ('\u{307}', '\u{17b}'), ('\u{30c}',
        '\u{17d}'), ('\u{323}', '\u{1e92}'), ('\u{331}', '\u{1e94}')]), ('\u{61}', &[('\u{300}',
        '\u{e0}'), ('\u{301}', '\u{e1}'), ('\u{302}', '\u{e2}'), ('\u{303}', '\u{e3}'), ('\u{304}',
        '\u{101}'), ('\u{306}', '\u{103}'), ('\u{307}', '\u{227}'), ('\u{308}', '\u{e4}'),
        ('\u{309}', '\u{1ea3}'), ('\u{30a}', '\u{e5}'), ('\u{30c}', '\u{1ce}'), ('\u{30f}',
        '\u{201}'), ('\u{311}', '\u{203}'), ('\u{323}', '\u{1ea1}'), ('\u{325}', '\u{1e01}'),
        ('\u{328}', '\u{105}')]), ('\u{62}', &[('\u{307}', '\u{1e03}'), ('\u{323}', '\u{1e05}'),
        ('\u{331}', '\u{1e07}')]), ('\u{63}', &[('\u{301}', '\u{107}'), ('\u{302}', '\u{109}'),
        ('\u{307}', '\u{10b}'), ('\u{30c}', '\u{10d}'), ('\u{327}', '\u{e7}')]), ('\u{64}',
        &[('\u{307}', '\u{1e0b}'), ('\u{30c}', '\u{10f}'), ('\u{323}', '\u{1e0d}'), ('\u{327}',
        '\u{1e11}'), ('\u{32d}', '\u{1e13}'), ('\u{331}', '\u{1e0f}')]), ('\u{65}', &[('\u{300}',
        '\u{e8}'), ('\u{301}', '\u{e9}'), ('\u{302}', '\u{ea}'), ('\u{303}', '\u{1ebd}'),
        ('\u{304}', '\u{113}'), ('\u{306}', '\u{115}'), ('\u{307}', '\u{117}'), ('\u{308}',
        '\u{eb}'), ('\u{309}', '\u{1ebb}'), ('\u{30c}', '\u{11b}'), ('\u{30f}', '\u{205}'),
        ('\u{311}', '\u{207}'), ('\u{323}', '\u{1eb9}'), ('\u{327}', '\u{229}'), ('\u{328}',
        '\u{119}'), ('\u{32d}', '\u{1e19}'), ('\u{330}', '\u{1e1b}')]), ('\u{66}', &[('\u{307}',
        '\u{1e1f}')]), ('\u{67}', &[('\u{301}', '\u{1f5}'), ('\u{302}', '\u{11d}'), ('\u{304}',
        '\u{1e21}'), ('\u{306}', '\u{11f}'), ('\u{307}', '\u{121}'), ('\u{30c}', '\u{1e7}'),
        ('\u{327}', '\u{123}')]), ('\u{68}', &[('\u{302}', '\u{125}'), ('\u{307}', '\u{1e23}'),
        ('\u{308}', '\u{1e27}'), ('\u{30c}', '\u{21f}'), ('\u{323}', '\u{1e25}'), ('\u{327}',
        '\u{1e29}'), ('\u{32e}', '\u{1e2b}'), ('\u{331}', '\u{1e96}')]), ('\u{69}', &[('\u{300}',
        '\u{ec}'), ('\u{301}', '\u{ed}'), ('\u{302}', '\u{ee}'), ('\u{303}', '\u{129}'), ('\u{304}',
        '\u{12b}'), ('\u{306}', '\u{12d}'), ('\u{308}', '\u{ef}'), ('\u{309}', '\u{1ec9}'),
        ('\u{30c}', '\u{1d0}'), ('\u{30f}', '\u{209}'), ('\u{311}', '\u{20b}'), ('\u{323}',
        '\u{1ecb}'), ('\u{328}', '\u{12f}'), ('\u{330}', '\u{1e2d}')]), ('\u{6a}', &[('\u{302}',
        '\u{135}'), ('\u{30c}', '\u{1f0}')]), ('\u{6b}', &[('\u{301}', '\u{1e31}'), ('\u{30c}',
        '\u{1e9}'), ('\u{323}', '\u{1e33}'), ('\u{327}', '\u{137}'), ('\u{331}', '\u{1e35}')]),
        ('\u{6c}', &[('\u{301}', '\u{13a}'), ('\u{30c}', '\u{13e}'), ('\u{323}', '\u{1e37}'),
        ('\u{327}', '\u{13c}'), ('\u{32d}', '\u{1e3d}'), ('\u{331}', '\u{1e3b}')]), ('\u{6d}',
        &[('\u{301}', '\u{1e3f}'), ('\u{307}', '\u{1e41}'), ('\u{323}', '\u{1e43}')]), ('\u{6e}',
        &[('\u{300}', '\u{1f9}'), ('\u{301}', '\u{144}'), ('\u{303}', '\u{f1}'), ('\u{307}',
        '\u{1e45}'), ('\u{30c}', '\u{148}'), ('\u{323}', '\u{1e47}'), ('\u{327}', '\u{146}'),
        ('\u{32d}', '\u{1e4b}'), ('\u{331}', '\u{1e49}')]), ('\u{6f}', &[('\u{300}', '\u{f2}'),
        ('\u{301}', '\u{f3}'), ('\u{302}', '\u{f4}'), ('\u{303}', '\u{f5}'), ('\u{304}', '\u{14d}'),
        ('\u{306}', '\u{14f}'), ('\u{307}', '\u{22f}'), ('\u{308}', '\u{f6}'), ('\u{309}',
        '\u{1ecf}'), ('\u{30b}', '\u{151}'), ('\u{30c}', '\u{1d2}'), ('\u{30f}', '\u{20d}'),
        ('\u{311}', '\u{20f}'), ('\u{31b}', '\u{1a1}'), ('\u{323}', '\u{1ecd}'), ('\u{328}',
        '\u{1eb}')]), ('\u{70}', &[('\u{301}', '\u{1e55}'), ('\u{307}', '\u{1e57}')]), ('\u{72}',
        &[('\u{301}', '\u{155}'), ('\u{307}', '\u{1e59}'), ('\u{30c}', '\u{159}'), ('\u{30f}',
        '\u{211}'), ('\u{311}', '\u{213}'), ('\u{323}', '\u{1e5b}'), ('\u{327}', '\u{157}'),
        ('\u{331}', '\u{1e5f}')]), ('\u{73}', &[('\u{301}', '\u{15b}'), ('\u{302}', '\u{15d}'),
        ('\u{307}', '\u{1e61}'), ('\u{30c}', '\u{161}'), ('\u{323}', '\u{1e63}'), ('\u{326}',
        '\u{219}'), ('\u{327}', '\u{15f}')]), ('\u{74}', &[('\u{307}', '\u{1e6b}'), ('\u{308}',
        '\u{1e97}'), ('\u{30c}', '\u{165}'), ('\u{323}', '\u{1e6d}'), ('\u{326}', '\u{21b}'),
        ('\u{327}', '\u{163}'), ('\u{32d}', '\u{1e71}'), ('\u{331}', '\u{1e6f}')]), ('\u{75}',
        &[('\u{300}', '\u{f9}'), ('\u{301}', '\u{fa}'), ('\u{302}', '\u{fb}'), ('\u{303}',
        '\u{169}'), ('\u{304}', '\u{16b}'), ('\u{306}', '\u{16d}'), ('\u{308}', '\u{fc}'),
        ('\u{309}', '\u{1ee7}'), ('\u{30a}', '\u{16f}'), ('\u{30b}', '\u{171}'), ('\u{30c}',
        '\u{1d4}'), ('\u{30f}', '\u{215}'), ('\u{311}', '\u{217}'), ('\u{31b}', '\u{1b0}'),
        ('\u{323}', '\u{1ee5}'), ('\u{324}', '\u{1e73}'), ('\u{328}', '\u{173}'), ('\u{32d}',
        '\u{1e77}'), ('\u{330}', '\u{1e75}')]), ('\u{76}', &[('\u{303}', '\u{1e7d}'), ('\u{323}',
        '\u{1e7f}')]), ('\u{77}', &[('\u{300}', '\u{1e81}'), ('\u{301}', '\u{1e83}'), ('\u{302}',
        '\u{175}'), ('\u{307}', '\u{1e87}'), ('\u{308}', '\u{1e85}'), ('\u{30a}', '\u{1e98}'),
        ('\u{323}', '\u{1e89}')]), ('\u{78}', &[('\u{307}', '\u{1e8b}'), ('\u{308}', '\u{1e8d}')]),
        ('\u{79}', &[('\u{300}', '\u{1ef3}'), ('\u{301}', '\u{fd}'), ('\u{302}', '\u{177}'),
        ('\u{303}', '\u{1ef9}'), ('\u{304}', '\u{233}'), ('\u{307}', '\u{1e8f}'), ('\u{308}',
        '\u{ff}'), ('\u{309}', '\u{1ef7}'), ('\u{30a}', '\u{1e99}'), ('\u{323}', '\u{1ef5}')]),
        ('\u{7a}', &[('\u{301}', '\u{17a}'), ('\u{302}', '\u{1e91}'), ('\u{307}', '\u{17c}'),
        ('\u{30c}', '\u{17e}'), ('\u{323}', '\u{1e93}'), ('\u{331}', '\u{1e95}')]), ('\u{a8}',
        &[('\u{300}', '\u{1fed}'), ('\u{301}', '\u{385}'), ('\u{342}', '\u{1fc1}')]), ('\u{c2}',
        &[('\u{300}', '\u{1ea6}'), ('\u{301}', '\u{1ea4}'), ('\u{303}', '\u{1eaa}'), ('\u{309}',
        '\u{1ea8}')]), ('\u{c4}', &[('\u{304}', '\u{1de}')]), ('\u{c5}', &[('\u{301}', '\u{1fa}')]),
        ('\u{c6}', &[('\u{301}', '\u{1fc}'), ('\u{304}', '\u{1e2}')]), ('\u{c7}', &[('\u{301}',
        '\u{1e08}')]), ('\u{ca}', &[('\u{300}', '\u{1ec0}'), ('\u{301}', '\u{1ebe}'), ('\u{303}',
        '\u{1ec4}'), ('\u{309}', '\u{1ec2}')]), ('\u{cf}', &[('\u{301}', '\u{1e2e}')]), ('\u{d4}',
        &[('\u{300}', '\u{1ed2}'), ('\u{301}', '\u{1ed0}'), ('\u{303}', '\u{1ed6}'), ('\u{309}',
        '\u{1ed4}')]), ('\u{d5}', &[('\u{301}', '\u{1e4c}'), ('\u{304}', '\u{22c}'), ('\u{308}',
        '\u{1e4e}')]), ('\u{d6}', &[('\u{304}', '\u{22a}')]), ('\u{d8}', &[('\u{301}', '\u{1fe}')]),
        ('\u{dc}', &[('\u{300}', '\u{1db}'), ('\u{301}', '\u{1d7}'), ('\u{304}', '\u{1d5}'),
        ('\u{30c}', '\u{1d9}')]), ('\u{e2}', &[('\u{300}', '\u{1ea7}'), ('\u{301}', '\u{1ea5}'),
        ('\u{303}', '\u{1eab}'), ('\u{309}', '\u{1ea9}')]), ('\u{e4}', &[('\u{304}', '\u{1df}')]),
        ('\u{e5}', &[('\u{301}', '\u{1fb}')]), ('\u{e6}', &[('\u{301}', '\u{1fd}'), ('\u{304}',
        '\u{1e3}')]), ('\u{e7}', &[('\u{301}', '\u{1e09}')]), ('\u{ea}', &[('\u{300}', '\u{1ec1}'),
        ('\u{301}', '\u{1ebf}'), ('\u{303}', '\u{1ec5}'), ('\u{309}', '\u{1ec3}')]), ('\u{ef}',
        &[('\u{301}', '\u{1e2f}')]), ('\u{f4}', &[('\u{300}', '\u{1ed3}'), ('\u{301}', '\u{1ed1}'),
        ('\u{303}', '\u{1ed7}'), ('\u{309}', '\u{1ed5}')]), ('\u{f5}', &[('\u{301}', '\u{1e4d}'),
        ('\u{304}', '\u{22d}'), ('\u{308}', '\u{1e4f}')]), ('\u{f6}', &[('\u{304}', '\u{22b}')]),
        ('\u{f8}', &[('\u{301}', '\u{1ff}')]), ('\u{fc}', &[('\u{300}', '\u{1dc}'), ('\u{301}',
        '\u{1d8}'), ('\u{304}', '\u{1d6}'), ('\u{30c}', '\u{1da}')]), ('\u{102}', &[('\u{300}',
        '\u{1eb0}'), ('\u{301}', '\u{1eae}'), ('\u{303}', '\u{1eb4}'), ('\u{309}', '\u{1eb2}')]),
        ('\u{103}', &[('\u{300}', '\u{1eb1}'), ('\u{301}', '\u{1eaf}'), ('\u{303}', '\u{1eb5}'),
        ('\u{309}', '\u{1eb3}')]), ('\u{112}', &[('\u{300}', '\u{1e14}'), ('\u{301}', '\u{1e16}')]),
        ('\u{113}', &[('\u{300}', '\u{1e15}'), ('\u{301}', '\u{1e17}')]), ('\u{14c}', &[('\u{300}',
        '\u{1e50}'), ('\u{301}', '\u{1e52}')]), ('\u{14d}', &[('\u{300}', '\u{1e51}'), ('\u{301}',
        '\u{1e53}')]), ('\u{15a}', &[('\u{307}', '\u{1e64}')]), ('\u{15b}', &[('\u{307}',
        '\u{1e65}')]), ('\u{160}', &[('\u{307}', '\u{1e66}')]), ('\u{161}', &[('\u{307}',
        '\u{1e67}')]), ('\u{168}', &[('\u{301}', '\u{1e78}')]), ('\u{169}', &[('\u{301}',
        '\u{1e79}')]), ('\u{16a}', &[('\u{308}', '\u{1e7a}')]), ('\u{16b}', &[('\u{308}',
        '\u{1e7b}')]), ('\u{17f}', &[('\u{307}', '\u{1e9b}')]), ('\u{1a0}', &[('\u{300}',
        '\u{1edc}'), ('\u{301}', '\u{1eda}'), ('\u{303}', '\u{1ee0}'), ('\u{309}', '\u{1ede}'),
        ('\u{323}', '\u{1ee2}')]), ('\u{1a1}', &[('\u{300}', '\u{1edd}'), ('\u{301}', '\u{1edb}'),
        ('\u{303}', '\u{1ee1}'), ('\u{309}', '\u{1edf}'), ('\u{323}', '\u{1ee3}')]), ('\u{1af}',
        &[('\u{300}', '\u{1eea}'), ('\u{301}', '\u{1ee8}'), ('\u{303}', '\u{1eee}'), ('\u{309}',
        '\u{1eec}'), ('\u{323}', '\u{1ef0}')]), ('\u{1b0}', &[('\u{300}', '\u{1eeb}'), ('\u{301}',
        '\u{1ee9}'), ('\u{303}', '\u{1eef}'), ('\u{309}', '\u{1eed}'), ('\u{323}', '\u{1ef1}')]),
        ('\u{1b7}', &[('\u{30c}', '\u{1ee}')]), ('\u{1ea}', &[('\u{304}', '\u{1ec}')]), ('\u{1eb}',
        &[('\u{304}', '\u{1ed}')]), ('\u{226}', &[('\u{304}', '\u{1e0}')]), ('\u{227}',
        &[('\u{304}', '\u{1e1}')]), ('\u{228}', &[('\u{306}', '\u{1e1c}')]), ('\u{229}',
        &[('\u{306}', '\u{1e1d}')]), ('\u{22e}', &[('\u{304}', '\u{230}')]), ('\u{22f}',
        &[('\u{304}', '\u{231}')]), ('\u{292}', &[('\u{30c}', '\u{1ef}')]), ('\u{391}',
        &[('\u{300}', '\u{1fba}'), ('\u{301}', '\u{386}'), ('\u{304}', '\u{1fb9}'), ('\u{306}',
        '\u{1fb8}'), ('\u{313}', '\u{1f08}'), ('\u{314}', '\u{1f09}'), ('\u{345}', '\u{1fbc}')]),
        ('\u{395}', &[('\u{300}', '\u{1fc8}'), ('\u{301}', '\u{388}'), ('\u{313}', '\u{1f18}'),
        ('\u{314}', '\u{1f19}')]), ('\u{397}', &[('\u{300}', '\u{1fca}'), ('\u{301}', '\u{389}'),
        ('\u{313}', '\u{1f28}'), ('\u{314}', '\u{1f29}'), ('\u{345}', '\u{1fcc}')]), ('\u{399}',
        &[('\u{300}', '\u{1fda}'), ('\u{301}', '\u{38a}'), ('\u{304}', '\u{1fd9}'), ('\u{306}',
        '\u{1fd8}'), ('\u{308}', '\u{3aa}'), ('\u{313}', '\u{1f38}'), ('\u{314}', '\u{1f39}')]),
        ('\u{39f}', &[('\u{300}', '\u{1ff8}'), ('\u{301}', '\u{38c}'), ('\u{313}', '\u{1f48}'),
        ('\u{314}', '\u{1f49}')]), ('\u{3a1}', &[('\u{314}', '\u{1fec}')]), ('\u{3a5}',
        &[('\u{300}', '\u{1fea}'), ('\u{301}', '\u{38e}'), ('\u{304}', '\u{1fe9}'), ('\u{306}',
        '\u{1fe8}'), ('\u{308}', '\u{3ab}'), ('\u{314}', '\u{1f59}')]), ('\u{3a9}', &[('\u{300}',
        '\u{1ffa}'), ('\u{301}', '\u{38f}'), ('\u{313}', '\u{1f68}'), ('\u{314}', '\u{1f69}'),
        ('\u{345}', '\u{1ffc}')]), ('\u{3ac}', &[('\u{345}', '\u{1fb4}')]), ('\u{3ae}',
        &[('\u{345}', '\u{1fc4}')]), ('\u{3b1}', &[('\u{300}', '\u{1f70}'), ('\u{301}', '\u{3ac}'),
        ('\u{304}', '\u{1fb1}'), ('\u{306}', '\u{1fb0}'), ('\u{313}', '\u{1f00}'), ('\u{314}',
        '\u{1f01}'), ('\u{342}', '\u{1fb6}'), ('\u{345}', '\u{1fb3}')]), ('\u{3b5}', &[('\u{300}',
        '\u{1f72}'), ('\u{301}', '\u{3ad}'), ('\u{313}', '\u{1f10}'), ('\u{314}', '\u{1f11}')]),
        ('\u{3b7}', &[('\u{300}', '\u{1f74}'), ('\u{301}', '\u{3ae}'), ('\u{313}', '\u{1f20}'),
        ('\u{314}', '\u{1f21}'), ('\u{342}', '\u{1fc6}'), ('\u{345}', '\u{1fc3}')]), ('\u{3b9}',
        &[('\u{300}', '\u{1f76}'), ('\u{301}', '\u{3af}'), ('\u{304}', '\u{1fd1}'), ('\u{306}',
        '\u{1fd0}'), ('\u{308}', '\u{3ca}'), ('\u{313}', '\u{1f30}'), ('\u{314}', '\u{1f31}'),
        ('\u{342}', '\u{1fd6}')]), ('\u{3bf}', &[('\u{300}', '\u{1f78}'), ('\u{301}', '\u{3cc}'),
        ('\u{313}', '\u{1f40}'), ('\u{314}', '\u{1f41}')]), ('\u{3c1}', &[('\u{313}', '\u{1fe4}'),
        ('\u{314}', '\u{1fe5}')]), ('\u{3c5}', &[('\u{300}', '\u{1f7a}'), ('\u{301}', '\u{3cd}'),
        ('\u{304}', '\u{1fe1}'), ('\u{306}', '\u{1fe0}'), ('\u{308}', '\u{3cb}'), ('\u{313}',
        '\u{1f50}'), ('\u{314}', '\u{1f51}'), ('\u{342}', '\u{1fe6}')]), ('\u{3c9}', &[('\u{300}',
        '\u{1f7c}'), ('\u{301}', '\u{3ce}'), ('\u{313}', '\u{1f60}'), ('\u{314}', '\u{1f61}'),
        ('\u{342}', '\u{1ff6}'), ('\u{345}', '\u{1ff3}')]), ('\u{3ca}', &[('\u{300}', '\u{1fd2}'),
        ('\u{301}', '\u{390}'), ('\u{342}', '\u{1fd7}')]), ('\u{3cb}', &[('\u{300}', '\u{1fe2}'),
        ('\u{301}', '\u{3b0}'), ('\u{342}', '\u{1fe7}')]), ('\u{3ce}', &[('\u{345}', '\u{1ff4}')]),
        ('\u{3d2}', &[('\u{301}', '\u{3d3}'), ('\u{308}', '\u{3d4}')]), ('\u{406}', &[('\u{308}',
        '\u{407}')]), ('\u{410}', &[('\u{306}', '\u{4d0}'), ('\u{308}', '\u{4d2}')]), ('\u{413}',
        &[('\u{301}', '\u{403}')]), ('\u{415}', &[('\u{300}', '\u{400}'), ('\u{306}', '\u{4d6}'),
        ('\u{308}', '\u{401}')]), ('\u{416}', &[('\u{306}', '\u{4c1}'), ('\u{308}', '\u{4dc}')]),
        ('\u{417}', &[('\u{308}', '\u{4de}')]), ('\u{418}', &[('\u{300}', '\u{40d}'), ('\u{304}',
        '\u{4e2}'), ('\u{306}', '\u{419}'), ('\u{308}', '\u{4e4}')]), ('\u{41a}', &[('\u{301}',
        '\u{40c}')]), ('\u{41e}', &[('\u{308}', '\u{4e6}')]), ('\u{423}', &[('\u{304}', '\u{4ee}'),
        ('\u{306}', '\u{40e}'), ('\u{308}', '\u{4f0}'), ('\u{30b}', '\u{4f2}')]), ('\u{427}',
        &[('\u{308}', '\u{4f4}')]), ('\u{42b}', &[('\u{308}', '\u{4f8}')]), ('\u{42d}',
        &[('\u{308}', '\u{4ec}')]), ('\u{430}', &[('\u{306}', '\u{4d1}'), ('\u{308}', '\u{4d3}')]),
        ('\u{433}', &[('\u{301}', '\u{453}')]), ('\u{435}', &[('\u{300}', '\u{450}'), ('\u{306}',
        '\u{4d7}'), ('\u{308}', '\u{451}')]), ('\u{436}', &[('\u{306}', '\u{4c2}'), ('\u{308}',
        '\u{4dd}')]), ('\u{437}', &[('\u{308}', '\u{4df}')]), ('\u{438}', &[('\u{300}', '\u{45d}'),
        ('\u{304}', '\u{4e3}'), ('\u{306}', '\u{439}'), ('\u{308}', '\u{4e5}')]), ('\u{43a}',
        &[('\u{301}', '\u{45c}')]), ('\u{43e}', &[('\u{308}', '\u{4e7}')]), ('\u{443}',
        &[('\u{304}', '\u{4ef}'), ('\u{306}', '\u{45e}'), ('\u{308}', '\u{4f1}'), ('\u{30b}',
        '\u{4f3}')]), ('\u{447}', &[('\u{308}', '\u{4f5}')]), ('\u{44b}', &[('\u{308}',
        '\u{4f9}')]), ('\u{44d}', &[('\u{308}', '\u{4ed}')]), ('\u{456}', &[('\u{308}',
        '\u{457}')]), ('\u{474}', &[('\u{30f}', '\u{476}')]), ('\u{475}', &[('\u{30f}',
        '\u{477}')]), ('\u{4d8}', &[('\u{308}', '\u{4da}')]), ('\u{4d9}', &[('\u{308}',
        '\u{4db}')]), ('\u{4e8}', &[('\u{308}', '\u{4ea}')]), ('\u{4e9}', &[('\u{308}',
        '\u{4eb}')]), ('\u{627}', &[('\u{653}', '\u{622}'), ('\u{654}', '\u{623}'), ('\u{655}',
        '\u{625}')]), ('\u{648}', &[('\u{654}', '\u{624}')]), ('\u{64a}', &[('\u{654}',
        '\u{626}')]), ('\u{6c1}', &[('\u{654}', '\u{6c2}')]), ('\u{6d2}', &[('\u{654}',
        '\u{6d3}')]), ('\u{6d5}', &[('\u{654}', '\u{6c0}')]), ('\u{928}', &[('\u{93c}',
        '\u{929}')]), ('\u{930}', &[('\u{93c}', '\u{931}')]), ('\u{933}', &[('\u{93c}',
        '\u{934}')]), ('\u{9c7}', &[('\u{9be}', '\u{9cb}'), ('\u{9d7}', '\u{9cc}')]), ('\u{b47}',
        &[('\u{b3e}', '\u{b4b}'), ('\u{b56}', '\u{b48}'), ('\u{b57}', '\u{b4c}')]), ('\u{b92}',
        &[('\u{bd7}', '\u{b94}')]), ('\u{bc6}', &[('\u{bbe}', '\u{bca}'), ('\u{bd7}', '\u{bcc}')]),
        ('\u{bc7}', &[('\u{bbe}', '\u{bcb}')]), ('\u{c46}', &[('\u{c56}', '\u{c48}')]), ('\u{cbf}',
        &[('\u{cd5}', '\u{cc0}')]), ('\u{cc6}', &[('\u{cc2}', '\u{cca}'), ('\u{cd5}', '\u{cc7}'),
        ('\u{cd6}', '\u{cc8}')]), ('\u{cca}', &[('\u{cd5}', '\u{ccb}')]), ('\u{d46}', &[('\u{d3e}',
        '\u{d4a}'), ('\u{d57}', '\u{d4c}')]), ('\u{d47}', &[('\u{d3e}', '\u{d4b}')]), ('\u{dd9}',
        &[('\u{dca}', '\u{dda}'), ('\u{dcf}', '\u{ddc}'), ('\u{ddf}', '\u{dde}')]), ('\u{ddc}',
        &[('\u{dca}', '\u{ddd}')]), ('\u{1025}', &[('\u{102e}', '\u{1026}')]), ('\u{1b05}',
        &[('\u{1b35}', '\u{1b06}')]), ('\u{1b07}', &[('\u{1b35}', '\u{1b08}')]), ('\u{1b09}',
        &[('\u{1b35}', '\u{1b0a}')]), ('\u{1b0b}', &[('\u{1b35}', '\u{1b0c}')]), ('\u{1b0d}',
        &[('\u{1b35}', '\u{1b0e}')]), ('\u{1b11}', &[('\u{1b35}', '\u{1b12}')]), ('\u{1b3a}',
        &[('\u{1b35}', '\u{1b3b}')]), ('\u{1b3c}', &[('\u{1b35}', '\u{1b3d}')]), ('\u{1b3e}',
        &[('\u{1b35}', '\u{1b40}')]), ('\u{1b3f}', &[('\u{1b35}', '\u{1b41}')]), ('\u{1b42}',
        &[('\u{1b35}', '\u{1b43}')]), ('\u{1e36}', &[('\u{304}', '\u{1e38}')]), ('\u{1e37}',
        &[('\u{304}', '\u{1e39}')]), ('\u{1e5a}', &[('\u{304}', '\u{1e5c}')]), ('\u{1e5b}',
        &[('\u{304}', '\u{1e5d}')]), ('\u{1e62}', &[('\u{307}', '\u{1e68}')]), ('\u{1e63}',
        &[('\u{307}', '\u{1e69}')]), ('\u{1ea0}', &[('\u{302}', '\u{1eac}'), ('\u{306}',
        '\u{1eb6}')]), ('\u{1ea1}', &[('\u{302}', '\u{1ead}'), ('\u{306}', '\u{1eb7}')]),
        ('\u{1eb8}', &[('\u{302}', '\u{1ec6}')]), ('\u{1eb9}', &[('\u{302}', '\u{1ec7}')]),
        ('\u{1ecc}', &[('\u{302}', '\u{1ed8}')]), ('\u{1ecd}', &[('\u{302}', '\u{1ed9}')]),
        ('\u{1f00}', &[('\u{300}', '\u{1f02}'), ('\u{301}', '\u{1f04}'), ('\u{342}', '\u{1f06}'),
        ('\u{345}', '\u{1f80}')]), ('\u{1f01}', &[('\u{300}', '\u{1f03}'), ('\u{301}', '\u{1f05}'),
        ('\u{342}', '\u{1f07}'), ('\u{345}', '\u{1f81}')]), ('\u{1f02}', &[('\u{345}',
        '\u{1f82}')]), ('\u{1f03}', &[('\u{345}', '\u{1f83}')]), ('\u{1f04}', &[('\u{345}',
        '\u{1f84}')]), ('\u{1f05}', &[('\u{345}', '\u{1f85}')]), ('\u{1f06}', &[('\u{345}',
        '\u{1f86}')]), ('\u{1f07}', &[('\u{345}', '\u{1f87}')]), ('\u{1f08}', &[('\u{300}',
        '\u{1f0a}'), ('\u{301}', '\u{1f0c}'), ('\u{342}', '\u{1f0e}'), ('\u{345}', '\u{1f88}')]),
        ('\u{1f09}', &[('\u{300}', '\u{1f0b}'), ('\u{301}', '\u{1f0d}'), ('\u{342}', '\u{1f0f}'),
        ('\u{345}', '\u{1f89}')]), ('\u{1f0a}', &[('\u{345}', '\u{1f8a}')]), ('\u{1f0b}',
        &[('\u{345}', '\u{1f8b}')]), ('\u{1f0c}', &[('\u{345}', '\u{1f8c}')]), ('\u{1f0d}',
        &[('\u{345}', '\u{1f8d}')]), ('\u{1f0e}', &[('\u{345}', '\u{1f8e}')]), ('\u{1f0f}',
        &[('\u{345}', '\u{1f8f}')]), ('\u{1f10}', &[('\u{300}', '\u{1f12}'), ('\u{301}',
        '\u{1f14}')]), ('\u{1f11}', &[('\u{300}', '\u{1f13}'), ('\u{301}', '\u{1f15}')]),
        ('\u{1f18}', &[('\u{300}', '\u{1f1a}'), ('\u{301}', '\u{1f1c}')]), ('\u{1f19}',
        &[('\u{300}', '\u{1f1b}'), ('\u{301}', '\u{1f1d}')]), ('\u{1f20}', &[('\u{300}',
        '\u{1f22}'), ('\u{301}', '\u{1f24}'), ('\u{342}', '\u{1f26}'), ('\u{345}', '\u{1f90}')]),
        ('\u{1f21}', &[('\u{300}', '\u{1f23}'), ('\u{301}', '\u{1f25}'), ('\u{342}', '\u{1f27}'),
        ('\u{345}', '\u{1f91}')]), ('\u{1f22}', &[('\u{345}', '\u{1f92}')]), ('\u{1f23}',
        &[('\u{345}', '\u{1f93}')]), ('\u{1f24}', &[('\u{345}', '\u{1f94}')]), ('\u{1f25}',
        &[('\u{345}', '\u{1f95}')]), ('\u{1f26}', &[('\u{345}', '\u{1f96}')]), ('\u{1f27}',
        &[('\u{345}', '\u{1f97}')]), ('\u{1f28}', &[('\u{300}', '\u{1f2a}'), ('\u{301}',
        '\u{1f2c}'), ('\u{342}', '\u{1f2e}'), ('\u{345}', '\u{1f98}')]), ('\u{1f29}', &[('\u{300}',
        '\u{1f2b}'), ('\u{301}', '\u{1f2d}'), ('\u{342}', '\u{1f2f}'), ('\u{345}', '\u{1f99}')]),
        ('\u{1f2a}', &[('\u{345}', '\u{1f9a}')]), ('\u{1f2b}', &[('\u{345}', '\u{1f9b}')]),
        ('\u{1f2c}', &[('\u{345}', '\u{1f9c}')]), ('\u{1f2d}', &[('\u{345}', '\u{1f9d}')]),
        ('\u{1f2e}', &[('\u{345}', '\u{1f9e}')]), ('\u{1f2f}', &[('\u{345}', '\u{1f9f}')]),
        ('\u{1f30}', &[('\u{300}', '\u{1f32}'), ('\u{301}', '\u{1f34}'), ('\u{342}', '\u{1f36}')]),
        ('\u{1f31}', &[('\u{300}', '\u{1f33}'), ('\u{301}', '\u{1f35}'), ('\u{342}', '\u{1f37}')]),
        ('\u{1f38}', &[('\u{300}', '\u{1f3a}'), ('\u{301}', '\u{1f3c}'), ('\u{342}', '\u{1f3e}')]),
        ('\u{1f39}', &[('\u{300}', '\u{1f3b}'), ('\u{301}', '\u{1f3d}'), ('\u{342}', '\u{1f3f}')]),
        ('\u{1f40}', &[('\u{300}', '\u{1f42}'), ('\u{301}', '\u{1f44}')]), ('\u{1f41}',
        &[('\u{300}', '\u{1f43}'), ('\u{301}', '\u{1f45}')]), ('\u{1f48}', &[('\u{300}',
        '\u{1f4a}'), ('\u{301}', '\u{1f4c}')]), ('\u{1f49}', &[('\u{300}', '\u{1f4b}'), ('\u{301}',
        '\u{1f4d}')]), ('\u{1f50}', &[('\u{300}', '\u{1f52}'), ('\u{301}', '\u{1f54}'), ('\u{342}',
        '\u{1f56}')]), ('\u{1f51}', &[('\u{300}', '\u{1f53}'), ('\u{301}', '\u{1f55}'), ('\u{342}',
        '\u{1f57}')]), ('\u{1f59}', &[('\u{300}', '\u{1f5b}'), ('\u{301}', '\u{1f5d}'), ('\u{342}',
        '\u{1f5f}')]), ('\u{1f60}', &[('\u{300}', '\u{1f62}'), ('\u{301}', '\u{1f64}'), ('\u{342}',
        '\u{1f66}'), ('\u{345}', '\u{1fa0}')]), ('\u{1f61}', &[('\u{300}', '\u{1f63}'), ('\u{301}',
        '\u{1f65}'), ('\u{342}', '\u{1f67}'), ('\u{345}', '\u{1fa1}')]), ('\u{1f62}', &[('\u{345}',
        '\u{1fa2}')]), ('\u{1f63}', &[('\u{345}', '\u{1fa3}')]), ('\u{1f64}', &[('\u{345}',
        '\u{1fa4}')]), ('\u{1f65}', &[('\u{345}', '\u{1fa5}')]), ('\u{1f66}', &[('\u{345}',
        '\u{1fa6}')]), ('\u{1f67}', &[('\u{345}', '\u{1fa7}')]), ('\u{1f68}', &[('\u{300}',
        '\u{1f6a}'), ('\u{301}', '\u{1f6c}'), ('\u{342}', '\u{1f6e}'), ('\u{345}', '\u{1fa8}')]),
        ('\u{1f69}', &[('\u{300}', '\u{1f6b}'), ('\u{301}', '\u{1f6d}'), ('\u{342}', '\u{1f6f}'),
        ('\u{345}', '\u{1fa9}')]), ('\u{1f6a}', &[('\u{345}', '\u{1faa}')]), ('\u{1f6b}',
        &[('\u{345}', '\u{1fab}')]), ('\u{1f6c}', &[('\u{345}', '\u{1fac}')]), ('\u{1f6d}',
        &[('\u{345}', '\u{1fad}')]), ('\u{1f6e}', &[('\u{345}', '\u{1fae}')]), ('\u{1f6f}',
        &[('\u{345}', '\u{1faf}')]), ('\u{1f70}', &[('\u{345}', '\u{1fb2}')]), ('\u{1f74}',
        &[('\u{345}', '\u{1fc2}')]), ('\u{1f7c}', &[('\u{345}', '\u{1ff2}')]), ('\u{1fb6}',
        &[('\u{345}', '\u{1fb7}')]), ('\u{1fbf}', &[('\u{300}', '\u{1fcd}'), ('\u{301}',
        '\u{1fce}'), ('\u{342}', '\u{1fcf}')]), ('\u{1fc6}', &[('\u{345}', '\u{1fc7}')]),
        ('\u{1ff6}', &[('\u{345}', '\u{1ff7}')]), ('\u{1ffe}', &[('\u{300}', '\u{1fdd}'),
        ('\u{301}', '\u{1fde}'), ('\u{342}', '\u{1fdf}')]), ('\u{2190}', &[('\u{338}',
        '\u{219a}')]), ('\u{2192}', &[('\u{338}', '\u{219b}')]), ('\u{2194}', &[('\u{338}',
        '\u{21ae}')]), ('\u{21d0}', &[('\u{338}', '\u{21cd}')]), ('\u{21d2}', &[('\u{338}',
        '\u{21cf}')]), ('\u{21d4}', &[('\u{338}', '\u{21ce}')]), ('\u{2203}', &[('\u{338}',
        '\u{2204}')]), ('\u{2208}', &[('\u{338}', '\u{2209}')]), ('\u{220b}', &[('\u{338}',
        '\u{220c}')]), ('\u{2223}', &[('\u{338}', '\u{2224}')]), ('\u{2225}', &[('\u{338}',
        '\u{2226}')]), ('\u{223c}', &[('\u{338}', '\u{2241}')]), ('\u{2243}', &[('\u{338}',
        '\u{2244}')]), ('\u{2245}', &[('\u{338}', '\u{2247}')]), ('\u{2248}', &[('\u{338}',
        '\u{2249}')]), ('\u{224d}', &[('\u{338}', '\u{226d}')]), ('\u{2261}', &[('\u{338}',
        '\u{2262}')]), ('\u{2264}', &[('\u{338}', '\u{2270}')]), ('\u{2265}', &[('\u{338}',
        '\u{2271}')]), ('\u{2272}', &[('\u{338}', '\u{2274}')]), ('\u{2273}', &[('\u{338}',
        '\u{2275}')]), ('\u{2276}', &[('\u{338}', '\u{2278}')]), ('\u{2277}', &[('\u{338}',
        '\u{2279}')]), ('\u{227a}', &[('\u{338}', '\u{2280}')]), ('\u{227b}', &[('\u{338}',
        '\u{2281}')]), ('\u{227c}', &[('\u{338}', '\u{22e0}')]), ('\u{227d}', &[('\u{338}',
        '\u{22e1}')]), ('\u{2282}', &[('\u{338}', '\u{2284}')]), ('\u{2283}', &[('\u{338}',
        '\u{2285}')]), ('\u{2286}', &[('\u{338}', '\u{2288}')]), ('\u{2287}', &[('\u{338}',
        '\u{2289}')]), ('\u{2291}', &[('\u{338}', '\u{22e2}')]), ('\u{2292}', &[('\u{338}',
        '\u{22e3}')]), ('\u{22a2}', &[('\u{338}', '\u{22ac}')]), ('\u{22a8}', &[('\u{338}',
        '\u{22ad}')]), ('\u{22a9}', &[('\u{338}', '\u{22ae}')]), ('\u{22ab}', &[('\u{338}',
        '\u{22af}')]), ('\u{22b2}', &[('\u{338}', '\u{22ea}')]), ('\u{22b3}', &[('\u{338}',
        '\u{22eb}')]), ('\u{22b4}', &[('\u{338}', '\u{22ec}')]), ('\u{22b5}', &[('\u{338}',
        '\u{22ed}')]), ('\u{3046}', &[('\u{3099}', '\u{3094}')]), ('\u{304b}', &[('\u{3099}',
        '\u{304c}')]), ('\u{304d}', &[('\u{3099}', '\u{304e}')]), ('\u{304f}', &[('\u{3099}',
        '\u{3050}')]), ('\u{3051}', &[('\u{3099}', '\u{3052}')]), ('\u{3053}', &[('\u{3099}',
        '\u{3054}')]), ('\u{3055}', &[('\u{3099}', '\u{3056}')]), ('\u{3057}', &[('\u{3099}',
        '\u{3058}')]), ('\u{3059}', &[('\u{3099}', '\u{305a}')]), ('\u{305b}', &[('\u{3099}',
        '\u{305c}')]), ('\u{305d}', &[('\u{3099}', '\u{305e}')]), ('\u{305f}', &[('\u{3099}',
        '\u{3060}')]), ('\u{3061}', &[('\u{3099}', '\u{3062}')]), ('\u{3064}', &[('\u{3099}',
        '\u{3065}')]), ('\u{3066}', &[('\u{3099}', '\u{3067}')]), ('\u{3068}', &[('\u{3099}',
        '\u{3069}')]), ('\u{306f}', &[('\u{3099}', '\u{3070}'), ('\u{309a}', '\u{3071}')]),
        ('\u{3072}', &[('\u{3099}', '\u{3073}'), ('\u{309a}', '\u{3074}')]), ('\u{3075}',
        &[('\u{3099}', '\u{3076}'), ('\u{309a}', '\u{3077}')]), ('\u{3078}', &[('\u{3099}',
        '\u{3079}'), ('\u{309a}', '\u{307a}')]), ('\u{307b}', &[('\u{3099}', '\u{307c}'),
        ('\u{309a}', '\u{307d}')]), ('\u{309d}', &[('\u{3099}', '\u{309e}')]), ('\u{30a6}',
        &[('\u{3099}', '\u{30f4}')]), ('\u{30ab}', &[('\u{3099}', '\u{30ac}')]), ('\u{30ad}',
        &[('\u{3099}', '\u{30ae}')]), ('\u{30af}', &[('\u{3099}', '\u{30b0}')]), ('\u{30b1}',
        &[('\u{3099}', '\u{30b2}')]), ('\u{30b3}', &[('\u{3099}', '\u{30b4}')]), ('\u{30b5}',
        &[('\u{3099}', '\u{30b6}')]), ('\u{30b7}', &[('\u{3099}', '\u{30b8}')]), ('\u{30b9}',
        &[('\u{3099}', '\u{30ba}')]), ('\u{30bb}', &[('\u{3099}', '\u{30bc}')]), ('\u{30bd}',
        &[('\u{3099}', '\u{30be}')]), ('\u{30bf}', &[('\u{3099}', '\u{30c0}')]), ('\u{30c1}',
        &[('\u{3099}', '\u{30c2}')]), ('\u{30c4}', &[('\u{3099}', '\u{30c5}')]), ('\u{30c6}',
        &[('\u{3099}', '\u{30c7}')]), ('\u{30c8}', &[('\u{3099}', '\u{30c9}')]), ('\u{30cf}',
        &[('\u{3099}', '\u{30d0}'), ('\u{309a}', '\u{30d1}')]), ('\u{30d2}', &[('\u{3099}',
        '\u{30d3}'), ('\u{309a}', '\u{30d4}')]), ('\u{30d5}', &[('\u{3099}', '\u{30d6}'),
        ('\u{309a}', '\u{30d7}')]), ('\u{30d8}', &[('\u{3099}', '\u{30d9}'), ('\u{309a}',
        '\u{30da}')]), ('\u{30db}', &[('\u{3099}', '\u{30dc}'), ('\u{309a}', '\u{30dd}')]),
        ('\u{30ef}', &[('\u{3099}', '\u{30f7}')]), ('\u{30f0}', &[('\u{3099}', '\u{30f8}')]),
        ('\u{30f1}', &[('\u{3099}', '\u{30f9}')]), ('\u{30f2}', &[('\u{3099}', '\u{30fa}')]),
        ('\u{30fd}', &[('\u{3099}', '\u{30fe}')]), ('\u{11099}', &[('\u{110ba}', '\u{1109a}')]),
        ('\u{1109b}', &[('\u{110ba}', '\u{1109c}')]), ('\u{110a5}', &[('\u{110ba}', '\u{110ab}')]),
        ('\u{11131}', &[('\u{11127}', '\u{1112e}')]), ('\u{11132}', &[('\u{11127}', '\u{1112f}')]),
        ('\u{11347}', &[('\u{1133e}', '\u{1134b}'), ('\u{11357}', '\u{1134c}')]), ('\u{114b9}',
        &[('\u{114b0}', '\u{114bc}'), ('\u{114ba}', '\u{114bb}'), ('\u{114bd}', '\u{114be}')]),
        ('\u{115b8}', &[('\u{115af}', '\u{115ba}')]), ('\u{115b9}', &[('\u{115af}', '\u{115bb}')])
    ];


    fn bsearch_range_value_table(c: char, r: &'static [(char, char, u8)]) -> u8 {
        use std::cmp::Ordering::{Equal, Less, Greater};
        match r.binary_search_by(|&(lo, hi, _)| {
            if lo <= c && c <= hi { Equal }
            else if hi < c { Less }
            else { Greater }
        }) {
            Ok(idx) => {
                let (_, _, result) = r[idx];
                result
            }
            Err(_) => 0
        }
    }

    const combining_class_table: &'static [(char, char, u8)] = &[
        ('\u{300}', '\u{314}', 230), ('\u{315}', '\u{315}', 232), ('\u{316}', '\u{319}', 220),
        ('\u{31a}', '\u{31a}', 232), ('\u{31b}', '\u{31b}', 216), ('\u{31c}', '\u{320}', 220),
        ('\u{321}', '\u{322}', 202), ('\u{323}', '\u{326}', 220), ('\u{327}', '\u{328}', 202),
        ('\u{329}', '\u{333}', 220), ('\u{334}', '\u{338}', 1), ('\u{339}', '\u{33c}', 220),
        ('\u{33d}', '\u{344}', 230), ('\u{345}', '\u{345}', 240), ('\u{346}', '\u{346}', 230),
        ('\u{347}', '\u{349}', 220), ('\u{34a}', '\u{34c}', 230), ('\u{34d}', '\u{34e}', 220),
        ('\u{350}', '\u{352}', 230), ('\u{353}', '\u{356}', 220), ('\u{357}', '\u{357}', 230),
        ('\u{358}', '\u{358}', 232), ('\u{359}', '\u{35a}', 220), ('\u{35b}', '\u{35b}', 230),
        ('\u{35c}', '\u{35c}', 233), ('\u{35d}', '\u{35e}', 234), ('\u{35f}', '\u{35f}', 233),
        ('\u{360}', '\u{361}', 234), ('\u{362}', '\u{362}', 233), ('\u{363}', '\u{36f}', 230),
        ('\u{483}', '\u{487}', 230), ('\u{591}', '\u{591}', 220), ('\u{592}', '\u{595}', 230),
        ('\u{596}', '\u{596}', 220), ('\u{597}', '\u{599}', 230), ('\u{59a}', '\u{59a}', 222),
        ('\u{59b}', '\u{59b}', 220), ('\u{59c}', '\u{5a1}', 230), ('\u{5a2}', '\u{5a7}', 220),
        ('\u{5a8}', '\u{5a9}', 230), ('\u{5aa}', '\u{5aa}', 220), ('\u{5ab}', '\u{5ac}', 230),
        ('\u{5ad}', '\u{5ad}', 222), ('\u{5ae}', '\u{5ae}', 228), ('\u{5af}', '\u{5af}', 230),
        ('\u{5b0}', '\u{5b0}', 10), ('\u{5b1}', '\u{5b1}', 11), ('\u{5b2}', '\u{5b2}', 12),
        ('\u{5b3}', '\u{5b3}', 13), ('\u{5b4}', '\u{5b4}', 14), ('\u{5b5}', '\u{5b5}', 15),
        ('\u{5b6}', '\u{5b6}', 16), ('\u{5b7}', '\u{5b7}', 17), ('\u{5b8}', '\u{5b8}', 18),
        ('\u{5b9}', '\u{5ba}', 19), ('\u{5bb}', '\u{5bb}', 20), ('\u{5bc}', '\u{5bc}', 21),
        ('\u{5bd}', '\u{5bd}', 22), ('\u{5bf}', '\u{5bf}', 23), ('\u{5c1}', '\u{5c1}', 24),
        ('\u{5c2}', '\u{5c2}', 25), ('\u{5c4}', '\u{5c4}', 230), ('\u{5c5}', '\u{5c5}', 220),
        ('\u{5c7}', '\u{5c7}', 18), ('\u{610}', '\u{617}', 230), ('\u{618}', '\u{618}', 30),
        ('\u{619}', '\u{619}', 31), ('\u{61a}', '\u{61a}', 32), ('\u{64b}', '\u{64b}', 27),
        ('\u{64c}', '\u{64c}', 28), ('\u{64d}', '\u{64d}', 29), ('\u{64e}', '\u{64e}', 30),
        ('\u{64f}', '\u{64f}', 31), ('\u{650}', '\u{650}', 32), ('\u{651}', '\u{651}', 33),
        ('\u{652}', '\u{652}', 34), ('\u{653}', '\u{654}', 230), ('\u{655}', '\u{656}', 220),
        ('\u{657}', '\u{65b}', 230), ('\u{65c}', '\u{65c}', 220), ('\u{65d}', '\u{65e}', 230),
        ('\u{65f}', '\u{65f}', 220), ('\u{670}', '\u{670}', 35), ('\u{6d6}', '\u{6dc}', 230),
        ('\u{6df}', '\u{6e2}', 230), ('\u{6e3}', '\u{6e3}', 220), ('\u{6e4}', '\u{6e4}', 230),
        ('\u{6e7}', '\u{6e8}', 230), ('\u{6ea}', '\u{6ea}', 220), ('\u{6eb}', '\u{6ec}', 230),
        ('\u{6ed}', '\u{6ed}', 220), ('\u{711}', '\u{711}', 36), ('\u{730}', '\u{730}', 230),
        ('\u{731}', '\u{731}', 220), ('\u{732}', '\u{733}', 230), ('\u{734}', '\u{734}', 220),
        ('\u{735}', '\u{736}', 230), ('\u{737}', '\u{739}', 220), ('\u{73a}', '\u{73a}', 230),
        ('\u{73b}', '\u{73c}', 220), ('\u{73d}', '\u{73d}', 230), ('\u{73e}', '\u{73e}', 220),
        ('\u{73f}', '\u{741}', 230), ('\u{742}', '\u{742}', 220), ('\u{743}', '\u{743}', 230),
        ('\u{744}', '\u{744}', 220), ('\u{745}', '\u{745}', 230), ('\u{746}', '\u{746}', 220),
        ('\u{747}', '\u{747}', 230), ('\u{748}', '\u{748}', 220), ('\u{749}', '\u{74a}', 230),
        ('\u{7eb}', '\u{7f1}', 230), ('\u{7f2}', '\u{7f2}', 220), ('\u{7f3}', '\u{7f3}', 230),
        ('\u{816}', '\u{819}', 230), ('\u{81b}', '\u{823}', 230), ('\u{825}', '\u{827}', 230),
        ('\u{829}', '\u{82d}', 230), ('\u{859}', '\u{85b}', 220), ('\u{8e3}', '\u{8e3}', 220),
        ('\u{8e4}', '\u{8e5}', 230), ('\u{8e6}', '\u{8e6}', 220), ('\u{8e7}', '\u{8e8}', 230),
        ('\u{8e9}', '\u{8e9}', 220), ('\u{8ea}', '\u{8ec}', 230), ('\u{8ed}', '\u{8ef}', 220),
        ('\u{8f0}', '\u{8f0}', 27), ('\u{8f1}', '\u{8f1}', 28), ('\u{8f2}', '\u{8f2}', 29),
        ('\u{8f3}', '\u{8f5}', 230), ('\u{8f6}', '\u{8f6}', 220), ('\u{8f7}', '\u{8f8}', 230),
        ('\u{8f9}', '\u{8fa}', 220), ('\u{8fb}', '\u{8ff}', 230), ('\u{93c}', '\u{93c}', 7),
        ('\u{94d}', '\u{94d}', 9), ('\u{951}', '\u{951}', 230), ('\u{952}', '\u{952}', 220),
        ('\u{953}', '\u{954}', 230), ('\u{9bc}', '\u{9bc}', 7), ('\u{9cd}', '\u{9cd}', 9),
        ('\u{a3c}', '\u{a3c}', 7), ('\u{a4d}', '\u{a4d}', 9), ('\u{abc}', '\u{abc}', 7), ('\u{acd}',
        '\u{acd}', 9), ('\u{b3c}', '\u{b3c}', 7), ('\u{b4d}', '\u{b4d}', 9), ('\u{bcd}', '\u{bcd}',
        9), ('\u{c4d}', '\u{c4d}', 9), ('\u{c55}', '\u{c55}', 84), ('\u{c56}', '\u{c56}', 91),
        ('\u{cbc}', '\u{cbc}', 7), ('\u{ccd}', '\u{ccd}', 9), ('\u{d4d}', '\u{d4d}', 9), ('\u{dca}',
        '\u{dca}', 9), ('\u{e38}', '\u{e39}', 103), ('\u{e3a}', '\u{e3a}', 9), ('\u{e48}',
        '\u{e4b}', 107), ('\u{eb8}', '\u{eb9}', 118), ('\u{ec8}', '\u{ecb}', 122), ('\u{f18}',
        '\u{f19}', 220), ('\u{f35}', '\u{f35}', 220), ('\u{f37}', '\u{f37}', 220), ('\u{f39}',
        '\u{f39}', 216), ('\u{f71}', '\u{f71}', 129), ('\u{f72}', '\u{f72}', 130), ('\u{f74}',
        '\u{f74}', 132), ('\u{f7a}', '\u{f7d}', 130), ('\u{f80}', '\u{f80}', 130), ('\u{f82}',
        '\u{f83}', 230), ('\u{f84}', '\u{f84}', 9), ('\u{f86}', '\u{f87}', 230), ('\u{fc6}',
        '\u{fc6}', 220), ('\u{1037}', '\u{1037}', 7), ('\u{1039}', '\u{103a}', 9), ('\u{108d}',
        '\u{108d}', 220), ('\u{135d}', '\u{135f}', 230), ('\u{1714}', '\u{1714}', 9), ('\u{1734}',
        '\u{1734}', 9), ('\u{17d2}', '\u{17d2}', 9), ('\u{17dd}', '\u{17dd}', 230), ('\u{18a9}',
        '\u{18a9}', 228), ('\u{1939}', '\u{1939}', 222), ('\u{193a}', '\u{193a}', 230), ('\u{193b}',
        '\u{193b}', 220), ('\u{1a17}', '\u{1a17}', 230), ('\u{1a18}', '\u{1a18}', 220), ('\u{1a60}',
        '\u{1a60}', 9), ('\u{1a75}', '\u{1a7c}', 230), ('\u{1a7f}', '\u{1a7f}', 220), ('\u{1ab0}',
        '\u{1ab4}', 230), ('\u{1ab5}', '\u{1aba}', 220), ('\u{1abb}', '\u{1abc}', 230), ('\u{1abd}',
        '\u{1abd}', 220), ('\u{1b34}', '\u{1b34}', 7), ('\u{1b44}', '\u{1b44}', 9), ('\u{1b6b}',
        '\u{1b6b}', 230), ('\u{1b6c}', '\u{1b6c}', 220), ('\u{1b6d}', '\u{1b73}', 230), ('\u{1baa}',
        '\u{1bab}', 9), ('\u{1be6}', '\u{1be6}', 7), ('\u{1bf2}', '\u{1bf3}', 9), ('\u{1c37}',
        '\u{1c37}', 7), ('\u{1cd0}', '\u{1cd2}', 230), ('\u{1cd4}', '\u{1cd4}', 1), ('\u{1cd5}',
        '\u{1cd9}', 220), ('\u{1cda}', '\u{1cdb}', 230), ('\u{1cdc}', '\u{1cdf}', 220), ('\u{1ce0}',
        '\u{1ce0}', 230), ('\u{1ce2}', '\u{1ce8}', 1), ('\u{1ced}', '\u{1ced}', 220), ('\u{1cf4}',
        '\u{1cf4}', 230), ('\u{1cf8}', '\u{1cf9}', 230), ('\u{1dc0}', '\u{1dc1}', 230), ('\u{1dc2}',
        '\u{1dc2}', 220), ('\u{1dc3}', '\u{1dc9}', 230), ('\u{1dca}', '\u{1dca}', 220), ('\u{1dcb}',
        '\u{1dcc}', 230), ('\u{1dcd}', '\u{1dcd}', 234), ('\u{1dce}', '\u{1dce}', 214), ('\u{1dcf}',
        '\u{1dcf}', 220), ('\u{1dd0}', '\u{1dd0}', 202), ('\u{1dd1}', '\u{1df5}', 230), ('\u{1dfc}',
        '\u{1dfc}', 233), ('\u{1dfd}', '\u{1dfd}', 220), ('\u{1dfe}', '\u{1dfe}', 230), ('\u{1dff}',
        '\u{1dff}', 220), ('\u{20d0}', '\u{20d1}', 230), ('\u{20d2}', '\u{20d3}', 1), ('\u{20d4}',
        '\u{20d7}', 230), ('\u{20d8}', '\u{20da}', 1), ('\u{20db}', '\u{20dc}', 230), ('\u{20e1}',
        '\u{20e1}', 230), ('\u{20e5}', '\u{20e6}', 1), ('\u{20e7}', '\u{20e7}', 230), ('\u{20e8}',
        '\u{20e8}', 220), ('\u{20e9}', '\u{20e9}', 230), ('\u{20ea}', '\u{20eb}', 1), ('\u{20ec}',
        '\u{20ef}', 220), ('\u{20f0}', '\u{20f0}', 230), ('\u{2cef}', '\u{2cf1}', 230), ('\u{2d7f}',
        '\u{2d7f}', 9), ('\u{2de0}', '\u{2dff}', 230), ('\u{302a}', '\u{302a}', 218), ('\u{302b}',
        '\u{302b}', 228), ('\u{302c}', '\u{302c}', 232), ('\u{302d}', '\u{302d}', 222), ('\u{302e}',
        '\u{302f}', 224), ('\u{3099}', '\u{309a}', 8), ('\u{a66f}', '\u{a66f}', 230), ('\u{a674}',
        '\u{a67d}', 230), ('\u{a69e}', '\u{a69f}', 230), ('\u{a6f0}', '\u{a6f1}', 230), ('\u{a806}',
        '\u{a806}', 9), ('\u{a8c4}', '\u{a8c4}', 9), ('\u{a8e0}', '\u{a8f1}', 230), ('\u{a92b}',
        '\u{a92d}', 220), ('\u{a953}', '\u{a953}', 9), ('\u{a9b3}', '\u{a9b3}', 7), ('\u{a9c0}',
        '\u{a9c0}', 9), ('\u{aab0}', '\u{aab0}', 230), ('\u{aab2}', '\u{aab3}', 230), ('\u{aab4}',
        '\u{aab4}', 220), ('\u{aab7}', '\u{aab8}', 230), ('\u{aabe}', '\u{aabf}', 230), ('\u{aac1}',
        '\u{aac1}', 230), ('\u{aaf6}', '\u{aaf6}', 9), ('\u{abed}', '\u{abed}', 9), ('\u{fb1e}',
        '\u{fb1e}', 26), ('\u{fe20}', '\u{fe26}', 230), ('\u{fe27}', '\u{fe2d}', 220), ('\u{fe2e}',
        '\u{fe2f}', 230), ('\u{101fd}', '\u{101fd}', 220), ('\u{102e0}', '\u{102e0}', 220),
        ('\u{10376}', '\u{1037a}', 230), ('\u{10a0d}', '\u{10a0d}', 220), ('\u{10a0f}', '\u{10a0f}',
        230), ('\u{10a38}', '\u{10a38}', 230), ('\u{10a39}', '\u{10a39}', 1), ('\u{10a3a}',
        '\u{10a3a}', 220), ('\u{10a3f}', '\u{10a3f}', 9), ('\u{10ae5}', '\u{10ae5}', 230),
        ('\u{10ae6}', '\u{10ae6}', 220), ('\u{11046}', '\u{11046}', 9), ('\u{1107f}', '\u{1107f}',
        9), ('\u{110b9}', '\u{110b9}', 9), ('\u{110ba}', '\u{110ba}', 7), ('\u{11100}', '\u{11102}',
        230), ('\u{11133}', '\u{11134}', 9), ('\u{11173}', '\u{11173}', 7), ('\u{111c0}',
        '\u{111c0}', 9), ('\u{111ca}', '\u{111ca}', 7), ('\u{11235}', '\u{11235}', 9), ('\u{11236}',
        '\u{11236}', 7), ('\u{112e9}', '\u{112e9}', 7), ('\u{112ea}', '\u{112ea}', 9), ('\u{1133c}',
        '\u{1133c}', 7), ('\u{1134d}', '\u{1134d}', 9), ('\u{11366}', '\u{1136c}', 230),
        ('\u{11370}', '\u{11374}', 230), ('\u{114c2}', '\u{114c2}', 9), ('\u{114c3}', '\u{114c3}',
        7), ('\u{115bf}', '\u{115bf}', 9), ('\u{115c0}', '\u{115c0}', 7), ('\u{1163f}', '\u{1163f}',
        9), ('\u{116b6}', '\u{116b6}', 9), ('\u{116b7}', '\u{116b7}', 7), ('\u{1172b}', '\u{1172b}',
        9), ('\u{16af0}', '\u{16af4}', 1), ('\u{16b30}', '\u{16b36}', 230), ('\u{1bc9e}',
        '\u{1bc9e}', 1), ('\u{1d165}', '\u{1d166}', 216), ('\u{1d167}', '\u{1d169}', 1),
        ('\u{1d16d}', '\u{1d16d}', 226), ('\u{1d16e}', '\u{1d172}', 216), ('\u{1d17b}', '\u{1d182}',
        220), ('\u{1d185}', '\u{1d189}', 230), ('\u{1d18a}', '\u{1d18b}', 220), ('\u{1d1aa}',
        '\u{1d1ad}', 230), ('\u{1d242}', '\u{1d244}', 230), ('\u{1e8d0}', '\u{1e8d6}', 220)
    ];

    pub fn canonical_combining_class(c: char) -> u8 {
        bsearch_range_value_table(c, combining_class_table)
    }

    fn bsearch_range_table(c: char, r: &'static [(char, char)]) -> bool {
        use std::cmp::Ordering::{Equal, Less, Greater};
        r.binary_search_by(|&(lo, hi)| {
             if lo <= c && c <= hi {
                 Equal
             } else if hi < c {
                 Less
             } else {
                 Greater
             }
         })
         .is_ok()
    }

    /// Return whether the given character is a combining mark (`General_Category=Mark`)
    pub fn is_combining_mark(c: char) -> bool {
        bsearch_range_table(c, general_category_mark)
    }

    const general_category_mark: &'static [(char, char)] = &[
        ('\u{300}', '\u{314}'), ('\u{315}', '\u{315}'), ('\u{316}', '\u{319}'), ('\u{31a}',
        '\u{31a}'), ('\u{31b}', '\u{31b}'), ('\u{31c}', '\u{320}'), ('\u{321}', '\u{322}'),
        ('\u{323}', '\u{326}'), ('\u{327}', '\u{328}'), ('\u{329}', '\u{333}'), ('\u{334}',
        '\u{338}'), ('\u{339}', '\u{33c}'), ('\u{33d}', '\u{344}'), ('\u{345}', '\u{345}'),
        ('\u{346}', '\u{346}'), ('\u{347}', '\u{349}'), ('\u{34a}', '\u{34c}'), ('\u{34d}',
        '\u{34e}'), ('\u{350}', '\u{352}'), ('\u{353}', '\u{356}'), ('\u{357}', '\u{357}'),
        ('\u{358}', '\u{358}'), ('\u{359}', '\u{35a}'), ('\u{35b}', '\u{35b}'), ('\u{35c}',
        '\u{35c}'), ('\u{35d}', '\u{35e}'), ('\u{35f}', '\u{35f}'), ('\u{360}', '\u{361}'),
        ('\u{362}', '\u{362}'), ('\u{363}', '\u{36f}'), ('\u{483}', '\u{487}'), ('\u{591}',
        '\u{591}'), ('\u{592}', '\u{595}'), ('\u{596}', '\u{596}'), ('\u{597}', '\u{599}'),
        ('\u{59a}', '\u{59a}'), ('\u{59b}', '\u{59b}'), ('\u{59c}', '\u{5a1}'), ('\u{5a2}',
        '\u{5a7}'), ('\u{5a8}', '\u{5a9}'), ('\u{5aa}', '\u{5aa}'), ('\u{5ab}', '\u{5ac}'),
        ('\u{5ad}', '\u{5ad}'), ('\u{5ae}', '\u{5ae}'), ('\u{5af}', '\u{5af}'), ('\u{5b0}',
        '\u{5b0}'), ('\u{5b1}', '\u{5b1}'), ('\u{5b2}', '\u{5b2}'), ('\u{5b3}', '\u{5b3}'),
        ('\u{5b4}', '\u{5b4}'), ('\u{5b5}', '\u{5b5}'), ('\u{5b6}', '\u{5b6}'), ('\u{5b7}',
        '\u{5b7}'), ('\u{5b8}', '\u{5b8}'), ('\u{5b9}', '\u{5ba}'), ('\u{5bb}', '\u{5bb}'),
        ('\u{5bc}', '\u{5bc}'), ('\u{5bd}', '\u{5bd}'), ('\u{5bf}', '\u{5bf}'), ('\u{5c1}',
        '\u{5c1}'), ('\u{5c2}', '\u{5c2}'), ('\u{5c4}', '\u{5c4}'), ('\u{5c5}', '\u{5c5}'),
        ('\u{5c7}', '\u{5c7}'), ('\u{610}', '\u{617}'), ('\u{618}', '\u{618}'), ('\u{619}',
        '\u{619}'), ('\u{61a}', '\u{61a}'), ('\u{64b}', '\u{64b}'), ('\u{64c}', '\u{64c}'),
        ('\u{64d}', '\u{64d}'), ('\u{64e}', '\u{64e}'), ('\u{64f}', '\u{64f}'), ('\u{650}',
        '\u{650}'), ('\u{651}', '\u{651}'), ('\u{652}', '\u{652}'), ('\u{653}', '\u{654}'),
        ('\u{655}', '\u{656}'), ('\u{657}', '\u{65b}'), ('\u{65c}', '\u{65c}'), ('\u{65d}',
        '\u{65e}'), ('\u{65f}', '\u{65f}'), ('\u{670}', '\u{670}'), ('\u{6d6}', '\u{6dc}'),
        ('\u{6df}', '\u{6e2}'), ('\u{6e3}', '\u{6e3}'), ('\u{6e4}', '\u{6e4}'), ('\u{6e7}',
        '\u{6e8}'), ('\u{6ea}', '\u{6ea}'), ('\u{6eb}', '\u{6ec}'), ('\u{6ed}', '\u{6ed}'),
        ('\u{711}', '\u{711}'), ('\u{730}', '\u{730}'), ('\u{731}', '\u{731}'), ('\u{732}',
        '\u{733}'), ('\u{734}', '\u{734}'), ('\u{735}', '\u{736}'), ('\u{737}', '\u{739}'),
        ('\u{73a}', '\u{73a}'), ('\u{73b}', '\u{73c}'), ('\u{73d}', '\u{73d}'), ('\u{73e}',
        '\u{73e}'), ('\u{73f}', '\u{741}'), ('\u{742}', '\u{742}'), ('\u{743}', '\u{743}'),
        ('\u{744}', '\u{744}'), ('\u{745}', '\u{745}'), ('\u{746}', '\u{746}'), ('\u{747}',
        '\u{747}'), ('\u{748}', '\u{748}'), ('\u{749}', '\u{74a}'), ('\u{7eb}', '\u{7f1}'),
        ('\u{7f2}', '\u{7f2}'), ('\u{7f3}', '\u{7f3}'), ('\u{816}', '\u{819}'), ('\u{81b}',
        '\u{823}'), ('\u{825}', '\u{827}'), ('\u{829}', '\u{82d}'), ('\u{859}', '\u{85b}'),
        ('\u{8e3}', '\u{8e3}'), ('\u{8e4}', '\u{8e5}'), ('\u{8e6}', '\u{8e6}'), ('\u{8e7}',
        '\u{8e8}'), ('\u{8e9}', '\u{8e9}'), ('\u{8ea}', '\u{8ec}'), ('\u{8ed}', '\u{8ef}'),
        ('\u{8f0}', '\u{8f0}'), ('\u{8f1}', '\u{8f1}'), ('\u{8f2}', '\u{8f2}'), ('\u{8f3}',
        '\u{8f5}'), ('\u{8f6}', '\u{8f6}'), ('\u{8f7}', '\u{8f8}'), ('\u{8f9}', '\u{8fa}'),
        ('\u{8fb}', '\u{8ff}'), ('\u{93c}', '\u{93c}'), ('\u{94d}', '\u{94d}'), ('\u{951}',
        '\u{951}'), ('\u{952}', '\u{952}'), ('\u{953}', '\u{954}'), ('\u{9bc}', '\u{9bc}'),
        ('\u{9cd}', '\u{9cd}'), ('\u{a3c}', '\u{a3c}'), ('\u{a4d}', '\u{a4d}'), ('\u{abc}',
        '\u{abc}'), ('\u{acd}', '\u{acd}'), ('\u{b3c}', '\u{b3c}'), ('\u{b4d}', '\u{b4d}'),
        ('\u{bcd}', '\u{bcd}'), ('\u{c4d}', '\u{c4d}'), ('\u{c55}', '\u{c55}'), ('\u{c56}',
        '\u{c56}'), ('\u{cbc}', '\u{cbc}'), ('\u{ccd}', '\u{ccd}'), ('\u{d4d}', '\u{d4d}'),
        ('\u{dca}', '\u{dca}'), ('\u{e38}', '\u{e39}'), ('\u{e3a}', '\u{e3a}'), ('\u{e48}',
        '\u{e4b}'), ('\u{eb8}', '\u{eb9}'), ('\u{ec8}', '\u{ecb}'), ('\u{f18}', '\u{f19}'),
        ('\u{f35}', '\u{f35}'), ('\u{f37}', '\u{f37}'), ('\u{f39}', '\u{f39}'), ('\u{f71}',
        '\u{f71}'), ('\u{f72}', '\u{f72}'), ('\u{f74}', '\u{f74}'), ('\u{f7a}', '\u{f7d}'),
        ('\u{f80}', '\u{f80}'), ('\u{f82}', '\u{f83}'), ('\u{f84}', '\u{f84}'), ('\u{f86}',
        '\u{f87}'), ('\u{fc6}', '\u{fc6}'), ('\u{1037}', '\u{1037}'), ('\u{1039}', '\u{103a}'),
        ('\u{108d}', '\u{108d}'), ('\u{135d}', '\u{135f}'), ('\u{1714}', '\u{1714}'), ('\u{1734}',
        '\u{1734}'), ('\u{17d2}', '\u{17d2}'), ('\u{17dd}', '\u{17dd}'), ('\u{18a9}', '\u{18a9}'),
        ('\u{1939}', '\u{1939}'), ('\u{193a}', '\u{193a}'), ('\u{193b}', '\u{193b}'), ('\u{1a17}',
        '\u{1a17}'), ('\u{1a18}', '\u{1a18}'), ('\u{1a60}', '\u{1a60}'), ('\u{1a75}', '\u{1a7c}'),
        ('\u{1a7f}', '\u{1a7f}'), ('\u{1ab0}', '\u{1ab4}'), ('\u{1ab5}', '\u{1aba}'), ('\u{1abb}',
        '\u{1abc}'), ('\u{1abd}', '\u{1abd}'), ('\u{1b34}', '\u{1b34}'), ('\u{1b44}', '\u{1b44}'),
        ('\u{1b6b}', '\u{1b6b}'), ('\u{1b6c}', '\u{1b6c}'), ('\u{1b6d}', '\u{1b73}'), ('\u{1baa}',
        '\u{1bab}'), ('\u{1be6}', '\u{1be6}'), ('\u{1bf2}', '\u{1bf3}'), ('\u{1c37}', '\u{1c37}'),
        ('\u{1cd0}', '\u{1cd2}'), ('\u{1cd4}', '\u{1cd4}'), ('\u{1cd5}', '\u{1cd9}'), ('\u{1cda}',
        '\u{1cdb}'), ('\u{1cdc}', '\u{1cdf}'), ('\u{1ce0}', '\u{1ce0}'), ('\u{1ce2}', '\u{1ce8}'),
        ('\u{1ced}', '\u{1ced}'), ('\u{1cf4}', '\u{1cf4}'), ('\u{1cf8}', '\u{1cf9}'), ('\u{1dc0}',
        '\u{1dc1}'), ('\u{1dc2}', '\u{1dc2}'), ('\u{1dc3}', '\u{1dc9}'), ('\u{1dca}', '\u{1dca}'),
        ('\u{1dcb}', '\u{1dcc}'), ('\u{1dcd}', '\u{1dcd}'), ('\u{1dce}', '\u{1dce}'), ('\u{1dcf}',
        '\u{1dcf}'), ('\u{1dd0}', '\u{1dd0}'), ('\u{1dd1}', '\u{1df5}'), ('\u{1dfc}', '\u{1dfc}'),
        ('\u{1dfd}', '\u{1dfd}'), ('\u{1dfe}', '\u{1dfe}'), ('\u{1dff}', '\u{1dff}'), ('\u{20d0}',
        '\u{20d1}'), ('\u{20d2}', '\u{20d3}'), ('\u{20d4}', '\u{20d7}'), ('\u{20d8}', '\u{20da}'),
        ('\u{20db}', '\u{20dc}'), ('\u{20e1}', '\u{20e1}'), ('\u{20e5}', '\u{20e6}'), ('\u{20e7}',
        '\u{20e7}'), ('\u{20e8}', '\u{20e8}'), ('\u{20e9}', '\u{20e9}'), ('\u{20ea}', '\u{20eb}'),
        ('\u{20ec}', '\u{20ef}'), ('\u{20f0}', '\u{20f0}'), ('\u{2cef}', '\u{2cf1}'), ('\u{2d7f}',
        '\u{2d7f}'), ('\u{2de0}', '\u{2dff}'), ('\u{302a}', '\u{302a}'), ('\u{302b}', '\u{302b}'),
        ('\u{302c}', '\u{302c}'), ('\u{302d}', '\u{302d}'), ('\u{302e}', '\u{302f}'), ('\u{3099}',
        '\u{309a}'), ('\u{a66f}', '\u{a66f}'), ('\u{a674}', '\u{a67d}'), ('\u{a69e}', '\u{a69f}'),
        ('\u{a6f0}', '\u{a6f1}'), ('\u{a806}', '\u{a806}'), ('\u{a8c4}', '\u{a8c4}'), ('\u{a8e0}',
        '\u{a8f1}'), ('\u{a92b}', '\u{a92d}'), ('\u{a953}', '\u{a953}'), ('\u{a9b3}', '\u{a9b3}'),
        ('\u{a9c0}', '\u{a9c0}'), ('\u{aab0}', '\u{aab0}'), ('\u{aab2}', '\u{aab3}'), ('\u{aab4}',
        '\u{aab4}'), ('\u{aab7}', '\u{aab8}'), ('\u{aabe}', '\u{aabf}'), ('\u{aac1}', '\u{aac1}'),
        ('\u{aaf6}', '\u{aaf6}'), ('\u{abed}', '\u{abed}'), ('\u{fb1e}', '\u{fb1e}'), ('\u{fe20}',
        '\u{fe26}'), ('\u{fe27}', '\u{fe2d}'), ('\u{fe2e}', '\u{fe2f}'), ('\u{101fd}', '\u{101fd}'),
        ('\u{102e0}', '\u{102e0}'), ('\u{10376}', '\u{1037a}'), ('\u{10a0d}', '\u{10a0d}'),
        ('\u{10a0f}', '\u{10a0f}'), ('\u{10a38}', '\u{10a38}'), ('\u{10a39}', '\u{10a39}'),
        ('\u{10a3a}', '\u{10a3a}'), ('\u{10a3f}', '\u{10a3f}'), ('\u{10ae5}', '\u{10ae5}'),
        ('\u{10ae6}', '\u{10ae6}'), ('\u{11046}', '\u{11046}'), ('\u{1107f}', '\u{1107f}'),
        ('\u{110b9}', '\u{110b9}'), ('\u{110ba}', '\u{110ba}'), ('\u{11100}', '\u{11102}'),
        ('\u{11133}', '\u{11134}'), ('\u{11173}', '\u{11173}'), ('\u{111c0}', '\u{111c0}'),
        ('\u{111ca}', '\u{111ca}'), ('\u{11235}', '\u{11235}'), ('\u{11236}', '\u{11236}'),
        ('\u{112e9}', '\u{112e9}'), ('\u{112ea}', '\u{112ea}'), ('\u{1133c}', '\u{1133c}'),
        ('\u{1134d}', '\u{1134d}'), ('\u{11366}', '\u{1136c}'), ('\u{11370}', '\u{11374}'),
        ('\u{114c2}', '\u{114c2}'), ('\u{114c3}', '\u{114c3}'), ('\u{115bf}', '\u{115bf}'),
        ('\u{115c0}', '\u{115c0}'), ('\u{1163f}', '\u{1163f}'), ('\u{116b6}', '\u{116b6}'),
        ('\u{116b7}', '\u{116b7}'), ('\u{1172b}', '\u{1172b}'), ('\u{16af0}', '\u{16af4}'),
        ('\u{16b30}', '\u{16b36}'), ('\u{1bc9e}', '\u{1bc9e}'), ('\u{1d165}', '\u{1d166}'),
        ('\u{1d167}', '\u{1d169}'), ('\u{1d16d}', '\u{1d16d}'), ('\u{1d16e}', '\u{1d172}'),
        ('\u{1d17b}', '\u{1d182}'), ('\u{1d185}', '\u{1d189}'), ('\u{1d18a}', '\u{1d18b}'),
        ('\u{1d1aa}', '\u{1d1ad}'), ('\u{1d242}', '\u{1d244}'), ('\u{1e8d0}', '\u{1e8d6}')
    ];


}

