/*-------------------------------------------------------------------------*/
/* GNU Prolog                                                              */
/*                                                                         */
/* Part  : line-edit library                                               */
/* File  : stty.h                                                          */
/* Descr.: TTY features - header file                                      */
/* Author: Daniel Diaz                                                     */
/*                                                                         */
/* Copyright (C) 1999,2000 Daniel Diaz                                     */
/*                                                                         */
/* GNU Prolog is free software; you can redistribute it and/or modify it   */
/* under the terms of the GNU General Public License as published by the   */
/* Free Software Foundation; either version 2, or any later version.       */
/*                                                                         */
/* GNU Prolog is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of              */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        */
/* General Public License for more details.                                */
/*                                                                         */
/* You should have received a copy of the GNU General Public License along */
/* with this program; if not, write to the Free Software Foundation, Inc.  */
/* 59 Temple Place - Suite 330, Boston, MA 02111, USA.                     */
/*-------------------------------------------------------------------------*/

/*---------------------------------*/
/* Constants                       */
/*---------------------------------*/

/*---------------------------------*/
/* Type Definitions                */
/*---------------------------------*/

/*---------------------------------*/
/* Global Variables                */
/*---------------------------------*/

#if defined(_WIN32) && !defined(__CYGWIN__)

#include <windows.h>

#ifdef STTY_FILE

       HANDLE h_stdin;
       HANDLE h_stdout;

#else

extern HANDLE h_stdin;
extern HANDLE h_stdout;

#endif

#endif





/*---------------------------------*/
/* Function Prototypes             */
/*---------------------------------*/

void      LE_Init               (int fd_in,int fd_out);
void      LE_Term               (int fd_in,int fd_out);
void      LE_Screen_Size        (int fd_out,int *row,int *col);
int       LE_Kbd_Is_Not_Empty   (int fd_in);
int       LE_Which_Signal       (int c);
