#!/usr/bin/env python
### Compressed module sources ###
module_sources = [('util', 'eJxlkMEKgzAQRO/5isWTQhFaSg8Ff6LnQknM2ixoItmov1+T2FLb3DY7mZkXGkbnAxjJpiclKI+K\nrOSWSAihsQM28sjBk32WXF0FrKe4YZi8hWAwrZMDuC5fJC1wkaQ+K7eIOqpXm1rTEzmU1ZahLuc/\ncwYlGS9nQNs6jfoACwUDQVIf/RdDAXmULYK0Gpo1aXAz6l3sG6VWJ/nIdjHdx45jWTR3W3xVSKTT\n8NuEE9a+DMzomZz9QOencdyDJ7LvH6zEC9SEeBQ=\n'), ('util.commands', 'eJztWutz47YR/66/AiPPVdRFx1OdZz3jdJyznWiSs11Z6TXj83AgEpJQ86ECoHXK9I/vLh4kSFGW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\n'), ('util.retry', 'eJytV02P2zYQvftXDBwYlhxHtVNsDkZcbNEvFChy6l2mJcpmI5EuScW7KPLfO0NSlGR5tznUh7VE\nDh9n3rwZz4rmorQFKxo+E/5ZM1mqZlZp1UDVysIqVRsIm1fNLsbvFUpa/mRrcew2w0rDJDtx3eHV\n6nQS8jTDb9h3b9mJ2z/wkeskzyVreJ6ns9ms5BVobvVzwgorlFwDs5Y3F2v2D2swNecXcnX/YbOG\nhj3l/coDrABXZxA/DifnTwVZKGn2yS/d8zpdQ1FzJtvL/pOSHK/RJzTA5c9X9/jP13TnsObz+U+s\nruHgHVoCo4tF0zagKlwN7i0dhQZaaUUNwoJpi4Lz0vQeYWysrS0GD1bBQwaH6P0ShAF75iDb5sg1\nIRuObJaGTK9M2Ihy5PbKuYy8rG9wP2wA8welao81LXFWnD0V3ZE1mkW4cTQjSpcZwOGWROcpA9te\nao5HIk6kluJgGP5ZtXWJ3kLB2tPZZvB7BT0MKIxWk6nEP8rwCFQLY3kJQt67m2mO8hQGDZwEu6Ss\nibxnuApM1LHHCqaiaXgpmOX1s3PjEFLvYrlo9UWUaEWsFZhpdsTIMIEENmDd7Y3BgFUWg8AQYvSE\n2AX8SZGq2oZLayJQcBEuzJBrmDDhuXlWre406cuO4DT/uxUadTVFQhfxMo0yQY8kReCIRxxXpG5f\nknPd0ZobE5GziHMgvS9d+Acvfs9zl2SnJlFYEkj0ghynEAArvhcTLh46CpdYOG6DAqXeENZDYafD\nPalsDF3p3jSseVtRjSsePvb9YNfLR52ykh/bUzIfWy9KcAQ4yQ2X57CAZNA2YHzNoOuk3hGJXWzr\nnq5ngQRJ+LiP5dh7gtrdjWDJNSErlcydsHdAfYVKdGFQFvbsetAO37om5J/nI5D4mYcb4U0IwfOa\ndd0U/bY6IZjUP3pMfJEhjlgl3LYaZeLOJyuyWsNqFeyjqa/DSVedxhjoj0FSNfSlv4P5mt5yomL/\np2752BtMc0j7bhJ42EgmJzAl91LwIvO/iS9EPMlNIsnE31CWI3aoh9ze1+vnB9h8w32/MhRKGaTk\nUl7GBn/klaK2Rpa4hb7cTzh9eilObGg1c/vJK1a94/vB8wreTyxvohzVxDTiW+yR+ciaZgQh236x\nEhLr4KZWJLylIusHAuEawsqrr5OofwtC9QDL5RJ+xJ/EQmlmsZcgt2GgSDNs06yhltYanE+8/WMP\n7tmiCyulBhrLsmx2axunku1mM5xLtpse5ch0ku5GMMHDWbTJI2ReoQIV+kkdenDs0U1cfnU4SgyP\nkskFJ6nb2t3dq3PPBuGFqccfCnOP/0KMAdMv6/EmBbObq6Yuzu7vhtgx3483M2QcCLE0gtP/LYIJ\nZxElF/YVlv5nhu6x8yw4jkWdL0OBY/7uz7rbyaz7fRSdwd9KtMjwwF8CT+v9NsRDws9pAsBx/tQL\nNr37U9n9lizEdwuB/TmHt7DtZ+8+sc79fgSpwq1jofWNAIvY/zeR0ZeQNnnnD3TupkOsfNjF4R1s\nx7Bv4Gcc9XBa4H5wcte4qblmJvwLM7Q/as4+34s2dmHiaJG9rwwkIwbS+YD/V9h4vecO+ut+kK1h\nxN/YYV/urP8CNnostA==\n'), ('util.hg', 'eJzdPGtz20aS3/UrJlT5QDoUbSV3ro2y3CrHUWLXJY5LVjZ1pagokBiSiEmAwQBitLn89+vXPPCi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\n')]

### Load the compressed module sources ###
import sys, imp
for name, source in module_sources:
    source = source.decode("base64").decode("zlib")
    mod = imp.new_module(name)
    exec source in mod.__dict__
    sys.modules[name] = mod

### Original script follows ###
#!/usr/bin/env python
"""%prog [-p|--props-file] [-r|--rev revision] [-b|--branch branch]
         [-s|--shared-dir shared_dir] [--check-outgoing] repo [dest]

Tool to do safe operations with hg.

revision/branch on commandline will override those in props-file"""

# Import snippet to find tools lib
import os
import sys
sys.path.append(os.path.join(os.path.dirname(__file__), "../../lib/python"))

from util.hg import mercurial, out, remove_path

if __name__ == '__main__':
    from optparse import OptionParser
    import logging

    parser = OptionParser(__doc__)
    parser.set_defaults(
        revision=os.environ.get('HG_REV'),
        branch=os.environ.get('HG_BRANCH', None),
        outgoing=False,
        propsfile=os.environ.get('PROPERTIES_FILE'),
        loglevel=logging.INFO,
        shared_dir=os.environ.get('HG_SHARE_BASE_DIR'),
        clone_by_rev=False,
        mirrors=None,
        bundles=None,
    )
    parser.add_option(
        "-v", "--verbose", dest="loglevel", action="store_const",
        const=logging.DEBUG, help="verbose logging")
    parser.add_option(
        "-r", "--rev", dest="revision", help="which revision to update to")
    parser.add_option(
        "-b", "--branch", dest="branch", help="which branch to update to")
    parser.add_option("-p", "--props-file", dest="propsfile",
                      help="build json file containing revision information")
    parser.add_option("-s", "--shared-dir", dest="shared_dir",
                      help="clone to a shared directory")
    parser.add_option("--check-outgoing", dest="outgoing", action="store_true",
                      help="check for and clobber outgoing changesets")
    parser.add_option(
        "--clone-by-revision", dest="clone_by_rev", action="store_true",
        help="do initial clone with -r <rev> instead of cloning the entire repo. "
             "This is slower but is useful when cloning repositories with many "
             "heads which may timeout otherwise.")
    parser.add_option("--mirror", dest="mirrors", action="append",
                      help="add a mirror to try cloning/pulling from before repo")
    parser.add_option("--bundle", dest="bundles", action="append",
                      help="add a bundle to try downloading/unbundling from before doing a full clone")
    parser.add_option("--purge", dest="auto_purge", action="store_true",
                      help="Purge the destination directory (if it exists).")

    options, args = parser.parse_args()

    logging.basicConfig(level=options.loglevel, format="%(message)s")

    if len(args) not in (1, 2):
        parser.error("Invalid number of arguments")

    repo = args[0]
    if len(args) == 2:
        dest = args[1]
    else:
        dest = os.path.basename(repo)

    # Parse propsfile
    if options.propsfile:
        try:
            import json
        except ImportError:
            import simplejson as json
        js = json.load(open(options.propsfile))
        if options.revision is None:
            options.revision = js['sourcestamp']['revision']
        if options.branch is None:
            options.branch = js['sourcestamp']['branch']

    # look for and clobber outgoing changesets
    if options.outgoing:
        if out(dest, repo):
            remove_path(dest)
        if options.shared_dir and out(options.shared_dir, repo):
            remove_path(options.shared_dir)

    got_revision = mercurial(repo, dest, options.branch, options.revision,
                             shareBase=options.shared_dir,
                             clone_by_rev=options.clone_by_rev,
                             mirrors=options.mirrors,
                             bundles=options.bundles,
                             autoPurge=options.auto_purge)

    print "Got revision %s" % got_revision
