# lint_ignore=E501
config = {
    "shipped-locales-url": "https://hg.mozilla.org/%(repo)s/raw-file/%(revision)s/browser/locales/shipped-locales",
    "products": {
        "installer": {
            "product-name": "IceCat-%(version)s",
            "check_uptake": True,
            "alias": "icecat-latest",
            "ssl-only": False,
            "add-locales": True,
            "paths": {
                "linux": {
                    "path": "/icecat/releases/%(version)s/linux-i686/:lang/icecat-%(version)s.tar.bz2",
                    "bouncer-platform": "linux",
                },
                "linux64": {
                    "path": "/icecat/releases/%(version)s/linux-x86_64/:lang/icecat-%(version)s.tar.bz2",
                    "bouncer-platform": "linux64",
                },
                "macosx64": {
                    "path": "/icecat/releases/%(version)s/mac/:lang/IceCat%%20%(version)s.dmg",
                    "bouncer-platform": "osx",
                },
                "win32": {
                    "path": "/icecat/releases/%(version)s/win32/:lang/IceCat%%20Setup%%20%(version)s.exe",
                    "bouncer-platform": "win",
                },
                "win64": {
                    "path": "/icecat/releases/%(version)s/win64/:lang/IceCat%%20Setup%%20%(version)s.exe",
                    "bouncer-platform": "win64",
                },
                "opensolaris-i386": {
                    "path": "/icecat/releases/%(version)s/contrib/solaris_tarball/icecat-%(version)s.en-US.opensolaris-i386.tar.bz2",
                    "bouncer-platform": "opensolaris-i386",
                },
                "opensolaris-sparc": {
                    "path": "/icecat/releases/%(version)s/contrib/solaris_tarball/icecat-%(version)s.en-US.opensolaris-sparc.tar.bz2",
                    "bouncer-platform": "opensolaris-sparc",
                },
                "solaris-i386": {
                    "path": "/icecat/releases/%(version)s/contrib/solaris_tarball/icecat-%(version)s.en-US.solaris-i386.tar.bz2",
                    "bouncer-platform": "solaris-i386",
                },
                "solaris-sparc": {
                    "path": "/icecat/releases/%(version)s/contrib/solaris_tarball/icecat-%(version)s.en-US.solaris-sparc.tar.bz2",
                    "bouncer-platform": "solaris-sparc",
                },
            },
        },
        "installer-ssl": {
            "product-name": "IceCat-%(version)s-SSL",
            "check_uptake": True,
            "ssl-only": True,
            "add-locales": True,
            "paths": {
                "linux": {
                    "path": "/icecat/releases/%(version)s/linux-i686/:lang/icecat-%(version)s.tar.bz2",
                    "bouncer-platform": "linux",
                },
                "linux64": {
                    "path": "/icecat/releases/%(version)s/linux-x86_64/:lang/icecat-%(version)s.tar.bz2",
                    "bouncer-platform": "linux64",
                },
                "macosx64": {
                    "path": "/icecat/releases/%(version)s/mac/:lang/IceCat%%20%(version)s.dmg",
                    "bouncer-platform": "osx",
                },
                "win32": {
                    "path": "/icecat/releases/%(version)s/win32/:lang/IceCat%%20Setup%%20%(version)s.exe",
                    "bouncer-platform": "win",
                },
                "win64": {
                    "path": "/icecat/releases/%(version)s/win64/:lang/IceCat%%20Setup%%20%(version)s.exe",
                    "bouncer-platform": "win64",
                },
                "opensolaris-i386": {
                    "path": "/icecat/releases/%(version)s/contrib/solaris_tarball/icecat-%(version)s.en-US.opensolaris-i386.tar.bz2",
                    "bouncer-platform": "opensolaris-i386",
                },
                "opensolaris-sparc": {
                    "path": "/icecat/releases/%(version)s/contrib/solaris_tarball/icecat-%(version)s.en-US.opensolaris-sparc.tar.bz2",
                    "bouncer-platform": "opensolaris-sparc",
                },
                "solaris-i386": {
                    "path": "/icecat/releases/%(version)s/contrib/solaris_tarball/icecat-%(version)s.en-US.solaris-i386.tar.bz2",
                    "bouncer-platform": "solaris-i386",
                },
                "solaris-sparc": {
                    "path": "/icecat/releases/%(version)s/contrib/solaris_tarball/icecat-%(version)s.en-US.solaris-sparc.tar.bz2",
                    "bouncer-platform": "solaris-sparc",
                },
            },
        },
        "stub-installer": {
            "product-name": "IceCat-%(version)s-stub",
            "check_uptake": True,
            "alias": "icecat-stub",
            "ssl-only": True,
            "add-locales": True,
            "paths": {
                "win32": {
                    "path": "/icecat/releases/%(version)s/win32/:lang/IceCat%%20Setup%%20Stub%%20%(version)s.exe",
                    "bouncer-platform": "win",
                },
            },
        },
        "sha1-installer": {
            "product-name": "IceCat-%(version)s-sha1",
            # TODO: enable when sha1 installers are automated in bug 1290179
            "check_uptake": False,
            # TODO: enable when sha1 installers are automated in bug 1290179
            # "alias": "icecat-sha1",
            "ssl-only": True,
            "add-locales": True,
            "paths": {
                "win32": {
                    "path": "/icecat/releases/%(version)s/win32-sha1/:lang/IceCat%%20Setup%%20%(version)s.exe",
                    "bouncer-platform": "win",
                },
            },
        },
        "complete-mar": {
            "product-name": "IceCat-%(version)s-Complete",
            "check_uptake": True,
            "ssl-only": False,
            "add-locales": True,
            "paths": {
                "linux": {
                    "path": "/icecat/releases/%(version)s/update/linux-i686/:lang/icecat-%(version)s.complete.mar",
                    "bouncer-platform": "linux",
                },
                "linux64": {
                    "path": "/icecat/releases/%(version)s/update/linux-x86_64/:lang/icecat-%(version)s.complete.mar",
                    "bouncer-platform": "linux64",
                },
                "macosx64": {
                    "path": "/icecat/releases/%(version)s/update/mac/:lang/icecat-%(version)s.complete.mar",
                    "bouncer-platform": "osx",
                },
                "win32": {
                    "path": "/icecat/releases/%(version)s/update/win32/:lang/icecat-%(version)s.complete.mar",
                    "bouncer-platform": "win",
                },
                "win64": {
                    "path": "/icecat/releases/%(version)s/update/win64/:lang/icecat-%(version)s.complete.mar",
                    "bouncer-platform": "win64",
                },
                "opensolaris-i386": {
                    "path": "/icecat/releases/%(version)s/contrib/solaris_tarball/icecat-%(version)s.en-US.opensolaris-i386.complete.mar",
                    "bouncer-platform": "opensolaris-i386",
                },
                "opensolaris-sparc": {
                    "path": "/icecat/releases/%(version)s/contrib/solaris_tarball/icecat-%(version)s.en-US.opensolaris-sparc.complete.mar",
                    "bouncer-platform": "opensolaris-sparc",
                },
                "solaris-i386": {
                    "path": "/icecat/releases/%(version)s/contrib/solaris_tarball/icecat-%(version)s.en-US.solaris-i386.complete.mar",
                    "bouncer-platform": "solaris-i386",
                },
                "solaris-sparc": {
                    "path": "/icecat/releases/%(version)s/contrib/solaris_tarball/icecat-%(version)s.en-US.solaris-sparc.complete.mar",
                    "bouncer-platform": "solaris-sparc",
                },
            },
        },
        "complete-mar-candidates": {
            "product-name": "IceCat-%(version)sbuild%(build_number)s-Complete",
            "check_uptake": False,
            "ssl-only": False,
            "add-locales": True,
            "paths": {
                "linux": {
                    "path": "/icecat/candidates/%(version)s-candidates/build%(build_number)s/update/linux-i686/:lang/icecat-%(version)s.complete.mar",
                    "bouncer-platform": "linux",
                },
                "linux64": {
                    "path": "/icecat/candidates/%(version)s-candidates/build%(build_number)s/update/linux-x86_64/:lang/icecat-%(version)s.complete.mar",
                    "bouncer-platform": "linux64",
                },
                "macosx64": {
                    "path": "/icecat/candidates/%(version)s-candidates/build%(build_number)s/update/mac/:lang/icecat-%(version)s.complete.mar",
                    "bouncer-platform": "osx",
                },
                "win32": {
                    "path": "/icecat/candidates/%(version)s-candidates/build%(build_number)s/update/win32/:lang/icecat-%(version)s.complete.mar",
                    "bouncer-platform": "win",
                },
                "win64": {
                    "path": "/icecat/candidates/%(version)s-candidates/build%(build_number)s/update/win64/:lang/icecat-%(version)s.complete.mar",
                    "bouncer-platform": "win64",
                },
            },
        },
    },
    "partials": {
        "releases-dir": {
            "product-name": "IceCat-%(version)s-Partial-%(prev_version)s",
            "check_uptake": True,
            "ssl-only": False,
            "add-locales": True,
            "paths": {
                "linux": {
                    "path": "/icecat/releases/%(version)s/update/linux-i686/:lang/icecat-%(prev_version)s-%(version)s.partial.mar",
                    "bouncer-platform": "linux",
                },
                "linux64": {
                    "path": "/icecat/releases/%(version)s/update/linux-x86_64/:lang/icecat-%(prev_version)s-%(version)s.partial.mar",
                    "bouncer-platform": "linux64",
                },
                "macosx64": {
                    "path": "/icecat/releases/%(version)s/update/mac/:lang/icecat-%(prev_version)s-%(version)s.partial.mar",
                    "bouncer-platform": "osx",
                },
                "win32": {
                    "path": "/icecat/releases/%(version)s/update/win32/:lang/icecat-%(prev_version)s-%(version)s.partial.mar",
                    "bouncer-platform": "win",
                },
                "win64": {
                    "path": "/icecat/releases/%(version)s/update/win64/:lang/icecat-%(prev_version)s-%(version)s.partial.mar",
                    "bouncer-platform": "win64",
                },
                "opensolaris-i386": {
                    "path": "/icecat/releases/%(version)s/contrib/solaris_tarball/icecat-%(prev_version)s-%(version)s.en-US.opensolaris-i386.partial.mar",
                    "bouncer-platform": "opensolaris-i386",
                },
                "opensolaris-sparc": {
                    "path": "/icecat/releases/%(version)s/contrib/solaris_tarball/icecat-%(prev_version)s-%(version)s.en-US.opensolaris-sparc.partial.mar",
                    "bouncer-platform": "opensolaris-sparc",
                },
                "solaris-i386": {
                    "path": "/icecat/releases/%(version)s/contrib/solaris_tarball/icecat-%(prev_version)s-%(version)s.en-US.solaris-i386.partial.mar",
                    "bouncer-platform": "solaris-i386",
                },
                "solaris-sparc": {
                    "path": "/icecat/releases/%(version)s/contrib/solaris_tarball/icecat-%(prev_version)s-%(version)s.en-US.solaris-sparc.partial.mar",
                    "bouncer-platform": "solaris-sparc",
                },
            },
        },
        "candidates-dir": {
            "product-name": "IceCat-%(version)sbuild%(build_number)s-Partial-%(prev_version)sbuild%(prev_build_number)s",
            "check_uptake": False,
            "ssl-only": False,
            "add-locales": True,
            "paths": {
                "linux": {
                    "path": "/icecat/candidates/%(version)s-candidates/build%(build_number)s/update/linux-i686/:lang/icecat-%(prev_version)s-%(version)s.partial.mar",
                    "bouncer-platform": "linux",
                },
                "linux64": {
                    "path": "/icecat/candidates/%(version)s-candidates/build%(build_number)s/update/linux-x86_64/:lang/icecat-%(prev_version)s-%(version)s.partial.mar",
                    "bouncer-platform": "linux64",
                },
                "macosx64": {
                    "path": "/icecat/candidates/%(version)s-candidates/build%(build_number)s/update/mac/:lang/icecat-%(prev_version)s-%(version)s.partial.mar",
                    "bouncer-platform": "osx",
                },
                "win32": {
                    "path": "/icecat/candidates/%(version)s-candidates/build%(build_number)s/update/win32/:lang/icecat-%(prev_version)s-%(version)s.partial.mar",
                    "bouncer-platform": "win",
                },
                "win64": {
                    "path": "/icecat/candidates/%(version)s-candidates/build%(build_number)s/update/win64/:lang/icecat-%(prev_version)s-%(version)s.partial.mar",
                    "bouncer-platform": "win64",
                },
            },
        },
    },
}
