/*
 * $Id: SerializationTestPrepare.java,v 1.1 1998/10/28 23:11:48 metlov Exp $
 * This tests serialization of expressions.
 *
 * Basically, if the main TestSuite is passing there should not be any
 * problem with expressions serialization.
 *
 * To perform this test first compile and run SerializationTestPrepare
 * which will create serializetest.dat file. Then compile and 
 * run SerializationTestPerform program which will read and evaluate
 * expression from the serializetest.dat file.
 *
 */

package gnu.jel.tests;

import gnu.jel.Library;
import gnu.jel.Evaluator;
import gnu.jel.ExpressionBits;
import gnu.jel.CompilationException;
import java.io.ObjectOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class SerializationTestPrepare {
  public static void main(String[] args) {
    try {
      FileOutputStream fos=new FileOutputStream("serializetest.dat");
      ObjectOutputStream oos=new ObjectOutputStream(fos);
    
      // Set UP Library
      Class[] staticLib=new Class[2];
      Class[] dynamicLib=new Class[1];
      
      staticLib[0]=Class.forName("java.lang.Math");
      VariableProvider tvp=new VariableProvider();
      staticLib[1]=tvp.getClass();
      dynamicLib[0]=tvp.getClass();
      Library lib=new Library(staticLib,dynamicLib);
      lib.markStateDependent("random",null);
      
      // Saving expressions
      
      // with variables
      saveToStream(oos,"2+5+x",lib,null); 
      
      // with constants of type Object
      saveToStream(oos,"makeDoubleObject(5)",lib,null); 

      // with both
      saveToStream(oos,"makeDoubleObject(2-2+x-3)",lib,null);
    
      oos.close();
    } catch(Exception e) {
      System.out.println(e);
    };
  };

  public static void saveToStream(ObjectOutputStream oos,String expr,
			   Library lib,Class restype) 
    throws IOException, CompilationException {
    System.out.print("Compiling : "+expr+"...");
    ExpressionBits eb=Evaluator.compileBits(expr,lib,restype);
    oos.writeObject(eb);
    System.out.println(" done.");
  };
  
};
