/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jline.builtins.Options;
import org.jline.builtins.ScreenTerminal;
import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.reader.ParsedLine;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.LineDisciplineTerminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.Display;
import org.jline.utils.InfoCmp;

public class Tmux {
    public static final String OPT_PREFIX = "prefix";
    public static final String CMD_SEND_PREFIX = "send-prefix";
    public static final String CMD_SPLIT_WINDOW = "split-window";
    public static final String CMD_SELECT_PANE = "select-pane";
    private final AtomicBoolean dirty = new AtomicBoolean(true);
    private final AtomicBoolean resized = new AtomicBoolean(true);
    private final Terminal terminal;
    private final Display display;
    private final PrintStream err;
    private final String term;
    private final Consumer<Terminal> runner;
    private List<VirtualConsole> panes = new ArrayList<VirtualConsole>();
    private VirtualConsole active;
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final Size size = new Size();
    private final AtomicInteger paneId = new AtomicInteger();
    private final Map<String, String> serverOptions = new HashMap<String, String>();
    private final KeyMap<Object> keyMap = new KeyMap();
    private static final Object UNMAPPED = new Object();
    private static final String SCREEN_CAPS = "#\tReconstructed via infocmp from file: /usr/share/terminfo/73/screen\nscreen|VT 100/ANSI X3.64 virtual terminal,\n\tam, km, mir, msgr, xenl,\n\tcolors#8, cols#80, it#8, lines#24, ncv#3, pairs#64,\n\tacsc=++\\,\\,--..00``aaffgghhiijjkkllmmnnooppqqrrssttuuvvwwxxyyzz{{||}}~~,\n\tbel=^G, blink=\\E[5m, bold=\\E[1m, cbt=\\E[Z, civis=\\E[?25l,\n\tclear=\\E[H\\E[J, cnorm=\\E[34h\\E[?25h, cr=^M,\n\tcsr=\\E[%i%p1%d;%p2%dr, cub=\\E[%p1%dD, cub1=^H,\n\tcud=\\E[%p1%dB, cud1=^J, cuf=\\E[%p1%dC, cuf1=\\E[C,\n\tcup=\\E[%i%p1%d;%p2%dH, cuu=\\E[%p1%dA, cuu1=\\EM,\n\tcvvis=\\E[34l, dch=\\E[%p1%dP, dch1=\\E[P, dl=\\E[%p1%dM,\n\tdl1=\\E[M, ed=\\E[J, el=\\E[K, el1=\\E[1K, enacs=\\E(B\\E)0,\n\tflash=\\Eg, home=\\E[H, ht=^I, hts=\\EH, ich=\\E[%p1%d@,\n\til=\\E[%p1%dL, il1=\\E[L, ind=^J, is2=\\E)0, kbs=^H, kcbt=\\E[Z,\n\tkcub1=\\EOD, kcud1=\\EOB, kcuf1=\\EOC, kcuu1=\\EOA,\n\tkdch1=\\E[3~, kend=\\E[4~, kf1=\\EOP, kf10=\\E[21~,\n\tkf11=\\E[23~, kf12=\\E[24~, kf2=\\EOQ, kf3=\\EOR, kf4=\\EOS,\n\tkf5=\\E[15~, kf6=\\E[17~, kf7=\\E[18~, kf8=\\E[19~, kf9=\\E[20~,\n\tkhome=\\E[1~, kich1=\\E[2~, kmous=\\E[M, knp=\\E[6~, kpp=\\E[5~,\n\tnel=\\EE, op=\\E[39;49m, rc=\\E8, rev=\\E[7m, ri=\\EM, rmacs=^O,\n\trmcup=\\E[?1049l, rmir=\\E[4l, rmkx=\\E[?1l\\E>, rmso=\\E[23m,\n\trmul=\\E[24m, rs2=\\Ec\\E[?1000l\\E[?25h, sc=\\E7,\n\tsetab=\\E[4%p1%dm, setaf=\\E[3%p1%dm,\n\tsgr=\\E[0%?%p6%t;1%;%?%p1%t;3%;%?%p2%t;4%;%?%p3%t;7%;%?%p4%t;5%;m%?%p9%t\\016%e\\017%;,\n\tsgr0=\\E[m\\017, smacs=^N, smcup=\\E[?1049h, smir=\\E[4h,\n\tsmkx=\\E[?1h\\E=, smso=\\E[3m, smul=\\E[4m, tbc=\\E[3g,\n";
    private static final String SCREEN_256COLOR_CAPS = "#\tReconstructed via infocmp from file: /usr/share/terminfo/73/screen-256color\nscreen-256color|GNU Screen with 256 colors,\n\tam, km, mir, msgr, xenl,\n\tcolors#256, cols#80, it#8, lines#24, ncv#3, pairs#32767,\n\tacsc=++\\,\\,--..00``aaffgghhiijjkkllmmnnooppqqrrssttuuvvwwxxyyzz{{||}}~~,\n\tbel=^G, blink=\\E[5m, bold=\\E[1m, cbt=\\E[Z, civis=\\E[?25l,\n\tclear=\\E[H\\E[J, cnorm=\\E[34h\\E[?25h, cr=^M,\n\tcsr=\\E[%i%p1%d;%p2%dr, cub=\\E[%p1%dD, cub1=^H,\n\tcud=\\E[%p1%dB, cud1=^J, cuf=\\E[%p1%dC, cuf1=\\E[C,\n\tcup=\\E[%i%p1%d;%p2%dH, cuu=\\E[%p1%dA, cuu1=\\EM,\n\tcvvis=\\E[34l, dch=\\E[%p1%dP, dch1=\\E[P, dl=\\E[%p1%dM,\n\tdl1=\\E[M, ed=\\E[J, el=\\E[K, el1=\\E[1K, enacs=\\E(B\\E)0,\n\tflash=\\Eg, home=\\E[H, ht=^I, hts=\\EH, ich=\\E[%p1%d@,\n\til=\\E[%p1%dL, il1=\\E[L, ind=^J, initc@, is2=\\E)0, kbs=^H,\n\tkcbt=\\E[Z, kcub1=\\EOD, kcud1=\\EOB, kcuf1=\\EOC, kcuu1=\\EOA,\n\tkdch1=\\E[3~, kend=\\E[4~, kf1=\\EOP, kf10=\\E[21~,\n\tkf11=\\E[23~, kf12=\\E[24~, kf2=\\EOQ, kf3=\\EOR, kf4=\\EOS,\n\tkf5=\\E[15~, kf6=\\E[17~, kf7=\\E[18~, kf8=\\E[19~, kf9=\\E[20~,\n\tkhome=\\E[1~, kich1=\\E[2~, kmous=\\E[M, knp=\\E[6~, kpp=\\E[5~,\n\tnel=\\EE, op=\\E[39;49m, rc=\\E8, rev=\\E[7m, ri=\\EM, rmacs=^O,\n\trmcup=\\E[?1049l, rmir=\\E[4l, rmkx=\\E[?1l\\E>, rmso=\\E[23m,\n\trmul=\\E[24m, rs2=\\Ec\\E[?1000l\\E[?25h, sc=\\E7,\n\tsetab=\\E[%?%p1%{8}%<%t4%p1%d%e%p1%{16}%<%t10%p1%{8}%-%d%e48;5;%p1%d%;m,\n\tsetaf=\\E[%?%p1%{8}%<%t3%p1%d%e%p1%{16}%<%t9%p1%{8}%-%d%e38;5;%p1%d%;m,\n\tsgr=\\E[0%?%p6%t;1%;%?%p1%t;3%;%?%p2%t;4%;%?%p3%t;7%;%?%p4%t;5%;m%?%p9%t\\016%e\\017%;,\n\tsgr0=\\E[m\\017, smacs=^N, smcup=\\E[?1049h, smir=\\E[4h,\n\tsmkx=\\E[?1h\\E=, smso=\\E[3m, smul=\\E[4m, tbc=\\E[3g,\n";

    public Tmux(Terminal terminal, PrintStream err, Consumer<Terminal> runner) throws IOException {
        InfoCmp.setDefaultInfoCmp("screen", SCREEN_CAPS);
        InfoCmp.setDefaultInfoCmp("screen-256color", SCREEN_256COLOR_CAPS);
        this.terminal = terminal;
        this.err = err;
        this.runner = runner;
        this.display = new Display(terminal, true);
        Integer colors = terminal.getNumericCapability(InfoCmp.Capability.max_colors);
        this.term = colors != null && colors >= 256 ? "screen-256color" : "screen";
        this.serverOptions.put(OPT_PREFIX, "`");
        this.keyMap.setUnicode(UNMAPPED);
        this.keyMap.bind(UNMAPPED, KeyMap.range("^@-^?"));
        this.keyMap.bind((Object)CMD_SEND_PREFIX, (CharSequence)this.serverOptions.get(OPT_PREFIX));
        this.keyMap.bind((Object)CMD_SEND_PREFIX, (CharSequence)this.serverOptions.get(OPT_PREFIX));
        this.keyMap.bind((Object)CMD_SPLIT_WINDOW, (CharSequence)"\"");
        this.keyMap.bind((Object)"split-window -h", (CharSequence)"%");
        this.keyMap.bind((Object)"select-pane -U", (CharSequence)KeyMap.key(terminal, InfoCmp.Capability.key_up));
        this.keyMap.bind((Object)"select-pane -L", (CharSequence)KeyMap.key(terminal, InfoCmp.Capability.key_left));
        this.keyMap.bind((Object)"select-pane -R", (CharSequence)KeyMap.key(terminal, InfoCmp.Capability.key_right));
        this.keyMap.bind((Object)"select-pane -D", (CharSequence)KeyMap.key(terminal, InfoCmp.Capability.key_down));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        Terminal.SignalHandler prevWinchHandler = this.terminal.handle(Terminal.Signal.WINCH, this::resize);
        Terminal.SignalHandler prevIntHandler = this.terminal.handle(Terminal.Signal.INT, this::interrupt);
        Terminal.SignalHandler prevSuspHandler = this.terminal.handle(Terminal.Signal.TSTP, this::suspend);
        Attributes attributes = this.terminal.enterRawMode();
        this.terminal.puts(InfoCmp.Capability.enter_ca_mode, new Object[0]);
        this.terminal.puts(InfoCmp.Capability.keypad_xmit, new Object[0]);
        this.terminal.flush();
        try {
            this.size.copy(this.terminal.getSize());
            this.active = new VirtualConsole(this.getNewPaneName(), this.term, 0, 0, this.size.getColumns(), this.size.getRows() - 1, this::setDirty, this::close);
            this.active.getConsole().setAttributes(this.terminal.getAttributes());
            this.panes.add(this.active);
            this.runner.accept(this.active.getConsole());
            new Thread(this::inputLoop, "Mux input loop").start();
            this.redrawLoop();
        }
        finally {
            this.terminal.puts(InfoCmp.Capability.keypad_local, new Object[0]);
            this.terminal.puts(InfoCmp.Capability.exit_ca_mode, new Object[0]);
            this.terminal.flush();
            this.terminal.setAttributes(attributes);
            this.terminal.handle(Terminal.Signal.WINCH, prevWinchHandler);
            this.terminal.handle(Terminal.Signal.INT, prevIntHandler);
            this.terminal.handle(Terminal.Signal.TSTP, prevSuspHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redrawLoop() {
        while (this.running.get()) {
            try {
                AtomicBoolean atomicBoolean = this.dirty;
                synchronized (atomicBoolean) {
                    while (this.running.get() && !this.dirty.compareAndSet(true, false)) {
                        this.dirty.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.resized.compareAndSet(true, false)) {
                this.handleResize();
            }
            this.redraw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDirty() {
        AtomicBoolean atomicBoolean = this.dirty;
        synchronized (atomicBoolean) {
            this.dirty.set(true);
            this.dirty.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void inputLoop() {
        try {
            int c;
            while ((c = this.terminal.reader().read()) >= 0) {
                String pfx = this.serverOptions.get(OPT_PREFIX);
                if (pfx != null && c == pfx.charAt(0)) {
                    Object b = new BindingReader(this.terminal.reader()).readBinding(this.keyMap);
                    if (!(b instanceof String)) continue;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    ByteArrayOutputStream err = new ByteArrayOutputStream();
                    try {
                        PrintStream pout = new PrintStream(out);
                        Throwable throwable = null;
                        try {
                            PrintStream perr = new PrintStream(err);
                            Throwable throwable2 = null;
                            try {
                                this.execute(pout, perr, (String)b);
                                continue;
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (perr == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        perr.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                perr.close();
                                continue;
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (pout == null) continue;
                            if (throwable != null) {
                                try {
                                    pout.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            pout.close();
                            continue;
                        }
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                String s = new String(Character.toChars(c));
                this.active.getMasterInputOutput().write(s.getBytes());
                this.active.getMasterInputOutput().flush();
            }
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        finally {
            this.running.set(false);
            this.setDirty();
        }
    }

    private synchronized void close(VirtualConsole terminal) {
        int idx = this.panes.indexOf(terminal);
        if (idx >= 0) {
            this.panes.remove(idx);
            if (this.panes.isEmpty()) {
                this.running.set(false);
                this.setDirty();
            } else {
                if (this.active == terminal) {
                    this.active = this.panes.get(Math.max(0, idx - 1));
                }
                this.resize(Terminal.Signal.WINCH);
            }
        }
    }

    private void resize(Terminal.Signal signal) {
        this.resized.set(true);
        this.setDirty();
    }

    private void interrupt(Terminal.Signal signal) {
        this.active.getConsole().raise(signal);
    }

    private void suspend(Terminal.Signal signal) {
        this.active.getConsole().raise(signal);
    }

    private void handleResize() {
        this.size.copy(this.terminal.getSize());
        int nbPanes = this.panes.size();
        int nbRows = 1;
        while (nbRows * nbRows < nbPanes) {
            ++nbRows;
        }
        int nbCols = (nbPanes + nbRows - 1) / nbRows;
        int width = this.size.getColumns();
        int height = this.size.getRows() - 1;
        int colWidth = (width - nbCols + 1) / nbCols;
        int rowHeight = (height - nbRows + 1) / nbRows;
        for (int pane = 0; pane < nbPanes; ++pane) {
            VirtualConsole terminal = this.panes.get(pane);
            int i = pane % nbCols;
            int j = pane / nbCols;
            int l = i * colWidth + i;
            int w = i == nbCols - 1 || pane == nbPanes - 1 ? width - l : colWidth;
            int t = j * rowHeight + j;
            int h = j == nbRows - 1 || pane == nbPanes - 1 ? height - t : rowHeight;
            terminal.resize(l, t, w, h);
        }
        this.display.clear();
    }

    public void execute(PrintStream out, PrintStream err, String command) throws Exception {
        ParsedLine line = new DefaultParser().parse(command.trim(), 0);
        this.execute(out, err, line.words());
    }

    public synchronized void execute(PrintStream out, PrintStream err, List<String> command) throws Exception {
        String name = command.get(0);
        List<String> args = command.subList(1, command.size());
        switch (name) {
            case "send-prefix": {
                this.sendPrefix(out, err, args);
                break;
            }
            case "split-window": {
                this.splitWindow(out, err, args);
                break;
            }
            case "select-pane": {
                this.selectPane(out, err, args);
            }
        }
    }

    protected void selectPane(PrintStream out, PrintStream err, List<String> args) throws IOException {
        String[] usage = new String[]{"select-pane - ", "Usage: select-pane [-UDLR] [-t target-pane]", "  -? --help                    Show help", "  -U                           Select pane up", "  -D                           Select pane down", "  -L                           Select pane left", "  -R                           Select pane right"};
        Options opt = Options.compile(usage).parse(args);
        if (opt.isSet("help")) {
            opt.usage(err);
            return;
        }
        VirtualConsole prevActive = this.active;
        if (opt.isSet("L")) {
            int idx = this.panes.indexOf(this.active);
            this.active = this.panes.get((idx + this.panes.size() - 1) % this.panes.size());
        } else if (opt.isSet("R")) {
            int idx = this.panes.indexOf(this.active);
            this.active = this.panes.get((idx + 1) % this.panes.size());
        }
        if (prevActive != this.active) {
            this.setDirty();
        }
    }

    protected void sendPrefix(PrintStream out, PrintStream err, List<String> args) throws IOException {
        String[] usage = new String[]{"send-prefix - ", "Usage: send-prefix [-2] [-t target-pane]", "  -? --help                    Show help"};
        Options opt = Options.compile(usage).parse(args);
        if (opt.isSet("help")) {
            opt.usage(err);
            return;
        }
        this.active.getMasterInputOutput().write(this.serverOptions.get(OPT_PREFIX).getBytes());
    }

    protected void splitWindow(PrintStream out, PrintStream err, List<String> args) throws IOException {
        String[] usage = new String[]{"split-window - ", "Usage: split-window [-bdhvP] [-c start-directory] [-F format] [-p percentage|-l size] [-t target-pane] [command]", "  -? --help                    Show help", "  -h                           Horizontal split", "  -v                           Vertical split"};
        Options opt = Options.compile(usage).parse(args);
        if (opt.isSet("help")) {
            opt.usage(err);
            return;
        }
        VirtualConsole target = this.active;
        if (opt.isSet("h")) {
            int l0 = target.getLeft();
            int t0 = target.getTop();
            int w0 = target.getWidth();
            int h0 = target.getHeight();
            int l1 = l0;
            int w1 = (w0 - 1) / 2;
            int l2 = l1 + w1 + 1;
            int w2 = l0 + w0 - l2;
            target.resize(l1, t0, w1, h0);
            this.active = new VirtualConsole(this.getNewPaneName(), this.term, l2, t0, w2, h0, this::setDirty, this::close);
            this.active.getConsole().setAttributes(this.terminal.getAttributes());
            this.panes.add(this.panes.indexOf(target) + 1, this.active);
            this.runner.accept(this.active.getConsole());
        } else {
            int l0 = target.getLeft();
            int t0 = target.getTop();
            int w0 = target.getWidth();
            int h0 = target.getHeight();
            int t1 = t0;
            int h1 = (h0 - 1) / 2;
            int t2 = t1 + h1 + 1;
            int h2 = t0 + h0 - t2;
            target.resize(l0, t1, w0, h1);
            this.active = new VirtualConsole(this.getNewPaneName(), this.term, l0, t2, w0, h2, this::setDirty, this::close);
            this.active.getConsole().setAttributes(this.terminal.getAttributes());
            this.panes.add(this.panes.indexOf(target) + 1, this.active);
            this.runner.accept(this.active.getConsole());
        }
    }

    protected synchronized void redraw() {
        int[] screen = new int[this.size.getRows() * this.size.getColumns()];
        Arrays.fill(screen, 0xFF0020);
        int[] cursor = new int[2];
        for (VirtualConsole terminal : this.panes) {
            terminal.dump(screen, terminal.getTop(), terminal.getLeft(), this.size.getRows(), this.size.getColumns(), (int[])(terminal == this.active ? cursor : null));
            this.drawBorder(screen, this.size, terminal, 0xFF0000);
        }
        this.drawBorder(screen, this.size, this.active, 0x2F0000);
        Arrays.fill(screen, (this.size.getRows() - 1) * this.size.getColumns(), this.size.getRows() * this.size.getColumns(), 0xF20020);
        ArrayList<AttributedString> lines = new ArrayList<AttributedString>();
        int prevBg = 15;
        int prevFg = 15;
        boolean prevInv = false;
        boolean prevUl = false;
        boolean prevBold = false;
        boolean prevConceal = false;
        boolean prevFgBright = false;
        boolean prevBgBright = false;
        for (int y = 0; y < this.size.getRows(); ++y) {
            AttributedStringBuilder sb = new AttributedStringBuilder(this.size.getColumns());
            for (int x = 0; x < this.size.getColumns(); ++x) {
                boolean bgBright;
                int d = screen[y * this.size.getColumns() + x];
                int c = d & 0xFFFF;
                int a = d >> 16;
                int bg = a & 0xF;
                int fg = (a & 0xF0) >> 4;
                boolean inv = (a & 0x200) != 0;
                boolean ul = (a & 0x100) != 0;
                boolean bold = (a & 0x800) != 0;
                boolean conceal = (a & 0x400) != 0;
                boolean fgBright = (a & 0x1000) != 0;
                boolean bl = bgBright = (a & 0x2000) != 0;
                if (bg != prevBg || prevBgBright != bgBright) {
                    if (bg == 15) {
                        sb.style(sb.style().backgroundDefault());
                    } else {
                        sb.style(sb.style().background(bg + (bgBright ? 8 : 0)));
                    }
                    prevBg = bg;
                    prevBgBright = bgBright;
                }
                if (fg != prevFg || fgBright != prevFgBright) {
                    if (fg == 15) {
                        sb.style(sb.style().foregroundDefault());
                    } else {
                        sb.style(sb.style().foreground(fg + (fgBright ? 8 : 0)));
                    }
                    prevFg = fg;
                    prevFgBright = fgBright;
                }
                if (conceal != prevConceal) {
                    sb.style(conceal ? sb.style().conceal() : sb.style().concealOff());
                    prevConceal = conceal;
                }
                if (inv != prevInv) {
                    sb.style(conceal ? sb.style().inverse() : sb.style().inverseOff());
                    prevInv = inv;
                }
                if (ul != prevUl) {
                    sb.style(conceal ? sb.style().underline() : sb.style().underlineOff());
                    prevUl = ul;
                }
                if (bold != prevBold) {
                    sb.style(conceal ? sb.style().bold() : sb.style().boldOff());
                    prevBold = bold;
                }
                sb.append((char)c);
            }
            lines.add(sb.toAttributedString());
        }
        this.display.resize(this.size.getRows(), this.size.getColumns());
        this.display.update(lines, cursor[1] * this.size.getColumns() + cursor[0]);
        this.terminal.flush();
    }

    private void drawBorder(int[] screen, Size size, VirtualConsole terminal, int attr) {
        int i;
        for (i = terminal.getLeft(); i < terminal.getLeft() + terminal.getWidth(); ++i) {
            int y0 = terminal.getTop() - 1;
            int y1 = terminal.getTop() + terminal.getHeight();
            this.drawBorderChar(screen, size, i, y0, attr, 9472);
            this.drawBorderChar(screen, size, i, y1, attr, 9472);
        }
        for (i = terminal.getTop(); i < terminal.getTop() + terminal.getHeight(); ++i) {
            int x0 = terminal.getLeft() - 1;
            int x1 = terminal.getLeft() + terminal.getWidth();
            this.drawBorderChar(screen, size, x0, i, attr, 9474);
            this.drawBorderChar(screen, size, x1, i, attr, 9474);
        }
        this.drawBorderChar(screen, size, terminal.getLeft() - 1, terminal.getTop() - 1, attr, 9532);
        this.drawBorderChar(screen, size, terminal.getLeft() + terminal.getWidth(), terminal.getTop() - 1, attr, 9532);
        this.drawBorderChar(screen, size, terminal.getLeft() - 1, terminal.getTop() + terminal.getHeight(), attr, 9532);
        this.drawBorderChar(screen, size, terminal.getLeft() + terminal.getWidth(), terminal.getTop() + terminal.getHeight(), attr, 9532);
    }

    private void drawBorderChar(int[] screen, Size size, int x, int y, int attr, int c) {
        if (x >= 0 && x < size.getColumns() && y >= 0 && y < size.getRows() - 1) {
            screen[y * size.getColumns() + x] = attr | c;
        }
    }

    private String getNewPaneName() {
        return String.format("tmux%02d", this.paneId.incrementAndGet());
    }

    private static class VirtualConsole
    implements Closeable {
        private final ScreenTerminal terminal;
        private final Consumer<VirtualConsole> closer;
        private int left;
        private int top;
        private final OutputStream masterOutput;
        private final OutputStream masterInputOutput;
        private final LineDisciplineTerminal console;

        public VirtualConsole(String name, String type, int left, int top, int columns, int rows, final Runnable dirty, Consumer<VirtualConsole> closer) throws IOException {
            this.left = left;
            this.top = top;
            this.closer = closer;
            this.terminal = new ScreenTerminal(columns, rows){

                @Override
                protected void setDirty() {
                    super.setDirty();
                    dirty.run();
                }
            };
            this.masterOutput = new MasterOutputStream();
            this.masterInputOutput = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    console.processInputByte(b);
                }
            };
            this.console = new LineDisciplineTerminal(name, type, this.masterOutput, Charset.defaultCharset().name());
            this.console.setSize(new Size(columns, rows));
        }

        public int getLeft() {
            return this.left;
        }

        public int getTop() {
            return this.top;
        }

        public int getWidth() {
            return this.console.getWidth();
        }

        public int getHeight() {
            return this.console.getHeight();
        }

        public LineDisciplineTerminal getConsole() {
            return this.console;
        }

        public OutputStream getMasterInputOutput() {
            return this.masterInputOutput;
        }

        public void resize(int left, int top, int width, int height) {
            this.left = left;
            this.top = top;
            this.console.setSize(new Size(width, height));
            this.terminal.setSize(width, height);
            this.console.raise(Terminal.Signal.WINCH);
        }

        public void dump(int[] fullscreen, int ftop, int fleft, int fheight, int fwidth, int[] cursor) {
            this.terminal.dump(fullscreen, ftop, fleft, fheight, fwidth, cursor);
        }

        @Override
        public void close() throws IOException {
            this.console.close();
            this.closer.accept(this);
        }

        private class MasterOutputStream
        extends OutputStream {
            private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

            private MasterOutputStream() {
            }

            @Override
            public synchronized void write(int b) {
                this.buffer.write(b);
            }

            @Override
            public synchronized void flush() throws IOException {
                VirtualConsole.this.terminal.write(this.buffer.toString());
                VirtualConsole.this.masterInputOutput.write(VirtualConsole.this.terminal.read().getBytes());
                this.buffer.reset();
            }

            @Override
            public void close() throws IOException {
                this.flush();
            }
        }
    }
}

