/*
 A JavaScript implementation of the SHA family of hashes, as
 defined in FIPS PUB 180-4 and FIPS PUB 202, as well as the corresponding
 HMAC implementation as defined in FIPS PUB 198a

 Copyright 2008-2020 Brian Turek, 1998-2009 Paul Johnston & Contributors
 Distributed under the BSD License
 See http://caligatio.github.com/jsSHA/ for more information
*/
'use strict';(function(aa){function C(e,b,a){var k=0,h=[],l=0,g,m,c,f,n,q,u,r,I=!1,v=[],x=[],t,y=!1,z=!1,w=-1;a=a||{};g=a.encoding||"UTF8";t=a.numRounds||1;if(t!==parseInt(t,10)||1>t)throw Error("numRounds must a integer >= 1");if("SHA-1"===e)n=512,q=K,u=ba,f=160,r=function(b){return b.slice()};else if(0===e.lastIndexOf("SHA-",0))if(q=function(b,k){return L(b,k,e)},u=function(b,k,h,a){var d,f;if("SHA-224"===e||"SHA-256"===e)d=(k+65>>>9<<4)+15,f=16;else if("SHA-384"===e||"SHA-512"===e)d=(k+129>>>10<<
5)+31,f=32;else throw Error("Unexpected error in SHA-2 implementation");for(;b.length<=d;)b.push(0);b[k>>>5]|=128<<24-k%32;k=k+h;b[d]=k&4294967295;b[d-1]=k/4294967296|0;h=b.length;for(k=0;k<h;k+=f)a=L(b.slice(k,k+f),a,e);if("SHA-224"===e)b=[a[0],a[1],a[2],a[3],a[4],a[5],a[6]];else if("SHA-256"===e)b=a;else if("SHA-384"===e)b=[a[0].a,a[0].b,a[1].a,a[1].b,a[2].a,a[2].b,a[3].a,a[3].b,a[4].a,a[4].b,a[5].a,a[5].b];else if("SHA-512"===e)b=[a[0].a,a[0].b,a[1].a,a[1].b,a[2].a,a[2].b,a[3].a,a[3].b,a[4].a,
a[4].b,a[5].a,a[5].b,a[6].a,a[6].b,a[7].a,a[7].b];else throw Error("Unexpected error in SHA-2 implementation");return b},r=function(b){return b.slice()},"SHA-224"===e)n=512,f=224;else if("SHA-256"===e)n=512,f=256;else if("SHA-384"===e)n=1024,f=384;else if("SHA-512"===e)n=1024,f=512;else throw Error("Chosen SHA variant is not supported");else if(0===e.lastIndexOf("SHA3-",0)||0===e.lastIndexOf("SHAKE",0)){var F=6;q=D;r=function(b){var e=[],a;for(a=0;5>a;a+=1)e[a]=b[a].slice();return e};w=1;if("SHA3-224"===
e)n=1152,f=224;else if("SHA3-256"===e)n=1088,f=256;else if("SHA3-384"===e)n=832,f=384;else if("SHA3-512"===e)n=576,f=512;else if("SHAKE128"===e)n=1344,f=-1,F=31,z=!0;else if("SHAKE256"===e)n=1088,f=-1,F=31,z=!0;else throw Error("Chosen SHA variant is not supported");u=function(b,e,a,k,h){a=n;var d=F,f,g=[],l=a>>>5,m=0,c=e>>>5;for(f=0;f<c&&e>=a;f+=l)k=D(b.slice(f,f+l),k),e-=a;b=b.slice(f);for(e%=a;b.length<l;)b.push(0);f=e>>>3;b[f>>2]^=d<<f%4*8;b[l-1]^=2147483648;for(k=D(b,k);32*g.length<h;){b=k[m%
5][m/5|0];g.push(b.b);if(32*g.length>=h)break;g.push(b.a);m+=1;0===64*m%a&&D(null,k)}return g}}else throw Error("Chosen SHA variant is not supported");c=M(b,g,w);m=A(e);this.setHMACKey=function(b,a,h){var d;if(!0===I)throw Error("HMAC key already set");if(!0===y)throw Error("Cannot set HMAC key after calling update");if(!0===z)throw Error("SHAKE is not supported for HMAC");g=(h||{}).encoding||"UTF8";a=M(a,g,w)(b);b=a.binLen;a=a.value;d=n>>>3;h=d/4-1;if(d<b/8){for(a=u(a,b,0,A(e),f);a.length<=h;)a.push(0);
a[h]&=4294967040}else if(d>b/8){for(;a.length<=h;)a.push(0);a[h]&=4294967040}for(b=0;b<=h;b+=1)v[b]=a[b]^909522486,x[b]=a[b]^1549556828;m=q(v,m);k=n;I=!0};this.update=function(b){var a,e,d,f=0,g=n>>>5;a=c(b,h,l);b=a.binLen;e=a.value;a=b>>>5;for(d=0;d<a;d+=g)f+n<=b&&(m=q(e.slice(d,d+g),m),f+=n);k+=f;h=e.slice(f>>>5);l=b%n;y=!0};this.getHash=function(b,a){var d,g,c,n;if(!0===I)throw Error("Cannot call getHash after setting HMAC key");c=N(a);if(!0===z){if(-1===c.shakeLen)throw Error("shakeLen must be specified in options");
f=c.shakeLen}switch(b){case "HEX":d=function(b){return O(b,f,w,c)};break;case "B64":d=function(b){return P(b,f,w,c)};break;case "BYTES":d=function(b){return Q(b,f,w)};break;case "ARRAYBUFFER":try{g=new ArrayBuffer(0)}catch(p){throw Error("ARRAYBUFFER not supported by this environment");}d=function(b){return R(b,f,w)};break;case "UINT8ARRAY":try{g=new Uint8Array(0)}catch(p){throw Error("UINT8ARRAY not supported by this environment");}d=function(b){return S(b,f,w)};break;default:throw Error("format must be HEX, B64, BYTES, ARRAYBUFFER, or UINT8ARRAY");
}n=u(h.slice(),l,k,r(m),f);for(g=1;g<t;g+=1)!0===z&&0!==f%32&&(n[n.length-1]&=16777215>>>24-f%32),n=u(n,f,0,A(e),f);return d(n)};this.getHMAC=function(b,a){var d,g,c,p;if(!1===I)throw Error("Cannot call getHMAC without first setting HMAC key");c=N(a);switch(b){case "HEX":d=function(b){return O(b,f,w,c)};break;case "B64":d=function(b){return P(b,f,w,c)};break;case "BYTES":d=function(b){return Q(b,f,w)};break;case "ARRAYBUFFER":try{d=new ArrayBuffer(0)}catch(v){throw Error("ARRAYBUFFER not supported by this environment");
}d=function(b){return R(b,f,w)};break;case "UINT8ARRAY":try{d=new Uint8Array(0)}catch(v){throw Error("UINT8ARRAY not supported by this environment");}d=function(b){return S(b,f,w)};break;default:throw Error("outputFormat must be HEX, B64, BYTES, ARRAYBUFFER, or UINT8ARRAY");}g=u(h.slice(),l,k,r(m),f);p=q(x,A(e));p=u(g,f,n,p,f);return d(p)}}function a(a,b){this.a=a;this.b=b}function T(a,b,d,k){var h,l,g,c,p;b=b||[0];d=d||0;l=d>>>3;p=-1===k?3:0;for(h=0;h<a.length;h+=1)c=h+l,g=c>>>2,b.length<=g&&b.push(0),
b[g]|=a[h]<<8*(p+c%4*k);return{value:b,binLen:8*a.length+d}}function O(a,b,d,k){var h="";b/=8;var l,g,c;c=-1===d?3:0;for(l=0;l<b;l+=1)g=a[l>>>2]>>>8*(c+l%4*d),h+="0123456789abcdef".charAt(g>>>4&15)+"0123456789abcdef".charAt(g&15);return k.outputUpper?h.toUpperCase():h}function P(a,b,d,k){var h="",l=b/8,g,c,p,f;f=-1===d?3:0;for(g=0;g<l;g+=3)for(c=g+1<l?a[g+1>>>2]:0,p=g+2<l?a[g+2>>>2]:0,p=(a[g>>>2]>>>8*(f+g%4*d)&255)<<16|(c>>>8*(f+(g+1)%4*d)&255)<<8|p>>>8*(f+(g+2)%4*d)&255,c=0;4>c;c+=1)8*g+6*c<=b?h+=
"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(p>>>6*(3-c)&63):h+=k.b64Pad;return h}function Q(a,b,d){var k="";b/=8;var h,c,g;g=-1===d?3:0;for(h=0;h<b;h+=1)c=a[h>>>2]>>>8*(g+h%4*d)&255,k+=String.fromCharCode(c);return k}function R(a,b,d){b/=8;var k,h=new ArrayBuffer(b),c,g;g=new Uint8Array(h);c=-1===d?3:0;for(k=0;k<b;k+=1)g[k]=a[k>>>2]>>>8*(c+k%4*d)&255;return h}function S(a,b,d){b/=8;var k,h=new Uint8Array(b),c;c=-1===d?3:0;for(k=0;k<b;k+=1)h[k]=a[k>>>2]>>>8*(c+k%4*d)&
255;return h}function N(a){var b={outputUpper:!1,b64Pad:"=",shakeLen:-1};a=a||{};b.outputUpper=a.outputUpper||!1;!0===a.hasOwnProperty("b64Pad")&&(b.b64Pad=a.b64Pad);if(!0===a.hasOwnProperty("shakeLen")){if(0!==a.shakeLen%8)throw Error("shakeLen must be a multiple of 8");b.shakeLen=a.shakeLen}if("boolean"!==typeof b.outputUpper)throw Error("Invalid outputUpper formatting option");if("string"!==typeof b.b64Pad)throw Error("Invalid b64Pad formatting option");return b}function M(a,b,d){switch(b){case "UTF8":case "UTF16BE":case "UTF16LE":break;
default:throw Error("encoding must be UTF8, UTF16BE, or UTF16LE");}switch(a){case "HEX":a=function(b,a,e){var g=b.length,c,p,f,n,q,u;if(0!==g%2)throw Error("String of HEX type must be in byte increments");a=a||[0];e=e||0;q=e>>>3;u=-1===d?3:0;for(c=0;c<g;c+=2){p=parseInt(b.substr(c,2),16);if(isNaN(p))throw Error("String of HEX type contains invalid characters");n=(c>>>1)+q;for(f=n>>>2;a.length<=f;)a.push(0);a[f]|=p<<8*(u+n%4*d)}return{value:a,binLen:4*g+e}};break;case "TEXT":a=function(a,e,c){var g,
m,p=0,f,n,q,u,r,t;e=e||[0];c=c||0;q=c>>>3;if("UTF8"===b)for(t=-1===d?3:0,f=0;f<a.length;f+=1)for(g=a.charCodeAt(f),m=[],128>g?m.push(g):2048>g?(m.push(192|g>>>6),m.push(128|g&63)):55296>g||57344<=g?m.push(224|g>>>12,128|g>>>6&63,128|g&63):(f+=1,g=65536+((g&1023)<<10|a.charCodeAt(f)&1023),m.push(240|g>>>18,128|g>>>12&63,128|g>>>6&63,128|g&63)),n=0;n<m.length;n+=1){r=p+q;for(u=r>>>2;e.length<=u;)e.push(0);e[u]|=m[n]<<8*(t+r%4*d);p+=1}else if("UTF16BE"===b||"UTF16LE"===b)for(t=-1===d?2:0,m="UTF16LE"===
b&&1!==d||"UTF16LE"!==b&&1===d,f=0;f<a.length;f+=1){g=a.charCodeAt(f);!0===m&&(n=g&255,g=n<<8|g>>>8);r=p+q;for(u=r>>>2;e.length<=u;)e.push(0);e[u]|=g<<8*(t+r%4*d);p+=2}return{value:e,binLen:8*p+c}};break;case "B64":a=function(b,a,e){var c=0,m,p,f,n,q,u,r,t;if(-1===b.search(/^[a-zA-Z0-9=+\/]+$/))throw Error("Invalid character in base-64 string");p=b.indexOf("=");b=b.replace(/\=/g,"");if(-1!==p&&p<b.length)throw Error("Invalid '=' found in base-64 string");a=a||[0];e=e||0;u=e>>>3;t=-1===d?3:0;for(p=
0;p<b.length;p+=4){q=b.substr(p,4);for(f=n=0;f<q.length;f+=1)m="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".indexOf(q.charAt(f)),n|=m<<18-6*f;for(f=0;f<q.length-1;f+=1){r=c+u;for(m=r>>>2;a.length<=m;)a.push(0);a[m]|=(n>>>16-8*f&255)<<8*(t+r%4*d);c+=1}}return{value:a,binLen:8*c+e}};break;case "BYTES":a=function(b,a,e){var c,m,p,f,n,q;a=a||[0];e=e||0;p=e>>>3;q=-1===d?3:0;for(m=0;m<b.length;m+=1)c=b.charCodeAt(m),n=m+p,f=n>>>2,a.length<=f&&a.push(0),a[f]|=c<<8*(q+n%4*d);return{value:a,
binLen:8*b.length+e}};break;case "ARRAYBUFFER":try{a=new ArrayBuffer(0)}catch(k){throw Error("ARRAYBUFFER not supported by this environment");}a=function(b,a,e){return T(new Uint8Array(b),a,e,d)};break;case "UINT8ARRAY":try{a=new Uint8Array(0)}catch(k){throw Error("UINT8ARRAY not supported by this environment");}a=function(b,a,e){return T(b,a,e,d)};break;default:throw Error("format must be HEX, TEXT, B64, BYTES, ARRAYBUFFER, or UINT8ARRAY");}return a}function y(a,b){return a<<b|a>>>32-b}function U(e,
b){return 32<b?(b-=32,new a(e.b<<b|e.a>>>32-b,e.a<<b|e.b>>>32-b)):0!==b?new a(e.a<<b|e.b>>>32-b,e.b<<b|e.a>>>32-b):e}function x(a,b){return a>>>b|a<<32-b}function t(e,b){var d=null,d=new a(e.a,e.b);return d=32>=b?new a(d.a>>>b|d.b<<32-b&4294967295,d.b>>>b|d.a<<32-b&4294967295):new a(d.b>>>b-32|d.a<<64-b&4294967295,d.a>>>b-32|d.b<<64-b&4294967295)}function V(e,b){var d=null;return d=32>=b?new a(e.a>>>b,e.b>>>b|e.a<<32-b&4294967295):new a(0,e.a>>>b-32)}function ca(a,b,d){return a&b^~a&d}function da(e,
b,d){return new a(e.a&b.a^~e.a&d.a,e.b&b.b^~e.b&d.b)}function W(a,b,d){return a&b^a&d^b&d}function ea(e,b,d){return new a(e.a&b.a^e.a&d.a^b.a&d.a,e.b&b.b^e.b&d.b^b.b&d.b)}function fa(a){return x(a,2)^x(a,13)^x(a,22)}function ga(e){var b=t(e,28),d=t(e,34);e=t(e,39);return new a(b.a^d.a^e.a,b.b^d.b^e.b)}function ha(a){return x(a,6)^x(a,11)^x(a,25)}function ia(e){var b=t(e,14),d=t(e,18);e=t(e,41);return new a(b.a^d.a^e.a,b.b^d.b^e.b)}function ja(a){return x(a,7)^x(a,18)^a>>>3}function ka(e){var b=t(e,
1),d=t(e,8);e=V(e,7);return new a(b.a^d.a^e.a,b.b^d.b^e.b)}function la(a){return x(a,17)^x(a,19)^a>>>10}function ma(e){var b=t(e,19),d=t(e,61);e=V(e,6);return new a(b.a^d.a^e.a,b.b^d.b^e.b)}function G(a,b){var d=(a&65535)+(b&65535);return((a>>>16)+(b>>>16)+(d>>>16)&65535)<<16|d&65535}function na(a,b,d,k){var h=(a&65535)+(b&65535)+(d&65535)+(k&65535);return((a>>>16)+(b>>>16)+(d>>>16)+(k>>>16)+(h>>>16)&65535)<<16|h&65535}function H(a,b,d,k,h){var c=(a&65535)+(b&65535)+(d&65535)+(k&65535)+(h&65535);
return((a>>>16)+(b>>>16)+(d>>>16)+(k>>>16)+(h>>>16)+(c>>>16)&65535)<<16|c&65535}function oa(e,b){var d,k,c;d=(e.b&65535)+(b.b&65535);k=(e.b>>>16)+(b.b>>>16)+(d>>>16);c=(k&65535)<<16|d&65535;d=(e.a&65535)+(b.a&65535)+(k>>>16);k=(e.a>>>16)+(b.a>>>16)+(d>>>16);return new a((k&65535)<<16|d&65535,c)}function pa(e,b,d,k){var c,l,g;c=(e.b&65535)+(b.b&65535)+(d.b&65535)+(k.b&65535);l=(e.b>>>16)+(b.b>>>16)+(d.b>>>16)+(k.b>>>16)+(c>>>16);g=(l&65535)<<16|c&65535;c=(e.a&65535)+(b.a&65535)+(d.a&65535)+(k.a&65535)+
(l>>>16);l=(e.a>>>16)+(b.a>>>16)+(d.a>>>16)+(k.a>>>16)+(c>>>16);return new a((l&65535)<<16|c&65535,g)}function qa(e,b,d,k,c){var l,g,m;l=(e.b&65535)+(b.b&65535)+(d.b&65535)+(k.b&65535)+(c.b&65535);g=(e.b>>>16)+(b.b>>>16)+(d.b>>>16)+(k.b>>>16)+(c.b>>>16)+(l>>>16);m=(g&65535)<<16|l&65535;l=(e.a&65535)+(b.a&65535)+(d.a&65535)+(k.a&65535)+(c.a&65535)+(g>>>16);g=(e.a>>>16)+(b.a>>>16)+(d.a>>>16)+(k.a>>>16)+(c.a>>>16)+(l>>>16);return new a((g&65535)<<16|l&65535,m)}function B(e,b){return new a(e.a^b.a,e.b^
b.b)}function A(e){var b=[],d;if("SHA-1"===e)b=[1732584193,4023233417,2562383102,271733878,3285377520];else if(0===e.lastIndexOf("SHA-",0))switch(b=[3238371032,914150663,812702999,4144912697,4290775857,1750603025,1694076839,3204075428],d=[1779033703,3144134277,1013904242,2773480762,1359893119,2600822924,528734635,1541459225],e){case "SHA-224":break;case "SHA-256":b=d;break;case "SHA-384":b=[new a(3418070365,b[0]),new a(1654270250,b[1]),new a(2438529370,b[2]),new a(355462360,b[3]),new a(1731405415,
b[4]),new a(41048885895,b[5]),new a(3675008525,b[6]),new a(1203062813,b[7])];break;case "SHA-512":b=[new a(d[0],4089235720),new a(d[1],2227873595),new a(d[2],4271175723),new a(d[3],1595750129),new a(d[4],2917565137),new a(d[5],725511199),new a(d[6],4215389547),new a(d[7],327033209)];break;default:throw Error("Unknown SHA variant");}else if(0===e.lastIndexOf("SHA3-",0)||0===e.lastIndexOf("SHAKE",0))for(e=0;5>e;e+=1)b[e]=[new a(0,0),new a(0,0),new a(0,0),new a(0,0),new a(0,0)];else throw Error("No SHA variants supported");
return b}function K(a,b){var d=[],k,c,l,g,m,p,f;k=b[0];c=b[1];l=b[2];g=b[3];m=b[4];for(f=0;80>f;f+=1)d[f]=16>f?a[f]:y(d[f-3]^d[f-8]^d[f-14]^d[f-16],1),p=20>f?H(y(k,5),c&l^~c&g,m,1518500249,d[f]):40>f?H(y(k,5),c^l^g,m,1859775393,d[f]):60>f?H(y(k,5),W(c,l,g),m,2400959708,d[f]):H(y(k,5),c^l^g,m,3395469782,d[f]),m=g,g=l,l=y(c,30),c=k,k=p;b[0]=G(k,b[0]);b[1]=G(c,b[1]);b[2]=G(l,b[2]);b[3]=G(g,b[3]);b[4]=G(m,b[4]);return b}function ba(a,b,d,c){var h;for(h=(b+65>>>9<<4)+15;a.length<=h;)a.push(0);a[b>>>5]|=
128<<24-b%32;b+=d;a[h]=b&4294967295;a[h-1]=b/4294967296|0;b=a.length;for(h=0;h<b;h+=16)c=K(a.slice(h,h+16),c);return c}function L(e,b,d){var k,h,l,g,m,p,f,n,q,u,r,t,v,x,y,A,z,w,F,B,C,D,E=[],J;if("SHA-224"===d||"SHA-256"===d)u=64,t=1,D=Number,v=G,x=na,y=H,A=ja,z=la,w=fa,F=ha,C=W,B=ca,J=c;else if("SHA-384"===d||"SHA-512"===d)u=80,t=2,D=a,v=oa,x=pa,y=qa,A=ka,z=ma,w=ga,F=ia,C=ea,B=da,J=X;else throw Error("Unexpected error in SHA-2 implementation");d=b[0];k=b[1];h=b[2];l=b[3];g=b[4];m=b[5];p=b[6];f=b[7];
for(r=0;r<u;r+=1)16>r?(q=r*t,n=e.length<=q?0:e[q],q=e.length<=q+1?0:e[q+1],E[r]=new D(n,q)):E[r]=x(z(E[r-2]),E[r-7],A(E[r-15]),E[r-16]),n=y(f,F(g),B(g,m,p),J[r],E[r]),q=v(w(d),C(d,k,h)),f=p,p=m,m=g,g=v(l,n),l=h,h=k,k=d,d=v(n,q);b[0]=v(d,b[0]);b[1]=v(k,b[1]);b[2]=v(h,b[2]);b[3]=v(l,b[3]);b[4]=v(g,b[4]);b[5]=v(m,b[5]);b[6]=v(p,b[6]);b[7]=v(f,b[7]);return b}function D(e,b){var d,c,h,l,g=[],m=[];if(null!==e)for(c=0;c<e.length;c+=2)b[(c>>>1)%5][(c>>>1)/5|0]=B(b[(c>>>1)%5][(c>>>1)/5|0],new a(e[c+1],e[c]));
for(d=0;24>d;d+=1){l=A("SHA3-");for(c=0;5>c;c+=1){h=b[c][0];var p=b[c][1],f=b[c][2],n=b[c][3],q=b[c][4];g[c]=new a(h.a^p.a^f.a^n.a^q.a,h.b^p.b^f.b^n.b^q.b)}for(c=0;5>c;c+=1)m[c]=B(g[(c+4)%5],U(g[(c+1)%5],1));for(c=0;5>c;c+=1)for(h=0;5>h;h+=1)b[c][h]=B(b[c][h],m[c]);for(c=0;5>c;c+=1)for(h=0;5>h;h+=1)l[h][(2*c+3*h)%5]=U(b[c][h],Y[c][h]);for(c=0;5>c;c+=1)for(h=0;5>h;h+=1)b[c][h]=B(l[c][h],new a(~l[(c+1)%5][h].a&l[(c+2)%5][h].a,~l[(c+1)%5][h].b&l[(c+2)%5][h].b));b[0][0]=B(b[0][0],Z[d])}return b}var c,
X,Y,Z;c=[1116352408,1899447441,3049323471,3921009573,961987163,1508970993,2453635748,2870763221,3624381080,310598401,607225278,1426881987,1925078388,2162078206,2614888103,3248222580,3835390401,4022224774,264347078,604807628,770255983,1249150122,1555081692,1996064986,2554220882,2821834349,2952996808,3210313671,3336571891,3584528711,113926993,338241895,666307205,773529912,1294757372,1396182291,1695183700,1986661051,2177026350,2456956037,2730485921,2820302411,3259730800,3345764771,3516065817,3600352804,
4094571909,275423344,430227734,506948616,659060556,883997877,958139571,1322822218,1537002063,1747873779,1955562222,2024104815,2227730452,2361852424,2428436474,2756734187,3204031479,3329325298];X=[new a(c[0],3609767458),new a(c[1],602891725),new a(c[2],3964484399),new a(c[3],2173295548),new a(c[4],4081628472),new a(c[5],3053834265),new a(c[6],2937671579),new a(c[7],3664609560),new a(c[8],2734883394),new a(c[9],1164996542),new a(c[10],1323610764),new a(c[11],3590304994),new a(c[12],4068182383),new a(c[13],
991336113),new a(c[14],633803317),new a(c[15],3479774868),new a(c[16],2666613458),new a(c[17],944711139),new a(c[18],2341262773),new a(c[19],2007800933),new a(c[20],1495990901),new a(c[21],1856431235),new a(c[22],3175218132),new a(c[23],2198950837),new a(c[24],3999719339),new a(c[25],766784016),new a(c[26],2566594879),new a(c[27],3203337956),new a(c[28],1034457026),new a(c[29],2466948901),new a(c[30],3758326383),new a(c[31],168717936),new a(c[32],1188179964),new a(c[33],1546045734),new a(c[34],1522805485),
new a(c[35],2643833823),new a(c[36],2343527390),new a(c[37],1014477480),new a(c[38],1206759142),new a(c[39],344077627),new a(c[40],1290863460),new a(c[41],3158454273),new a(c[42],3505952657),new a(c[43],106217008),new a(c[44],3606008344),new a(c[45],1432725776),new a(c[46],1467031594),new a(c[47],851169720),new a(c[48],3100823752),new a(c[49],1363258195),new a(c[50],3750685593),new a(c[51],3785050280),new a(c[52],3318307427),new a(c[53],3812723403),new a(c[54],2003034995),new a(c[55],3602036899),
new a(c[56],1575990012),new a(c[57],1125592928),new a(c[58],2716904306),new a(c[59],442776044),new a(c[60],593698344),new a(c[61],3733110249),new a(c[62],2999351573),new a(c[63],3815920427),new a(3391569614,3928383900),new a(3515267271,566280711),new a(3940187606,3454069534),new a(4118630271,4000239992),new a(116418474,1914138554),new a(174292421,2731055270),new a(289380356,3203993006),new a(460393269,320620315),new a(685471733,587496836),new a(852142971,1086792851),new a(1017036298,365543100),new a(1126000580,
2618297676),new a(1288033470,3409855158),new a(1501505948,4234509866),new a(1607167915,987167468),new a(1816402316,1246189591)];Z=[new a(0,1),new a(0,32898),new a(2147483648,32906),new a(2147483648,2147516416),new a(0,32907),new a(0,2147483649),new a(2147483648,2147516545),new a(2147483648,32777),new a(0,138),new a(0,136),new a(0,2147516425),new a(0,2147483658),new a(0,2147516555),new a(2147483648,139),new a(2147483648,32905),new a(2147483648,32771),new a(2147483648,32770),new a(2147483648,128),new a(0,
32778),new a(2147483648,2147483658),new a(2147483648,2147516545),new a(2147483648,32896),new a(0,2147483649),new a(2147483648,2147516424)];Y=[[0,36,3,41,18],[1,44,10,45,2],[62,6,43,15,61],[28,55,25,21,56],[27,20,39,8,14]];"function"===typeof define&&define.amd?define(function(){return C}):"undefined"!==typeof exports?("undefined"!==typeof module&&module.exports&&(module.exports=C),exports=C):aa.jsSHA=C})(this);
