/*
	Runtime Engine
		By Craig Kadziolka ( Nov 1999 - Dec 2000 )

	Modifications and copying is permitted providing this header
	is retained
*/

/* Synchronization.h */

#ifndef SYNCHRONIZATION_H
#define SYNCHRONIZATION_H

#include "Types.h"
#include <signal.h>

/* Locks are not needed in co operative multitasking 
typedef sigset_t lock;

/ Function prototypes /
inline void LOCK(lock *);
inline void UNLOCK(lock *);

/ Macros for convienience /
#define CLEARLOCK(x)	UNLOCK(x)

*/

void	ATOMICSTORE(UInt32 *, UInt32);
UInt32  LOADMOSTRECENT(UInt32 *);

/* Instead we disable and enable interrupts around sensitive area */
void disable_interrupts();
void enable_interrupts();

#endif
