/*
  File autogenerated by gengetopt version 2.5  
  generated with the following command:
  /home/bettini/usr/local/bin/gengetopt --input cmdline.ggo --unamed-opts --no-handle-help --no-handle-version 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
/* Check for configure's getopt check result.  */
#ifndef HAVE_GETOPT_LONG
#include "getopt.h"
#else
#include <getopt.h>
#endif

#include "cmdline.h"


void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", PACKAGE, VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
"Purpose:\n"
"  Highlight the syntax of a source file (e.g. Java) \n"
"  into a specific format (e.g. HTML)\n"
"\n"
"Usage: %s [OPTIONS]... [FILES]...\n", PACKAGE);
  printf("   -h         --help               Print help and exit\n");
  printf("   -V         --version            Print version and exit\n");
  printf("   -iSTRING   --input=STRING       input file. default std input\n");
  printf("   -oSTRING   --output=STRING      output file. default std output\n");
  printf("   -sSTRING   --src-lang=STRING    source language (e.g. java, cpp, prolog, perl)\n");
  printf("   -fSTRING   --out-format=STRING  output format (e.g. html)\n");
  printf("   -v         --verbose            verbose mode on\n");
  printf("   -d         --doc                create html with title and header\n");
  printf("   -cSTRING   --css=STRING         use a css for formatting. Implies --doc\n");
  printf("   -TSTRING   --title=STRING       give a title to the html. Implies --doc\n");
  printf("   -tINT      --tab=INT            specify tab length. default 8\n");
  printf("   -HSTRING   --header=STRING      file to insert as header\n");
  printf("   -FSTRING   --footer=STRING      file to insert as footer\n");
  printf("              --tags-file=STRING   specify format options (def. tags.j2h)\n");
  printf("   -n         --line-number        number all output lines\n");
  printf("              --output-dir=STRING  output directory\n");
}


/* gengetopt_strdup(): automatically generated from strdup.c. */
/* strdup.c replacement of strdup, which is not standard */
static char *
gengetopt_strdup (const char *s)
{
  char *result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int missing_required_options = 0;	

  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->input_given = 0 ;
  args_info->output_given = 0 ;
  args_info->src_lang_given = 0 ;
  args_info->out_format_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->doc_given = 0 ;
  args_info->css_given = 0 ;
  args_info->title_given = 0 ;
  args_info->tab_given = 0 ;
  args_info->header_given = 0 ;
  args_info->footer_given = 0 ;
  args_info->tags_file_given = 0 ;
  args_info->line_number_given = 0 ;
  args_info->output_dir_given = 0 ;
#define clear_args() { \
  args_info->input_arg = NULL; \
  args_info->output_arg = NULL; \
  args_info->src_lang_arg = NULL; \
  args_info->out_format_arg = NULL; \
  args_info->css_arg = NULL; \
  args_info->title_arg = NULL; \
  args_info->header_arg = NULL; \
  args_info->footer_arg = NULL; \
  args_info->tags_file_arg = NULL; \
  args_info->output_dir_arg = NULL; \
}

  clear_args();

  args_info->inputs = NULL;
  args_info->inputs_num = 0;

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "input",	1, NULL, 'i' },
        { "output",	1, NULL, 'o' },
        { "src-lang",	1, NULL, 's' },
        { "out-format",	1, NULL, 'f' },
        { "verbose",	0, NULL, 'v' },
        { "doc",	0, NULL, 'd' },
        { "css",	1, NULL, 'c' },
        { "title",	1, NULL, 'T' },
        { "tab",	1, NULL, 't' },
        { "header",	1, NULL, 'H' },
        { "footer",	1, NULL, 'F' },
        { "tags-file",	1, NULL, 0 },
        { "line-number",	0, NULL, 'n' },
        { "output-dir",	1, NULL, 0 },
        { NULL,	0, NULL, 0 }
      };

      c = getopt_long (argc, argv, "hVi:o:s:f:vdc:T:t:H:F:n", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          if (args_info->help_given)
            {
              fprintf (stderr, "%s: `--help' (`-h') option given more than once\n", PACKAGE);
              clear_args ();
              exit (1);
            }
          args_info->help_given = 1;
          return 0;

        case 'V':	/* Print version and exit.  */
          if (args_info->version_given)
            {
              fprintf (stderr, "%s: `--version' (`-V') option given more than once\n", PACKAGE);
              clear_args ();
              exit (1);
            }
          args_info->version_given = 1;
          return 0;

        case 'i':	/* input file. default std input.  */
          if (args_info->input_given)
            {
              fprintf (stderr, "%s: `--input' (`-i') option given more than once\n", PACKAGE);
              clear_args ();
              exit (1);
            }
          args_info->input_given = 1;
          args_info->input_arg = gengetopt_strdup (optarg);
          break;

        case 'o':	/* output file. default std output.  */
          if (args_info->output_given)
            {
              fprintf (stderr, "%s: `--output' (`-o') option given more than once\n", PACKAGE);
              clear_args ();
              exit (1);
            }
          args_info->output_given = 1;
          args_info->output_arg = gengetopt_strdup (optarg);
          break;

        case 's':	/* source language (e.g. java, cpp, prolog, perl).  */
          if (args_info->src_lang_given)
            {
              fprintf (stderr, "%s: `--src-lang' (`-s') option given more than once\n", PACKAGE);
              clear_args ();
              exit (1);
            }
          args_info->src_lang_given = 1;
          args_info->src_lang_arg = gengetopt_strdup (optarg);
          break;

        case 'f':	/* output format (e.g. html).  */
          if (args_info->out_format_given)
            {
              fprintf (stderr, "%s: `--out-format' (`-f') option given more than once\n", PACKAGE);
              clear_args ();
              exit (1);
            }
          args_info->out_format_given = 1;
          args_info->out_format_arg = gengetopt_strdup (optarg);
          break;

        case 'v':	/* verbose mode on.  */
          if (args_info->verbose_given)
            {
              fprintf (stderr, "%s: `--verbose' (`-v') option given more than once\n", PACKAGE);
              clear_args ();
              exit (1);
            }
          args_info->verbose_given = 1;
          break;

        case 'd':	/* create html with title and header.  */
          if (args_info->doc_given)
            {
              fprintf (stderr, "%s: `--doc' (`-d') option given more than once\n", PACKAGE);
              clear_args ();
              exit (1);
            }
          args_info->doc_given = 1;
          break;

        case 'c':	/* use a css for formatting. Implies --doc.  */
          if (args_info->css_given)
            {
              fprintf (stderr, "%s: `--css' (`-c') option given more than once\n", PACKAGE);
              clear_args ();
              exit (1);
            }
          args_info->css_given = 1;
          args_info->css_arg = gengetopt_strdup (optarg);
          break;

        case 'T':	/* give a title to the html. Implies --doc.  */
          if (args_info->title_given)
            {
              fprintf (stderr, "%s: `--title' (`-T') option given more than once\n", PACKAGE);
              clear_args ();
              exit (1);
            }
          args_info->title_given = 1;
          args_info->title_arg = gengetopt_strdup (optarg);
          break;

        case 't':	/* specify tab length. default 8.  */
          if (args_info->tab_given)
            {
              fprintf (stderr, "%s: `--tab' (`-t') option given more than once\n", PACKAGE);
              clear_args ();
              exit (1);
            }
          args_info->tab_given = 1;
          args_info->tab_arg = atoi (optarg);
          break;

        case 'H':	/* file to insert as header.  */
          if (args_info->header_given)
            {
              fprintf (stderr, "%s: `--header' (`-H') option given more than once\n", PACKAGE);
              clear_args ();
              exit (1);
            }
          args_info->header_given = 1;
          args_info->header_arg = gengetopt_strdup (optarg);
          break;

        case 'F':	/* file to insert as footer.  */
          if (args_info->footer_given)
            {
              fprintf (stderr, "%s: `--footer' (`-F') option given more than once\n", PACKAGE);
              clear_args ();
              exit (1);
            }
          args_info->footer_given = 1;
          args_info->footer_arg = gengetopt_strdup (optarg);
          break;

        
        case 'n':	/* number all output lines.  */
          if (args_info->line_number_given)
            {
              fprintf (stderr, "%s: `--line-number' (`-n') option given more than once\n", PACKAGE);
              clear_args ();
              exit (1);
            }
          args_info->line_number_given = 1;
          break;

        
        case 0:	/* Long option with no short option */
          /* specify format options (def. tags.j2h).  */
          if (strcmp (long_options[option_index].name, "tags-file") == 0)
          {
            if (args_info->tags_file_given)
              {
                fprintf (stderr, "%s: `--tags-file' option given more than once\n", PACKAGE);
                clear_args ();
                exit (1);
              }
            args_info->tags_file_given = 1;
            args_info->tags_file_arg = gengetopt_strdup (optarg);
            break;
          }
          /* output directory.  */
          else if (strcmp (long_options[option_index].name, "output-dir") == 0)
          {
            if (args_info->output_dir_given)
              {
                fprintf (stderr, "%s: `--output-dir' option given more than once\n", PACKAGE);
                clear_args ();
                exit (1);
              }
            args_info->output_dir_given = 1;
            args_info->output_dir_arg = gengetopt_strdup (optarg);
            break;
          }

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          exit (1);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */

  if (! args_info->src_lang_given)
    {
      fprintf (stderr, "%s: `--src-lang' (`-s') option required!\n", PACKAGE);
      missing_required_options = 1;
    }

  if (! args_info->out_format_given)
    {
      fprintf (stderr, "%s: `--out-format' (`-f') option required!\n", PACKAGE);
      missing_required_options = 1;
    }

  if ( missing_required_options )
    exit (1);

  if (optind < argc)
    {
      int i = 0 ;

      args_info->inputs_num = argc - optind ;
      args_info->inputs = 
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind++]) ; 
    }

  return 0;
}
