// Copyright 2024 Richard Hughes <richard@hughsie.com>
// SPDX-License-Identifier: LGPL-2.1-or-later

#[derive(ToString)]
enum FuMsgpackItemKind {
    Unknown,
    Integer,
    Nil,
    Boolean,
    Float,
    String,
    Binary,
    Array,
    Map,
    Extension,
}

enum FuMsgpackCmd {
    PositiveFixint    = 0x00,
    PositiveFixintEnd = 0x7F,
    Fixmap            = 0x80,
    FixmapEnd         = 0x8F,
    Fixarray          = 0x90,
    FixarrayEnd       = 0x9F,
    Fixstr            = 0xA0,
    FixstrEnd         = 0xBF,
    Nil               = 0xC0,
    False             = 0xC2,
    True              = 0xC3,
    Bin8              = 0xC4,
    Bin16             = 0xC5,
    Bin32             = 0xC6,
    Ext8              = 0xC7,
    Ext16             = 0xC8,
    Ext32             = 0xC9,
    Float32           = 0xCA,
    Float64           = 0xCB,
    Uint8             = 0xCC,
    Uint16            = 0xCD,
    Uint32            = 0xCE,
    Uint64            = 0xCF,
    Int8              = 0xD0,
    Int16             = 0xD1,
    Int32             = 0xD2,
    Int64             = 0xD3,
    Fixext1           = 0xD4,
    Fixext2           = 0xD5,
    Fixext4           = 0xD6,
    Fixext8           = 0xD7,
    Fixext16          = 0xD8,
    Str8              = 0xD9,
    Str16             = 0xDA,
    Str32             = 0xDB,
    Array16           = 0xDC,
    Array32           = 0xDD,
    Map16             = 0xDE,
    Map32             = 0xDF,
    NegativeFixint    = 0xE0,
    NegativeFixintEnd = 0xFF,
}
