#include <arm_neon.h>
#include "arm-neon-ref.h"
#include "compute-ref-data.h"

/* Expected results.  */
/* Chunk 0.  */
VECT_VAR_DECL(expected0,int,8,8) [] = { 0xf0, 0xf0, 0xf0, 0xf0,
					0xf0, 0xf0, 0xf0, 0xf0 };
VECT_VAR_DECL(expected0,int,16,4) [] = { 0xfff0, 0xfff0, 0xfff0, 0xfff0 };
VECT_VAR_DECL(expected0,int,32,2) [] = { 0xfffffff0, 0xfffffff0 };
VECT_VAR_DECL(expected0,int,64,1) [] = { 0xfffffffffffffff0 };
VECT_VAR_DECL(expected0,uint,8,8) [] = { 0xf0, 0xf0, 0xf0, 0xf0,
					 0xf0, 0xf0, 0xf0, 0xf0 };
VECT_VAR_DECL(expected0,uint,16,4) [] = { 0xfff0, 0xfff0, 0xfff0, 0xfff0 };
VECT_VAR_DECL(expected0,uint,32,2) [] = { 0xfffffff0, 0xfffffff0 };
VECT_VAR_DECL(expected0,uint,64,1) [] = { 0xfffffffffffffff0 };
VECT_VAR_DECL(expected0,poly,8,8) [] = { 0xf0, 0xf0, 0xf0, 0xf0,
					 0xf0, 0xf0, 0xf0, 0xf0 };
VECT_VAR_DECL(expected0,poly,16,4) [] = { 0xfff0, 0xfff0, 0xfff0, 0xfff0 };
VECT_VAR_DECL(expected0,hfloat,32,2) [] = { 0xc1800000, 0xc1800000 };
VECT_VAR_DECL(expected0,int,8,16) [] = { 0xf0, 0xf0, 0xf0, 0xf0,
					 0xf0, 0xf0, 0xf0, 0xf0,
					 0xf0, 0xf0, 0xf0, 0xf0,
					 0xf0, 0xf0, 0xf0, 0xf0 };
VECT_VAR_DECL(expected0,int,16,8) [] = { 0xfff0, 0xfff0, 0xfff0, 0xfff0,
					 0xfff0, 0xfff0, 0xfff0, 0xfff0 };
VECT_VAR_DECL(expected0,int,32,4) [] = { 0xfffffff0, 0xfffffff0,
					 0xfffffff0, 0xfffffff0 };
VECT_VAR_DECL(expected0,int,64,2) [] = { 0xfffffffffffffff0,
					 0xfffffffffffffff0 };
VECT_VAR_DECL(expected0,uint,8,16) [] = { 0xf0, 0xf0, 0xf0, 0xf0,
					  0xf0, 0xf0, 0xf0, 0xf0,
					  0xf0, 0xf0, 0xf0, 0xf0,
					  0xf0, 0xf0, 0xf0, 0xf0 };
VECT_VAR_DECL(expected0,uint,16,8) [] = { 0xfff0, 0xfff0, 0xfff0, 0xfff0,
					  0xfff0, 0xfff0, 0xfff0, 0xfff0 };
VECT_VAR_DECL(expected0,uint,32,4) [] = { 0xfffffff0, 0xfffffff0,
					  0xfffffff0, 0xfffffff0 };
VECT_VAR_DECL(expected0,uint,64,2) [] = { 0xfffffffffffffff0,
					  0xfffffffffffffff0 };
VECT_VAR_DECL(expected0,poly,8,16) [] = { 0xf0, 0xf0, 0xf0, 0xf0,
					  0xf0, 0xf0, 0xf0, 0xf0,
					  0xf0, 0xf0, 0xf0, 0xf0,
					  0xf0, 0xf0, 0xf0, 0xf0 };
VECT_VAR_DECL(expected0,poly,16,8) [] = { 0xfff0, 0xfff0, 0xfff0, 0xfff0,
					  0xfff0, 0xfff0, 0xfff0, 0xfff0 };
VECT_VAR_DECL(expected0,hfloat,32,4) [] = { 0xc1800000, 0xc1800000,
					    0xc1800000, 0xc1800000 };

/* Chunk 1.  */
VECT_VAR_DECL(expected1,int,8,8) [] = { 0xf1, 0xf1, 0xf1, 0xf1,
					0xf1, 0xf1, 0xf1, 0xf1 };
VECT_VAR_DECL(expected1,int,16,4) [] = { 0xfff1, 0xfff1, 0xfff1, 0xfff1 };
VECT_VAR_DECL(expected1,int,32,2) [] = { 0xfffffff1, 0xfffffff1 };
VECT_VAR_DECL(expected1,int,64,1) [] = { 0xfffffffffffffff1 };
VECT_VAR_DECL(expected1,uint,8,8) [] = { 0xf1, 0xf1, 0xf1, 0xf1,
					 0xf1, 0xf1, 0xf1, 0xf1 };
VECT_VAR_DECL(expected1,uint,16,4) [] = { 0xfff1, 0xfff1, 0xfff1, 0xfff1 };
VECT_VAR_DECL(expected1,uint,32,2) [] = { 0xfffffff1, 0xfffffff1 };
VECT_VAR_DECL(expected1,uint,64,1) [] = { 0xfffffffffffffff1 };
VECT_VAR_DECL(expected1,poly,8,8) [] = { 0xf1, 0xf1, 0xf1, 0xf1,
					 0xf1, 0xf1, 0xf1, 0xf1 };
VECT_VAR_DECL(expected1,poly,16,4) [] = { 0xfff1, 0xfff1, 0xfff1, 0xfff1 };
VECT_VAR_DECL(expected1,hfloat,32,2) [] = { 0xc1700000, 0xc1700000 };
VECT_VAR_DECL(expected1,int,8,16) [] = { 0xf1, 0xf1, 0xf1, 0xf1,
					 0xf1, 0xf1, 0xf1, 0xf1,
					 0xf1, 0xf1, 0xf1, 0xf1,
					 0xf1, 0xf1, 0xf1, 0xf1 };
VECT_VAR_DECL(expected1,int,16,8) [] = { 0xfff1, 0xfff1, 0xfff1, 0xfff1,
					 0xfff1, 0xfff1, 0xfff1, 0xfff1 };
VECT_VAR_DECL(expected1,int,32,4) [] = { 0xfffffff1, 0xfffffff1,
					 0xfffffff1, 0xfffffff1 };
VECT_VAR_DECL(expected1,int,64,2) [] = { 0xfffffffffffffff1,
					 0xfffffffffffffff1 };
VECT_VAR_DECL(expected1,uint,8,16) [] = { 0xf1, 0xf1, 0xf1, 0xf1,
					  0xf1, 0xf1, 0xf1, 0xf1,
					  0xf1, 0xf1, 0xf1, 0xf1,
					  0xf1, 0xf1, 0xf1, 0xf1 };
VECT_VAR_DECL(expected1,uint,16,8) [] = { 0xfff1, 0xfff1, 0xfff1, 0xfff1,
					  0xfff1, 0xfff1, 0xfff1, 0xfff1 };
VECT_VAR_DECL(expected1,uint,32,4) [] = { 0xfffffff1, 0xfffffff1,
					  0xfffffff1, 0xfffffff1 };
VECT_VAR_DECL(expected1,uint,64,2) [] = { 0xfffffffffffffff1,
					  0xfffffffffffffff1 };
VECT_VAR_DECL(expected1,poly,8,16) [] = { 0xf1, 0xf1, 0xf1, 0xf1,
					  0xf1, 0xf1, 0xf1, 0xf1,
					  0xf1, 0xf1, 0xf1, 0xf1,
					  0xf1, 0xf1, 0xf1, 0xf1 };
VECT_VAR_DECL(expected1,poly,16,8) [] = { 0xfff1, 0xfff1, 0xfff1, 0xfff1,
					  0xfff1, 0xfff1, 0xfff1, 0xfff1 };
VECT_VAR_DECL(expected1,hfloat,32,4) [] = { 0xc1700000, 0xc1700000,
					    0xc1700000, 0xc1700000 };

/* Chunk 2.  */
VECT_VAR_DECL(expected2,int,8,8) [] = { 0xf2, 0xf2, 0xf2, 0xf2,
					0xf2, 0xf2, 0xf2, 0xf2 };
VECT_VAR_DECL(expected2,int,16,4) [] = { 0xfff2, 0xfff2, 0xfff2, 0xfff2 };
VECT_VAR_DECL(expected2,int,32,2) [] = { 0xfffffff2, 0xfffffff2 };
VECT_VAR_DECL(expected2,int,64,1) [] = { 0xfffffffffffffff2 };
VECT_VAR_DECL(expected2,uint,8,8) [] = { 0xf2, 0xf2, 0xf2, 0xf2,
					 0xf2, 0xf2, 0xf2, 0xf2 };
VECT_VAR_DECL(expected2,uint,16,4) [] = { 0xfff2, 0xfff2, 0xfff2, 0xfff2 };
VECT_VAR_DECL(expected2,uint,32,2) [] = { 0xfffffff2, 0xfffffff2 };
VECT_VAR_DECL(expected2,uint,64,1) [] = { 0xfffffffffffffff2 };
VECT_VAR_DECL(expected2,poly,8,8) [] = { 0xf2, 0xf2, 0xf2, 0xf2,
					 0xf2, 0xf2, 0xf2, 0xf2 };
VECT_VAR_DECL(expected2,poly,16,4) [] = { 0xfff2, 0xfff2, 0xfff2, 0xfff2 };
VECT_VAR_DECL(expected2,hfloat,32,2) [] = { 0xc1600000, 0xc1600000 };
VECT_VAR_DECL(expected2,int,8,16) [] = { 0xf2, 0xf2, 0xf2, 0xf2,
					 0xf2, 0xf2, 0xf2, 0xf2,
					 0xf2, 0xf2, 0xf2, 0xf2,
					 0xf2, 0xf2, 0xf2, 0xf2 };
VECT_VAR_DECL(expected2,int,16,8) [] = { 0xfff2, 0xfff2, 0xfff2, 0xfff2,
					 0xfff2, 0xfff2, 0xfff2, 0xfff2 };
VECT_VAR_DECL(expected2,int,32,4) [] = { 0xfffffff2, 0xfffffff2,
					 0xfffffff2, 0xfffffff2 };
VECT_VAR_DECL(expected2,int,64,2) [] = { 0xfffffffffffffff2,
					 0xfffffffffffffff2 };
VECT_VAR_DECL(expected2,uint,8,16) [] = { 0xf2, 0xf2, 0xf2, 0xf2,
					  0xf2, 0xf2, 0xf2, 0xf2,
					  0xf2, 0xf2, 0xf2, 0xf2,
					  0xf2, 0xf2, 0xf2, 0xf2 };
VECT_VAR_DECL(expected2,uint,16,8) [] = { 0xfff2, 0xfff2, 0xfff2, 0xfff2,
					  0xfff2, 0xfff2, 0xfff2, 0xfff2 };
VECT_VAR_DECL(expected2,uint,32,4) [] = { 0xfffffff2, 0xfffffff2,
					  0xfffffff2, 0xfffffff2 };
VECT_VAR_DECL(expected2,uint,64,2) [] = { 0xfffffffffffffff2,
					  0xfffffffffffffff2 };
VECT_VAR_DECL(expected2,poly,8,16) [] = { 0xf2, 0xf2, 0xf2, 0xf2,
					  0xf2, 0xf2, 0xf2, 0xf2,
					  0xf2, 0xf2, 0xf2, 0xf2,
					  0xf2, 0xf2, 0xf2, 0xf2 };
VECT_VAR_DECL(expected2,poly,16,8) [] = { 0xfff2, 0xfff2, 0xfff2, 0xfff2,
					  0xfff2, 0xfff2, 0xfff2, 0xfff2 };
VECT_VAR_DECL(expected2,hfloat,32,4) [] = { 0xc1600000, 0xc1600000,
					    0xc1600000, 0xc1600000 };

#define TEST_MSG "VLD1_DUP/VLD1_DUPQ"
void exec_vld1_dup (void)
{
  int i;

  /* Fill vector with buffer item #i.  */
#define TEST_VLD1_DUP(VAR, BUF, Q, T1, T2, W, N)			\
  VECT_VAR(VAR, T1, W, N) =						\
    vld1##Q##_dup_##T2##W(&VECT_VAR(BUF, T1, W, N)[i]);			\
  vst1##Q##_##T2##W(VECT_VAR(result, T1, W, N), VECT_VAR(VAR, T1, W, N))

  DECL_VARIABLE_ALL_VARIANTS(vector);

  /* Try to read different places from the input buffer.  */
  for (i=0; i<3; i++) {
    clean_results ();

    TEST_MACRO_ALL_VARIANTS_2_5(TEST_VLD1_DUP, vector, buffer_dup);

    TEST_VLD1_DUP(vector, buffer_dup, , float, f, 32, 2);
    TEST_VLD1_DUP(vector, buffer_dup, q, float, f, 32, 4);

    switch (i) {
    case 0:
      CHECK_RESULTS_NAMED (TEST_MSG, expected0, "");
      break;
    case 1:
      CHECK_RESULTS_NAMED (TEST_MSG, expected1, "");
      break;
    case 2:
      CHECK_RESULTS_NAMED (TEST_MSG, expected2, "");
      break;
    default:
      abort();
    }
  }
}

int main (void)
{
  exec_vld1_dup ();
  return 0;
}
