# Blackfin testcase for loop counter values when jumping out from the last insn
# mach: bfin

.include "testutils.inc"
	start

	init_r_regs 0;
	ASTAT = R0;

	loadsym r1, dest;
	r0 = r1;
	loadsym r1, src;
	r2 = 0x10;

_strncpy:
	CC = R2 == 0;
	if CC JUMP 4f;

	P2 = R2 ;       /* size */
	P0 = R0 ;       /* dst*/
	P1 = R1 ;       /* src*/

	LSETUP (1f, 2f) LC0 = P2;
1:
	R1 = B [P1++] (Z);
	B [P0++] = R1;
	CC = R1 == 0;
2:
	if CC jump 3f;

	fail

	/* if src is shorter than n, we need to null pad bytes in dest
	 * but, we can get here when the last byte is zero, and we don't
	 * want to copy an extra byte at the end, so we need to check
	 */
3:
	R2 = LC0;
	CHECKREG R2, 0x0a;

	CC = R2
	if ! CC jump 4f;

	LSETUP(5f, 5f) LC0;
5:
	B [P0++] = R1;

4:
	loadsym P1, answer;
	P0 = R0;
	p2 = 0x20;
	LSETUP (6f, 7f) LC0 = P2;
6:
	R1 = B [P0++];
	R2 = B [P1++];
	CC = R1 == R2
	IF ! CC JUMP wrong;
7:
	NOP;

	pass

wrong:
	fail

	.data
dest:
	.db 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F
	.db 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F

src:
	.db 0x21, 0x22, 0x23, 0x24, 0x25, 0x00, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x30

answer:
	.db 0x21, 0x22, 0x23, 0x24, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
	.db 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F
