/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.SchemaDVFactory;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.validation.ValidationState;

class W3CSchemaType {
    static boolean isValid(String dataType, String content) {
        boolean isValid = false;
        try {
            XSSimpleType simpleType = SchemaDVFactory.getInstance().getBuiltInType(dataType);
            if (simpleType == null) {
                throw new IllegalArgumentException("Datatype " + dataType + " does not exist!");
            }
            simpleType.validate(content, (ValidationContext)new ValidationState(), new ValidatedInfo());
            isValid = true;
        }
        catch (InvalidDatatypeValueException e) {
            isValid = false;
            Logger.getLogger(W3CSchemaType.class.getName()).log(Level.FINE, content + "is not of datatype " + dataType + "!", e);
        }
        return isValid;
    }

    private W3CSchemaType() {
    }
}

