/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.jhotdraw.draw.AbstractCompositeFigure;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public abstract class AbstractAttributedCompositeFigure
extends AbstractCompositeFigure {
    private HashMap<AttributeKey, Object> attributes = new HashMap();
    private HashSet<AttributeKey> forbiddenAttributes;

    public void setAttributeEnabled(AttributeKey attributeKey, boolean bl) {
        if (this.forbiddenAttributes == null) {
            this.forbiddenAttributes = new HashSet();
        }
        if (bl) {
            this.forbiddenAttributes.remove(attributeKey);
        } else {
            this.forbiddenAttributes.add(attributeKey);
        }
    }

    public boolean isAttributeEnabled(AttributeKey attributeKey) {
        return this.forbiddenAttributes == null || !this.forbiddenAttributes.contains(attributeKey);
    }

    public void setAttributes(Map<AttributeKey, Object> map) {
        for (Map.Entry<AttributeKey, Object> entry : map.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Map<AttributeKey, Object> getAttributes() {
        return new HashMap<AttributeKey, Object>(this.attributes);
    }

    @Override
    public <T> void set(AttributeKey<T> attributeKey, T t) {
        if (this.forbiddenAttributes == null || !this.forbiddenAttributes.contains(attributeKey)) {
            Object object = this.attributes.put(attributeKey, t);
            this.setAttributeOnChildren(attributeKey, t);
            this.fireAttributeChanged(attributeKey, object, t);
        }
    }

    protected <T> void setAttributeOnChildren(AttributeKey<T> attributeKey, T t) {
        for (Figure figure : this.getChildren()) {
            figure.set(attributeKey, t);
        }
    }

    @Override
    public <T> T get(AttributeKey<T> attributeKey) {
        return attributeKey.get(this.attributes);
    }

    @Override
    public Object getAttributesRestoreData() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(new HashMap<AttributeKey, Object>(this.getAttributes()));
        for (Figure figure : this.getChildren()) {
            linkedList.add(figure.getAttributesRestoreData());
        }
        return linkedList;
    }

    @Override
    public void restoreAttributesTo(Object object) {
        Iterator iterator = ((LinkedList)object).iterator();
        this.attributes.clear();
        this.setAttributes((Map)iterator.next());
        for (Figure figure : this.getChildren()) {
            figure.restoreAttributesTo(iterator.next());
        }
    }

    public void drawFigure(Graphics2D graphics2D) {
        this.drawChildren(graphics2D);
        if (this.get(AttributeKeys.FILL_COLOR) != null) {
            graphics2D.setColor(this.get(AttributeKeys.FILL_COLOR));
            this.drawFill(graphics2D);
        }
        if (this.get(AttributeKeys.STROKE_COLOR) != null && this.get(AttributeKeys.STROKE_WIDTH) > 0.0) {
            graphics2D.setStroke(AttributeKeys.getStroke(this));
            graphics2D.setColor(this.get(AttributeKeys.STROKE_COLOR));
            this.drawStroke(graphics2D);
        }
        if (this.get(AttributeKeys.TEXT_COLOR) != null) {
            if (this.get(AttributeKeys.TEXT_SHADOW_COLOR) != null && this.get(AttributeKeys.TEXT_SHADOW_OFFSET) != null) {
                Dimension2DDouble dimension2DDouble = this.get(AttributeKeys.TEXT_SHADOW_OFFSET);
                graphics2D.translate(dimension2DDouble.width, dimension2DDouble.height);
                graphics2D.setColor(this.get(AttributeKeys.TEXT_SHADOW_COLOR));
                this.drawText(graphics2D);
                graphics2D.translate(-dimension2DDouble.width, -dimension2DDouble.height);
            }
            graphics2D.setColor(this.get(AttributeKeys.TEXT_COLOR));
            this.drawText(graphics2D);
        }
    }

    protected void drawChildren(Graphics2D graphics2D) {
        for (Figure figure : this.getChildren()) {
            figure.draw(graphics2D);
        }
    }

    public Stroke getStroke() {
        return AttributeKeys.getStroke(this);
    }

    public double getStrokeMiterLimitFactor() {
        Number number = this.get(AttributeKeys.STROKE_MITER_LIMIT);
        return number != null ? number.doubleValue() : 10.0;
    }

    public Rectangle2D.Double getFigureDrawBounds() {
        double d = AttributeKeys.getStrokeTotalWidth(this) / 2.0;
        if (this.get(AttributeKeys.STROKE_JOIN) == 0) {
            d *= this.get(AttributeKeys.STROKE_MITER_LIMIT).doubleValue();
        }
        Rectangle2D.Double double_ = this.getBounds();
        Geom.grow(double_, d += 1.0, d);
        return double_;
    }

    protected abstract void drawFill(Graphics2D var1);

    protected abstract void drawStroke(Graphics2D var1);

    protected void drawText(Graphics2D graphics2D) {
    }

    @Override
    public AbstractAttributedCompositeFigure clone() {
        AbstractAttributedCompositeFigure abstractAttributedCompositeFigure = (AbstractAttributedCompositeFigure)super.clone();
        abstractAttributedCompositeFigure.attributes = new HashMap<AttributeKey, Object>(this.attributes);
        if (this.forbiddenAttributes != null) {
            abstractAttributedCompositeFigure.forbiddenAttributes = new HashSet<AttributeKey>(this.forbiddenAttributes);
        }
        return abstractAttributedCompositeFigure;
    }

    protected void writeAttributes(DOMOutput dOMOutput) throws IOException {
        Figure figure = (Figure)dOMOutput.getPrototype();
        boolean bl = false;
        for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
            Object t;
            Object t2;
            AttributeKey attributeKey = entry.getKey();
            if (this.forbiddenAttributes != null && this.forbiddenAttributes.contains(attributeKey) || (t2 = figure.get(attributeKey)) == (t = this.get(attributeKey)) && (t2 == null || t == null || t2.equals(t))) continue;
            if (!bl) {
                dOMOutput.openElement("a");
                bl = true;
            }
            dOMOutput.openElement(attributeKey.getKey());
            dOMOutput.writeObject(entry.getValue());
            dOMOutput.closeElement();
        }
        if (bl) {
            dOMOutput.closeElement();
        }
    }

    protected void readAttributes(DOMInput dOMInput) throws IOException {
        if (dOMInput.getElementCount("a") > 0) {
            dOMInput.openElement("a");
            for (int i = dOMInput.getElementCount() - 1; i >= 0; --i) {
                dOMInput.openElement(i);
                String string = dOMInput.getTagName();
                Object object = dOMInput.readObject();
                AttributeKey attributeKey = this.getAttributeKey(string);
                if (attributeKey != null && attributeKey.isAssignable(object) && (this.forbiddenAttributes == null || !this.forbiddenAttributes.contains(attributeKey))) {
                    this.set(attributeKey, object);
                }
                dOMInput.closeElement();
            }
            dOMInput.closeElement();
        }
    }

    protected AttributeKey getAttributeKey(String string) {
        return AttributeKeys.supportedAttributeMap.get(string);
    }

    protected void applyAttributesTo(Figure figure) {
        for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
            figure.set(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void write(DOMOutput dOMOutput) throws IOException {
        super.write(dOMOutput);
        this.writeAttributes(dOMOutput);
    }

    @Override
    public void read(DOMInput dOMInput) throws IOException {
        super.read(dOMInput);
        this.readAttributes(dOMInput);
    }

    public <T> void removeAttribute(AttributeKey<T> attributeKey) {
        if (this.hasAttribute(attributeKey)) {
            T t = this.get(attributeKey);
            this.attributes.remove(attributeKey);
            this.fireAttributeChanged(attributeKey, t, attributeKey.getDefaultValue());
        }
    }

    public boolean hasAttribute(AttributeKey attributeKey) {
        return this.attributes.containsKey(attributeKey);
    }
}

