#vi:filetype=perl



use lib 'lib';
use Test::Nginx::Socket;

repeat_each(3);

plan tests => repeat_each(1) * blocks();
no_root_location();
no_long_string();
$ENV{TEST_NGINX_SERVROOT} = server_root();
run_tests();


__DATA__
=== TEST 1.0 : Runtime Learning force (per ip)
--- http_config
include /etc/nginx/naxsi_core.rules;
--- config
if ($remote_addr = "127.0.0.1") {
 set $naxsi_flag_learning 1;
}
location / {
	 SecRulesEnabled;
	 DeniedUrl "/RequestDenied";
	 CheckRule "$SQL >= 8" BLOCK;
	 CheckRule "$RFI >= 8" BLOCK;
	 CheckRule "$TRAVERSAL >= 4" BLOCK;
	 CheckRule "$XSS >= 8" BLOCK;
  	 root $TEST_NGINX_SERVROOT/html/;
         index index.html index.htm;
}
location /RequestDenied {
	 return 412;
}
--- request
GET /?a=<>
--- error_code: 200

=== TEST 1.01 : Runtime Learning force (absolute)
--- http_config
include /etc/nginx/naxsi_core.rules;
--- config
set $naxsi_flag_learning 1;
location / {
	 SecRulesEnabled;
	 DeniedUrl "/RequestDenied";
	 CheckRule "$SQL >= 8" BLOCK;
	 CheckRule "$RFI >= 8" BLOCK;
	 CheckRule "$TRAVERSAL >= 4" BLOCK;
	 CheckRule "$XSS >= 8" BLOCK;
  	 root $TEST_NGINX_SERVROOT/html/;
         index index.html index.htm;
}
location /RequestDenied {
	 return 412;
}
--- request
GET /?a=<>
--- error_code: 200


=== TEST 1.1: Runtime Learning force (fail - per ip)
--- http_config
include /etc/nginx/naxsi_core.rules;
--- config
if ($remote_addr = "127.0.0.42") {
 set $naxsi_flag_learning 1;
}

location / {
	 SecRulesEnabled;
	 DeniedUrl "/RequestDenied";
	 CheckRule "$SQL >= 8" BLOCK;
	 CheckRule "$RFI >= 8" BLOCK;
	 CheckRule "$TRAVERSAL >= 4" BLOCK;
	 CheckRule "$XSS >= 8" BLOCK;
  	 root $TEST_NGINX_SERVROOT/html/;
         index index.html index.htm;
}
location /RequestDenied {
	 return 412;
}
--- request
GET /?a=<>
--- error_code: 412

=== TEST 1.2: Runtime Learning force (fail - in location)
--- http_config
include /etc/nginx/naxsi_core.rules;
--- config
location / {
 # this will not work, as naxsi
# is processed before var set in location.
         set $naxsi_flag_learning 1;
	 SecRulesEnabled;
	 DeniedUrl "/RequestDenied";
	 CheckRule "$SQL >= 8" BLOCK;
	 CheckRule "$RFI >= 8" BLOCK;
	 CheckRule "$TRAVERSAL >= 4" BLOCK;
	 CheckRule "$XSS >= 8" BLOCK;
  	 root $TEST_NGINX_SERVROOT/html/;
         index index.html index.htm;
}
location /RequestDenied {
	 return 412;
}
--- request
GET /?a=<>
--- error_code: 412



=== TEST 1.3: Runtime Learning disable (per ip)
--- http_config
include /etc/nginx/naxsi_core.rules;
--- config
if ($remote_addr = "127.0.0.1") {
 set $naxsi_flag_learning 0;
}
location / {
	 SecRulesEnabled;
	 LearningMode;
	 DeniedUrl "/RequestDenied";
	 CheckRule "$SQL >= 8" BLOCK;
	 CheckRule "$RFI >= 8" BLOCK;
	 CheckRule "$TRAVERSAL >= 4" BLOCK;
	 CheckRule "$XSS >= 8" BLOCK;
  	 root $TEST_NGINX_SERVROOT/html/;
         index index.html index.htm;
}
location /RequestDenied {
	 return 412;
}
--- request
GET /?a=<>
--- error_code: 412

=== TEST 1.4: Runtime Learning disable (fail - per ip)
--- http_config
include /etc/nginx/naxsi_core.rules;
--- config
if ($remote_addr = "127.0.0.42") {
 set $naxsi_flag_learning 0;
}
location / {
	 SecRulesEnabled;
	 LearningMode;
	 DeniedUrl "/RequestDenied";
	 CheckRule "$SQL >= 8" BLOCK;
	 CheckRule "$RFI >= 8" BLOCK;
	 CheckRule "$TRAVERSAL >= 4" BLOCK;
	 CheckRule "$XSS >= 8" BLOCK;
  	 root $TEST_NGINX_SERVROOT/html/;
         index index.html index.htm;
}
location /RequestDenied {
	 return 412;
}
--- request
GET /?a=<>
--- error_code: 200

=== TEST 2.00 : Check that SecRulesDisabled correctly works
--- http_config
include /etc/nginx/naxsi_core.rules;
--- config
location / {
	 SecRulesEnabled;
	 SecRulesDisabled;
	 DeniedUrl "/RequestDenied";
	 CheckRule "$SQL >= 8" BLOCK;
	 CheckRule "$RFI >= 8" BLOCK;
	 CheckRule "$TRAVERSAL >= 4" BLOCK;
	 CheckRule "$XSS >= 8" BLOCK;
  	 root $TEST_NGINX_SERVROOT/html/;
         index index.html index.htm;
}
location /RequestDenied {
	 return 412;
}
--- request
GET /?a=<>
--- error_code: 200

=== TEST 2: Runtime disable force (absolute)
--- http_config
include /etc/nginx/naxsi_core.rules;
--- config
set $naxsi_flag_enable 0;
location / {
	 SecRulesEnabled;
	 DeniedUrl "/RequestDenied";
	 CheckRule "$SQL >= 8" BLOCK;
	 CheckRule "$RFI >= 8" BLOCK;
	 CheckRule "$TRAVERSAL >= 4" BLOCK;
	 CheckRule "$XSS >= 8" BLOCK;
  	 root $TEST_NGINX_SERVROOT/html/;
         index index.html index.htm;
}
location /RequestDenied {
	 return 412;
}
--- request
GET /?a=<>
--- error_code: 200

=== TEST 2.2: Runtime enable force
--- http_config
include /etc/nginx/naxsi_core.rules;
--- config
set $naxsi_flag_enable 1;
location / {
	 SecRulesEnabled;
	 SecRulesDisabled;
	 DeniedUrl "/RequestDenied";
	 CheckRule "$SQL >= 8" BLOCK;
	 CheckRule "$RFI >= 8" BLOCK;
	 CheckRule "$TRAVERSAL >= 4" BLOCK;
	 CheckRule "$XSS >= 8" BLOCK;
  	 root $TEST_NGINX_SERVROOT/html/;
         index index.html index.htm;
}
location /RequestDenied {
	 return 412;
}
--- request
GET /?a=<>
--- error_code: 412

=== TEST 2.3: Runtime enable force, with static learning (which is pointless)
--- http_config
include /etc/nginx/naxsi_core.rules;
--- config
set $naxsi_flag_enable 1;
location / {
	 LearningMode;
	 SecRulesEnabled;
	 SecRulesDisabled;
	 DeniedUrl "/RequestDenied";
	 CheckRule "$SQL >= 8" BLOCK;
	 CheckRule "$RFI >= 8" BLOCK;
	 CheckRule "$TRAVERSAL >= 4" BLOCK;
	 CheckRule "$XSS >= 8" BLOCK;
  	 root $TEST_NGINX_SERVROOT/html/;
         index index.html index.htm;
}
location /RequestDenied {
	 return 412;
}
--- request
GET /?a=<>
--- error_code: 200

=== TEST 2.4: Runtime enable + learning mode (absolute)
--- http_config
include /etc/nginx/naxsi_core.rules;
--- config
set $naxsi_flag_learning 1;
set $naxsi_flag_enable 1;
location / {
	 SecRulesEnabled;
	 SecRulesDisabled;
	 DeniedUrl "/RequestDenied";
	 CheckRule "$SQL >= 8" BLOCK;
	 CheckRule "$RFI >= 8" BLOCK;
	 CheckRule "$TRAVERSAL >= 4" BLOCK;
	 CheckRule "$XSS >= 8" BLOCK;
  	 root $TEST_NGINX_SERVROOT/html/;
         index index.html index.htm;
}
location /RequestDenied {
	 return 412;
}
--- request
GET /?a=<>
--- error_code: 200

=== TEST 3.0: Runtime enable + learning mode (per ip)
--- http_config
include /etc/nginx/naxsi_core.rules;
--- config
if ($remote_addr = "127.0.0.1") {
set $naxsi_flag_enable 1;
set $naxsi_flag_learning 1;
}
location / {
	 SecRulesEnabled;
	 SecRulesDisabled;
	 DeniedUrl "/RequestDenied";
	 CheckRule "$SQL >= 8" BLOCK;
	 CheckRule "$RFI >= 8" BLOCK;
	 CheckRule "$TRAVERSAL >= 4" BLOCK;
	 CheckRule "$XSS >= 8" BLOCK;
  	 root $TEST_NGINX_SERVROOT/html/;
         index index.html index.htm;
}
location /RequestDenied {
	 return 412;
}
--- request
GET /?a=<>
--- error_code: 200

=== TEST 3.1: Runtime enable + learning mode (per ip)
--- http_config
include /etc/nginx/naxsi_core.rules;
--- config
if ($remote_addr = "127.0.0.42") {
set $naxsi_flag_enable 1;
set $naxsi_flag_learning 1;
}
location / {
	 SecRulesEnabled;
	 SecRulesDisabled;
	 DeniedUrl "/RequestDenied";
	 CheckRule "$SQL >= 8" BLOCK;
	 CheckRule "$RFI >= 8" BLOCK;
	 CheckRule "$TRAVERSAL >= 4" BLOCK;
	 CheckRule "$XSS >= 8" BLOCK;
  	 root $TEST_NGINX_SERVROOT/html/;
         index index.html index.htm;
}
location /RequestDenied {
	 return 412;
}
--- request
GET /?a=<>
--- error_code: 200

=== TEST 3.2: Runtime enable + learning mode (per ip)
--- http_config
include /etc/nginx/naxsi_core.rules;
--- config
set $naxsi_flag_enable 1;
if ($remote_addr = "127.0.0.1") {
set $naxsi_flag_learning 1;
}
location / {
	 SecRulesEnabled;
	 SecRulesDisabled;
	 DeniedUrl "/RequestDenied";
	 CheckRule "$SQL >= 8" BLOCK;
	 CheckRule "$RFI >= 8" BLOCK;
	 CheckRule "$TRAVERSAL >= 4" BLOCK;
	 CheckRule "$XSS >= 8" BLOCK;
  	 root $TEST_NGINX_SERVROOT/html/;
         index index.html index.htm;
}
location /RequestDenied {
	 return 412;
}
--- request
GET /?a=<>
--- error_code: 200

=== TEST 3.3: Runtime enable (success) + learning mode (fail - per ip)
--- http_config
include /etc/nginx/naxsi_core.rules;
--- config
set $naxsi_flag_enable 1;
if ($remote_addr = "127.0.0.42") {
set $naxsi_flag_learning 1;
}
location / {
	 SecRulesEnabled;
	 SecRulesDisabled;
	 DeniedUrl "/RequestDenied";
	 CheckRule "$SQL >= 8" BLOCK;
	 CheckRule "$RFI >= 8" BLOCK;
	 CheckRule "$TRAVERSAL >= 4" BLOCK;
	 CheckRule "$XSS >= 8" BLOCK;
  	 root $TEST_NGINX_SERVROOT/html/;
         index index.html index.htm;
}
location /RequestDenied {
	 return 412;
}
--- request
GET /?a=<>
--- error_code: 412










