/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.autobean.vm.impl;

import com.google.web.bindery.autobean.vm.impl.BeanMethod;
import com.google.web.bindery.autobean.vm.impl.MethodPropertyContext;
import com.google.web.bindery.autobean.vm.impl.ProxyAutoBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GetterPropertyContext
extends MethodPropertyContext {
    private final Method setter;
    private final Object shim;

    GetterPropertyContext(ProxyAutoBean<?> bean, Method getter) {
        super(getter);
        this.shim = bean.as();
        Method found = null;
        String name = BeanMethod.GET.inferName(getter);
        for (Method m : getter.getDeclaringClass().getMethods()) {
            if (!BeanMethod.SET.matches(m) && !BeanMethod.SET_BUILDER.matches(m) || !BeanMethod.SET.inferName(m).equals(name) || !getter.getReturnType().isAssignableFrom(m.getParameterTypes()[0])) continue;
            found = m;
            break;
        }
        this.setter = found;
    }

    @Override
    public boolean canSet() {
        return this.setter != null;
    }

    @Override
    public void set(Object value) {
        if (!this.canSet()) {
            throw new UnsupportedOperationException("No setter");
        }
        try {
            this.setter.setAccessible(true);
            this.setter.invoke(this.shim, value);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }
}

