/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.editor.client.adapters;

import com.google.gwt.editor.client.CompositeEditor;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.adapters.EditorSource;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ListEditorWrapper<T, E extends Editor<T>>
extends AbstractList<T> {
    private final List<T> backing;
    private final CompositeEditor.EditorChain<T, E> chain;
    private final List<E> editors;
    private final EditorSource<E> editorSource;
    private final List<T> workingCopy;

    public ListEditorWrapper(List<T> backing, CompositeEditor.EditorChain<T, E> chain, EditorSource<E> editorSource) {
        this.backing = backing;
        this.chain = chain;
        this.editorSource = editorSource;
        this.editors = new ArrayList(backing.size());
        this.workingCopy = new ArrayList<T>(backing);
    }

    @Override
    public void add(int index, T element) {
        this.workingCopy.add(index, element);
        E subEditor = this.editorSource.create(index);
        this.editors.add(index, subEditor);
        int j = this.editors.size();
        for (int i = index + 1; i < j; ++i) {
            this.editorSource.setIndex((Editor)this.editors.get(i), i);
        }
        this.chain.attach(element, subEditor);
    }

    @Override
    public T get(int index) {
        return this.workingCopy.get(index);
    }

    @Override
    public T remove(int index) {
        T toReturn = this.workingCopy.remove(index);
        Editor subEditor = (Editor)this.editors.remove(index);
        this.editorSource.dispose(subEditor);
        int j = this.editors.size();
        for (int i = index; i < j; ++i) {
            this.editorSource.setIndex((Editor)this.editors.get(i), i);
        }
        this.chain.detach(subEditor);
        return toReturn;
    }

    @Override
    public T set(int index, T element) {
        T toReturn = this.workingCopy.set(index, element);
        this.chain.attach(element, (Editor)this.editors.get(index));
        return toReturn;
    }

    @Override
    public int size() {
        return this.workingCopy.size();
    }

    void attach() {
        this.editors.addAll(this.editorSource.create(this.workingCopy.size(), 0));
        int j = this.workingCopy.size();
        for (int i = 0; i < j; ++i) {
            this.chain.attach(this.workingCopy.get(i), (Editor)this.editors.get(i));
        }
    }

    void detach() {
        int j = this.editors.size();
        for (int i = 0; i < j; ++i) {
            this.chain.detach((Editor)this.editors.get(i));
            this.editorSource.dispose((Editor)this.editors.get(i));
        }
    }

    void flush() {
        int j = this.workingCopy.size();
        for (int i = 0; i < j; ++i) {
            Editor subEditor = (Editor)this.editors.get(i);
            T value = this.chain.getValue(subEditor);
            if (this.workingCopy.get(i) == value) continue;
            this.workingCopy.set(i, value);
        }
        this.backing.clear();
        this.backing.addAll(this.workingCopy);
    }

    List<? extends E> getEditors() {
        return this.editors;
    }
}

