#pragma once

#include <common/memory.h>

#include <boost/noncopyable.hpp>

#include "protocol_strategy.h"

namespace caspar { namespace IO {

class lock_container : public boost::noncopyable
{
  public:
    lock_container(const std::wstring& lifecycle_key);
    ~lock_container();

    bool check_access(client_connection<wchar_t>::ptr conn);
    bool try_lock(const std::wstring& lock_phrase, client_connection<wchar_t>::ptr conn);
    void release_lock(client_connection<wchar_t>::ptr conn);
    void clear_locks();

  private:
    struct impl;
    spl::unique_ptr<impl> impl_;
};
}} // namespace caspar::IO