/*
 * This source file is part of libRocket, the HTML/CSS Interface Middleware
 *
 * For the latest information, see http://www.librocket.com
 *
 * Copyright (c) 2008-2010 CodePoint Ltd, Shift Technology Ltd
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */

#include "precompiled.h"
#include "FontEffectNone.h"

namespace Rocket {
namespace Core {

FontEffectNone::FontEffectNone()
{
}

FontEffectNone::~FontEffectNone()
{
}

// Resizes and repositions the glyph to fit the outline.
bool FontEffectNone::GetGlyphSize(Vector2i& ROCKET_UNUSED_PARAMETER(origin), Vector2i& ROCKET_UNUSED_PARAMETER(dimensions), const FontGlyph& ROCKET_UNUSED_PARAMETER(glyph)) const
{
	ROCKET_UNUSED(origin);
	ROCKET_UNUSED(dimensions);
	ROCKET_UNUSED(glyph);

	return false;
}

// Expands the original glyph texture for the outline.
void FontEffectNone::GenerateGlyphTexture(byte* ROCKET_UNUSED_PARAMETER(destination_data), const Vector2i& ROCKET_UNUSED_PARAMETER(destination_dimensions), int ROCKET_UNUSED_PARAMETER(destination_stride), const FontGlyph& ROCKET_UNUSED_PARAMETER(glyph)) const
{
	ROCKET_UNUSED(destination_data);
	ROCKET_UNUSED(destination_dimensions);
	ROCKET_UNUSED(destination_stride);
	ROCKET_UNUSED(glyph);
}

}
}
