/*
 *	MMX & 3D Now! assembler ver 1.8
 *	programmed by Herr Mie.
 *		98/12/05	renewal
 *		98/12/06	bug fix of prefetchw
 *		98/12/08	can use [q|d]word ptr temporarily
 *		98/12/10	bug fix
 *		99/09/28	Enhanced 3D Now!
 *		99/10/26	bug fix of ebp-adressing
 *					getnum.c by kei-i
 *		99/12/21	consider space in getnum.c
 */

#include "mydef.h"
#include "encode.h"
#include "errmes.h"

/*
 *	t@C LF(0x0A) ܂ EOF ɂȂ܂łn-1ǂ
 *	LF1OCR(0x0D)̏ꍇÂĂ
 *	s char s[n];ł邱 n͐̐ł邱
 *	ǂݍ񂾕̒n̎0Ԃ
 *	nȏ゠ꍇ͎cǂݎ̂Ă1Ԃ
 *	EOFɓꍇ-1Ԃ
 */

static int get1line(char *s, int n, FILE *fp){
	int i,c;
	for( i = 0; i < n-1; i++ ){
		c = fgetc(fp);
		if( c == EOF || c == 0x0A )break;
		*s++ = c;
	}
	if( i > 0 && s[-1] == 0x0D ){
		s[-1] = NUL;
	}else{
		*s = NUL;
	}
	if( c == EOF )return -1;
	if( c == 0x0A )return 0;
	do{
		c=fgetc(fp);	/* ǂݎ̂ */
	}while( c != EOF && c != 0x0a );
	return 1;
}

int main(int argc,char *argv[]){
	char orgName[128];
	char outName[128];
	char buf[strLenMax];
	FILE *fp1,*fp2;
	ENCODE enc;

	fprintf(stderr,"*** MMX & 3D Now! assembler ver 1.8 ***\n");
	argc--;argv++;
	if(argc<1){
		fprintf(stderr,"use: mmx file[.mmx]\n");
		return ERR;
	}

	/* ̓t@C̐ */

	if(strlen(*argv)>=sizeof(orgName)-4){/* 4=sizeof(".mmx") */
		fprintf(stderr,"file name is too long.\n");
		return ERR;
	}

	strcpy(orgName,*argv);
	fp1 = fopen( orgName, "rb" );
	if( !fp1 ){	/* gqȗ? */
		strcat( orgName, ".mmx" );
		fp1 = fopen( orgName, "rb" );
		if( !fp1 ){
			fprintf(stderr,"Can't open %s.\n",orgName);
			return ERR;
		}
	}
	fprintf(stderr,"input file:%s\n",orgName);

	/* o̓t@C̐ */

	{
		int i, len, found = 0;
		strcpy( outName, orgName );
		len = strlen( outName );
		for( i = len - 1; i > 0 && i >= len - 4; i-- ){
			if( outName[i] == '.' ){
				found++;
				break;
			}
		}
		if( found ){
			strcpy( &outName[i+1], "asm" );
		}else{
			strcat( outName, ".asm" );
		}
	}
	fp2=fopen(outName,"w");
	if(!fp2){
		fprintf(stderr,"Can't open %s!\n",outName);
		return ERR;
	}
	fprintf(stderr,"output file:%s\n",outName);

	/* G[֐̂߂̏ */

	setErrMes(orgName);

	/* ϊJn */

	for(;;){
		int ret;
		ret = get1line(buf,sizeof(buf),fp1);
		if( ret == -1 )break;
		if( ret == 1 )fprintf(stderr,"too long!\n");
		if(getEncode(&enc,buf)==NOERR){
			putEncode(&enc,fp2);
		}
		fprintf(fp2,"%s\n",buf);
		incErrLine();
	}
	fprintf(stderr,"complete.\n");
	fclose(fp1);
	fclose(fp2);
	return NOERR;
}
