/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import oracle.net.ns.Packet;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class ConnectPacket
extends Packet
implements SQLnetDef {
    private boolean connDataOflow;

    public ConnectPacket(SessionAtts sessionAtts, boolean bl, boolean bl2) throws IOException {
        super(sessionAtts);
        this.data = sessionAtts.cOption.conn_data.toString();
        this.dataLen = this.data == null ? 0 : this.data.length();
        this.connDataOflow = this.dataLen > 230;
        int n2 = !this.connDataOflow ? 58 + this.dataLen : 58;
        this.createBuffer(n2, 1, 0);
        this.buffer[8] = 1;
        this.buffer[9] = 54;
        this.buffer[10] = 1;
        this.buffer[11] = 44;
        int n3 = 1;
        if (bl && sessionAtts.nt.isCharacteristicUrgentSupported()) {
            n3 |= 0xC00;
        }
        if (bl2) {
            n3 |= 0x40;
        }
        this.buffer[12] = (byte)(n3 >> 8 & 0xFF);
        this.buffer[13] = (byte)(n3 & 0xFF);
        this.buffer[14] = (byte)(this.sdu / 256);
        this.buffer[15] = (byte)(this.sdu % 256);
        this.buffer[16] = (byte)(this.tdu / 256);
        this.buffer[17] = (byte)(this.tdu % 256);
        this.buffer[18] = 79;
        this.buffer[19] = -104;
        this.buffer[22] = 0;
        this.buffer[23] = 1;
        this.buffer[24] = (byte)(this.dataLen / 256);
        this.buffer[25] = (byte)(this.dataLen % 256);
        this.buffer[27] = 58;
        if (!sessionAtts.anoEnabled) {
            this.buffer[33] = 4;
            this.buffer[32] = 4;
        } else {
            this.buffer[32] = this.buffer[33] = (byte)sessionAtts.getANOFlags();
        }
        this.buffer[32] = (byte)(this.buffer[32] | 0x80);
        this.buffer[33] = (byte)(this.buffer[33] | 0x80);
        ConnectPacket.setUb2ToBytes(this.buffer, 50, 0);
        ConnectPacket.setUb2ToBytes(this.buffer, 52, 0);
        ConnectPacket.setUb2ToBytes(this.buffer, 54, 0);
        ConnectPacket.setUb2ToBytes(this.buffer, 56, 0);
        if (!this.connDataOflow && this.dataLen > 0) {
            this.data.getBytes(0, this.dataLen, this.buffer, 58);
        }
    }

    @Override
    protected void send() throws IOException {
        super.send();
        if (this.connDataOflow) {
            byte[] byArray = new byte[this.dataLen];
            this.data.getBytes(0, this.dataLen, byArray, 0);
            this.sAtts.nsOutputStream.write(byArray);
            this.sAtts.nsOutputStream.flush();
        }
    }
}

