/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.ExternalByteArrayCodec;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.util.Map;

public class ExternalByteArrayEncoding
implements Encoding<byte[]> {
    private static final EncodingID encodingId = EncodingID.EXTERNAL;
    private int contentId = -1;

    public static EncodingParams toParam(int contentId) {
        ExternalByteArrayEncoding e = new ExternalByteArrayEncoding();
        e.contentId = contentId;
        return new EncodingParams(encodingId, e.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        return ITF8.writeUnsignedITF8(this.contentId);
    }

    @Override
    public void fromByteArray(byte[] data) {
        this.contentId = ITF8.readUnsignedITF8(data);
    }

    @Override
    public BitCodec<byte[]> buildCodec(Map<Integer, InputStream> inputMap, Map<Integer, ExposedByteArrayOutputStream> outputMap) {
        InputStream inputStream = inputMap == null ? null : inputMap.get(this.contentId);
        ExposedByteArrayOutputStream outputStream = outputMap == null ? null : outputMap.get(this.contentId);
        return new ExternalByteArrayCodec(outputStream, inputStream);
    }

    @Override
    public EncodingID id() {
        return encodingId;
    }
}

