/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.html;

import edu.harvard.hul.ois.jhove.module.html.Html4DocDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlAttributeDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlSpecialToken;
import edu.harvard.hul.ois.jhove.module.html.HtmlTagDesc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class Html4TFDocDesc
extends Html4DocDesc {
    protected static void classInit4(Map map) {
        Html4DocDesc.classInit4(map);
        fontMarkup = new String[]{"tt", "i", "b", "u", "s", "strike", "big", "small"};
        listMarkup = new String[]{"ul", "ol", "dir", "menu"};
        specialMarkup = new String[]{"a", "img", "applet", "object", "font", "basefont", "br", "script", "map", "q", "sub", "sup", "span", "bdo", "iframe"};
        inlineContent = new ArrayList(35);
        Html4TFDocDesc.addStringsToList(fontMarkup, inlineContent);
        Html4TFDocDesc.addStringsToList(phraseMarkup, inlineContent);
        Html4TFDocDesc.addStringsToList(specialMarkup, inlineContent);
        Html4TFDocDesc.addStringsToList(formMarkup, inlineContent);
        inlineContent.add(HtmlSpecialToken.PCDATA);
        blockContent = new ArrayList(20);
        Html4TFDocDesc.addStringsToList(headings, blockContent);
        Html4TFDocDesc.addStringsToList(listMarkup, blockContent);
        String[] stringArray = new String[]{"p", "pre", "dl", "div", "center", "noscript", "blockquote", "form", "hr", "table", "fieldset", "address"};
        Html4TFDocDesc.addStringsToList(stringArray, blockContent);
        flowContent = new ArrayList(30);
        flowContent.addAll(blockContent);
        flowContent.addAll(inlineContent);
        bodyContent = new ArrayList(flowContent.size() + 3);
        bodyContent.addAll(flowContent);
        bodyContent.add("ins");
        bodyContent.add("del");
        listContent = new ArrayList(1);
        listContent.add("li");
        thtdAtts = new ArrayList(bigAttrs.size() + 7);
        thtdAtts.addAll(bigAttrs);
        Html4TFDocDesc.addSimpleAttribute(thtdAtts, "abbr");
        Html4TFDocDesc.addSimpleAttribute(thtdAtts, "axis");
        Html4TFDocDesc.addSimpleAttribute(thtdAtts, "headers");
        Html4TFDocDesc.addSimpleAttribute(thtdAtts, "scope");
        thtdAtts.add(halignAtt);
        thtdAtts.add(valignAtt);
        Html4TFDocDesc.addSelfAttribute(thtdAtts, "nowrap");
        Html4TFDocDesc.addSimpleAttribute(thtdAtts, "rowspan");
        Html4TFDocDesc.addSimpleAttribute(thtdAtts, "colspan");
        Html4TFDocDesc.addSimpleAttribute(thtdAtts, "bgcolor");
        Html4TFDocDesc.addSimpleAttribute(thtdAtts, "width");
        Html4TFDocDesc.addSimpleAttribute(thtdAtts, "height");
    }

    protected static void addAElement(Map map) {
        String string = "a";
        ArrayList arrayList = new ArrayList(bigAttrs.size() + 14);
        arrayList.addAll(bigAttrs);
        Html4TFDocDesc.addSimpleAttribute(arrayList, "type");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "name");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "href");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "hreflang");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "target");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "rel");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "rev");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "accesskey");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "shape");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "rect");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "coords");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "tabindex");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "onfocus");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "onblur");
        ArrayList arrayList2 = new ArrayList(inlineContent.size());
        arrayList2.addAll(inlineContent);
        arrayList2.remove("a");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, arrayList2, arrayList);
        map.put(string, htmlTagDesc);
    }

    protected static void addAppletElement(Map map, HtmlAttributeDesc htmlAttributeDesc) {
        String string = "applet";
        ArrayList<String> arrayList = new ArrayList<String>(flowContent.size());
        arrayList.addAll(flowContent);
        arrayList.add("param");
        ArrayList<HtmlAttributeDesc> arrayList2 = new ArrayList<HtmlAttributeDesc>(9);
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "codebase");
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "archive");
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "code");
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "object");
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "alt");
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "alt");
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "name");
        Html4TFDocDesc.addRequiredAttribute(arrayList2, "width");
        Html4TFDocDesc.addRequiredAttribute(arrayList2, "height");
        arrayList2.add(htmlAttributeDesc);
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "hspace");
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "vspace");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, false, arrayList, arrayList2);
        map.put(string, htmlTagDesc);
    }

    protected static void addAreaElement(Map map, HtmlAttributeDesc htmlAttributeDesc) {
        String string = "area";
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(10);
        arrayList.add(htmlAttributeDesc);
        Html4TFDocDesc.addSimpleAttribute(arrayList, "coords");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "href");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "target");
        arrayList.add(new HtmlAttributeDesc("nohref", new String[]{"nohref"}, 4));
        arrayList.add(new HtmlAttributeDesc("alt", null, 1));
        Html4TFDocDesc.addSimpleAttribute(arrayList, "tabindex");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "accesskey");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "onfocus");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "onblur");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, false, null, arrayList);
        map.put(string, htmlTagDesc);
    }

    protected static void addBaseElement(Map map) {
        String string = "base";
        ArrayList arrayList = new ArrayList(2);
        Html4TFDocDesc.addSimpleAttribute(arrayList, "href");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "target");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, false, null, arrayList);
        map.put(string, htmlTagDesc);
    }

    protected static void addBasefontElement(Map map) {
        String string = "basefont";
        ArrayList arrayList = new ArrayList(4);
        Html4TFDocDesc.addSimpleAttribute(arrayList, "id");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "size");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "color");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "face");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, false, null, arrayList);
        map.put(string, htmlTagDesc);
    }

    protected static void addBlockquoteElement(Map map) {
        String string = "blockquote";
        ArrayList<String> arrayList = new ArrayList<String>(blockContent.size() + 1);
        arrayList.addAll(blockContent);
        arrayList.add("script");
        ArrayList arrayList2 = new ArrayList(bigAttrs.size() + 1);
        arrayList2.addAll(bigAttrs);
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "cite");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, flowContent, arrayList2);
        map.put(string, htmlTagDesc);
    }

    protected static void addBrElement(Map map, List list) {
        String string = "br";
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(list.size() + 1);
        arrayList.addAll(list);
        arrayList.add(new HtmlAttributeDesc("clear", new String[]{"left", "all", "right", "none"}, 5));
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, false, null, arrayList);
        map.put(string, htmlTagDesc);
    }

    protected static void addButtonElement(Map map) {
        String string = "button";
        ArrayList<String> arrayList = new ArrayList<String>(formMarkup.length + 3);
        Html4TFDocDesc.addStringsToList(formMarkup, arrayList);
        arrayList.add("form");
        arrayList.add("isindex");
        arrayList.add("fieldset");
        arrayList.add("iframe");
        ArrayList<HtmlAttributeDesc> arrayList2 = new ArrayList<HtmlAttributeDesc>(biggerAttrs.size() + 8);
        arrayList2.addAll(biggerAttrs);
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "name");
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "value");
        arrayList2.add(new HtmlAttributeDesc("type", new String[]{"button", "submit", "reset"}, 5));
        Html4TFDocDesc.addSelfAttribute(arrayList2, "disabled");
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "tabindex");
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "accesskey");
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "onfocus");
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "onblur");
    }

    protected static void addCaptionElement(Map map, List list, HtmlAttributeDesc htmlAttributeDesc) {
        String string = "caption";
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(bigAttrs.size() + 1);
        arrayList.add(new HtmlAttributeDesc("align", new String[]{"top", "bottom", "left", "right"}, 4));
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, list, arrayList);
        map.put(string, htmlTagDesc);
    }

    protected static void addCenterElement(Map map) {
        String string = "center";
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, flowContent, bigAttrs);
        map.put(string, htmlTagDesc);
    }

    protected static void addDirElement(Map map) {
        String string = "dir";
        ArrayList arrayList = new ArrayList(1);
        Html4TFDocDesc.addSelfAttribute(arrayList, "compact");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, listContent, arrayList);
        map.put(string, htmlTagDesc);
    }

    protected static void addDivElement(Map map) {
        String string = "div";
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(bigAttrs.size() + 1);
        arrayList.addAll(bigAttrs);
        arrayList.add(new HtmlAttributeDesc("align", new String[]{"left", "center", "right", "justify"}, 4));
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, flowContent, arrayList);
        map.put(string, htmlTagDesc);
    }

    protected static void addDlElement(Map map) {
        String string = "dl";
        ArrayList arrayList = new ArrayList(2);
        Html4TFDocDesc.addStringsToList(new String[]{"dt", "dd"}, arrayList);
        ArrayList arrayList2 = new ArrayList(bigAttrs.size() + 1);
        Html4TFDocDesc.addSelfAttribute(arrayList2, "compact");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, arrayList, arrayList2);
        map.put(string, htmlTagDesc);
    }

    protected static void addFontElement(Map map) {
        String string = "font";
        ArrayList arrayList = new ArrayList(bigAttrs.size() + 10);
        arrayList.addAll(bigAttrs);
        arrayList.addAll(i18nAttrs);
        Html4TFDocDesc.addSimpleAttribute(arrayList, "size");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "color");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "face");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, inlineContent, arrayList);
        map.put(string, htmlTagDesc);
    }

    protected static void addFrameElement(Map map) {
        String string = "frame";
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(bigAttrs.size() + 8);
        arrayList.addAll(bigAttrs);
        Html4TFDocDesc.addSimpleAttribute(arrayList, "longdesc");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "name");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "src");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "marginwidth");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "marginheight");
        Html4TFDocDesc.addSelfAttribute(arrayList, "noresize");
        arrayList.add(new HtmlAttributeDesc("scrolling", new String[]{"yes", "no", "auto"}, 5));
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, false, null, arrayList);
        map.put(string, htmlTagDesc);
    }

    protected static void addFramesetElement(Map map) {
        String string = "frameset";
        ArrayList arrayList = new ArrayList(3);
        Html4TFDocDesc.addStringsToList(new String[]{"frameset", "frame", "noframes"}, arrayList);
        ArrayList arrayList2 = new ArrayList(coreAttrs.size() + 4);
        arrayList2.addAll(coreAttrs);
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "rows");
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "cols");
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "onload");
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "onunload");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, false, false, arrayList, arrayList2);
        map.put(string, htmlTagDesc);
    }

    protected static void addHeadElement(Map map) {
        String string = "head";
        String[] stringArray = new String[]{"script", "style", "meta", "link"};
        ArrayList<String> arrayList = new ArrayList<String>(7);
        arrayList.add("title");
        arrayList.add("isindex");
        arrayList.add("base");
        arrayList.add("script");
        arrayList.add("style");
        arrayList.add("meta");
        arrayList.add("link");
        arrayList.add("object");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, false, false, arrayList, null);
        map.put(string, htmlTagDesc);
        Html4TFDocDesc.addStringsToList(stringArray, arrayList);
    }

    protected static void addHrElement(Map map) {
        String string = "hr";
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(bigAttrs.size() + 4);
        arrayList.add(new HtmlAttributeDesc("align", new String[]{"left", "center", "right"}, 4));
        Html4TFDocDesc.addSelfAttribute(arrayList, "noshade");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "size");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "width");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, false, null, arrayList);
        map.put(string, htmlTagDesc);
    }

    protected static void addInputElement(Map map) {
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(biggerAttrs.size() + 20);
        arrayList.addAll(biggerAttrs);
        arrayList.add(new HtmlAttributeDesc("type", new String[]{"text", "password", "checkbox", "radio", "submit", "reset", "file", "hidden", "image", "button"}, 5));
        Html4TFDocDesc.addSimpleAttribute(arrayList, "name");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "value");
        Html4TFDocDesc.addSelfAttribute(arrayList, "checked");
        Html4TFDocDesc.addSelfAttribute(arrayList, "disabled");
        Html4TFDocDesc.addSelfAttribute(arrayList, "readonly");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "size");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "maxlength");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "src");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "alt");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "usemap");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "tabindex");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "accesskey");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "onfocus");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "onblur");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "onselect");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "onchange");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "accept");
        arrayList.add(new HtmlAttributeDesc("align", new String[]{"top", "middle", "bottom", "left", "right"}, 4));
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("input", true, true, null, arrayList);
        map.put("input", htmlTagDesc);
    }

    protected static void addLegendElement(Map map) {
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(bigAttrs.size() + 2);
        arrayList.addAll(bigAttrs);
        Html4TFDocDesc.addSimpleAttribute(arrayList, "accesskey");
        arrayList.add(new HtmlAttributeDesc("align", new String[]{"top", "left", "bottom", "right"}, 4));
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("label", true, true, inlineContent, arrayList);
        map.put("label", htmlTagDesc);
    }

    protected static void addLiElement(Map map) {
        ArrayList arrayList = new ArrayList(bigAttrs.size() + 2);
        arrayList.addAll(bigAttrs);
        Html4TFDocDesc.addSimpleAttribute(arrayList, "type");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "value");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("li", true, false, flowContent, arrayList);
        map.put("li", htmlTagDesc);
    }

    protected static void addLinkElement(Map map) {
        ArrayList arrayList = new ArrayList(bigAttrs.size() + 8);
        arrayList.addAll(bigAttrs);
        Html4TFDocDesc.addSimpleAttribute(arrayList, "charset");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "href");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "hreflang");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "type");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "rel");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "rev");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "media");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "target");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("link", true, false, null, arrayList);
        map.put("link", htmlTagDesc);
    }

    protected static void addMenuElement(Map map) {
        ArrayList arrayList = new ArrayList(1);
        Html4TFDocDesc.addSelfAttribute(arrayList, "compact");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("menu", true, true, listContent, arrayList);
        map.put("menu", htmlTagDesc);
    }

    protected static void addNoframesElement(Map map, int n) {
        ArrayList<String> arrayList;
        if (n == 6 || n == 3) {
            arrayList = new ArrayList<String>(1);
            arrayList.add("body");
        } else {
            arrayList = flowContent;
        }
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("noframes", true, true, arrayList, bigAttrs);
        map.put("noframes", htmlTagDesc);
    }

    protected static void addNoscriptElement(Map map) {
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("noscript", true, false, flowContent, bigAttrs);
        map.put("noscript", htmlTagDesc);
    }

    protected static void addObjectElement(Map map) {
        ArrayList arrayList = new ArrayList(biggerAttrs.size() + 13);
        arrayList.addAll(biggerAttrs);
        Html4TFDocDesc.addSelfAttribute(arrayList, "declare");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "classid");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "codebase");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "data");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "type");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "codetype");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "archive");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "standby");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "height");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "width");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "usemap");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "name");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "tabindex");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "align");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "border");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "hspace");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "vspace");
    }

    protected static void addOlElement(Map map) {
        ArrayList arrayList = new ArrayList(bigAttrs.size() + 3);
        arrayList.addAll(bigAttrs);
        Html4TFDocDesc.addSimpleAttribute(arrayList, "type");
        Html4TFDocDesc.addSelfAttribute(arrayList, "compact");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "start");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("ol", true, true, listContent, arrayList);
        map.put("ol", htmlTagDesc);
    }

    protected static void addPElement(Map map) {
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(bigAttrs.size() + 1);
        arrayList.addAll(bigAttrs);
        arrayList.add(new HtmlAttributeDesc("align", new String[]{"left", "center", "right", "justify"}, 4));
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("p", true, false, inlineContent, arrayList);
        map.put("p", htmlTagDesc);
    }

    protected static void addPreElement(Map map) {
        ArrayList arrayList = new ArrayList(inlineContent.size());
        arrayList.addAll(inlineContent);
        Html4TFDocDesc.removeStringsFromList(arrayList, new String[]{"img", "object", "big", "small", "sub", "sup"});
        ArrayList arrayList2 = new ArrayList(bigAttrs.size() + 1);
        arrayList2.addAll(bigAttrs);
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "width");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("pre", true, true, arrayList, arrayList2);
        map.put("pre", htmlTagDesc);
    }

    protected static void addScriptElement(Map map) {
        ArrayList<HtmlSpecialToken> arrayList = new ArrayList<HtmlSpecialToken>(1);
        arrayList.add(HtmlSpecialToken.PCDATA);
        ArrayList arrayList2 = new ArrayList(6);
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "charset");
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "type");
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "language");
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "src");
        Html4TFDocDesc.addSelfAttribute(arrayList2, "defer");
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "event");
        Html4TFDocDesc.addSimpleAttribute(arrayList2, "for");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("script", true, true, arrayList, arrayList2);
        map.put("script", htmlTagDesc);
    }

    protected static void addTableElement(Map map) {
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(biggerAttrs.size() + 10);
        arrayList.addAll(biggerAttrs);
        Html4TFDocDesc.addSimpleAttribute(arrayList, "summary");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "width");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "border");
        arrayList.add(new HtmlAttributeDesc("frame", new String[]{"void", "above", "below", "hsides", "lhs", "rhs", "vsides", "box", "border"}, 4));
        arrayList.add(new HtmlAttributeDesc("rules", new String[]{"none", "groups", "rows", "cols", "all"}, 4));
        Html4TFDocDesc.addSimpleAttribute(arrayList, "rules");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "cellspacing");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "cellpadding");
        arrayList.add(new HtmlAttributeDesc("align", new String[]{"left", "center", "right"}, 4));
        Html4TFDocDesc.addSimpleAttribute(arrayList, "bgcolor");
        Html4TFDocDesc.addSimpleAttribute(arrayList, "datapagesize");
        List[] listArray = new List[5];
        int[] nArray = new int[]{0, 3, 0, 0, 2};
        ArrayList<String> arrayList2 = new ArrayList<String>(1);
        arrayList2.add("caption");
        listArray[0] = arrayList2;
        arrayList2 = new ArrayList(2);
        arrayList2.add("col");
        arrayList2.add("colgroup");
        listArray[1] = arrayList2;
        arrayList2 = new ArrayList(1);
        arrayList2.add("thead");
        listArray[2] = arrayList2;
        arrayList2 = new ArrayList(1);
        arrayList2.add("tfoot");
        listArray[3] = arrayList2;
        arrayList2 = new ArrayList(1);
        arrayList2.add("tbody");
        listArray[4] = arrayList2;
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("table", true, true, nArray, listArray, arrayList);
        map.put("table", htmlTagDesc);
    }

    protected static void addTrElement(Map map) {
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(bigAttrs.size() + 3);
        arrayList.addAll(bigAttrs);
        arrayList.add(halignAtt);
        arrayList.add(valignAtt);
        Html4TFDocDesc.addSimpleAttribute(arrayList, "bgcolor");
        ArrayList<String> arrayList2 = new ArrayList<String>(2);
        arrayList2.add("th");
        arrayList2.add("td");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("tr", true, false, arrayList2, arrayList);
        htmlTagDesc.addImplicitContainer((HtmlTagDesc)map.get("tbody"));
        map.put("tr", htmlTagDesc);
    }

    protected static void addUlElement(Map map) {
        ArrayList arrayList = new ArrayList(bigAttrs.size() + 2);
        arrayList.addAll(bigAttrs);
        Html4TFDocDesc.addSimpleAttribute(arrayList, "type");
        Html4TFDocDesc.addSelfAttribute(arrayList, "compact");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("ul", true, true, listContent, arrayList);
        map.put("ul", htmlTagDesc);
    }
}

