/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.remote.internal.Activator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ToolkitMigration
implements Runnable {
    private static void copy(File src, File dest) throws IOException {
        byte[] buffer = new byte[1024];
        FileInputStream is = null;
        OutputStream os = null;
        try {
            is = new FileInputStream(src);
            os = new FileOutputStream(dest);
            int read = ((InputStream)is).read(buffer);
            while (read > 0) {
                os.write(buffer, 0, read);
                read = ((InputStream)is).read(buffer);
            }
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                finally {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
            }
        }
    }

    private static void copy(File location, File[] settings) throws IOException {
        File newLocation = new File(location.getParentFile(), String.valueOf(location.getName()) + ".connection");
        if (newLocation.isFile()) {
            throw new IOException(String.format("Path %s points to existing file", newLocation.getAbsoluteFile()));
        }
        if (!newLocation.exists() && !newLocation.mkdir()) {
            throw new IOException(String.format("Unable to make directory %s", newLocation.getAbsoluteFile()));
        }
        File[] fileArray = settings;
        int n = settings.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            File newFile = new File(newLocation, file.getName());
            if (!newFile.exists()) {
                try {
                    ToolkitMigration.copy(file, newFile);
                }
                catch (IOException e) {
                    Activator.log(e, "Unable to copy %s to %s", file, newFile);
                }
            }
            ++n2;
        }
    }

    @Override
    public void run() {
        Object[] files;
        File location = Activator.getDefault().getStateLocation().toFile();
        if (location.isDirectory() && !CoreUtil.isNullOrEmpty((Object[])(files = location.listFiles()))) {
            try {
                ToolkitMigration.copy(location, (File[])files);
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
    }
}

