/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.project;

import com.nvidia.cuda.ide.build.project.AbstractMultiModule;
import com.nvidia.cuda.ide.build.project.Cubin;
import com.nvidia.cuda.ide.build.project.CudaProjectConfigurationImpl;
import com.nvidia.cuda.ide.build.project.ICudaModule;
import com.nvidia.cuda.ide.build.project.MultiConfiguration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class MultiCubin
extends AbstractMultiModule {
    private IPath path;

    public MultiCubin(MultiConfiguration multiConfiguration, IPath path) {
        super(multiConfiguration);
        this.path = path;
    }

    @Override
    public Collection<ICudaModule.Type> getTypesFromConfigurations() {
        HashSet<ICudaModule.Type> types = new HashSet<ICudaModule.Type>();
        for (Cubin cubin : this.getModules()) {
            types.add(cubin.getType());
        }
        return types;
    }

    public Collection<IFile> getFilesInAllConfigurations() {
        HashSet<IFile> files = null;
        for (Cubin cubin : this.getModules()) {
            List<IFile> moduleFiles = Arrays.asList(cubin.getFiles());
            if (files == null) {
                files = new HashSet<IFile>(moduleFiles);
                continue;
            }
            files.retainAll(moduleFiles);
        }
        return files;
    }

    public Collection<IFile> getFilesInAnyConfiguration() {
        HashSet<IFile> filesInAllModules = null;
        HashSet<IFile> filesInAnyModule = new HashSet<IFile>();
        for (Cubin cubin : this.getModules()) {
            List<IFile> moduleFiles = Arrays.asList(cubin.getFiles());
            filesInAnyModule.addAll(moduleFiles);
            if (filesInAllModules == null) {
                filesInAllModules = new HashSet<IFile>(moduleFiles);
                continue;
            }
            filesInAllModules.retainAll(moduleFiles);
        }
        filesInAnyModule.removeAll(filesInAllModules);
        return filesInAnyModule;
    }

    public IPath getPath() {
        return this.path;
    }

    protected Collection<Cubin> getModules() {
        LinkedList<Cubin> cubins = new LinkedList<Cubin>();
        CudaProjectConfigurationImpl[] cudaProjectConfigurationImplArray = this.multiConfiguration.getNestedConfigurations();
        int n = cudaProjectConfigurationImplArray.length;
        int n2 = 0;
        while (n2 < n) {
            Cubin[] modules;
            CudaProjectConfigurationImpl configuration = cudaProjectConfigurationImplArray[n2];
            Cubin[] cubinArray = modules = configuration.getModules();
            int n3 = modules.length;
            int n4 = 0;
            while (n4 < n3) {
                Cubin cubin = cubinArray[n4];
                if (this.path.equals((Object)cubin.getPath())) {
                    cubins.add(cubin);
                }
                ++n4;
            }
            ++n2;
        }
        return cubins;
    }

    public void setPath(IPath path) {
        for (Cubin cubin : this.getModules()) {
            cubin.setPath(path);
        }
        this.path = path;
    }

    public void setType(ICudaModule.Type type) {
        for (Cubin cubin : this.getModules()) {
            cubin.setType(type);
        }
    }

    public void remove() throws CoreException {
        for (Cubin cubin : this.getModules()) {
            cubin.remove();
        }
        this.multiConfiguration.reloadCubins();
    }

    public boolean isInAllConfigurations() {
        return this.multiConfiguration.getNestedConfigurations().length == this.getModules().size();
    }

    public String[] getConfigurationNames() {
        Collection<Cubin> modules = this.getModules();
        String[] configurationNames = new String[modules.size()];
        int i = 0;
        for (Cubin cubin : modules) {
            configurationNames[i++] = cubin.getParentConfiguration().getConfigurationDescription().getName();
        }
        return configurationNames;
    }

    public void addToAllConfigurations(String templateConfiguration) throws CoreException {
        Cubin template = null;
        HashSet<ICConfigurationDescription> descriptions = new HashSet<ICConfigurationDescription>();
        Collection<Cubin> modules = this.getModules();
        for (Cubin cubin : modules) {
            if (templateConfiguration.equals(cubin.getParentConfiguration().getConfigurationDescription().getName())) {
                template = cubin;
            }
            descriptions.add(cubin.getParentConfiguration().getConfigurationDescription());
        }
        if (template == null) {
            throw new CoreException((IStatus)new Status(4, "com.nvidia.cuda.ide.build", String.format("No module %s in configuration %s", this.getPath(), templateConfiguration)));
        }
        CudaProjectConfigurationImpl[] cudaProjectConfigurationImplArray = this.multiConfiguration.getNestedConfigurations();
        int n = cudaProjectConfigurationImplArray.length;
        int n2 = 0;
        while (n2 < n) {
            CudaProjectConfigurationImpl configuration = cudaProjectConfigurationImplArray[n2];
            if (!descriptions.contains(configuration.getConfigurationDescription())) {
                IFile[] files;
                Cubin cubin = configuration.newModule(template.getPath());
                cubin.setDeviceLinkerEnabled(template.isDeviceLinkingEnabled());
                cubin.setType(template.getType());
                cubin.setPhysicalArchitectures(template.getPhysicalArchitectures());
                cubin.setVirtualArchitectures(template.getVirtualArchitectures());
                IFile[] iFileArray = files = template.getFiles();
                int n3 = files.length;
                int n4 = 0;
                while (n4 < n3) {
                    IFile file = iFileArray[n4];
                    cubin.include(file);
                    ++n4;
                }
            }
            ++n2;
        }
        this.multiConfiguration.fireReloaded();
    }

    public IFile getSingleSourceFile() {
        IFile result = null;
        for (Cubin cubin : this.getModules()) {
            IFile[] files = cubin.getFiles();
            if (files.length > 0) {
                if (result == null) {
                    result = files[0];
                    continue;
                }
                if (result.equals((Object)files[0])) continue;
                return null;
            }
            return null;
        }
        return result;
    }
}

