/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.IAbsoluteFontSizeValueProvider;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.command.LibraryChangeEvent;
import org.eclipse.birt.report.model.api.command.ResourceChangeEvent;
import org.eclipse.birt.report.model.api.core.IResourceChangeListener;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.DesignSession;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Style;

class SessionHandleImpl {
    protected DesignSession session;

    public static void setBirtResourcePath(String resourcePath) {
        DesignSession.setResourcePath(resourcePath);
    }

    public static String getBirtResourcePath() {
        return DesignSession.getResourcePath();
    }

    public SessionHandleImpl(Locale locale) {
        ULocale uLocale = ULocale.forLocale((Locale)locale);
        this.session = new DesignSession(uLocale);
    }

    public SessionHandleImpl(ULocale locale) {
        this.session = new DesignSession(locale);
    }

    public void activate() {
        this.session.activate();
    }

    public ModuleHandle openModule(String fileName, InputStream is) throws DesignFileException {
        Module module = this.session.openModule(fileName, is);
        return module.getModuleHandle();
    }

    public ModuleHandle openModule(String fileName, InputStream is, ModuleOption options) throws DesignFileException {
        Module module = this.session.openModule(fileName, is, options);
        return module.getModuleHandle();
    }

    public ModuleHandle openModule(String fileName) throws DesignFileException {
        Module module = this.session.openModule(fileName);
        return module.getModuleHandle();
    }

    public ModuleHandle openModule(String fileName, ModuleOption options) throws DesignFileException {
        Module module = this.session.openModule(fileName, options);
        return module.getModuleHandle();
    }

    public ReportDesignHandle openDesign(String fileName) throws DesignFileException {
        return this.session.openDesign(fileName).handle();
    }

    public ReportDesignHandle openDesign(String fileName, ModuleOption options) throws DesignFileException {
        return this.session.openDesign(fileName, options).handle();
    }

    public ReportDesignHandle openDesign(String fileName, InputStream is) throws DesignFileException {
        return this.session.openDesign(fileName, is).handle();
    }

    public ReportDesignHandle openDesign(String fileName, InputStream is, ModuleOption options) throws DesignFileException {
        return this.session.openDesign(fileName, is, options).handle();
    }

    public ReportDesignHandle openDesign(URL systemId, InputStream is) throws DesignFileException {
        return this.session.openDesign(systemId, is).handle();
    }

    public ReportDesignHandle openDesign(URL systemId, InputStream is, ModuleOption options) throws DesignFileException {
        return this.session.openDesign(systemId, is, options).handle();
    }

    public LibraryHandle openLibrary(String fileName) throws DesignFileException {
        return this.session.openLibrary(fileName).handle();
    }

    public LibraryHandle openLibrary(String fileName, ModuleOption options) throws DesignFileException {
        return this.session.openLibrary(fileName, options).handle();
    }

    public LibraryHandle openLibrary(String fileName, InputStream is) throws DesignFileException {
        return this.session.openLibrary(fileName, is).handle();
    }

    public LibraryHandle openLibrary(String fileName, InputStream is, ModuleOption options) throws DesignFileException {
        return this.session.openLibrary(fileName, is, options).handle();
    }

    public LibraryHandle openLibrary(URL systemId, InputStream is) throws DesignFileException {
        return this.session.openLibrary(systemId, is).handle();
    }

    public LibraryHandle openLibrary(URL systemId, InputStream is, ModuleOption options) throws DesignFileException {
        return this.session.openLibrary(systemId, is, options).handle();
    }

    public ReportDesignHandle createDesign(String fileName) {
        return this.session.createDesign(fileName, null).handle();
    }

    public ReportDesignHandle createDesign(String fileName, ModuleOption options) {
        return this.session.createDesign(fileName, options).handle();
    }

    public ReportDesignHandle createDesignFromTemplate(String templateDesignName) throws DesignFileException {
        return this.session.createDesignFromTemplate(templateDesignName).handle();
    }

    public ReportDesignHandle createDesignFromTemplate(String templateDesignName, InputStream is) throws DesignFileException {
        return this.session.createDesignFromTemplate(templateDesignName, is).handle();
    }

    public LibraryHandle createLibraryFromTemplate(String templateLibraryName) throws DesignFileException {
        return this.session.createLibraryFromTemplate(templateLibraryName).handle();
    }

    public ReportDesignHandle createDesign() {
        return this.session.createDesign(null, null).handle();
    }

    public LibraryHandle createLibrary() {
        return this.session.createLibrary().handle();
    }

    public void saveAll() throws IOException {
        Iterator<Module> iter = this.session.getModuleIterator();
        while (iter.hasNext()) {
            Module module = iter.next();
            ModuleHandle handle = (ModuleHandle)module.getHandle(module);
            if (!handle.needsSave()) continue;
            handle.save();
        }
    }

    public void closeAll(boolean save) throws IOException {
        Iterator<Module> iter = this.session.getModuleIterator();
        while (iter.hasNext()) {
            Module module = iter.next();
            ModuleHandle handle = (ModuleHandle)module.getHandle(module);
            if (save && handle.needsSave()) {
                handle.save();
            }
            handle.close();
        }
    }

    public void setApplicationUnits(String units) throws PropertyValueException {
        this.session.setUnits(units);
    }

    public String getApplicationUnits() {
        return this.session.getUnits();
    }

    public void setColorFormat(int rgbFormat) throws PropertyValueException {
        this.session.setColorFormat(rgbFormat);
    }

    public int getColorFormat() {
        return this.session.getColorFormat();
    }

    public void setDefaultValue(String propName, Object value) throws PropertyValueException {
        this.session.setDefaultValue(propName, value);
    }

    public Object getDefaultValue(String propName) {
        return this.session.getDefaultValue(propName);
    }

    public void setResourceLocator(IResourceLocator locator) {
        this.session.setResourceLocator(locator);
    }

    public IResourceLocator getResourceLocator() {
        return this.session.getResourceLocator();
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public ULocale getULocale() {
        return this.session.getLocale();
    }

    public void fireResourceChange(ResourceChangeEvent ev) {
        if (ev.getEventType() == 20) {
            this.session.fireLibChange((LibraryChangeEvent)ev);
        }
    }

    public void addResourceChangeListener(IResourceChangeListener listener) {
        this.session.addResourceChangeListener(listener);
    }

    public boolean removeResourceChangeListener(IResourceChangeListener listener) {
        return this.session.removeResourceChangeListener(listener);
    }

    DesignSession getSession() {
        return this.session;
    }

    public void setResourceFolder(String resourceFolder) {
        this.session.setResourceFolder(resourceFolder);
    }

    public String getResourceFolder() {
        return this.session.getResourceFolder();
    }

    public StyleHandle getDefaultTOCStyle(String name) {
        List<DesignElement> result = this.session.getDefaultTOCStyleValue();
        if (result == null) {
            return null;
        }
        for (Style style : result) {
            if (!style.getName().equals(name)) continue;
            return style.handle(style.getRoot());
        }
        return null;
    }

    public IAbsoluteFontSizeValueProvider getPredefinedFontSizeProvider() {
        return this.session.getPredefinedFontSizeProvider();
    }
}

