/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKUIActivator;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.engine.ProfileScope;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.ui.LicenseManager;
import org.osgi.service.prefs.Preferences;

public class SimpleLicenseManager
extends LicenseManager {
    Set<String> accepted = new HashSet<String>();
    String profileId;

    public SimpleLicenseManager(String profileId) {
        this.profileId = profileId;
        this.initializeFromPreferences();
    }

    public SimpleLicenseManager() {
        this("_SELF_");
    }

    public boolean accept(ILicense license) {
        this.accepted.add(license.getUUID());
        this.updatePreferences();
        return true;
    }

    public boolean reject(ILicense license) {
        this.accepted.remove(license.getUUID());
        this.updatePreferences();
        return true;
    }

    public boolean isAccepted(ILicense license) {
        return this.accepted.contains(license.getUUID());
    }

    public boolean hasAcceptedLicenses() {
        return !this.accepted.isEmpty();
    }

    private Preferences getPreferences() {
        IAgentLocation location = (IAgentLocation)ProvSDKUIActivator.getDefault().getProvisioningAgent().getService(IAgentLocation.SERVICE_NAME);
        return new ProfileScope(location, this.profileId).getNode("org.eclipse.equinox.p2.ui.sdk");
    }

    private void initializeFromPreferences() {
        Preferences pref = this.getPreferences();
        if (pref != null) {
            String digestList = pref.get("licenseDigestList", "");
            StringTokenizer tokenizer = new StringTokenizer(digestList, ",");
            while (tokenizer.hasMoreTokens()) {
                this.accepted.add(tokenizer.nextToken().trim());
            }
        }
    }

    private void updatePreferences() {
        Preferences pref = this.getPreferences();
        StringBuffer result = new StringBuffer();
        Object[] indexedList = this.accepted.toArray();
        int i = 0;
        while (i < indexedList.length) {
            if (i != 0) {
                result.append(",");
            }
            result.append((String)indexedList[i]);
            ++i;
        }
        pref.put("licenseDigestList", result.toString());
    }
}

