/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.language.settings.providers.ScannerDiscoveryLegacySupport;
import org.eclipse.cdt.core.model.ILanguageDescriptor;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.model.util.CDTListComparator;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICExternalSetting;
import org.eclipse.cdt.core.settings.model.ICFileDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICMultiFolderDescription;
import org.eclipse.cdt.core.settings.model.ICMultiItemsHolder;
import org.eclipse.cdt.core.settings.model.ICMultiResourceDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.MultiLanguageSetting;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.ui.language.settings.providers.LanguageSettingsImages;
import org.eclipse.cdt.internal.ui.language.settings.providers.LanguageSettingsProvidersPage;
import org.eclipse.cdt.internal.ui.newui.Messages;
import org.eclipse.cdt.internal.ui.newui.StatusMessageLine;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;
import org.eclipse.cdt.ui.newui.StringListModeControl;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractLangsListTab
extends AbstractCPropertyTab {
    protected Table table;
    protected TableViewer tv;
    protected Tree langTree;
    protected TreeColumn langCol;
    protected Button showBIButton;
    protected boolean toAllCfgs = false;
    protected boolean toAllLang = false;
    private StatusMessageLine fStatusLine;
    @Deprecated
    protected Label lb1;
    @Deprecated
    protected Label lb2;
    protected TableColumn columnToFit = null;
    protected ICLanguageSetting lang;
    protected LinkedList<ICLanguageSettingEntry> shownEntries;
    protected ArrayList<ICSettingEntry> exported;
    protected SashForm sashForm;
    protected ICLanguageSetting[] ls;
    private boolean fHadSomeModification;
    private StringListModeControl stringListModeControl;
    private static final int BUTTON_ADD = 0;
    private static final int BUTTON_EDIT = 1;
    private static final int BUTTON_DELETE = 2;
    private static final int BUTTON_EXPORT_UNEXPORT = 3;
    private static final int BUTTON_MOVE_UP = 5;
    private static final int BUTTON_MOVE_DOWN = 6;
    protected static final String[] BUTTONS;
    protected static final String[] BUTTSYM;
    private static final Comparator<Object> comp;
    private static String selectedLanguage;
    private static final int[] DEFAULT_SASH_WEIGHTS;

    static {
        String[] stringArray = new String[7];
        stringArray[0] = ADD_STR;
        stringArray[1] = EDIT_STR;
        stringArray[2] = DEL_STR;
        stringArray[3] = Messages.AbstractLangsListTab_Export;
        stringArray[5] = MOVEUP_STR;
        stringArray[6] = MOVEDOWN_STR;
        BUTTONS = stringArray;
        BUTTSYM = new String[]{ADD_STR, EDIT_STR, DEL_STR, Messages.AbstractLangsListTab_Export};
        comp = CDTListComparator.getInstance();
        DEFAULT_SASH_WEIGHTS = new int[]{10, 30};
    }

    @Override
    public void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(2, false));
        GridData gd = (GridData)this.usercomp.getLayoutData();
        gd.heightHint = 1;
        this.sashForm = new SashForm(this.usercomp, 0);
        this.sashForm.setOrientation(256);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.sashForm.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        this.sashForm.setLayout((Layout)layout);
        this.addTree((Composite)this.sashForm).setLayoutData((Object)new GridData(1040));
        this.table = new Table((Composite)this.sashForm, 68098);
        gd = new GridData(1808);
        gd.widthHint = 150;
        this.table.setLayoutData((Object)gd);
        this.table.setHeaderVisible(this.isHeaderVisible());
        this.table.setLinesVisible(true);
        this.sashForm.setWeights(DEFAULT_SASH_WEIGHTS);
        this.sashForm.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 1) {
                    return;
                }
                int shift = event.x - AbstractLangsListTab.this.sashForm.getBounds().x;
                GridData data = (GridData)AbstractLangsListTab.this.langTree.getLayoutData();
                if (data.widthHint + shift < 20) {
                    return;
                }
                AbstractLangsListTab.this.sashForm.layout(true);
            }
        });
        this.tv = new TableViewer(this.table);
        this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tv.setLabelProvider((IBaseLabelProvider)new LanguageSettingsEntriesLabelProvider());
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractLangsListTab.this.updateStatusLine();
                AbstractLangsListTab.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (AbstractLangsListTab.this.buttonIsEnabled(1) && AbstractLangsListTab.this.table.getSelectionIndex() != -1) {
                    AbstractLangsListTab.this.buttonPressed(1);
                }
            }
        });
        this.table.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                AbstractLangsListTab.this.setColumnToFit();
            }

            public void controlResized(ControlEvent e) {
                AbstractLangsListTab.this.setColumnToFit();
            }
        });
        this.fStatusLine = new StatusMessageLine(this.usercomp, 16384, 2);
        this.showBIButton = this.setupCheck(this.usercomp, Messages.AbstractLangsListTab_ShowBuiltin, 1, 512);
        gd = (GridData)this.showBIButton.getLayoutData();
        this.showBIButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractLangsListTab.this.update();
            }
        });
        this.stringListModeControl = new StringListModeControl(this.page, this.usercomp, 1);
        this.stringListModeControl.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AbstractLangsListTab.this.update();
            }
        });
        this.additionalTableSet();
        this.initButtons(this.getKind() == 4 ? BUTTSYM : BUTTONS);
        this.updateData(this.getResDesc());
    }

    private ICLanguageSettingEntry getSelectedEntry() {
        int index = this.table.getSelectionIndex();
        if (index < 0 || this.table.getSelectionIndices().length != 1) {
            return null;
        }
        return (ICLanguageSettingEntry)this.table.getItem(index).getData();
    }

    protected void updateStringListModeControl() {
        this.stringListModeControl.updateStringListModeControl();
    }

    protected void updateStatusLine() {
        ICConfigurationDescription cfgDescription = this.page.getResDesc().getConfiguration();
        IStatus status = LanguageSettingsImages.getStatus(this.getSelectedEntry(), cfgDescription);
        if (cfgDescription != null && (status == null || status.isOK())) {
            boolean isEnabled;
            IProject project = cfgDescription.getProjectDescription().getProject();
            boolean bl = isEnabled = !LanguageSettingsProvidersPage.isLanguageSettingsProvidersEnabled(project) || ScannerDiscoveryLegacySupport.isMbsLanguageSettingsProviderOn((ICConfigurationDescription)cfgDescription);
            if (!isEnabled) {
                status = new Status(1, "org.eclipse.cdt.ui", Messages.AbstractLangsListTab_MbsProviderNotEnabled);
            } else if (LanguageSettingsProvidersPage.isLanguageSettingsProvidersEnabled(project)) {
                status = new Status(1, "org.eclipse.cdt.ui", Messages.AbstractLangsListTab_LspPageMayDefineAdditionalEntries);
            }
        }
        this.fStatusLine.setErrorStatus(status);
    }

    @Override
    protected void updateButtons() {
        int index = this.table.getSelectionIndex();
        int[] ids = this.table.getSelectionIndices();
        boolean canAdd = this.langTree.getItemCount() > 0;
        boolean canExport = index != -1;
        boolean canEdit = canExport && ids.length == 1;
        boolean canDelete = canExport;
        ICLanguageSettingEntry ent = null;
        if (canExport) {
            ent = (ICLanguageSettingEntry)this.table.getItem(index).getData();
            if (ent.isReadOnly()) {
                canEdit = false;
            }
            if (ent.isReadOnly()) {
                canDelete = false;
            }
            if (this.exported.contains(this.resolve(ent))) {
                this.buttonSetText(3, Messages.AbstractLangsListTab_Unexport);
            } else {
                this.buttonSetText(3, Messages.AbstractLangsListTab_Export);
            }
        } else {
            this.buttonSetText(3, Messages.AbstractLangsListTab_Export);
        }
        boolean canMoveUp = false;
        boolean canMoveDown = false;
        if (ent != null) {
            canMoveUp = canEdit && index > 0 && !ent.isBuiltIn();
            boolean bl = canMoveDown = canEdit && index < this.table.getItemCount() - 1 && !ent.isBuiltIn();
        }
        if (canMoveDown && this.showBIButton.getSelection() && (ent = (ICLanguageSettingEntry)this.table.getItem(index + 1).getData()).isBuiltIn()) {
            canMoveDown = false;
        }
        this.buttonSetEnabled(0, canAdd);
        this.buttonSetEnabled(1, canEdit);
        this.buttonSetEnabled(2, canDelete);
        this.buttonSetEnabled(3, canExport && !this.page.isMultiCfg());
        this.buttonSetEnabled(5, canMoveUp && !this.page.isMultiCfg());
        this.buttonSetEnabled(6, canMoveDown && !this.page.isMultiCfg());
    }

    private Tree addTree(Composite comp) {
        this.langTree = new Tree(comp, 2308);
        this.langTree.setLayoutData((Object)new GridData(1040));
        this.langTree.setHeaderVisible(true);
        this.langTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ICLanguageSetting langSetting;
                TreeItem[] items = AbstractLangsListTab.this.langTree.getSelection();
                if (items.length > 0 && (langSetting = (ICLanguageSetting)items[0].getData()) != null) {
                    AbstractLangsListTab.this.lang = langSetting;
                    selectedLanguage = AbstractLangsListTab.this.getLanguageName(AbstractLangsListTab.this.lang);
                    AbstractLangsListTab.this.update();
                }
            }
        });
        this.langTree.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int x = AbstractLangsListTab.this.langTree.getBounds().width - 5;
                if (AbstractLangsListTab.this.langCol.getWidth() != x) {
                    AbstractLangsListTab.this.langCol.setWidth(x);
                }
            }
        });
        this.langCol = new TreeColumn(this.langTree, 0);
        this.langCol.setText(Messages.AbstractLangsListTab_Languages);
        this.langCol.setWidth(200);
        this.langCol.setResizable(false);
        this.langCol.setToolTipText(Messages.AbstractLangsListTab_Languages);
        return this.langTree;
    }

    public abstract int getKind();

    public abstract ICLanguageSettingEntry doAdd();

    public abstract ICLanguageSettingEntry doEdit(ICLanguageSettingEntry var1);

    public void additionalTableSet() {
    }

    public void update() {
        this.update(0);
    }

    public void update(int shift) {
        if (this.lang != null) {
            int x = this.table.getSelectionIndex();
            x = x == -1 ? 0 : (x += shift);
            this.shownEntries = this.getIncs();
            this.tv.setInput((Object)this.shownEntries.toArray(new Object[this.shownEntries.size()]));
            if (this.table.getItemCount() > x) {
                this.table.setSelection(x);
            } else if (this.table.getItemCount() > 0) {
                this.table.setSelection(0);
            }
        }
        this.updateStringListModeControl();
        this.updateStatusLine();
        this.updateButtons();
    }

    protected LinkedList<ICLanguageSettingEntry> getIncs() {
        LinkedList<ICLanguageSettingEntry> l = new LinkedList<ICLanguageSettingEntry>();
        List<ICLanguageSettingEntry> lst = this.getSettingEntriesList(this.getKind());
        if (lst != null) {
            for (ICLanguageSettingEntry ent : lst) {
                if (ent.isBuiltIn()) continue;
                l.add(ent);
            }
            if (this.showBIButton.getSelection()) {
                for (ICLanguageSettingEntry ent : lst) {
                    if (!ent.isBuiltIn()) continue;
                    l.add(ent);
                }
            }
        }
        return l;
    }

    @Override
    public void updateData(ICResourceDescription rcDes) {
        if (rcDes == null || !this.canBeVisible()) {
            return;
        }
        this.updateExport();
        this.langTree.removeAll();
        TreeItem selectedItem = null;
        this.ls = this.getLangSetting(rcDes);
        if (this.ls != null) {
            Arrays.sort(this.ls, CDTListComparator.getInstance());
            ICLanguageSetting[] iCLanguageSettingArray = this.ls;
            int n = this.ls.length;
            int n2 = 0;
            while (n2 < n) {
                ICLanguageSetting langSetting = iCLanguageSettingArray[n2];
                if ((langSetting.getSupportedEntryKinds() & this.getKind()) != 0) {
                    TreeItem t = new TreeItem(this.langTree, 0);
                    String langId = this.getLanguageName(langSetting);
                    t.setText(0, langId);
                    t.setData((Object)langSetting);
                    if (selectedItem == null || selectedLanguage != null && selectedLanguage.equals(langId)) {
                        selectedItem = t;
                        this.lang = langSetting;
                    }
                }
                ++n2;
            }
            if (selectedItem != null && this.table != null) {
                this.langTree.setSelection(selectedItem);
            }
        }
        this.update();
    }

    private String getLanguageName(ICLanguageSetting langSetting) {
        ILanguageDescriptor langDes;
        String langId = langSetting.getLanguageId();
        String langName = null;
        if (langId != null && langId.length() != 0 && (langDes = LanguageManager.getInstance().getLanguageDescriptor(langId)) != null) {
            langName = langDes.getName();
        }
        if (langName == null || langName.length() == 0) {
            langName = langSetting.getName();
        }
        if (langName == null || langName.length() == 0) {
            langName = langId;
        }
        return langName;
    }

    private void updateExport() {
        this.exported = new ArrayList();
        ICExternalSetting[] extSettings = this.getResDesc().getConfiguration().getExternalSettings();
        if (extSettings != null && extSettings.length != 0) {
            ICExternalSetting[] iCExternalSettingArray = extSettings;
            int n = extSettings.length;
            int n2 = 0;
            while (n2 < n) {
                ICExternalSetting extSetting = iCExternalSettingArray[n2];
                ICSettingEntry[] entries = extSetting.getEntries(this.getKind());
                if (entries != null && entries.length != 0) {
                    ICSettingEntry[] iCSettingEntryArray = entries;
                    int n3 = entries.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICSettingEntry entry = iCSettingEntryArray[n4];
                        this.exported.add(entry);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private void performAdd(ICLanguageSettingEntry entry) {
        if (entry != null) {
            this.fHadSomeModification = true;
            if ((this.toAllCfgs || this.toAllLang) && !(this.getResDesc() instanceof ICMultiResourceDescription)) {
                this.addToAll(entry);
            } else if (this.isWModifyMode() && this.lang instanceof MultiLanguageSetting) {
                this.performMulti(entry, null);
            } else {
                this.changeIt(entry, null);
            }
            this.update();
        }
    }

    private void changeIt(ICLanguageSettingEntry add, ICLanguageSettingEntry[] del) {
        List<ICLanguageSettingEntry> lsEntries = this.getSettingEntriesList(this.getKind());
        if (del != null) {
            ICLanguageSettingEntry[] iCLanguageSettingEntryArray = del;
            int n = del.length;
            int n2 = 0;
            while (n2 < n) {
                ICLanguageSettingEntry d = iCLanguageSettingEntryArray[n2];
                for (ICLanguageSettingEntry entry : lsEntries) {
                    if (!d.getName().equals(entry.getName())) continue;
                    lsEntries.remove(entry);
                    break;
                }
                ++n2;
            }
        }
        if (add != null) {
            lsEntries.add(add);
        }
        this.setSettingEntries(this.getKind(), lsEntries, this.toAllLang);
    }

    private void performMulti(ICLanguageSettingEntry ent, ICLanguageSettingEntry del) {
        MultiLanguageSetting ms = (MultiLanguageSetting)this.lang;
        ICLanguageSetting[] langSettings = (ICLanguageSetting[])ms.getItems();
        ICLanguageSettingEntry[][] es = ms.getSettingEntriesM(this.getKind());
        int i = 0;
        while (i < langSettings.length) {
            ArrayList<ICLanguageSettingEntry> entries = new ArrayList<ICLanguageSettingEntry>(Arrays.asList(es[i]));
            if (del != null) {
                for (ICLanguageSettingEntry entry : entries) {
                    if (!entry.getName().equals(del.getName())) continue;
                    entries.remove(entry);
                    break;
                }
            }
            if (ent != null) {
                entries.add(ent);
            }
            langSettings[i].setSettingEntries(this.getKind(), entries);
            ++i;
        }
    }

    private void performEdit(int n) {
        if (n == -1) {
            return;
        }
        ICLanguageSettingEntry old = (ICLanguageSettingEntry)this.table.getItem(n).getData();
        if (old.isReadOnly()) {
            return;
        }
        ICLanguageSettingEntry ent = this.doEdit(old);
        this.toAllLang = false;
        if (ent != null) {
            this.fHadSomeModification = true;
            if (this.isWModifyMode() && this.lang instanceof MultiLanguageSetting) {
                this.performMulti(ent, old);
            } else {
                ICLanguageSettingEntry[] del = null;
                if (!ent.getName().equals(old.getName()) || ent.getFlags() != old.getFlags()) {
                    del = new ICLanguageSettingEntry[]{old};
                }
                this.changeIt(ent, del);
            }
            this.update();
        }
    }

    private void performDelete(int n) {
        if (n == -1) {
            return;
        }
        this.fHadSomeModification = true;
        int[] ids = this.table.getSelectionIndices();
        if (this.isWModifyMode() && this.lang instanceof MultiLanguageSetting) {
            int x = ids.length - 1;
            while (x >= 0) {
                ICLanguageSettingEntry old = (ICLanguageSettingEntry)this.table.getItem(ids[x]).getData();
                this.performMulti(null, old);
                --x;
            }
        } else {
            ICLanguageSettingEntry[] del = new ICLanguageSettingEntry[ids.length];
            int x = ids.length - 1;
            while (x >= 0) {
                ICLanguageSettingEntry old;
                del[x] = old = (ICLanguageSettingEntry)this.table.getItem(ids[x]).getData();
                --x;
            }
            this.changeIt(null, del);
        }
        this.update();
    }

    @Override
    public void buttonPressed(int buttonIndex) {
        int n = this.table.getSelectionIndex();
        int[] ids = this.table.getSelectionIndices();
        switch (buttonIndex) {
            case 0: {
                this.toAllCfgs = false;
                this.toAllLang = false;
                this.performAdd(this.doAdd());
                break;
            }
            case 1: {
                this.performEdit(n);
                break;
            }
            case 2: {
                this.performDelete(n);
                break;
            }
            case 3: {
                if (n == -1) {
                    return;
                }
                int x = ids.length - 1;
                while (x >= 0) {
                    ICLanguageSettingEntry old = this.resolve((ICLanguageSettingEntry)this.table.getItem(ids[x]).getData());
                    if (this.exported.contains(old)) {
                        this.deleteExportSetting((ICSettingEntry)old);
                    } else {
                        this.page.getResDesc().getConfiguration().createExternalSetting(null, null, null, (ICSettingEntry[])new ICLanguageSettingEntry[]{old});
                    }
                    --x;
                }
                this.updateExport();
                this.update();
                break;
            }
            case 5: 
            case 6: {
                ICLanguageSettingEntry old = (ICLanguageSettingEntry)this.table.getItem(n).getData();
                int x = this.shownEntries.indexOf(old);
                if (x < 0) break;
                if (buttonIndex == 6) {
                    ++x;
                }
                old = this.shownEntries.get(x);
                ICLanguageSettingEntry old2 = this.shownEntries.get(x - 1);
                this.shownEntries.remove(x);
                this.shownEntries.remove(x - 1);
                this.shownEntries.add(x - 1, old);
                this.shownEntries.add(x, old2);
                this.setSettingEntries(this.getKind(), this.shownEntries, false);
                this.update(buttonIndex == 5 ? -1 : 1);
                break;
            }
        }
        this.table.setFocus();
    }

    private ICLanguageSettingEntry resolve(ICLanguageSettingEntry entry) {
        ICLanguageSettingEntry[] entries = CDataUtil.resolveEntries((ICLanguageSettingEntry[])new ICLanguageSettingEntry[]{entry}, (ICConfigurationDescription)this.getResDesc().getConfiguration());
        if (entries.length > 0) {
            return entries[0];
        }
        return entry;
    }

    private void deleteExportSetting(ICSettingEntry ent) {
        ICConfigurationDescription cfg = this.getResDesc().getConfiguration();
        ICExternalSetting[] extSettings = cfg.getExternalSettings();
        if (extSettings != null && extSettings.length != 0) {
            ICExternalSetting[] iCExternalSettingArray = extSettings;
            int n = extSettings.length;
            int n2 = 0;
            while (n2 < n) {
                ICExternalSetting extSetting = iCExternalSettingArray[n2];
                ICSettingEntry[] entries = extSetting.getEntries(this.getKind());
                if (entries != null && entries.length != 0) {
                    int j = 0;
                    while (j < entries.length) {
                        if (entries[j].equalsByName(ent)) {
                            ICSettingEntry[] arr = new ICSettingEntry[entries.length - 1];
                            int index = 0;
                            int k = 0;
                            while (k < entries.length) {
                                if (k != j) {
                                    arr[index++] = entries[k];
                                }
                                ++k;
                            }
                            cfg.removeExternalSetting(extSetting);
                            cfg.createExternalSetting(extSetting.getCompatibleLanguageIds(), extSetting.getCompatibleContentTypeIds(), extSetting.getCompatibleExtensions(), arr);
                            return;
                        }
                        ++j;
                    }
                }
                ++n2;
            }
        }
    }

    private void addToAll(ICLanguageSettingEntry ent) {
        ICResourceDescription curRcDes = this.page.getResDesc();
        String id = this.lang.getName();
        ICConfigurationDescription[] iCConfigurationDescriptionArray = this.page.getCfgsEditable();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfgDes = iCConfigurationDescriptionArray[n2];
            ICResourceDescription rcDes = this.page.getResDesc(cfgDes);
            if (rcDes != null && (this.toAllCfgs || curRcDes.equals(rcDes))) {
                ICLanguageSetting[] iCLanguageSettingArray = this.getLangSetting(rcDes);
                int n3 = iCLanguageSettingArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICLanguageSetting l = iCLanguageSettingArray[n4];
                    if (this.toAllLang || id == l.getName() || id != null && id.equals(l.getName())) {
                        List lst = l.getSettingEntriesList(this.getKind());
                        lst.add(ent);
                        l.setSettingEntries(this.getKind(), lst);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    @Override
    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        block7: {
            block6: {
                this.fHadSomeModification = false;
                if (!this.page.isMultiCfg()) break block6;
                ICLanguageSetting[] sr = this.ls;
                if (!(dst instanceof ICMultiItemsHolder)) break block7;
                Object[] objectArray = ((ICMultiItemsHolder)dst).getItems();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (item instanceof ICResourceDescription) {
                        ICLanguageSetting[] ds = this.getLangSetting((ICResourceDescription)item);
                        if (ds == null || sr.length != ds.length) {
                            return;
                        }
                        int i = 0;
                        while (i < sr.length) {
                            ICLanguageSettingEntry[] ents = null;
                            ents = sr[i].getSettingEntries(this.getKind());
                            ds[i].setSettingEntries(this.getKind(), ents);
                            ++i;
                        }
                    }
                    ++n2;
                }
                break block7;
            }
            ICLanguageSetting[] sr = this.getLangSetting(src);
            ICLanguageSetting[] ds = this.getLangSetting(dst);
            if (sr == null || ds == null || sr.length != ds.length) {
                return;
            }
            int i = 0;
            while (i < sr.length) {
                ICLanguageSettingEntry[] ents = null;
                ents = sr[i].getSettingEntries(this.getKind());
                ds[i].setSettingEntries(this.getKind(), ents);
                ++i;
            }
        }
    }

    @Override
    protected void performDefaults() {
        TreeItem[] tis;
        this.fHadSomeModification = true;
        TreeItem[] treeItemArray = tis = this.langTree.getItems();
        int n = tis.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti = treeItemArray[n2];
            Object ob = ti.getData();
            if (ob != null && ob instanceof ICLanguageSetting) {
                ((ICLanguageSetting)ob).setSettingEntries(this.getKind(), null);
            }
            ++n2;
        }
        this.updateData(this.getResDesc());
    }

    public ICLanguageSetting[] getLangSetting(ICResourceDescription rcDes) {
        switch (rcDes.getType()) {
            case 1: 
            case 2: 
            case 4: {
                ICFolderDescription foDes = (ICFolderDescription)rcDes;
                if (foDes instanceof ICMultiFolderDescription) {
                    return this.getLS((ICMultiFolderDescription)foDes);
                }
                return foDes.getLanguageSettings();
            }
            case 8: {
                ICLanguageSetting[] iCLanguageSettingArray;
                ICFileDescription fiDes = (ICFileDescription)rcDes;
                ICLanguageSetting langSetting = fiDes.getLanguageSetting();
                if (langSetting != null) {
                    ICLanguageSetting[] iCLanguageSettingArray2 = new ICLanguageSetting[1];
                    iCLanguageSettingArray = iCLanguageSettingArray2;
                    iCLanguageSettingArray2[0] = langSetting;
                } else {
                    iCLanguageSettingArray = null;
                }
                return iCLanguageSettingArray;
            }
        }
        return null;
    }

    private ICLanguageSetting[] getLS(ICMultiFolderDescription foDes) {
        Object[][] lsArray2D = foDes.getLanguageSettingsM(comp);
        ICLanguageSetting[] fs = this.conv2LS(CDTPrefUtil.getListForDisplay(lsArray2D, comp));
        ICLanguageSetting[] lsets = new ICLanguageSetting[fs.length];
        int i = 0;
        while (i < fs.length) {
            ArrayList<Object> list = new ArrayList<Object>(lsArray2D.length);
            Object[][] objectArray = lsArray2D;
            int n = lsArray2D.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] lsArray = objectArray[n2];
                int x = Arrays.binarySearch(lsArray, fs[i], comp);
                if (x >= 0) {
                    list.add(lsArray[x]);
                }
                ++n2;
            }
            if (list.size() == 1) {
                lsets[i] = (ICLanguageSetting)list.get(0);
            } else if (list.size() > 1) {
                lsets[i] = new MultiLanguageSetting(list, foDes.getConfiguration());
            }
            ++i;
        }
        return lsets;
    }

    @Override
    public boolean canBeVisible() {
        if (this.getResDesc() == null) {
            return true;
        }
        ICLanguageSetting[] langSettings = this.getLangSetting(this.getResDesc());
        if (langSettings == null) {
            return false;
        }
        ICLanguageSetting[] iCLanguageSettingArray = langSettings;
        int n = langSettings.length;
        int n2 = 0;
        while (n2 < n) {
            ICLanguageSetting element = iCLanguageSettingArray[n2];
            if ((element.getSupportedEntryKinds() & this.getKind()) != 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void setSettingEntries(int kind, List<ICLanguageSettingEntry> incs, boolean toAll) {
        if (this.page.isMultiCfg()) {
            ((ICMultiResourceDescription)this.getResDesc()).setSettingEntries(this.lang, kind, incs, toAll);
        } else {
            this.lang.setSettingEntries(kind, incs);
        }
    }

    private List<ICLanguageSettingEntry> getSettingEntriesList(int kind) {
        if (this.page.isMultiCfg() && this.lang instanceof MultiLanguageSetting) {
            Object[][] lses = ((MultiLanguageSetting)this.lang).getSettingEntriesM(kind);
            Object[] res = CDTPrefUtil.getListForDisplay(lses, comp);
            ICLanguageSettingEntry[] out = new ICLanguageSettingEntry[res.length];
            System.arraycopy(res, 0, out, 0, res.length);
            return Arrays.asList(out);
        }
        return this.lang.getSettingEntriesList(kind);
    }

    private ICLanguageSetting[] conv2LS(Object[] ob) {
        ICLanguageSetting[] se = new ICLanguageSetting[ob.length];
        System.arraycopy(ob, 0, se, 0, ob.length);
        return se;
    }

    protected boolean isHeaderVisible() {
        return true;
    }

    protected void setColumnToFit() {
        if (this.columnToFit != null) {
            this.columnToFit.setWidth(this.table.getClientArea().width);
        }
    }

    protected final boolean hadSomeModification() {
        return this.fHadSomeModification;
    }

    @Override
    protected final boolean isIndexerAffected() {
        switch (this.getKind()) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                if (!this.hadSomeModification()) break;
                return true;
            }
        }
        return false;
    }

    private class LanguageSettingsEntriesLabelProvider
    extends LabelProvider
    implements IFontProvider,
    ITableLabelProvider {
        private LanguageSettingsEntriesLabelProvider() {
        }

        public Image getImage(Object element) {
            return this.getColumnImage(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof ICLanguageSettingEntry) {
                ICConfigurationDescription cfg = AbstractLangsListTab.this.getResDesc().getConfiguration();
                return LanguageSettingsImages.getImage((ICLanguageSettingEntry)element, cfg);
            }
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ICLanguageSettingEntry) {
                ICLanguageSettingEntry entry = (ICLanguageSettingEntry)element;
                switch (columnIndex) {
                    case 0: {
                        String name = entry.getName();
                        if (AbstractLangsListTab.this.exported.contains(AbstractLangsListTab.this.resolve(entry))) {
                            name = String.valueOf(name) + Messages.AbstractLangsListTab_ExportIndicator;
                        }
                        return name;
                    }
                    case 1: {
                        if (entry.getKind() == 4) {
                            return entry.getValue();
                        }
                        return null;
                    }
                }
            } else if (columnIndex == 0) {
                return element.toString();
            }
            return null;
        }

        public Font getFont(Object element) {
            if (element instanceof ICLanguageSettingEntry) {
                ICLanguageSettingEntry entry = (ICLanguageSettingEntry)element;
                if (entry.isBuiltIn()) {
                    return null;
                }
                if (entry.isReadOnly()) {
                    return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.dialogfont");
                }
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            return null;
        }
    }
}

