/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.rse.core.IRSECoreRegistry;
import org.eclipse.rse.core.IRSEInitListener;
import org.eclipse.rse.core.IRSEInteractionProvider;
import org.eclipse.rse.core.comm.SystemKeystoreProviderManager;
import org.eclipse.rse.core.model.ISystemProfileManager;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystemConfigurationProxy;
import org.eclipse.rse.internal.core.RSECoreRegistry;
import org.eclipse.rse.internal.core.RSEInitJob;
import org.eclipse.rse.internal.core.model.SystemProfileManager;
import org.eclipse.rse.internal.core.model.SystemRegistry;
import org.eclipse.rse.internal.core.subsystems.SubSystemConfigurationProxy;
import org.eclipse.rse.internal.core.subsystems.SubSystemConfigurationProxyComparator;
import org.eclipse.rse.internal.persistence.RSEPersistenceManager;
import org.eclipse.rse.logging.Logger;
import org.eclipse.rse.logging.LoggerFactory;
import org.eclipse.rse.persistence.IRSEPersistenceManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class RSECorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.rse.core";
    public static final int CURRENT_RELEASE = 200;
    public static final String CURRENT_RELEASE_NAME = "2.0.0";
    public static final int INIT_ALL = 0;
    public static final int INIT_MODEL = 1;
    public static final int INIT_INITIALIZER = 2;
    private static RSECorePlugin plugin = null;
    private Logger logger = null;
    private ISystemRegistry _systemRegistry = null;
    private IRSEPersistenceManager _persistenceManager = null;
    private ISubSystemConfigurationProxy[] _subsystemConfigurations = null;
    private IRSEInteractionProvider _interactionProvider = null;

    public static RSECorePlugin getDefault() {
        return plugin;
    }

    public static IStatus waitForInitCompletion() throws InterruptedException {
        return RSEInitJob.getInstance().waitForCompletion();
    }

    public static IStatus waitForInitCompletion(int phase) throws InterruptedException {
        return RSEInitJob.getInstance().waitForCompletion(phase);
    }

    public static boolean isInitComplete(int phase) {
        return RSEInitJob.getInstance().isComplete(phase);
    }

    public static void addInitListener(IRSEInitListener listener) {
        RSEInitJob.getInstance().addInitListener(listener);
    }

    public static void removeInitListener(IRSEInitListener listener) {
        RSEInitJob.getInstance().removeInitListener(listener);
    }

    public static IRSECoreRegistry getTheCoreRegistry() {
        return RSECorePlugin.getDefault().getCoreRegistry();
    }

    public static IRSEPersistenceManager getThePersistenceManager() {
        return RSECorePlugin.getDefault().getPersistenceManager();
    }

    public static ISystemProfileManager getTheSystemProfileManager() {
        return SystemProfileManager.getDefault();
    }

    public static boolean isTheSystemRegistryActive() {
        if (plugin == null) {
            return false;
        }
        return RSECorePlugin.getDefault().isSystemRegistryActive();
    }

    public static ISystemRegistry getTheSystemRegistry() {
        return RSECorePlugin.getDefault().getSystemRegistry();
    }

    public static String getLocalMachineName() {
        String machineName = null;
        try {
            machineName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            RSECorePlugin.getDefault().log(e);
        }
        return machineName;
    }

    public static String getLocalMachineIPAddress() {
        String machineAddress = null;
        try {
            machineAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            RSECorePlugin.getDefault().log(e);
        }
        return machineAddress;
    }

    public static String getQualifiedHostName(String hostName) {
        try {
            InetAddress address = InetAddress.getByName(hostName);
            return address.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return hostName;
        }
    }

    public RSECorePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.registerKeystoreProviders();
    }

    public void stop(BundleContext context) throws Exception {
        LoggerFactory.freeLogger(this);
        this.logger = null;
        super.stop(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRSEPersistenceManager getPersistenceManager() {
        if (this._persistenceManager == null) {
            RSECorePlugin rSECorePlugin = this;
            synchronized (rSECorePlugin) {
                if (this._persistenceManager == null) {
                    this._persistenceManager = new RSEPersistenceManager(this.getSystemRegistry());
                }
            }
        }
        return this._persistenceManager;
    }

    private boolean isSystemRegistryActive() {
        return this._systemRegistry != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISystemRegistry getSystemRegistry() {
        if (this._systemRegistry == null) {
            RSECorePlugin rSECorePlugin = this;
            synchronized (rSECorePlugin) {
                if (this._systemRegistry == null) {
                    String logfilePath = this.getStateLocation().toOSString();
                    SystemRegistry sr = SystemRegistry.getInstance(logfilePath);
                    ISubSystemConfigurationProxy[] proxies = this.getSubSystemConfigurationProxies();
                    if (proxies != null) {
                        sr.setSubSystemConfigurationProxies(proxies);
                    }
                    this._systemRegistry = sr;
                }
            }
        }
        return this._systemRegistry;
    }

    public IRSECoreRegistry getCoreRegistry() {
        return RSECoreRegistry.getInstance();
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(this);
        }
        return this.logger;
    }

    private void log(Throwable t) {
        this.getLogger().logError("Unexpected Exception", t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultInteractionProvider(IRSEInteractionProvider p) {
        RSECorePlugin rSECorePlugin = this;
        synchronized (rSECorePlugin) {
            this._interactionProvider = p;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRSEInteractionProvider getDefaultInteractionProvider() {
        RSECorePlugin rSECorePlugin = this;
        synchronized (rSECorePlugin) {
            return this._interactionProvider;
        }
    }

    private void registerKeystoreProviders() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] systemTypeExtensions = registry.getConfigurationElementsFor(PLUGIN_ID, "keystoreProviders");
        int i = 0;
        while (i < systemTypeExtensions.length) {
            String nameSpace = systemTypeExtensions[i].getDeclaringExtension().getNamespaceIdentifier();
            String keystoreProviderType = systemTypeExtensions[i].getAttribute("class");
            Bundle bundle = Platform.getBundle((String)nameSpace);
            if (bundle.getState() != 1) {
                SystemKeystoreProviderManager.getInstance().registerKeystoreProvider(bundle, keystoreProviderType);
            }
            ++i;
        }
    }

    private IConfigurationElement[] getSubSystemConfigurationPlugins() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] subsystemConfigurationExtensions = registry.getConfigurationElementsFor(PLUGIN_ID, "subsystemConfigurations");
        return subsystemConfigurationExtensions;
    }

    public ISubSystemConfigurationProxy[] getSubSystemConfigurationProxies() {
        if (this._subsystemConfigurations != null) {
            return this._subsystemConfigurations;
        }
        IConfigurationElement[] factoryPlugins = this.getSubSystemConfigurationPlugins();
        if (factoryPlugins != null) {
            ArrayList<SubSystemConfigurationProxy> l = new ArrayList<SubSystemConfigurationProxy>();
            int idx = 0;
            while (idx < factoryPlugins.length) {
                SubSystemConfigurationProxy ssf = new SubSystemConfigurationProxy(factoryPlugins[idx]);
                l.add(ssf);
                ++idx;
            }
            ISubSystemConfigurationProxy[] newProxies = l.toArray(new ISubSystemConfigurationProxy[l.size()]);
            Arrays.sort(newProxies, new SubSystemConfigurationProxyComparator());
            this._subsystemConfigurations = newProxies;
        }
        return this._subsystemConfigurations;
    }
}

