/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.model.Session;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class PCSamplingPeriodControl
extends Composite {
    private Session session;
    private Button defaultPeriodButton;
    private Button selectPeriodButton;
    private Spinner samplingPeriodSpinner;

    public PCSamplingPeriodControl(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FormLayout());
        Group group = new Group((Composite)this, 2048);
        group.setLayout((Layout)new FormLayout());
        group.setText("Sampling period: Rerun Kernel Profile - PC Sampling analysis after updating");
        FormData groupData = new FormData();
        groupData.top = new FormAttachment(0, 0);
        groupData.bottom = new FormAttachment(100, 0);
        groupData.left = new FormAttachment(0, 0);
        groupData.right = new FormAttachment(100, 0);
        group.setLayoutData((Object)groupData);
        this.defaultPeriodButton = new Button((Composite)group, 16);
        FormData defaultButtonData = new FormData();
        defaultButtonData.top = new FormAttachment(0, 4);
        defaultButtonData.left = new FormAttachment(0, 0);
        defaultButtonData.bottom = new FormAttachment(100, 0);
        this.defaultPeriodButton.setLayoutData((Object)defaultButtonData);
        this.defaultPeriodButton.setText("Default sampling period");
        this.defaultPeriodButton.setToolTipText("The sampling period is chosen based on the multiprocessors on the device, the kernel launch parameters and the sampling buffer size on the device.");
        this.defaultPeriodButton.setSelection(true);
        this.selectPeriodButton = new Button((Composite)group, 16);
        this.selectPeriodButton.setText("Select sampling period");
        this.selectPeriodButton.setToolTipText("The actual sampling period will be in 2^n cycles");
        FormData selectButtonData = new FormData();
        selectButtonData.top = new FormAttachment(0, 4);
        selectButtonData.left = new FormAttachment((Control)this.defaultPeriodButton, 50);
        selectButtonData.bottom = new FormAttachment(100, 0);
        this.selectPeriodButton.setLayoutData((Object)selectButtonData);
        this.samplingPeriodSpinner = new Spinner((Composite)group, 2048);
        this.samplingPeriodSpinner.setMinimum(5);
        this.samplingPeriodSpinner.setMaximum(31);
        this.samplingPeriodSpinner.setIncrement(1);
        this.samplingPeriodSpinner.setTextLimit(2);
        FormData spinnerData = new FormData(20, -1);
        spinnerData.top = new FormAttachment(0, 4);
        spinnerData.left = new FormAttachment((Control)this.selectPeriodButton, 50);
        spinnerData.bottom = new FormAttachment(100, 0);
        this.samplingPeriodSpinner.setLayoutData((Object)spinnerData);
        this.samplingPeriodSpinner.setEnabled(false);
        this.samplingPeriodSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.widget instanceof Spinner) {
                    int period = ((Spinner)e.widget).getSelection();
                    PCSamplingPeriodControl.this.setPCSamplingPeriod(period);
                }
            }
        });
        this.defaultPeriodButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (PCSamplingPeriodControl.this.defaultPeriodButton.getSelection()) {
                    PCSamplingPeriodControl.this.samplingPeriodSpinner.setEnabled(false);
                    PCSamplingPeriodControl.this.setPCSamplingPeriod(0);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.selectPeriodButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (PCSamplingPeriodControl.this.selectPeriodButton.getSelection()) {
                    PCSamplingPeriodControl.this.samplingPeriodSpinner.setEnabled(true);
                    PCSamplingPeriodControl.this.setPCSamplingPeriod(PCSamplingPeriodControl.this.samplingPeriodSpinner.getSelection());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        group.layout();
        parent.layout();
    }

    public void setInput(Session session) {
        this.session = session;
        if (session.getPCSamplingPeriod() != 0) {
            this.selectPeriodButton.setSelection(true);
            this.samplingPeriodSpinner.setEnabled(true);
            this.samplingPeriodSpinner.setSelection(session.getPCSamplingPeriod());
        } else {
            this.defaultPeriodButton.setSelection(true);
            this.samplingPeriodSpinner.setEnabled(false);
        }
    }

    public void refresh() {
    }

    private void setPCSamplingPeriod(int period) {
        if (this.session != null) {
            this.session.setPCSamplingPeriod(period);
        }
    }
}

