/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.ByteSizeFormatter;
import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResultInterval;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.value.IValue;
import com.nvidia.viper.value.ValueBandwidth;
import com.nvidia.viper.value.ValuePercent;
import org.eclipse.jface.action.Action;

public class AnalysisResultMemcpyThroughput
extends AnalysisResultInterval<Long> {
    private long totalMemcpyTime = 0L;

    public AnalysisResultMemcpyThroughput(Session session, AnalysisDescriptor desc) {
        super(session, desc);
    }

    public void setTotalMemcpyTime(long totalMemcpyTime) {
        this.totalMemcpyTime = totalMemcpyTime;
    }

    @Override
    public String getDetails(ResultOutput otpt) {
        if (this.totalMemcpyTime > 0L) {
            double bytesTotal = 0.0;
            long memcpyTime = 0L;
            for (ITimelineInterval interval : this.intervals.keySet()) {
                Long bw = (Long)this.getData(interval);
                if (bw == null) continue;
                bytesTotal += (double)bw.longValue() * (double)interval.getDuration();
                memcpyTime += interval.getDuration();
            }
            long bwAvg = (long)(memcpyTime == 0L ? 0.0 : bytesTotal / (double)memcpyTime);
            ValueBandwidth bwAvgValue = new ValueBandwidth(ByteSizeFormatter.Base.KILOBYTE, bwAvg);
            double bwTimeAvg = (double)memcpyTime / (double)this.totalMemcpyTime;
            ValuePercent bwTimeValue = new ValuePercent(bwTimeAvg * 100.0);
            return String.valueOf(bwAvgValue.toString()) + " avg, for memcpys accounting for " + bwTimeValue.toString() + " of all memcpy time";
        }
        return null;
    }

    @Override
    public IValue getValue(ITimelineInterval interval) {
        Long throughput = (Long)this.getData(interval);
        if (throughput == null) {
            return null;
        }
        return new ValueBandwidth(ByteSizeFormatter.Base.KILOBYTE, throughput);
    }

    @Override
    public String getValueDescription(ITimelineInterval interval) {
        return null;
    }

    @Override
    public Action getMoreAction() {
        return new Action(){

            public void run() {
                ViperHelp.displayHelp(ViperHelp.PINNED_MEMORY);
            }
        };
    }
}

