/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.activity.CuptiActivityFlag;
import com.nvidia.viper.activity.CuptiActivityGlobalAccess;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResultSourceLevel;
import com.nvidia.viper.analysis.AnalysisResultSourceLevelKind;
import com.nvidia.viper.analysis.SourceLevelResultGraphicFactory;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineKind;
import com.nvidia.viper.ui.analysis.IAnalysisResultGraphicFactory;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.Action;

public class AnalysisResultUncoalescedGlobalMemory
extends AnalysisResultSourceLevel {
    private static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    private static final double BAD_COALESCE_UNCACHE_1 = 1.1;
    private static final double BAD_COALESCE_UNCACHE_2 = 2.1;
    private final double BAD_COALESCE_CACHE_1;
    private final double BAD_COALESCE_CACHE_2;
    private static final double BAD_COALESCE_4 = 4.1;
    private static final double BAD_COALESCE_8 = 8.1;
    private static final double BAD_COALESCE_16 = 16.1;
    private Set<ICuptiActivitySourceLevelResult> markerResults = new HashSet<ICuptiActivitySourceLevelResult>();

    static {
        numberFormatter.setMaximumFractionDigits(1);
        numberFormatter.setGroupingUsed(false);
    }

    public AnalysisResultUncoalescedGlobalMemory(Session session, TimelineIntervalKernel kernel, AnalysisDescriptor desc) {
        super(session, kernel, desc);
        TimelineDevice deviceTL = (TimelineDevice)kernel.getPrimaryTimeline().getAncestor(TimelineKind.DEVICE);
        int major = deviceTL.getComputeCapabilityMajor();
        if (major >= 5) {
            this.BAD_COALESCE_CACHE_1 = 1.1;
            this.BAD_COALESCE_CACHE_2 = 2.1;
        } else {
            this.BAD_COALESCE_CACHE_1 = 4.1;
            this.BAD_COALESCE_CACHE_2 = 4.1;
        }
    }

    @Override
    public IAnalysisResultGraphicFactory getAnalysisResultFactory() {
        return new SourceLevelResultGraphicFactory();
    }

    @Override
    public String getResultDescription(ICuptiActivitySourceLevelResult result) {
        if (result instanceof CuptiActivityGlobalAccess) {
            CuptiActivityGlobalAccess ga = (CuptiActivityGlobalAccess)result;
            if (ga.executed != 0) {
                double trans = (double)ga.l2_transactions / (double)ga.executed;
                String lsStr = CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_LOAD.isSet(((CuptiActivityGlobalAccess)result).flags) ? "Global Load" : "Global Store";
                lsStr = lsStr.concat(" L2 Transactions/Access = " + numberFormatter.format(trans));
                if (ga.theoreticalL2Transactions != 0L) {
                    double idealTrans = (double)ga.theoreticalL2Transactions / (double)ga.executed;
                    lsStr = lsStr.concat(", Ideal Transactions/Access = " + numberFormatter.format(idealTrans));
                }
                lsStr = lsStr.concat(" [ " + ga.l2_transactions + " L2 transactions for " + ga.executed + " total executions ]");
                return lsStr;
            }
        }
        return super.getResultDescription(result);
    }

    private boolean isUncoalesced(CuptiActivityGlobalAccess ga) {
        if (!ga.isNullResult()) {
            if (ga.theoreticalL2Transactions == 0L) {
                int accessSize = ga.flags & CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_SIZE_MASK.getCode();
                boolean isCached = (ga.flags & CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_CACHED.getCode()) != 0;
                double badCoalesce = this.getBadCoalesce(accessSize, isCached);
                if (ga.executed == 0) {
                    return false;
                }
                if ((double)ga.l2_transactions / (double)ga.executed >= badCoalesce) {
                    return true;
                }
            } else if (ga.l2_transactions > ga.theoreticalL2Transactions) {
                return true;
            }
        }
        return false;
    }

    private double getBadCoalesce(int accessSize, boolean isCached) {
        switch (accessSize) {
            case 1: {
                return isCached ? this.BAD_COALESCE_CACHE_1 : 1.1;
            }
            case 2: {
                return isCached ? this.BAD_COALESCE_CACHE_2 : 2.1;
            }
            case 4: {
                return 4.1;
            }
            case 8: {
                return 8.1;
            }
            case 16: {
                return 16.1;
            }
        }
        return 4.1;
    }

    @Override
    public boolean addResult(ICuptiActivitySourceLevelResult slr) {
        if (slr instanceof CuptiActivityGlobalAccess) {
            CuptiActivityGlobalAccess slrUncoalesced = (CuptiActivityGlobalAccess)slr;
            if (this.isUncoalesced(slrUncoalesced)) {
                this.addMarkers(slrUncoalesced);
                this.markerResults.add(slrUncoalesced);
            }
            if (super.addResult(slrUncoalesced)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Action getMoreAction() {
        return new MoreAction();
    }

    @Override
    public AnalysisResultSourceLevelKind getAnalysisResultSourceLevelKind() {
        return AnalysisResultSourceLevelKind.GLOBAL_ACCESS_KIND;
    }

    @Override
    public Set<ICuptiActivitySourceLevelResult> getMarkerSourceLevelResults() {
        return Collections.unmodifiableSet(this.markerResults);
    }

    private class MoreAction
    extends Action {
        private MoreAction() {
        }

        public void run() {
            ViperHelp.displayHelp(ViperHelp.GLOBAL_MEMORY_COALESCED);
        }
    }
}

