/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.importexport.internal.wizard;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationArtifactRepositoryFactory;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationMetadataRepositoryFactory;
import org.eclipse.equinox.internal.p2.importexport.internal.Messages;
import org.eclipse.equinox.internal.p2.importexport.internal.wizard.AbstractImportPage;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.dialogs.ISelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.model.ProfileElement;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDetailsLabelProvider;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.osgi.util.tracker.ServiceTracker;

public class ImportFromInstallationPage
extends AbstractImportPage
implements ISelectableIUsPage {
    protected IProvisioningAgent otherInstanceAgent = null;
    IProfile toBeImportedProfile = null;
    private File instancePath = null;
    private URI[] metaURIs = null;
    private URI[] artiURIs = null;
    private IProvisioningAgentProvider agentProvider;

    public ImportFromInstallationPage(ProvisioningUI ui, ProvisioningOperationWizard wizard) {
        super("importfrominstancepage", ui, wizard);
        this.setTitle(Messages.ImportFromInstallationPage_DIALOG_TITLE);
        this.setDescription(Messages.ImportFromInstallationPage_DIALOG_DESCRIPTION);
    }

    protected void createContents(Composite composite) {
        this.createDestinationGroup(composite, true);
        this.createInstallationTable(composite);
    }

    protected String getDestinationLabel() {
        return Messages.ImportFromInstallationPage_DESTINATION_LABEL;
    }

    protected String getDialogTitle() {
        return Messages.ImportFromInstallationPage_DIALOG_TITLE;
    }

    protected Object getInput() {
        return new IInstallableUnit[0];
    }

    protected String getInvalidDestinationMessage() {
        return Messages.ImportFromInstallationPage_INVALID_DESTINATION;
    }

    protected String getNoOptionsMessage() {
        return Messages.ImportFromInstallationPage_SELECT_COMPONENT;
    }

    protected boolean validateDestinationGroup() {
        return this.validateDestinationGroup((IProgressMonitor)new NullProgressMonitor());
    }

    private IProvisioningAgentProvider getAgentProvider() {
        if (this.agentProvider == null) {
            ServiceTracker tracker = new ServiceTracker(Platform.getBundle((String)"org.eclipse.equinox.p2.ui.importexport").getBundleContext(), IProvisioningAgentProvider.class, null);
            tracker.open();
            this.agentProvider = (IProvisioningAgentProvider)tracker.getService();
            tracker.close();
        }
        return this.agentProvider;
    }

    /*
     * Unable to fully structure code
     */
    boolean validateDestinationGroup(IProgressMonitor monitor) {
        block46: {
            block43: {
                progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                if (Display.findDisplay((Thread)Thread.currentThread()) == null) {
                    getSuperValidateDest = new Callable<Boolean>(){
                        Boolean validated;

                        @Override
                        public Boolean call() throws Exception {
                            Display.getDefault().syncExec(new Runnable(){

                                public void run() {
                                    validated = ImportFromInstallationPage.super.validateDestinationGroup();
                                }
                            });
                            return this.validated;
                        }
                    };
                    executor = Executors.newSingleThreadScheduledExecutor();
                    getSuperDestTask = executor.submit(getSuperValidateDest);
                    try {
                        try {
                            rt = getSuperDestTask.get();
                            break block43;
                        }
                        catch (Exception v0) {
                            executor.shutdown();
                            return false;
                        }
                    }
                    finally {
                        executor.shutdown();
                    }
                }
                rt = super.validateDestinationGroup();
            }
            if (rt) {
                try {
                    try {
                        block47: {
                            block48: {
                                if (Display.findDisplay((Thread)Thread.currentThread()) == null) {
                                    getDestinationValue = new Callable<String>(){
                                        String des;

                                        @Override
                                        public String call() throws Exception {
                                            if (Display.findDisplay((Thread)Thread.currentThread()) == null) {
                                                Display.getDefault().syncExec(new Runnable(){

                                                    public void run() {
                                                        des = ImportFromInstallationPage.this.getDestinationValue();
                                                    }
                                                });
                                            } else {
                                                this.des = ImportFromInstallationPage.this.getDestinationValue();
                                            }
                                            return this.des;
                                        }
                                    };
                                    executor = Executors.newSingleThreadScheduledExecutor();
                                    getDestTask = executor.submit(getDestinationValue);
                                    try {
                                        destination = getDestTask.get();
                                    }
                                    finally {
                                        executor.shutdown();
                                    }
                                } else {
                                    destination = this.getDestinationValue();
                                }
                                toBeImportedProfileId = null;
                                try {
                                    block45: {
                                        config = new File(destination, "configuration/config.ini");
                                        configArea = config.getParentFile().toURI();
                                        is = null;
                                        p2DataArea = new File(destination, "p2");
                                        try {
                                            try {
                                                props = new Properties();
                                                is = new FileInputStream(config);
                                                props.load(is);
                                                toBeImportedProfileId = props.getProperty("eclipse.p2.profile");
                                                url = props.getProperty("eclipse.p2.data.area");
                                                if (url != null) {
                                                    if (url.startsWith("@config.dir/")) {
                                                        url = "file:" + url.substring("@config.dir/".length());
                                                    }
                                                    p2DataArea = new File(URIUtil.makeAbsolute((URI)URIUtil.fromString((String)(new File(url.substring("file:".length())).isAbsolute() != false ? url : url.substring("file:".length()))), (URI)configArea));
                                                }
                                            }
                                            catch (IOException v1) {
                                                try {
                                                    is.close();
                                                }
                                                catch (IOException v2) {}
                                                is = null;
                                                break block45;
                                            }
                                        }
                                        catch (Throwable var12_20) {
                                            try {
                                                is.close();
                                            }
                                            catch (IOException v3) {}
                                            is = null;
                                            throw var12_20;
                                        }
                                        try {
                                            is.close();
                                        }
                                        catch (IOException v4) {}
                                        is = null;
                                    }
                                    if (p2DataArea.exists()) {
                                        createAgent = true;
                                        if (this.otherInstanceAgent != null) {
                                            if (!p2DataArea.equals(this.instancePath)) {
                                                this.otherInstanceAgent.stop();
                                                this.otherInstanceAgent = null;
                                                this.instancePath = p2DataArea;
                                                this.cleanLocalRepository();
                                            } else {
                                                createAgent = false;
                                            }
                                        }
                                        if (createAgent) {
                                            this.otherInstanceAgent = this.getAgentProvider().createAgent(p2DataArea.toURI());
                                        }
                                        factory = new ExtensionLocationArtifactRepositoryFactory();
                                        factory.setAgent(ImportFromInstallationPage.agent);
                                        artiRepo = factory.load(new File(destination).toURI(), 0, (IProgressMonitor)progress.newChild(50));
                                        this.artiURIs = new URI[]{artiRepo.getLocation()};
                                        metaFatory = new ExtensionLocationMetadataRepositoryFactory();
                                        metaFatory.setAgent(ImportFromInstallationPage.agent);
                                        metaRepo = metaFatory.load(new File(destination).toURI(), 0, (IProgressMonitor)progress.newChild(50));
                                        this.metaURIs = new URI[]{metaRepo.getLocation()};
                                        break block46;
                                    }
                                    throw new FileNotFoundException();
                                }
                                catch (ProvisionException v5) {
                                    if (this.otherInstanceAgent == null) break block47;
                                    this.toBeImportedProfile = null;
                                    manager = (IMetadataRepositoryManager)ImportFromInstallationPage.agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
                                    artifactManager = (IArtifactRepositoryManager)ImportFromInstallationPage.agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
                                    registry = (IProfileRegistry)this.otherInstanceAgent.getService(IProfileRegistry.SERVICE_NAME);
                                    if (toBeImportedProfileId != null) {
                                        this.toBeImportedProfile = registry.getProfile(toBeImportedProfileId);
                                    }
                                    if (this.toBeImportedProfile != null) break block48;
                                    existingProfiles = registry.getProfiles();
                                    if (existingProfiles.length == 1) {
                                        this.toBeImportedProfile = existingProfiles[0];
                                        break block48;
                                    }
                                    var13_25 = existingProfiles;
                                    artiRepo = existingProfiles.length;
                                    factory = 0;
                                    ** while (factory < artiRepo)
                                }
lbl-1000:
                                // 1 sources

                                {
                                    existingProfile = var13_25[factory];
                                    if (this.toBeImportedProfile == null) {
                                        this.toBeImportedProfile = existingProfile;
                                    } else if (this.toBeImportedProfile.getTimestamp() < existingProfile.getTimestamp()) {
                                        this.toBeImportedProfile = existingProfile;
                                    }
                                    ++factory;
                                    continue;
                                }
                            }
                            location = (IAgentLocation)this.otherInstanceAgent.getService(IAgentLocation.SERVICE_NAME);
                            engineDataArea = location.getDataArea("org.eclipse.equinox.p2.engine");
                            progress.setWorkRemaining(50);
                            metaRepo = manager.loadRepository(engineDataArea.resolve("profileRegistry/" + this.toBeImportedProfile.getProfileId() + ".profile"), (IProgressMonitor)progress.newChild(25));
                            this.metaURIs = new URI[]{metaRepo.getLocation()};
                            artiRepo = artifactManager.loadRepository(new File(destination).toURI(), (IProgressMonitor)progress.newChild(25));
                            this.artiURIs = new URI[]{artiRepo.getLocation()};
                            break block46;
                        }
                        throw new Exception();
                    }
                    catch (Exception v6) {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                ImportFromInstallationPage.this.setErrorMessage(ImportFromInstallationPage.this.getInvalidDestinationMessage());
                            }
                        });
                        rt = false;
                        if (this.otherInstanceAgent != null) {
                            this.otherInstanceAgent.stop();
                        }
                        this.otherInstanceAgent = null;
                        this.toBeImportedProfile = null;
                        this.cleanLocalRepository();
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        }
        return rt;
    }

    protected void giveFocusToDestination() {
        this.destinationBrowseButton.setFocus();
    }

    protected void handleDestinationBrowseButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.getContainer().getShell());
        dialog.setText(this.getDialogTitle());
        dialog.setFilterPath(this.getDestinationValue());
        String selectedFileName = dialog.open();
        if (selectedFileName != null) {
            this.setDestinationValue(selectedFileName);
            this.handleDestinationChanged(selectedFileName);
        }
    }

    protected void handleDestinationChanged(String newDestination) {
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    ProfileElement input = null;
                    if (ImportFromInstallationPage.this.validateDestinationGroup(monitor)) {
                        final IProfile currentProfile = ImportFromInstallationPage.this.toBeImportedProfile;
                        ProfileElement element = new ProfileElement(null, currentProfile.getProfileId()){

                            public IQueryable<?> getQueryable() {
                                return currentProfile;
                            }
                        };
                        element.setQueryable((IQueryable)currentProfile);
                        input = element;
                    }
                    final ProfileElement viewerInput = input;
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            (this).ImportFromInstallationPage.this.viewer.setInput(viewerInput);
                            ImportFromInstallationPage.this.updatePageCompletion();
                        }
                    });
                }
            });
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(e.getLocalizedMessage());
            this.setPageComplete(false);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected boolean validDestination() {
        if (this.destinationNameField == null) {
            return true;
        }
        File file = new File(this.getDestinationValue());
        return file.exists() && file.isDirectory();
    }

    protected ITableLabelProvider getLabelProvider() {
        return new ImportFromInstallationLabelProvider();
    }

    public void dispose() {
        super.dispose();
        if (this.otherInstanceAgent != null) {
            this.otherInstanceAgent.stop();
            this.otherInstanceAgent = null;
            this.toBeImportedProfile = null;
        }
        if (this.getWizard().performCancel()) {
            this.cleanLocalRepository();
        }
    }

    public void cleanLocalRepository() {
        if (this.metaURIs != null && this.metaURIs.length > 0) {
            IProvisioningAgent runningAgent = this.getProvisioningUI().getSession().getProvisioningAgent();
            IMetadataRepositoryManager manager = (IMetadataRepositoryManager)runningAgent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            URI[] uRIArray = this.metaURIs;
            int n = this.metaURIs.length;
            int n2 = 0;
            while (n2 < n) {
                URI uri = uRIArray[n2];
                manager.removeRepository(uri);
                ++n2;
            }
            IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)runningAgent.getService(IArtifactRepositoryManager.SERVICE_NAME);
            URI[] uRIArray2 = this.artiURIs;
            int n3 = this.artiURIs.length;
            n = 0;
            while (n < n3) {
                URI uri = uRIArray2[n];
                artifactManager.removeRepository(uri);
                ++n;
            }
        }
    }

    public Object[] getCheckedIUElements() {
        return this.viewer.getCheckedElements();
    }

    public Object[] getSelectedIUElements() {
        return null;
    }

    public void setCheckedElements(Object[] elements) {
        new UnsupportedOperationException();
    }

    public ProvisioningContext getProvisioningContext() {
        ProvisioningContext context = new ProvisioningContext(this.getProvisioningUI().getSession().getProvisioningAgent());
        context.setArtifactRepositories(this.artiURIs);
        context.setMetadataRepositories(this.metaURIs);
        return context;
    }

    class ImportFromInstallationLabelProvider
    extends IUDetailsLabelProvider {
        ImportFromInstallationLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = super.getColumnText(element, columnIndex);
            if (columnIndex == 0) {
                IInstallableUnit iu = (IInstallableUnit)ProvUI.getAdapter((Object)element, IInstallableUnit.class);
                return ImportFromInstallationPage.this.getIUNameWithDetail(iu);
            }
            return text;
        }

        public Color getForeground(Object element) {
            IInstallableUnit iu = (IInstallableUnit)ProvUI.getAdapter((Object)element, IInstallableUnit.class);
            if (ImportFromInstallationPage.this.hasInstalled(iu)) {
                return Display.getDefault().getSystemColor(15);
            }
            return super.getForeground(element);
        }
    }
}

