#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Whispered World
# send your bug reports to contact@dotslashplay.it
###

script_version=20240903.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='the-whispered-world'
GAME_NAME='The Whispered World'

ARCHIVE_BASE_0_NAME='gog_the_whispered_world_special_edition_2.0.0.1.sh'
ARCHIVE_BASE_0_MD5='485368f130f2d82f564a0159cd497437'
ARCHIVE_BASE_0_SIZE='2200000'
ARCHIVE_BASE_0_VERSION='3.2.0418-gog2.0.0.1'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/the_whispered_world_special_edition'

## Optional icons pack
ARCHIVE_OPTIONAL_ICONS_NAME='the-whispered-world_icons.tar.gz'
ARCHIVE_OPTIONAL_ICONS_MD5='3ec301bf71cf279aa8de91c136e16388'
ARCHIVE_OPTIONAL_ICONS_URL='https://downloads.dotslashplay.it/resources/the-whispered-world'
CONTENT_ICONS_PATH='.'
CONTENT_ICONS_FILES='
16x16
32x32
48x48
256x256'

VISIONAIRE_NAME='TWWSE'

CONTENT_PATH_DEFAULT='data/noarch/game'

PKG_BIN_ARCH='64'

## Ensure smooth upgrades from packages generated by game scripts pre-20231005.1
PKG_DATA_PROVIDES='
the-whispered-world-videos'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
