#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Fallout Tactics
# send your bug reports to contact@dotslashplay.it
###

script_version=20230331.2

GAME_ID='fallout-tactics'
GAME_NAME='Fallout Tactics'

ARCHIVE_BASE_EN_0='setup_fallout_tactics_2.1.0.12.exe'
ARCHIVE_BASE_EN_0_MD5='9cc1d9987d8a2fa6c1cc6cf9837758ad'
ARCHIVE_BASE_EN_0_TYPE='innosetup'
ARCHIVE_BASE_EN_0_SIZE='1900000'
ARCHIVE_BASE_EN_0_VERSION='1.27-gog2.1.0.12'
ARCHIVE_BASE_EN_0_URL='https://www.gog.com/game/fallout_tactics'

ARCHIVE_BASE_FR_0='setup_fallout_tactics_french_2.1.0.12.exe'
ARCHIVE_BASE_FR_0_MD5='520c29934290910cdeecbc7fcca68f2b'
ARCHIVE_BASE_FR_0_TYPE='innosetup'
ARCHIVE_BASE_FR_0_SIZE='1900000'
ARCHIVE_BASE_FR_0_VERSION='1.27-gog2.1.0.12'
ARCHIVE_BASE_FR_0_URL='https://www.gog.com/game/fallout_tactics'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_BIN_FILES='
*.dll
*.exe
core/*.cfg'
CONTENT_GAME_L10N_FILES='
tactics.cfg
core/locale
core/movie
core/music/custom/readme.txt
core/entities_0.bos
core/gui_0.bos
core/locale_0.bos
core/loc-mis_*.bos
core/mis-core_?.bos'
CONTENT_GAME_DATA_FILES='
bitmaps
miles
fallouttactics.ico
core/missions
core/tables
core/user
core/*.bos
core/game.pck'
CONTENT_DOC_L10N_FILES='
readme.txt
patch readme.txt
fallout tactics_license.rtf'
CONTENT_DOC_DATA_FILES='
*.pdf
editor_readme.txt
fallout editor end user license agreement.txt
fot_hires_readme.rtf
readme.rtf'

USER_PERSISTENT_DIRECTORIES='
core/user'
USER_PERSISTENT_FILES='
*.cfg
core/*.cfg
bos.exe
ft tools.exe'

APPLICATIONS_LIST='APP_MAIN APP_MAIN_RESOLUTION APP_TOOLS APP_TOOLS_RESOLUTION'

APP_MAIN_EXE='bos.exe'
APP_MAIN_ICON='fallouttactics.ico'

APP_MAIN_RESOLUTION_ID="${GAME_ID}-hires"
APP_MAIN_RESOLUTION_NAME="$GAME_NAME - HD patch"
APP_MAIN_RESOLUTION_CAT='Settings'
APP_MAIN_RESOLUTION_EXE='fot_hires_patch.exe'
APP_MAIN_RESOLUTION_ICON='fallouttactics.ico'

APP_TOOLS_ID="${GAME_ID}-tools"
APP_TOOLS_NAME="$GAME_NAME - Toolbox"
APP_TOOLS_EXE='ft tools.exe'
APP_TOOLS_ICON='fallouttactics.ico'

APP_TOOLS_RESOLUTION_ID="${APP_TOOLS_ID}-hires"
APP_TOOLS_RESOLUTION_NAME="$APP_TOOLS_NAME - HD patch"
APP_TOOLS_RESOLUTION_CAT='Settings'
APP_TOOLS_RESOLUTION_EXE='fttools_hires_patch.exe'
APP_TOOLS_RESOLUTION_ICON='fallouttactics.ico'

PACKAGES_LIST='PKG_BIN PKG_L10N PKG_DATA'

PKG_L10N_ID="${GAME_ID}-l10n"
PKG_L10N_ID_EN="${PKG_L10N_ID}-en"
PKG_L10N_ID_FR="${PKG_L10N_ID}-fr"
PKG_L10N_PROVIDES="
$PKG_L10N_ID"
PKG_L10N_DESCRIPTION_EN='English localization'
PKG_L10N_DESCRIPTION_FR='French localization'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID $PKG_L10N_ID"

# Load common functions

target_version='2.23'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
