#region License
//
// The Open Toolkit Library License
//
// Copyright (c) 2006 - 2009 the Open Toolkit library.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights to 
// use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
// the Software, and to permit persons to whom the Software is furnished to do
// so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
//
#endregion

namespace OpenTK.Graphics.OpenGL
{
    using System;
    using System.Text;
    using System.Runtime.InteropServices;
    #pragma warning disable 3019
    #pragma warning disable 1591
    #pragma warning disable 1572
    #pragma warning disable 1573

    partial class GL
    {

        public static partial class GL_3dfx
        {
            [AutoGenerated(Category = "3DfxTbuffer", Version = "1.2", EntryPoint = "glTbufferMask3DFX")]
            public static 
            void TbufferMask(Int32 mask)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glTbufferMask3DFX((UInt32)mask);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "3DfxTbuffer", Version = "1.2", EntryPoint = "glTbufferMask3DFX")]
            public static 
            void TbufferMask(UInt32 mask)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glTbufferMask3DFX((UInt32)mask);
                #if DEBUG
                }
                #endif
            }

        }

        public static partial class Amd
        {
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glBeginPerfMonitorAMD")]
            public static 
            void BeginPerfMonitor(Int32 monitor)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBeginPerfMonitorAMD((UInt32)monitor);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glBeginPerfMonitorAMD")]
            public static 
            void BeginPerfMonitor(UInt32 monitor)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBeginPerfMonitorAMD((UInt32)monitor);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AmdDrawBuffersBlend", Version = "2.0", EntryPoint = "glBlendEquationIndexedAMD")]
            public static 
            void BlendEquationIndexed(Int32 buf, OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend mode)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBlendEquationIndexedAMD((UInt32)buf, (OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend)mode);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdDrawBuffersBlend", Version = "2.0", EntryPoint = "glBlendEquationIndexedAMD")]
            public static 
            void BlendEquationIndexed(UInt32 buf, OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend mode)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBlendEquationIndexedAMD((UInt32)buf, (OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend)mode);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AmdDrawBuffersBlend", Version = "2.0", EntryPoint = "glBlendEquationSeparateIndexedAMD")]
            public static 
            void BlendEquationSeparateIndexed(Int32 buf, OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend modeRGB, OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend modeAlpha)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBlendEquationSeparateIndexedAMD((UInt32)buf, (OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend)modeRGB, (OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend)modeAlpha);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdDrawBuffersBlend", Version = "2.0", EntryPoint = "glBlendEquationSeparateIndexedAMD")]
            public static 
            void BlendEquationSeparateIndexed(UInt32 buf, OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend modeRGB, OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend modeAlpha)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBlendEquationSeparateIndexedAMD((UInt32)buf, (OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend)modeRGB, (OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend)modeAlpha);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AmdDrawBuffersBlend", Version = "2.0", EntryPoint = "glBlendFuncIndexedAMD")]
            public static 
            void BlendFuncIndexed(Int32 buf, OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend src, OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend dst)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBlendFuncIndexedAMD((UInt32)buf, (OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend)src, (OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend)dst);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdDrawBuffersBlend", Version = "2.0", EntryPoint = "glBlendFuncIndexedAMD")]
            public static 
            void BlendFuncIndexed(UInt32 buf, OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend src, OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend dst)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBlendFuncIndexedAMD((UInt32)buf, (OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend)src, (OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend)dst);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AmdDrawBuffersBlend", Version = "2.0", EntryPoint = "glBlendFuncSeparateIndexedAMD")]
            public static 
            void BlendFuncSeparateIndexed(Int32 buf, OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend srcRGB, OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend dstRGB, OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend srcAlpha, OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend dstAlpha)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBlendFuncSeparateIndexedAMD((UInt32)buf, (OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend)srcRGB, (OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend)dstRGB, (OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend)srcAlpha, (OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend)dstAlpha);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdDrawBuffersBlend", Version = "2.0", EntryPoint = "glBlendFuncSeparateIndexedAMD")]
            public static 
            void BlendFuncSeparateIndexed(UInt32 buf, OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend srcRGB, OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend dstRGB, OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend srcAlpha, OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend dstAlpha)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBlendFuncSeparateIndexedAMD((UInt32)buf, (OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend)srcRGB, (OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend)dstRGB, (OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend)srcAlpha, (OpenTK.Graphics.OpenGL.AmdDrawBuffersBlend)dstAlpha);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glDeletePerfMonitorsAMD")]
            public static 
            void DeletePerfMonitors(Int32 n, [OutAttribute] Int32[] monitors)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* monitors_ptr = monitors)
                    {
                        Delegates.glDeletePerfMonitorsAMD((Int32)n, (UInt32*)monitors_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glDeletePerfMonitorsAMD")]
            public static 
            void DeletePerfMonitors(Int32 n, [OutAttribute] out Int32 monitors)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* monitors_ptr = &monitors)
                    {
                        Delegates.glDeletePerfMonitorsAMD((Int32)n, (UInt32*)monitors_ptr);
                        monitors = *monitors_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glDeletePerfMonitorsAMD")]
            public static 
            unsafe void DeletePerfMonitors(Int32 n, [OutAttribute] Int32* monitors)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeletePerfMonitorsAMD((Int32)n, (UInt32*)monitors);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glDeletePerfMonitorsAMD")]
            public static 
            void DeletePerfMonitors(Int32 n, [OutAttribute] UInt32[] monitors)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* monitors_ptr = monitors)
                    {
                        Delegates.glDeletePerfMonitorsAMD((Int32)n, (UInt32*)monitors_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glDeletePerfMonitorsAMD")]
            public static 
            void DeletePerfMonitors(Int32 n, [OutAttribute] out UInt32 monitors)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* monitors_ptr = &monitors)
                    {
                        Delegates.glDeletePerfMonitorsAMD((Int32)n, (UInt32*)monitors_ptr);
                        monitors = *monitors_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glDeletePerfMonitorsAMD")]
            public static 
            unsafe void DeletePerfMonitors(Int32 n, [OutAttribute] UInt32* monitors)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeletePerfMonitorsAMD((Int32)n, (UInt32*)monitors);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glEndPerfMonitorAMD")]
            public static 
            void EndPerfMonitor(Int32 monitor)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glEndPerfMonitorAMD((UInt32)monitor);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glEndPerfMonitorAMD")]
            public static 
            void EndPerfMonitor(UInt32 monitor)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glEndPerfMonitorAMD((UInt32)monitor);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGenPerfMonitorsAMD")]
            public static 
            void GenPerfMonitors(Int32 n, [OutAttribute] Int32[] monitors)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* monitors_ptr = monitors)
                    {
                        Delegates.glGenPerfMonitorsAMD((Int32)n, (UInt32*)monitors_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGenPerfMonitorsAMD")]
            public static 
            void GenPerfMonitors(Int32 n, [OutAttribute] out Int32 monitors)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* monitors_ptr = &monitors)
                    {
                        Delegates.glGenPerfMonitorsAMD((Int32)n, (UInt32*)monitors_ptr);
                        monitors = *monitors_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGenPerfMonitorsAMD")]
            public static 
            unsafe void GenPerfMonitors(Int32 n, [OutAttribute] Int32* monitors)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGenPerfMonitorsAMD((Int32)n, (UInt32*)monitors);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGenPerfMonitorsAMD")]
            public static 
            void GenPerfMonitors(Int32 n, [OutAttribute] UInt32[] monitors)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* monitors_ptr = monitors)
                    {
                        Delegates.glGenPerfMonitorsAMD((Int32)n, (UInt32*)monitors_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGenPerfMonitorsAMD")]
            public static 
            void GenPerfMonitors(Int32 n, [OutAttribute] out UInt32 monitors)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* monitors_ptr = &monitors)
                    {
                        Delegates.glGenPerfMonitorsAMD((Int32)n, (UInt32*)monitors_ptr);
                        monitors = *monitors_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGenPerfMonitorsAMD")]
            public static 
            unsafe void GenPerfMonitors(Int32 n, [OutAttribute] UInt32* monitors)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGenPerfMonitorsAMD((Int32)n, (UInt32*)monitors);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCounterDataAMD")]
            public static 
            unsafe void GetPerfMonitorCounterData(Int32 monitor, OpenTK.Graphics.OpenGL.AmdPerformanceMonitor pname, Int32 dataSize, [OutAttribute] Int32[] data, [OutAttribute] Int32* bytesWritten)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                fixed (Int32* data_ptr = data)
                {
                    Delegates.glGetPerfMonitorCounterDataAMD((UInt32)monitor, (OpenTK.Graphics.OpenGL.AmdPerformanceMonitor)pname, (Int32)dataSize, (UInt32*)data_ptr, (Int32*)bytesWritten);
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCounterDataAMD")]
            public static 
            void GetPerfMonitorCounterData(Int32 monitor, OpenTK.Graphics.OpenGL.AmdPerformanceMonitor pname, Int32 dataSize, [OutAttribute] out Int32 data, [OutAttribute] out Int32 bytesWritten)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* data_ptr = &data)
                    fixed (Int32* bytesWritten_ptr = &bytesWritten)
                    {
                        Delegates.glGetPerfMonitorCounterDataAMD((UInt32)monitor, (OpenTK.Graphics.OpenGL.AmdPerformanceMonitor)pname, (Int32)dataSize, (UInt32*)data_ptr, (Int32*)bytesWritten_ptr);
                        data = *data_ptr;
                        bytesWritten = *bytesWritten_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCounterDataAMD")]
            public static 
            unsafe void GetPerfMonitorCounterData(Int32 monitor, OpenTK.Graphics.OpenGL.AmdPerformanceMonitor pname, Int32 dataSize, [OutAttribute] Int32* data, [OutAttribute] Int32* bytesWritten)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetPerfMonitorCounterDataAMD((UInt32)monitor, (OpenTK.Graphics.OpenGL.AmdPerformanceMonitor)pname, (Int32)dataSize, (UInt32*)data, (Int32*)bytesWritten);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCounterDataAMD")]
            public static 
            unsafe void GetPerfMonitorCounterData(UInt32 monitor, OpenTK.Graphics.OpenGL.AmdPerformanceMonitor pname, Int32 dataSize, [OutAttribute] UInt32[] data, [OutAttribute] Int32* bytesWritten)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                fixed (UInt32* data_ptr = data)
                {
                    Delegates.glGetPerfMonitorCounterDataAMD((UInt32)monitor, (OpenTK.Graphics.OpenGL.AmdPerformanceMonitor)pname, (Int32)dataSize, (UInt32*)data_ptr, (Int32*)bytesWritten);
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCounterDataAMD")]
            public static 
            void GetPerfMonitorCounterData(UInt32 monitor, OpenTK.Graphics.OpenGL.AmdPerformanceMonitor pname, Int32 dataSize, [OutAttribute] out UInt32 data, [OutAttribute] out Int32 bytesWritten)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* data_ptr = &data)
                    fixed (Int32* bytesWritten_ptr = &bytesWritten)
                    {
                        Delegates.glGetPerfMonitorCounterDataAMD((UInt32)monitor, (OpenTK.Graphics.OpenGL.AmdPerformanceMonitor)pname, (Int32)dataSize, (UInt32*)data_ptr, (Int32*)bytesWritten_ptr);
                        data = *data_ptr;
                        bytesWritten = *bytesWritten_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCounterDataAMD")]
            public static 
            unsafe void GetPerfMonitorCounterData(UInt32 monitor, OpenTK.Graphics.OpenGL.AmdPerformanceMonitor pname, Int32 dataSize, [OutAttribute] UInt32* data, [OutAttribute] Int32* bytesWritten)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetPerfMonitorCounterDataAMD((UInt32)monitor, (OpenTK.Graphics.OpenGL.AmdPerformanceMonitor)pname, (Int32)dataSize, (UInt32*)data, (Int32*)bytesWritten);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCounterInfoAMD")]
            public static 
            void GetPerfMonitorCounterInfo(Int32 group, Int32 counter, OpenTK.Graphics.OpenGL.AmdPerformanceMonitor pname, [OutAttribute] IntPtr data)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetPerfMonitorCounterInfoAMD((UInt32)group, (UInt32)counter, (OpenTK.Graphics.OpenGL.AmdPerformanceMonitor)pname, (IntPtr)data);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCounterInfoAMD")]
            public static 
            void GetPerfMonitorCounterInfo<T3>(Int32 group, Int32 counter, OpenTK.Graphics.OpenGL.AmdPerformanceMonitor pname, [InAttribute, OutAttribute] T3[] data)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetPerfMonitorCounterInfoAMD((UInt32)group, (UInt32)counter, (OpenTK.Graphics.OpenGL.AmdPerformanceMonitor)pname, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCounterInfoAMD")]
            public static 
            void GetPerfMonitorCounterInfo<T3>(Int32 group, Int32 counter, OpenTK.Graphics.OpenGL.AmdPerformanceMonitor pname, [InAttribute, OutAttribute] T3[,] data)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetPerfMonitorCounterInfoAMD((UInt32)group, (UInt32)counter, (OpenTK.Graphics.OpenGL.AmdPerformanceMonitor)pname, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCounterInfoAMD")]
            public static 
            void GetPerfMonitorCounterInfo<T3>(Int32 group, Int32 counter, OpenTK.Graphics.OpenGL.AmdPerformanceMonitor pname, [InAttribute, OutAttribute] T3[,,] data)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetPerfMonitorCounterInfoAMD((UInt32)group, (UInt32)counter, (OpenTK.Graphics.OpenGL.AmdPerformanceMonitor)pname, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCounterInfoAMD")]
            public static 
            void GetPerfMonitorCounterInfo<T3>(Int32 group, Int32 counter, OpenTK.Graphics.OpenGL.AmdPerformanceMonitor pname, [InAttribute, OutAttribute] ref T3 data)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetPerfMonitorCounterInfoAMD((UInt32)group, (UInt32)counter, (OpenTK.Graphics.OpenGL.AmdPerformanceMonitor)pname, (IntPtr)data_ptr.AddrOfPinnedObject());
                    data = (T3)data_ptr.Target;
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCounterInfoAMD")]
            public static 
            void GetPerfMonitorCounterInfo(UInt32 group, UInt32 counter, OpenTK.Graphics.OpenGL.AmdPerformanceMonitor pname, [OutAttribute] IntPtr data)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetPerfMonitorCounterInfoAMD((UInt32)group, (UInt32)counter, (OpenTK.Graphics.OpenGL.AmdPerformanceMonitor)pname, (IntPtr)data);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCounterInfoAMD")]
            public static 
            void GetPerfMonitorCounterInfo<T3>(UInt32 group, UInt32 counter, OpenTK.Graphics.OpenGL.AmdPerformanceMonitor pname, [InAttribute, OutAttribute] T3[] data)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetPerfMonitorCounterInfoAMD((UInt32)group, (UInt32)counter, (OpenTK.Graphics.OpenGL.AmdPerformanceMonitor)pname, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCounterInfoAMD")]
            public static 
            void GetPerfMonitorCounterInfo<T3>(UInt32 group, UInt32 counter, OpenTK.Graphics.OpenGL.AmdPerformanceMonitor pname, [InAttribute, OutAttribute] T3[,] data)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetPerfMonitorCounterInfoAMD((UInt32)group, (UInt32)counter, (OpenTK.Graphics.OpenGL.AmdPerformanceMonitor)pname, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCounterInfoAMD")]
            public static 
            void GetPerfMonitorCounterInfo<T3>(UInt32 group, UInt32 counter, OpenTK.Graphics.OpenGL.AmdPerformanceMonitor pname, [InAttribute, OutAttribute] T3[,,] data)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetPerfMonitorCounterInfoAMD((UInt32)group, (UInt32)counter, (OpenTK.Graphics.OpenGL.AmdPerformanceMonitor)pname, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCounterInfoAMD")]
            public static 
            void GetPerfMonitorCounterInfo<T3>(UInt32 group, UInt32 counter, OpenTK.Graphics.OpenGL.AmdPerformanceMonitor pname, [InAttribute, OutAttribute] ref T3 data)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetPerfMonitorCounterInfoAMD((UInt32)group, (UInt32)counter, (OpenTK.Graphics.OpenGL.AmdPerformanceMonitor)pname, (IntPtr)data_ptr.AddrOfPinnedObject());
                    data = (T3)data_ptr.Target;
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCountersAMD")]
            public static 
            void GetPerfMonitorCounters(Int32 group, [OutAttribute] out Int32 numCounters, [OutAttribute] out Int32 maxActiveCounters, Int32 counterSize, [OutAttribute] out Int32 counters)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* numCounters_ptr = &numCounters)
                    fixed (Int32* maxActiveCounters_ptr = &maxActiveCounters)
                    fixed (Int32* counters_ptr = &counters)
                    {
                        Delegates.glGetPerfMonitorCountersAMD((UInt32)group, (Int32*)numCounters_ptr, (Int32*)maxActiveCounters_ptr, (Int32)counterSize, (UInt32*)counters_ptr);
                        numCounters = *numCounters_ptr;
                        maxActiveCounters = *maxActiveCounters_ptr;
                        counters = *counters_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCountersAMD")]
            public static 
            unsafe void GetPerfMonitorCounters(Int32 group, [OutAttribute] Int32* numCounters, [OutAttribute] Int32* maxActiveCounters, Int32 counterSize, [OutAttribute] Int32[] counters)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                fixed (Int32* counters_ptr = counters)
                {
                    Delegates.glGetPerfMonitorCountersAMD((UInt32)group, (Int32*)numCounters, (Int32*)maxActiveCounters, (Int32)counterSize, (UInt32*)counters_ptr);
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCountersAMD")]
            public static 
            unsafe void GetPerfMonitorCounters(Int32 group, [OutAttribute] Int32* numCounters, [OutAttribute] Int32* maxActiveCounters, Int32 counterSize, [OutAttribute] Int32* counters)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetPerfMonitorCountersAMD((UInt32)group, (Int32*)numCounters, (Int32*)maxActiveCounters, (Int32)counterSize, (UInt32*)counters);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCountersAMD")]
            public static 
            void GetPerfMonitorCounters(UInt32 group, [OutAttribute] out Int32 numCounters, [OutAttribute] out Int32 maxActiveCounters, Int32 counterSize, [OutAttribute] out UInt32 counters)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* numCounters_ptr = &numCounters)
                    fixed (Int32* maxActiveCounters_ptr = &maxActiveCounters)
                    fixed (UInt32* counters_ptr = &counters)
                    {
                        Delegates.glGetPerfMonitorCountersAMD((UInt32)group, (Int32*)numCounters_ptr, (Int32*)maxActiveCounters_ptr, (Int32)counterSize, (UInt32*)counters_ptr);
                        numCounters = *numCounters_ptr;
                        maxActiveCounters = *maxActiveCounters_ptr;
                        counters = *counters_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCountersAMD")]
            public static 
            unsafe void GetPerfMonitorCounters(UInt32 group, [OutAttribute] Int32* numCounters, [OutAttribute] Int32* maxActiveCounters, Int32 counterSize, [OutAttribute] UInt32[] counters)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                fixed (UInt32* counters_ptr = counters)
                {
                    Delegates.glGetPerfMonitorCountersAMD((UInt32)group, (Int32*)numCounters, (Int32*)maxActiveCounters, (Int32)counterSize, (UInt32*)counters_ptr);
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCountersAMD")]
            public static 
            unsafe void GetPerfMonitorCounters(UInt32 group, [OutAttribute] Int32* numCounters, [OutAttribute] Int32* maxActiveCounters, Int32 counterSize, [OutAttribute] UInt32* counters)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetPerfMonitorCountersAMD((UInt32)group, (Int32*)numCounters, (Int32*)maxActiveCounters, (Int32)counterSize, (UInt32*)counters);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCounterStringAMD")]
            public static 
            void GetPerfMonitorCounterString(Int32 group, Int32 counter, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder counterString)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    {
                        Delegates.glGetPerfMonitorCounterStringAMD((UInt32)group, (UInt32)counter, (Int32)bufSize, (Int32*)length_ptr, (StringBuilder)counterString);
                        length = *length_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCounterStringAMD")]
            public static 
            unsafe void GetPerfMonitorCounterString(Int32 group, Int32 counter, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder counterString)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetPerfMonitorCounterStringAMD((UInt32)group, (UInt32)counter, (Int32)bufSize, (Int32*)length, (StringBuilder)counterString);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCounterStringAMD")]
            public static 
            void GetPerfMonitorCounterString(UInt32 group, UInt32 counter, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder counterString)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    {
                        Delegates.glGetPerfMonitorCounterStringAMD((UInt32)group, (UInt32)counter, (Int32)bufSize, (Int32*)length_ptr, (StringBuilder)counterString);
                        length = *length_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCounterStringAMD")]
            public static 
            unsafe void GetPerfMonitorCounterString(UInt32 group, UInt32 counter, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder counterString)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetPerfMonitorCounterStringAMD((UInt32)group, (UInt32)counter, (Int32)bufSize, (Int32*)length, (StringBuilder)counterString);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorGroupsAMD")]
            public static 
            void GetPerfMonitorGroup([OutAttribute] out Int32 numGroups, Int32 groupsSize, [OutAttribute] out Int32 groups)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* numGroups_ptr = &numGroups)
                    fixed (Int32* groups_ptr = &groups)
                    {
                        Delegates.glGetPerfMonitorGroupsAMD((Int32*)numGroups_ptr, (Int32)groupsSize, (UInt32*)groups_ptr);
                        numGroups = *numGroups_ptr;
                        groups = *groups_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorGroupsAMD")]
            public static 
            void GetPerfMonitorGroup([OutAttribute] out Int32 numGroups, Int32 groupsSize, [OutAttribute] out UInt32 groups)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* numGroups_ptr = &numGroups)
                    fixed (UInt32* groups_ptr = &groups)
                    {
                        Delegates.glGetPerfMonitorGroupsAMD((Int32*)numGroups_ptr, (Int32)groupsSize, (UInt32*)groups_ptr);
                        numGroups = *numGroups_ptr;
                        groups = *groups_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorGroupsAMD")]
            public static 
            unsafe void GetPerfMonitorGroup([OutAttribute] Int32* numGroups, Int32 groupsSize, [OutAttribute] Int32[] groups)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                fixed (Int32* groups_ptr = groups)
                {
                    Delegates.glGetPerfMonitorGroupsAMD((Int32*)numGroups, (Int32)groupsSize, (UInt32*)groups_ptr);
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorGroupsAMD")]
            public static 
            unsafe void GetPerfMonitorGroup([OutAttribute] Int32* numGroups, Int32 groupsSize, [OutAttribute] Int32* groups)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetPerfMonitorGroupsAMD((Int32*)numGroups, (Int32)groupsSize, (UInt32*)groups);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorGroupsAMD")]
            public static 
            unsafe void GetPerfMonitorGroup([OutAttribute] Int32* numGroups, Int32 groupsSize, [OutAttribute] UInt32[] groups)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                fixed (UInt32* groups_ptr = groups)
                {
                    Delegates.glGetPerfMonitorGroupsAMD((Int32*)numGroups, (Int32)groupsSize, (UInt32*)groups_ptr);
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorGroupsAMD")]
            public static 
            unsafe void GetPerfMonitorGroup([OutAttribute] Int32* numGroups, Int32 groupsSize, [OutAttribute] UInt32* groups)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetPerfMonitorGroupsAMD((Int32*)numGroups, (Int32)groupsSize, (UInt32*)groups);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorGroupStringAMD")]
            public static 
            void GetPerfMonitorGroupString(Int32 group, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder groupString)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    {
                        Delegates.glGetPerfMonitorGroupStringAMD((UInt32)group, (Int32)bufSize, (Int32*)length_ptr, (StringBuilder)groupString);
                        length = *length_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorGroupStringAMD")]
            public static 
            unsafe void GetPerfMonitorGroupString(Int32 group, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder groupString)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetPerfMonitorGroupStringAMD((UInt32)group, (Int32)bufSize, (Int32*)length, (StringBuilder)groupString);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorGroupStringAMD")]
            public static 
            void GetPerfMonitorGroupString(UInt32 group, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder groupString)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    {
                        Delegates.glGetPerfMonitorGroupStringAMD((UInt32)group, (Int32)bufSize, (Int32*)length_ptr, (StringBuilder)groupString);
                        length = *length_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorGroupStringAMD")]
            public static 
            unsafe void GetPerfMonitorGroupString(UInt32 group, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder groupString)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetPerfMonitorGroupStringAMD((UInt32)group, (Int32)bufSize, (Int32*)length, (StringBuilder)groupString);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glSelectPerfMonitorCountersAMD")]
            public static 
            void SelectPerfMonitorCounters(Int32 monitor, bool enable, Int32 group, Int32 numCounters, [OutAttribute] Int32[] counterList)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* counterList_ptr = counterList)
                    {
                        Delegates.glSelectPerfMonitorCountersAMD((UInt32)monitor, (bool)enable, (UInt32)group, (Int32)numCounters, (UInt32*)counterList_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glSelectPerfMonitorCountersAMD")]
            public static 
            void SelectPerfMonitorCounters(Int32 monitor, bool enable, Int32 group, Int32 numCounters, [OutAttribute] out Int32 counterList)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* counterList_ptr = &counterList)
                    {
                        Delegates.glSelectPerfMonitorCountersAMD((UInt32)monitor, (bool)enable, (UInt32)group, (Int32)numCounters, (UInt32*)counterList_ptr);
                        counterList = *counterList_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glSelectPerfMonitorCountersAMD")]
            public static 
            unsafe void SelectPerfMonitorCounters(Int32 monitor, bool enable, Int32 group, Int32 numCounters, [OutAttribute] Int32* counterList)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glSelectPerfMonitorCountersAMD((UInt32)monitor, (bool)enable, (UInt32)group, (Int32)numCounters, (UInt32*)counterList);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glSelectPerfMonitorCountersAMD")]
            public static 
            void SelectPerfMonitorCounters(UInt32 monitor, bool enable, UInt32 group, Int32 numCounters, [OutAttribute] UInt32[] counterList)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* counterList_ptr = counterList)
                    {
                        Delegates.glSelectPerfMonitorCountersAMD((UInt32)monitor, (bool)enable, (UInt32)group, (Int32)numCounters, (UInt32*)counterList_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glSelectPerfMonitorCountersAMD")]
            public static 
            void SelectPerfMonitorCounters(UInt32 monitor, bool enable, UInt32 group, Int32 numCounters, [OutAttribute] out UInt32 counterList)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* counterList_ptr = &counterList)
                    {
                        Delegates.glSelectPerfMonitorCountersAMD((UInt32)monitor, (bool)enable, (UInt32)group, (Int32)numCounters, (UInt32*)counterList_ptr);
                        counterList = *counterList_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glSelectPerfMonitorCountersAMD")]
            public static 
            unsafe void SelectPerfMonitorCounters(UInt32 monitor, bool enable, UInt32 group, Int32 numCounters, [OutAttribute] UInt32* counterList)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glSelectPerfMonitorCountersAMD((UInt32)monitor, (bool)enable, (UInt32)group, (Int32)numCounters, (UInt32*)counterList);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AmdVertexShaderTesselator", Version = "2.0", EntryPoint = "glTessellationFactorAMD")]
            public static 
            void TessellationFactor(Single factor)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glTessellationFactorAMD((Single)factor);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AmdVertexShaderTesselator", Version = "2.0", EntryPoint = "glTessellationModeAMD")]
            public static 
            void TessellationMode(OpenTK.Graphics.OpenGL.AmdVertexShaderTesselator mode)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glTessellationModeAMD((OpenTK.Graphics.OpenGL.AmdVertexShaderTesselator)mode);
                #if DEBUG
                }
                #endif
            }

        }

        public static partial class Apple
        {
            [AutoGenerated(Category = "AppleVertexArrayObject", Version = "1.2", EntryPoint = "glBindVertexArrayAPPLE")]
            public static 
            void BindVertexArray(Int32 array)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBindVertexArrayAPPLE((UInt32)array);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexArrayObject", Version = "1.2", EntryPoint = "glBindVertexArrayAPPLE")]
            public static 
            void BindVertexArray(UInt32 array)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBindVertexArrayAPPLE((UInt32)array);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleFlushBufferRange", Version = "1.5", EntryPoint = "glBufferParameteriAPPLE")]
            public static 
            void BufferParameter(OpenTK.Graphics.OpenGL.BufferTarget target, OpenTK.Graphics.OpenGL.BufferParameterApple pname, Int32 param)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBufferParameteriAPPLE((OpenTK.Graphics.OpenGL.BufferTarget)target, (OpenTK.Graphics.OpenGL.BufferParameterApple)pname, (Int32)param);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleFence", Version = "1.2", EntryPoint = "glDeleteFencesAPPLE")]
            public static 
            void DeleteFences(Int32 n, Int32[] fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* fences_ptr = fences)
                    {
                        Delegates.glDeleteFencesAPPLE((Int32)n, (UInt32*)fences_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleFence", Version = "1.2", EntryPoint = "glDeleteFencesAPPLE")]
            public static 
            void DeleteFences(Int32 n, ref Int32 fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* fences_ptr = &fences)
                    {
                        Delegates.glDeleteFencesAPPLE((Int32)n, (UInt32*)fences_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleFence", Version = "1.2", EntryPoint = "glDeleteFencesAPPLE")]
            public static 
            unsafe void DeleteFences(Int32 n, Int32* fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeleteFencesAPPLE((Int32)n, (UInt32*)fences);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleFence", Version = "1.2", EntryPoint = "glDeleteFencesAPPLE")]
            public static 
            void DeleteFences(Int32 n, UInt32[] fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* fences_ptr = fences)
                    {
                        Delegates.glDeleteFencesAPPLE((Int32)n, (UInt32*)fences_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleFence", Version = "1.2", EntryPoint = "glDeleteFencesAPPLE")]
            public static 
            void DeleteFences(Int32 n, ref UInt32 fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* fences_ptr = &fences)
                    {
                        Delegates.glDeleteFencesAPPLE((Int32)n, (UInt32*)fences_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleFence", Version = "1.2", EntryPoint = "glDeleteFencesAPPLE")]
            public static 
            unsafe void DeleteFences(Int32 n, UInt32* fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeleteFencesAPPLE((Int32)n, (UInt32*)fences);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexArrayObject", Version = "1.2", EntryPoint = "glDeleteVertexArraysAPPLE")]
            public static 
            void DeleteVertexArrays(Int32 n, Int32[] arrays)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* arrays_ptr = arrays)
                    {
                        Delegates.glDeleteVertexArraysAPPLE((Int32)n, (UInt32*)arrays_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexArrayObject", Version = "1.2", EntryPoint = "glDeleteVertexArraysAPPLE")]
            public static 
            void DeleteVertexArrays(Int32 n, ref Int32 arrays)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* arrays_ptr = &arrays)
                    {
                        Delegates.glDeleteVertexArraysAPPLE((Int32)n, (UInt32*)arrays_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexArrayObject", Version = "1.2", EntryPoint = "glDeleteVertexArraysAPPLE")]
            public static 
            unsafe void DeleteVertexArrays(Int32 n, Int32* arrays)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeleteVertexArraysAPPLE((Int32)n, (UInt32*)arrays);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexArrayObject", Version = "1.2", EntryPoint = "glDeleteVertexArraysAPPLE")]
            public static 
            void DeleteVertexArrays(Int32 n, UInt32[] arrays)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* arrays_ptr = arrays)
                    {
                        Delegates.glDeleteVertexArraysAPPLE((Int32)n, (UInt32*)arrays_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexArrayObject", Version = "1.2", EntryPoint = "glDeleteVertexArraysAPPLE")]
            public static 
            void DeleteVertexArrays(Int32 n, ref UInt32 arrays)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* arrays_ptr = &arrays)
                    {
                        Delegates.glDeleteVertexArraysAPPLE((Int32)n, (UInt32*)arrays_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexArrayObject", Version = "1.2", EntryPoint = "glDeleteVertexArraysAPPLE")]
            public static 
            unsafe void DeleteVertexArrays(Int32 n, UInt32* arrays)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeleteVertexArraysAPPLE((Int32)n, (UInt32*)arrays);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glDisableVertexAttribAPPLE")]
            public static 
            void DisableVertexAttrib(Int32 index, OpenTK.Graphics.OpenGL.AppleVertexProgramEvaluators pname)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDisableVertexAttribAPPLE((UInt32)index, (OpenTK.Graphics.OpenGL.AppleVertexProgramEvaluators)pname);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glDisableVertexAttribAPPLE")]
            public static 
            void DisableVertexAttrib(UInt32 index, OpenTK.Graphics.OpenGL.AppleVertexProgramEvaluators pname)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDisableVertexAttribAPPLE((UInt32)index, (OpenTK.Graphics.OpenGL.AppleVertexProgramEvaluators)pname);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleElementArray", Version = "1.2", EntryPoint = "glDrawElementArrayAPPLE")]
            public static 
            void DrawElementArray(OpenTK.Graphics.OpenGL.BeginMode mode, Int32 first, Int32 count)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDrawElementArrayAPPLE((OpenTK.Graphics.OpenGL.BeginMode)mode, (Int32)first, (Int32)count);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleElementArray", Version = "1.2", EntryPoint = "glDrawRangeElementArrayAPPLE")]
            public static 
            void DrawRangeElementArray(OpenTK.Graphics.OpenGL.BeginMode mode, Int32 start, Int32 end, Int32 first, Int32 count)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDrawRangeElementArrayAPPLE((OpenTK.Graphics.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32)first, (Int32)count);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleElementArray", Version = "1.2", EntryPoint = "glDrawRangeElementArrayAPPLE")]
            public static 
            void DrawRangeElementArray(OpenTK.Graphics.OpenGL.BeginMode mode, UInt32 start, UInt32 end, Int32 first, Int32 count)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDrawRangeElementArrayAPPLE((OpenTK.Graphics.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32)first, (Int32)count);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleElementArray", Version = "1.2", EntryPoint = "glElementPointerAPPLE")]
            public static 
            void ElementPointer(OpenTK.Graphics.OpenGL.AppleElementArray type, IntPtr pointer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glElementPointerAPPLE((OpenTK.Graphics.OpenGL.AppleElementArray)type, (IntPtr)pointer);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleElementArray", Version = "1.2", EntryPoint = "glElementPointerAPPLE")]
            public static 
            void ElementPointer<T1>(OpenTK.Graphics.OpenGL.AppleElementArray type, [InAttribute, OutAttribute] T1[] pointer)
                where T1 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glElementPointerAPPLE((OpenTK.Graphics.OpenGL.AppleElementArray)type, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleElementArray", Version = "1.2", EntryPoint = "glElementPointerAPPLE")]
            public static 
            void ElementPointer<T1>(OpenTK.Graphics.OpenGL.AppleElementArray type, [InAttribute, OutAttribute] T1[,] pointer)
                where T1 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glElementPointerAPPLE((OpenTK.Graphics.OpenGL.AppleElementArray)type, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleElementArray", Version = "1.2", EntryPoint = "glElementPointerAPPLE")]
            public static 
            void ElementPointer<T1>(OpenTK.Graphics.OpenGL.AppleElementArray type, [InAttribute, OutAttribute] T1[,,] pointer)
                where T1 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glElementPointerAPPLE((OpenTK.Graphics.OpenGL.AppleElementArray)type, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleElementArray", Version = "1.2", EntryPoint = "glElementPointerAPPLE")]
            public static 
            void ElementPointer<T1>(OpenTK.Graphics.OpenGL.AppleElementArray type, [InAttribute, OutAttribute] ref T1 pointer)
                where T1 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glElementPointerAPPLE((OpenTK.Graphics.OpenGL.AppleElementArray)type, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                    pointer = (T1)pointer_ptr.Target;
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glEnableVertexAttribAPPLE")]
            public static 
            void EnableVertexAttrib(Int32 index, OpenTK.Graphics.OpenGL.AppleVertexProgramEvaluators pname)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glEnableVertexAttribAPPLE((UInt32)index, (OpenTK.Graphics.OpenGL.AppleVertexProgramEvaluators)pname);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glEnableVertexAttribAPPLE")]
            public static 
            void EnableVertexAttrib(UInt32 index, OpenTK.Graphics.OpenGL.AppleVertexProgramEvaluators pname)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glEnableVertexAttribAPPLE((UInt32)index, (OpenTK.Graphics.OpenGL.AppleVertexProgramEvaluators)pname);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleFence", Version = "1.2", EntryPoint = "glFinishFenceAPPLE")]
            public static 
            void FinishFence(Int32 fence)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFinishFenceAPPLE((UInt32)fence);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleFence", Version = "1.2", EntryPoint = "glFinishFenceAPPLE")]
            public static 
            void FinishFence(UInt32 fence)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFinishFenceAPPLE((UInt32)fence);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleFence", Version = "1.2", EntryPoint = "glFinishObjectAPPLE")]
            public static 
            void FinishObject(OpenTK.Graphics.OpenGL.AppleFence @object, Int32 name)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFinishObjectAPPLE((OpenTK.Graphics.OpenGL.AppleFence)@object, (Int32)name);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleFlushBufferRange", Version = "1.5", EntryPoint = "glFlushMappedBufferRangeAPPLE")]
            public static 
            void FlushMappedBufferRange(OpenTK.Graphics.OpenGL.BufferTarget target, IntPtr offset, IntPtr size)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFlushMappedBufferRangeAPPLE((OpenTK.Graphics.OpenGL.BufferTarget)target, (IntPtr)offset, (IntPtr)size);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexArrayRange", Version = "1.2", EntryPoint = "glFlushVertexArrayRangeAPPLE")]
            public static 
            void FlushVertexArrayRange(Int32 length, [OutAttribute] IntPtr pointer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFlushVertexArrayRangeAPPLE((Int32)length, (IntPtr)pointer);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexArrayRange", Version = "1.2", EntryPoint = "glFlushVertexArrayRangeAPPLE")]
            public static 
            void FlushVertexArrayRange<T1>(Int32 length, [InAttribute, OutAttribute] T1[] pointer)
                where T1 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glFlushVertexArrayRangeAPPLE((Int32)length, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexArrayRange", Version = "1.2", EntryPoint = "glFlushVertexArrayRangeAPPLE")]
            public static 
            void FlushVertexArrayRange<T1>(Int32 length, [InAttribute, OutAttribute] T1[,] pointer)
                where T1 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glFlushVertexArrayRangeAPPLE((Int32)length, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexArrayRange", Version = "1.2", EntryPoint = "glFlushVertexArrayRangeAPPLE")]
            public static 
            void FlushVertexArrayRange<T1>(Int32 length, [InAttribute, OutAttribute] T1[,,] pointer)
                where T1 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glFlushVertexArrayRangeAPPLE((Int32)length, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexArrayRange", Version = "1.2", EntryPoint = "glFlushVertexArrayRangeAPPLE")]
            public static 
            void FlushVertexArrayRange<T1>(Int32 length, [InAttribute, OutAttribute] ref T1 pointer)
                where T1 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glFlushVertexArrayRangeAPPLE((Int32)length, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                    pointer = (T1)pointer_ptr.Target;
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleFence", Version = "1.2", EntryPoint = "glGenFencesAPPLE")]
            public static 
            void GenFences(Int32 n, [OutAttribute] Int32[] fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* fences_ptr = fences)
                    {
                        Delegates.glGenFencesAPPLE((Int32)n, (UInt32*)fences_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleFence", Version = "1.2", EntryPoint = "glGenFencesAPPLE")]
            public static 
            void GenFences(Int32 n, [OutAttribute] out Int32 fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* fences_ptr = &fences)
                    {
                        Delegates.glGenFencesAPPLE((Int32)n, (UInt32*)fences_ptr);
                        fences = *fences_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleFence", Version = "1.2", EntryPoint = "glGenFencesAPPLE")]
            public static 
            unsafe void GenFences(Int32 n, [OutAttribute] Int32* fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGenFencesAPPLE((Int32)n, (UInt32*)fences);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleFence", Version = "1.2", EntryPoint = "glGenFencesAPPLE")]
            public static 
            void GenFences(Int32 n, [OutAttribute] UInt32[] fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* fences_ptr = fences)
                    {
                        Delegates.glGenFencesAPPLE((Int32)n, (UInt32*)fences_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleFence", Version = "1.2", EntryPoint = "glGenFencesAPPLE")]
            public static 
            void GenFences(Int32 n, [OutAttribute] out UInt32 fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* fences_ptr = &fences)
                    {
                        Delegates.glGenFencesAPPLE((Int32)n, (UInt32*)fences_ptr);
                        fences = *fences_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleFence", Version = "1.2", EntryPoint = "glGenFencesAPPLE")]
            public static 
            unsafe void GenFences(Int32 n, [OutAttribute] UInt32* fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGenFencesAPPLE((Int32)n, (UInt32*)fences);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexArrayObject", Version = "1.2", EntryPoint = "glGenVertexArraysAPPLE")]
            public static 
            void GenVertexArrays(Int32 n, [OutAttribute] Int32[] arrays)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* arrays_ptr = arrays)
                    {
                        Delegates.glGenVertexArraysAPPLE((Int32)n, (UInt32*)arrays_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexArrayObject", Version = "1.2", EntryPoint = "glGenVertexArraysAPPLE")]
            public static 
            void GenVertexArrays(Int32 n, [OutAttribute] out Int32 arrays)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* arrays_ptr = &arrays)
                    {
                        Delegates.glGenVertexArraysAPPLE((Int32)n, (UInt32*)arrays_ptr);
                        arrays = *arrays_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexArrayObject", Version = "1.2", EntryPoint = "glGenVertexArraysAPPLE")]
            public static 
            unsafe void GenVertexArrays(Int32 n, [OutAttribute] Int32* arrays)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGenVertexArraysAPPLE((Int32)n, (UInt32*)arrays);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexArrayObject", Version = "1.2", EntryPoint = "glGenVertexArraysAPPLE")]
            public static 
            void GenVertexArrays(Int32 n, [OutAttribute] UInt32[] arrays)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* arrays_ptr = arrays)
                    {
                        Delegates.glGenVertexArraysAPPLE((Int32)n, (UInt32*)arrays_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexArrayObject", Version = "1.2", EntryPoint = "glGenVertexArraysAPPLE")]
            public static 
            void GenVertexArrays(Int32 n, [OutAttribute] out UInt32 arrays)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* arrays_ptr = &arrays)
                    {
                        Delegates.glGenVertexArraysAPPLE((Int32)n, (UInt32*)arrays_ptr);
                        arrays = *arrays_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexArrayObject", Version = "1.2", EntryPoint = "glGenVertexArraysAPPLE")]
            public static 
            unsafe void GenVertexArrays(Int32 n, [OutAttribute] UInt32* arrays)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGenVertexArraysAPPLE((Int32)n, (UInt32*)arrays);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleObjectPurgeable", Version = "1.5", EntryPoint = "glGetObjectParameterivAPPLE")]
            public static 
            void GetObjectParameter(OpenTK.Graphics.OpenGL.AppleObjectPurgeable objectType, Int32 name, OpenTK.Graphics.OpenGL.AppleObjectPurgeable pname, [OutAttribute] Int32[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = @params)
                    {
                        Delegates.glGetObjectParameterivAPPLE((OpenTK.Graphics.OpenGL.AppleObjectPurgeable)objectType, (UInt32)name, (OpenTK.Graphics.OpenGL.AppleObjectPurgeable)pname, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleObjectPurgeable", Version = "1.5", EntryPoint = "glGetObjectParameterivAPPLE")]
            public static 
            void GetObjectParameter(OpenTK.Graphics.OpenGL.AppleObjectPurgeable objectType, Int32 name, OpenTK.Graphics.OpenGL.AppleObjectPurgeable pname, [OutAttribute] out Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetObjectParameterivAPPLE((OpenTK.Graphics.OpenGL.AppleObjectPurgeable)objectType, (UInt32)name, (OpenTK.Graphics.OpenGL.AppleObjectPurgeable)pname, (Int32*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleObjectPurgeable", Version = "1.5", EntryPoint = "glGetObjectParameterivAPPLE")]
            public static 
            unsafe void GetObjectParameter(OpenTK.Graphics.OpenGL.AppleObjectPurgeable objectType, Int32 name, OpenTK.Graphics.OpenGL.AppleObjectPurgeable pname, [OutAttribute] Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetObjectParameterivAPPLE((OpenTK.Graphics.OpenGL.AppleObjectPurgeable)objectType, (UInt32)name, (OpenTK.Graphics.OpenGL.AppleObjectPurgeable)pname, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleObjectPurgeable", Version = "1.5", EntryPoint = "glGetObjectParameterivAPPLE")]
            public static 
            void GetObjectParameter(OpenTK.Graphics.OpenGL.AppleObjectPurgeable objectType, UInt32 name, OpenTK.Graphics.OpenGL.AppleObjectPurgeable pname, [OutAttribute] Int32[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = @params)
                    {
                        Delegates.glGetObjectParameterivAPPLE((OpenTK.Graphics.OpenGL.AppleObjectPurgeable)objectType, (UInt32)name, (OpenTK.Graphics.OpenGL.AppleObjectPurgeable)pname, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleObjectPurgeable", Version = "1.5", EntryPoint = "glGetObjectParameterivAPPLE")]
            public static 
            void GetObjectParameter(OpenTK.Graphics.OpenGL.AppleObjectPurgeable objectType, UInt32 name, OpenTK.Graphics.OpenGL.AppleObjectPurgeable pname, [OutAttribute] out Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetObjectParameterivAPPLE((OpenTK.Graphics.OpenGL.AppleObjectPurgeable)objectType, (UInt32)name, (OpenTK.Graphics.OpenGL.AppleObjectPurgeable)pname, (Int32*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleObjectPurgeable", Version = "1.5", EntryPoint = "glGetObjectParameterivAPPLE")]
            public static 
            unsafe void GetObjectParameter(OpenTK.Graphics.OpenGL.AppleObjectPurgeable objectType, UInt32 name, OpenTK.Graphics.OpenGL.AppleObjectPurgeable pname, [OutAttribute] Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetObjectParameterivAPPLE((OpenTK.Graphics.OpenGL.AppleObjectPurgeable)objectType, (UInt32)name, (OpenTK.Graphics.OpenGL.AppleObjectPurgeable)pname, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleTextureRange", Version = "1.2", EntryPoint = "glGetTexParameterPointervAPPLE")]
            public static 
            void GetTexParameterPointer(OpenTK.Graphics.OpenGL.AppleTextureRange target, OpenTK.Graphics.OpenGL.AppleTextureRange pname, [OutAttribute] IntPtr @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetTexParameterPointervAPPLE((OpenTK.Graphics.OpenGL.AppleTextureRange)target, (OpenTK.Graphics.OpenGL.AppleTextureRange)pname, (IntPtr)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleTextureRange", Version = "1.2", EntryPoint = "glGetTexParameterPointervAPPLE")]
            public static 
            void GetTexParameterPointer<T2>(OpenTK.Graphics.OpenGL.AppleTextureRange target, OpenTK.Graphics.OpenGL.AppleTextureRange pname, [InAttribute, OutAttribute] T2[] @params)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetTexParameterPointervAPPLE((OpenTK.Graphics.OpenGL.AppleTextureRange)target, (OpenTK.Graphics.OpenGL.AppleTextureRange)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    @params_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleTextureRange", Version = "1.2", EntryPoint = "glGetTexParameterPointervAPPLE")]
            public static 
            void GetTexParameterPointer<T2>(OpenTK.Graphics.OpenGL.AppleTextureRange target, OpenTK.Graphics.OpenGL.AppleTextureRange pname, [InAttribute, OutAttribute] T2[,] @params)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetTexParameterPointervAPPLE((OpenTK.Graphics.OpenGL.AppleTextureRange)target, (OpenTK.Graphics.OpenGL.AppleTextureRange)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    @params_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleTextureRange", Version = "1.2", EntryPoint = "glGetTexParameterPointervAPPLE")]
            public static 
            void GetTexParameterPointer<T2>(OpenTK.Graphics.OpenGL.AppleTextureRange target, OpenTK.Graphics.OpenGL.AppleTextureRange pname, [InAttribute, OutAttribute] T2[,,] @params)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetTexParameterPointervAPPLE((OpenTK.Graphics.OpenGL.AppleTextureRange)target, (OpenTK.Graphics.OpenGL.AppleTextureRange)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    @params_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleTextureRange", Version = "1.2", EntryPoint = "glGetTexParameterPointervAPPLE")]
            public static 
            void GetTexParameterPointer<T2>(OpenTK.Graphics.OpenGL.AppleTextureRange target, OpenTK.Graphics.OpenGL.AppleTextureRange pname, [InAttribute, OutAttribute] ref T2 @params)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetTexParameterPointervAPPLE((OpenTK.Graphics.OpenGL.AppleTextureRange)target, (OpenTK.Graphics.OpenGL.AppleTextureRange)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
                    @params = (T2)@params_ptr.Target;
                }
                finally
                {
                    @params_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleFence", Version = "1.2", EntryPoint = "glIsFenceAPPLE")]
            public static 
            bool IsFence(Int32 fence)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glIsFenceAPPLE((UInt32)fence);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleFence", Version = "1.2", EntryPoint = "glIsFenceAPPLE")]
            public static 
            bool IsFence(UInt32 fence)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glIsFenceAPPLE((UInt32)fence);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexArrayObject", Version = "1.2", EntryPoint = "glIsVertexArrayAPPLE")]
            public static 
            bool IsVertexArray(Int32 array)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glIsVertexArrayAPPLE((UInt32)array);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexArrayObject", Version = "1.2", EntryPoint = "glIsVertexArrayAPPLE")]
            public static 
            bool IsVertexArray(UInt32 array)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glIsVertexArrayAPPLE((UInt32)array);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glIsVertexAttribEnabledAPPLE")]
            public static 
            bool IsVertexAttribEnabled(Int32 index, OpenTK.Graphics.OpenGL.AppleVertexProgramEvaluators pname)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glIsVertexAttribEnabledAPPLE((UInt32)index, (OpenTK.Graphics.OpenGL.AppleVertexProgramEvaluators)pname);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glIsVertexAttribEnabledAPPLE")]
            public static 
            bool IsVertexAttribEnabled(UInt32 index, OpenTK.Graphics.OpenGL.AppleVertexProgramEvaluators pname)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glIsVertexAttribEnabledAPPLE((UInt32)index, (OpenTK.Graphics.OpenGL.AppleVertexProgramEvaluators)pname);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glMapVertexAttrib1dAPPLE")]
            public static 
            void MapVertexAttrib1(Int32 index, Int32 size, Double u1, Double u2, Int32 stride, Int32 order, Double[] points)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* points_ptr = points)
                    {
                        Delegates.glMapVertexAttrib1dAPPLE((UInt32)index, (UInt32)size, (Double)u1, (Double)u2, (Int32)stride, (Int32)order, (Double*)points_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glMapVertexAttrib1dAPPLE")]
            public static 
            void MapVertexAttrib1(Int32 index, Int32 size, Double u1, Double u2, Int32 stride, Int32 order, ref Double points)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* points_ptr = &points)
                    {
                        Delegates.glMapVertexAttrib1dAPPLE((UInt32)index, (UInt32)size, (Double)u1, (Double)u2, (Int32)stride, (Int32)order, (Double*)points_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glMapVertexAttrib1dAPPLE")]
            public static 
            unsafe void MapVertexAttrib1(Int32 index, Int32 size, Double u1, Double u2, Int32 stride, Int32 order, Double* points)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMapVertexAttrib1dAPPLE((UInt32)index, (UInt32)size, (Double)u1, (Double)u2, (Int32)stride, (Int32)order, (Double*)points);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glMapVertexAttrib1dAPPLE")]
            public static 
            void MapVertexAttrib1(UInt32 index, UInt32 size, Double u1, Double u2, Int32 stride, Int32 order, Double[] points)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* points_ptr = points)
                    {
                        Delegates.glMapVertexAttrib1dAPPLE((UInt32)index, (UInt32)size, (Double)u1, (Double)u2, (Int32)stride, (Int32)order, (Double*)points_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glMapVertexAttrib1dAPPLE")]
            public static 
            void MapVertexAttrib1(UInt32 index, UInt32 size, Double u1, Double u2, Int32 stride, Int32 order, ref Double points)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* points_ptr = &points)
                    {
                        Delegates.glMapVertexAttrib1dAPPLE((UInt32)index, (UInt32)size, (Double)u1, (Double)u2, (Int32)stride, (Int32)order, (Double*)points_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glMapVertexAttrib1dAPPLE")]
            public static 
            unsafe void MapVertexAttrib1(UInt32 index, UInt32 size, Double u1, Double u2, Int32 stride, Int32 order, Double* points)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMapVertexAttrib1dAPPLE((UInt32)index, (UInt32)size, (Double)u1, (Double)u2, (Int32)stride, (Int32)order, (Double*)points);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glMapVertexAttrib1fAPPLE")]
            public static 
            void MapVertexAttrib1(Int32 index, Int32 size, Single u1, Single u2, Int32 stride, Int32 order, Single[] points)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* points_ptr = points)
                    {
                        Delegates.glMapVertexAttrib1fAPPLE((UInt32)index, (UInt32)size, (Single)u1, (Single)u2, (Int32)stride, (Int32)order, (Single*)points_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glMapVertexAttrib1fAPPLE")]
            public static 
            void MapVertexAttrib1(Int32 index, Int32 size, Single u1, Single u2, Int32 stride, Int32 order, ref Single points)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* points_ptr = &points)
                    {
                        Delegates.glMapVertexAttrib1fAPPLE((UInt32)index, (UInt32)size, (Single)u1, (Single)u2, (Int32)stride, (Int32)order, (Single*)points_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glMapVertexAttrib1fAPPLE")]
            public static 
            unsafe void MapVertexAttrib1(Int32 index, Int32 size, Single u1, Single u2, Int32 stride, Int32 order, Single* points)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMapVertexAttrib1fAPPLE((UInt32)index, (UInt32)size, (Single)u1, (Single)u2, (Int32)stride, (Int32)order, (Single*)points);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glMapVertexAttrib1fAPPLE")]
            public static 
            void MapVertexAttrib1(UInt32 index, UInt32 size, Single u1, Single u2, Int32 stride, Int32 order, Single[] points)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* points_ptr = points)
                    {
                        Delegates.glMapVertexAttrib1fAPPLE((UInt32)index, (UInt32)size, (Single)u1, (Single)u2, (Int32)stride, (Int32)order, (Single*)points_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glMapVertexAttrib1fAPPLE")]
            public static 
            void MapVertexAttrib1(UInt32 index, UInt32 size, Single u1, Single u2, Int32 stride, Int32 order, ref Single points)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* points_ptr = &points)
                    {
                        Delegates.glMapVertexAttrib1fAPPLE((UInt32)index, (UInt32)size, (Single)u1, (Single)u2, (Int32)stride, (Int32)order, (Single*)points_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glMapVertexAttrib1fAPPLE")]
            public static 
            unsafe void MapVertexAttrib1(UInt32 index, UInt32 size, Single u1, Single u2, Int32 stride, Int32 order, Single* points)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMapVertexAttrib1fAPPLE((UInt32)index, (UInt32)size, (Single)u1, (Single)u2, (Int32)stride, (Int32)order, (Single*)points);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glMapVertexAttrib2dAPPLE")]
            public static 
            void MapVertexAttrib2(Int32 index, Int32 size, Double u1, Double u2, Int32 ustride, Int32 uorder, Double v1, Double v2, Int32 vstride, Int32 vorder, Double[] points)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* points_ptr = points)
                    {
                        Delegates.glMapVertexAttrib2dAPPLE((UInt32)index, (UInt32)size, (Double)u1, (Double)u2, (Int32)ustride, (Int32)uorder, (Double)v1, (Double)v2, (Int32)vstride, (Int32)vorder, (Double*)points_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glMapVertexAttrib2dAPPLE")]
            public static 
            void MapVertexAttrib2(Int32 index, Int32 size, Double u1, Double u2, Int32 ustride, Int32 uorder, Double v1, Double v2, Int32 vstride, Int32 vorder, ref Double points)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* points_ptr = &points)
                    {
                        Delegates.glMapVertexAttrib2dAPPLE((UInt32)index, (UInt32)size, (Double)u1, (Double)u2, (Int32)ustride, (Int32)uorder, (Double)v1, (Double)v2, (Int32)vstride, (Int32)vorder, (Double*)points_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glMapVertexAttrib2dAPPLE")]
            public static 
            unsafe void MapVertexAttrib2(Int32 index, Int32 size, Double u1, Double u2, Int32 ustride, Int32 uorder, Double v1, Double v2, Int32 vstride, Int32 vorder, Double* points)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMapVertexAttrib2dAPPLE((UInt32)index, (UInt32)size, (Double)u1, (Double)u2, (Int32)ustride, (Int32)uorder, (Double)v1, (Double)v2, (Int32)vstride, (Int32)vorder, (Double*)points);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glMapVertexAttrib2dAPPLE")]
            public static 
            void MapVertexAttrib2(UInt32 index, UInt32 size, Double u1, Double u2, Int32 ustride, Int32 uorder, Double v1, Double v2, Int32 vstride, Int32 vorder, Double[] points)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* points_ptr = points)
                    {
                        Delegates.glMapVertexAttrib2dAPPLE((UInt32)index, (UInt32)size, (Double)u1, (Double)u2, (Int32)ustride, (Int32)uorder, (Double)v1, (Double)v2, (Int32)vstride, (Int32)vorder, (Double*)points_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glMapVertexAttrib2dAPPLE")]
            public static 
            void MapVertexAttrib2(UInt32 index, UInt32 size, Double u1, Double u2, Int32 ustride, Int32 uorder, Double v1, Double v2, Int32 vstride, Int32 vorder, ref Double points)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* points_ptr = &points)
                    {
                        Delegates.glMapVertexAttrib2dAPPLE((UInt32)index, (UInt32)size, (Double)u1, (Double)u2, (Int32)ustride, (Int32)uorder, (Double)v1, (Double)v2, (Int32)vstride, (Int32)vorder, (Double*)points_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glMapVertexAttrib2dAPPLE")]
            public static 
            unsafe void MapVertexAttrib2(UInt32 index, UInt32 size, Double u1, Double u2, Int32 ustride, Int32 uorder, Double v1, Double v2, Int32 vstride, Int32 vorder, Double* points)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMapVertexAttrib2dAPPLE((UInt32)index, (UInt32)size, (Double)u1, (Double)u2, (Int32)ustride, (Int32)uorder, (Double)v1, (Double)v2, (Int32)vstride, (Int32)vorder, (Double*)points);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glMapVertexAttrib2fAPPLE")]
            public static 
            void MapVertexAttrib2(Int32 index, Int32 size, Single u1, Single u2, Int32 ustride, Int32 uorder, Single v1, Single v2, Int32 vstride, Int32 vorder, Single[] points)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* points_ptr = points)
                    {
                        Delegates.glMapVertexAttrib2fAPPLE((UInt32)index, (UInt32)size, (Single)u1, (Single)u2, (Int32)ustride, (Int32)uorder, (Single)v1, (Single)v2, (Int32)vstride, (Int32)vorder, (Single*)points_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glMapVertexAttrib2fAPPLE")]
            public static 
            void MapVertexAttrib2(Int32 index, Int32 size, Single u1, Single u2, Int32 ustride, Int32 uorder, Single v1, Single v2, Int32 vstride, Int32 vorder, ref Single points)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* points_ptr = &points)
                    {
                        Delegates.glMapVertexAttrib2fAPPLE((UInt32)index, (UInt32)size, (Single)u1, (Single)u2, (Int32)ustride, (Int32)uorder, (Single)v1, (Single)v2, (Int32)vstride, (Int32)vorder, (Single*)points_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glMapVertexAttrib2fAPPLE")]
            public static 
            unsafe void MapVertexAttrib2(Int32 index, Int32 size, Single u1, Single u2, Int32 ustride, Int32 uorder, Single v1, Single v2, Int32 vstride, Int32 vorder, Single* points)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMapVertexAttrib2fAPPLE((UInt32)index, (UInt32)size, (Single)u1, (Single)u2, (Int32)ustride, (Int32)uorder, (Single)v1, (Single)v2, (Int32)vstride, (Int32)vorder, (Single*)points);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glMapVertexAttrib2fAPPLE")]
            public static 
            void MapVertexAttrib2(UInt32 index, UInt32 size, Single u1, Single u2, Int32 ustride, Int32 uorder, Single v1, Single v2, Int32 vstride, Int32 vorder, Single[] points)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* points_ptr = points)
                    {
                        Delegates.glMapVertexAttrib2fAPPLE((UInt32)index, (UInt32)size, (Single)u1, (Single)u2, (Int32)ustride, (Int32)uorder, (Single)v1, (Single)v2, (Int32)vstride, (Int32)vorder, (Single*)points_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glMapVertexAttrib2fAPPLE")]
            public static 
            void MapVertexAttrib2(UInt32 index, UInt32 size, Single u1, Single u2, Int32 ustride, Int32 uorder, Single v1, Single v2, Int32 vstride, Int32 vorder, ref Single points)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* points_ptr = &points)
                    {
                        Delegates.glMapVertexAttrib2fAPPLE((UInt32)index, (UInt32)size, (Single)u1, (Single)u2, (Int32)ustride, (Int32)uorder, (Single)v1, (Single)v2, (Int32)vstride, (Int32)vorder, (Single*)points_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleVertexProgramEvaluators", Version = "1.5", EntryPoint = "glMapVertexAttrib2fAPPLE")]
            public static 
            unsafe void MapVertexAttrib2(UInt32 index, UInt32 size, Single u1, Single u2, Int32 ustride, Int32 uorder, Single v1, Single v2, Int32 vstride, Int32 vorder, Single* points)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMapVertexAttrib2fAPPLE((UInt32)index, (UInt32)size, (Single)u1, (Single)u2, (Int32)ustride, (Int32)uorder, (Single)v1, (Single)v2, (Int32)vstride, (Int32)vorder, (Single*)points);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleElementArray", Version = "1.2", EntryPoint = "glMultiDrawElementArrayAPPLE")]
            public static 
            void MultiDrawElementArray(OpenTK.Graphics.OpenGL.BeginMode mode, Int32[] first, Int32[] count, Int32 primcount)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* first_ptr = first)
                    fixed (Int32* count_ptr = count)
                    {
                        Delegates.glMultiDrawElementArrayAPPLE((OpenTK.Graphics.OpenGL.BeginMode)mode, (Int32*)first_ptr, (Int32*)count_ptr, (Int32)primcount);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleElementArray", Version = "1.2", EntryPoint = "glMultiDrawElementArrayAPPLE")]
            public static 
            void MultiDrawElementArray(OpenTK.Graphics.OpenGL.BeginMode mode, ref Int32 first, ref Int32 count, Int32 primcount)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* first_ptr = &first)
                    fixed (Int32* count_ptr = &count)
                    {
                        Delegates.glMultiDrawElementArrayAPPLE((OpenTK.Graphics.OpenGL.BeginMode)mode, (Int32*)first_ptr, (Int32*)count_ptr, (Int32)primcount);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleElementArray", Version = "1.2", EntryPoint = "glMultiDrawElementArrayAPPLE")]
            public static 
            unsafe void MultiDrawElementArray(OpenTK.Graphics.OpenGL.BeginMode mode, Int32* first, Int32* count, Int32 primcount)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiDrawElementArrayAPPLE((OpenTK.Graphics.OpenGL.BeginMode)mode, (Int32*)first, (Int32*)count, (Int32)primcount);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleElementArray", Version = "1.2", EntryPoint = "glMultiDrawRangeElementArrayAPPLE")]
            public static 
            void MultiDrawRangeElementArray(OpenTK.Graphics.OpenGL.BeginMode mode, Int32 start, Int32 end, Int32[] first, Int32[] count, Int32 primcount)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* first_ptr = first)
                    fixed (Int32* count_ptr = count)
                    {
                        Delegates.glMultiDrawRangeElementArrayAPPLE((OpenTK.Graphics.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32*)first_ptr, (Int32*)count_ptr, (Int32)primcount);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleElementArray", Version = "1.2", EntryPoint = "glMultiDrawRangeElementArrayAPPLE")]
            public static 
            void MultiDrawRangeElementArray(OpenTK.Graphics.OpenGL.BeginMode mode, Int32 start, Int32 end, ref Int32 first, ref Int32 count, Int32 primcount)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* first_ptr = &first)
                    fixed (Int32* count_ptr = &count)
                    {
                        Delegates.glMultiDrawRangeElementArrayAPPLE((OpenTK.Graphics.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32*)first_ptr, (Int32*)count_ptr, (Int32)primcount);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleElementArray", Version = "1.2", EntryPoint = "glMultiDrawRangeElementArrayAPPLE")]
            public static 
            unsafe void MultiDrawRangeElementArray(OpenTK.Graphics.OpenGL.BeginMode mode, Int32 start, Int32 end, Int32* first, Int32* count, Int32 primcount)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiDrawRangeElementArrayAPPLE((OpenTK.Graphics.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32*)first, (Int32*)count, (Int32)primcount);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleElementArray", Version = "1.2", EntryPoint = "glMultiDrawRangeElementArrayAPPLE")]
            public static 
            void MultiDrawRangeElementArray(OpenTK.Graphics.OpenGL.BeginMode mode, UInt32 start, UInt32 end, Int32[] first, Int32[] count, Int32 primcount)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* first_ptr = first)
                    fixed (Int32* count_ptr = count)
                    {
                        Delegates.glMultiDrawRangeElementArrayAPPLE((OpenTK.Graphics.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32*)first_ptr, (Int32*)count_ptr, (Int32)primcount);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleElementArray", Version = "1.2", EntryPoint = "glMultiDrawRangeElementArrayAPPLE")]
            public static 
            void MultiDrawRangeElementArray(OpenTK.Graphics.OpenGL.BeginMode mode, UInt32 start, UInt32 end, ref Int32 first, ref Int32 count, Int32 primcount)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* first_ptr = &first)
                    fixed (Int32* count_ptr = &count)
                    {
                        Delegates.glMultiDrawRangeElementArrayAPPLE((OpenTK.Graphics.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32*)first_ptr, (Int32*)count_ptr, (Int32)primcount);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleElementArray", Version = "1.2", EntryPoint = "glMultiDrawRangeElementArrayAPPLE")]
            public static 
            unsafe void MultiDrawRangeElementArray(OpenTK.Graphics.OpenGL.BeginMode mode, UInt32 start, UInt32 end, Int32* first, Int32* count, Int32 primcount)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiDrawRangeElementArrayAPPLE((OpenTK.Graphics.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32*)first, (Int32*)count, (Int32)primcount);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleObjectPurgeable", Version = "1.5", EntryPoint = "glObjectPurgeableAPPLE")]
            public static 
            System.IntPtr ObjectPurgeable(OpenTK.Graphics.OpenGL.AppleObjectPurgeable objectType, Int32 name, OpenTK.Graphics.OpenGL.AppleObjectPurgeable option)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glObjectPurgeableAPPLE((OpenTK.Graphics.OpenGL.AppleObjectPurgeable)objectType, (UInt32)name, (OpenTK.Graphics.OpenGL.AppleObjectPurgeable)option);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleObjectPurgeable", Version = "1.5", EntryPoint = "glObjectPurgeableAPPLE")]
            public static 
            System.IntPtr ObjectPurgeable(OpenTK.Graphics.OpenGL.AppleObjectPurgeable objectType, UInt32 name, OpenTK.Graphics.OpenGL.AppleObjectPurgeable option)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glObjectPurgeableAPPLE((OpenTK.Graphics.OpenGL.AppleObjectPurgeable)objectType, (UInt32)name, (OpenTK.Graphics.OpenGL.AppleObjectPurgeable)option);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleObjectPurgeable", Version = "1.5", EntryPoint = "glObjectUnpurgeableAPPLE")]
            public static 
            System.IntPtr ObjectUnpurgeable(OpenTK.Graphics.OpenGL.AppleObjectPurgeable objectType, Int32 name, OpenTK.Graphics.OpenGL.AppleObjectPurgeable option)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glObjectUnpurgeableAPPLE((OpenTK.Graphics.OpenGL.AppleObjectPurgeable)objectType, (UInt32)name, (OpenTK.Graphics.OpenGL.AppleObjectPurgeable)option);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleObjectPurgeable", Version = "1.5", EntryPoint = "glObjectUnpurgeableAPPLE")]
            public static 
            System.IntPtr ObjectUnpurgeable(OpenTK.Graphics.OpenGL.AppleObjectPurgeable objectType, UInt32 name, OpenTK.Graphics.OpenGL.AppleObjectPurgeable option)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glObjectUnpurgeableAPPLE((OpenTK.Graphics.OpenGL.AppleObjectPurgeable)objectType, (UInt32)name, (OpenTK.Graphics.OpenGL.AppleObjectPurgeable)option);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleFence", Version = "1.2", EntryPoint = "glSetFenceAPPLE")]
            public static 
            void SetFence(Int32 fence)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glSetFenceAPPLE((UInt32)fence);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleFence", Version = "1.2", EntryPoint = "glSetFenceAPPLE")]
            public static 
            void SetFence(UInt32 fence)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glSetFenceAPPLE((UInt32)fence);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleFence", Version = "1.2", EntryPoint = "glTestFenceAPPLE")]
            public static 
            bool TestFence(Int32 fence)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glTestFenceAPPLE((UInt32)fence);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleFence", Version = "1.2", EntryPoint = "glTestFenceAPPLE")]
            public static 
            bool TestFence(UInt32 fence)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glTestFenceAPPLE((UInt32)fence);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleFence", Version = "1.2", EntryPoint = "glTestObjectAPPLE")]
            public static 
            bool TestObject(OpenTK.Graphics.OpenGL.AppleFence @object, Int32 name)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glTestObjectAPPLE((OpenTK.Graphics.OpenGL.AppleFence)@object, (UInt32)name);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AppleFence", Version = "1.2", EntryPoint = "glTestObjectAPPLE")]
            public static 
            bool TestObject(OpenTK.Graphics.OpenGL.AppleFence @object, UInt32 name)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glTestObjectAPPLE((OpenTK.Graphics.OpenGL.AppleFence)@object, (UInt32)name);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleTextureRange", Version = "1.2", EntryPoint = "glTextureRangeAPPLE")]
            public static 
            void TextureRange(OpenTK.Graphics.OpenGL.AppleTextureRange target, Int32 length, IntPtr pointer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glTextureRangeAPPLE((OpenTK.Graphics.OpenGL.AppleTextureRange)target, (Int32)length, (IntPtr)pointer);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleTextureRange", Version = "1.2", EntryPoint = "glTextureRangeAPPLE")]
            public static 
            void TextureRange<T2>(OpenTK.Graphics.OpenGL.AppleTextureRange target, Int32 length, [InAttribute, OutAttribute] T2[] pointer)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glTextureRangeAPPLE((OpenTK.Graphics.OpenGL.AppleTextureRange)target, (Int32)length, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleTextureRange", Version = "1.2", EntryPoint = "glTextureRangeAPPLE")]
            public static 
            void TextureRange<T2>(OpenTK.Graphics.OpenGL.AppleTextureRange target, Int32 length, [InAttribute, OutAttribute] T2[,] pointer)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glTextureRangeAPPLE((OpenTK.Graphics.OpenGL.AppleTextureRange)target, (Int32)length, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleTextureRange", Version = "1.2", EntryPoint = "glTextureRangeAPPLE")]
            public static 
            void TextureRange<T2>(OpenTK.Graphics.OpenGL.AppleTextureRange target, Int32 length, [InAttribute, OutAttribute] T2[,,] pointer)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glTextureRangeAPPLE((OpenTK.Graphics.OpenGL.AppleTextureRange)target, (Int32)length, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleTextureRange", Version = "1.2", EntryPoint = "glTextureRangeAPPLE")]
            public static 
            void TextureRange<T2>(OpenTK.Graphics.OpenGL.AppleTextureRange target, Int32 length, [InAttribute, OutAttribute] ref T2 pointer)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glTextureRangeAPPLE((OpenTK.Graphics.OpenGL.AppleTextureRange)target, (Int32)length, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                    pointer = (T2)pointer_ptr.Target;
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexArrayRange", Version = "1.2", EntryPoint = "glVertexArrayParameteriAPPLE")]
            public static 
            void VertexArrayParameter(OpenTK.Graphics.OpenGL.AppleVertexArrayRange pname, Int32 param)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexArrayParameteriAPPLE((OpenTK.Graphics.OpenGL.AppleVertexArrayRange)pname, (Int32)param);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexArrayRange", Version = "1.2", EntryPoint = "glVertexArrayRangeAPPLE")]
            public static 
            void VertexArrayRange(Int32 length, [OutAttribute] IntPtr pointer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexArrayRangeAPPLE((Int32)length, (IntPtr)pointer);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexArrayRange", Version = "1.2", EntryPoint = "glVertexArrayRangeAPPLE")]
            public static 
            void VertexArrayRange<T1>(Int32 length, [InAttribute, OutAttribute] T1[] pointer)
                where T1 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glVertexArrayRangeAPPLE((Int32)length, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexArrayRange", Version = "1.2", EntryPoint = "glVertexArrayRangeAPPLE")]
            public static 
            void VertexArrayRange<T1>(Int32 length, [InAttribute, OutAttribute] T1[,] pointer)
                where T1 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glVertexArrayRangeAPPLE((Int32)length, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexArrayRange", Version = "1.2", EntryPoint = "glVertexArrayRangeAPPLE")]
            public static 
            void VertexArrayRange<T1>(Int32 length, [InAttribute, OutAttribute] T1[,,] pointer)
                where T1 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glVertexArrayRangeAPPLE((Int32)length, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AppleVertexArrayRange", Version = "1.2", EntryPoint = "glVertexArrayRangeAPPLE")]
            public static 
            void VertexArrayRange<T1>(Int32 length, [InAttribute, OutAttribute] ref T1 pointer)
                where T1 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glVertexArrayRangeAPPLE((Int32)length, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                    pointer = (T1)pointer_ptr.Target;
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

        }

        public static partial class Arb
        {
            
        /// <summary>
        /// Select active texture unit
        /// </summary>
        /// <param name="texture">
        /// <para>
        /// Specifies which texture unit to make active. The number of texture units is implementation dependent, but must be at least two. texture must be one of GL_TEXTURE, where i ranges from 0 to the larger of (GL_MAX_TEXTURE_COORDS - 1) and (GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS - 1). The initial value is GL_TEXTURE0.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glActiveTextureARB")]
            public static 
            void ActiveTexture(OpenTK.Graphics.OpenGL.TextureUnit texture)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glActiveTextureARB((OpenTK.Graphics.OpenGL.TextureUnit)texture);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glAttachObjectARB")]
            public static 
            void AttachObject(Int32 containerObj, Int32 obj)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glAttachObjectARB((UInt32)containerObj, (UInt32)obj);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glAttachObjectARB")]
            public static 
            void AttachObject(UInt32 containerObj, UInt32 obj)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glAttachObjectARB((UInt32)containerObj, (UInt32)obj);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Delimit the boundaries of a query object
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target type of query object established between glBeginQuery and the subsequent glEndQuery. The symbolic constant must be GL_SAMPLES_PASSED.
        /// </para>
        /// </param>
        /// <param name="id">
        /// <para>
        /// Specifies the name of a query object.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glBeginQueryARB")]
            public static 
            void BeginQuery(OpenTK.Graphics.OpenGL.ArbOcclusionQuery target, Int32 id)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBeginQueryARB((OpenTK.Graphics.OpenGL.ArbOcclusionQuery)target, (UInt32)id);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Delimit the boundaries of a query object
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target type of query object established between glBeginQuery and the subsequent glEndQuery. The symbolic constant must be GL_SAMPLES_PASSED.
        /// </para>
        /// </param>
        /// <param name="id">
        /// <para>
        /// Specifies the name of a query object.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glBeginQueryARB")]
            public static 
            void BeginQuery(OpenTK.Graphics.OpenGL.ArbOcclusionQuery target, UInt32 id)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBeginQueryARB((OpenTK.Graphics.OpenGL.ArbOcclusionQuery)target, (UInt32)id);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Associates a generic vertex attribute index with a named attribute variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the handle of the program object in which the association is to be made.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be bound.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Specifies a null terminated string containing the name of the vertex shader attribute variable to which index is to be bound.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexShader", Version = "1.2", EntryPoint = "glBindAttribLocationARB")]
            public static 
            void BindAttribLocation(Int32 programObj, Int32 index, String name)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBindAttribLocationARB((UInt32)programObj, (UInt32)index, (String)name);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Associates a generic vertex attribute index with a named attribute variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the handle of the program object in which the association is to be made.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be bound.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Specifies a null terminated string containing the name of the vertex shader attribute variable to which index is to be bound.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexShader", Version = "1.2", EntryPoint = "glBindAttribLocationARB")]
            public static 
            void BindAttribLocation(UInt32 programObj, UInt32 index, String name)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBindAttribLocationARB((UInt32)programObj, (UInt32)index, (String)name);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Bind a named buffer object
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target to which the buffer object is bound. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="buffer">
        /// <para>
        /// Specifies the name of a buffer object.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glBindBufferARB")]
            public static 
            void BindBuffer(OpenTK.Graphics.OpenGL.BufferTargetArb target, Int32 buffer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBindBufferARB((OpenTK.Graphics.OpenGL.BufferTargetArb)target, (UInt32)buffer);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Bind a named buffer object
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target to which the buffer object is bound. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="buffer">
        /// <para>
        /// Specifies the name of a buffer object.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glBindBufferARB")]
            public static 
            void BindBuffer(OpenTK.Graphics.OpenGL.BufferTargetArb target, UInt32 buffer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBindBufferARB((OpenTK.Graphics.OpenGL.BufferTargetArb)target, (UInt32)buffer);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glBindProgramARB")]
            public static 
            void BindProgram(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, Int32 program)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBindProgramARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)program);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glBindProgramARB")]
            public static 
            void BindProgram(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, UInt32 program)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBindProgramARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)program);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Creates and initializes a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the buffer object's new data store.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to data that will be copied into the data store for initialization, or NULL if no data is to be copied.
        /// </para>
        /// </param>
        /// <param name="usage">
        /// <para>
        /// Specifies the expected usage pattern of the data store. The symbolic constant must be GL_STREAM_DRAW, GL_STREAM_READ, GL_STREAM_COPY, GL_STATIC_DRAW, GL_STATIC_READ, GL_STATIC_COPY, GL_DYNAMIC_DRAW, GL_DYNAMIC_READ, or GL_DYNAMIC_COPY.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glBufferDataARB")]
            public static 
            void BufferData(OpenTK.Graphics.OpenGL.BufferTargetArb target, IntPtr size, IntPtr data, OpenTK.Graphics.OpenGL.BufferUsageArb usage)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBufferDataARB((OpenTK.Graphics.OpenGL.BufferTargetArb)target, (IntPtr)size, (IntPtr)data, (OpenTK.Graphics.OpenGL.BufferUsageArb)usage);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Creates and initializes a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the buffer object's new data store.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to data that will be copied into the data store for initialization, or NULL if no data is to be copied.
        /// </para>
        /// </param>
        /// <param name="usage">
        /// <para>
        /// Specifies the expected usage pattern of the data store. The symbolic constant must be GL_STREAM_DRAW, GL_STREAM_READ, GL_STREAM_COPY, GL_STATIC_DRAW, GL_STATIC_READ, GL_STATIC_COPY, GL_DYNAMIC_DRAW, GL_DYNAMIC_READ, or GL_DYNAMIC_COPY.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glBufferDataARB")]
            public static 
            void BufferData<T2>(OpenTK.Graphics.OpenGL.BufferTargetArb target, IntPtr size, [InAttribute, OutAttribute] T2[] data, OpenTK.Graphics.OpenGL.BufferUsageArb usage)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glBufferDataARB((OpenTK.Graphics.OpenGL.BufferTargetArb)target, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject(), (OpenTK.Graphics.OpenGL.BufferUsageArb)usage);
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Creates and initializes a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the buffer object's new data store.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to data that will be copied into the data store for initialization, or NULL if no data is to be copied.
        /// </para>
        /// </param>
        /// <param name="usage">
        /// <para>
        /// Specifies the expected usage pattern of the data store. The symbolic constant must be GL_STREAM_DRAW, GL_STREAM_READ, GL_STREAM_COPY, GL_STATIC_DRAW, GL_STATIC_READ, GL_STATIC_COPY, GL_DYNAMIC_DRAW, GL_DYNAMIC_READ, or GL_DYNAMIC_COPY.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glBufferDataARB")]
            public static 
            void BufferData<T2>(OpenTK.Graphics.OpenGL.BufferTargetArb target, IntPtr size, [InAttribute, OutAttribute] T2[,] data, OpenTK.Graphics.OpenGL.BufferUsageArb usage)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glBufferDataARB((OpenTK.Graphics.OpenGL.BufferTargetArb)target, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject(), (OpenTK.Graphics.OpenGL.BufferUsageArb)usage);
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Creates and initializes a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the buffer object's new data store.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to data that will be copied into the data store for initialization, or NULL if no data is to be copied.
        /// </para>
        /// </param>
        /// <param name="usage">
        /// <para>
        /// Specifies the expected usage pattern of the data store. The symbolic constant must be GL_STREAM_DRAW, GL_STREAM_READ, GL_STREAM_COPY, GL_STATIC_DRAW, GL_STATIC_READ, GL_STATIC_COPY, GL_DYNAMIC_DRAW, GL_DYNAMIC_READ, or GL_DYNAMIC_COPY.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glBufferDataARB")]
            public static 
            void BufferData<T2>(OpenTK.Graphics.OpenGL.BufferTargetArb target, IntPtr size, [InAttribute, OutAttribute] T2[,,] data, OpenTK.Graphics.OpenGL.BufferUsageArb usage)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glBufferDataARB((OpenTK.Graphics.OpenGL.BufferTargetArb)target, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject(), (OpenTK.Graphics.OpenGL.BufferUsageArb)usage);
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Creates and initializes a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the buffer object's new data store.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to data that will be copied into the data store for initialization, or NULL if no data is to be copied.
        /// </para>
        /// </param>
        /// <param name="usage">
        /// <para>
        /// Specifies the expected usage pattern of the data store. The symbolic constant must be GL_STREAM_DRAW, GL_STREAM_READ, GL_STREAM_COPY, GL_STATIC_DRAW, GL_STATIC_READ, GL_STATIC_COPY, GL_DYNAMIC_DRAW, GL_DYNAMIC_READ, or GL_DYNAMIC_COPY.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glBufferDataARB")]
            public static 
            void BufferData<T2>(OpenTK.Graphics.OpenGL.BufferTargetArb target, IntPtr size, [InAttribute, OutAttribute] ref T2 data, OpenTK.Graphics.OpenGL.BufferUsageArb usage)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glBufferDataARB((OpenTK.Graphics.OpenGL.BufferTargetArb)target, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject(), (OpenTK.Graphics.OpenGL.BufferUsageArb)usage);
                    data = (T2)data_ptr.Target;
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Updates a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store where data replacement will begin, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being replaced.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the new data that will be copied into the data store.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glBufferSubDataARB")]
            public static 
            void BufferSubData(OpenTK.Graphics.OpenGL.BufferTargetArb target, IntPtr offset, IntPtr size, IntPtr data)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBufferSubDataARB((OpenTK.Graphics.OpenGL.BufferTargetArb)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Updates a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store where data replacement will begin, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being replaced.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the new data that will be copied into the data store.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glBufferSubDataARB")]
            public static 
            void BufferSubData<T3>(OpenTK.Graphics.OpenGL.BufferTargetArb target, IntPtr offset, IntPtr size, [InAttribute, OutAttribute] T3[] data)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glBufferSubDataARB((OpenTK.Graphics.OpenGL.BufferTargetArb)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Updates a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store where data replacement will begin, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being replaced.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the new data that will be copied into the data store.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glBufferSubDataARB")]
            public static 
            void BufferSubData<T3>(OpenTK.Graphics.OpenGL.BufferTargetArb target, IntPtr offset, IntPtr size, [InAttribute, OutAttribute] T3[,] data)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glBufferSubDataARB((OpenTK.Graphics.OpenGL.BufferTargetArb)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Updates a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store where data replacement will begin, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being replaced.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the new data that will be copied into the data store.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glBufferSubDataARB")]
            public static 
            void BufferSubData<T3>(OpenTK.Graphics.OpenGL.BufferTargetArb target, IntPtr offset, IntPtr size, [InAttribute, OutAttribute] T3[,,] data)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glBufferSubDataARB((OpenTK.Graphics.OpenGL.BufferTargetArb)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Updates a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store where data replacement will begin, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being replaced.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the new data that will be copied into the data store.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glBufferSubDataARB")]
            public static 
            void BufferSubData<T3>(OpenTK.Graphics.OpenGL.BufferTargetArb target, IntPtr offset, IntPtr size, [InAttribute, OutAttribute] ref T3 data)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glBufferSubDataARB((OpenTK.Graphics.OpenGL.BufferTargetArb)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
                    data = (T3)data_ptr.Target;
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbColorBufferFloat", Version = "1.5", EntryPoint = "glClampColorARB")]
            public static 
            void ClampColor(OpenTK.Graphics.OpenGL.ArbColorBufferFloat target, OpenTK.Graphics.OpenGL.ArbColorBufferFloat clamp)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glClampColorARB((OpenTK.Graphics.OpenGL.ArbColorBufferFloat)target, (OpenTK.Graphics.OpenGL.ArbColorBufferFloat)clamp);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Select active texture unit
        /// </summary>
        /// <param name="texture">
        /// <para>
        /// Specifies which texture unit to make active. The number of texture units is implementation dependent, but must be at least two. texture must be one of GL_TEXTURE, where i ranges from 0 to the value of GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value. The initial value is GL_TEXTURE0.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glClientActiveTextureARB")]
            public static 
            void ClientActiveTexture(OpenTK.Graphics.OpenGL.TextureUnit texture)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glClientActiveTextureARB((OpenTK.Graphics.OpenGL.TextureUnit)texture);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Compiles a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be compiled.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glCompileShaderARB")]
            public static 
            void CompileShader(Int32 shaderObj)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glCompileShaderARB((UInt32)shaderObj);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Compiles a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be compiled.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glCompileShaderARB")]
            public static 
            void CompileShader(UInt32 shaderObj)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glCompileShaderARB((UInt32)shaderObj);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a one-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_1D or GL_PROXY_TEXTURE_1D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels wide. The height of the 1D texture image is 1.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexImage1DARB")]
            public static 
            void CompressedTexImage1D(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 border, Int32 imageSize, IntPtr data)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glCompressedTexImage1DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (OpenTK.Graphics.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)border, (Int32)imageSize, (IntPtr)data);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a one-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_1D or GL_PROXY_TEXTURE_1D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels wide. The height of the 1D texture image is 1.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexImage1DARB")]
            public static 
            void CompressedTexImage1D<T6>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T6[] data)
                where T6 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexImage1DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (OpenTK.Graphics.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a one-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_1D or GL_PROXY_TEXTURE_1D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels wide. The height of the 1D texture image is 1.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexImage1DARB")]
            public static 
            void CompressedTexImage1D<T6>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T6[,] data)
                where T6 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexImage1DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (OpenTK.Graphics.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a one-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_1D or GL_PROXY_TEXTURE_1D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels wide. The height of the 1D texture image is 1.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexImage1DARB")]
            public static 
            void CompressedTexImage1D<T6>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T6[,,] data)
                where T6 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexImage1DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (OpenTK.Graphics.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a one-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_1D or GL_PROXY_TEXTURE_1D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels wide. The height of the 1D texture image is 1.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexImage1DARB")]
            public static 
            void CompressedTexImage1D<T6>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] ref T6 data)
                where T6 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexImage1DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (OpenTK.Graphics.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                    data = (T6)data_ptr.Target;
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a two-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels wide and cube-mapped texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be Must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels high and cube-mapped texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexImage2DARB")]
            public static 
            void CompressedTexImage2D(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, IntPtr data)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glCompressedTexImage2DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (OpenTK.Graphics.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a two-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels wide and cube-mapped texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be Must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels high and cube-mapped texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexImage2DARB")]
            public static 
            void CompressedTexImage2D<T7>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T7[] data)
                where T7 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexImage2DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (OpenTK.Graphics.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a two-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels wide and cube-mapped texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be Must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels high and cube-mapped texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexImage2DARB")]
            public static 
            void CompressedTexImage2D<T7>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T7[,] data)
                where T7 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexImage2DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (OpenTK.Graphics.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a two-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels wide and cube-mapped texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be Must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels high and cube-mapped texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexImage2DARB")]
            public static 
            void CompressedTexImage2D<T7>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T7[,,] data)
                where T7 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexImage2DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (OpenTK.Graphics.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a two-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels wide and cube-mapped texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be Must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels high and cube-mapped texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexImage2DARB")]
            public static 
            void CompressedTexImage2D<T7>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] ref T7 data)
                where T7 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexImage2DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (OpenTK.Graphics.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                    data = (T7)data_ptr.Target;
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D or GL_PROXY_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels deep.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexImage3DARB")]
            public static 
            void CompressedTexImage3D(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, Int32 imageSize, IntPtr data)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glCompressedTexImage3DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (OpenTK.Graphics.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (Int32)imageSize, (IntPtr)data);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D or GL_PROXY_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels deep.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexImage3DARB")]
            public static 
            void CompressedTexImage3D<T8>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T8[] data)
                where T8 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexImage3DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (OpenTK.Graphics.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D or GL_PROXY_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels deep.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexImage3DARB")]
            public static 
            void CompressedTexImage3D<T8>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T8[,] data)
                where T8 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexImage3DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (OpenTK.Graphics.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D or GL_PROXY_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels deep.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexImage3DARB")]
            public static 
            void CompressedTexImage3D<T8>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T8[,,] data)
                where T8 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexImage3DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (OpenTK.Graphics.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D or GL_PROXY_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 3D texture images that are at least 16 texels deep.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexImage3DARB")]
            public static 
            void CompressedTexImage3D<T8>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] ref T8 data)
                where T8 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexImage3DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (OpenTK.Graphics.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                    data = (T8)data_ptr.Target;
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a one-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_1D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexSubImage1DARB")]
            public static 
            void CompressedTexSubImage1D(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 width, OpenTK.Graphics.OpenGL.PixelFormat format, Int32 imageSize, IntPtr data)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glCompressedTexSubImage1DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)width, (OpenTK.Graphics.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a one-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_1D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexSubImage1DARB")]
            public static 
            void CompressedTexSubImage1D<T6>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 width, OpenTK.Graphics.OpenGL.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] T6[] data)
                where T6 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexSubImage1DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)width, (OpenTK.Graphics.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a one-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_1D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexSubImage1DARB")]
            public static 
            void CompressedTexSubImage1D<T6>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 width, OpenTK.Graphics.OpenGL.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] T6[,] data)
                where T6 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexSubImage1DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)width, (OpenTK.Graphics.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a one-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_1D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexSubImage1DARB")]
            public static 
            void CompressedTexSubImage1D<T6>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 width, OpenTK.Graphics.OpenGL.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] T6[,,] data)
                where T6 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexSubImage1DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)width, (OpenTK.Graphics.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a one-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_1D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexSubImage1DARB")]
            public static 
            void CompressedTexSubImage1D<T6>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 width, OpenTK.Graphics.OpenGL.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] ref T6 data)
                where T6 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexSubImage1DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)width, (OpenTK.Graphics.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                    data = (T6)data_ptr.Target;
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a two-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexSubImage2DARB")]
            public static 
            void CompressedTexSubImage2D(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.OpenGL.PixelFormat format, Int32 imageSize, IntPtr data)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glCompressedTexSubImage2DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a two-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexSubImage2DARB")]
            public static 
            void CompressedTexSubImage2D<T8>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.OpenGL.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] T8[] data)
                where T8 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexSubImage2DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a two-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexSubImage2DARB")]
            public static 
            void CompressedTexSubImage2D<T8>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.OpenGL.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] T8[,] data)
                where T8 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexSubImage2DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a two-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexSubImage2DARB")]
            public static 
            void CompressedTexSubImage2D<T8>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.OpenGL.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] T8[,,] data)
                where T8 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexSubImage2DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a two-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexSubImage2DARB")]
            public static 
            void CompressedTexSubImage2D<T8>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.OpenGL.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] ref T8 data)
                where T8 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexSubImage2DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                    data = (T8)data_ptr.Target;
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexSubImage3DARB")]
            public static 
            void CompressedTexSubImage3D(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, OpenTK.Graphics.OpenGL.PixelFormat format, Int32 imageSize, IntPtr data)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glCompressedTexSubImage3DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (OpenTK.Graphics.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexSubImage3DARB")]
            public static 
            void CompressedTexSubImage3D<T10>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, OpenTK.Graphics.OpenGL.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] T10[] data)
                where T10 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexSubImage3DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (OpenTK.Graphics.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexSubImage3DARB")]
            public static 
            void CompressedTexSubImage3D<T10>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, OpenTK.Graphics.OpenGL.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] T10[,] data)
                where T10 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexSubImage3DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (OpenTK.Graphics.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexSubImage3DARB")]
            public static 
            void CompressedTexSubImage3D<T10>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, OpenTK.Graphics.OpenGL.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] T10[,,] data)
                where T10 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexSubImage3DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (OpenTK.Graphics.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a three-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glCompressedTexSubImage3DARB")]
            public static 
            void CompressedTexSubImage3D<T10>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, OpenTK.Graphics.OpenGL.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] ref T10 data)
                where T10 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexSubImage3DARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (OpenTK.Graphics.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                    data = (T10)data_ptr.Target;
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glCreateProgramObjectARB")]
            public static 
            Int32 CreateProgramObject()
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glCreateProgramObjectARB();
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glCreateShaderObjectARB")]
            public static 
            Int32 CreateShaderObject(OpenTK.Graphics.OpenGL.ArbShaderObjects shaderType)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glCreateShaderObjectARB((OpenTK.Graphics.OpenGL.ArbShaderObjects)shaderType);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbMatrixPalette", Version = "1.1", EntryPoint = "glCurrentPaletteMatrixARB")]
            public static 
            void CurrentPaletteMatrix(Int32 index)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glCurrentPaletteMatrixARB((Int32)index);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Delete named buffer objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array of buffer objects to be deleted.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glDeleteBuffersARB")]
            public static 
            void DeleteBuffers(Int32 n, Int32[] buffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* buffers_ptr = buffers)
                    {
                        Delegates.glDeleteBuffersARB((Int32)n, (UInt32*)buffers_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Delete named buffer objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array of buffer objects to be deleted.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glDeleteBuffersARB")]
            public static 
            void DeleteBuffers(Int32 n, ref Int32 buffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* buffers_ptr = &buffers)
                    {
                        Delegates.glDeleteBuffersARB((Int32)n, (UInt32*)buffers_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Delete named buffer objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array of buffer objects to be deleted.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glDeleteBuffersARB")]
            public static 
            unsafe void DeleteBuffers(Int32 n, Int32* buffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeleteBuffersARB((Int32)n, (UInt32*)buffers);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Delete named buffer objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array of buffer objects to be deleted.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glDeleteBuffersARB")]
            public static 
            void DeleteBuffers(Int32 n, UInt32[] buffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* buffers_ptr = buffers)
                    {
                        Delegates.glDeleteBuffersARB((Int32)n, (UInt32*)buffers_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Delete named buffer objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array of buffer objects to be deleted.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glDeleteBuffersARB")]
            public static 
            void DeleteBuffers(Int32 n, ref UInt32 buffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* buffers_ptr = &buffers)
                    {
                        Delegates.glDeleteBuffersARB((Int32)n, (UInt32*)buffers_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Delete named buffer objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array of buffer objects to be deleted.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glDeleteBuffersARB")]
            public static 
            unsafe void DeleteBuffers(Int32 n, UInt32* buffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeleteBuffersARB((Int32)n, (UInt32*)buffers);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glDeleteObjectARB")]
            public static 
            void DeleteObject(Int32 obj)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeleteObjectARB((UInt32)obj);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glDeleteObjectARB")]
            public static 
            void DeleteObject(UInt32 obj)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeleteObjectARB((UInt32)obj);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Deletes a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be deleted.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glDeleteProgramsARB")]
            public static 
            void DeleteProgram(Int32 n, Int32[] programs)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* programs_ptr = programs)
                    {
                        Delegates.glDeleteProgramsARB((Int32)n, (UInt32*)programs_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Deletes a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be deleted.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glDeleteProgramsARB")]
            public static 
            void DeleteProgram(Int32 n, ref Int32 programs)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* programs_ptr = &programs)
                    {
                        Delegates.glDeleteProgramsARB((Int32)n, (UInt32*)programs_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Deletes a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be deleted.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glDeleteProgramsARB")]
            public static 
            unsafe void DeleteProgram(Int32 n, Int32* programs)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeleteProgramsARB((Int32)n, (UInt32*)programs);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Deletes a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be deleted.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glDeleteProgramsARB")]
            public static 
            void DeleteProgram(Int32 n, UInt32[] programs)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* programs_ptr = programs)
                    {
                        Delegates.glDeleteProgramsARB((Int32)n, (UInt32*)programs_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Deletes a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be deleted.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glDeleteProgramsARB")]
            public static 
            void DeleteProgram(Int32 n, ref UInt32 programs)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* programs_ptr = &programs)
                    {
                        Delegates.glDeleteProgramsARB((Int32)n, (UInt32*)programs_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Deletes a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be deleted.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glDeleteProgramsARB")]
            public static 
            unsafe void DeleteProgram(Int32 n, UInt32* programs)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeleteProgramsARB((Int32)n, (UInt32*)programs);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Delete named query objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of query objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="ids">
        /// <para>
        /// Specifies an array of query objects to be deleted.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glDeleteQueriesARB")]
            public static 
            void DeleteQueries(Int32 n, Int32[] ids)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* ids_ptr = ids)
                    {
                        Delegates.glDeleteQueriesARB((Int32)n, (UInt32*)ids_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Delete named query objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of query objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="ids">
        /// <para>
        /// Specifies an array of query objects to be deleted.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glDeleteQueriesARB")]
            public static 
            void DeleteQueries(Int32 n, ref Int32 ids)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* ids_ptr = &ids)
                    {
                        Delegates.glDeleteQueriesARB((Int32)n, (UInt32*)ids_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Delete named query objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of query objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="ids">
        /// <para>
        /// Specifies an array of query objects to be deleted.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glDeleteQueriesARB")]
            public static 
            unsafe void DeleteQueries(Int32 n, Int32* ids)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeleteQueriesARB((Int32)n, (UInt32*)ids);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Delete named query objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of query objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="ids">
        /// <para>
        /// Specifies an array of query objects to be deleted.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glDeleteQueriesARB")]
            public static 
            void DeleteQueries(Int32 n, UInt32[] ids)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* ids_ptr = ids)
                    {
                        Delegates.glDeleteQueriesARB((Int32)n, (UInt32*)ids_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Delete named query objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of query objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="ids">
        /// <para>
        /// Specifies an array of query objects to be deleted.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glDeleteQueriesARB")]
            public static 
            void DeleteQueries(Int32 n, ref UInt32 ids)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* ids_ptr = &ids)
                    {
                        Delegates.glDeleteQueriesARB((Int32)n, (UInt32*)ids_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Delete named query objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of query objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="ids">
        /// <para>
        /// Specifies an array of query objects to be deleted.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glDeleteQueriesARB")]
            public static 
            unsafe void DeleteQueries(Int32 n, UInt32* ids)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeleteQueriesARB((Int32)n, (UInt32*)ids);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glDetachObjectARB")]
            public static 
            void DetachObject(Int32 containerObj, Int32 attachedObj)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDetachObjectARB((UInt32)containerObj, (UInt32)attachedObj);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glDetachObjectARB")]
            public static 
            void DetachObject(UInt32 containerObj, UInt32 attachedObj)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDetachObjectARB((UInt32)containerObj, (UInt32)attachedObj);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glDisableVertexAttribArrayARB")]
            public static 
            void DisableVertexAttribArray(Int32 index)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDisableVertexAttribArrayARB((UInt32)index);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glDisableVertexAttribArrayARB")]
            public static 
            void DisableVertexAttribArray(UInt32 index)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDisableVertexAttribArrayARB((UInt32)index);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbDrawInstanced", Version = "2.0", EntryPoint = "glDrawArraysInstancedARB")]
            public static 
            void DrawArraysInstanced(OpenTK.Graphics.OpenGL.BeginMode mode, Int32 first, Int32 count, Int32 primcount)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDrawArraysInstancedARB((OpenTK.Graphics.OpenGL.BeginMode)mode, (Int32)first, (Int32)count, (Int32)primcount);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies a list of color buffers to be drawn into
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffers in bufs.
        /// </para>
        /// </param>
        /// <param name="bufs">
        /// <para>
        /// Points to an array of symbolic constants specifying the buffers into which fragment colors or data values will be written.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbDrawBuffers", Version = "1.5", EntryPoint = "glDrawBuffersARB")]
            public static 
            void DrawBuffers(Int32 n, OpenTK.Graphics.OpenGL.ArbDrawBuffers[] bufs)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (OpenTK.Graphics.OpenGL.ArbDrawBuffers* bufs_ptr = bufs)
                    {
                        Delegates.glDrawBuffersARB((Int32)n, (OpenTK.Graphics.OpenGL.ArbDrawBuffers*)bufs_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies a list of color buffers to be drawn into
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffers in bufs.
        /// </para>
        /// </param>
        /// <param name="bufs">
        /// <para>
        /// Points to an array of symbolic constants specifying the buffers into which fragment colors or data values will be written.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbDrawBuffers", Version = "1.5", EntryPoint = "glDrawBuffersARB")]
            public static 
            void DrawBuffers(Int32 n, ref OpenTK.Graphics.OpenGL.ArbDrawBuffers bufs)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (OpenTK.Graphics.OpenGL.ArbDrawBuffers* bufs_ptr = &bufs)
                    {
                        Delegates.glDrawBuffersARB((Int32)n, (OpenTK.Graphics.OpenGL.ArbDrawBuffers*)bufs_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies a list of color buffers to be drawn into
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffers in bufs.
        /// </para>
        /// </param>
        /// <param name="bufs">
        /// <para>
        /// Points to an array of symbolic constants specifying the buffers into which fragment colors or data values will be written.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbDrawBuffers", Version = "1.5", EntryPoint = "glDrawBuffersARB")]
            public static 
            unsafe void DrawBuffers(Int32 n, OpenTK.Graphics.OpenGL.ArbDrawBuffers* bufs)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDrawBuffersARB((Int32)n, (OpenTK.Graphics.OpenGL.ArbDrawBuffers*)bufs);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbDrawInstanced", Version = "2.0", EntryPoint = "glDrawElementsInstancedARB")]
            public static 
            void DrawElementsInstanced(OpenTK.Graphics.OpenGL.BeginMode mode, Int32 count, OpenTK.Graphics.OpenGL.DrawElementsType type, IntPtr indices, Int32 primcount)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDrawElementsInstancedARB((OpenTK.Graphics.OpenGL.BeginMode)mode, (Int32)count, (OpenTK.Graphics.OpenGL.DrawElementsType)type, (IntPtr)indices, (Int32)primcount);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbDrawInstanced", Version = "2.0", EntryPoint = "glDrawElementsInstancedARB")]
            public static 
            void DrawElementsInstanced<T3>(OpenTK.Graphics.OpenGL.BeginMode mode, Int32 count, OpenTK.Graphics.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T3[] indices, Int32 primcount)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
                try
                {
                    Delegates.glDrawElementsInstancedARB((OpenTK.Graphics.OpenGL.BeginMode)mode, (Int32)count, (OpenTK.Graphics.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)primcount);
                }
                finally
                {
                    indices_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbDrawInstanced", Version = "2.0", EntryPoint = "glDrawElementsInstancedARB")]
            public static 
            void DrawElementsInstanced<T3>(OpenTK.Graphics.OpenGL.BeginMode mode, Int32 count, OpenTK.Graphics.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T3[,] indices, Int32 primcount)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
                try
                {
                    Delegates.glDrawElementsInstancedARB((OpenTK.Graphics.OpenGL.BeginMode)mode, (Int32)count, (OpenTK.Graphics.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)primcount);
                }
                finally
                {
                    indices_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbDrawInstanced", Version = "2.0", EntryPoint = "glDrawElementsInstancedARB")]
            public static 
            void DrawElementsInstanced<T3>(OpenTK.Graphics.OpenGL.BeginMode mode, Int32 count, OpenTK.Graphics.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T3[,,] indices, Int32 primcount)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
                try
                {
                    Delegates.glDrawElementsInstancedARB((OpenTK.Graphics.OpenGL.BeginMode)mode, (Int32)count, (OpenTK.Graphics.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)primcount);
                }
                finally
                {
                    indices_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbDrawInstanced", Version = "2.0", EntryPoint = "glDrawElementsInstancedARB")]
            public static 
            void DrawElementsInstanced<T3>(OpenTK.Graphics.OpenGL.BeginMode mode, Int32 count, OpenTK.Graphics.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] ref T3 indices, Int32 primcount)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
                try
                {
                    Delegates.glDrawElementsInstancedARB((OpenTK.Graphics.OpenGL.BeginMode)mode, (Int32)count, (OpenTK.Graphics.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)primcount);
                    indices = (T3)indices_ptr.Target;
                }
                finally
                {
                    indices_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Enable or disable a generic vertex attribute array
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be enabled or disabled.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glEnableVertexAttribArrayARB")]
            public static 
            void EnableVertexAttribArray(Int32 index)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glEnableVertexAttribArrayARB((UInt32)index);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Enable or disable a generic vertex attribute array
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be enabled or disabled.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glEnableVertexAttribArrayARB")]
            public static 
            void EnableVertexAttribArray(UInt32 index)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glEnableVertexAttribArrayARB((UInt32)index);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glEndQueryARB")]
            public static 
            void EndQuery(OpenTK.Graphics.OpenGL.ArbOcclusionQuery target)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glEndQueryARB((OpenTK.Graphics.OpenGL.ArbOcclusionQuery)target);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbGeometryShader4", Version = "3.0", EntryPoint = "glFramebufferTextureARB")]
            public static 
            void FramebufferTexture(OpenTK.Graphics.OpenGL.FramebufferTarget target, OpenTK.Graphics.OpenGL.FramebufferAttachment attachment, Int32 texture, Int32 level)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFramebufferTextureARB((OpenTK.Graphics.OpenGL.FramebufferTarget)target, (OpenTK.Graphics.OpenGL.FramebufferAttachment)attachment, (UInt32)texture, (Int32)level);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbGeometryShader4", Version = "3.0", EntryPoint = "glFramebufferTextureARB")]
            public static 
            void FramebufferTexture(OpenTK.Graphics.OpenGL.FramebufferTarget target, OpenTK.Graphics.OpenGL.FramebufferAttachment attachment, UInt32 texture, Int32 level)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFramebufferTextureARB((OpenTK.Graphics.OpenGL.FramebufferTarget)target, (OpenTK.Graphics.OpenGL.FramebufferAttachment)attachment, (UInt32)texture, (Int32)level);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbGeometryShader4", Version = "3.0", EntryPoint = "glFramebufferTextureFaceARB")]
            public static 
            void FramebufferTextureFace(OpenTK.Graphics.OpenGL.FramebufferTarget target, OpenTK.Graphics.OpenGL.FramebufferAttachment attachment, Int32 texture, Int32 level, OpenTK.Graphics.OpenGL.TextureTarget face)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFramebufferTextureFaceARB((OpenTK.Graphics.OpenGL.FramebufferTarget)target, (OpenTK.Graphics.OpenGL.FramebufferAttachment)attachment, (UInt32)texture, (Int32)level, (OpenTK.Graphics.OpenGL.TextureTarget)face);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbGeometryShader4", Version = "3.0", EntryPoint = "glFramebufferTextureFaceARB")]
            public static 
            void FramebufferTextureFace(OpenTK.Graphics.OpenGL.FramebufferTarget target, OpenTK.Graphics.OpenGL.FramebufferAttachment attachment, UInt32 texture, Int32 level, OpenTK.Graphics.OpenGL.TextureTarget face)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFramebufferTextureFaceARB((OpenTK.Graphics.OpenGL.FramebufferTarget)target, (OpenTK.Graphics.OpenGL.FramebufferAttachment)attachment, (UInt32)texture, (Int32)level, (OpenTK.Graphics.OpenGL.TextureTarget)face);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbGeometryShader4", Version = "3.0", EntryPoint = "glFramebufferTextureLayerARB")]
            public static 
            void FramebufferTextureLayer(OpenTK.Graphics.OpenGL.FramebufferTarget target, OpenTK.Graphics.OpenGL.FramebufferAttachment attachment, Int32 texture, Int32 level, Int32 layer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFramebufferTextureLayerARB((OpenTK.Graphics.OpenGL.FramebufferTarget)target, (OpenTK.Graphics.OpenGL.FramebufferAttachment)attachment, (UInt32)texture, (Int32)level, (Int32)layer);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbGeometryShader4", Version = "3.0", EntryPoint = "glFramebufferTextureLayerARB")]
            public static 
            void FramebufferTextureLayer(OpenTK.Graphics.OpenGL.FramebufferTarget target, OpenTK.Graphics.OpenGL.FramebufferAttachment attachment, UInt32 texture, Int32 level, Int32 layer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFramebufferTextureLayerARB((OpenTK.Graphics.OpenGL.FramebufferTarget)target, (OpenTK.Graphics.OpenGL.FramebufferAttachment)attachment, (UInt32)texture, (Int32)level, (Int32)layer);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Generate buffer object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer object names to be generated.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array in which the generated buffer object names are stored.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glGenBuffersARB")]
            public static 
            void GenBuffers(Int32 n, [OutAttribute] Int32[] buffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* buffers_ptr = buffers)
                    {
                        Delegates.glGenBuffersARB((Int32)n, (UInt32*)buffers_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Generate buffer object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer object names to be generated.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array in which the generated buffer object names are stored.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glGenBuffersARB")]
            public static 
            void GenBuffers(Int32 n, [OutAttribute] out Int32 buffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* buffers_ptr = &buffers)
                    {
                        Delegates.glGenBuffersARB((Int32)n, (UInt32*)buffers_ptr);
                        buffers = *buffers_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Generate buffer object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer object names to be generated.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array in which the generated buffer object names are stored.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glGenBuffersARB")]
            public static 
            unsafe void GenBuffers(Int32 n, [OutAttribute] Int32* buffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGenBuffersARB((Int32)n, (UInt32*)buffers);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Generate buffer object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer object names to be generated.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array in which the generated buffer object names are stored.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glGenBuffersARB")]
            public static 
            void GenBuffers(Int32 n, [OutAttribute] UInt32[] buffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* buffers_ptr = buffers)
                    {
                        Delegates.glGenBuffersARB((Int32)n, (UInt32*)buffers_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Generate buffer object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer object names to be generated.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array in which the generated buffer object names are stored.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glGenBuffersARB")]
            public static 
            void GenBuffers(Int32 n, [OutAttribute] out UInt32 buffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* buffers_ptr = &buffers)
                    {
                        Delegates.glGenBuffersARB((Int32)n, (UInt32*)buffers_ptr);
                        buffers = *buffers_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Generate buffer object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer object names to be generated.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array in which the generated buffer object names are stored.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glGenBuffersARB")]
            public static 
            unsafe void GenBuffers(Int32 n, [OutAttribute] UInt32* buffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGenBuffersARB((Int32)n, (UInt32*)buffers);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGenProgramsARB")]
            public static 
            void GenProgram(Int32 n, [OutAttribute] Int32[] programs)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* programs_ptr = programs)
                    {
                        Delegates.glGenProgramsARB((Int32)n, (UInt32*)programs_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGenProgramsARB")]
            public static 
            void GenProgram(Int32 n, [OutAttribute] out Int32 programs)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* programs_ptr = &programs)
                    {
                        Delegates.glGenProgramsARB((Int32)n, (UInt32*)programs_ptr);
                        programs = *programs_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGenProgramsARB")]
            public static 
            unsafe void GenProgram(Int32 n, [OutAttribute] Int32* programs)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGenProgramsARB((Int32)n, (UInt32*)programs);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGenProgramsARB")]
            public static 
            void GenProgram(Int32 n, [OutAttribute] UInt32[] programs)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* programs_ptr = programs)
                    {
                        Delegates.glGenProgramsARB((Int32)n, (UInt32*)programs_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGenProgramsARB")]
            public static 
            void GenProgram(Int32 n, [OutAttribute] out UInt32 programs)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* programs_ptr = &programs)
                    {
                        Delegates.glGenProgramsARB((Int32)n, (UInt32*)programs_ptr);
                        programs = *programs_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGenProgramsARB")]
            public static 
            unsafe void GenProgram(Int32 n, [OutAttribute] UInt32* programs)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGenProgramsARB((Int32)n, (UInt32*)programs);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Generate query object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of query object names to be generated.
        /// </para>
        /// </param>
        /// <param name="ids">
        /// <para>
        /// Specifies an array in which the generated query object names are stored.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glGenQueriesARB")]
            public static 
            void GenQueries(Int32 n, [OutAttribute] Int32[] ids)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* ids_ptr = ids)
                    {
                        Delegates.glGenQueriesARB((Int32)n, (UInt32*)ids_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Generate query object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of query object names to be generated.
        /// </para>
        /// </param>
        /// <param name="ids">
        /// <para>
        /// Specifies an array in which the generated query object names are stored.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glGenQueriesARB")]
            public static 
            void GenQueries(Int32 n, [OutAttribute] out Int32 ids)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* ids_ptr = &ids)
                    {
                        Delegates.glGenQueriesARB((Int32)n, (UInt32*)ids_ptr);
                        ids = *ids_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Generate query object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of query object names to be generated.
        /// </para>
        /// </param>
        /// <param name="ids">
        /// <para>
        /// Specifies an array in which the generated query object names are stored.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glGenQueriesARB")]
            public static 
            unsafe void GenQueries(Int32 n, [OutAttribute] Int32* ids)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGenQueriesARB((Int32)n, (UInt32*)ids);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Generate query object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of query object names to be generated.
        /// </para>
        /// </param>
        /// <param name="ids">
        /// <para>
        /// Specifies an array in which the generated query object names are stored.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glGenQueriesARB")]
            public static 
            void GenQueries(Int32 n, [OutAttribute] UInt32[] ids)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* ids_ptr = ids)
                    {
                        Delegates.glGenQueriesARB((Int32)n, (UInt32*)ids_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Generate query object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of query object names to be generated.
        /// </para>
        /// </param>
        /// <param name="ids">
        /// <para>
        /// Specifies an array in which the generated query object names are stored.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glGenQueriesARB")]
            public static 
            void GenQueries(Int32 n, [OutAttribute] out UInt32 ids)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* ids_ptr = &ids)
                    {
                        Delegates.glGenQueriesARB((Int32)n, (UInt32*)ids_ptr);
                        ids = *ids_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Generate query object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of query object names to be generated.
        /// </para>
        /// </param>
        /// <param name="ids">
        /// <para>
        /// Specifies an array in which the generated query object names are stored.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glGenQueriesARB")]
            public static 
            unsafe void GenQueries(Int32 n, [OutAttribute] UInt32* ids)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGenQueriesARB((Int32)n, (UInt32*)ids);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns information about an active attribute variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the attribute variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the attribute variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexShader", Version = "1.2", EntryPoint = "glGetActiveAttribARB")]
            public static 
            void GetActiveAttrib(Int32 programObj, Int32 index, Int32 maxLength, [OutAttribute] out Int32 length, [OutAttribute] out Int32 size, [OutAttribute] out OpenTK.Graphics.OpenGL.ArbVertexShader type, [OutAttribute] StringBuilder name)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    fixed (Int32* size_ptr = &size)
                    fixed (OpenTK.Graphics.OpenGL.ArbVertexShader* type_ptr = &type)
                    {
                        Delegates.glGetActiveAttribARB((UInt32)programObj, (UInt32)index, (Int32)maxLength, (Int32*)length_ptr, (Int32*)size_ptr, (OpenTK.Graphics.OpenGL.ArbVertexShader*)type_ptr, (StringBuilder)name);
                        length = *length_ptr;
                        size = *size_ptr;
                        type = *type_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns information about an active attribute variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the attribute variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the attribute variable.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexShader", Version = "1.2", EntryPoint = "glGetActiveAttribARB")]
            public static 
            unsafe void GetActiveAttrib(Int32 programObj, Int32 index, Int32 maxLength, [OutAttribute] Int32* length, [OutAttribute] Int32* size, [OutAttribute] OpenTK.Graphics.OpenGL.ArbVertexShader* type, [OutAttribute] StringBuilder name)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetActiveAttribARB((UInt32)programObj, (UInt32)index, (Int32)maxLength, (Int32*)length, (Int32*)size, (OpenTK.Graphics.OpenGL.ArbVertexShader*)type, (StringBuilder)name);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns information about an active attribute variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the attribute variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the attribute variable.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexShader", Version = "1.2", EntryPoint = "glGetActiveAttribARB")]
            public static 
            void GetActiveAttrib(UInt32 programObj, UInt32 index, Int32 maxLength, [OutAttribute] out Int32 length, [OutAttribute] out Int32 size, [OutAttribute] out OpenTK.Graphics.OpenGL.ArbVertexShader type, [OutAttribute] StringBuilder name)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    fixed (Int32* size_ptr = &size)
                    fixed (OpenTK.Graphics.OpenGL.ArbVertexShader* type_ptr = &type)
                    {
                        Delegates.glGetActiveAttribARB((UInt32)programObj, (UInt32)index, (Int32)maxLength, (Int32*)length_ptr, (Int32*)size_ptr, (OpenTK.Graphics.OpenGL.ArbVertexShader*)type_ptr, (StringBuilder)name);
                        length = *length_ptr;
                        size = *size_ptr;
                        type = *type_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns information about an active attribute variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the attribute variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the attribute variable.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexShader", Version = "1.2", EntryPoint = "glGetActiveAttribARB")]
            public static 
            unsafe void GetActiveAttrib(UInt32 programObj, UInt32 index, Int32 maxLength, [OutAttribute] Int32* length, [OutAttribute] Int32* size, [OutAttribute] OpenTK.Graphics.OpenGL.ArbVertexShader* type, [OutAttribute] StringBuilder name)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetActiveAttribARB((UInt32)programObj, (UInt32)index, (Int32)maxLength, (Int32*)length, (Int32*)size, (OpenTK.Graphics.OpenGL.ArbVertexShader*)type, (StringBuilder)name);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns information about an active uniform variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetActiveUniformARB")]
            public static 
            void GetActiveUniform(Int32 programObj, Int32 index, Int32 maxLength, [OutAttribute] out Int32 length, [OutAttribute] out Int32 size, [OutAttribute] out OpenTK.Graphics.OpenGL.ArbShaderObjects type, [OutAttribute] StringBuilder name)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    fixed (Int32* size_ptr = &size)
                    fixed (OpenTK.Graphics.OpenGL.ArbShaderObjects* type_ptr = &type)
                    {
                        Delegates.glGetActiveUniformARB((UInt32)programObj, (UInt32)index, (Int32)maxLength, (Int32*)length_ptr, (Int32*)size_ptr, (OpenTK.Graphics.OpenGL.ArbShaderObjects*)type_ptr, (StringBuilder)name);
                        length = *length_ptr;
                        size = *size_ptr;
                        type = *type_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns information about an active uniform variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the uniform variable.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetActiveUniformARB")]
            public static 
            unsafe void GetActiveUniform(Int32 programObj, Int32 index, Int32 maxLength, [OutAttribute] Int32* length, [OutAttribute] Int32* size, [OutAttribute] OpenTK.Graphics.OpenGL.ArbShaderObjects* type, [OutAttribute] StringBuilder name)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetActiveUniformARB((UInt32)programObj, (UInt32)index, (Int32)maxLength, (Int32*)length, (Int32*)size, (OpenTK.Graphics.OpenGL.ArbShaderObjects*)type, (StringBuilder)name);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns information about an active uniform variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the uniform variable.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetActiveUniformARB")]
            public static 
            void GetActiveUniform(UInt32 programObj, UInt32 index, Int32 maxLength, [OutAttribute] out Int32 length, [OutAttribute] out Int32 size, [OutAttribute] out OpenTK.Graphics.OpenGL.ArbShaderObjects type, [OutAttribute] StringBuilder name)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    fixed (Int32* size_ptr = &size)
                    fixed (OpenTK.Graphics.OpenGL.ArbShaderObjects* type_ptr = &type)
                    {
                        Delegates.glGetActiveUniformARB((UInt32)programObj, (UInt32)index, (Int32)maxLength, (Int32*)length_ptr, (Int32*)size_ptr, (OpenTK.Graphics.OpenGL.ArbShaderObjects*)type_ptr, (StringBuilder)name);
                        length = *length_ptr;
                        size = *size_ptr;
                        type = *type_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns information about an active uniform variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the uniform variable.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetActiveUniformARB")]
            public static 
            unsafe void GetActiveUniform(UInt32 programObj, UInt32 index, Int32 maxLength, [OutAttribute] Int32* length, [OutAttribute] Int32* size, [OutAttribute] OpenTK.Graphics.OpenGL.ArbShaderObjects* type, [OutAttribute] StringBuilder name)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetActiveUniformARB((UInt32)programObj, (UInt32)index, (Int32)maxLength, (Int32*)length, (Int32*)size, (OpenTK.Graphics.OpenGL.ArbShaderObjects*)type, (StringBuilder)name);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetAttachedObjectsARB")]
            public static 
            void GetAttachedObjects(Int32 containerObj, Int32 maxCount, [OutAttribute] out Int32 count, [OutAttribute] out Int32 obj)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* count_ptr = &count)
                    fixed (Int32* obj_ptr = &obj)
                    {
                        Delegates.glGetAttachedObjectsARB((UInt32)containerObj, (Int32)maxCount, (Int32*)count_ptr, (UInt32*)obj_ptr);
                        count = *count_ptr;
                        obj = *obj_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetAttachedObjectsARB")]
            public static 
            unsafe void GetAttachedObjects(Int32 containerObj, Int32 maxCount, [OutAttribute] Int32* count, [OutAttribute] Int32[] obj)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                fixed (Int32* obj_ptr = obj)
                {
                    Delegates.glGetAttachedObjectsARB((UInt32)containerObj, (Int32)maxCount, (Int32*)count, (UInt32*)obj_ptr);
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetAttachedObjectsARB")]
            public static 
            unsafe void GetAttachedObjects(Int32 containerObj, Int32 maxCount, [OutAttribute] Int32* count, [OutAttribute] Int32* obj)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetAttachedObjectsARB((UInt32)containerObj, (Int32)maxCount, (Int32*)count, (UInt32*)obj);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetAttachedObjectsARB")]
            public static 
            void GetAttachedObjects(UInt32 containerObj, Int32 maxCount, [OutAttribute] out Int32 count, [OutAttribute] out UInt32 obj)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* count_ptr = &count)
                    fixed (UInt32* obj_ptr = &obj)
                    {
                        Delegates.glGetAttachedObjectsARB((UInt32)containerObj, (Int32)maxCount, (Int32*)count_ptr, (UInt32*)obj_ptr);
                        count = *count_ptr;
                        obj = *obj_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetAttachedObjectsARB")]
            public static 
            unsafe void GetAttachedObjects(UInt32 containerObj, Int32 maxCount, [OutAttribute] Int32* count, [OutAttribute] UInt32[] obj)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                fixed (UInt32* obj_ptr = obj)
                {
                    Delegates.glGetAttachedObjectsARB((UInt32)containerObj, (Int32)maxCount, (Int32*)count, (UInt32*)obj_ptr);
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetAttachedObjectsARB")]
            public static 
            unsafe void GetAttachedObjects(UInt32 containerObj, Int32 maxCount, [OutAttribute] Int32* count, [OutAttribute] UInt32* obj)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetAttachedObjectsARB((UInt32)containerObj, (Int32)maxCount, (Int32*)count, (UInt32*)obj);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns the location of an attribute variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Points to a null terminated string containing the name of the attribute variable whose location is to be queried.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexShader", Version = "1.2", EntryPoint = "glGetAttribLocationARB")]
            public static 
            Int32 GetAttribLocation(Int32 programObj, String name)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glGetAttribLocationARB((UInt32)programObj, (String)name);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns the location of an attribute variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Points to a null terminated string containing the name of the attribute variable whose location is to be queried.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexShader", Version = "1.2", EntryPoint = "glGetAttribLocationARB")]
            public static 
            Int32 GetAttribLocation(UInt32 programObj, String name)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glGetAttribLocationARB((UInt32)programObj, (String)name);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glGetBufferParameterivARB")]
            public static 
            void GetBufferParameter(OpenTK.Graphics.OpenGL.ArbVertexBufferObject target, OpenTK.Graphics.OpenGL.BufferParameterNameArb pname, [OutAttribute] Int32[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = @params)
                    {
                        Delegates.glGetBufferParameterivARB((OpenTK.Graphics.OpenGL.ArbVertexBufferObject)target, (OpenTK.Graphics.OpenGL.BufferParameterNameArb)pname, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glGetBufferParameterivARB")]
            public static 
            void GetBufferParameter(OpenTK.Graphics.OpenGL.ArbVertexBufferObject target, OpenTK.Graphics.OpenGL.BufferParameterNameArb pname, [OutAttribute] out Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetBufferParameterivARB((OpenTK.Graphics.OpenGL.ArbVertexBufferObject)target, (OpenTK.Graphics.OpenGL.BufferParameterNameArb)pname, (Int32*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glGetBufferParameterivARB")]
            public static 
            unsafe void GetBufferParameter(OpenTK.Graphics.OpenGL.ArbVertexBufferObject target, OpenTK.Graphics.OpenGL.BufferParameterNameArb pname, [OutAttribute] Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetBufferParameterivARB((OpenTK.Graphics.OpenGL.ArbVertexBufferObject)target, (OpenTK.Graphics.OpenGL.BufferParameterNameArb)pname, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glGetBufferPointervARB")]
            public static 
            void GetBufferPointer(OpenTK.Graphics.OpenGL.ArbVertexBufferObject target, OpenTK.Graphics.OpenGL.BufferPointerNameArb pname, [OutAttribute] IntPtr @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetBufferPointervARB((OpenTK.Graphics.OpenGL.ArbVertexBufferObject)target, (OpenTK.Graphics.OpenGL.BufferPointerNameArb)pname, (IntPtr)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glGetBufferPointervARB")]
            public static 
            void GetBufferPointer<T2>(OpenTK.Graphics.OpenGL.ArbVertexBufferObject target, OpenTK.Graphics.OpenGL.BufferPointerNameArb pname, [InAttribute, OutAttribute] T2[] @params)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetBufferPointervARB((OpenTK.Graphics.OpenGL.ArbVertexBufferObject)target, (OpenTK.Graphics.OpenGL.BufferPointerNameArb)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    @params_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glGetBufferPointervARB")]
            public static 
            void GetBufferPointer<T2>(OpenTK.Graphics.OpenGL.ArbVertexBufferObject target, OpenTK.Graphics.OpenGL.BufferPointerNameArb pname, [InAttribute, OutAttribute] T2[,] @params)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetBufferPointervARB((OpenTK.Graphics.OpenGL.ArbVertexBufferObject)target, (OpenTK.Graphics.OpenGL.BufferPointerNameArb)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    @params_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glGetBufferPointervARB")]
            public static 
            void GetBufferPointer<T2>(OpenTK.Graphics.OpenGL.ArbVertexBufferObject target, OpenTK.Graphics.OpenGL.BufferPointerNameArb pname, [InAttribute, OutAttribute] T2[,,] @params)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetBufferPointervARB((OpenTK.Graphics.OpenGL.ArbVertexBufferObject)target, (OpenTK.Graphics.OpenGL.BufferPointerNameArb)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    @params_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glGetBufferPointervARB")]
            public static 
            void GetBufferPointer<T2>(OpenTK.Graphics.OpenGL.ArbVertexBufferObject target, OpenTK.Graphics.OpenGL.BufferPointerNameArb pname, [InAttribute, OutAttribute] ref T2 @params)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetBufferPointervARB((OpenTK.Graphics.OpenGL.ArbVertexBufferObject)target, (OpenTK.Graphics.OpenGL.BufferPointerNameArb)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
                    @params = (T2)@params_ptr.Target;
                }
                finally
                {
                    @params_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store from which data will be returned, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being returned.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the location where buffer object data is returned.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glGetBufferSubDataARB")]
            public static 
            void GetBufferSubData(OpenTK.Graphics.OpenGL.BufferTargetArb target, IntPtr offset, IntPtr size, [OutAttribute] IntPtr data)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetBufferSubDataARB((OpenTK.Graphics.OpenGL.BufferTargetArb)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store from which data will be returned, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being returned.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the location where buffer object data is returned.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glGetBufferSubDataARB")]
            public static 
            void GetBufferSubData<T3>(OpenTK.Graphics.OpenGL.BufferTargetArb target, IntPtr offset, IntPtr size, [InAttribute, OutAttribute] T3[] data)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetBufferSubDataARB((OpenTK.Graphics.OpenGL.BufferTargetArb)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store from which data will be returned, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being returned.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the location where buffer object data is returned.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glGetBufferSubDataARB")]
            public static 
            void GetBufferSubData<T3>(OpenTK.Graphics.OpenGL.BufferTargetArb target, IntPtr offset, IntPtr size, [InAttribute, OutAttribute] T3[,] data)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetBufferSubDataARB((OpenTK.Graphics.OpenGL.BufferTargetArb)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store from which data will be returned, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being returned.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the location where buffer object data is returned.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glGetBufferSubDataARB")]
            public static 
            void GetBufferSubData<T3>(OpenTK.Graphics.OpenGL.BufferTargetArb target, IntPtr offset, IntPtr size, [InAttribute, OutAttribute] T3[,,] data)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetBufferSubDataARB((OpenTK.Graphics.OpenGL.BufferTargetArb)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store from which data will be returned, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being returned.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the location where buffer object data is returned.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glGetBufferSubDataARB")]
            public static 
            void GetBufferSubData<T3>(OpenTK.Graphics.OpenGL.BufferTargetArb target, IntPtr offset, IntPtr size, [InAttribute, OutAttribute] ref T3 data)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetBufferSubDataARB((OpenTK.Graphics.OpenGL.BufferTargetArb)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
                    data = (T3)data_ptr.Target;
                }
                finally
                {
                    data_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return a compressed texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies which texture is to be obtained. GL_TEXTURE_1D, GL_TEXTURE_2D, and GL_TEXTURE_3D GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, and GL_TEXTURE_CUBE_MAP_NEGATIVE_Z are accepted.
        /// </para>
        /// </param>
        /// <param name="lod">
        /// <para>
        /// Specifies the level-of-detail number of the desired image. Level 0 is the base image level. Level is the th mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="img">
        /// <para>
        /// Returns the compressed texture image.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glGetCompressedTexImageARB")]
            public static 
            void GetCompressedTexImage(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, [OutAttribute] IntPtr img)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetCompressedTexImageARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (IntPtr)img);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return a compressed texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies which texture is to be obtained. GL_TEXTURE_1D, GL_TEXTURE_2D, and GL_TEXTURE_3D GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, and GL_TEXTURE_CUBE_MAP_NEGATIVE_Z are accepted.
        /// </para>
        /// </param>
        /// <param name="lod">
        /// <para>
        /// Specifies the level-of-detail number of the desired image. Level 0 is the base image level. Level is the th mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="img">
        /// <para>
        /// Returns the compressed texture image.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glGetCompressedTexImageARB")]
            public static 
            void GetCompressedTexImage<T2>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, [InAttribute, OutAttribute] T2[] img)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle img_ptr = GCHandle.Alloc(img, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetCompressedTexImageARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (IntPtr)img_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    img_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return a compressed texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies which texture is to be obtained. GL_TEXTURE_1D, GL_TEXTURE_2D, and GL_TEXTURE_3D GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, and GL_TEXTURE_CUBE_MAP_NEGATIVE_Z are accepted.
        /// </para>
        /// </param>
        /// <param name="lod">
        /// <para>
        /// Specifies the level-of-detail number of the desired image. Level 0 is the base image level. Level is the th mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="img">
        /// <para>
        /// Returns the compressed texture image.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glGetCompressedTexImageARB")]
            public static 
            void GetCompressedTexImage<T2>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, [InAttribute, OutAttribute] T2[,] img)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle img_ptr = GCHandle.Alloc(img, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetCompressedTexImageARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (IntPtr)img_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    img_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return a compressed texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies which texture is to be obtained. GL_TEXTURE_1D, GL_TEXTURE_2D, and GL_TEXTURE_3D GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, and GL_TEXTURE_CUBE_MAP_NEGATIVE_Z are accepted.
        /// </para>
        /// </param>
        /// <param name="lod">
        /// <para>
        /// Specifies the level-of-detail number of the desired image. Level 0 is the base image level. Level is the th mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="img">
        /// <para>
        /// Returns the compressed texture image.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glGetCompressedTexImageARB")]
            public static 
            void GetCompressedTexImage<T2>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, [InAttribute, OutAttribute] T2[,,] img)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle img_ptr = GCHandle.Alloc(img, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetCompressedTexImageARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (IntPtr)img_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    img_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return a compressed texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies which texture is to be obtained. GL_TEXTURE_1D, GL_TEXTURE_2D, and GL_TEXTURE_3D GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, and GL_TEXTURE_CUBE_MAP_NEGATIVE_Z are accepted.
        /// </para>
        /// </param>
        /// <param name="lod">
        /// <para>
        /// Specifies the level-of-detail number of the desired image. Level 0 is the base image level. Level is the th mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="img">
        /// <para>
        /// Returns the compressed texture image.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTextureCompression", Version = "1.2", EntryPoint = "glGetCompressedTexImageARB")]
            public static 
            void GetCompressedTexImage<T2>(OpenTK.Graphics.OpenGL.TextureTarget target, Int32 level, [InAttribute, OutAttribute] ref T2 img)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle img_ptr = GCHandle.Alloc(img, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetCompressedTexImageARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (Int32)level, (IntPtr)img_ptr.AddrOfPinnedObject());
                    img = (T2)img_ptr.Target;
                }
                finally
                {
                    img_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetHandleARB")]
            public static 
            Int32 GetHandle(OpenTK.Graphics.OpenGL.ArbShaderObjects pname)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glGetHandleARB((OpenTK.Graphics.OpenGL.ArbShaderObjects)pname);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetInfoLogARB")]
            public static 
            void GetInfoLog(Int32 obj, Int32 maxLength, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder infoLog)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    {
                        Delegates.glGetInfoLogARB((UInt32)obj, (Int32)maxLength, (Int32*)length_ptr, (StringBuilder)infoLog);
                        length = *length_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetInfoLogARB")]
            public static 
            unsafe void GetInfoLog(Int32 obj, Int32 maxLength, [OutAttribute] Int32* length, [OutAttribute] StringBuilder infoLog)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetInfoLogARB((UInt32)obj, (Int32)maxLength, (Int32*)length, (StringBuilder)infoLog);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetInfoLogARB")]
            public static 
            void GetInfoLog(UInt32 obj, Int32 maxLength, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder infoLog)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    {
                        Delegates.glGetInfoLogARB((UInt32)obj, (Int32)maxLength, (Int32*)length_ptr, (StringBuilder)infoLog);
                        length = *length_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetInfoLogARB")]
            public static 
            unsafe void GetInfoLog(UInt32 obj, Int32 maxLength, [OutAttribute] Int32* length, [OutAttribute] StringBuilder infoLog)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetInfoLogARB((UInt32)obj, (Int32)maxLength, (Int32*)length, (StringBuilder)infoLog);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetObjectParameterfvARB")]
            public static 
            void GetObjectParameter(Int32 obj, OpenTK.Graphics.OpenGL.ArbShaderObjects pname, [OutAttribute] Single[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = @params)
                    {
                        Delegates.glGetObjectParameterfvARB((UInt32)obj, (OpenTK.Graphics.OpenGL.ArbShaderObjects)pname, (Single*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetObjectParameterfvARB")]
            public static 
            void GetObjectParameter(Int32 obj, OpenTK.Graphics.OpenGL.ArbShaderObjects pname, [OutAttribute] out Single @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = &@params)
                    {
                        Delegates.glGetObjectParameterfvARB((UInt32)obj, (OpenTK.Graphics.OpenGL.ArbShaderObjects)pname, (Single*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetObjectParameterfvARB")]
            public static 
            unsafe void GetObjectParameter(Int32 obj, OpenTK.Graphics.OpenGL.ArbShaderObjects pname, [OutAttribute] Single* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetObjectParameterfvARB((UInt32)obj, (OpenTK.Graphics.OpenGL.ArbShaderObjects)pname, (Single*)@params);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetObjectParameterfvARB")]
            public static 
            void GetObjectParameter(UInt32 obj, OpenTK.Graphics.OpenGL.ArbShaderObjects pname, [OutAttribute] Single[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = @params)
                    {
                        Delegates.glGetObjectParameterfvARB((UInt32)obj, (OpenTK.Graphics.OpenGL.ArbShaderObjects)pname, (Single*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetObjectParameterfvARB")]
            public static 
            void GetObjectParameter(UInt32 obj, OpenTK.Graphics.OpenGL.ArbShaderObjects pname, [OutAttribute] out Single @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = &@params)
                    {
                        Delegates.glGetObjectParameterfvARB((UInt32)obj, (OpenTK.Graphics.OpenGL.ArbShaderObjects)pname, (Single*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetObjectParameterfvARB")]
            public static 
            unsafe void GetObjectParameter(UInt32 obj, OpenTK.Graphics.OpenGL.ArbShaderObjects pname, [OutAttribute] Single* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetObjectParameterfvARB((UInt32)obj, (OpenTK.Graphics.OpenGL.ArbShaderObjects)pname, (Single*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetObjectParameterivARB")]
            public static 
            void GetObjectParameter(Int32 obj, OpenTK.Graphics.OpenGL.ArbShaderObjects pname, [OutAttribute] Int32[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = @params)
                    {
                        Delegates.glGetObjectParameterivARB((UInt32)obj, (OpenTK.Graphics.OpenGL.ArbShaderObjects)pname, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetObjectParameterivARB")]
            public static 
            void GetObjectParameter(Int32 obj, OpenTK.Graphics.OpenGL.ArbShaderObjects pname, [OutAttribute] out Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetObjectParameterivARB((UInt32)obj, (OpenTK.Graphics.OpenGL.ArbShaderObjects)pname, (Int32*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetObjectParameterivARB")]
            public static 
            unsafe void GetObjectParameter(Int32 obj, OpenTK.Graphics.OpenGL.ArbShaderObjects pname, [OutAttribute] Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetObjectParameterivARB((UInt32)obj, (OpenTK.Graphics.OpenGL.ArbShaderObjects)pname, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetObjectParameterivARB")]
            public static 
            void GetObjectParameter(UInt32 obj, OpenTK.Graphics.OpenGL.ArbShaderObjects pname, [OutAttribute] Int32[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = @params)
                    {
                        Delegates.glGetObjectParameterivARB((UInt32)obj, (OpenTK.Graphics.OpenGL.ArbShaderObjects)pname, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetObjectParameterivARB")]
            public static 
            void GetObjectParameter(UInt32 obj, OpenTK.Graphics.OpenGL.ArbShaderObjects pname, [OutAttribute] out Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetObjectParameterivARB((UInt32)obj, (OpenTK.Graphics.OpenGL.ArbShaderObjects)pname, (Int32*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetObjectParameterivARB")]
            public static 
            unsafe void GetObjectParameter(UInt32 obj, OpenTK.Graphics.OpenGL.ArbShaderObjects pname, [OutAttribute] Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetObjectParameterivARB((UInt32)obj, (OpenTK.Graphics.OpenGL.ArbShaderObjects)pname, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramEnvParameterdvARB")]
            public static 
            void GetProgramEnvParameter(OpenTK.Graphics.OpenGL.ArbVertexProgram target, Int32 index, [OutAttribute] Double[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* @params_ptr = @params)
                    {
                        Delegates.glGetProgramEnvParameterdvARB((OpenTK.Graphics.OpenGL.ArbVertexProgram)target, (UInt32)index, (Double*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramEnvParameterdvARB")]
            public static 
            void GetProgramEnvParameter(OpenTK.Graphics.OpenGL.ArbVertexProgram target, Int32 index, [OutAttribute] out Double @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* @params_ptr = &@params)
                    {
                        Delegates.glGetProgramEnvParameterdvARB((OpenTK.Graphics.OpenGL.ArbVertexProgram)target, (UInt32)index, (Double*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramEnvParameterdvARB")]
            public static 
            unsafe void GetProgramEnvParameter(OpenTK.Graphics.OpenGL.ArbVertexProgram target, Int32 index, [OutAttribute] Double* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetProgramEnvParameterdvARB((OpenTK.Graphics.OpenGL.ArbVertexProgram)target, (UInt32)index, (Double*)@params);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramEnvParameterdvARB")]
            public static 
            void GetProgramEnvParameter(OpenTK.Graphics.OpenGL.ArbVertexProgram target, UInt32 index, [OutAttribute] Double[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* @params_ptr = @params)
                    {
                        Delegates.glGetProgramEnvParameterdvARB((OpenTK.Graphics.OpenGL.ArbVertexProgram)target, (UInt32)index, (Double*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramEnvParameterdvARB")]
            public static 
            void GetProgramEnvParameter(OpenTK.Graphics.OpenGL.ArbVertexProgram target, UInt32 index, [OutAttribute] out Double @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* @params_ptr = &@params)
                    {
                        Delegates.glGetProgramEnvParameterdvARB((OpenTK.Graphics.OpenGL.ArbVertexProgram)target, (UInt32)index, (Double*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramEnvParameterdvARB")]
            public static 
            unsafe void GetProgramEnvParameter(OpenTK.Graphics.OpenGL.ArbVertexProgram target, UInt32 index, [OutAttribute] Double* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetProgramEnvParameterdvARB((OpenTK.Graphics.OpenGL.ArbVertexProgram)target, (UInt32)index, (Double*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramEnvParameterfvARB")]
            public static 
            void GetProgramEnvParameter(OpenTK.Graphics.OpenGL.ArbVertexProgram target, Int32 index, [OutAttribute] Single[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = @params)
                    {
                        Delegates.glGetProgramEnvParameterfvARB((OpenTK.Graphics.OpenGL.ArbVertexProgram)target, (UInt32)index, (Single*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramEnvParameterfvARB")]
            public static 
            void GetProgramEnvParameter(OpenTK.Graphics.OpenGL.ArbVertexProgram target, Int32 index, [OutAttribute] out Single @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = &@params)
                    {
                        Delegates.glGetProgramEnvParameterfvARB((OpenTK.Graphics.OpenGL.ArbVertexProgram)target, (UInt32)index, (Single*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramEnvParameterfvARB")]
            public static 
            unsafe void GetProgramEnvParameter(OpenTK.Graphics.OpenGL.ArbVertexProgram target, Int32 index, [OutAttribute] Single* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetProgramEnvParameterfvARB((OpenTK.Graphics.OpenGL.ArbVertexProgram)target, (UInt32)index, (Single*)@params);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramEnvParameterfvARB")]
            public static 
            void GetProgramEnvParameter(OpenTK.Graphics.OpenGL.ArbVertexProgram target, UInt32 index, [OutAttribute] Single[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = @params)
                    {
                        Delegates.glGetProgramEnvParameterfvARB((OpenTK.Graphics.OpenGL.ArbVertexProgram)target, (UInt32)index, (Single*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramEnvParameterfvARB")]
            public static 
            void GetProgramEnvParameter(OpenTK.Graphics.OpenGL.ArbVertexProgram target, UInt32 index, [OutAttribute] out Single @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = &@params)
                    {
                        Delegates.glGetProgramEnvParameterfvARB((OpenTK.Graphics.OpenGL.ArbVertexProgram)target, (UInt32)index, (Single*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramEnvParameterfvARB")]
            public static 
            unsafe void GetProgramEnvParameter(OpenTK.Graphics.OpenGL.ArbVertexProgram target, UInt32 index, [OutAttribute] Single* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetProgramEnvParameterfvARB((OpenTK.Graphics.OpenGL.ArbVertexProgram)target, (UInt32)index, (Single*)@params);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns a parameter from a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the object parameter. Accepted symbolic names are GL_DELETE_STATUS, GL_LINK_STATUS, GL_VALIDATE_STATUS, GL_INFO_LOG_LENGTH, GL_ATTACHED_SHADERS, GL_ACTIVE_ATTRIBUTES, GL_ACTIVE_ATTRIBUTE_MAX_LENGTH, GL_ACTIVE_UNIFORMS, GL_ACTIVE_UNIFORM_MAX_LENGTH.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested object parameter.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramivARB")]
            public static 
            void GetProgram(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, OpenTK.Graphics.OpenGL.AssemblyProgramParameterArb pname, [OutAttribute] out Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetProgramivARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (OpenTK.Graphics.OpenGL.AssemblyProgramParameterArb)pname, (Int32*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns a parameter from a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the object parameter. Accepted symbolic names are GL_DELETE_STATUS, GL_LINK_STATUS, GL_VALIDATE_STATUS, GL_INFO_LOG_LENGTH, GL_ATTACHED_SHADERS, GL_ACTIVE_ATTRIBUTES, GL_ACTIVE_ATTRIBUTE_MAX_LENGTH, GL_ACTIVE_UNIFORMS, GL_ACTIVE_UNIFORM_MAX_LENGTH.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested object parameter.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramivARB")]
            public static 
            unsafe void GetProgram(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, OpenTK.Graphics.OpenGL.AssemblyProgramParameterArb pname, [OutAttribute] Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetProgramivARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (OpenTK.Graphics.OpenGL.AssemblyProgramParameterArb)pname, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramLocalParameterdvARB")]
            public static 
            void GetProgramLocalParameter(OpenTK.Graphics.OpenGL.ArbVertexProgram target, Int32 index, [OutAttribute] Double[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* @params_ptr = @params)
                    {
                        Delegates.glGetProgramLocalParameterdvARB((OpenTK.Graphics.OpenGL.ArbVertexProgram)target, (UInt32)index, (Double*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramLocalParameterdvARB")]
            public static 
            void GetProgramLocalParameter(OpenTK.Graphics.OpenGL.ArbVertexProgram target, Int32 index, [OutAttribute] out Double @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* @params_ptr = &@params)
                    {
                        Delegates.glGetProgramLocalParameterdvARB((OpenTK.Graphics.OpenGL.ArbVertexProgram)target, (UInt32)index, (Double*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramLocalParameterdvARB")]
            public static 
            unsafe void GetProgramLocalParameter(OpenTK.Graphics.OpenGL.ArbVertexProgram target, Int32 index, [OutAttribute] Double* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetProgramLocalParameterdvARB((OpenTK.Graphics.OpenGL.ArbVertexProgram)target, (UInt32)index, (Double*)@params);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramLocalParameterdvARB")]
            public static 
            void GetProgramLocalParameter(OpenTK.Graphics.OpenGL.ArbVertexProgram target, UInt32 index, [OutAttribute] Double[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* @params_ptr = @params)
                    {
                        Delegates.glGetProgramLocalParameterdvARB((OpenTK.Graphics.OpenGL.ArbVertexProgram)target, (UInt32)index, (Double*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramLocalParameterdvARB")]
            public static 
            void GetProgramLocalParameter(OpenTK.Graphics.OpenGL.ArbVertexProgram target, UInt32 index, [OutAttribute] out Double @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* @params_ptr = &@params)
                    {
                        Delegates.glGetProgramLocalParameterdvARB((OpenTK.Graphics.OpenGL.ArbVertexProgram)target, (UInt32)index, (Double*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramLocalParameterdvARB")]
            public static 
            unsafe void GetProgramLocalParameter(OpenTK.Graphics.OpenGL.ArbVertexProgram target, UInt32 index, [OutAttribute] Double* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetProgramLocalParameterdvARB((OpenTK.Graphics.OpenGL.ArbVertexProgram)target, (UInt32)index, (Double*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramLocalParameterfvARB")]
            public static 
            void GetProgramLocalParameter(OpenTK.Graphics.OpenGL.ArbVertexProgram target, Int32 index, [OutAttribute] Single[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = @params)
                    {
                        Delegates.glGetProgramLocalParameterfvARB((OpenTK.Graphics.OpenGL.ArbVertexProgram)target, (UInt32)index, (Single*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramLocalParameterfvARB")]
            public static 
            void GetProgramLocalParameter(OpenTK.Graphics.OpenGL.ArbVertexProgram target, Int32 index, [OutAttribute] out Single @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = &@params)
                    {
                        Delegates.glGetProgramLocalParameterfvARB((OpenTK.Graphics.OpenGL.ArbVertexProgram)target, (UInt32)index, (Single*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramLocalParameterfvARB")]
            public static 
            unsafe void GetProgramLocalParameter(OpenTK.Graphics.OpenGL.ArbVertexProgram target, Int32 index, [OutAttribute] Single* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetProgramLocalParameterfvARB((OpenTK.Graphics.OpenGL.ArbVertexProgram)target, (UInt32)index, (Single*)@params);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramLocalParameterfvARB")]
            public static 
            void GetProgramLocalParameter(OpenTK.Graphics.OpenGL.ArbVertexProgram target, UInt32 index, [OutAttribute] Single[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = @params)
                    {
                        Delegates.glGetProgramLocalParameterfvARB((OpenTK.Graphics.OpenGL.ArbVertexProgram)target, (UInt32)index, (Single*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramLocalParameterfvARB")]
            public static 
            void GetProgramLocalParameter(OpenTK.Graphics.OpenGL.ArbVertexProgram target, UInt32 index, [OutAttribute] out Single @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = &@params)
                    {
                        Delegates.glGetProgramLocalParameterfvARB((OpenTK.Graphics.OpenGL.ArbVertexProgram)target, (UInt32)index, (Single*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramLocalParameterfvARB")]
            public static 
            unsafe void GetProgramLocalParameter(OpenTK.Graphics.OpenGL.ArbVertexProgram target, UInt32 index, [OutAttribute] Single* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetProgramLocalParameterfvARB((OpenTK.Graphics.OpenGL.ArbVertexProgram)target, (UInt32)index, (Single*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramStringARB")]
            public static 
            void GetProgramString(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, OpenTK.Graphics.OpenGL.AssemblyProgramParameterArb pname, [OutAttribute] IntPtr @string)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetProgramStringARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (OpenTK.Graphics.OpenGL.AssemblyProgramParameterArb)pname, (IntPtr)@string);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramStringARB")]
            public static 
            void GetProgramString<T2>(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, OpenTK.Graphics.OpenGL.AssemblyProgramParameterArb pname, [InAttribute, OutAttribute] T2[] @string)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle @string_ptr = GCHandle.Alloc(@string, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetProgramStringARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (OpenTK.Graphics.OpenGL.AssemblyProgramParameterArb)pname, (IntPtr)@string_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    @string_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramStringARB")]
            public static 
            void GetProgramString<T2>(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, OpenTK.Graphics.OpenGL.AssemblyProgramParameterArb pname, [InAttribute, OutAttribute] T2[,] @string)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle @string_ptr = GCHandle.Alloc(@string, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetProgramStringARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (OpenTK.Graphics.OpenGL.AssemblyProgramParameterArb)pname, (IntPtr)@string_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    @string_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramStringARB")]
            public static 
            void GetProgramString<T2>(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, OpenTK.Graphics.OpenGL.AssemblyProgramParameterArb pname, [InAttribute, OutAttribute] T2[,,] @string)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle @string_ptr = GCHandle.Alloc(@string, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetProgramStringARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (OpenTK.Graphics.OpenGL.AssemblyProgramParameterArb)pname, (IntPtr)@string_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    @string_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetProgramStringARB")]
            public static 
            void GetProgramString<T2>(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, OpenTK.Graphics.OpenGL.AssemblyProgramParameterArb pname, [InAttribute, OutAttribute] ref T2 @string)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle @string_ptr = GCHandle.Alloc(@string, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetProgramStringARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (OpenTK.Graphics.OpenGL.AssemblyProgramParameterArb)pname, (IntPtr)@string_ptr.AddrOfPinnedObject());
                    @string = (T2)@string_ptr.Target;
                }
                finally
                {
                    @string_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glGetQueryivARB")]
            public static 
            void GetQuery(OpenTK.Graphics.OpenGL.ArbOcclusionQuery target, OpenTK.Graphics.OpenGL.ArbOcclusionQuery pname, [OutAttribute] Int32[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = @params)
                    {
                        Delegates.glGetQueryivARB((OpenTK.Graphics.OpenGL.ArbOcclusionQuery)target, (OpenTK.Graphics.OpenGL.ArbOcclusionQuery)pname, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glGetQueryivARB")]
            public static 
            void GetQuery(OpenTK.Graphics.OpenGL.ArbOcclusionQuery target, OpenTK.Graphics.OpenGL.ArbOcclusionQuery pname, [OutAttribute] out Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetQueryivARB((OpenTK.Graphics.OpenGL.ArbOcclusionQuery)target, (OpenTK.Graphics.OpenGL.ArbOcclusionQuery)pname, (Int32*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glGetQueryivARB")]
            public static 
            unsafe void GetQuery(OpenTK.Graphics.OpenGL.ArbOcclusionQuery target, OpenTK.Graphics.OpenGL.ArbOcclusionQuery pname, [OutAttribute] Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetQueryivARB((OpenTK.Graphics.OpenGL.ArbOcclusionQuery)target, (OpenTK.Graphics.OpenGL.ArbOcclusionQuery)pname, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return parameters of a query object
        /// </summary>
        /// <param name="id">
        /// <para>
        /// Specifies the name of a query object.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a query object parameter. Accepted values are GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glGetQueryObjectivARB")]
            public static 
            void GetQueryObject(Int32 id, OpenTK.Graphics.OpenGL.ArbOcclusionQuery pname, [OutAttribute] Int32[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = @params)
                    {
                        Delegates.glGetQueryObjectivARB((UInt32)id, (OpenTK.Graphics.OpenGL.ArbOcclusionQuery)pname, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return parameters of a query object
        /// </summary>
        /// <param name="id">
        /// <para>
        /// Specifies the name of a query object.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a query object parameter. Accepted values are GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glGetQueryObjectivARB")]
            public static 
            void GetQueryObject(Int32 id, OpenTK.Graphics.OpenGL.ArbOcclusionQuery pname, [OutAttribute] out Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetQueryObjectivARB((UInt32)id, (OpenTK.Graphics.OpenGL.ArbOcclusionQuery)pname, (Int32*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return parameters of a query object
        /// </summary>
        /// <param name="id">
        /// <para>
        /// Specifies the name of a query object.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a query object parameter. Accepted values are GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glGetQueryObjectivARB")]
            public static 
            unsafe void GetQueryObject(Int32 id, OpenTK.Graphics.OpenGL.ArbOcclusionQuery pname, [OutAttribute] Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetQueryObjectivARB((UInt32)id, (OpenTK.Graphics.OpenGL.ArbOcclusionQuery)pname, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return parameters of a query object
        /// </summary>
        /// <param name="id">
        /// <para>
        /// Specifies the name of a query object.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a query object parameter. Accepted values are GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glGetQueryObjectivARB")]
            public static 
            void GetQueryObject(UInt32 id, OpenTK.Graphics.OpenGL.ArbOcclusionQuery pname, [OutAttribute] Int32[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = @params)
                    {
                        Delegates.glGetQueryObjectivARB((UInt32)id, (OpenTK.Graphics.OpenGL.ArbOcclusionQuery)pname, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return parameters of a query object
        /// </summary>
        /// <param name="id">
        /// <para>
        /// Specifies the name of a query object.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a query object parameter. Accepted values are GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glGetQueryObjectivARB")]
            public static 
            void GetQueryObject(UInt32 id, OpenTK.Graphics.OpenGL.ArbOcclusionQuery pname, [OutAttribute] out Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetQueryObjectivARB((UInt32)id, (OpenTK.Graphics.OpenGL.ArbOcclusionQuery)pname, (Int32*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return parameters of a query object
        /// </summary>
        /// <param name="id">
        /// <para>
        /// Specifies the name of a query object.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a query object parameter. Accepted values are GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glGetQueryObjectivARB")]
            public static 
            unsafe void GetQueryObject(UInt32 id, OpenTK.Graphics.OpenGL.ArbOcclusionQuery pname, [OutAttribute] Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetQueryObjectivARB((UInt32)id, (OpenTK.Graphics.OpenGL.ArbOcclusionQuery)pname, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return parameters of a query object
        /// </summary>
        /// <param name="id">
        /// <para>
        /// Specifies the name of a query object.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a query object parameter. Accepted values are GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glGetQueryObjectuivARB")]
            public static 
            void GetQueryObject(UInt32 id, OpenTK.Graphics.OpenGL.ArbOcclusionQuery pname, [OutAttribute] UInt32[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* @params_ptr = @params)
                    {
                        Delegates.glGetQueryObjectuivARB((UInt32)id, (OpenTK.Graphics.OpenGL.ArbOcclusionQuery)pname, (UInt32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return parameters of a query object
        /// </summary>
        /// <param name="id">
        /// <para>
        /// Specifies the name of a query object.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a query object parameter. Accepted values are GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glGetQueryObjectuivARB")]
            public static 
            void GetQueryObject(UInt32 id, OpenTK.Graphics.OpenGL.ArbOcclusionQuery pname, [OutAttribute] out UInt32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* @params_ptr = &@params)
                    {
                        Delegates.glGetQueryObjectuivARB((UInt32)id, (OpenTK.Graphics.OpenGL.ArbOcclusionQuery)pname, (UInt32*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return parameters of a query object
        /// </summary>
        /// <param name="id">
        /// <para>
        /// Specifies the name of a query object.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a query object parameter. Accepted values are GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glGetQueryObjectuivARB")]
            public static 
            unsafe void GetQueryObject(UInt32 id, OpenTK.Graphics.OpenGL.ArbOcclusionQuery pname, [OutAttribute] UInt32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetQueryObjectuivARB((UInt32)id, (OpenTK.Graphics.OpenGL.ArbOcclusionQuery)pname, (UInt32*)@params);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns the source code string from a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned source code string.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in source (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="source">
        /// <para>
        /// Specifies an array of characters that is used to return the source code string.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetShaderSourceARB")]
            public static 
            void GetShaderSource(Int32 obj, Int32 maxLength, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder source)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    {
                        Delegates.glGetShaderSourceARB((UInt32)obj, (Int32)maxLength, (Int32*)length_ptr, (StringBuilder)source);
                        length = *length_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns the source code string from a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned source code string.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in source (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="source">
        /// <para>
        /// Specifies an array of characters that is used to return the source code string.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetShaderSourceARB")]
            public static 
            unsafe void GetShaderSource(Int32 obj, Int32 maxLength, [OutAttribute] Int32* length, [OutAttribute] StringBuilder source)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetShaderSourceARB((UInt32)obj, (Int32)maxLength, (Int32*)length, (StringBuilder)source);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns the source code string from a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned source code string.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in source (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="source">
        /// <para>
        /// Specifies an array of characters that is used to return the source code string.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetShaderSourceARB")]
            public static 
            void GetShaderSource(UInt32 obj, Int32 maxLength, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder source)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    {
                        Delegates.glGetShaderSourceARB((UInt32)obj, (Int32)maxLength, (Int32*)length_ptr, (StringBuilder)source);
                        length = *length_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns the source code string from a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned source code string.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in source (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="source">
        /// <para>
        /// Specifies an array of characters that is used to return the source code string.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetShaderSourceARB")]
            public static 
            unsafe void GetShaderSource(UInt32 obj, Int32 maxLength, [OutAttribute] Int32* length, [OutAttribute] StringBuilder source)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetShaderSourceARB((UInt32)obj, (Int32)maxLength, (Int32*)length, (StringBuilder)source);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns the value of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the value of the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetUniformfvARB")]
            public static 
            void GetUniform(Int32 programObj, Int32 location, [OutAttribute] Single[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = @params)
                    {
                        Delegates.glGetUniformfvARB((UInt32)programObj, (Int32)location, (Single*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns the value of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the value of the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetUniformfvARB")]
            public static 
            void GetUniform(Int32 programObj, Int32 location, [OutAttribute] out Single @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = &@params)
                    {
                        Delegates.glGetUniformfvARB((UInt32)programObj, (Int32)location, (Single*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns the value of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the value of the specified uniform variable.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetUniformfvARB")]
            public static 
            unsafe void GetUniform(Int32 programObj, Int32 location, [OutAttribute] Single* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetUniformfvARB((UInt32)programObj, (Int32)location, (Single*)@params);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns the value of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the value of the specified uniform variable.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetUniformfvARB")]
            public static 
            void GetUniform(UInt32 programObj, Int32 location, [OutAttribute] Single[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = @params)
                    {
                        Delegates.glGetUniformfvARB((UInt32)programObj, (Int32)location, (Single*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns the value of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the value of the specified uniform variable.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetUniformfvARB")]
            public static 
            void GetUniform(UInt32 programObj, Int32 location, [OutAttribute] out Single @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = &@params)
                    {
                        Delegates.glGetUniformfvARB((UInt32)programObj, (Int32)location, (Single*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns the value of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the value of the specified uniform variable.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetUniformfvARB")]
            public static 
            unsafe void GetUniform(UInt32 programObj, Int32 location, [OutAttribute] Single* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetUniformfvARB((UInt32)programObj, (Int32)location, (Single*)@params);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns the value of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the value of the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetUniformivARB")]
            public static 
            void GetUniform(Int32 programObj, Int32 location, [OutAttribute] Int32[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = @params)
                    {
                        Delegates.glGetUniformivARB((UInt32)programObj, (Int32)location, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns the value of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the value of the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetUniformivARB")]
            public static 
            void GetUniform(Int32 programObj, Int32 location, [OutAttribute] out Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetUniformivARB((UInt32)programObj, (Int32)location, (Int32*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns the value of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the value of the specified uniform variable.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetUniformivARB")]
            public static 
            unsafe void GetUniform(Int32 programObj, Int32 location, [OutAttribute] Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetUniformivARB((UInt32)programObj, (Int32)location, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns the value of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the value of the specified uniform variable.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetUniformivARB")]
            public static 
            void GetUniform(UInt32 programObj, Int32 location, [OutAttribute] Int32[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = @params)
                    {
                        Delegates.glGetUniformivARB((UInt32)programObj, (Int32)location, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns the value of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the value of the specified uniform variable.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetUniformivARB")]
            public static 
            void GetUniform(UInt32 programObj, Int32 location, [OutAttribute] out Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetUniformivARB((UInt32)programObj, (Int32)location, (Int32*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns the value of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the value of the specified uniform variable.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetUniformivARB")]
            public static 
            unsafe void GetUniform(UInt32 programObj, Int32 location, [OutAttribute] Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetUniformivARB((UInt32)programObj, (Int32)location, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns the location of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Points to a null terminated string containing the name of the uniform variable whose location is to be queried.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetUniformLocationARB")]
            public static 
            Int32 GetUniformLocation(Int32 programObj, String name)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glGetUniformLocationARB((UInt32)programObj, (String)name);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Returns the location of a uniform variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Points to a null terminated string containing the name of the uniform variable whose location is to be queried.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetUniformLocationARB")]
            public static 
            Int32 GetUniformLocation(UInt32 programObj, String name)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glGetUniformLocationARB((UInt32)programObj, (String)name);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribdvARB")]
            public static 
            void GetVertexAttrib(Int32 index, OpenTK.Graphics.OpenGL.VertexAttribParameterArb pname, [OutAttribute] Double[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* @params_ptr = @params)
                    {
                        Delegates.glGetVertexAttribdvARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribParameterArb)pname, (Double*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribdvARB")]
            public static 
            void GetVertexAttrib(Int32 index, OpenTK.Graphics.OpenGL.VertexAttribParameterArb pname, [OutAttribute] out Double @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* @params_ptr = &@params)
                    {
                        Delegates.glGetVertexAttribdvARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribParameterArb)pname, (Double*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribdvARB")]
            public static 
            unsafe void GetVertexAttrib(Int32 index, OpenTK.Graphics.OpenGL.VertexAttribParameterArb pname, [OutAttribute] Double* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetVertexAttribdvARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribParameterArb)pname, (Double*)@params);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribdvARB")]
            public static 
            void GetVertexAttrib(UInt32 index, OpenTK.Graphics.OpenGL.VertexAttribParameterArb pname, [OutAttribute] Double[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* @params_ptr = @params)
                    {
                        Delegates.glGetVertexAttribdvARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribParameterArb)pname, (Double*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribdvARB")]
            public static 
            void GetVertexAttrib(UInt32 index, OpenTK.Graphics.OpenGL.VertexAttribParameterArb pname, [OutAttribute] out Double @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* @params_ptr = &@params)
                    {
                        Delegates.glGetVertexAttribdvARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribParameterArb)pname, (Double*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribdvARB")]
            public static 
            unsafe void GetVertexAttrib(UInt32 index, OpenTK.Graphics.OpenGL.VertexAttribParameterArb pname, [OutAttribute] Double* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetVertexAttribdvARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribParameterArb)pname, (Double*)@params);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribfvARB")]
            public static 
            void GetVertexAttrib(Int32 index, OpenTK.Graphics.OpenGL.VertexAttribParameterArb pname, [OutAttribute] Single[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = @params)
                    {
                        Delegates.glGetVertexAttribfvARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribParameterArb)pname, (Single*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribfvARB")]
            public static 
            void GetVertexAttrib(Int32 index, OpenTK.Graphics.OpenGL.VertexAttribParameterArb pname, [OutAttribute] out Single @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = &@params)
                    {
                        Delegates.glGetVertexAttribfvARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribParameterArb)pname, (Single*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribfvARB")]
            public static 
            unsafe void GetVertexAttrib(Int32 index, OpenTK.Graphics.OpenGL.VertexAttribParameterArb pname, [OutAttribute] Single* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetVertexAttribfvARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribParameterArb)pname, (Single*)@params);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribfvARB")]
            public static 
            void GetVertexAttrib(UInt32 index, OpenTK.Graphics.OpenGL.VertexAttribParameterArb pname, [OutAttribute] Single[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = @params)
                    {
                        Delegates.glGetVertexAttribfvARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribParameterArb)pname, (Single*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribfvARB")]
            public static 
            void GetVertexAttrib(UInt32 index, OpenTK.Graphics.OpenGL.VertexAttribParameterArb pname, [OutAttribute] out Single @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = &@params)
                    {
                        Delegates.glGetVertexAttribfvARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribParameterArb)pname, (Single*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribfvARB")]
            public static 
            unsafe void GetVertexAttrib(UInt32 index, OpenTK.Graphics.OpenGL.VertexAttribParameterArb pname, [OutAttribute] Single* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetVertexAttribfvARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribParameterArb)pname, (Single*)@params);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribivARB")]
            public static 
            void GetVertexAttrib(Int32 index, OpenTK.Graphics.OpenGL.VertexAttribParameterArb pname, [OutAttribute] Int32[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = @params)
                    {
                        Delegates.glGetVertexAttribivARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribParameterArb)pname, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribivARB")]
            public static 
            void GetVertexAttrib(Int32 index, OpenTK.Graphics.OpenGL.VertexAttribParameterArb pname, [OutAttribute] out Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetVertexAttribivARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribParameterArb)pname, (Int32*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribivARB")]
            public static 
            unsafe void GetVertexAttrib(Int32 index, OpenTK.Graphics.OpenGL.VertexAttribParameterArb pname, [OutAttribute] Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetVertexAttribivARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribParameterArb)pname, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribivARB")]
            public static 
            void GetVertexAttrib(UInt32 index, OpenTK.Graphics.OpenGL.VertexAttribParameterArb pname, [OutAttribute] Int32[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = @params)
                    {
                        Delegates.glGetVertexAttribivARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribParameterArb)pname, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribivARB")]
            public static 
            void GetVertexAttrib(UInt32 index, OpenTK.Graphics.OpenGL.VertexAttribParameterArb pname, [OutAttribute] out Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetVertexAttribivARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribParameterArb)pname, (Int32*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return a generic vertex attribute parameter
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the generic vertex attribute parameter to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the vertex attribute parameter to be queried. Accepted values are GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, GL_VERTEX_ATTRIB_ARRAY_ENABLED, GL_VERTEX_ATTRIB_ARRAY_SIZE, GL_VERTEX_ATTRIB_ARRAY_STRIDE, GL_VERTEX_ATTRIB_ARRAY_TYPE, GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, or GL_CURRENT_VERTEX_ATTRIB.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribivARB")]
            public static 
            unsafe void GetVertexAttrib(UInt32 index, OpenTK.Graphics.OpenGL.VertexAttribParameterArb pname, [OutAttribute] Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetVertexAttribivARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribParameterArb)pname, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribPointervARB")]
            public static 
            void GetVertexAttribPointer(Int32 index, OpenTK.Graphics.OpenGL.VertexAttribPointerParameterArb pname, [OutAttribute] IntPtr pointer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetVertexAttribPointervARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribPointerParameterArb)pname, (IntPtr)pointer);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribPointervARB")]
            public static 
            void GetVertexAttribPointer<T2>(Int32 index, OpenTK.Graphics.OpenGL.VertexAttribPointerParameterArb pname, [InAttribute, OutAttribute] T2[] pointer)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetVertexAttribPointervARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribPointerParameterArb)pname, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribPointervARB")]
            public static 
            void GetVertexAttribPointer<T2>(Int32 index, OpenTK.Graphics.OpenGL.VertexAttribPointerParameterArb pname, [InAttribute, OutAttribute] T2[,] pointer)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetVertexAttribPointervARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribPointerParameterArb)pname, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribPointervARB")]
            public static 
            void GetVertexAttribPointer<T2>(Int32 index, OpenTK.Graphics.OpenGL.VertexAttribPointerParameterArb pname, [InAttribute, OutAttribute] T2[,,] pointer)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetVertexAttribPointervARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribPointerParameterArb)pname, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribPointervARB")]
            public static 
            void GetVertexAttribPointer<T2>(Int32 index, OpenTK.Graphics.OpenGL.VertexAttribPointerParameterArb pname, [InAttribute, OutAttribute] ref T2 pointer)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetVertexAttribPointervARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribPointerParameterArb)pname, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                    pointer = (T2)pointer_ptr.Target;
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribPointervARB")]
            public static 
            void GetVertexAttribPointer(UInt32 index, OpenTK.Graphics.OpenGL.VertexAttribPointerParameterArb pname, [OutAttribute] IntPtr pointer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetVertexAttribPointervARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribPointerParameterArb)pname, (IntPtr)pointer);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribPointervARB")]
            public static 
            void GetVertexAttribPointer<T2>(UInt32 index, OpenTK.Graphics.OpenGL.VertexAttribPointerParameterArb pname, [InAttribute, OutAttribute] T2[] pointer)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetVertexAttribPointervARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribPointerParameterArb)pname, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribPointervARB")]
            public static 
            void GetVertexAttribPointer<T2>(UInt32 index, OpenTK.Graphics.OpenGL.VertexAttribPointerParameterArb pname, [InAttribute, OutAttribute] T2[,] pointer)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetVertexAttribPointervARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribPointerParameterArb)pname, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribPointervARB")]
            public static 
            void GetVertexAttribPointer<T2>(UInt32 index, OpenTK.Graphics.OpenGL.VertexAttribPointerParameterArb pname, [InAttribute, OutAttribute] T2[,,] pointer)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetVertexAttribPointervARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribPointerParameterArb)pname, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glGetVertexAttribPointervARB")]
            public static 
            void GetVertexAttribPointer<T2>(UInt32 index, OpenTK.Graphics.OpenGL.VertexAttribPointerParameterArb pname, [InAttribute, OutAttribute] ref T2 pointer)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetVertexAttribPointervARB((UInt32)index, (OpenTK.Graphics.OpenGL.VertexAttribPointerParameterArb)pname, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                    pointer = (T2)pointer_ptr.Target;
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Determine if a name corresponds to a buffer object
        /// </summary>
        /// <param name="buffer">
        /// <para>
        /// Specifies a value that may be the name of a buffer object.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glIsBufferARB")]
            public static 
            bool IsBuffer(Int32 buffer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glIsBufferARB((UInt32)buffer);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Determine if a name corresponds to a buffer object
        /// </summary>
        /// <param name="buffer">
        /// <para>
        /// Specifies a value that may be the name of a buffer object.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glIsBufferARB")]
            public static 
            bool IsBuffer(UInt32 buffer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glIsBufferARB((UInt32)buffer);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Determines if a name corresponds to a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies a potential program object.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glIsProgramARB")]
            public static 
            bool IsProgram(Int32 program)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glIsProgramARB((UInt32)program);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Determines if a name corresponds to a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies a potential program object.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glIsProgramARB")]
            public static 
            bool IsProgram(UInt32 program)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glIsProgramARB((UInt32)program);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Determine if a name corresponds to a query object
        /// </summary>
        /// <param name="id">
        /// <para>
        /// Specifies a value that may be the name of a query object.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glIsQueryARB")]
            public static 
            bool IsQuery(Int32 id)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glIsQueryARB((UInt32)id);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Determine if a name corresponds to a query object
        /// </summary>
        /// <param name="id">
        /// <para>
        /// Specifies a value that may be the name of a query object.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbOcclusionQuery", Version = "1.5", EntryPoint = "glIsQueryARB")]
            public static 
            bool IsQuery(UInt32 id)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glIsQueryARB((UInt32)id);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Links a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the handle of the program object to be linked.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glLinkProgramARB")]
            public static 
            void LinkProgram(Int32 programObj)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glLinkProgramARB((UInt32)programObj);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Links a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the handle of the program object to be linked.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glLinkProgramARB")]
            public static 
            void LinkProgram(UInt32 programObj)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glLinkProgramARB((UInt32)programObj);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Replace the current matrix with the specified row-major ordered matrix
        /// </summary>
        /// <param name="m">
        /// <para>
        /// Specifies a pointer to 16 consecutive values, which are used as the elements of a 4 times 4 row-major matrix.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTransposeMatrix", Version = "1.2", EntryPoint = "glLoadTransposeMatrixdARB")]
            public static 
            void LoadTransposeMatrix(Double[] m)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* m_ptr = m)
                    {
                        Delegates.glLoadTransposeMatrixdARB((Double*)m_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Replace the current matrix with the specified row-major ordered matrix
        /// </summary>
        /// <param name="m">
        /// <para>
        /// Specifies a pointer to 16 consecutive values, which are used as the elements of a 4 times 4 row-major matrix.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTransposeMatrix", Version = "1.2", EntryPoint = "glLoadTransposeMatrixdARB")]
            public static 
            void LoadTransposeMatrix(ref Double m)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* m_ptr = &m)
                    {
                        Delegates.glLoadTransposeMatrixdARB((Double*)m_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Replace the current matrix with the specified row-major ordered matrix
        /// </summary>
        /// <param name="m">
        /// <para>
        /// Specifies a pointer to 16 consecutive values, which are used as the elements of a 4 times 4 row-major matrix.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbTransposeMatrix", Version = "1.2", EntryPoint = "glLoadTransposeMatrixdARB")]
            public static 
            unsafe void LoadTransposeMatrix(Double* m)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glLoadTransposeMatrixdARB((Double*)m);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Replace the current matrix with the specified row-major ordered matrix
        /// </summary>
        /// <param name="m">
        /// <para>
        /// Specifies a pointer to 16 consecutive values, which are used as the elements of a 4 times 4 row-major matrix.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTransposeMatrix", Version = "1.2", EntryPoint = "glLoadTransposeMatrixfARB")]
            public static 
            void LoadTransposeMatrix(Single[] m)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* m_ptr = m)
                    {
                        Delegates.glLoadTransposeMatrixfARB((Single*)m_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Replace the current matrix with the specified row-major ordered matrix
        /// </summary>
        /// <param name="m">
        /// <para>
        /// Specifies a pointer to 16 consecutive values, which are used as the elements of a 4 times 4 row-major matrix.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTransposeMatrix", Version = "1.2", EntryPoint = "glLoadTransposeMatrixfARB")]
            public static 
            void LoadTransposeMatrix(ref Single m)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* m_ptr = &m)
                    {
                        Delegates.glLoadTransposeMatrixfARB((Single*)m_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Replace the current matrix with the specified row-major ordered matrix
        /// </summary>
        /// <param name="m">
        /// <para>
        /// Specifies a pointer to 16 consecutive values, which are used as the elements of a 4 times 4 row-major matrix.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbTransposeMatrix", Version = "1.2", EntryPoint = "glLoadTransposeMatrixfARB")]
            public static 
            unsafe void LoadTransposeMatrix(Single* m)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glLoadTransposeMatrixfARB((Single*)m);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Map a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object being mapped. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="access">
        /// <para>
        /// Specifies the access policy, indicating whether it will be possible to read from, write to, or both read from and write to the buffer object's mapped data store. The symbolic constant must be GL_READ_ONLY, GL_WRITE_ONLY, or GL_READ_WRITE.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glMapBufferARB")]
            public static 
            unsafe System.IntPtr MapBuffer(OpenTK.Graphics.OpenGL.BufferTargetArb target, OpenTK.Graphics.OpenGL.ArbVertexBufferObject access)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glMapBufferARB((OpenTK.Graphics.OpenGL.BufferTargetArb)target, (OpenTK.Graphics.OpenGL.ArbVertexBufferObject)access);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbMatrixPalette", Version = "1.1", EntryPoint = "glMatrixIndexPointerARB")]
            public static 
            void MatrixIndexPointer(Int32 size, OpenTK.Graphics.OpenGL.ArbMatrixPalette type, Int32 stride, IntPtr pointer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMatrixIndexPointerARB((Int32)size, (OpenTK.Graphics.OpenGL.ArbMatrixPalette)type, (Int32)stride, (IntPtr)pointer);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbMatrixPalette", Version = "1.1", EntryPoint = "glMatrixIndexPointerARB")]
            public static 
            void MatrixIndexPointer<T3>(Int32 size, OpenTK.Graphics.OpenGL.ArbMatrixPalette type, Int32 stride, [InAttribute, OutAttribute] T3[] pointer)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glMatrixIndexPointerARB((Int32)size, (OpenTK.Graphics.OpenGL.ArbMatrixPalette)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbMatrixPalette", Version = "1.1", EntryPoint = "glMatrixIndexPointerARB")]
            public static 
            void MatrixIndexPointer<T3>(Int32 size, OpenTK.Graphics.OpenGL.ArbMatrixPalette type, Int32 stride, [InAttribute, OutAttribute] T3[,] pointer)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glMatrixIndexPointerARB((Int32)size, (OpenTK.Graphics.OpenGL.ArbMatrixPalette)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbMatrixPalette", Version = "1.1", EntryPoint = "glMatrixIndexPointerARB")]
            public static 
            void MatrixIndexPointer<T3>(Int32 size, OpenTK.Graphics.OpenGL.ArbMatrixPalette type, Int32 stride, [InAttribute, OutAttribute] T3[,,] pointer)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glMatrixIndexPointerARB((Int32)size, (OpenTK.Graphics.OpenGL.ArbMatrixPalette)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbMatrixPalette", Version = "1.1", EntryPoint = "glMatrixIndexPointerARB")]
            public static 
            void MatrixIndexPointer<T3>(Int32 size, OpenTK.Graphics.OpenGL.ArbMatrixPalette type, Int32 stride, [InAttribute, OutAttribute] ref T3 pointer)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glMatrixIndexPointerARB((Int32)size, (OpenTK.Graphics.OpenGL.ArbMatrixPalette)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                    pointer = (T3)pointer_ptr.Target;
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbMatrixPalette", Version = "1.1", EntryPoint = "glMatrixIndexubvARB")]
            public static 
            void MatrixIndex(Int32 size, Byte[] indices)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Byte* indices_ptr = indices)
                    {
                        Delegates.glMatrixIndexubvARB((Int32)size, (Byte*)indices_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbMatrixPalette", Version = "1.1", EntryPoint = "glMatrixIndexubvARB")]
            public static 
            void MatrixIndex(Int32 size, ref Byte indices)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Byte* indices_ptr = &indices)
                    {
                        Delegates.glMatrixIndexubvARB((Int32)size, (Byte*)indices_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbMatrixPalette", Version = "1.1", EntryPoint = "glMatrixIndexubvARB")]
            public static 
            unsafe void MatrixIndex(Int32 size, Byte* indices)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMatrixIndexubvARB((Int32)size, (Byte*)indices);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbMatrixPalette", Version = "1.1", EntryPoint = "glMatrixIndexuivARB")]
            public static 
            void MatrixIndex(Int32 size, Int32[] indices)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* indices_ptr = indices)
                    {
                        Delegates.glMatrixIndexuivARB((Int32)size, (UInt32*)indices_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbMatrixPalette", Version = "1.1", EntryPoint = "glMatrixIndexuivARB")]
            public static 
            void MatrixIndex(Int32 size, ref Int32 indices)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* indices_ptr = &indices)
                    {
                        Delegates.glMatrixIndexuivARB((Int32)size, (UInt32*)indices_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbMatrixPalette", Version = "1.1", EntryPoint = "glMatrixIndexuivARB")]
            public static 
            unsafe void MatrixIndex(Int32 size, Int32* indices)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMatrixIndexuivARB((Int32)size, (UInt32*)indices);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbMatrixPalette", Version = "1.1", EntryPoint = "glMatrixIndexuivARB")]
            public static 
            void MatrixIndex(Int32 size, UInt32[] indices)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* indices_ptr = indices)
                    {
                        Delegates.glMatrixIndexuivARB((Int32)size, (UInt32*)indices_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbMatrixPalette", Version = "1.1", EntryPoint = "glMatrixIndexuivARB")]
            public static 
            void MatrixIndex(Int32 size, ref UInt32 indices)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* indices_ptr = &indices)
                    {
                        Delegates.glMatrixIndexuivARB((Int32)size, (UInt32*)indices_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbMatrixPalette", Version = "1.1", EntryPoint = "glMatrixIndexuivARB")]
            public static 
            unsafe void MatrixIndex(Int32 size, UInt32* indices)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMatrixIndexuivARB((Int32)size, (UInt32*)indices);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbMatrixPalette", Version = "1.1", EntryPoint = "glMatrixIndexusvARB")]
            public static 
            void MatrixIndex(Int32 size, Int16[] indices)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* indices_ptr = indices)
                    {
                        Delegates.glMatrixIndexusvARB((Int32)size, (UInt16*)indices_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbMatrixPalette", Version = "1.1", EntryPoint = "glMatrixIndexusvARB")]
            public static 
            void MatrixIndex(Int32 size, ref Int16 indices)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* indices_ptr = &indices)
                    {
                        Delegates.glMatrixIndexusvARB((Int32)size, (UInt16*)indices_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbMatrixPalette", Version = "1.1", EntryPoint = "glMatrixIndexusvARB")]
            public static 
            unsafe void MatrixIndex(Int32 size, Int16* indices)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMatrixIndexusvARB((Int32)size, (UInt16*)indices);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbMatrixPalette", Version = "1.1", EntryPoint = "glMatrixIndexusvARB")]
            public static 
            void MatrixIndex(Int32 size, UInt16[] indices)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt16* indices_ptr = indices)
                    {
                        Delegates.glMatrixIndexusvARB((Int32)size, (UInt16*)indices_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbMatrixPalette", Version = "1.1", EntryPoint = "glMatrixIndexusvARB")]
            public static 
            void MatrixIndex(Int32 size, ref UInt16 indices)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt16* indices_ptr = &indices)
                    {
                        Delegates.glMatrixIndexusvARB((Int32)size, (UInt16*)indices_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbMatrixPalette", Version = "1.1", EntryPoint = "glMatrixIndexusvARB")]
            public static 
            unsafe void MatrixIndex(Int32 size, UInt16* indices)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMatrixIndexusvARB((Int32)size, (UInt16*)indices);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord1dARB")]
            public static 
            void MultiTexCoord1(OpenTK.Graphics.OpenGL.TextureUnit target, Double s)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord1dARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Double)s);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord1dvARB")]
            public static 
            unsafe void MultiTexCoord1(OpenTK.Graphics.OpenGL.TextureUnit target, Double* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord1dvARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Double*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord1fARB")]
            public static 
            void MultiTexCoord1(OpenTK.Graphics.OpenGL.TextureUnit target, Single s)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord1fARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Single)s);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord1fvARB")]
            public static 
            unsafe void MultiTexCoord1(OpenTK.Graphics.OpenGL.TextureUnit target, Single* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord1fvARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Single*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord1iARB")]
            public static 
            void MultiTexCoord1(OpenTK.Graphics.OpenGL.TextureUnit target, Int32 s)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord1iARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int32)s);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord1ivARB")]
            public static 
            unsafe void MultiTexCoord1(OpenTK.Graphics.OpenGL.TextureUnit target, Int32* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord1ivARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int32*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord1sARB")]
            public static 
            void MultiTexCoord1(OpenTK.Graphics.OpenGL.TextureUnit target, Int16 s)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord1sARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int16)s);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord1svARB")]
            public static 
            unsafe void MultiTexCoord1(OpenTK.Graphics.OpenGL.TextureUnit target, Int16* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord1svARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int16*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord2dARB")]
            public static 
            void MultiTexCoord2(OpenTK.Graphics.OpenGL.TextureUnit target, Double s, Double t)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord2dARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Double)s, (Double)t);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord2dvARB")]
            public static 
            void MultiTexCoord2(OpenTK.Graphics.OpenGL.TextureUnit target, Double[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* v_ptr = v)
                    {
                        Delegates.glMultiTexCoord2dvARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Double*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord2dvARB")]
            public static 
            void MultiTexCoord2(OpenTK.Graphics.OpenGL.TextureUnit target, ref Double v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* v_ptr = &v)
                    {
                        Delegates.glMultiTexCoord2dvARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Double*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord2dvARB")]
            public static 
            unsafe void MultiTexCoord2(OpenTK.Graphics.OpenGL.TextureUnit target, Double* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord2dvARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Double*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord2fARB")]
            public static 
            void MultiTexCoord2(OpenTK.Graphics.OpenGL.TextureUnit target, Single s, Single t)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord2fARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Single)s, (Single)t);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord2fvARB")]
            public static 
            void MultiTexCoord2(OpenTK.Graphics.OpenGL.TextureUnit target, Single[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* v_ptr = v)
                    {
                        Delegates.glMultiTexCoord2fvARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Single*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord2fvARB")]
            public static 
            void MultiTexCoord2(OpenTK.Graphics.OpenGL.TextureUnit target, ref Single v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* v_ptr = &v)
                    {
                        Delegates.glMultiTexCoord2fvARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Single*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord2fvARB")]
            public static 
            unsafe void MultiTexCoord2(OpenTK.Graphics.OpenGL.TextureUnit target, Single* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord2fvARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Single*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord2iARB")]
            public static 
            void MultiTexCoord2(OpenTK.Graphics.OpenGL.TextureUnit target, Int32 s, Int32 t)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord2iARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int32)s, (Int32)t);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord2ivARB")]
            public static 
            void MultiTexCoord2(OpenTK.Graphics.OpenGL.TextureUnit target, Int32[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* v_ptr = v)
                    {
                        Delegates.glMultiTexCoord2ivARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int32*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord2ivARB")]
            public static 
            void MultiTexCoord2(OpenTK.Graphics.OpenGL.TextureUnit target, ref Int32 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* v_ptr = &v)
                    {
                        Delegates.glMultiTexCoord2ivARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int32*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord2ivARB")]
            public static 
            unsafe void MultiTexCoord2(OpenTK.Graphics.OpenGL.TextureUnit target, Int32* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord2ivARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int32*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord2sARB")]
            public static 
            void MultiTexCoord2(OpenTK.Graphics.OpenGL.TextureUnit target, Int16 s, Int16 t)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord2sARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int16)s, (Int16)t);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord2svARB")]
            public static 
            void MultiTexCoord2(OpenTK.Graphics.OpenGL.TextureUnit target, Int16[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = v)
                    {
                        Delegates.glMultiTexCoord2svARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord2svARB")]
            public static 
            void MultiTexCoord2(OpenTK.Graphics.OpenGL.TextureUnit target, ref Int16 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = &v)
                    {
                        Delegates.glMultiTexCoord2svARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord2svARB")]
            public static 
            unsafe void MultiTexCoord2(OpenTK.Graphics.OpenGL.TextureUnit target, Int16* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord2svARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int16*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord3dARB")]
            public static 
            void MultiTexCoord3(OpenTK.Graphics.OpenGL.TextureUnit target, Double s, Double t, Double r)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord3dARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Double)s, (Double)t, (Double)r);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord3dvARB")]
            public static 
            void MultiTexCoord3(OpenTK.Graphics.OpenGL.TextureUnit target, Double[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* v_ptr = v)
                    {
                        Delegates.glMultiTexCoord3dvARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Double*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord3dvARB")]
            public static 
            void MultiTexCoord3(OpenTK.Graphics.OpenGL.TextureUnit target, ref Double v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* v_ptr = &v)
                    {
                        Delegates.glMultiTexCoord3dvARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Double*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord3dvARB")]
            public static 
            unsafe void MultiTexCoord3(OpenTK.Graphics.OpenGL.TextureUnit target, Double* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord3dvARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Double*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord3fARB")]
            public static 
            void MultiTexCoord3(OpenTK.Graphics.OpenGL.TextureUnit target, Single s, Single t, Single r)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord3fARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Single)s, (Single)t, (Single)r);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord3fvARB")]
            public static 
            void MultiTexCoord3(OpenTK.Graphics.OpenGL.TextureUnit target, Single[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* v_ptr = v)
                    {
                        Delegates.glMultiTexCoord3fvARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Single*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord3fvARB")]
            public static 
            void MultiTexCoord3(OpenTK.Graphics.OpenGL.TextureUnit target, ref Single v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* v_ptr = &v)
                    {
                        Delegates.glMultiTexCoord3fvARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Single*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord3fvARB")]
            public static 
            unsafe void MultiTexCoord3(OpenTK.Graphics.OpenGL.TextureUnit target, Single* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord3fvARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Single*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord3iARB")]
            public static 
            void MultiTexCoord3(OpenTK.Graphics.OpenGL.TextureUnit target, Int32 s, Int32 t, Int32 r)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord3iARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int32)s, (Int32)t, (Int32)r);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord3ivARB")]
            public static 
            void MultiTexCoord3(OpenTK.Graphics.OpenGL.TextureUnit target, Int32[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* v_ptr = v)
                    {
                        Delegates.glMultiTexCoord3ivARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int32*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord3ivARB")]
            public static 
            void MultiTexCoord3(OpenTK.Graphics.OpenGL.TextureUnit target, ref Int32 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* v_ptr = &v)
                    {
                        Delegates.glMultiTexCoord3ivARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int32*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord3ivARB")]
            public static 
            unsafe void MultiTexCoord3(OpenTK.Graphics.OpenGL.TextureUnit target, Int32* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord3ivARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int32*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord3sARB")]
            public static 
            void MultiTexCoord3(OpenTK.Graphics.OpenGL.TextureUnit target, Int16 s, Int16 t, Int16 r)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord3sARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int16)s, (Int16)t, (Int16)r);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord3svARB")]
            public static 
            void MultiTexCoord3(OpenTK.Graphics.OpenGL.TextureUnit target, Int16[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = v)
                    {
                        Delegates.glMultiTexCoord3svARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord3svARB")]
            public static 
            void MultiTexCoord3(OpenTK.Graphics.OpenGL.TextureUnit target, ref Int16 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = &v)
                    {
                        Delegates.glMultiTexCoord3svARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord3svARB")]
            public static 
            unsafe void MultiTexCoord3(OpenTK.Graphics.OpenGL.TextureUnit target, Int16* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord3svARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int16*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord4dARB")]
            public static 
            void MultiTexCoord4(OpenTK.Graphics.OpenGL.TextureUnit target, Double s, Double t, Double r, Double q)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord4dARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Double)s, (Double)t, (Double)r, (Double)q);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord4dvARB")]
            public static 
            void MultiTexCoord4(OpenTK.Graphics.OpenGL.TextureUnit target, Double[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* v_ptr = v)
                    {
                        Delegates.glMultiTexCoord4dvARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Double*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord4dvARB")]
            public static 
            void MultiTexCoord4(OpenTK.Graphics.OpenGL.TextureUnit target, ref Double v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* v_ptr = &v)
                    {
                        Delegates.glMultiTexCoord4dvARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Double*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord4dvARB")]
            public static 
            unsafe void MultiTexCoord4(OpenTK.Graphics.OpenGL.TextureUnit target, Double* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord4dvARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Double*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord4fARB")]
            public static 
            void MultiTexCoord4(OpenTK.Graphics.OpenGL.TextureUnit target, Single s, Single t, Single r, Single q)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord4fARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Single)s, (Single)t, (Single)r, (Single)q);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord4fvARB")]
            public static 
            void MultiTexCoord4(OpenTK.Graphics.OpenGL.TextureUnit target, Single[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* v_ptr = v)
                    {
                        Delegates.glMultiTexCoord4fvARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Single*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord4fvARB")]
            public static 
            void MultiTexCoord4(OpenTK.Graphics.OpenGL.TextureUnit target, ref Single v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* v_ptr = &v)
                    {
                        Delegates.glMultiTexCoord4fvARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Single*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord4fvARB")]
            public static 
            unsafe void MultiTexCoord4(OpenTK.Graphics.OpenGL.TextureUnit target, Single* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord4fvARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Single*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord4iARB")]
            public static 
            void MultiTexCoord4(OpenTK.Graphics.OpenGL.TextureUnit target, Int32 s, Int32 t, Int32 r, Int32 q)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord4iARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int32)s, (Int32)t, (Int32)r, (Int32)q);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord4ivARB")]
            public static 
            void MultiTexCoord4(OpenTK.Graphics.OpenGL.TextureUnit target, Int32[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* v_ptr = v)
                    {
                        Delegates.glMultiTexCoord4ivARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int32*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord4ivARB")]
            public static 
            void MultiTexCoord4(OpenTK.Graphics.OpenGL.TextureUnit target, ref Int32 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* v_ptr = &v)
                    {
                        Delegates.glMultiTexCoord4ivARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int32*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord4ivARB")]
            public static 
            unsafe void MultiTexCoord4(OpenTK.Graphics.OpenGL.TextureUnit target, Int32* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord4ivARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int32*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord4sARB")]
            public static 
            void MultiTexCoord4(OpenTK.Graphics.OpenGL.TextureUnit target, Int16 s, Int16 t, Int16 r, Int16 q)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord4sARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int16)s, (Int16)t, (Int16)r, (Int16)q);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord4svARB")]
            public static 
            void MultiTexCoord4(OpenTK.Graphics.OpenGL.TextureUnit target, Int16[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = v)
                    {
                        Delegates.glMultiTexCoord4svARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord4svARB")]
            public static 
            void MultiTexCoord4(OpenTK.Graphics.OpenGL.TextureUnit target, ref Int16 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = &v)
                    {
                        Delegates.glMultiTexCoord4svARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbMultitexture", Version = "1.2", EntryPoint = "glMultiTexCoord4svARB")]
            public static 
            unsafe void MultiTexCoord4(OpenTK.Graphics.OpenGL.TextureUnit target, Int16* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord4svARB((OpenTK.Graphics.OpenGL.TextureUnit)target, (Int16*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Multiply the current matrix with the specified row-major ordered matrix
        /// </summary>
        /// <param name="m">
        /// <para>
        /// Points to 16 consecutive values that are used as the elements of a 4 times 4 row-major matrix.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTransposeMatrix", Version = "1.2", EntryPoint = "glMultTransposeMatrixdARB")]
            public static 
            void MultTransposeMatrix(Double[] m)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* m_ptr = m)
                    {
                        Delegates.glMultTransposeMatrixdARB((Double*)m_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Multiply the current matrix with the specified row-major ordered matrix
        /// </summary>
        /// <param name="m">
        /// <para>
        /// Points to 16 consecutive values that are used as the elements of a 4 times 4 row-major matrix.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTransposeMatrix", Version = "1.2", EntryPoint = "glMultTransposeMatrixdARB")]
            public static 
            void MultTransposeMatrix(ref Double m)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* m_ptr = &m)
                    {
                        Delegates.glMultTransposeMatrixdARB((Double*)m_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Multiply the current matrix with the specified row-major ordered matrix
        /// </summary>
        /// <param name="m">
        /// <para>
        /// Points to 16 consecutive values that are used as the elements of a 4 times 4 row-major matrix.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbTransposeMatrix", Version = "1.2", EntryPoint = "glMultTransposeMatrixdARB")]
            public static 
            unsafe void MultTransposeMatrix(Double* m)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultTransposeMatrixdARB((Double*)m);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Multiply the current matrix with the specified row-major ordered matrix
        /// </summary>
        /// <param name="m">
        /// <para>
        /// Points to 16 consecutive values that are used as the elements of a 4 times 4 row-major matrix.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTransposeMatrix", Version = "1.2", EntryPoint = "glMultTransposeMatrixfARB")]
            public static 
            void MultTransposeMatrix(Single[] m)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* m_ptr = m)
                    {
                        Delegates.glMultTransposeMatrixfARB((Single*)m_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Multiply the current matrix with the specified row-major ordered matrix
        /// </summary>
        /// <param name="m">
        /// <para>
        /// Points to 16 consecutive values that are used as the elements of a 4 times 4 row-major matrix.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbTransposeMatrix", Version = "1.2", EntryPoint = "glMultTransposeMatrixfARB")]
            public static 
            void MultTransposeMatrix(ref Single m)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* m_ptr = &m)
                    {
                        Delegates.glMultTransposeMatrixfARB((Single*)m_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Multiply the current matrix with the specified row-major ordered matrix
        /// </summary>
        /// <param name="m">
        /// <para>
        /// Points to 16 consecutive values that are used as the elements of a 4 times 4 row-major matrix.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbTransposeMatrix", Version = "1.2", EntryPoint = "glMultTransposeMatrixfARB")]
            public static 
            unsafe void MultTransposeMatrix(Single* m)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultTransposeMatrixfARB((Single*)m);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify point parameters
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued point parameter. GL_POINT_SIZE_MIN, GL_POINT_SIZE_MAX, GL_POINT_FADE_THRESHOLD_SIZE, and GL_POINT_SPRITE_COORD_ORIGIN are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that pname will be set to.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbPointParameters", Version = "1.0", EntryPoint = "glPointParameterfARB")]
            public static 
            void PointParameter(OpenTK.Graphics.OpenGL.ArbPointParameters pname, Single param)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glPointParameterfARB((OpenTK.Graphics.OpenGL.ArbPointParameters)pname, (Single)param);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify point parameters
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued point parameter. GL_POINT_SIZE_MIN, GL_POINT_SIZE_MAX, GL_POINT_FADE_THRESHOLD_SIZE, and GL_POINT_SPRITE_COORD_ORIGIN are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that pname will be set to.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbPointParameters", Version = "1.0", EntryPoint = "glPointParameterfvARB")]
            public static 
            void PointParameter(OpenTK.Graphics.OpenGL.ArbPointParameters pname, Single[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = @params)
                    {
                        Delegates.glPointParameterfvARB((OpenTK.Graphics.OpenGL.ArbPointParameters)pname, (Single*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify point parameters
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued point parameter. GL_POINT_SIZE_MIN, GL_POINT_SIZE_MAX, GL_POINT_FADE_THRESHOLD_SIZE, and GL_POINT_SPRITE_COORD_ORIGIN are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that pname will be set to.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbPointParameters", Version = "1.0", EntryPoint = "glPointParameterfvARB")]
            public static 
            unsafe void PointParameter(OpenTK.Graphics.OpenGL.ArbPointParameters pname, Single* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glPointParameterfvARB((OpenTK.Graphics.OpenGL.ArbPointParameters)pname, (Single*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramEnvParameter4dARB")]
            public static 
            void ProgramEnvParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, Int32 index, Double x, Double y, Double z, Double w)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glProgramEnvParameter4dARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Double)x, (Double)y, (Double)z, (Double)w);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramEnvParameter4dARB")]
            public static 
            void ProgramEnvParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, UInt32 index, Double x, Double y, Double z, Double w)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glProgramEnvParameter4dARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Double)x, (Double)y, (Double)z, (Double)w);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramEnvParameter4dvARB")]
            public static 
            void ProgramEnvParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, Int32 index, Double[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* @params_ptr = @params)
                    {
                        Delegates.glProgramEnvParameter4dvARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Double*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramEnvParameter4dvARB")]
            public static 
            void ProgramEnvParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, Int32 index, ref Double @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* @params_ptr = &@params)
                    {
                        Delegates.glProgramEnvParameter4dvARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Double*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramEnvParameter4dvARB")]
            public static 
            unsafe void ProgramEnvParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, Int32 index, Double* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glProgramEnvParameter4dvARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Double*)@params);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramEnvParameter4dvARB")]
            public static 
            void ProgramEnvParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, UInt32 index, Double[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* @params_ptr = @params)
                    {
                        Delegates.glProgramEnvParameter4dvARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Double*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramEnvParameter4dvARB")]
            public static 
            void ProgramEnvParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, UInt32 index, ref Double @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* @params_ptr = &@params)
                    {
                        Delegates.glProgramEnvParameter4dvARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Double*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramEnvParameter4dvARB")]
            public static 
            unsafe void ProgramEnvParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, UInt32 index, Double* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glProgramEnvParameter4dvARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Double*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramEnvParameter4fARB")]
            public static 
            void ProgramEnvParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, Int32 index, Single x, Single y, Single z, Single w)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glProgramEnvParameter4fARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Single)x, (Single)y, (Single)z, (Single)w);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramEnvParameter4fARB")]
            public static 
            void ProgramEnvParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, UInt32 index, Single x, Single y, Single z, Single w)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glProgramEnvParameter4fARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Single)x, (Single)y, (Single)z, (Single)w);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramEnvParameter4fvARB")]
            public static 
            void ProgramEnvParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, Int32 index, Single[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = @params)
                    {
                        Delegates.glProgramEnvParameter4fvARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Single*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramEnvParameter4fvARB")]
            public static 
            void ProgramEnvParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, Int32 index, ref Single @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = &@params)
                    {
                        Delegates.glProgramEnvParameter4fvARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Single*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramEnvParameter4fvARB")]
            public static 
            unsafe void ProgramEnvParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, Int32 index, Single* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glProgramEnvParameter4fvARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Single*)@params);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramEnvParameter4fvARB")]
            public static 
            void ProgramEnvParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, UInt32 index, Single[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = @params)
                    {
                        Delegates.glProgramEnvParameter4fvARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Single*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramEnvParameter4fvARB")]
            public static 
            void ProgramEnvParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, UInt32 index, ref Single @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = &@params)
                    {
                        Delegates.glProgramEnvParameter4fvARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Single*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramEnvParameter4fvARB")]
            public static 
            unsafe void ProgramEnvParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, UInt32 index, Single* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glProgramEnvParameter4fvARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Single*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramLocalParameter4dARB")]
            public static 
            void ProgramLocalParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, Int32 index, Double x, Double y, Double z, Double w)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glProgramLocalParameter4dARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Double)x, (Double)y, (Double)z, (Double)w);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramLocalParameter4dARB")]
            public static 
            void ProgramLocalParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, UInt32 index, Double x, Double y, Double z, Double w)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glProgramLocalParameter4dARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Double)x, (Double)y, (Double)z, (Double)w);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramLocalParameter4dvARB")]
            public static 
            void ProgramLocalParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, Int32 index, Double[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* @params_ptr = @params)
                    {
                        Delegates.glProgramLocalParameter4dvARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Double*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramLocalParameter4dvARB")]
            public static 
            void ProgramLocalParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, Int32 index, ref Double @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* @params_ptr = &@params)
                    {
                        Delegates.glProgramLocalParameter4dvARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Double*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramLocalParameter4dvARB")]
            public static 
            unsafe void ProgramLocalParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, Int32 index, Double* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glProgramLocalParameter4dvARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Double*)@params);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramLocalParameter4dvARB")]
            public static 
            void ProgramLocalParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, UInt32 index, Double[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* @params_ptr = @params)
                    {
                        Delegates.glProgramLocalParameter4dvARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Double*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramLocalParameter4dvARB")]
            public static 
            void ProgramLocalParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, UInt32 index, ref Double @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* @params_ptr = &@params)
                    {
                        Delegates.glProgramLocalParameter4dvARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Double*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramLocalParameter4dvARB")]
            public static 
            unsafe void ProgramLocalParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, UInt32 index, Double* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glProgramLocalParameter4dvARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Double*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramLocalParameter4fARB")]
            public static 
            void ProgramLocalParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, Int32 index, Single x, Single y, Single z, Single w)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glProgramLocalParameter4fARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Single)x, (Single)y, (Single)z, (Single)w);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramLocalParameter4fARB")]
            public static 
            void ProgramLocalParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, UInt32 index, Single x, Single y, Single z, Single w)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glProgramLocalParameter4fARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Single)x, (Single)y, (Single)z, (Single)w);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramLocalParameter4fvARB")]
            public static 
            void ProgramLocalParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, Int32 index, Single[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = @params)
                    {
                        Delegates.glProgramLocalParameter4fvARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Single*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramLocalParameter4fvARB")]
            public static 
            void ProgramLocalParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, Int32 index, ref Single @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = &@params)
                    {
                        Delegates.glProgramLocalParameter4fvARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Single*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramLocalParameter4fvARB")]
            public static 
            unsafe void ProgramLocalParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, Int32 index, Single* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glProgramLocalParameter4fvARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Single*)@params);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramLocalParameter4fvARB")]
            public static 
            void ProgramLocalParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, UInt32 index, Single[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = @params)
                    {
                        Delegates.glProgramLocalParameter4fvARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Single*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramLocalParameter4fvARB")]
            public static 
            void ProgramLocalParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, UInt32 index, ref Single @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = &@params)
                    {
                        Delegates.glProgramLocalParameter4fvARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Single*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramLocalParameter4fvARB")]
            public static 
            unsafe void ProgramLocalParameter4(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, UInt32 index, Single* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glProgramLocalParameter4fvARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (UInt32)index, (Single*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbGeometryShader4", Version = "3.0", EntryPoint = "glProgramParameteriARB")]
            public static 
            void ProgramParameter(Int32 program, OpenTK.Graphics.OpenGL.ArbGeometryShader4 pname, Int32 value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glProgramParameteriARB((UInt32)program, (OpenTK.Graphics.OpenGL.ArbGeometryShader4)pname, (Int32)value);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbGeometryShader4", Version = "3.0", EntryPoint = "glProgramParameteriARB")]
            public static 
            void ProgramParameter(UInt32 program, OpenTK.Graphics.OpenGL.ArbGeometryShader4 pname, Int32 value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glProgramParameteriARB((UInt32)program, (OpenTK.Graphics.OpenGL.ArbGeometryShader4)pname, (Int32)value);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramStringARB")]
            public static 
            void ProgramString(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, OpenTK.Graphics.OpenGL.ArbVertexProgram format, Int32 len, IntPtr @string)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glProgramStringARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (OpenTK.Graphics.OpenGL.ArbVertexProgram)format, (Int32)len, (IntPtr)@string);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramStringARB")]
            public static 
            void ProgramString<T3>(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, OpenTK.Graphics.OpenGL.ArbVertexProgram format, Int32 len, [InAttribute, OutAttribute] T3[] @string)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle @string_ptr = GCHandle.Alloc(@string, GCHandleType.Pinned);
                try
                {
                    Delegates.glProgramStringARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (OpenTK.Graphics.OpenGL.ArbVertexProgram)format, (Int32)len, (IntPtr)@string_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    @string_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramStringARB")]
            public static 
            void ProgramString<T3>(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, OpenTK.Graphics.OpenGL.ArbVertexProgram format, Int32 len, [InAttribute, OutAttribute] T3[,] @string)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle @string_ptr = GCHandle.Alloc(@string, GCHandleType.Pinned);
                try
                {
                    Delegates.glProgramStringARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (OpenTK.Graphics.OpenGL.ArbVertexProgram)format, (Int32)len, (IntPtr)@string_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    @string_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramStringARB")]
            public static 
            void ProgramString<T3>(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, OpenTK.Graphics.OpenGL.ArbVertexProgram format, Int32 len, [InAttribute, OutAttribute] T3[,,] @string)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle @string_ptr = GCHandle.Alloc(@string, GCHandleType.Pinned);
                try
                {
                    Delegates.glProgramStringARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (OpenTK.Graphics.OpenGL.ArbVertexProgram)format, (Int32)len, (IntPtr)@string_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    @string_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glProgramStringARB")]
            public static 
            void ProgramString<T3>(OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb target, OpenTK.Graphics.OpenGL.ArbVertexProgram format, Int32 len, [InAttribute, OutAttribute] ref T3 @string)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle @string_ptr = GCHandle.Alloc(@string, GCHandleType.Pinned);
                try
                {
                    Delegates.glProgramStringARB((OpenTK.Graphics.OpenGL.AssemblyProgramTargetArb)target, (OpenTK.Graphics.OpenGL.ArbVertexProgram)format, (Int32)len, (IntPtr)@string_ptr.AddrOfPinnedObject());
                    @string = (T3)@string_ptr.Target;
                }
                finally
                {
                    @string_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify multisample coverage parameters
        /// </summary>
        /// <param name="value">
        /// <para>
        /// Specify a single floating-point sample coverage value. The value is clamped to the range [0 ,1]. The initial value is 1.0.
        /// </para>
        /// </param>
        /// <param name="invert">
        /// <para>
        /// Specify a single boolean value representing if the coverage masks should be inverted. GL_TRUE and GL_FALSE are accepted. The initial value is GL_FALSE.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbMultisample", Version = "1.2", EntryPoint = "glSampleCoverageARB")]
            public static 
            void SampleCoverage(Single value, bool invert)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glSampleCoverageARB((Single)value, (bool)invert);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Replaces the source code in a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the handle of the shader object whose source code is to be replaced.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements in the string and length arrays.
        /// </para>
        /// </param>
        /// <param name="string">
        /// <para>
        /// Specifies an array of pointers to strings containing the source code to be loaded into the shader.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Specifies an array of string lengths.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glShaderSourceARB")]
            public static 
            void ShaderSource(Int32 shaderObj, Int32 count, String[] @string, ref Int32 length)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    {
                        Delegates.glShaderSourceARB((UInt32)shaderObj, (Int32)count, (String[])@string, (Int32*)length_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Replaces the source code in a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the handle of the shader object whose source code is to be replaced.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements in the string and length arrays.
        /// </para>
        /// </param>
        /// <param name="string">
        /// <para>
        /// Specifies an array of pointers to strings containing the source code to be loaded into the shader.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Specifies an array of string lengths.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glShaderSourceARB")]
            public static 
            unsafe void ShaderSource(Int32 shaderObj, Int32 count, String[] @string, Int32* length)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glShaderSourceARB((UInt32)shaderObj, (Int32)count, (String[])@string, (Int32*)length);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Replaces the source code in a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the handle of the shader object whose source code is to be replaced.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements in the string and length arrays.
        /// </para>
        /// </param>
        /// <param name="string">
        /// <para>
        /// Specifies an array of pointers to strings containing the source code to be loaded into the shader.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Specifies an array of string lengths.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glShaderSourceARB")]
            public static 
            void ShaderSource(UInt32 shaderObj, Int32 count, String[] @string, ref Int32 length)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* length_ptr = &length)
                    {
                        Delegates.glShaderSourceARB((UInt32)shaderObj, (Int32)count, (String[])@string, (Int32*)length_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Replaces the source code in a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the handle of the shader object whose source code is to be replaced.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements in the string and length arrays.
        /// </para>
        /// </param>
        /// <param name="string">
        /// <para>
        /// Specifies an array of pointers to strings containing the source code to be loaded into the shader.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Specifies an array of string lengths.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glShaderSourceARB")]
            public static 
            unsafe void ShaderSource(UInt32 shaderObj, Int32 count, String[] @string, Int32* length)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glShaderSourceARB((UInt32)shaderObj, (Int32)count, (String[])@string, (Int32*)length);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbTextureBufferObject", Version = "3.0", EntryPoint = "glTexBufferARB")]
            public static 
            void TexBuffer(OpenTK.Graphics.OpenGL.TextureTarget target, OpenTK.Graphics.OpenGL.ArbTextureBufferObject internalformat, Int32 buffer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glTexBufferARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (OpenTK.Graphics.OpenGL.ArbTextureBufferObject)internalformat, (UInt32)buffer);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbTextureBufferObject", Version = "3.0", EntryPoint = "glTexBufferARB")]
            public static 
            void TexBuffer(OpenTK.Graphics.OpenGL.TextureTarget target, OpenTK.Graphics.OpenGL.ArbTextureBufferObject internalformat, UInt32 buffer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glTexBufferARB((OpenTK.Graphics.OpenGL.TextureTarget)target, (OpenTK.Graphics.OpenGL.ArbTextureBufferObject)internalformat, (UInt32)buffer);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform1fARB")]
            public static 
            void Uniform1(Int32 location, Single v0)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glUniform1fARB((Int32)location, (Single)v0);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform1fvARB")]
            public static 
            void Uniform1(Int32 location, Int32 count, Single[] value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* value_ptr = value)
                    {
                        Delegates.glUniform1fvARB((Int32)location, (Int32)count, (Single*)value_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform1fvARB")]
            public static 
            void Uniform1(Int32 location, Int32 count, ref Single value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* value_ptr = &value)
                    {
                        Delegates.glUniform1fvARB((Int32)location, (Int32)count, (Single*)value_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform1fvARB")]
            public static 
            unsafe void Uniform1(Int32 location, Int32 count, Single* value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glUniform1fvARB((Int32)location, (Int32)count, (Single*)value);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform1iARB")]
            public static 
            void Uniform1(Int32 location, Int32 v0)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glUniform1iARB((Int32)location, (Int32)v0);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform1ivARB")]
            public static 
            void Uniform1(Int32 location, Int32 count, Int32[] value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* value_ptr = value)
                    {
                        Delegates.glUniform1ivARB((Int32)location, (Int32)count, (Int32*)value_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform1ivARB")]
            public static 
            void Uniform1(Int32 location, Int32 count, ref Int32 value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* value_ptr = &value)
                    {
                        Delegates.glUniform1ivARB((Int32)location, (Int32)count, (Int32*)value_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform1ivARB")]
            public static 
            unsafe void Uniform1(Int32 location, Int32 count, Int32* value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glUniform1ivARB((Int32)location, (Int32)count, (Int32*)value);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform2fARB")]
            public static 
            void Uniform2(Int32 location, Single v0, Single v1)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glUniform2fARB((Int32)location, (Single)v0, (Single)v1);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform2fvARB")]
            public static 
            void Uniform2(Int32 location, Int32 count, Single[] value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* value_ptr = value)
                    {
                        Delegates.glUniform2fvARB((Int32)location, (Int32)count, (Single*)value_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform2fvARB")]
            public static 
            void Uniform2(Int32 location, Int32 count, ref Single value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* value_ptr = &value)
                    {
                        Delegates.glUniform2fvARB((Int32)location, (Int32)count, (Single*)value_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform2fvARB")]
            public static 
            unsafe void Uniform2(Int32 location, Int32 count, Single* value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glUniform2fvARB((Int32)location, (Int32)count, (Single*)value);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform2iARB")]
            public static 
            void Uniform2(Int32 location, Int32 v0, Int32 v1)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glUniform2iARB((Int32)location, (Int32)v0, (Int32)v1);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform2ivARB")]
            public static 
            void Uniform2(Int32 location, Int32 count, Int32[] value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* value_ptr = value)
                    {
                        Delegates.glUniform2ivARB((Int32)location, (Int32)count, (Int32*)value_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform2ivARB")]
            public static 
            unsafe void Uniform2(Int32 location, Int32 count, Int32* value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glUniform2ivARB((Int32)location, (Int32)count, (Int32*)value);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform3fARB")]
            public static 
            void Uniform3(Int32 location, Single v0, Single v1, Single v2)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glUniform3fARB((Int32)location, (Single)v0, (Single)v1, (Single)v2);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform3fvARB")]
            public static 
            void Uniform3(Int32 location, Int32 count, Single[] value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* value_ptr = value)
                    {
                        Delegates.glUniform3fvARB((Int32)location, (Int32)count, (Single*)value_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform3fvARB")]
            public static 
            void Uniform3(Int32 location, Int32 count, ref Single value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* value_ptr = &value)
                    {
                        Delegates.glUniform3fvARB((Int32)location, (Int32)count, (Single*)value_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform3fvARB")]
            public static 
            unsafe void Uniform3(Int32 location, Int32 count, Single* value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glUniform3fvARB((Int32)location, (Int32)count, (Single*)value);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform3iARB")]
            public static 
            void Uniform3(Int32 location, Int32 v0, Int32 v1, Int32 v2)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glUniform3iARB((Int32)location, (Int32)v0, (Int32)v1, (Int32)v2);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform3ivARB")]
            public static 
            void Uniform3(Int32 location, Int32 count, Int32[] value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* value_ptr = value)
                    {
                        Delegates.glUniform3ivARB((Int32)location, (Int32)count, (Int32*)value_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform3ivARB")]
            public static 
            void Uniform3(Int32 location, Int32 count, ref Int32 value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* value_ptr = &value)
                    {
                        Delegates.glUniform3ivARB((Int32)location, (Int32)count, (Int32*)value_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform3ivARB")]
            public static 
            unsafe void Uniform3(Int32 location, Int32 count, Int32* value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glUniform3ivARB((Int32)location, (Int32)count, (Int32*)value);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform4fARB")]
            public static 
            void Uniform4(Int32 location, Single v0, Single v1, Single v2, Single v3)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glUniform4fARB((Int32)location, (Single)v0, (Single)v1, (Single)v2, (Single)v3);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform4fvARB")]
            public static 
            void Uniform4(Int32 location, Int32 count, Single[] value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* value_ptr = value)
                    {
                        Delegates.glUniform4fvARB((Int32)location, (Int32)count, (Single*)value_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform4fvARB")]
            public static 
            void Uniform4(Int32 location, Int32 count, ref Single value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* value_ptr = &value)
                    {
                        Delegates.glUniform4fvARB((Int32)location, (Int32)count, (Single*)value_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform4fvARB")]
            public static 
            unsafe void Uniform4(Int32 location, Int32 count, Single* value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glUniform4fvARB((Int32)location, (Int32)count, (Single*)value);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform4iARB")]
            public static 
            void Uniform4(Int32 location, Int32 v0, Int32 v1, Int32 v2, Int32 v3)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glUniform4iARB((Int32)location, (Int32)v0, (Int32)v1, (Int32)v2, (Int32)v3);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform4ivARB")]
            public static 
            void Uniform4(Int32 location, Int32 count, Int32[] value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* value_ptr = value)
                    {
                        Delegates.glUniform4ivARB((Int32)location, (Int32)count, (Int32*)value_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform4ivARB")]
            public static 
            void Uniform4(Int32 location, Int32 count, ref Int32 value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* value_ptr = &value)
                    {
                        Delegates.glUniform4ivARB((Int32)location, (Int32)count, (Int32*)value_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the value of a uniform variable for the current program object
        /// </summary>
        /// <param name="location">
        /// <para>
        /// Specifies the location of the uniform variable to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified uniform variable.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniform4ivARB")]
            public static 
            unsafe void Uniform4(Int32 location, Int32 count, Int32* value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glUniform4ivARB((Int32)location, (Int32)count, (Int32*)value);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniformMatrix2fvARB")]
            public static 
            void UniformMatrix2(Int32 location, Int32 count, bool transpose, Single[] value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* value_ptr = value)
                    {
                        Delegates.glUniformMatrix2fvARB((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniformMatrix2fvARB")]
            public static 
            void UniformMatrix2(Int32 location, Int32 count, bool transpose, ref Single value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* value_ptr = &value)
                    {
                        Delegates.glUniformMatrix2fvARB((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniformMatrix2fvARB")]
            public static 
            unsafe void UniformMatrix2(Int32 location, Int32 count, bool transpose, Single* value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glUniformMatrix2fvARB((Int32)location, (Int32)count, (bool)transpose, (Single*)value);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniformMatrix3fvARB")]
            public static 
            void UniformMatrix3(Int32 location, Int32 count, bool transpose, Single[] value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* value_ptr = value)
                    {
                        Delegates.glUniformMatrix3fvARB((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniformMatrix3fvARB")]
            public static 
            void UniformMatrix3(Int32 location, Int32 count, bool transpose, ref Single value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* value_ptr = &value)
                    {
                        Delegates.glUniformMatrix3fvARB((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniformMatrix3fvARB")]
            public static 
            unsafe void UniformMatrix3(Int32 location, Int32 count, bool transpose, Single* value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glUniformMatrix3fvARB((Int32)location, (Int32)count, (bool)transpose, (Single*)value);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniformMatrix4fvARB")]
            public static 
            void UniformMatrix4(Int32 location, Int32 count, bool transpose, Single[] value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* value_ptr = value)
                    {
                        Delegates.glUniformMatrix4fvARB((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniformMatrix4fvARB")]
            public static 
            void UniformMatrix4(Int32 location, Int32 count, bool transpose, ref Single value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* value_ptr = &value)
                    {
                        Delegates.glUniformMatrix4fvARB((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUniformMatrix4fvARB")]
            public static 
            unsafe void UniformMatrix4(Int32 location, Int32 count, bool transpose, Single* value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glUniformMatrix4fvARB((Int32)location, (Int32)count, (bool)transpose, (Single*)value);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexBufferObject", Version = "1.2", EntryPoint = "glUnmapBufferARB")]
            public static 
            bool UnmapBuffer(OpenTK.Graphics.OpenGL.BufferTargetArb target)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glUnmapBufferARB((OpenTK.Graphics.OpenGL.BufferTargetArb)target);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUseProgramObjectARB")]
            public static 
            void UseProgramObject(Int32 programObj)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glUseProgramObjectARB((UInt32)programObj);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glUseProgramObjectARB")]
            public static 
            void UseProgramObject(UInt32 programObj)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glUseProgramObjectARB((UInt32)programObj);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Validates a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the handle of the program object to be validated.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glValidateProgramARB")]
            public static 
            void ValidateProgram(Int32 programObj)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glValidateProgramARB((UInt32)programObj);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Validates a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the handle of the program object to be validated.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glValidateProgramARB")]
            public static 
            void ValidateProgram(UInt32 programObj)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glValidateProgramARB((UInt32)programObj);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib1dARB")]
            public static 
            void VertexAttrib1(Int32 index, Double x)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib1dARB((UInt32)index, (Double)x);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib1dARB")]
            public static 
            void VertexAttrib1(UInt32 index, Double x)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib1dARB((UInt32)index, (Double)x);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib1dvARB")]
            public static 
            unsafe void VertexAttrib1(Int32 index, Double* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib1dvARB((UInt32)index, (Double*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib1dvARB")]
            public static 
            unsafe void VertexAttrib1(UInt32 index, Double* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib1dvARB((UInt32)index, (Double*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib1fARB")]
            public static 
            void VertexAttrib1(Int32 index, Single x)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib1fARB((UInt32)index, (Single)x);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib1fARB")]
            public static 
            void VertexAttrib1(UInt32 index, Single x)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib1fARB((UInt32)index, (Single)x);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib1fvARB")]
            public static 
            unsafe void VertexAttrib1(Int32 index, Single* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib1fvARB((UInt32)index, (Single*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib1fvARB")]
            public static 
            unsafe void VertexAttrib1(UInt32 index, Single* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib1fvARB((UInt32)index, (Single*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib1sARB")]
            public static 
            void VertexAttrib1(Int32 index, Int16 x)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib1sARB((UInt32)index, (Int16)x);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib1sARB")]
            public static 
            void VertexAttrib1(UInt32 index, Int16 x)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib1sARB((UInt32)index, (Int16)x);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib1svARB")]
            public static 
            unsafe void VertexAttrib1(Int32 index, Int16* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib1svARB((UInt32)index, (Int16*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib1svARB")]
            public static 
            unsafe void VertexAttrib1(UInt32 index, Int16* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib1svARB((UInt32)index, (Int16*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib2dARB")]
            public static 
            void VertexAttrib2(Int32 index, Double x, Double y)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib2dARB((UInt32)index, (Double)x, (Double)y);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib2dARB")]
            public static 
            void VertexAttrib2(UInt32 index, Double x, Double y)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib2dARB((UInt32)index, (Double)x, (Double)y);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib2dvARB")]
            public static 
            void VertexAttrib2(Int32 index, Double[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* v_ptr = v)
                    {
                        Delegates.glVertexAttrib2dvARB((UInt32)index, (Double*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib2dvARB")]
            public static 
            void VertexAttrib2(Int32 index, ref Double v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib2dvARB((UInt32)index, (Double*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib2dvARB")]
            public static 
            unsafe void VertexAttrib2(Int32 index, Double* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib2dvARB((UInt32)index, (Double*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib2dvARB")]
            public static 
            void VertexAttrib2(UInt32 index, Double[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* v_ptr = v)
                    {
                        Delegates.glVertexAttrib2dvARB((UInt32)index, (Double*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib2dvARB")]
            public static 
            void VertexAttrib2(UInt32 index, ref Double v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib2dvARB((UInt32)index, (Double*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib2dvARB")]
            public static 
            unsafe void VertexAttrib2(UInt32 index, Double* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib2dvARB((UInt32)index, (Double*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib2fARB")]
            public static 
            void VertexAttrib2(Int32 index, Single x, Single y)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib2fARB((UInt32)index, (Single)x, (Single)y);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib2fARB")]
            public static 
            void VertexAttrib2(UInt32 index, Single x, Single y)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib2fARB((UInt32)index, (Single)x, (Single)y);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib2fvARB")]
            public static 
            void VertexAttrib2(Int32 index, Single[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* v_ptr = v)
                    {
                        Delegates.glVertexAttrib2fvARB((UInt32)index, (Single*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib2fvARB")]
            public static 
            void VertexAttrib2(Int32 index, ref Single v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib2fvARB((UInt32)index, (Single*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib2fvARB")]
            public static 
            unsafe void VertexAttrib2(Int32 index, Single* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib2fvARB((UInt32)index, (Single*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib2fvARB")]
            public static 
            void VertexAttrib2(UInt32 index, Single[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* v_ptr = v)
                    {
                        Delegates.glVertexAttrib2fvARB((UInt32)index, (Single*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib2fvARB")]
            public static 
            void VertexAttrib2(UInt32 index, ref Single v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib2fvARB((UInt32)index, (Single*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib2fvARB")]
            public static 
            unsafe void VertexAttrib2(UInt32 index, Single* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib2fvARB((UInt32)index, (Single*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib2sARB")]
            public static 
            void VertexAttrib2(Int32 index, Int16 x, Int16 y)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib2sARB((UInt32)index, (Int16)x, (Int16)y);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib2sARB")]
            public static 
            void VertexAttrib2(UInt32 index, Int16 x, Int16 y)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib2sARB((UInt32)index, (Int16)x, (Int16)y);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib2svARB")]
            public static 
            void VertexAttrib2(Int32 index, Int16[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = v)
                    {
                        Delegates.glVertexAttrib2svARB((UInt32)index, (Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib2svARB")]
            public static 
            void VertexAttrib2(Int32 index, ref Int16 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib2svARB((UInt32)index, (Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib2svARB")]
            public static 
            unsafe void VertexAttrib2(Int32 index, Int16* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib2svARB((UInt32)index, (Int16*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib2svARB")]
            public static 
            void VertexAttrib2(UInt32 index, Int16[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = v)
                    {
                        Delegates.glVertexAttrib2svARB((UInt32)index, (Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib2svARB")]
            public static 
            void VertexAttrib2(UInt32 index, ref Int16 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib2svARB((UInt32)index, (Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib2svARB")]
            public static 
            unsafe void VertexAttrib2(UInt32 index, Int16* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib2svARB((UInt32)index, (Int16*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib3dARB")]
            public static 
            void VertexAttrib3(Int32 index, Double x, Double y, Double z)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib3dARB((UInt32)index, (Double)x, (Double)y, (Double)z);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib3dARB")]
            public static 
            void VertexAttrib3(UInt32 index, Double x, Double y, Double z)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib3dARB((UInt32)index, (Double)x, (Double)y, (Double)z);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib3dvARB")]
            public static 
            void VertexAttrib3(Int32 index, Double[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* v_ptr = v)
                    {
                        Delegates.glVertexAttrib3dvARB((UInt32)index, (Double*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib3dvARB")]
            public static 
            void VertexAttrib3(Int32 index, ref Double v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib3dvARB((UInt32)index, (Double*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib3dvARB")]
            public static 
            unsafe void VertexAttrib3(Int32 index, Double* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib3dvARB((UInt32)index, (Double*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib3dvARB")]
            public static 
            void VertexAttrib3(UInt32 index, Double[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* v_ptr = v)
                    {
                        Delegates.glVertexAttrib3dvARB((UInt32)index, (Double*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib3dvARB")]
            public static 
            void VertexAttrib3(UInt32 index, ref Double v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib3dvARB((UInt32)index, (Double*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib3dvARB")]
            public static 
            unsafe void VertexAttrib3(UInt32 index, Double* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib3dvARB((UInt32)index, (Double*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib3fARB")]
            public static 
            void VertexAttrib3(Int32 index, Single x, Single y, Single z)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib3fARB((UInt32)index, (Single)x, (Single)y, (Single)z);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib3fARB")]
            public static 
            void VertexAttrib3(UInt32 index, Single x, Single y, Single z)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib3fARB((UInt32)index, (Single)x, (Single)y, (Single)z);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib3fvARB")]
            public static 
            void VertexAttrib3(Int32 index, Single[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* v_ptr = v)
                    {
                        Delegates.glVertexAttrib3fvARB((UInt32)index, (Single*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib3fvARB")]
            public static 
            void VertexAttrib3(Int32 index, ref Single v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib3fvARB((UInt32)index, (Single*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib3fvARB")]
            public static 
            unsafe void VertexAttrib3(Int32 index, Single* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib3fvARB((UInt32)index, (Single*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib3fvARB")]
            public static 
            void VertexAttrib3(UInt32 index, Single[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* v_ptr = v)
                    {
                        Delegates.glVertexAttrib3fvARB((UInt32)index, (Single*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib3fvARB")]
            public static 
            void VertexAttrib3(UInt32 index, ref Single v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib3fvARB((UInt32)index, (Single*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib3fvARB")]
            public static 
            unsafe void VertexAttrib3(UInt32 index, Single* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib3fvARB((UInt32)index, (Single*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib3sARB")]
            public static 
            void VertexAttrib3(Int32 index, Int16 x, Int16 y, Int16 z)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib3sARB((UInt32)index, (Int16)x, (Int16)y, (Int16)z);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib3sARB")]
            public static 
            void VertexAttrib3(UInt32 index, Int16 x, Int16 y, Int16 z)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib3sARB((UInt32)index, (Int16)x, (Int16)y, (Int16)z);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib3svARB")]
            public static 
            void VertexAttrib3(Int32 index, Int16[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = v)
                    {
                        Delegates.glVertexAttrib3svARB((UInt32)index, (Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib3svARB")]
            public static 
            void VertexAttrib3(Int32 index, ref Int16 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib3svARB((UInt32)index, (Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib3svARB")]
            public static 
            unsafe void VertexAttrib3(Int32 index, Int16* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib3svARB((UInt32)index, (Int16*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib3svARB")]
            public static 
            void VertexAttrib3(UInt32 index, Int16[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = v)
                    {
                        Delegates.glVertexAttrib3svARB((UInt32)index, (Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib3svARB")]
            public static 
            void VertexAttrib3(UInt32 index, ref Int16 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib3svARB((UInt32)index, (Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib3svARB")]
            public static 
            unsafe void VertexAttrib3(UInt32 index, Int16* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib3svARB((UInt32)index, (Int16*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4bvARB")]
            public static 
            void VertexAttrib4(UInt32 index, SByte[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (SByte* v_ptr = v)
                    {
                        Delegates.glVertexAttrib4bvARB((UInt32)index, (SByte*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4bvARB")]
            public static 
            void VertexAttrib4(UInt32 index, ref SByte v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (SByte* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib4bvARB((UInt32)index, (SByte*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4bvARB")]
            public static 
            unsafe void VertexAttrib4(UInt32 index, SByte* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4bvARB((UInt32)index, (SByte*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4dARB")]
            public static 
            void VertexAttrib4(Int32 index, Double x, Double y, Double z, Double w)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4dARB((UInt32)index, (Double)x, (Double)y, (Double)z, (Double)w);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4dARB")]
            public static 
            void VertexAttrib4(UInt32 index, Double x, Double y, Double z, Double w)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4dARB((UInt32)index, (Double)x, (Double)y, (Double)z, (Double)w);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4dvARB")]
            public static 
            void VertexAttrib4(Int32 index, Double[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* v_ptr = v)
                    {
                        Delegates.glVertexAttrib4dvARB((UInt32)index, (Double*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4dvARB")]
            public static 
            void VertexAttrib4(Int32 index, ref Double v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib4dvARB((UInt32)index, (Double*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4dvARB")]
            public static 
            unsafe void VertexAttrib4(Int32 index, Double* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4dvARB((UInt32)index, (Double*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4dvARB")]
            public static 
            void VertexAttrib4(UInt32 index, Double[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* v_ptr = v)
                    {
                        Delegates.glVertexAttrib4dvARB((UInt32)index, (Double*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4dvARB")]
            public static 
            void VertexAttrib4(UInt32 index, ref Double v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib4dvARB((UInt32)index, (Double*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4dvARB")]
            public static 
            unsafe void VertexAttrib4(UInt32 index, Double* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4dvARB((UInt32)index, (Double*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4fARB")]
            public static 
            void VertexAttrib4(Int32 index, Single x, Single y, Single z, Single w)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4fARB((UInt32)index, (Single)x, (Single)y, (Single)z, (Single)w);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4fARB")]
            public static 
            void VertexAttrib4(UInt32 index, Single x, Single y, Single z, Single w)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4fARB((UInt32)index, (Single)x, (Single)y, (Single)z, (Single)w);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4fvARB")]
            public static 
            void VertexAttrib4(Int32 index, Single[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* v_ptr = v)
                    {
                        Delegates.glVertexAttrib4fvARB((UInt32)index, (Single*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4fvARB")]
            public static 
            void VertexAttrib4(Int32 index, ref Single v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib4fvARB((UInt32)index, (Single*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4fvARB")]
            public static 
            unsafe void VertexAttrib4(Int32 index, Single* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4fvARB((UInt32)index, (Single*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4fvARB")]
            public static 
            void VertexAttrib4(UInt32 index, Single[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* v_ptr = v)
                    {
                        Delegates.glVertexAttrib4fvARB((UInt32)index, (Single*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4fvARB")]
            public static 
            void VertexAttrib4(UInt32 index, ref Single v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib4fvARB((UInt32)index, (Single*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4fvARB")]
            public static 
            unsafe void VertexAttrib4(UInt32 index, Single* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4fvARB((UInt32)index, (Single*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4ivARB")]
            public static 
            void VertexAttrib4(Int32 index, Int32[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* v_ptr = v)
                    {
                        Delegates.glVertexAttrib4ivARB((UInt32)index, (Int32*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4ivARB")]
            public static 
            void VertexAttrib4(Int32 index, ref Int32 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib4ivARB((UInt32)index, (Int32*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4ivARB")]
            public static 
            unsafe void VertexAttrib4(Int32 index, Int32* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4ivARB((UInt32)index, (Int32*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4ivARB")]
            public static 
            void VertexAttrib4(UInt32 index, Int32[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* v_ptr = v)
                    {
                        Delegates.glVertexAttrib4ivARB((UInt32)index, (Int32*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4ivARB")]
            public static 
            void VertexAttrib4(UInt32 index, ref Int32 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib4ivARB((UInt32)index, (Int32*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4ivARB")]
            public static 
            unsafe void VertexAttrib4(UInt32 index, Int32* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4ivARB((UInt32)index, (Int32*)v);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NbvARB")]
            public static 
            void VertexAttrib4N(UInt32 index, SByte[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (SByte* v_ptr = v)
                    {
                        Delegates.glVertexAttrib4NbvARB((UInt32)index, (SByte*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NbvARB")]
            public static 
            void VertexAttrib4N(UInt32 index, ref SByte v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (SByte* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib4NbvARB((UInt32)index, (SByte*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NbvARB")]
            public static 
            unsafe void VertexAttrib4N(UInt32 index, SByte* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4NbvARB((UInt32)index, (SByte*)v);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NivARB")]
            public static 
            void VertexAttrib4N(Int32 index, Int32[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* v_ptr = v)
                    {
                        Delegates.glVertexAttrib4NivARB((UInt32)index, (Int32*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NivARB")]
            public static 
            void VertexAttrib4N(Int32 index, ref Int32 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib4NivARB((UInt32)index, (Int32*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NivARB")]
            public static 
            unsafe void VertexAttrib4N(Int32 index, Int32* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4NivARB((UInt32)index, (Int32*)v);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NivARB")]
            public static 
            void VertexAttrib4N(UInt32 index, Int32[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* v_ptr = v)
                    {
                        Delegates.glVertexAttrib4NivARB((UInt32)index, (Int32*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NivARB")]
            public static 
            void VertexAttrib4N(UInt32 index, ref Int32 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib4NivARB((UInt32)index, (Int32*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NivARB")]
            public static 
            unsafe void VertexAttrib4N(UInt32 index, Int32* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4NivARB((UInt32)index, (Int32*)v);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NsvARB")]
            public static 
            void VertexAttrib4N(Int32 index, Int16[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = v)
                    {
                        Delegates.glVertexAttrib4NsvARB((UInt32)index, (Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NsvARB")]
            public static 
            void VertexAttrib4N(Int32 index, ref Int16 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib4NsvARB((UInt32)index, (Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NsvARB")]
            public static 
            unsafe void VertexAttrib4N(Int32 index, Int16* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4NsvARB((UInt32)index, (Int16*)v);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NsvARB")]
            public static 
            void VertexAttrib4N(UInt32 index, Int16[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = v)
                    {
                        Delegates.glVertexAttrib4NsvARB((UInt32)index, (Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NsvARB")]
            public static 
            void VertexAttrib4N(UInt32 index, ref Int16 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib4NsvARB((UInt32)index, (Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NsvARB")]
            public static 
            unsafe void VertexAttrib4N(UInt32 index, Int16* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4NsvARB((UInt32)index, (Int16*)v);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NubARB")]
            public static 
            void VertexAttrib4N(Int32 index, Byte x, Byte y, Byte z, Byte w)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4NubARB((UInt32)index, (Byte)x, (Byte)y, (Byte)z, (Byte)w);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NubARB")]
            public static 
            void VertexAttrib4N(UInt32 index, Byte x, Byte y, Byte z, Byte w)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4NubARB((UInt32)index, (Byte)x, (Byte)y, (Byte)z, (Byte)w);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NubvARB")]
            public static 
            void VertexAttrib4N(Int32 index, Byte[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Byte* v_ptr = v)
                    {
                        Delegates.glVertexAttrib4NubvARB((UInt32)index, (Byte*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NubvARB")]
            public static 
            void VertexAttrib4N(Int32 index, ref Byte v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Byte* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib4NubvARB((UInt32)index, (Byte*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NubvARB")]
            public static 
            unsafe void VertexAttrib4N(Int32 index, Byte* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4NubvARB((UInt32)index, (Byte*)v);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NubvARB")]
            public static 
            void VertexAttrib4N(UInt32 index, Byte[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Byte* v_ptr = v)
                    {
                        Delegates.glVertexAttrib4NubvARB((UInt32)index, (Byte*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NubvARB")]
            public static 
            void VertexAttrib4N(UInt32 index, ref Byte v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Byte* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib4NubvARB((UInt32)index, (Byte*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NubvARB")]
            public static 
            unsafe void VertexAttrib4N(UInt32 index, Byte* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4NubvARB((UInt32)index, (Byte*)v);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NuivARB")]
            public static 
            void VertexAttrib4N(UInt32 index, UInt32[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* v_ptr = v)
                    {
                        Delegates.glVertexAttrib4NuivARB((UInt32)index, (UInt32*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NuivARB")]
            public static 
            void VertexAttrib4N(UInt32 index, ref UInt32 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib4NuivARB((UInt32)index, (UInt32*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NuivARB")]
            public static 
            unsafe void VertexAttrib4N(UInt32 index, UInt32* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4NuivARB((UInt32)index, (UInt32*)v);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NusvARB")]
            public static 
            void VertexAttrib4N(UInt32 index, UInt16[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt16* v_ptr = v)
                    {
                        Delegates.glVertexAttrib4NusvARB((UInt32)index, (UInt16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NusvARB")]
            public static 
            void VertexAttrib4N(UInt32 index, ref UInt16 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt16* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib4NusvARB((UInt32)index, (UInt16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4NusvARB")]
            public static 
            unsafe void VertexAttrib4N(UInt32 index, UInt16* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4NusvARB((UInt32)index, (UInt16*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4sARB")]
            public static 
            void VertexAttrib4(Int32 index, Int16 x, Int16 y, Int16 z, Int16 w)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4sARB((UInt32)index, (Int16)x, (Int16)y, (Int16)z, (Int16)w);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4sARB")]
            public static 
            void VertexAttrib4(UInt32 index, Int16 x, Int16 y, Int16 z, Int16 w)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4sARB((UInt32)index, (Int16)x, (Int16)y, (Int16)z, (Int16)w);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4svARB")]
            public static 
            void VertexAttrib4(Int32 index, Int16[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = v)
                    {
                        Delegates.glVertexAttrib4svARB((UInt32)index, (Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4svARB")]
            public static 
            void VertexAttrib4(Int32 index, ref Int16 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib4svARB((UInt32)index, (Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4svARB")]
            public static 
            unsafe void VertexAttrib4(Int32 index, Int16* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4svARB((UInt32)index, (Int16*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4svARB")]
            public static 
            void VertexAttrib4(UInt32 index, Int16[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = v)
                    {
                        Delegates.glVertexAttrib4svARB((UInt32)index, (Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4svARB")]
            public static 
            void VertexAttrib4(UInt32 index, ref Int16 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib4svARB((UInt32)index, (Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4svARB")]
            public static 
            unsafe void VertexAttrib4(UInt32 index, Int16* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4svARB((UInt32)index, (Int16*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4ubvARB")]
            public static 
            void VertexAttrib4(Int32 index, Byte[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Byte* v_ptr = v)
                    {
                        Delegates.glVertexAttrib4ubvARB((UInt32)index, (Byte*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4ubvARB")]
            public static 
            void VertexAttrib4(Int32 index, ref Byte v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Byte* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib4ubvARB((UInt32)index, (Byte*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4ubvARB")]
            public static 
            unsafe void VertexAttrib4(Int32 index, Byte* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4ubvARB((UInt32)index, (Byte*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4ubvARB")]
            public static 
            void VertexAttrib4(UInt32 index, Byte[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Byte* v_ptr = v)
                    {
                        Delegates.glVertexAttrib4ubvARB((UInt32)index, (Byte*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4ubvARB")]
            public static 
            void VertexAttrib4(UInt32 index, ref Byte v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Byte* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib4ubvARB((UInt32)index, (Byte*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4ubvARB")]
            public static 
            unsafe void VertexAttrib4(UInt32 index, Byte* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4ubvARB((UInt32)index, (Byte*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4uivARB")]
            public static 
            void VertexAttrib4(UInt32 index, UInt32[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* v_ptr = v)
                    {
                        Delegates.glVertexAttrib4uivARB((UInt32)index, (UInt32*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4uivARB")]
            public static 
            void VertexAttrib4(UInt32 index, ref UInt32 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib4uivARB((UInt32)index, (UInt32*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4uivARB")]
            public static 
            unsafe void VertexAttrib4(UInt32 index, UInt32* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4uivARB((UInt32)index, (UInt32*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4usvARB")]
            public static 
            void VertexAttrib4(UInt32 index, UInt16[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt16* v_ptr = v)
                    {
                        Delegates.glVertexAttrib4usvARB((UInt32)index, (UInt16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4usvARB")]
            public static 
            void VertexAttrib4(UInt32 index, ref UInt16 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt16* v_ptr = &v)
                    {
                        Delegates.glVertexAttrib4usvARB((UInt32)index, (UInt16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies the value of a generic vertex attribute
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="v0">
        /// <para>
        /// Specifies the new values to be used for the specified vertex attribute.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttrib4usvARB")]
            public static 
            unsafe void VertexAttrib4(UInt32 index, UInt16* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttrib4usvARB((UInt32)index, (UInt16*)v);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbInstancedArrays", Version = "2.0", EntryPoint = "glVertexAttribDivisorARB")]
            public static 
            void VertexAttribDivisor(Int32 index, Int32 divisor)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttribDivisorARB((UInt32)index, (UInt32)divisor);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbInstancedArrays", Version = "2.0", EntryPoint = "glVertexAttribDivisorARB")]
            public static 
            void VertexAttribDivisor(UInt32 index, UInt32 divisor)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttribDivisorARB((UInt32)index, (UInt32)divisor);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Define an array of generic vertex attribute data
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per generic vertex attribute. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="normalized">
        /// <para>
        /// Specifies whether fixed-point data values should be normalized (GL_TRUE) or converted directly as fixed-point values (GL_FALSE) when they are accessed.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive generic vertex attributes. If stride is 0, the generic vertex attributes are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first generic vertex attribute in the array. The initial value is 0.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttribPointerARB")]
            public static 
            void VertexAttribPointer(Int32 index, Int32 size, OpenTK.Graphics.OpenGL.VertexAttribPointerTypeArb type, bool normalized, Int32 stride, IntPtr pointer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttribPointerARB((UInt32)index, (Int32)size, (OpenTK.Graphics.OpenGL.VertexAttribPointerTypeArb)type, (bool)normalized, (Int32)stride, (IntPtr)pointer);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Define an array of generic vertex attribute data
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per generic vertex attribute. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="normalized">
        /// <para>
        /// Specifies whether fixed-point data values should be normalized (GL_TRUE) or converted directly as fixed-point values (GL_FALSE) when they are accessed.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive generic vertex attributes. If stride is 0, the generic vertex attributes are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first generic vertex attribute in the array. The initial value is 0.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttribPointerARB")]
            public static 
            void VertexAttribPointer<T5>(Int32 index, Int32 size, OpenTK.Graphics.OpenGL.VertexAttribPointerTypeArb type, bool normalized, Int32 stride, [InAttribute, OutAttribute] T5[] pointer)
                where T5 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glVertexAttribPointerARB((UInt32)index, (Int32)size, (OpenTK.Graphics.OpenGL.VertexAttribPointerTypeArb)type, (bool)normalized, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Define an array of generic vertex attribute data
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per generic vertex attribute. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="normalized">
        /// <para>
        /// Specifies whether fixed-point data values should be normalized (GL_TRUE) or converted directly as fixed-point values (GL_FALSE) when they are accessed.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive generic vertex attributes. If stride is 0, the generic vertex attributes are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first generic vertex attribute in the array. The initial value is 0.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttribPointerARB")]
            public static 
            void VertexAttribPointer<T5>(Int32 index, Int32 size, OpenTK.Graphics.OpenGL.VertexAttribPointerTypeArb type, bool normalized, Int32 stride, [InAttribute, OutAttribute] T5[,] pointer)
                where T5 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glVertexAttribPointerARB((UInt32)index, (Int32)size, (OpenTK.Graphics.OpenGL.VertexAttribPointerTypeArb)type, (bool)normalized, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Define an array of generic vertex attribute data
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per generic vertex attribute. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="normalized">
        /// <para>
        /// Specifies whether fixed-point data values should be normalized (GL_TRUE) or converted directly as fixed-point values (GL_FALSE) when they are accessed.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive generic vertex attributes. If stride is 0, the generic vertex attributes are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first generic vertex attribute in the array. The initial value is 0.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttribPointerARB")]
            public static 
            void VertexAttribPointer<T5>(Int32 index, Int32 size, OpenTK.Graphics.OpenGL.VertexAttribPointerTypeArb type, bool normalized, Int32 stride, [InAttribute, OutAttribute] T5[,,] pointer)
                where T5 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glVertexAttribPointerARB((UInt32)index, (Int32)size, (OpenTK.Graphics.OpenGL.VertexAttribPointerTypeArb)type, (bool)normalized, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Define an array of generic vertex attribute data
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per generic vertex attribute. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="normalized">
        /// <para>
        /// Specifies whether fixed-point data values should be normalized (GL_TRUE) or converted directly as fixed-point values (GL_FALSE) when they are accessed.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive generic vertex attributes. If stride is 0, the generic vertex attributes are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first generic vertex attribute in the array. The initial value is 0.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttribPointerARB")]
            public static 
            void VertexAttribPointer<T5>(Int32 index, Int32 size, OpenTK.Graphics.OpenGL.VertexAttribPointerTypeArb type, bool normalized, Int32 stride, [InAttribute, OutAttribute] ref T5 pointer)
                where T5 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glVertexAttribPointerARB((UInt32)index, (Int32)size, (OpenTK.Graphics.OpenGL.VertexAttribPointerTypeArb)type, (bool)normalized, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                    pointer = (T5)pointer_ptr.Target;
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Define an array of generic vertex attribute data
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per generic vertex attribute. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="normalized">
        /// <para>
        /// Specifies whether fixed-point data values should be normalized (GL_TRUE) or converted directly as fixed-point values (GL_FALSE) when they are accessed.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive generic vertex attributes. If stride is 0, the generic vertex attributes are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first generic vertex attribute in the array. The initial value is 0.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttribPointerARB")]
            public static 
            void VertexAttribPointer(UInt32 index, Int32 size, OpenTK.Graphics.OpenGL.VertexAttribPointerTypeArb type, bool normalized, Int32 stride, IntPtr pointer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexAttribPointerARB((UInt32)index, (Int32)size, (OpenTK.Graphics.OpenGL.VertexAttribPointerTypeArb)type, (bool)normalized, (Int32)stride, (IntPtr)pointer);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Define an array of generic vertex attribute data
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per generic vertex attribute. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="normalized">
        /// <para>
        /// Specifies whether fixed-point data values should be normalized (GL_TRUE) or converted directly as fixed-point values (GL_FALSE) when they are accessed.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive generic vertex attributes. If stride is 0, the generic vertex attributes are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first generic vertex attribute in the array. The initial value is 0.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttribPointerARB")]
            public static 
            void VertexAttribPointer<T5>(UInt32 index, Int32 size, OpenTK.Graphics.OpenGL.VertexAttribPointerTypeArb type, bool normalized, Int32 stride, [InAttribute, OutAttribute] T5[] pointer)
                where T5 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glVertexAttribPointerARB((UInt32)index, (Int32)size, (OpenTK.Graphics.OpenGL.VertexAttribPointerTypeArb)type, (bool)normalized, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Define an array of generic vertex attribute data
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per generic vertex attribute. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="normalized">
        /// <para>
        /// Specifies whether fixed-point data values should be normalized (GL_TRUE) or converted directly as fixed-point values (GL_FALSE) when they are accessed.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive generic vertex attributes. If stride is 0, the generic vertex attributes are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first generic vertex attribute in the array. The initial value is 0.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttribPointerARB")]
            public static 
            void VertexAttribPointer<T5>(UInt32 index, Int32 size, OpenTK.Graphics.OpenGL.VertexAttribPointerTypeArb type, bool normalized, Int32 stride, [InAttribute, OutAttribute] T5[,] pointer)
                where T5 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glVertexAttribPointerARB((UInt32)index, (Int32)size, (OpenTK.Graphics.OpenGL.VertexAttribPointerTypeArb)type, (bool)normalized, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Define an array of generic vertex attribute data
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per generic vertex attribute. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="normalized">
        /// <para>
        /// Specifies whether fixed-point data values should be normalized (GL_TRUE) or converted directly as fixed-point values (GL_FALSE) when they are accessed.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive generic vertex attributes. If stride is 0, the generic vertex attributes are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first generic vertex attribute in the array. The initial value is 0.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttribPointerARB")]
            public static 
            void VertexAttribPointer<T5>(UInt32 index, Int32 size, OpenTK.Graphics.OpenGL.VertexAttribPointerTypeArb type, bool normalized, Int32 stride, [InAttribute, OutAttribute] T5[,,] pointer)
                where T5 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glVertexAttribPointerARB((UInt32)index, (Int32)size, (OpenTK.Graphics.OpenGL.VertexAttribPointerTypeArb)type, (bool)normalized, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Define an array of generic vertex attribute data
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be modified.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per generic vertex attribute. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="normalized">
        /// <para>
        /// Specifies whether fixed-point data values should be normalized (GL_TRUE) or converted directly as fixed-point values (GL_FALSE) when they are accessed.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive generic vertex attributes. If stride is 0, the generic vertex attributes are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first generic vertex attribute in the array. The initial value is 0.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexProgram", Version = "1.3", EntryPoint = "glVertexAttribPointerARB")]
            public static 
            void VertexAttribPointer<T5>(UInt32 index, Int32 size, OpenTK.Graphics.OpenGL.VertexAttribPointerTypeArb type, bool normalized, Int32 stride, [InAttribute, OutAttribute] ref T5 pointer)
                where T5 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glVertexAttribPointerARB((UInt32)index, (Int32)size, (OpenTK.Graphics.OpenGL.VertexAttribPointerTypeArb)type, (bool)normalized, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                    pointer = (T5)pointer_ptr.Target;
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glVertexBlendARB")]
            public static 
            void VertexBlend(Int32 count)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glVertexBlendARB((Int32)count);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightbvARB")]
            public static 
            void Weight(Int32 size, SByte[] weights)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (SByte* weights_ptr = weights)
                    {
                        Delegates.glWeightbvARB((Int32)size, (SByte*)weights_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightbvARB")]
            public static 
            void Weight(Int32 size, ref SByte weights)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (SByte* weights_ptr = &weights)
                    {
                        Delegates.glWeightbvARB((Int32)size, (SByte*)weights_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightbvARB")]
            public static 
            unsafe void Weight(Int32 size, SByte* weights)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWeightbvARB((Int32)size, (SByte*)weights);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightdvARB")]
            public static 
            void Weight(Int32 size, Double[] weights)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* weights_ptr = weights)
                    {
                        Delegates.glWeightdvARB((Int32)size, (Double*)weights_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightdvARB")]
            public static 
            void Weight(Int32 size, ref Double weights)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* weights_ptr = &weights)
                    {
                        Delegates.glWeightdvARB((Int32)size, (Double*)weights_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightdvARB")]
            public static 
            unsafe void Weight(Int32 size, Double* weights)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWeightdvARB((Int32)size, (Double*)weights);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightfvARB")]
            public static 
            void Weight(Int32 size, Single[] weights)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* weights_ptr = weights)
                    {
                        Delegates.glWeightfvARB((Int32)size, (Single*)weights_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightfvARB")]
            public static 
            void Weight(Int32 size, ref Single weights)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* weights_ptr = &weights)
                    {
                        Delegates.glWeightfvARB((Int32)size, (Single*)weights_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightfvARB")]
            public static 
            unsafe void Weight(Int32 size, Single* weights)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWeightfvARB((Int32)size, (Single*)weights);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightivARB")]
            public static 
            void Weight(Int32 size, Int32[] weights)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* weights_ptr = weights)
                    {
                        Delegates.glWeightivARB((Int32)size, (Int32*)weights_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightivARB")]
            public static 
            void Weight(Int32 size, ref Int32 weights)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* weights_ptr = &weights)
                    {
                        Delegates.glWeightivARB((Int32)size, (Int32*)weights_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightivARB")]
            public static 
            unsafe void Weight(Int32 size, Int32* weights)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWeightivARB((Int32)size, (Int32*)weights);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightPointerARB")]
            public static 
            void WeightPointer(Int32 size, OpenTK.Graphics.OpenGL.ArbVertexBlend type, Int32 stride, IntPtr pointer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWeightPointerARB((Int32)size, (OpenTK.Graphics.OpenGL.ArbVertexBlend)type, (Int32)stride, (IntPtr)pointer);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightPointerARB")]
            public static 
            void WeightPointer<T3>(Int32 size, OpenTK.Graphics.OpenGL.ArbVertexBlend type, Int32 stride, [InAttribute, OutAttribute] T3[] pointer)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glWeightPointerARB((Int32)size, (OpenTK.Graphics.OpenGL.ArbVertexBlend)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightPointerARB")]
            public static 
            void WeightPointer<T3>(Int32 size, OpenTK.Graphics.OpenGL.ArbVertexBlend type, Int32 stride, [InAttribute, OutAttribute] T3[,] pointer)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glWeightPointerARB((Int32)size, (OpenTK.Graphics.OpenGL.ArbVertexBlend)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightPointerARB")]
            public static 
            void WeightPointer<T3>(Int32 size, OpenTK.Graphics.OpenGL.ArbVertexBlend type, Int32 stride, [InAttribute, OutAttribute] T3[,,] pointer)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glWeightPointerARB((Int32)size, (OpenTK.Graphics.OpenGL.ArbVertexBlend)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightPointerARB")]
            public static 
            void WeightPointer<T3>(Int32 size, OpenTK.Graphics.OpenGL.ArbVertexBlend type, Int32 stride, [InAttribute, OutAttribute] ref T3 pointer)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glWeightPointerARB((Int32)size, (OpenTK.Graphics.OpenGL.ArbVertexBlend)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                    pointer = (T3)pointer_ptr.Target;
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightsvARB")]
            public static 
            void Weight(Int32 size, Int16[] weights)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* weights_ptr = weights)
                    {
                        Delegates.glWeightsvARB((Int32)size, (Int16*)weights_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightsvARB")]
            public static 
            void Weight(Int32 size, ref Int16 weights)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* weights_ptr = &weights)
                    {
                        Delegates.glWeightsvARB((Int32)size, (Int16*)weights_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightsvARB")]
            public static 
            unsafe void Weight(Int32 size, Int16* weights)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWeightsvARB((Int32)size, (Int16*)weights);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightubvARB")]
            public static 
            void Weight(Int32 size, Byte[] weights)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Byte* weights_ptr = weights)
                    {
                        Delegates.glWeightubvARB((Int32)size, (Byte*)weights_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightubvARB")]
            public static 
            void Weight(Int32 size, ref Byte weights)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Byte* weights_ptr = &weights)
                    {
                        Delegates.glWeightubvARB((Int32)size, (Byte*)weights_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightubvARB")]
            public static 
            unsafe void Weight(Int32 size, Byte* weights)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWeightubvARB((Int32)size, (Byte*)weights);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightuivARB")]
            public static 
            void Weight(Int32 size, UInt32[] weights)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* weights_ptr = weights)
                    {
                        Delegates.glWeightuivARB((Int32)size, (UInt32*)weights_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightuivARB")]
            public static 
            void Weight(Int32 size, ref UInt32 weights)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* weights_ptr = &weights)
                    {
                        Delegates.glWeightuivARB((Int32)size, (UInt32*)weights_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightuivARB")]
            public static 
            unsafe void Weight(Int32 size, UInt32* weights)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWeightuivARB((Int32)size, (UInt32*)weights);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightusvARB")]
            public static 
            void Weight(Int32 size, UInt16[] weights)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt16* weights_ptr = weights)
                    {
                        Delegates.glWeightusvARB((Int32)size, (UInt16*)weights_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightusvARB")]
            public static 
            void Weight(Int32 size, ref UInt16 weights)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt16* weights_ptr = &weights)
                    {
                        Delegates.glWeightusvARB((Int32)size, (UInt16*)weights_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbVertexBlend", Version = "1.1", EntryPoint = "glWeightusvARB")]
            public static 
            unsafe void Weight(Int32 size, UInt16* weights)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWeightusvARB((Int32)size, (UInt16*)weights);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos2dARB")]
            public static 
            void WindowPos2(Double x, Double y)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWindowPos2dARB((Double)x, (Double)y);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos2dvARB")]
            public static 
            void WindowPos2(Double[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* v_ptr = v)
                    {
                        Delegates.glWindowPos2dvARB((Double*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos2dvARB")]
            public static 
            void WindowPos2(ref Double v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* v_ptr = &v)
                    {
                        Delegates.glWindowPos2dvARB((Double*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos2dvARB")]
            public static 
            unsafe void WindowPos2(Double* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWindowPos2dvARB((Double*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos2fARB")]
            public static 
            void WindowPos2(Single x, Single y)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWindowPos2fARB((Single)x, (Single)y);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos2fvARB")]
            public static 
            void WindowPos2(Single[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* v_ptr = v)
                    {
                        Delegates.glWindowPos2fvARB((Single*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos2fvARB")]
            public static 
            void WindowPos2(ref Single v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* v_ptr = &v)
                    {
                        Delegates.glWindowPos2fvARB((Single*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos2fvARB")]
            public static 
            unsafe void WindowPos2(Single* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWindowPos2fvARB((Single*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos2iARB")]
            public static 
            void WindowPos2(Int32 x, Int32 y)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWindowPos2iARB((Int32)x, (Int32)y);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos2ivARB")]
            public static 
            void WindowPos2(Int32[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* v_ptr = v)
                    {
                        Delegates.glWindowPos2ivARB((Int32*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos2ivARB")]
            public static 
            void WindowPos2(ref Int32 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* v_ptr = &v)
                    {
                        Delegates.glWindowPos2ivARB((Int32*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos2ivARB")]
            public static 
            unsafe void WindowPos2(Int32* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWindowPos2ivARB((Int32*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos2sARB")]
            public static 
            void WindowPos2(Int16 x, Int16 y)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWindowPos2sARB((Int16)x, (Int16)y);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos2svARB")]
            public static 
            void WindowPos2(Int16[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = v)
                    {
                        Delegates.glWindowPos2svARB((Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos2svARB")]
            public static 
            void WindowPos2(ref Int16 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = &v)
                    {
                        Delegates.glWindowPos2svARB((Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos2svARB")]
            public static 
            unsafe void WindowPos2(Int16* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWindowPos2svARB((Int16*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos3dARB")]
            public static 
            void WindowPos3(Double x, Double y, Double z)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWindowPos3dARB((Double)x, (Double)y, (Double)z);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos3dvARB")]
            public static 
            void WindowPos3(Double[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* v_ptr = v)
                    {
                        Delegates.glWindowPos3dvARB((Double*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos3dvARB")]
            public static 
            void WindowPos3(ref Double v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* v_ptr = &v)
                    {
                        Delegates.glWindowPos3dvARB((Double*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos3dvARB")]
            public static 
            unsafe void WindowPos3(Double* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWindowPos3dvARB((Double*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos3fARB")]
            public static 
            void WindowPos3(Single x, Single y, Single z)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWindowPos3fARB((Single)x, (Single)y, (Single)z);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos3fvARB")]
            public static 
            void WindowPos3(Single[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* v_ptr = v)
                    {
                        Delegates.glWindowPos3fvARB((Single*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos3fvARB")]
            public static 
            void WindowPos3(ref Single v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* v_ptr = &v)
                    {
                        Delegates.glWindowPos3fvARB((Single*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos3fvARB")]
            public static 
            unsafe void WindowPos3(Single* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWindowPos3fvARB((Single*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos3iARB")]
            public static 
            void WindowPos3(Int32 x, Int32 y, Int32 z)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWindowPos3iARB((Int32)x, (Int32)y, (Int32)z);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos3ivARB")]
            public static 
            void WindowPos3(Int32[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* v_ptr = v)
                    {
                        Delegates.glWindowPos3ivARB((Int32*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos3ivARB")]
            public static 
            void WindowPos3(ref Int32 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* v_ptr = &v)
                    {
                        Delegates.glWindowPos3ivARB((Int32*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos3ivARB")]
            public static 
            unsafe void WindowPos3(Int32* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWindowPos3ivARB((Int32*)v);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos3sARB")]
            public static 
            void WindowPos3(Int16 x, Int16 y, Int16 z)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWindowPos3sARB((Int16)x, (Int16)y, (Int16)z);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos3svARB")]
            public static 
            void WindowPos3(Int16[] v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = v)
                    {
                        Delegates.glWindowPos3svARB((Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos3svARB")]
            public static 
            void WindowPos3(ref Int16 v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* v_ptr = &v)
                    {
                        Delegates.glWindowPos3svARB((Int16*)v_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the raster position in window coordinates for pixel operations
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the , , coordinates for the raster position.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbWindowPos", Version = "1.0", EntryPoint = "glWindowPos3svARB")]
            public static 
            unsafe void WindowPos3(Int16* v)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWindowPos3svARB((Int16*)v);
                #if DEBUG
                }
                #endif
            }

        }

        public static partial class Ati
        {
            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glAlphaFragmentOp1ATI")]
            public static 
            void AlphaFragmentOp1(OpenTK.Graphics.OpenGL.AtiFragmentShader op, Int32 dst, Int32 dstMod, Int32 arg1, Int32 arg1Rep, Int32 arg1Mod)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glAlphaFragmentOp1ATI((OpenTK.Graphics.OpenGL.AtiFragmentShader)op, (UInt32)dst, (UInt32)dstMod, (UInt32)arg1, (UInt32)arg1Rep, (UInt32)arg1Mod);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glAlphaFragmentOp1ATI")]
            public static 
            void AlphaFragmentOp1(OpenTK.Graphics.OpenGL.AtiFragmentShader op, UInt32 dst, UInt32 dstMod, UInt32 arg1, UInt32 arg1Rep, UInt32 arg1Mod)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glAlphaFragmentOp1ATI((OpenTK.Graphics.OpenGL.AtiFragmentShader)op, (UInt32)dst, (UInt32)dstMod, (UInt32)arg1, (UInt32)arg1Rep, (UInt32)arg1Mod);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glAlphaFragmentOp2ATI")]
            public static 
            void AlphaFragmentOp2(OpenTK.Graphics.OpenGL.AtiFragmentShader op, Int32 dst, Int32 dstMod, Int32 arg1, Int32 arg1Rep, Int32 arg1Mod, Int32 arg2, Int32 arg2Rep, Int32 arg2Mod)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glAlphaFragmentOp2ATI((OpenTK.Graphics.OpenGL.AtiFragmentShader)op, (UInt32)dst, (UInt32)dstMod, (UInt32)arg1, (UInt32)arg1Rep, (UInt32)arg1Mod, (UInt32)arg2, (UInt32)arg2Rep, (UInt32)arg2Mod);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glAlphaFragmentOp2ATI")]
            public static 
            void AlphaFragmentOp2(OpenTK.Graphics.OpenGL.AtiFragmentShader op, UInt32 dst, UInt32 dstMod, UInt32 arg1, UInt32 arg1Rep, UInt32 arg1Mod, UInt32 arg2, UInt32 arg2Rep, UInt32 arg2Mod)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glAlphaFragmentOp2ATI((OpenTK.Graphics.OpenGL.AtiFragmentShader)op, (UInt32)dst, (UInt32)dstMod, (UInt32)arg1, (UInt32)arg1Rep, (UInt32)arg1Mod, (UInt32)arg2, (UInt32)arg2Rep, (UInt32)arg2Mod);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glAlphaFragmentOp3ATI")]
            public static 
            void AlphaFragmentOp3(OpenTK.Graphics.OpenGL.AtiFragmentShader op, Int32 dst, Int32 dstMod, Int32 arg1, Int32 arg1Rep, Int32 arg1Mod, Int32 arg2, Int32 arg2Rep, Int32 arg2Mod, Int32 arg3, Int32 arg3Rep, Int32 arg3Mod)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glAlphaFragmentOp3ATI((OpenTK.Graphics.OpenGL.AtiFragmentShader)op, (UInt32)dst, (UInt32)dstMod, (UInt32)arg1, (UInt32)arg1Rep, (UInt32)arg1Mod, (UInt32)arg2, (UInt32)arg2Rep, (UInt32)arg2Mod, (UInt32)arg3, (UInt32)arg3Rep, (UInt32)arg3Mod);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glAlphaFragmentOp3ATI")]
            public static 
            void AlphaFragmentOp3(OpenTK.Graphics.OpenGL.AtiFragmentShader op, UInt32 dst, UInt32 dstMod, UInt32 arg1, UInt32 arg1Rep, UInt32 arg1Mod, UInt32 arg2, UInt32 arg2Rep, UInt32 arg2Mod, UInt32 arg3, UInt32 arg3Rep, UInt32 arg3Mod)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glAlphaFragmentOp3ATI((OpenTK.Graphics.OpenGL.AtiFragmentShader)op, (UInt32)dst, (UInt32)dstMod, (UInt32)arg1, (UInt32)arg1Rep, (UInt32)arg1Mod, (UInt32)arg2, (UInt32)arg2Rep, (UInt32)arg2Mod, (UInt32)arg3, (UInt32)arg3Rep, (UInt32)arg3Mod);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glArrayObjectATI")]
            public static 
            void ArrayObject(OpenTK.Graphics.OpenGL.EnableCap array, Int32 size, OpenTK.Graphics.OpenGL.AtiVertexArrayObject type, Int32 stride, Int32 buffer, Int32 offset)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glArrayObjectATI((OpenTK.Graphics.OpenGL.EnableCap)array, (Int32)size, (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)type, (Int32)stride, (UInt32)buffer, (UInt32)offset);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glArrayObjectATI")]
            public static 
            void ArrayObject(OpenTK.Graphics.OpenGL.EnableCap array, Int32 size, OpenTK.Graphics.OpenGL.AtiVertexArrayObject type, Int32 stride, UInt32 buffer, UInt32 offset)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glArrayObjectATI((OpenTK.Graphics.OpenGL.EnableCap)array, (Int32)size, (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)type, (Int32)stride, (UInt32)buffer, (UInt32)offset);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glBeginFragmentShaderATI")]
            public static 
            void BeginFragmentShader()
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBeginFragmentShaderATI();
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glBindFragmentShaderATI")]
            public static 
            void BindFragmentShader(Int32 id)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBindFragmentShaderATI((UInt32)id);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glBindFragmentShaderATI")]
            public static 
            void BindFragmentShader(UInt32 id)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBindFragmentShaderATI((UInt32)id);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexStreams", Version = "1.2", EntryPoint = "glClientActiveVertexStreamATI")]
            public static 
            void ClientActiveVertexStream(OpenTK.Graphics.OpenGL.AtiVertexStreams stream)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glClientActiveVertexStreamATI((OpenTK.Graphics.OpenGL.AtiVertexStreams)stream);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glColorFragmentOp1ATI")]
            public static 
            void ColorFragmentOp1(OpenTK.Graphics.OpenGL.AtiFragmentShader op, Int32 dst, Int32 dstMask, Int32 dstMod, Int32 arg1, Int32 arg1Rep, Int32 arg1Mod)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glColorFragmentOp1ATI((OpenTK.Graphics.OpenGL.AtiFragmentShader)op, (UInt32)dst, (UInt32)dstMask, (UInt32)dstMod, (UInt32)arg1, (UInt32)arg1Rep, (UInt32)arg1Mod);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glColorFragmentOp1ATI")]
            public static 
            void ColorFragmentOp1(OpenTK.Graphics.OpenGL.AtiFragmentShader op, UInt32 dst, UInt32 dstMask, UInt32 dstMod, UInt32 arg1, UInt32 arg1Rep, UInt32 arg1Mod)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glColorFragmentOp1ATI((OpenTK.Graphics.OpenGL.AtiFragmentShader)op, (UInt32)dst, (UInt32)dstMask, (UInt32)dstMod, (UInt32)arg1, (UInt32)arg1Rep, (UInt32)arg1Mod);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glColorFragmentOp2ATI")]
            public static 
            void ColorFragmentOp2(OpenTK.Graphics.OpenGL.AtiFragmentShader op, Int32 dst, Int32 dstMask, Int32 dstMod, Int32 arg1, Int32 arg1Rep, Int32 arg1Mod, Int32 arg2, Int32 arg2Rep, Int32 arg2Mod)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glColorFragmentOp2ATI((OpenTK.Graphics.OpenGL.AtiFragmentShader)op, (UInt32)dst, (UInt32)dstMask, (UInt32)dstMod, (UInt32)arg1, (UInt32)arg1Rep, (UInt32)arg1Mod, (UInt32)arg2, (UInt32)arg2Rep, (UInt32)arg2Mod);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glColorFragmentOp2ATI")]
            public static 
            void ColorFragmentOp2(OpenTK.Graphics.OpenGL.AtiFragmentShader op, UInt32 dst, UInt32 dstMask, UInt32 dstMod, UInt32 arg1, UInt32 arg1Rep, UInt32 arg1Mod, UInt32 arg2, UInt32 arg2Rep, UInt32 arg2Mod)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glColorFragmentOp2ATI((OpenTK.Graphics.OpenGL.AtiFragmentShader)op, (UInt32)dst, (UInt32)dstMask, (UInt32)dstMod, (UInt32)arg1, (UInt32)arg1Rep, (UInt32)arg1Mod, (UInt32)arg2, (UInt32)arg2Rep, (UInt32)arg2Mod);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glColorFragmentOp3ATI")]
            public static 
            void ColorFragmentOp3(OpenTK.Graphics.OpenGL.AtiFragmentShader op, Int32 dst, Int32 dstMask, Int32 dstMod, Int32 arg1, Int32 arg1Rep, Int32 arg1Mod, Int32 arg2, Int32 arg2Rep, Int32 arg2Mod, Int32 arg3, Int32 arg3Rep, Int32 arg3Mod)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glColorFragmentOp3ATI((OpenTK.Graphics.OpenGL.AtiFragmentShader)op, (UInt32)dst, (UInt32)dstMask, (UInt32)dstMod, (UInt32)arg1, (UInt32)arg1Rep, (UInt32)arg1Mod, (UInt32)arg2, (UInt32)arg2Rep, (UInt32)arg2Mod, (UInt32)arg3, (UInt32)arg3Rep, (UInt32)arg3Mod);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glColorFragmentOp3ATI")]
            public static 
            void ColorFragmentOp3(OpenTK.Graphics.OpenGL.AtiFragmentShader op, UInt32 dst, UInt32 dstMask, UInt32 dstMod, UInt32 arg1, UInt32 arg1Rep, UInt32 arg1Mod, UInt32 arg2, UInt32 arg2Rep, UInt32 arg2Mod, UInt32 arg3, UInt32 arg3Rep, UInt32 arg3Mod)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glColorFragmentOp3ATI((OpenTK.Graphics.OpenGL.AtiFragmentShader)op, (UInt32)dst, (UInt32)dstMask, (UInt32)dstMod, (UInt32)arg1, (UInt32)arg1Rep, (UInt32)arg1Mod, (UInt32)arg2, (UInt32)arg2Rep, (UInt32)arg2Mod, (UInt32)arg3, (UInt32)arg3Rep, (UInt32)arg3Mod);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glDeleteFragmentShaderATI")]
            public static 
            void DeleteFragmentShader(Int32 id)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeleteFragmentShaderATI((UInt32)id);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glDeleteFragmentShaderATI")]
            public static 
            void DeleteFragmentShader(UInt32 id)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeleteFragmentShaderATI((UInt32)id);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies a list of color buffers to be drawn into
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffers in bufs.
        /// </para>
        /// </param>
        /// <param name="bufs">
        /// <para>
        /// Points to an array of symbolic constants specifying the buffers into which fragment colors or data values will be written.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "AtiDrawBuffers", Version = "1.2", EntryPoint = "glDrawBuffersATI")]
            public static 
            void DrawBuffers(Int32 n, OpenTK.Graphics.OpenGL.AtiDrawBuffers[] bufs)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (OpenTK.Graphics.OpenGL.AtiDrawBuffers* bufs_ptr = bufs)
                    {
                        Delegates.glDrawBuffersATI((Int32)n, (OpenTK.Graphics.OpenGL.AtiDrawBuffers*)bufs_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies a list of color buffers to be drawn into
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffers in bufs.
        /// </para>
        /// </param>
        /// <param name="bufs">
        /// <para>
        /// Points to an array of symbolic constants specifying the buffers into which fragment colors or data values will be written.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "AtiDrawBuffers", Version = "1.2", EntryPoint = "glDrawBuffersATI")]
            public static 
            void DrawBuffers(Int32 n, ref OpenTK.Graphics.OpenGL.AtiDrawBuffers bufs)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (OpenTK.Graphics.OpenGL.AtiDrawBuffers* bufs_ptr = &bufs)
                    {
                        Delegates.glDrawBuffersATI((Int32)n, (OpenTK.Graphics.OpenGL.AtiDrawBuffers*)bufs_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specifies a list of color buffers to be drawn into
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffers in bufs.
        /// </para>
        /// </param>
        /// <param name="bufs">
        /// <para>
        /// Points to an array of symbolic constants specifying the buffers into which fragment colors or data values will be written.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiDrawBuffers", Version = "1.2", EntryPoint = "glDrawBuffersATI")]
            public static 
            unsafe void DrawBuffers(Int32 n, OpenTK.Graphics.OpenGL.AtiDrawBuffers* bufs)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDrawBuffersATI((Int32)n, (OpenTK.Graphics.OpenGL.AtiDrawBuffers*)bufs);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiElementArray", Version = "1.2", EntryPoint = "glDrawElementArrayATI")]
            public static 
            void DrawElementArray(OpenTK.Graphics.OpenGL.BeginMode mode, Int32 count)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDrawElementArrayATI((OpenTK.Graphics.OpenGL.BeginMode)mode, (Int32)count);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiElementArray", Version = "1.2", EntryPoint = "glDrawRangeElementArrayATI")]
            public static 
            void DrawRangeElementArray(OpenTK.Graphics.OpenGL.BeginMode mode, Int32 start, Int32 end, Int32 count)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDrawRangeElementArrayATI((OpenTK.Graphics.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32)count);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiElementArray", Version = "1.2", EntryPoint = "glDrawRangeElementArrayATI")]
            public static 
            void DrawRangeElementArray(OpenTK.Graphics.OpenGL.BeginMode mode, UInt32 start, UInt32 end, Int32 count)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDrawRangeElementArrayATI((OpenTK.Graphics.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32)count);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiElementArray", Version = "1.2", EntryPoint = "glElementPointerATI")]
            public static 
            void ElementPointer(OpenTK.Graphics.OpenGL.AtiElementArray type, IntPtr pointer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glElementPointerATI((OpenTK.Graphics.OpenGL.AtiElementArray)type, (IntPtr)pointer);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiElementArray", Version = "1.2", EntryPoint = "glElementPointerATI")]
            public static 
            void ElementPointer<T1>(OpenTK.Graphics.OpenGL.AtiElementArray type, [InAttribute, OutAttribute] T1[] pointer)
                where T1 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glElementPointerATI((OpenTK.Graphics.OpenGL.AtiElementArray)type, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiElementArray", Version = "1.2", EntryPoint = "glElementPointerATI")]
            public static 
            void ElementPointer<T1>(OpenTK.Graphics.OpenGL.AtiElementArray type, [InAttribute, OutAttribute] T1[,] pointer)
                where T1 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glElementPointerATI((OpenTK.Graphics.OpenGL.AtiElementArray)type, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiElementArray", Version = "1.2", EntryPoint = "glElementPointerATI")]
            public static 
            void ElementPointer<T1>(OpenTK.Graphics.OpenGL.AtiElementArray type, [InAttribute, OutAttribute] T1[,,] pointer)
                where T1 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glElementPointerATI((OpenTK.Graphics.OpenGL.AtiElementArray)type, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiElementArray", Version = "1.2", EntryPoint = "glElementPointerATI")]
            public static 
            void ElementPointer<T1>(OpenTK.Graphics.OpenGL.AtiElementArray type, [InAttribute, OutAttribute] ref T1 pointer)
                where T1 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glElementPointerATI((OpenTK.Graphics.OpenGL.AtiElementArray)type, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                    pointer = (T1)pointer_ptr.Target;
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glEndFragmentShaderATI")]
            public static 
            void EndFragmentShader()
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glEndFragmentShaderATI();
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glFreeObjectBufferATI")]
            public static 
            void FreeObjectBuffer(Int32 buffer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFreeObjectBufferATI((UInt32)buffer);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glFreeObjectBufferATI")]
            public static 
            void FreeObjectBuffer(UInt32 buffer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFreeObjectBufferATI((UInt32)buffer);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glGenFragmentShadersATI")]
            public static 
            Int32 GenFragmentShaders(Int32 range)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glGenFragmentShadersATI((UInt32)range);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glGenFragmentShadersATI")]
            public static 
            Int32 GenFragmentShaders(UInt32 range)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glGenFragmentShadersATI((UInt32)range);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glGetArrayObjectfvATI")]
            public static 
            void GetArrayObject(OpenTK.Graphics.OpenGL.EnableCap array, OpenTK.Graphics.OpenGL.AtiVertexArrayObject pname, [OutAttribute] out Single @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = &@params)
                    {
                        Delegates.glGetArrayObjectfvATI((OpenTK.Graphics.OpenGL.EnableCap)array, (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)pname, (Single*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glGetArrayObjectfvATI")]
            public static 
            unsafe void GetArrayObject(OpenTK.Graphics.OpenGL.EnableCap array, OpenTK.Graphics.OpenGL.AtiVertexArrayObject pname, [OutAttribute] Single* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetArrayObjectfvATI((OpenTK.Graphics.OpenGL.EnableCap)array, (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)pname, (Single*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glGetArrayObjectivATI")]
            public static 
            void GetArrayObject(OpenTK.Graphics.OpenGL.EnableCap array, OpenTK.Graphics.OpenGL.AtiVertexArrayObject pname, [OutAttribute] out Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetArrayObjectivATI((OpenTK.Graphics.OpenGL.EnableCap)array, (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)pname, (Int32*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glGetArrayObjectivATI")]
            public static 
            unsafe void GetArrayObject(OpenTK.Graphics.OpenGL.EnableCap array, OpenTK.Graphics.OpenGL.AtiVertexArrayObject pname, [OutAttribute] Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetArrayObjectivATI((OpenTK.Graphics.OpenGL.EnableCap)array, (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)pname, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glGetObjectBufferfvATI")]
            public static 
            void GetObjectBuffer(Int32 buffer, OpenTK.Graphics.OpenGL.AtiVertexArrayObject pname, [OutAttribute] out Single @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = &@params)
                    {
                        Delegates.glGetObjectBufferfvATI((UInt32)buffer, (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)pname, (Single*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glGetObjectBufferfvATI")]
            public static 
            unsafe void GetObjectBuffer(Int32 buffer, OpenTK.Graphics.OpenGL.AtiVertexArrayObject pname, [OutAttribute] Single* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetObjectBufferfvATI((UInt32)buffer, (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)pname, (Single*)@params);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glGetObjectBufferfvATI")]
            public static 
            void GetObjectBuffer(UInt32 buffer, OpenTK.Graphics.OpenGL.AtiVertexArrayObject pname, [OutAttribute] out Single @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = &@params)
                    {
                        Delegates.glGetObjectBufferfvATI((UInt32)buffer, (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)pname, (Single*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glGetObjectBufferfvATI")]
            public static 
            unsafe void GetObjectBuffer(UInt32 buffer, OpenTK.Graphics.OpenGL.AtiVertexArrayObject pname, [OutAttribute] Single* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetObjectBufferfvATI((UInt32)buffer, (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)pname, (Single*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glGetObjectBufferivATI")]
            public static 
            void GetObjectBuffer(Int32 buffer, OpenTK.Graphics.OpenGL.AtiVertexArrayObject pname, [OutAttribute] out Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetObjectBufferivATI((UInt32)buffer, (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)pname, (Int32*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glGetObjectBufferivATI")]
            public static 
            unsafe void GetObjectBuffer(Int32 buffer, OpenTK.Graphics.OpenGL.AtiVertexArrayObject pname, [OutAttribute] Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetObjectBufferivATI((UInt32)buffer, (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)pname, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glGetObjectBufferivATI")]
            public static 
            void GetObjectBuffer(UInt32 buffer, OpenTK.Graphics.OpenGL.AtiVertexArrayObject pname, [OutAttribute] out Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetObjectBufferivATI((UInt32)buffer, (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)pname, (Int32*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glGetObjectBufferivATI")]
            public static 
            unsafe void GetObjectBuffer(UInt32 buffer, OpenTK.Graphics.OpenGL.AtiVertexArrayObject pname, [OutAttribute] Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetObjectBufferivATI((UInt32)buffer, (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)pname, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiEnvmapBumpmap", Version = "1.2", EntryPoint = "glGetTexBumpParameterfvATI")]
            public static 
            void GetTexBumpParameter(OpenTK.Graphics.OpenGL.AtiEnvmapBumpmap pname, [OutAttribute] Single[] param)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* param_ptr = param)
                    {
                        Delegates.glGetTexBumpParameterfvATI((OpenTK.Graphics.OpenGL.AtiEnvmapBumpmap)pname, (Single*)param_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiEnvmapBumpmap", Version = "1.2", EntryPoint = "glGetTexBumpParameterfvATI")]
            public static 
            void GetTexBumpParameter(OpenTK.Graphics.OpenGL.AtiEnvmapBumpmap pname, [OutAttribute] out Single param)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* param_ptr = &param)
                    {
                        Delegates.glGetTexBumpParameterfvATI((OpenTK.Graphics.OpenGL.AtiEnvmapBumpmap)pname, (Single*)param_ptr);
                        param = *param_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiEnvmapBumpmap", Version = "1.2", EntryPoint = "glGetTexBumpParameterfvATI")]
            public static 
            unsafe void GetTexBumpParameter(OpenTK.Graphics.OpenGL.AtiEnvmapBumpmap pname, [OutAttribute] Single* param)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetTexBumpParameterfvATI((OpenTK.Graphics.OpenGL.AtiEnvmapBumpmap)pname, (Single*)param);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiEnvmapBumpmap", Version = "1.2", EntryPoint = "glGetTexBumpParameterivATI")]
            public static 
            void GetTexBumpParameter(OpenTK.Graphics.OpenGL.AtiEnvmapBumpmap pname, [OutAttribute] Int32[] param)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* param_ptr = param)
                    {
                        Delegates.glGetTexBumpParameterivATI((OpenTK.Graphics.OpenGL.AtiEnvmapBumpmap)pname, (Int32*)param_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiEnvmapBumpmap", Version = "1.2", EntryPoint = "glGetTexBumpParameterivATI")]
            public static 
            void GetTexBumpParameter(OpenTK.Graphics.OpenGL.AtiEnvmapBumpmap pname, [OutAttribute] out Int32 param)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* param_ptr = &param)
                    {
                        Delegates.glGetTexBumpParameterivATI((OpenTK.Graphics.OpenGL.AtiEnvmapBumpmap)pname, (Int32*)param_ptr);
                        param = *param_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiEnvmapBumpmap", Version = "1.2", EntryPoint = "glGetTexBumpParameterivATI")]
            public static 
            unsafe void GetTexBumpParameter(OpenTK.Graphics.OpenGL.AtiEnvmapBumpmap pname, [OutAttribute] Int32* param)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetTexBumpParameterivATI((OpenTK.Graphics.OpenGL.AtiEnvmapBumpmap)pname, (Int32*)param);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glGetVariantArrayObjectfvATI")]
            public static 
            void GetVariantArrayObject(Int32 id, OpenTK.Graphics.OpenGL.AtiVertexArrayObject pname, [OutAttribute] out Single @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = &@params)
                    {
                        Delegates.glGetVariantArrayObjectfvATI((UInt32)id, (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)pname, (Single*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glGetVariantArrayObjectfvATI")]
            public static 
            unsafe void GetVariantArrayObject(Int32 id, OpenTK.Graphics.OpenGL.AtiVertexArrayObject pname, [OutAttribute] Single* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetVariantArrayObjectfvATI((UInt32)id, (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)pname, (Single*)@params);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glGetVariantArrayObjectfvATI")]
            public static 
            void GetVariantArrayObject(UInt32 id, OpenTK.Graphics.OpenGL.AtiVertexArrayObject pname, [OutAttribute] out Single @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = &@params)
                    {
                        Delegates.glGetVariantArrayObjectfvATI((UInt32)id, (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)pname, (Single*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glGetVariantArrayObjectfvATI")]
            public static 
            unsafe void GetVariantArrayObject(UInt32 id, OpenTK.Graphics.OpenGL.AtiVertexArrayObject pname, [OutAttribute] Single* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetVariantArrayObjectfvATI((UInt32)id, (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)pname, (Single*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glGetVariantArrayObjectivATI")]
            public static 
            void GetVariantArrayObject(Int32 id, OpenTK.Graphics.OpenGL.AtiVertexArrayObject pname, [OutAttribute] out Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetVariantArrayObjectivATI((UInt32)id, (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)pname, (Int32*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glGetVariantArrayObjectivATI")]
            public static 
            unsafe void GetVariantArrayObject(Int32 id, OpenTK.Graphics.OpenGL.AtiVertexArrayObject pname, [OutAttribute] Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetVariantArrayObjectivATI((UInt32)id, (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)pname, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glGetVariantArrayObjectivATI")]
            public static 
            void GetVariantArrayObject(UInt32 id, OpenTK.Graphics.OpenGL.AtiVertexArrayObject pname, [OutAttribute] out Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetVariantArrayObjectivATI((UInt32)id, (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)pname, (Int32*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glGetVariantArrayObjectivATI")]
            public static 
            unsafe void GetVariantArrayObject(UInt32 id, OpenTK.Graphics.OpenGL.AtiVertexArrayObject pname, [OutAttribute] Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetVariantArrayObjectivATI((UInt32)id, (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)pname, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexAttribArrayObject", Version = "1.2", EntryPoint = "glGetVertexAttribArrayObjectfvATI")]
            public static 
            void GetVertexAttribArrayObject(Int32 index, OpenTK.Graphics.OpenGL.AtiVertexAttribArrayObject pname, [OutAttribute] Single[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = @params)
                    {
                        Delegates.glGetVertexAttribArrayObjectfvATI((UInt32)index, (OpenTK.Graphics.OpenGL.AtiVertexAttribArrayObject)pname, (Single*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexAttribArrayObject", Version = "1.2", EntryPoint = "glGetVertexAttribArrayObjectfvATI")]
            public static 
            void GetVertexAttribArrayObject(Int32 index, OpenTK.Graphics.OpenGL.AtiVertexAttribArrayObject pname, [OutAttribute] out Single @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = &@params)
                    {
                        Delegates.glGetVertexAttribArrayObjectfvATI((UInt32)index, (OpenTK.Graphics.OpenGL.AtiVertexAttribArrayObject)pname, (Single*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexAttribArrayObject", Version = "1.2", EntryPoint = "glGetVertexAttribArrayObjectfvATI")]
            public static 
            unsafe void GetVertexAttribArrayObject(Int32 index, OpenTK.Graphics.OpenGL.AtiVertexAttribArrayObject pname, [OutAttribute] Single* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetVertexAttribArrayObjectfvATI((UInt32)index, (OpenTK.Graphics.OpenGL.AtiVertexAttribArrayObject)pname, (Single*)@params);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexAttribArrayObject", Version = "1.2", EntryPoint = "glGetVertexAttribArrayObjectfvATI")]
            public static 
            void GetVertexAttribArrayObject(UInt32 index, OpenTK.Graphics.OpenGL.AtiVertexAttribArrayObject pname, [OutAttribute] Single[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = @params)
                    {
                        Delegates.glGetVertexAttribArrayObjectfvATI((UInt32)index, (OpenTK.Graphics.OpenGL.AtiVertexAttribArrayObject)pname, (Single*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexAttribArrayObject", Version = "1.2", EntryPoint = "glGetVertexAttribArrayObjectfvATI")]
            public static 
            void GetVertexAttribArrayObject(UInt32 index, OpenTK.Graphics.OpenGL.AtiVertexAttribArrayObject pname, [OutAttribute] out Single @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = &@params)
                    {
                        Delegates.glGetVertexAttribArrayObjectfvATI((UInt32)index, (OpenTK.Graphics.OpenGL.AtiVertexAttribArrayObject)pname, (Single*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexAttribArrayObject", Version = "1.2", EntryPoint = "glGetVertexAttribArrayObjectfvATI")]
            public static 
            unsafe void GetVertexAttribArrayObject(UInt32 index, OpenTK.Graphics.OpenGL.AtiVertexAttribArrayObject pname, [OutAttribute] Single* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetVertexAttribArrayObjectfvATI((UInt32)index, (OpenTK.Graphics.OpenGL.AtiVertexAttribArrayObject)pname, (Single*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexAttribArrayObject", Version = "1.2", EntryPoint = "glGetVertexAttribArrayObjectivATI")]
            public static 
            void GetVertexAttribArrayObject(Int32 index, OpenTK.Graphics.OpenGL.AtiVertexAttribArrayObject pname, [OutAttribute] Int32[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = @params)
                    {
                        Delegates.glGetVertexAttribArrayObjectivATI((UInt32)index, (OpenTK.Graphics.OpenGL.AtiVertexAttribArrayObject)pname, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexAttribArrayObject", Version = "1.2", EntryPoint = "glGetVertexAttribArrayObjectivATI")]
            public static 
            void GetVertexAttribArrayObject(Int32 index, OpenTK.Graphics.OpenGL.AtiVertexAttribArrayObject pname, [OutAttribute] out Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetVertexAttribArrayObjectivATI((UInt32)index, (OpenTK.Graphics.OpenGL.AtiVertexAttribArrayObject)pname, (Int32*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexAttribArrayObject", Version = "1.2", EntryPoint = "glGetVertexAttribArrayObjectivATI")]
            public static 
            unsafe void GetVertexAttribArrayObject(Int32 index, OpenTK.Graphics.OpenGL.AtiVertexAttribArrayObject pname, [OutAttribute] Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetVertexAttribArrayObjectivATI((UInt32)index, (OpenTK.Graphics.OpenGL.AtiVertexAttribArrayObject)pname, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexAttribArrayObject", Version = "1.2", EntryPoint = "glGetVertexAttribArrayObjectivATI")]
            public static 
            void GetVertexAttribArrayObject(UInt32 index, OpenTK.Graphics.OpenGL.AtiVertexAttribArrayObject pname, [OutAttribute] Int32[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = @params)
                    {
                        Delegates.glGetVertexAttribArrayObjectivATI((UInt32)index, (OpenTK.Graphics.OpenGL.AtiVertexAttribArrayObject)pname, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexAttribArrayObject", Version = "1.2", EntryPoint = "glGetVertexAttribArrayObjectivATI")]
            public static 
            void GetVertexAttribArrayObject(UInt32 index, OpenTK.Graphics.OpenGL.AtiVertexAttribArrayObject pname, [OutAttribute] out Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetVertexAttribArrayObjectivATI((UInt32)index, (OpenTK.Graphics.OpenGL.AtiVertexAttribArrayObject)pname, (Int32*)@params_ptr);
                        @params = *@params_ptr;
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexAttribArrayObject", Version = "1.2", EntryPoint = "glGetVertexAttribArrayObjectivATI")]
            public static 
            unsafe void GetVertexAttribArrayObject(UInt32 index, OpenTK.Graphics.OpenGL.AtiVertexAttribArrayObject pname, [OutAttribute] Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetVertexAttribArrayObjectivATI((UInt32)index, (OpenTK.Graphics.OpenGL.AtiVertexAttribArrayObject)pname, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glIsObjectBufferATI")]
            public static 
            bool IsObjectBuffer(Int32 buffer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glIsObjectBufferATI((UInt32)buffer);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glIsObjectBufferATI")]
            public static 
            bool IsObjectBuffer(UInt32 buffer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glIsObjectBufferATI((UInt32)buffer);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiMapObjectBuffer", Version = "1.2", EntryPoint = "glMapObjectBufferATI")]
            public static 
            unsafe System.IntPtr MapObjectBuffer(Int32 buffer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glMapObjectBufferATI((UInt32)buffer);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiMapObjectBuffer", Version = "1.2", EntryPoint = "glMapObjectBufferATI")]
            public static 
            unsafe System.IntPtr MapObjectBuffer(UInt32 buffer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glMapObjectBufferATI((UInt32)buffer);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glNewObjectBufferATI")]
            public static 
            Int32 NewObjectBuffer(Int32 size, IntPtr pointer, OpenTK.Graphics.OpenGL.AtiVertexArrayObject usage)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glNewObjectBufferATI((Int32)size, (IntPtr)pointer, (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)usage);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glNewObjectBufferATI")]
            public static 
            Int32 NewObjectBuffer<T1>(Int32 size, [InAttribute, OutAttribute] T1[] pointer, OpenTK.Graphics.OpenGL.AtiVertexArrayObject usage)
                where T1 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    return Delegates.glNewObjectBufferATI((Int32)size, (IntPtr)pointer_ptr.AddrOfPinnedObject(), (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)usage);
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glNewObjectBufferATI")]
            public static 
            Int32 NewObjectBuffer<T1>(Int32 size, [InAttribute, OutAttribute] T1[,] pointer, OpenTK.Graphics.OpenGL.AtiVertexArrayObject usage)
                where T1 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    return Delegates.glNewObjectBufferATI((Int32)size, (IntPtr)pointer_ptr.AddrOfPinnedObject(), (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)usage);
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glNewObjectBufferATI")]
            public static 
            Int32 NewObjectBuffer<T1>(Int32 size, [InAttribute, OutAttribute] T1[,,] pointer, OpenTK.Graphics.OpenGL.AtiVertexArrayObject usage)
                where T1 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    return Delegates.glNewObjectBufferATI((Int32)size, (IntPtr)pointer_ptr.AddrOfPinnedObject(), (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)usage);
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexArrayObject", Version = "1.2", EntryPoint = "glNewObjectBufferATI")]
            public static 
            Int32 NewObjectBuffer<T1>(Int32 size, [InAttribute, OutAttribute] ref T1 pointer, OpenTK.Graphics.OpenGL.AtiVertexArrayObject usage)
                where T1 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Int32 retval = Delegates.glNewObjectBufferATI((Int32)size, (IntPtr)pointer_ptr.AddrOfPinnedObject(), (OpenTK.Graphics.OpenGL.AtiVertexArrayObject)usage);
                    pointer = (T1)pointer_ptr.Target;
                    return retval;
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexStreams", Version = "1.2", EntryPoint = "glNormalStream3bATI")]
            public static 
            void NormalStream3(OpenTK.Graphics.OpenGL.AtiVertexStreams stream, Byte nx, Byte ny, Byte nz)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glNormalStream3bATI((OpenTK.Graphics.OpenGL.AtiVertexStreams)stream, (SByte)nx, (SByte)ny, (SByte)nz);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexStreams", Version = "1.2", EntryPoint = "glNormalStream3bATI")]
            public static 
            void NormalStream3(OpenTK.Graphics.OpenGL.AtiVertexStreams stream, SByte nx, SByte ny, SByte nz)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glNormalStream3bATI((OpenTK.Graphics.OpenGL.AtiVertexStreams)stream, (SByte)nx, (SByte)ny, (SByte)nz);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexStreams", Version = "1.2", EntryPoint = "glNormalStream3bvATI")]
            public static 
            void NormalStream3(OpenTK.Graphics.OpenGL.AtiVertexStreams stream, Byte[] coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Byte* coords_ptr = coords)
                    {
                        Delegates.glNormalStream3bvATI((OpenTK.Graphics.OpenGL.AtiVertexStreams)stream, (SByte*)coords_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexStreams", Version = "1.2", EntryPoint = "glNormalStream3bvATI")]
            public static 
            void NormalStream3(OpenTK.Graphics.OpenGL.AtiVertexStreams stream, ref Byte coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Byte* coords_ptr = &coords)
                    {
                        Delegates.glNormalStream3bvATI((OpenTK.Graphics.OpenGL.AtiVertexStreams)stream, (SByte*)coords_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexStreams", Version = "1.2", EntryPoint = "glNormalStream3bvATI")]
            public static 
            unsafe void NormalStream3(OpenTK.Graphics.OpenGL.AtiVertexStreams stream, Byte* coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glNormalStream3bvATI((OpenTK.Graphics.OpenGL.AtiVertexStreams)stream, (SByte*)coords);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexStreams", Version = "1.2", EntryPoint = "glNormalStream3bvATI")]
            public static 
            void NormalStream3(OpenTK.Graphics.OpenGL.AtiVertexStreams stream, SByte[] coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (SByte* coords_ptr = coords)
                    {
                        Delegates.glNormalStream3bvATI((OpenTK.Graphics.OpenGL.AtiVertexStreams)stream, (SByte*)coords_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexStreams", Version = "1.2", EntryPoint = "glNormalStream3bvATI")]
            public static 
            void NormalStream3(OpenTK.Graphics.OpenGL.AtiVertexStreams stream, ref SByte coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (SByte* coords_ptr = &coords)
                    {
                        Delegates.glNormalStream3bvATI((OpenTK.Graphics.OpenGL.AtiVertexStreams)stream, (SByte*)coords_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexStreams", Version = "1.2", EntryPoint = "glNormalStream3bvATI")]
            public static 
            unsafe void NormalStream3(OpenTK.Graphics.OpenGL.AtiVertexStreams stream, SByte* coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glNormalStream3bvATI((OpenTK.Graphics.OpenGL.AtiVertexStreams)stream, (SByte*)coords);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexStreams", Version = "1.2", EntryPoint = "glNormalStream3dATI")]
            public static 
            void NormalStream3(OpenTK.Graphics.OpenGL.AtiVertexStreams stream, Double nx, Double ny, Double nz)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glNormalStream3dATI((OpenTK.Graphics.OpenGL.AtiVertexStreams)stream, (Double)nx, (Double)ny, (Double)nz);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexStreams", Version = "1.2", EntryPoint = "glNormalStream3dvATI")]
            public static 
            void NormalStream3(OpenTK.Graphics.OpenGL.AtiVertexStreams stream, Double[] coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* coords_ptr = coords)
                    {
                        Delegates.glNormalStream3dvATI((OpenTK.Graphics.OpenGL.AtiVertexStreams)stream, (Double*)coords_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexStreams", Version = "1.2", EntryPoint = "glNormalStream3dvATI")]
            public static 
            void NormalStream3(OpenTK.Graphics.OpenGL.AtiVertexStreams stream, ref Double coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Double* coords_ptr = &coords)
                    {
                        Delegates.glNormalStream3dvATI((OpenTK.Graphics.OpenGL.AtiVertexStreams)stream, (Double*)coords_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexStreams", Version = "1.2", EntryPoint = "glNormalStream3dvATI")]
            public static 
            unsafe void NormalStream3(OpenTK.Graphics.OpenGL.AtiVertexStreams stream, Double* coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glNormalStream3dvATI((OpenTK.Graphics.OpenGL.AtiVertexStreams)stream, (Double*)coords);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexStreams", Version = "1.2", EntryPoint = "glNormalStream3fATI")]
            public static 
            void NormalStream3(OpenTK.Graphics.OpenGL.AtiVertexStreams stream, Single nx, Single ny, Single nz)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glNormalStream3fATI((OpenTK.Graphics.OpenGL.AtiVertexStreams)stream, (Single)nx, (Single)ny, (Single)nz);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexStreams", Version = "1.2", EntryPoint = "glNormalStream3fvATI")]
            public static 
            void NormalStream3(OpenTK.Graphics.OpenGL.AtiVertexStreams stream, Single[] coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* coords_ptr = coords)
                    {
                        Delegates.glNormalStream3fvATI((OpenTK.Graphics.OpenGL.AtiVertexStreams)stream, (Single*)coords_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexStreams", Version = "1.2", EntryPoint = "glNormalStream3fvATI")]
            public static 
            void NormalStream3(OpenTK.Graphics.OpenGL.AtiVertexStreams stream, ref Single coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* coords_ptr = &coords)
                    {
                        Delegates.glNormalStream3fvATI((OpenTK.Graphics.OpenGL.AtiVertexStreams)stream, (Single*)coords_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexStreams", Version = "1.2", EntryPoint = "glNormalStream3fvATI")]
            public static 
            unsafe void NormalStream3(OpenTK.Graphics.OpenGL.AtiVertexStreams stream, Single* coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glNormalStream3fvATI((OpenTK.Graphics.OpenGL.AtiVertexStreams)stream, (Single*)coords);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexStreams", Version = "1.2", EntryPoint = "glNormalStream3iATI")]
            public static 
            void NormalStream3(OpenTK.Graphics.OpenGL.AtiVertexStreams stream, Int32 nx, Int32 ny, Int32 nz)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glNormalStream3iATI((OpenTK.Graphics.OpenGL.AtiVertexStreams)stream, (Int32)nx, (Int32)ny, (Int32)nz);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexStreams", Version = "1.2", EntryPoint = "glNormalStream3ivATI")]
            public static 
            void NormalStream3(OpenTK.Graphics.OpenGL.AtiVertexStreams stream, Int32[] coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* coords_ptr = coords)
                    {
                        Delegates.glNormalStream3ivATI((OpenTK.Graphics.OpenGL.AtiVertexStreams)stream, (Int32*)coords_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexStreams", Version = "1.2", EntryPoint = "glNormalStream3ivATI")]
            public static 
            void NormalStream3(OpenTK.Graphics.OpenGL.AtiVertexStreams stream, ref Int32 coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* coords_ptr = &coords)
                    {
                        Delegates.glNormalStream3ivATI((OpenTK.Graphics.OpenGL.AtiVertexStreams)stream, (Int32*)coords_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexStreams", Version = "1.2", EntryPoint = "glNormalStream3ivATI")]
            public static 
            unsafe void NormalStream3(OpenTK.Graphics.OpenGL.AtiVertexStreams stream, Int32* coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glNormalStream3ivATI((OpenTK.Graphics.OpenGL.AtiVertexStreams)stream, (Int32*)coords);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexStreams", Version = "1.2", EntryPoint = "glNormalStream3sATI")]
            public static 
            void NormalStream3(OpenTK.Graphics.OpenGL.AtiVertexStreams stream, Int16 nx, Int16 ny, Int16 nz)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glNormalStream3sATI((OpenTK.Graphics.OpenGL.AtiVertexStreams)stream, (Int16)nx, (Int16)ny, (Int16)nz);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexStreams", Version = "1.2", EntryPoint = "glNormalStream3svATI")]
            public static 
            void NormalStream3(OpenTK.Graphics.OpenGL.AtiVertexStreams stream, Int16[] coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* coords_ptr = coords)
                    {
                        Delegates.glNormalStream3svATI((OpenTK.Graphics.OpenGL.AtiVertexStreams)stream, (Int16*)coords_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiVertexStreams", Version = "1.2", EntryPoint = "glNormalStream3svATI")]
            public static 
            void NormalStream3(OpenTK.Graphics.OpenGL.AtiVertexStreams stream, ref Int16 coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* coords_ptr = &coords)
                    {
                        Delegates.glNormalStream3svATI((OpenTK.Graphics.OpenGL.AtiVertexStreams)stream, (Int16*)coords_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiVertexStreams", Version = "1.2", EntryPoint = "glNormalStream3svATI")]
            public static 
            unsafe void NormalStream3(OpenTK.Graphics.OpenGL.AtiVertexStreams stream, Int16* coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glNormalStream3svATI((OpenTK.Graphics.OpenGL.AtiVertexStreams)stream, (Int16*)coords);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glPassTexCoordATI")]
            public static 
            void PassTexCoor(Int32 dst, Int32 coord, OpenTK.Graphics.OpenGL.AtiFragmentShader swizzle)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glPassTexCoordATI((UInt32)dst, (UInt32)coord, (OpenTK.Graphics.OpenGL.AtiFragmentShader)swizzle);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glPassTexCoordATI")]
            public static 
            void PassTexCoor(UInt32 dst, UInt32 coord, OpenTK.Graphics.OpenGL.AtiFragmentShader swizzle)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glPassTexCoordATI((UInt32)dst, (UInt32)coord, (OpenTK.Graphics.OpenGL.AtiFragmentShader)swizzle);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiPnTriangles", Version = "1.2", EntryPoint = "glPNTrianglesfATI")]
            public static 
            void PNTriangles(OpenTK.Graphics.OpenGL.AtiPnTriangles pname, Single param)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glPNTrianglesfATI((OpenTK.Graphics.OpenGL.AtiPnTriangles)pname, (Single)param);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiPnTriangles", Version = "1.2", EntryPoint = "glPNTrianglesiATI")]
            public static 
            void PNTriangles(OpenTK.Graphics.OpenGL.AtiPnTriangles pname, Int32 param)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glPNTrianglesiATI((OpenTK.Graphics.OpenGL.AtiPnTriangles)pname, (Int32)param);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glSampleMapATI")]
            public static 
            void SampleMap(Int32 dst, Int32 interp, OpenTK.Graphics.OpenGL.AtiFragmentShader swizzle)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glSampleMapATI((UInt32)dst, (UInt32)interp, (OpenTK.Graphics.OpenGL.AtiFragmentShader)swizzle);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glSampleMapATI")]
            public static 
            void SampleMap(UInt32 dst, UInt32 interp, OpenTK.Graphics.OpenGL.AtiFragmentShader swizzle)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glSampleMapATI((UInt32)dst, (UInt32)interp, (OpenTK.Graphics.OpenGL.AtiFragmentShader)swizzle);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glSetFragmentShaderConstantATI")]
            public static 
            void SetFragmentShaderConstant(Int32 dst, Single[] value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* value_ptr = value)
                    {
                        Delegates.glSetFragmentShaderConstantATI((UInt32)dst, (Single*)value_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glSetFragmentShaderConstantATI")]
            public static 
            void SetFragmentShaderConstant(Int32 dst, ref Single value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* value_ptr = &value)
                    {
                        Delegates.glSetFragmentShaderConstantATI((UInt32)dst, (Single*)value_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glSetFragmentShaderConstantATI")]
            public static 
            unsafe void SetFragmentShaderConstant(Int32 dst, Single* value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glSetFragmentShaderConstantATI((UInt32)dst, (Single*)value);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glSetFragmentShaderConstantATI")]
            public static 
            void SetFragmentShaderConstant(UInt32 dst, Single[] value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* value_ptr = value)
                    {
                        Delegates.glSetFragmentShaderConstantATI((UInt32)dst, (Single*)value_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glSetFragmentShaderConstantATI")]
            public static 
            void SetFragmentShaderConstant(UInt32 dst, ref Single value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* value_ptr = &value)
                    {
                        Delegates.glSetFragmentShaderConstantATI((UInt32)dst, (Single*)value_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glSetFragmentShaderConstantATI")]
            public static 
            unsafe void SetFragmentShaderConstant(UInt32 dst, Single* value)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glSetFragmentShaderConstantATI((UInt32)dst, (Single*)value);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set front and/or back function and reference value for stencil testing
        /// </summary>
        /// <param name="face">
        /// <para>
        /// Specifies whether front and/or back stencil state is updated. Three symbolic constants are valid: GL_FRONT, GL_BACK, and GL_FRONT_AND_BACK.
        /// </para>
        /// </param>
        /// <param name="func">
        /// <para>
        /// Specifies the test function. Eight symbolic constants are valid: GL_NEVER, GL_LESS, GL_LEQUAL, GL_GREATER, GL_GEQUAL, GL_EQUAL, GL_NOTEQUAL, and GL_ALWAYS. The initial value is GL_ALWAYS.
        /// </para>
        /// </param>
        /// <param name="ref">
        /// <para>
        /// Specifies the reference value for the stencil test. ref is clamped to the range [0, 2 sup n - 1], where is the number of bitplanes in the stencil buffer. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="mask">
        /// <para>
        /// Specifies a mask that is ANDed with both the reference value and the stored stencil value when the test is done. The initial value is all 1's.
    