!{\src2tex{textfont=tt}}
!!****f* ABINIT/pawmkrhoij
!!
!! NAME
!! pawmkrhoij
!!
!! FUNCTION
!! Calculate the PAW quantities rhoij (augmentation occupancies)
!! for each atom:
!!   * rhoij=Sum_{n,k} {occ(n,k)*rhoij_nk}
!!   * Usefull quantities to compute (later)
!!       rhoij derivatives (wrt atm. pos., strains, ...)
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  atindx1(natom)=index table for atoms, inverse of atindx
!!  cprjnk(natom,mband*mkmem*nsppol)= wave functions projected with non-local projectors:
!!                                   cprjnk=<p_i|Cnk> where p_i is a non-local projector.
!!  dimcprj=array of dimensions of array cprjnk_k
!!  eigen(mband*nkpt*nsppol)=array for holding eigenvalues (hartree)
!!  mband=maximum number of bands
!!  mkmem =number of k points which can fit in memory; set to 0 if use disk
!!  mpi_enreg=informations about MPI parallelization
!!  natom=number of atoms in cell.
!!  nattyp(ntypat)= # atoms of each type.
!!  nband=number of bands for all k points
!!  nkpt=number of k points.
!!  nspden=number of spin-density components
!!  nsppol=1 for unpolarized, 2 for spin-polarized
!!  ntypat=number of types of atoms in unit cell.
!!  occ(mband*nkpt*nsppol)=occupation number for each band for each k
!!  pawprtvol=control print volume and debugging output for PAW
!!  unpaw=unit number for rhoij_nk data (if used)
!!  wtk(nkpt)=weight assigned to each k point
!!
!! SIDE EFFECTS
!!  pawrhoij(natom) <type(pawrhoij_type)>= paw rhoij occupancies and related data
!!  On input: arrays dimensions
!!  On output:
!!    pawrhoij(iatom)%rhoij_(lmn2_size,nspden)= paw rhoij quantities for each atom (non symetrized)
!!                     Rhoij = Sum_{n,k} {occ(n,k)*rhoij_nk}
!!
!! PARENTS
!!      vtorho
!!
!! CHILDREN
!!      leave_new,leave_test,pawgrhoij,print_ij,timab,wrtout,xcomm_init,xme_init,xsum_mpi
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

 subroutine pawmkrhoij(atindx1,cprjnk,dimcprj,eigen,istwfk,mband,mkmem,mpi_enreg,natom,nattyp,&
&                      nband,nkpt,nspden,nsppol,ntypat,occ,pawprtvol,pawrhoij,unpaw,wtk)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_11util
 use interfaces_13nonlocal
 use interfaces_lib01hidempi
#else
 use defs_xfuncmpi
#endif
!End of the abilint section

 implicit none

!Arguments ---------------------------------------------
!scalars
 integer,intent(in) :: mband,mkmem,natom,nkpt,nspden,nsppol
 integer,intent(in) :: ntypat,pawprtvol,unpaw
 type(MPI_type),intent(inout) :: mpi_enreg
!arrays
 integer,intent(in) :: atindx1(natom),dimcprj(natom),istwfk(nkpt)
 integer,intent(in) :: nattyp(ntypat),nband(nkpt*nsppol)
 real(dp),intent(in) :: eigen(mband*nkpt*nsppol),occ(mband*nkpt*nsppol),wtk(nkpt)
 type(cprj_type) :: cprjnk(natom,mband*mkmem*nsppol)
 type(pawrhoij_type),intent(inout) :: pawrhoij(natom)

!Local variables ---------------------------------------
!scalars
 integer :: bdtot_index,bufdim,cplex,iatm,iatom,ib,iband,ibg,ierr,ikpt
 integer :: ilmn,iplex,isppol,itypat,jdim,j0lmn,jlmn,klmn,me,natinc,natom0
 integer :: nband_k,nband0,spaceComm
 real(dp) :: eig_k,occ_k,rhoij_tmp,weight,wtk_k
 character(len=500) :: message
!arrays
 integer,allocatable :: dimlmn(:),idum(:)
 real(dp) :: tsec(2)
 real(dp),allocatable :: buffer1(:),buffer2(:)
 type(cprj_type),allocatable :: cprjnk_k(:,:)

!************************************************************************

 if(nspden==4) then
  write(message, '(a,a,a,a)' )ch10,&
&   ' pawmkrhoij : ERROR -',ch10,&
&   '  nspden 4 not allowed !'
  call wrtout(6,message,'PERS')
  call leave_new('PERS')
 end if

!Init mpi_comm
 call xcomm_init(mpi_enreg,spaceComm)
!BEGIN TF_CHANGES
!Define me
 call xme_init(mpi_enreg,me)
!END TF_CHANGES

!Initialize temporary file
 if (mkmem==0) then
  rewind unpaw;read(unpaw) natom0
  if (natom/=natom0) then
   write(message, '(a,a,a,a)' )ch10,&
&    ' pawmkrhoij : BUG -',ch10,&
&    '  _PAW file was not created with the right options !'
   call wrtout(6,message,'PERS')
   call leave_new('PERS')
  end if
  allocate(dimlmn(natom));read(unpaw) dimlmn(1:natom)
  do iatom=1,natom
   if (dimcprj(iatom)/=dimlmn(iatom)) then
    write(message, '(a,a,a,a)' )ch10,&
&     ' pawmkrhoij : BUG -',ch10,&
&     '  _PAW file was not created with the right options !'
    call wrtout(6,message,'PERS')
    call leave_new('PERS')
   end if
  end do
  deallocate(dimlmn)
 end if

!Initialize output quantities
 do iatom=1,natom;pawrhoij(iatom)%rhoij_=zero;end do

!LOOP OVER SPINS
 bdtot_index=0;ibg=0
 do isppol=1,nsppol

! LOOP OVER k POINTS
  do ikpt=1,nkpt

   nband_k=nband(ikpt+(isppol-1)*nkpt)
   wtk_k=wtk(ikpt)

   if(mpi_enreg%paral_compil_kpt==1)then
    if(minval(abs(mpi_enreg%proc_distrb(ikpt,1:nband_k,isppol)-me))/=0) then
     bdtot_index=bdtot_index+nband_k
     cycle
    end if
   end if

   cplex=2;if (istwfk(ikpt)>1) cplex=1

!  Extract Rhoij_nk quantities according to mkmem
   allocate(cprjnk_k(natom,nband_k))
   call cprj2_alloc(cprjnk_k,0,dimcprj)
   if (mkmem==0) then
    read(unpaw) nband0
    if (nband_k/=nband0) then
     write(message, '(a,a,a,a)' )ch10,&
&      ' pawmkrhoij : BUG -',ch10,&
&      '  _PAW file was not created with the right options !'
     call wrtout(6,message,'PERS')
     call leave_new('PERS')
    end if
    do iband=1,nband_k;do iatom=1,natom
     read(unpaw) cprjnk_k(iatom,iband)%cp(:,:)
    end do;end do
   else
    do iband=1,nband_k;do iatom=1,natom
     cprjnk_k(iatom,iband)%cp(:,:)=cprjnk(iatom,iband+ibg)%cp(:,:)
    end do;end do
   end if

!  LOOP OVER BANDS
   do ib=1,nband_k
    iband=bdtot_index+ib

    if(mpi_enreg%paral_compil_kpt==1)then
     if (mpi_enreg%proc_distrb(ikpt,ib,isppol)/= me) cycle
    end if

!   Select occupied bands
    if (abs(occ(iband))>tol8) then
     eig_k=eigen(iband);occ_k=occ(iband)
     weight=wtk_k*occ_k

!    Accumulate (n,k) contribution to rhoij
     if (nspden==2.and.nsppol==1) weight=half*weight
     do iatm=1,natom
      iatom=atindx1(iatm)
      do jlmn=1,pawrhoij(iatom)%lmn_size
       j0lmn=jlmn*(jlmn-1)/2
       do ilmn=1,jlmn
        klmn=j0lmn+ilmn
        rhoij_tmp=zero
        do iplex=1,cplex
         rhoij_tmp=rhoij_tmp+cprjnk_k(iatm,ib)%cp(iplex,ilmn)*cprjnk_k(iatm,ib)%cp(iplex,jlmn)
        end do
        pawrhoij(iatom)%rhoij_(klmn,isppol)=pawrhoij(iatom)%rhoij_(klmn,isppol)+weight*rhoij_tmp
       end do
      end do
     end do

!END LOOPS
    end if ! abs(occ)>tol8
   end do ! ib
   bdtot_index=bdtot_index+nband_k
   if (mkmem/=0) ibg=ibg+nband_k
   call cprj2_free(cprjnk_k)
   deallocate(cprjnk_k)
  end do !f ikpt
 end do ! isppol

!MPI: need to exchange arrays between procs
!==========================================
 if(mpi_enreg%paral_compil_kpt==1)then
  call timab(66,1,tsec)
  if (mpi_enreg%parareel == 0) then
!BEGIN TF_CHANGES
  call leave_test(mpi_enreg)
!END TF_CHANGES
  end if
  call timab(66,2,tsec)
  call timab(48,1,tsec)

! Exchange rhoij_
  allocate(dimlmn(natom))
  dimlmn(1:natom)=pawrhoij(1:natom)%lmn2_size
  bufdim=sum(dimlmn)*nsppol
  allocate(buffer1(bufdim),buffer2(bufdim))
  jdim=0
  do iatom=1,natom
   do isppol=1,nsppol
    buffer1(jdim+1:jdim+dimlmn(iatom))=pawrhoij(iatom)%rhoij_(:,isppol)
    jdim=jdim+dimlmn(iatom)
   end do
  end do
  call xsum_mpi(buffer1,buffer2,bufdim,spaceComm,ierr) !Build sum of everything
  jdim=0
  do iatom=1,natom
   do isppol=1,nsppol
    pawrhoij(iatom)%rhoij_(:,isppol)=buffer2(jdim+1:jdim+dimlmn(iatom))
    jdim=jdim+dimlmn(iatom)
   end do
  end do
  deallocate(buffer1,buffer2,dimlmn)
  call timab(48,2,tsec)
 end if ! mpi_enreg%paral_compil_kpt==1

!Print info
 if (pawprtvol>=1) then
  natinc=1;if(natom>1) natinc=natom-1
  do iatom=1,natom,natinc
   write(message, '(4a,i3,a)') ch10," PAW TEST:",ch10,&
&    ' ====== Values of RHOIJ in pawmkrhoij (iatom=',iatom,') ======'
   if (nspden==2.and.nsppol==1) write(message,'(3a)') trim(message),ch10,&
&    '      (antiferromagnetism case: only one spin component)'
   call wrtout(6,message,'COLL')
   do isppol=1,nsppol
    write(message, '(a,i1,a)') '   Density component= ',isppol,':'
    call wrtout(6,message,'COLL')
    call print_ij(pawrhoij(iatom)%rhoij_(:,isppol),pawrhoij(iatom)%lmn2_size,&
 &                pawrhoij(iatom)%lmn_size,1,-1,idum,0,idum,-1.d0,1)
   end do
  end do
 end if

end subroutine pawmkrhoij
!!***
