/*
    ACfax - Fax reception with X11-interface for amateur radio
    Copyright (C) 1995-1998 Andreas Czechanowski, DL4SDC

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

    andreas.czechanowski@ins.uni-stuttgart.de
*/
    
/*
 * sblaster.h - header file for sblaster.c, that handles the dsp-interface
 *		for Linux.
 */

#define DSPDEV "/dev/dsp"
#define MIXDEV "/dev/mixer"

/* adjust the values below to your SoundBlaster to obtain fax-pictures
   without azimut-errors. Adjustment can also be done in the program, and
   you can enter the calculated frequency here. Accuracy should be about
   +/- 0.01 Hz
*/
#define FM_SMPLF 4000.976
#define AM_SMPLF 4801.109

void interface_init(char **, int*);
void interface_stop(void);
void setup_mode(int, int, int, unsigned *);
void do_receive(void);
void do_transmit(void);
int signal_level(void);
void tune_frequency(unsigned);

extern int dspfd;	/* file descriptor of /dev/dsp, used for select() */
extern int rx_level;	/* audio frequency input level, from 0 to 255 */
