; Copyright (C) 2013, Regents of the University of Texas
; Written by Matt Kaufmann, August, 2013
; License: A 3-clause BSD license.  See the LICENSE file distributed with ACL2.

; See make-event-keywords-or-exp.lisp.  We check here that the expansions are
; stored as expected.

(in-package "ACL2")

(include-book "make-event-keywords-or-exp") ; establishes dependency

(make-event
 (er-let* ((forms (read-file "make-event-keywords-or-exp.cert" state)))
   (cond
    ((equal
      (cadr (member-eq :expansion-alist forms))
      '((7 RECORD-EXPANSION
           (DEFUN-MEASURES F1 (X0 X1 X2 X3)
             (IF (CONSP X0)
                 (IF (CONSP X1)
                     (IF (CONSP X2)
                         (IF (CONSP X3)
                             (F1 (CONS X0 X0)
                                 (CONS X1 X1)
                                 (CDR X2)
                                 (CDR X3))
                             X3)
                         X2)
                     X1)
                 X0))
           (DEFUN F1 (X0 X1 X2 X3)
             (DECLARE (XARGS :MEASURE (ACL2-COUNT X2)))
             (IF (CONSP X0)
                 (IF (CONSP X1)
                     (IF (CONSP X2)
                         (IF (CONSP X3)
                             (F1 (CONS X0 X0)
                                 (CONS X1 X1)
                                 (CDR X2)
                                 (CDR X3))
                             X3)
                         X2)
                     X1)
                 X0)))
        (8
         RECORD-EXPANSION
         (DEFUN-MEASURES-CHECK F1C (X0 X1 X2 X3)
           (IF (CONSP X0)
               (IF (CONSP X1)
                   (IF (CONSP X2)
                       (IF (CONSP X3)
                           (F1C (CONS X0 X0)
                                (CONS X1 X1)
                                (CDR X2)
                                (CDR X3))
                           X3)
                       X2)
                   X1)
               X0))
         (MAKE-EVENT
          '(:OR (:DO-PROOFS (DEFUN F1C (X0 X1 X2 X3)
                              (DECLARE (XARGS :MEASURE (ACL2-COUNT X0)))
                              (IF (CONSP X0)
                                  (IF (CONSP X1)
                                      (IF (CONSP X2)
                                          (IF (CONSP X3)
                                              (F1C (CONS X0 X0)
                                                   (CONS X1 X1)
                                                   (CDR X2)
                                                   (CDR X3))
                                              X3)
                                          X2)
                                      X1)
                                  X0)))
                (:DO-PROOFS (DEFUN F1C (X0 X1 X2 X3)
                              (DECLARE (XARGS :MEASURE (ACL2-COUNT X1)))
                              (IF (CONSP X0)
                                  (IF (CONSP X1)
                                      (IF (CONSP X2)
                                          (IF (CONSP X3)
                                              (F1C (CONS X0 X0)
                                                   (CONS X1 X1)
                                                   (CDR X2)
                                                   (CDR X3))
                                              X3)
                                          X2)
                                      X1)
                                  X0)))
                (:DO-PROOFS (DEFUN F1C (X0 X1 X2 X3)
                              (DECLARE (XARGS :MEASURE (ACL2-COUNT X2)))
                              (IF (CONSP X0)
                                  (IF (CONSP X1)
                                      (IF (CONSP X2)
                                          (IF (CONSP X3)
                                              (F1C (CONS X0 X0)
                                                   (CONS X1 X1)
                                                   (CDR X2)
                                                   (CDR X3))
                                              X3)
                                          X2)
                                      X1)
                                  X0)))
                (:DO-PROOFS (DEFUN F1C (X0 X1 X2 X3)
                              (DECLARE (XARGS :MEASURE (ACL2-COUNT X3)))
                              (IF (CONSP X0)
                                  (IF (CONSP X1)
                                      (IF (CONSP X2)
                                          (IF (CONSP X3)
                                              (F1C (CONS X0 X0)
                                                   (CONS X1 X1)
                                                   (CDR X2)
                                                   (CDR X3))
                                              X3)
                                          X2)
                                      X1)
                                  X0))))
          :CHECK-EXPANSION (DEFUN F1C (X0 X1 X2 X3)
                             (DECLARE (XARGS :MEASURE (ACL2-COUNT X2)))
                             (IF (CONSP X0)
                                 (IF (CONSP X1)
                                     (IF (CONSP X2)
                                         (IF (CONSP X3)
                                             (F1C (CONS X0 X0)
                                                  (CONS X1 X1)
                                                  (CDR X2)
                                                  (CDR X3))
                                             X3)
                                         X2)
                                     X1)
                                 X0))))
        (16 RECORD-EXPANSION (VERIFY-GUARDS+ M1)
            (VERIFY-GUARDS G1))
        (19 RECORD-EXPANSION
            (MAKE-EVENT (ER-PROGN (ASSIGN MAKE-EVENT-DEBUG T)
                                  (VALUE '(VALUE-TRIPLE NIL))))
            (VALUE-TRIPLE NIL))
        (20 RECORD-EXPANSION
            (MAKE-EVENT '(:OR (LOCAL (DEFUN FOO1 (X) X))
                              (DEFUN NOOP (X) X)))
            (LOCAL (VALUE-TRIPLE :ELIDED)))
        (21 RECORD-EXPANSION
            (MAKE-EVENT
             (ER-PROGN (VALUE (CW "Here I'm computing with state...~%"))
                       (VALUE '(MAKE-EVENT '(:OR (LOCAL (DEFUN FOO2 (X) X))
                                                 (DEFUN NOOP (X) X)))))
             :EXPANSION? (DEFUN FOO2 (X) X))
            (LOCAL (VALUE-TRIPLE :ELIDED)))
        (22 RECORD-EXPANSION
            (MAKE-EVENT
             (ER-PROGN (VALUE (CW "Here I'm computing with state...~%"))
                       (VALUE '(MAKE-EVENT '(:OR (LOCAL (DEFUN FOO3 (X) X))
                                                 (DEFUN NOOP (X) X))
                                           :EXPANSION? (DEFUN FOO3 (X) X))))
             :EXPANSION? (DEFUN FOO3 (X) X))
            (LOCAL (VALUE-TRIPLE :ELIDED)))
        (26 RECORD-EXPANSION
            (MAKE-EVENT '(:OR (DEFUN FOO7 (X) X)
                              (DEFUN NOOP (X) X))
                        :EXPANSION? (DEFUN WRONG (X) X)
                        :CHECK-EXPANSION T)
            (MAKE-EVENT '(:OR (DEFUN FOO7 (X) X)
                              (DEFUN NOOP (X) X))
                        :CHECK-EXPANSION (DEFUN FOO7 (X) X)))
        (28 RECORD-EXPANSION
            (MAKE-EVENT '(LOCAL (DEFUN FOO8 (X) X))
                        :EXPANSION? (DEFUN WRONG (X) X)
                        :CHECK-EXPANSION T)
            (MAKE-EVENT '(LOCAL (DEFUN FOO8 (X) X))
                        :CHECK-EXPANSION (LOCAL (DEFUN FOO8 (X) X))))
        (29 RECORD-EXPANSION
            (MAKE-EVENT '(LOCAL (DEFUN FOO8 (X) X))
                        :EXPANSION? NIL
                        :CHECK-EXPANSION T)
            (MAKE-EVENT '(LOCAL (DEFUN FOO8 (X) X))
                        :CHECK-EXPANSION (LOCAL (DEFUN FOO8 (X) X))))))
          (value '(value-triple nil)))
         (t (er soft 'top
                "Unexpected form in make-event-keywords-or-exp.cert!")))))
