# Catalan and Italian: apertium-cat-ita

This is an Apertium language pair for translating between Italian to
Catalan. What you can use this language package for:

* Translating between Catalan and Italian
* Morphological analysis of Catalan and Italian
* Part-of-speech tagging of Catalan and Italian

For information on the latter two points, see subheading "For more 
information" below

## Requirements

You will need the following software installed:

* lttoolbox (>= 3.3.0)
* apertium (>= 3.3.0)
* vislcg3 (>= 0.9.9.10297)
* apertium-cat
* apertium-ita

If this does not make any sense, we recommend you look at: www.apertium.org

## Compiling

Given the requirements being installed, you should be able to just run:

    $ ./configure 
    $ make
    # make install

You can use `./autogen.sh` instead of `./configure` you're compiling from
SVN. If you installed any prerequisite language packages using a `--prefix`
to `./configure`, make sure to give the same `--prefix` to `./configure` here.

## Testing

If you are in the source directory after running make, the following
commands should work:

    $  echo "Apertium è una piattaforma di traduzione automatica libera e aperta." | apertium -d . ita-cat
    Apertium és una plataforma de traducció automàtica lliure i oberta.

    $  echo "Apertium és una plataforma de traducció automàtica lliure i oberta." | apertium -d . cat-ita
    Apertium è una piattaforma di traduzione automatica libera e aperta.

After installing somewhere in $PATH, you should be able to do eg.

    $ echo "Apertium è una piattaforma di traduzione automatica libera e aperta." | apertium ita-cat
    Apertium és una plataforma de traducció automàtica lliure i oberta.

    $  echo "Apertium és una plataforma de traducció automàtica lliure i oberta." | apertium cat-ita
    Apertium è una piattaforma di traduzione automatica libera e aperta.

The following command runs tests which are on the Apertium wiki page:

    $ ./pending-tests.sh 

## Files and data

* apertium-cat-ita.cat-ita.dix  - Bilingual dictionary
* apertium-cat-ita.cat-ita.t1x  - Chunking rules for translating into Italian
* apertium-cat-ita.ita-cat.t1x  - Chunking rules for translating into Catalan
* apertium-cat-ita.cat-ita.t2x  - Interchunk rules for translating into Italian
* apertium-cat-ita.ita-cat.t2x  - Interchunk rules for translating into Catalan
* apertium-cat-ita.cat-ita.t3x  - Postchunk rules for translating into Italian
* apertium-cat-ita.ita-cat.t3x  - Postchunk rules for translating into Catalan
* apertium-cat-ita.cat-ita.metalrx  - Lexical selection rules for translating into Italian
* apertium-cat-ita.ita-cat.metalrx  - Lexical selection rules for translating into Catalan
* modes.xml                     - Translation modes

## For more information

* http://wiki.apertium.org/wiki/Installation
* http://wiki.apertium.org/wiki/apertium-ca-it
* http://wiki.apertium.org/wiki/Using_an_lttoolbox_dictionary

## Help and support

If you need help using this language pair or data, you can contact:

* Mailing list: apertium-stuff@lists.sourceforge.net
* IRC: #apertium on irc.freenode.net

See also the file AUTHORS included in this distribution.

## Publications 

Antonio Toral, Mireia Ginestí-Rosell, Francis Tyers (2011) "An Italian to 
  Catalan RBMT system reusing data from existing language pairs". Second 
  International Workshop on Free/Open-Source Rule-Based Machine 
  Translation (Barcelona)
