// Last update: timvdm 19 June 2009
#include <boost/python.hpp>

#include <avogadro/meshgenerator.h>
#include <avogadro/mesh.h>
#include <avogadro/cube.h>

using namespace boost::python;
using namespace Avogadro;

// handle default argument
bool initialize(MeshGenerator &self, const Cube *cube, Mesh *mesh, float iso)
{
  return self.initialize(cube, mesh, iso);
}

void export_MeshGenerator()
{
  
  class_<Avogadro::MeshGenerator, boost::noncopyable>("MeshGenerator")
    // constructors
    .def(init<QObject*>())
    .def(init<const Cube*, Mesh*, float>())
    .def(init<const Cube*, Mesh*, float, bool>())
    .def(init<const Cube*, Mesh*, float, QObject*>())
    
    //
    // read-only poperties 
    //
    .add_property("cube", 
        make_function(&MeshGenerator::cube, return_value_policy<reference_existing_object>()),
        "The Cube being used by the class.")

    .add_property("mesh", 
        make_function(&MeshGenerator::mesh, return_value_policy<reference_existing_object>()),
        "The Mesh being generated by the class.")

    //
    // real functions
    //
    .def("initialize", 
        &MeshGenerator::initialize,
        "Initialization function, set up the MeshGenerator ready to find an "
        "isosurface of the supplied Cube.")
    .def("initialize", 
        &initialize,
        "Initialization function, set up the MeshGenerator ready to find an "
        "isosurface of the supplied Cube.")

    .def("run", 
        &MeshGenerator::run,
        "Use this function to begin Mesh generation. Uses an asynchronous thread, "
        "and so avoids locking the user interface while the isosurface is found.")

    .def("clear", 
        &MeshGenerator::clear,
        "Clears the contents of the MeshGenerator.")
    ;
   
}
